/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.init.AzureSamlRequestFilter;
import com.viztrend.safe.init.ClientResources;
import com.viztrend.safe.init.CustomAuthenticationFailureHandler;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.init.CustomAuthenticationSuccessHandler;
import com.viztrend.safe.init.OktaOauth2Filter;
import com.viztrend.safe.init.OktaSamlRequestFilter;
import com.viztrend.safe.init.TFSOauth2ADFilter2;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.Oauth2ConfigRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.UserService;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.web.filter.CompositeFilter;

@Configuration
@EnableOAuth2Client
public class WebSecurityConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    @Autowired
    UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private SessionRegistry sessionRegistry;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    OAuth2ClientContext oauth2ClientContext;
    @Autowired
    CustomAuthenticationSuccessHandler customAuthenticationSuccessHandler;
    @Autowired
    CustomAuthenticationFailureHandler customAuthenticationFailureHandler;
    @Autowired
    CustomAuthenticationProvider customAuthenticationProvider;
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    PersistentTokenRepository tokenRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private Environment env;
    @Autowired
    private Oauth2ConfigRepository oauth2ConfigRepository;
    @Autowired
    private SAMLConfigRepository samlConfigRepository;
    @Autowired
    private UserService userService;
    private String sessionId = "JSESSIONID";
    protected static String lockedAccountMsg = "Your account has been locked, Please contact your administrator.";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSecurityConfiguration.class);

    public void init(AuthenticationManagerBuilder auth) throws Exception {
        if (!"true".equals(System.getenv("plainpass"))) {
            auth.userDetailsService(this.userDetailsService()).passwordEncoder(this.passwordEncoder());
        } else {
            auth.userDetailsService(this.userDetailsService());
        }
        auth.authenticationProvider((AuthenticationProvider)this.customAuthenticationProvider);
        auth.authenticationProvider((AuthenticationProvider)this.authProvider());
    }

    @Bean
    UserDetailsService userDetailsService() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public DaoAuthenticationProvider authProvider() {
        DaoAuthenticationProvider authProvider = new DaoAuthenticationProvider();
        authProvider.setUserDetailsService(this.userDetailsService());
        authProvider.setPasswordEncoder((Object)this.passwordEncoder());
        return authProvider;
    }

    @Bean
    CookieSerializer cookieSerializer() {
        int DEFAULT_MAX_AGE = 172800;
        String COOKIE_NAME = this.sessionId;
        boolean PROD = "prod".equals(this.env.getProperty("app.env"));
        String DOMAIN = PROD ? this.env.getProperty("server.domain") : null;
        boolean SECURE = PROD;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public PrincipalExtractor getPrincipalExtractor() {
        return map -> {
            String oauthId = (String)map.get("email");
            HashMap infoMap = new HashMap();
            infoMap.put("name", map.get("name"));
            infoMap.put("email", map.get("email"));
            SecureUser secureUser = this.customAuthenticationProvider.getUserContext(oauthId);
            if (secureUser == null) {
                secureUser = new SecureUser(oauthId, "");
            }
            secureUser.setOauthInfoMap(infoMap);
            return secureUser;
        };
    }

    @Bean
    public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(-100);
        return registration;
    }

    @Bean
    public ClientResources okta() {
        return new ClientResources();
    }

    @Bean
    public ClientResources google() {
        return new ClientResources();
    }

    private Filter ssoFilter() {
        CompositeFilter filter = new CompositeFilter();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(this.ssoFilterGoogle(this.google(), "/login/google"));
        filters.add(this.samlFilterAzure(this.okta(), "/login/saml/**"));
        filters.add(this.samlFilterAzure(this.okta(), "/logout/saml/**"));
        filter.setFilters(filters);
        return filter;
    }

    private Filter ssoFilterGoogle(ClientResources client, String path) {
        OAuth2ClientAuthenticationProcessingFilter oAuth2ClientAuthenticationFilter = new OAuth2ClientAuthenticationProcessingFilter(path);
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)client.getGoogleClient(), this.oauth2ClientContext);
        oAuth2ClientAuthenticationFilter.setRestTemplate((OAuth2RestOperations)oAuth2RestTemplate);
        UserInfoTokenServices tokenServices = new UserInfoTokenServices(client.getGoogleResource().getUserInfoUri(), client.getGoogleClient().getClientId());
        tokenServices.setRestTemplate((OAuth2RestOperations)oAuth2RestTemplate);
        tokenServices.setPrincipalExtractor(this.getPrincipalExtractor());
        oAuth2ClientAuthenticationFilter.setTokenServices((ResourceServerTokenServices)tokenServices);
        oAuth2ClientAuthenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler);
        oAuth2ClientAuthenticationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler);
        return oAuth2ClientAuthenticationFilter;
    }

    private Filter ssoFilterOkta(ClientResources client, String path) {
        OktaOauth2Filter oktaOauth2Filter = new OktaOauth2Filter(path, this.customAuthenticationProvider);
        oktaOauth2Filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler);
        oktaOauth2Filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler);
        oktaOauth2Filter.setUserRepository(this.userRepository);
        oktaOauth2Filter.setOauth2ConfigRepository(this.oauth2ConfigRepository);
        return oktaOauth2Filter;
    }

    private Filter samlFilterOkta(ClientResources client, String path) {
        OktaSamlRequestFilter oktaSamlRequestFilter = new OktaSamlRequestFilter(path, this.customAuthenticationProvider, this.samlConfigRepository);
        oktaSamlRequestFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler);
        oktaSamlRequestFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler);
        oktaSamlRequestFilter.setUserRepository(this.userRepository);
        oktaSamlRequestFilter.setSamlConfigRepository(this.samlConfigRepository);
        oktaSamlRequestFilter.setCompanyRepository(this.companyRepository);
        return oktaSamlRequestFilter;
    }

    private Filter samlFilterAzure(ClientResources client, String path) {
        AzureSamlRequestFilter azureSamlRequestFilter = new AzureSamlRequestFilter(path, this.customAuthenticationProvider, this.samlConfigRepository, this.env);
        azureSamlRequestFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler);
        azureSamlRequestFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler);
        azureSamlRequestFilter.setUserRepository(this.userRepository);
        azureSamlRequestFilter.setSamlConfigRepository(this.samlConfigRepository);
        azureSamlRequestFilter.setCompanyRepository(this.companyRepository);
        azureSamlRequestFilter.setGroupRepository(this.groupRepository);
        azureSamlRequestFilter.setInvitationRepository(this.invitationRepository);
        azureSamlRequestFilter.setMongoConfig(this.mongoConfig);
        azureSamlRequestFilter.setUserService(this.userService);
        azureSamlRequestFilter.setTokenRepository(this.tokenRepository);
        return azureSamlRequestFilter;
    }

    private Filter ssoFilterTfs(String path) {
        TFSOauth2ADFilter2 tFSOauth2Filter = new TFSOauth2ADFilter2(path, this.customAuthenticationProvider);
        TFSOauth2ADFilter2.setClientId((String)this.env.getProperty("tfs.client-id"));
        TFSOauth2ADFilter2.setClientSec((String)this.env.getProperty("tfs.client-secret"));
        TFSOauth2ADFilter2.setRedirectUrl((String)this.env.getProperty("tfs.redirectUrl"));
        tFSOauth2Filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler);
        tFSOauth2Filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.customAuthenticationFailureHandler);
        tFSOauth2Filter.setUserRepository(this.userRepository);
        return tFSOauth2Filter;
    }

    static /* synthetic */ Filter access$000(WebSecurityConfiguration x0) {
        return x0.ssoFilter();
    }

    static /* synthetic */ Environment access$100(WebSecurityConfiguration x0) {
        return x0.env;
    }

    static /* synthetic */ String access$200(WebSecurityConfiguration x0) {
        return x0.sessionId;
    }

    static /* synthetic */ SessionRegistry access$300(WebSecurityConfiguration x0) {
        return x0.sessionRegistry;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }
}

