/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.viztrend.safe.config.interceptor.PublicPathInterceptor;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.UserService;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
class WebMvcConfig
extends WebMvcConfigurerAdapter
implements EmbeddedServletContainerCustomizer {
    private static final Pattern PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String[] excludedUri = new String[]{"/mfa", "/postcode", "/admin/postreccode", "/mfaactivation", "/admin/generateRecoveryCode", "/admin/enableMFA", "/accounts"};
    @Autowired
    private Environment env;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private APIService apiService;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private SAMLConfigRepository sAMLConfigRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebMvcConfig.class);
    @Autowired
    private UserService userService;

    WebMvcConfig() {
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new /* Unavailable Anonymous Inner Class!! */);
        registry.addInterceptor((HandlerInterceptor)new PublicPathInterceptor(this.serverCacheRepository, this.apiService, this.mongoTemplate, this.userRepository, this.userService));
    }

    public void customize(ConfigurableEmbeddedServletContainer container) {
    }

    static /* synthetic */ String[] access$000() {
        return excludedUri;
    }

    static /* synthetic */ Environment access$100(WebMvcConfig x0) {
        return x0.env;
    }

    static /* synthetic */ Pattern access$200() {
        return PATTERN;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ UserRepository access$400(WebMvcConfig x0) {
        return x0.userRepository;
    }

    static /* synthetic */ CompanyRepository access$500(WebMvcConfig x0) {
        return x0.companyRepository;
    }

    static /* synthetic */ SAMLConfigRepository access$600(WebMvcConfig x0) {
        return x0.sAMLConfigRepository;
    }
}

