/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.web.util.UriComponentsBuilder;

public class ReturnToLoginEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnToLoginEntryPoint.class);

    public ReturnToLoginEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        LOGGER.debug("Request URL is:{}", (Object)request.getRequestURL());
        LOGGER.debug("Request scheme is :{}", (Object)request.getScheme());
        String current = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build().toUriString();
        LOGGER.debug("Current URL is:{}", (Object)current);
        String login = this.buildRedirectUrlToLoginPage(request, response, authException);
        String sep = login.contains("?") ? "&" : "?";
        String redirectURL = login + sep + "returnTo=" + URLEncoder.encode(current, StandardCharsets.UTF_8.name());
        LOGGER.debug("Redirecting to URL :{}", (Object)redirectURL);
        response.sendRedirect(redirectURL);
    }
}

