/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import com.okta.controller.DeepLinkServlet;
import com.okta.saml.Application;
import com.okta.saml.Configuration;
import com.okta.saml.SAMLResponse;
import com.okta.saml.SAMLValidator;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.ws.security.SecurityPolicyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * Exception performing whole class analysis ignored.
 */
public class OktaSamlRequestFilter
extends AbstractAuthenticationProcessingFilter {
    protected static final String SAML_REQUEST = "SAMLRequest";
    protected static final String SAML_RESPONSE = "SAMLResponse";
    protected static final String RELAY_STATE = "RelayState";
    private static final Logger LOGGER = LoggerFactory.getLogger(OktaSamlRequestFilter.class);
    protected SAMLValidator validator;
    private CustomAuthenticationProvider customAuthenticationProvider;
    private UserRepository userRepository;
    private SAMLConfigRepository samlConfigRepository;
    private String file;
    private CompanyRepository companyRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OktaSamlRequestFilter(String path, CustomAuthenticationProvider customAuthenticationProvider, SAMLConfigRepository samlConfigRepository) {
        super(path);
        this.customAuthenticationProvider = customAuthenticationProvider;
        this.samlConfigRepository = samlConfigRepository;
        try {
            try (InputStream stream = Application.class.getResourceAsStream("/valid-config.xml");){
                this.file = OktaSamlRequestFilter.convertStreamToString((InputStream)stream);
            }
            this.validator = new SAMLValidator();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    protected OktaSamlRequestFilter(RequestMatcher requiresAuthenticationRequestMatcher) {
        super(requiresAuthenticationRequestMatcher);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        Company company = null;
        ImmutableList parts = InternetDomainName.from((String)request.getServerName()).parts();
        String subDomain = null;
        Application app = null;
        Configuration configuration = null;
        LOGGER.debug("parts ---- " + parts);
        if (parts.size() > 1) {
            subDomain = (String)parts.get(0);
            LOGGER.debug("subdomain to fetch company ---- :" + subDomain + ":");
            company = this.companyRepository.findByUrlPrefix(subDomain);
        } else {
            company = (Company)this.companyRepository.findAll().get(0);
        }
        if (company == null) {
            PrintWriter writer = response.getWriter();
            response.setHeader("Content-Type", "text/html");
            writer.write("<html><body>No SAML configuration found.</body></html>");
            return null;
        }
        String replaceFile = this.file;
        SAMLConfig config = this.samlConfigRepository.findByTenant(company.getTenant());
        System.out.print("inside get method ...... ");
        System.out.print("config is  ...... " + config);
        if (config == null) {
            PrintWriter writer = response.getWriter();
            response.setHeader("Content-Type", "text/html");
            writer.write("<html><body>No SAML configuration found.</body></html>");
            return null;
        }
        this.logger.debug((Object)("SAML Config :" + config));
        if (!PropertyValidator.isValid((Object)config)) {
            return null;
        }
        replaceFile = replaceFile.replaceAll("identity_provider_issuer", config.getIdentityProviderIssuer());
        replaceFile = replaceFile.replaceAll("xcertificate", config.getXcertificate());
        replaceFile = replaceFile.replaceAll("identity_provider_single_sign", config.getIdentityProviderSingleSign());
        this.logger.debug((Object)("SAML Config after replace :" + replaceFile));
        try {
            this.logger.debug((Object)("Before getting configuration :" + replaceFile));
            configuration = this.validator.getConfiguration(replaceFile);
        }
        catch (SecurityPolicyException e) {
            throw new RuntimeException(e);
        }
        app = configuration.getDefaultApplication();
        if (configuration.getDefaultEntityID() == null) {
            LOGGER.error("Default application has not been configured in configuration.");
        } else if (app == null) {
            LOGGER.error("Could not find default application in configuration: " + configuration.getDefaultEntityID());
        }
        if (request.getMethod().equals("POST")) {
            SAMLResponse samlResponse = this.doPost(request, response, configuration);
            LOGGER.debug("saml response ------- :" + samlResponse);
            System.out.print("saml response :" + samlResponse);
            if (samlResponse == null) {
                PrintWriter writer = response.getWriter();
                response.setHeader("Content-Type", "text/html");
                writer.write("<html><body>Invalid SAML configuration.</body></html>");
                return null;
            }
            String email = samlResponse.getUserID();
            String firstName = null;
            String lastName = null;
            firstName = PropertyValidator.isValid((Collection)((Collection)samlResponse.getAttributes().get("firstName"))) ? String.valueOf(((List)samlResponse.getAttributes().get("firstName")).get(0)) : "unknow";
            lastName = PropertyValidator.isValid((Collection)((Collection)samlResponse.getAttributes().get("lastName"))) ? String.valueOf(((List)samlResponse.getAttributes().get("lastName")).get(0)) : "unknow";
            if (email != null) {
                User dbUserOld = this.userRepository.findByUserNameIgnoreCase(email);
                if (company.getPaymentDetails() != null) {
                    Long usersCount = this.userRepository.countByTenantAndArchiveFalse(company.getTenant());
                    Long pkgUsersCount = company.getUserCount();
                    if (pkgUsersCount < usersCount) {
                        response.sendRedirect("/userslimit");
                        return null;
                    }
                }
                if (dbUserOld == null) {
                    User dbUser = new User();
                    dbUser.setTenant(company.getTenant());
                    dbUser.setUserName(email.toLowerCase());
                    dbUser.setFullName(org.apache.commons.lang3.StringUtils.defaultString((String)firstName) + " " + org.apache.commons.lang3.StringUtils.defaultString((String)lastName));
                    dbUser.setFirstName(firstName);
                    dbUser.setLastName(lastName);
                    dbUser.setPassword("okta-auth");
                    dbUser.setLdap(false);
                    dbUser.setOkta(true);
                    dbUser.setEmail(email);
                    UserCompany uc = new UserCompany();
                    uc.setCompany(company);
                    dbUser.setUserCompanies(new ArrayList());
                    dbUser.getUserCompanies().add(uc);
                    dbUser = (User)this.userRepository.save((Object)dbUser);
                }
                LdapUser ldapUser = new LdapUser();
                if (PropertyValidator.isValid((Collection)((Collection)samlResponse.getAttributes().get("groups")))) {
                    ldapUser.setGroups(new ArrayList((Collection)samlResponse.getAttributes().get("groups")));
                }
                SecureUser secureUser = this.customAuthenticationProvider.getUserContext(email);
                ldapUser.setProvider("okta");
                secureUser.getUserContextDTO().getContextMap().put("ldapUser", ldapUser);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)"", secureUser.getAuthorities());
                return usernamePasswordAuthenticationToken;
            }
        } else {
            this.doGet(request, response, app);
        }
        return null;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response, Application app) throws ServletException, IOException {
        try {
            Object samlRequest = null;
            String encodedSaml = Base64.encodeBase64String((byte[])samlRequest.toString().getBytes());
            String url = app.getAuthenticationURL();
            url = url + "?SAMLRequest=" + URLEncoder.encode(encodedSaml, "UTF-8");
            response.sendRedirect(url);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.setStatus(500);
        }
    }

    protected SAMLResponse doPost(HttpServletRequest request, HttpServletResponse response, Configuration configuration) throws ServletException, IOException {
        try {
            String relay = request.getParameter("RelayState");
            LOGGER.debug("relay value is:" + relay);
            if (relay != null && !relay.isEmpty()) {
                DeepLinkServlet deepLinkServlet = new DeepLinkServlet();
                deepLinkServlet.doPost(request, response);
                LOGGER.debug("returing null from do post:" + relay);
                return null;
            }
            String assertion = request.getParameter("SAMLResponse");
            if (assertion == null) {
                throw new Exception("SAMLResponse parameter missing");
            }
            assertion = new String(Base64.decodeBase64((byte[])assertion.getBytes("UTF-8")), Charset.forName("UTF-8"));
            LOGGER.debug("configuration is :" + configuration);
            LOGGER.debug("assertion is :" + assertion);
            if (configuration == null) {
                response.sendRedirect("/login/oktasaml");
            }
            SAMLResponse samlResponse = this.validator.getSAMLResponse(assertion, configuration);
            this.logger.debug((Object)"SAML authentication successful");
            this.logger.debug((Object)("LoggedIn USer :" + request.getAttribute("user")));
            return samlResponse;
        }
        catch (SecurityPolicyException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            this.logger.debug((Object)"SAML authentication unsuccessful");
            response.setStatus(401);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            response.setStatus(500);
        }
        return null;
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public CustomAuthenticationProvider getCustomAuthenticationProvider() {
        return this.customAuthenticationProvider;
    }

    public void setCustomAuthenticationProvider(CustomAuthenticationProvider customAuthenticationProvider) {
        this.customAuthenticationProvider = customAuthenticationProvider;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public SAMLConfigRepository getSamlConfigRepository() {
        return this.samlConfigRepository;
    }

    public void setSamlConfigRepository(SAMLConfigRepository samlConfigRepository) {
        this.samlConfigRepository = samlConfigRepository;
    }

    public CompanyRepository getCompanyRepository() {
        return this.companyRepository;
    }

    public void setCompanyRepository(CompanyRepository companyRepository) {
        this.companyRepository = companyRepository;
    }
}

