/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.init.CustomAuthenticationProvider;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

/*
 * Exception performing whole class analysis ignored.
 */
public class JiraOAuth2Filter
extends AbstractAuthenticationProcessingFilter {
    private CustomAuthenticationProvider customAuthenticationProvider;
    private static Gson gson = new GsonBuilder().create();
    private static CloseableHttpClient httpclient;
    private static PoolingHttpClientConnectionManager connManager;
    private static final Logger LOGGER;
    private UserRepository userRepository;
    private static String tokenUrl;
    private static String authUrl;
    private static String clientId;
    private static String clientSec;
    private static String redirectUrl;

    public JiraOAuth2Filter(String path, CustomAuthenticationProvider customAuthenticationProvider) {
        super(path);
        this.customAuthenticationProvider = customAuthenticationProvider;
    }

    public static void main(String[] args) {
        try {
            for (int i = 0; i < 100; ++i) {
                HttpGet get = new HttpGet("https://google.com/" + i);
                get.addHeader("Authorization", "access-token");
                get.addHeader("Content-type", "application/json-patch+json");
                CloseableHttpResponse httpresponse = httpclient.execute((HttpUriRequest)get);
                LOGGER.debug("&&&&&&&&&&&& :" + connManager.getTotalStats() + ": &&&&&&&&&&&&&");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String state = "new";
        String nonce = "678910";
        if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getUserContextDTO().getContextMap().get("tfs_refresh_token") != null) {
            try {
                response.sendRedirect("/");
            }
            catch (IOException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            return null;
        }
        String id_token = request.getParameter("id_token");
        if (PropertyValidator.isValid((Object)id_token)) {
            Map resultMap = null;
            try {
                resultMap = JiraOAuth2Filter.getAccessToken((String)"jwt-bearer", (String)id_token);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
            String access_token = String.valueOf(resultMap.get("access_token"));
            String refresh_token = String.valueOf(resultMap.get("refresh_token"));
            if (UserContextUtil.getUserContext() != null) {
                this.setTokenInContext(refresh_token);
                try {
                    response.sendRedirect("/tfsgettest");
                }
                catch (IOException e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return null;
            }
            String userInfoJson = JiraOAuth2Filter.executeGetRequest((String)"https://app.vssps.visualstudio.com/_apis/profile/profiles/me?api-version=4.1", (String)("Bearer " + access_token)).getContent();
            LOGGER.debug("userInfoJson -- >" + userInfoJson);
            Map userInfoMap = (Map)gson.fromJson(userInfoJson, Map.class);
            String userId = String.valueOf(userInfoMap.get("id"));
            String companyInfoJson = JiraOAuth2Filter.executeGetRequest((String)("https://app.vssps.visualstudio.com/_apis/accounts?ownerId=" + userId + "&api-version=4.1"), (String)("Bearer " + access_token)).getContent();
            LOGGER.debug("companyInfoJson -- >" + companyInfoJson);
            Map companyInfoMap = (Map)gson.fromJson(companyInfoJson, Map.class);
            String companyId = String.valueOf(((Map)((ArrayList)companyInfoMap.get("value")).get(0)).get("accountName"));
            String principalInfoJson = JiraOAuth2Filter.executeGetRequest((String)("https://vsaex.dev.azure.com/" + companyId + "/_apis/userentitlements/" + userId + "?api-version=4.1-preview.1"), (String)("Bearer " + access_token)).getContent();
            LOGGER.debug("principalInfoJson -- >" + principalInfoJson);
            Map principalInfoMap = (Map)gson.fromJson(principalInfoJson, Map.class);
            String principal = String.valueOf(((Map)principalInfoMap.get("user")).get("principalName"));
            String displayName = String.valueOf(((Map)principalInfoMap.get("user")).get("displayName"));
            SecureUser secureUser = this.customAuthenticationProvider.getUserContext(principal);
            if (secureUser == null) {
                secureUser = new SecureUser(principal, "");
                HashMap<String, String> infoMap = new HashMap<String, String>();
                infoMap.put("name", displayName);
                infoMap.put("email", principal);
                secureUser.setOauthInfoMap(infoMap);
            }
            if (secureUser.getUserContextDTO() != null) {
                secureUser.getUserContextDTO().getContextMap().put("tfs", "true");
                secureUser.getUserContextDTO().getContextMap().put("tfs_refresh_token", refresh_token);
            }
            UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)secureUser, (Object)"", secureUser.getAuthorities());
            return usernamePasswordAuthenticationToken;
        }
        String newLocal = authUrl + "?client_id=" + clientId + "&response_type=id_token&response_mode=form_post&state=" + state + "&scope=openid&nonce=" + nonce + "&redirect_uri=" + redirectUrl;
        try {
            response.sendRedirect(newLocal);
            return null;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private void setTokenInContext(String token) {
        UserContextUtil.getUserContext().getUserContextDTO().getContextMap().put("tfs_refresh_token", token);
    }

    public static Map<?, ?> getAccessToken(String grandType, String accessCode) throws Exception {
        HttpPost httppost = new HttpPost(tokenUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
        params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        params.add(new BasicNameValuePair("client_assertion", clientSec));
        if (grandType.equals("refresh_token")) {
            params.add(new BasicNameValuePair("grant_type", "refresh_token"));
        } else {
            params.add(new BasicNameValuePair("grant_type", "urn:ietf:params:oauth:grant-type:" + grandType));
        }
        params.add(new BasicNameValuePair("assertion", accessCode));
        params.add(new BasicNameValuePair("redirect_uri", redirectUrl));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(params, "UTF-8");
        httppost.setEntity((HttpEntity)urlEncodedFormEntity);
        httppost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        CloseableHttpResponse postResponse = httpclient.execute((HttpUriRequest)httppost);
        LOGGER.debug("request body:" + JiraOAuth2Filter.convertStreamToString((InputStream)httppost.getEntity().getContent()));
        HttpEntity entity = postResponse.getEntity();
        try (InputStream instream = entity.getContent();){
            Map resultMap = (Map)gson.fromJson(JiraOAuth2Filter.convertStreamToString((InputStream)instream), Map.class);
            if (UserContextUtil.getUserContext() != null) {
                UserContextUtil.getUserContext().getUserContextDTO().getContextMap().put("tfs_refresh_token", resultMap.get("refresh_token"));
            }
            postResponse.close();
            Map map = resultMap;
            return map;
        }
    }

    static String convertStreamToString(InputStream is) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            return br.lines().collect(Collectors.joining());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TFSResponse executeGetRequest(String url, String accessToken) {
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", accessToken);
        get.addHeader("Content-type", "application/json-patch+json");
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)get);
            Integer status = response.getStatusLine().getStatusCode();
            String content = JiraOAuth2Filter.convertStreamToString((InputStream)response.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setStatusCode(status);
            TFSResponse tFSResponse2 = tFSResponse;
            return tFSResponse2;
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TFSResponse executePatchRequest(String url, String accessToken, String body) {
        HttpPatch post = new HttpPatch(url);
        String json = body;
        CloseableHttpResponse postResponse = null;
        try {
            StringEntity entity = new StringEntity(json, "UTF-8");
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json-patch+json");
            post.addHeader("Authorization", accessToken);
            postResponse = httpclient.execute((HttpUriRequest)post);
            Integer status = postResponse.getStatusLine().getStatusCode();
            String reason = postResponse.getStatusLine().getReasonPhrase();
            String content = JiraOAuth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setReason(reason);
            tFSResponse.setStatusCode(status);
            TFSResponse tFSResponse2 = tFSResponse;
            return tFSResponse2;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        finally {
            try {
                postResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TFSResponse executePostRequest(String url, String accessToken, String body) {
        HttpPost post = new HttpPost(url);
        String json = body;
        CloseableHttpResponse postResponse = null;
        try {
            StringEntity entity = new StringEntity(json, "UTF-8");
            post.setEntity((HttpEntity)entity);
            post.setHeader("Content-type", "application/json");
            post.addHeader("Authorization", accessToken);
            postResponse = httpclient.execute((HttpUriRequest)post);
            Integer status = postResponse.getStatusLine().getStatusCode();
            String content = JiraOAuth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
            TFSResponse tFSResponse = new TFSResponse();
            tFSResponse.setContent(content);
            tFSResponse.setStatusCode(status);
            TFSResponse tFSResponse2 = tFSResponse;
            return tFSResponse2;
        }
        catch (Exception ex) {
            LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
        }
        finally {
            try {
                postResponse.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void setClientId(String clientId) {
        JiraOAuth2Filter.clientId = clientId;
    }

    public static void setClientSec(String clientSec) {
        JiraOAuth2Filter.clientSec = clientSec;
    }

    public static void setRedirectUrl(String redirectUrl) {
        JiraOAuth2Filter.redirectUrl = redirectUrl;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    static {
        LOGGER = LoggerFactory.getLogger(JiraOAuth2Filter.class);
        tokenUrl = "https://login.microsoftonline.com/ad9afc4f-bf0c-464e-aba8-5358e7db9b05/oauth2/token";
        authUrl = "https://login.microsoftonline.com/ad9afc4f-bf0c-464e-aba8-5358e7db9b05/oauth2/authorize";
        connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(1000);
        connManager.setDefaultMaxPerRoute(50);
        httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }
}

