/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.viztrend.safe.init.CustomAuthenticationSuccessHandler;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.SAMLConfig;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.SAMLConfigRepository;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

@Component
class CustomLogoutHandler
implements LogoutSuccessHandler {
    @Autowired
    private SAMLConfigRepository samlConfigRepository;
    @Autowired
    private CompanyRepository companyRepository;
    @Autowired
    private Environment env;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAuthenticationSuccessHandler.class);

    CustomLogoutHandler() {
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        try {
            SecureUser secureUser;
            User user;
            String samlId;
            boolean isLocalDeployment = this.env.getProperty("isLocalDeployment").equals("true");
            SAMLConfig samlConfig = null;
            if (!isLocalDeployment && this.env.getProperty("app.env").equals("prod") && UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getCurrentCompany() != null) {
                Company company = this.companyRepository.findById(UserContextUtil.getUserContext().getCurrentCompanyId());
                if (PropertyValidator.isValid((Object)company)) {
                    samlConfig = this.samlConfigRepository.findByTenant(company.getTenant());
                }
            } else {
                List samlConfigList = this.samlConfigRepository.findAll();
                if (PropertyValidator.isValid((Collection)samlConfigList)) {
                    samlConfig = (SAMLConfig)samlConfigList.get(0);
                }
            }
            if (PropertyValidator.isValid(samlConfig) && PropertyValidator.isValid((Object)samlConfig.getIdentityProviderSingleSignOut()) && authentication != null && PropertyValidator.isValid((Object)(samlId = (user = (User)(secureUser = (SecureUser)authentication.getPrincipal()).getUserContextDTO().getContextMap().get("user")).getSamlUserId()))) {
                response.sendRedirect("/logout/saml?samlId=" + samlId);
                return;
            }
            String redirectUrl = request.getParameter("redirect");
            if (PropertyValidator.isValid((Object)redirectUrl)) {
                response.sendRedirect(redirectUrl);
            } else {
                response.sendRedirect("/login");
            }
        }
        catch (IOException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }
}

