/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import com.viztrend.safe.init.WebSecurityConfiguration;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Config;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.dto.LdapUser;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.CompanyRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.InvitationRepository;
import com.viztrend.safe.persistence.repository.TokenRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.LDAPService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
class CustomAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    @Autowired
    UserRepository userRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    ConfigRepository configRepository;
    @Autowired
    @Qualifier(value="LDAPServiceImpl")
    LDAPService ldapService;
    @Autowired
    TokenRepository tokenRepository;
    @Autowired
    CompanyRepository companyRepository;
    @Autowired
    private InvitationRepository invitationRepository;
    @Autowired
    private Environment env;
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomAuthenticationProvider.class);

    CustomAuthenticationProvider() {
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
    }

    protected SecureUser retrieveUser(String username) throws AuthenticationException {
        SecureUser secureUser = this.getUserContext(username);
        if (secureUser != null) {
            return secureUser;
        }
        return null;
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        String password = authentication.getCredentials().toString();
        SecureUser secureUser = this.getUserContext(username);
        if (secureUser != null && (password.equals(secureUser.getPassword()) || password == null)) {
            return secureUser;
        }
        throw new BadCredentialsException("External system authentication failed");
    }

    public SecureUser getUserContext(String userName) {
        SecureUser secureUser = null;
        UserContextDTO userContext = new UserContextDTO();
        User user = this.userRepository.findByUserNameIgnoreCase(userName);
        if (user != null && user.getIsActive().booleanValue()) {
            if (user.getPassword() == null) {
                user.setPassword(UUID.randomUUID().toString());
            }
            secureUser = new SecureUser(user.getUserName(), user.getPassword());
            userContext.getContextMap().put("user", user);
            List userCompanyList = user.getUserCompanies();
            ArrayList<Company> companies = new ArrayList<Company>();
            if (PropertyValidator.isValid((Collection)userCompanyList)) {
                for (UserCompany uc : userCompanyList) {
                    if (uc.getCompany().isArchive()) continue;
                    companies.add(uc.getCompany());
                }
            }
            if (!PropertyValidator.isValid(companies)) {
                this.tokenRepository.delete((Serializable)((Object)user.getUserName()));
                throw new DisabledException("Your account has been deactivated, Please contact your administrator.");
            }
            if (user.isLocked()) {
                this.tokenRepository.delete((Serializable)((Object)user.getUserName()));
                throw new DisabledException(WebSecurityConfiguration.lockedAccountMsg);
            }
            userContext.getContextMap().put("tenant", ((Company)companies.get(0)).getTenant());
            userContext.getContextMap().put("urlPrefix", ((Company)companies.get(0)).getUrlPrefix());
            userContext.getContextMap().put("companies", companies);
            userContext.getContextMap().put("urlScheme", this.env.getProperty("redirect.from.http.server.port") != null ? "https" : "http");
            userContext.getContextMap().put("serverDomain", this.env.getProperty("server.domain"));
            userContext.getContextMap().put("isLocalDeployment", this.env.getProperty("isLocalDeployment"));
            try {
                LdapUser ldapUser;
                Config config;
                boolean loginFromLdap;
                List configList = this.configRepository.findAll();
                if (PropertyValidator.isValid((Collection)configList) && this.env.getProperty("isLocalDeployment").equals("true") && (loginFromLdap = (config = (Config)configList.get(0)).getLdapConfig().isLogin()) && PropertyValidator.isValid((Object)(ldapUser = this.ldapService.findUser(userName)))) {
                    ldapUser.setProvider("ldap");
                    userContext.getContextMap().put("ldapUser", ldapUser);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while sending email :" + StringUtils.getTraceString((Throwable)ex));
            }
            secureUser.setUserContextDTO(userContext);
        }
        return secureUser;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        SecureUser user;
        block27: {
            String username = authentication.getPrincipal() == null ? "NONE_PROVIDED" : authentication.getName();
            user = null;
            try {
                if (authentication.getPrincipal().equals("sysadmin")) {
                    SecureUser sUser = new SecureUser(authentication.getPrincipal().toString(), authentication.getCredentials().toString());
                    UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)sUser, (Object)"", sUser.getAuthorities());
                    return usernamePasswordAuthenticationToken;
                }
                LOGGER.info("trying to authenticate from LDAP");
                List configList = this.configRepository.findAll();
                if (PropertyValidator.isValid((Collection)configList)) {
                    Config config = (Config)configList.get(0);
                    boolean loginFromLdap = config.getLdapConfig().isLogin();
                    if (!loginFromLdap) {
                        LOGGER.warn("no config allowed to login from ldap");
                        throw new ProviderNotFoundException("provider not allowed");
                    }
                    if (!this.ldapService.authenticateAndAuthorize(username, authentication.getCredentials().toString())) {
                        throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
                    }
                    User dbUserOld = this.userRepository.findByUserNameIgnoreCase(username);
                    Company company = (Company)this.companyRepository.findAll().get(0);
                    LdapUser ldapUser = null;
                    try {
                        ldapUser = this.ldapService.findUser(username);
                    }
                    catch (Exception e1) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e1));
                    }
                    if (ldapUser == null) {
                        LOGGER.error("Not able to find user from ldap after its being authenticated..");
                        throw new BadCredentialsException("User Not found in ldap");
                    }
                    HashSet<String> groups = new HashSet<String>();
                    for (String gp : ldapUser.getGroups()) {
                        String[] gpArr;
                        for (String gpStrArr : gpArr = gp.split(",")) {
                            if (!gpStrArr.startsWith("CN=")) continue;
                            groups.add(gpStrArr.substring(gpStrArr.indexOf("=") + 1));
                        }
                    }
                    List matchedGroups = this.groupRepository.findByTitleInOrExternalReferenceInAndTenant(new ArrayList(groups), new ArrayList(groups), company.getTenant());
                    List externalReferencesMatched = matchedGroups.stream().map(Group::getExternalReference).filter(groups::contains).collect(Collectors.toList());
                    if (dbUserOld == null) {
                        try {
                            User dbUser = new User();
                            dbUser.setTenant(config.getTenant());
                            dbUser.setUserName(username.toLowerCase());
                            if (PropertyValidator.isValid((Object)ldapUser.getDisplayName())) {
                                dbUser.setFullName(ldapUser.getDisplayName());
                            } else {
                                dbUser.setFullName(org.apache.commons.lang3.StringUtils.defaultString((String)ldapUser.getFirstName()) + " " + org.apache.commons.lang3.StringUtils.defaultString((String)ldapUser.getLastName()));
                            }
                            dbUser.setFirstName(ldapUser.getFirstName());
                            dbUser.setLastName(ldapUser.getLastName());
                            dbUser.setPassword(UUID.randomUUID().toString());
                            dbUser.setLdap(true);
                            dbUser.setEmail(ldapUser.getEmail());
                            UserCompany uc = new UserCompany();
                            uc.setCompany(company);
                            dbUser.setUserCompanies(new ArrayList());
                            dbUser.getUserCompanies().add(uc);
                            dbUser.setExternalReferenceGroups(externalReferencesMatched);
                            Map packageDetailsCount = this.userService.getPackageLimitCount(company);
                            Long usersCount = packageDetailsCount.getOrDefault("userCount", 0L);
                            Long guestUserCount = packageDetailsCount.getOrDefault("guestUserCount", 0L);
                            Long pkgUsersCount = (Long)packageDetailsCount.get("pkgUserCount");
                            Long pkgGuestUsersCount = (Long)packageDetailsCount.get("pkgGuestUserCount");
                            ArrayList<Group> matchedGroupsFiltered = new ArrayList<Group>();
                            if (PropertyValidator.isValid((Collection)matchedGroups)) {
                                for (Group gp : matchedGroups) {
                                    if (gp.isArchive() || !gp.getTenant().equals(company.getTenant())) continue;
                                    matchedGroupsFiltered.add(gp);
                                    if (!gp.isForGuestUsers() || !company.isGuestEnabled()) continue;
                                    LOGGER.debug("setting user as guest");
                                    dbUser.setIsGuest(Boolean.valueOf(true));
                                    ((UserCompany)dbUser.getUserCompanies().get(0)).setIsGuest(Boolean.valueOf(true));
                                }
                            }
                            if (!PropertyValidator.isValid(matchedGroupsFiltered) && config.getLdapConfig().isAddAsInActiveUser()) {
                                ((UserCompany)dbUser.getUserCompanies().get(0)).setIsActive(Boolean.valueOf(false));
                            }
                            LOGGER.debug("package guest users:" + pkgGuestUsersCount + " active guest users:" + guestUserCount);
                            LOGGER.debug("package users:" + pkgUsersCount + " active users:" + usersCount);
                            boolean isLimitExceeded = true;
                            String userType = "users";
                            if (!dbUser.getIsActive().booleanValue()) {
                                isLimitExceeded = false;
                            } else if (dbUser.getIsGuest().booleanValue()) {
                                userType = "guest users";
                                if (pkgGuestUsersCount == null || pkgGuestUsersCount - guestUserCount > 0L) {
                                    isLimitExceeded = false;
                                }
                            } else if (!(dbUser.getIsGuest().booleanValue() || pkgUsersCount - usersCount <= 0L && pkgUsersCount != -1L)) {
                                isLimitExceeded = false;
                            }
                            if (isLimitExceeded) {
                                user = new SecureUser(dbUser.getUserName(), "");
                                user.setLoginWithError(true);
                                user.setError(userType + " limit reached");
                                return this.createSuccessAuthentication((Object)user, authentication, (UserDetails)user);
                            }
                            dbUser = (User)this.userRepository.save((Object)dbUser);
                            user = this.retrieveUser(username);
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                    } else {
                        dbUserOld.setExternalReferenceGroups(externalReferencesMatched);
                        this.userRepository.save((Object)dbUserOld);
                        user = this.retrieveUser(username);
                    }
                    break block27;
                }
                LOGGER.warn("no ldap config found");
                throw new ProviderNotFoundException("provider not allowed");
            }
            catch (UsernameNotFoundException notFound) {
                throw new InternalAuthenticationServiceException("internal authentcation exception");
            }
        }
        Assert.notNull((Object)user, (String)"retrieveUser returned null - a violation of the interface contract");
        return this.createSuccessAuthentication((Object)user, authentication, (UserDetails)user);
    }

    @Bean
    public MethodInvokingFactoryBean methodInvokingFactoryBean() {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setTargetClass(SecurityContextHolder.class);
        methodInvokingFactoryBean.setTargetMethod("setStrategyName");
        methodInvokingFactoryBean.setArguments((Object[])new String[]{"MODE_INHERITABLETHREADLOCAL"});
        return methodInvokingFactoryBean;
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

