/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.init;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;

class ClientResources {
    @NestedConfigurationProperty
    private AuthorizationCodeResourceDetails client = new AuthorizationCodeResourceDetails();
    @Autowired
    private Environment env;
    @NestedConfigurationProperty
    private ResourceServerProperties resource = new ResourceServerProperties();

    ClientResources() {
    }

    public AuthorizationCodeResourceDetails getGoogleClient() {
        this.client.setClientId(this.env.getProperty("google.client.id"));
        this.client.setClientSecret(this.env.getProperty("google.client.secret"));
        this.client.setAccessTokenUri("https://www.googleapis.com/oauth2/v4/token");
        this.client.setUserAuthorizationUri("https://accounts.google.com/o/oauth2/v2/auth");
        this.client.setScope(new ArrayList<String>(Arrays.asList("https://www.googleapis.com/auth/userinfo.email,https://www.googleapis.com/auth/userinfo.profile".split(","))));
        this.client.setClientAuthenticationScheme(AuthenticationScheme.form);
        this.client.setAuthenticationScheme(AuthenticationScheme.query);
        return this.client;
    }

    public ResourceServerProperties getOktaResource() {
        this.resource.setUserInfoUri("https://loxvoloxvo1.okta.com/oauth2/v1/userinfo");
        this.resource.setPreferTokenInfo(true);
        return this.resource;
    }

    public ResourceServerProperties getGoogleResource() {
        this.resource.setUserInfoUri("https://www.googleapis.com/oauth2/v3/userinfo");
        this.resource.setPreferTokenInfo(true);
        return this.resource;
    }
}

