/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller.api;

import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.service.RiskApiServiceV1;
import com.viztrend.safe.utils.PropertyValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Kendis Risk API V1"}, description="Version 1 of Kendis Risk Management REST API")
public class ApiV1Controller {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiV1Controller.class);
    private static final int DEFAULT_PAGE_LIMIT = 50;
    private static final int MAX_PAGE_LIMIT = 50;
    private static final int DEFAULT_START_AT = 0;
    @Autowired
    private RiskApiServiceV1 riskApiServiceV1;

    @ApiOperation(tags={"Risk Registers"}, value="Get list of risk registers", notes="Retrieve a paginated list of risk registers with optional field selection. Pagination parameters (startAt, pageLimit) control the result set. Default page limit is 50 with a maximum of 50 items per page.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved risk registers"), @ApiResponse(code=400, message="Invalid request parameters"), @ApiResponse(code=401, message="Unauthorized - Invalid or missing API key"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="fields", example="id, key, title, status", value="Comma-separated list of fields to include in response. Available fields: id, key, title, status, createdBy, workflow, riskMatrix, linkedSessions, watcherList. Pass 'all' to retrieve all fields.", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="startAt", example="0", value="Pagination offset - the index of the first item to return. Default is 0.", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="50", value="Number of items to return per page. Default is 50, maximum is 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk-registers"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> listRiskRegisters(@PathVariable(value="companyPrefix") String companyPrefix, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            LOGGER.debug("listRiskRegisters called for company: {}", (Object)companyPrefix);
            String fields = request.getParameter("fields");
            String expand = request.getParameter("expand");
            int startAt = this.parseIntParameter(request.getParameter("startAt"), 0);
            int pageLimit = this.parseIntParameter(request.getParameter("pageLimit"), 50);
            pageLimit = this.validatePageLimit(pageLimit);
            LOGGER.debug("Calling service with: fields={}, expand={}, startAt={}, pageLimit={}", new Object[]{fields, expand, startAt, pageLimit});
            if (this.riskApiServiceV1 == null) {
                LOGGER.error("riskApiServiceV1 is NULL! Bean not injected!");
                responseJson.put("error", "Service not available");
                return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            responseJson = this.riskApiServiceV1.getListOfRiskRegister(fields, expand, startAt, pageLimit);
            LOGGER.debug("Service returned responseJson: {}", (Object)responseJson);
            LOGGER.debug("ResponseJson size: {}, isEmpty: {}, isNull: {}", new Object[]{responseJson != null ? Integer.valueOf(responseJson.size()) : "null", responseJson != null ? Boolean.valueOf(responseJson.isEmpty()) : "null", responseJson == null});
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            LOGGER.error("KendisException while fetching risk registers: {}", (Object)e.getMessage(), (Object)e);
            responseJson.put("errorMessages", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risk registers", (Throwable)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risk Registers"}, value="Get risk register by ID or key", notes="Retrieve detailed information about a specific risk register using its ID or key.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved risk register"), @ApiResponse(code=404, message="Risk register not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="fields", example="id, key, title, status, workflow", value="Comma-separated list of fields to include or 'all' for all fields.", required=false, dataType="string", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk-registers/{registerIdOrKey}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegister(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="registerIdOrKey", value="Risk register ID or key", required=true) @PathVariable(value="registerIdOrKey") String registerIdOrKey, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            String fields = request.getParameter("fields");
            String expand = request.getParameter("expand");
            responseJson = this.riskApiServiceV1.getRiskRegisterByIdOrKey(registerIdOrKey, fields, expand);
            if (!PropertyValidator.isValid(responseJson.get("Data"))) {
                responseJson.put("errorMessages", "No Risk Register found with the given ID or key.");
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risk register: {}", (Object)registerIdOrKey, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risk Registers"}, value="Get risk register metadata", notes="Retrieve configuration metadata including statuses, impact levels, probability levels, and risk matrix for a specific risk register. This data is used to populate forms and dropdowns.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved metadata"), @ApiResponse(code=404, message="Risk register not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic {apiKey}\nGet your API key from user profile", required=true, dataType="string", paramType="header")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk-registers/{registerId}/metadata"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisterMetadata(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="registerId", value="Risk register ID", required=true) @PathVariable(value="registerId") String registerId, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.riskApiServiceV1.getRiskRegisterMetadata(registerId);
            if (!PropertyValidator.isValid(responseJson.get("Data")) || ((Map)responseJson.get("Data")).isEmpty()) {
                responseJson.put("errorMessages", "No Risk Register found with the given ID.");
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risk register metadata: {}", (Object)registerId, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risk Registers"}, value="Get boards linked to risk register", notes="Retrieve a paginated list of all boards (PI boards, solution trains, etc.) that are linked to the specified risk register.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved linked boards"), @ApiResponse(code=404, message="Risk register not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="startAt", example="0", value="Pagination offset. Default is 0.", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="50", value="Number of boards to return. Default is 50, maximum is 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk-registers/{registerId}/boards"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisterLinkedBoards(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="registerId", value="Risk register ID", required=true) @PathVariable(value="registerId") String registerId, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            int startAt = this.parseIntParameter(request.getParameter("startAt"), 0);
            int pageLimit = this.parseIntParameter(request.getParameter("pageLimit"), 50);
            pageLimit = this.validatePageLimit(pageLimit);
            responseJson = this.riskApiServiceV1.getRiskRegisterLinkedBoards(registerId, startAt, pageLimit);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching linked boards for risk register: {}", (Object)registerId, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risks"}, value="Get risks by risk register", notes="Retrieve a paginated list of risks from a specific risk register with optional field selection. Supports filtering by status, impact, probability, and other criteria.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved risks"), @ApiResponse(code=404, message="Risk register not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="fields", example="id, title, status, impact, probability", value="Comma-separated list of fields. Available: title, id, createdBy, status, linkedItems, boardTeams, boardSprints, impact, probability, raisedDate, resolutionDate, riskRegister, watcherList, responsible, linkedPiBoards, linkedSolutionBoards, linkedOrgCollections, conversationCount, fields (custom fields). Pass 'all' for all fields.", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="startAt", example="0", value="Pagination offset. Default is 0.", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="50", value="Number of risks to return. Default is 50, maximum is 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk-registers/{registerIdOrKey}/risks"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRisksByRegister(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="registerIdOrKey", value="Risk register ID or key", required=true) @PathVariable(value="registerIdOrKey") String registerIdOrKey, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            String fields = request.getParameter("fields");
            String expand = request.getParameter("expand");
            int startAt = this.parseIntParameter(request.getParameter("startAt"), 0);
            int pageLimit = this.parseIntParameter(request.getParameter("pageLimit"), 50);
            pageLimit = this.validatePageLimit(pageLimit);
            responseJson = this.riskApiServiceV1.getListOfRiskByRiskRegister(registerIdOrKey, fields, expand, startAt, pageLimit);
            if (!PropertyValidator.isValid(responseJson.get("Data"))) {
                responseJson.put("errorMessages", "No Risk Register found with the given ID or key.");
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risks for register: {}", (Object)registerIdOrKey, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risks"}, value="Get risk by ID", notes="Retrieve detailed information about a specific risk including its assessment, linked items, conversations, and all relationships.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved risk"), @ApiResponse(code=404, message="Risk not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="fields", example="id, title, status, impact, linkedItems", value="Comma-separated list of fields or 'all' for all fields.", required=false, dataType="string", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risks/{riskId}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskById(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="riskId", value="Risk ID", required=true) @PathVariable(value="riskId") String riskId, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            String fields = request.getParameter("fields");
            String expand = request.getParameter("expand");
            responseJson = this.riskApiServiceV1.getRiskById(riskId, fields, expand);
            if (!PropertyValidator.isValid(responseJson.get("Data")) || ((Map)responseJson.get("Data")).isEmpty()) {
                responseJson.put("errorMessages", "No Risk found with the given ID.");
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risk: {}", (Object)riskId, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Boards"}, value="Get risk register for board", notes="Retrieve the risk register that is linked to a specific board (PI board, solution train, etc.).")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved risk register"), @ApiResponse(code=404, message="Board or risk register not found"), @ApiResponse(code=500, message="Internal server error occurred")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Basic authentication header in format: Basic base64(email:apiKey)\nExample: For email 'user@example.com' and API key 'abc123', encode 'user@example.com:abc123' in base64 and use 'Basic <encoded_value>'\nGet your API key from user profile", required=true, dataType="string", paramType="header"), @ApiImplicitParam(name="fields", example="id, key, title, status", value="Comma-separated list of fields or 'all' for all fields.", required=false, dataType="string", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/boards/{boardId}/risk-register"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getBoardRiskRegister(@PathVariable(value="companyPrefix") String companyPrefix, @ApiParam(name="boardId", value="Board (Session) ID", required=true) @PathVariable(value="boardId") String boardId, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            String fields = request.getParameter("fields");
            String expand = request.getParameter("expand");
            responseJson = this.riskApiServiceV1.getRiskRegisterLinkToTheBoard(boardId, fields, expand);
            if (!PropertyValidator.isValid(responseJson.get("Data")) || ((Map)responseJson.get("Data")).isEmpty()) {
                responseJson.put("errorMessages", "No risk register found for the given board.");
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while fetching risk register for board: {}", (Object)boardId, (Object)e);
            responseJson.put("error", "There are some issues in fetching data.");
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private int parseIntParameter(String value, int defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid integer parameter value: {}, using default: {}", (Object)value, (Object)defaultValue);
            return defaultValue;
        }
    }

    private int validatePageLimit(int pageLimit) {
        if (pageLimit < 0) {
            pageLimit = Math.abs(pageLimit);
        }
        if (pageLimit > 50) {
            return 50;
        }
        if (pageLimit == 0) {
            return 50;
        }
        return pageLimit;
    }
}

