/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller.api;

import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.UserApiKey;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.UserApiKeyRepository;
import com.viztrend.safe.service.APIService;
import com.viztrend.safe.service.APIServiceImpl;
import com.viztrend.safe.service.DependencyAPIService;
import com.viztrend.safe.service.RiskAPIService;
import com.viztrend.safe.utils.PropertyValidator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/{companyPrefix}"})
@Api(tags={"Kendis APi's"})
@RestController
public class APIController {
    private static final Logger LOGGER = LoggerFactory.getLogger(APIServiceImpl.class);
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private APIService apiService;
    @Autowired
    private RiskAPIService riskAPIService;
    @Autowired
    private UserApiKeyRepository userApiKeyRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private DependencyAPIService dependencyAPIService;
    private static final String AUTHORIZATION_SCHEME = "Basic";

    private UserApiKey extractUserApiKeyFromHeader(String keyAuthorization) {
        String[] keyAuthorizationSplit = keyAuthorization.split(" ");
        if (keyAuthorizationSplit.length != 2) {
            return null;
        }
        String apiKey = this.apiService.hashApiKey(keyAuthorizationSplit[1]);
        return this.userApiKeyRepository.findByApiKey(apiKey);
    }

    private HashMap<String, Object> validateAuthorization(HashMap<String, String> authorization) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (!PropertyValidator.isValid(authorization) || authorization.size() != 2) {
            response.put("success", false);
            response.put("reason", "Invalid request, missing values.");
            return response;
        }
        if (!AUTHORIZATION_SCHEME.equals(authorization.get("scheme"))) {
            response.put("success", false);
            response.put("reason", "Invalid authorization scheme.");
            return response;
        }
        String apiKey = this.apiService.hashApiKey(authorization.get("apiKey"));
        UserApiKey userApiKey = this.userApiKeyRepository.findByApiKey(apiKey);
        if (!PropertyValidator.isValid((Object)userApiKey)) {
            response.put("success", false);
            response.put("reason", "Invalid api key");
            return response;
        }
        if (!userApiKey.isRevoked()) {
            response.put("success", false);
            response.put("reason", "This API key has been revoked");
            return response;
        }
        response.put("success", true);
        response.put("userApiKey", userApiKey);
        return response;
    }

    private void decreaseDailyLimit(UserApiKey userApiKey) {
        userApiKey.setDailyLimit(userApiKey.getDailyLimit() - 1);
        this.userApiKeyRepository.save((Object)userApiKey);
    }

    @ApiOperation(tags={"Objectives"}, value="Get objective by keys", notes="Retrieve details of an objective by objective key")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=400, message="Please check objectiveKey in paramater"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="objectiveKey", example="", value="OBJ-1 , OBJ-234", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="fields", example="key, title, bvPlan, bvActual, completion", value="You can retrieve objective groups with specific fields by passing fields which is given below. \n [key, title, bvPlan, bvActual, completion, startDate, pageLimit, status, description, linkedItems, Responsible, KR, groupName] \n OR \n  To get all fields please pass all.", required=false, dataType="string", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, value={"/objective"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getObjectivebyKey(HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            if (PropertyValidator.isValid((Object)request.getParameter("objectiveKey"))) {
                responseJson = this.apiService.getIndividualObjectiveByObjectiveKey(request.getParameter("objectiveKey"), request.getParameter("fields"), request.getParameter("expand"));
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
                }
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return new ResponseEntity((Object)responseJson, HttpStatus.OK);
            }
            responseJson.put("errorMessages", "please send objective keys as a parameter. ");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            responseJson.put("errorMessages", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching Individual objectice by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Objectives"}, value="Get List of Objectives ", notes="Retrieve details of an objective by the type of objectives from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=400, message="Please check your url"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", example="key, title, bvPlan, bvActual, completion", value="You can retrieve objective groups with specific fields by passing fields given below, \n key, title, bvPlan, bvActual, completion, startDate, pageLimit, status, description, linkedItems, Responsible, KR, groupName \n OR \n  To get all fields please pass [all or nothing]", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="startAt", example="1", value=" Start At as a way to navigate through a long list of objectives and user can pass it's value.By default it is set to '0'", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="10", value=" Page limit is like setting a boundary on how many objectives you want to see at once. It's like saying, 'I only want to see 10 (or any number you choose) things on a page. By default it is set to 50 and you can't pass a value higher then 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"{type}/objectives", "{type}/objectives/{id}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getAllglobalObjectives(@ApiParam(name="type", example="", allowMultiple=false, allowableValues="companylevel,piboard,collection,batches", type="String", value="type of objectives like piboard or companylevel", required=true) @PathVariable(value="type") String type, @ApiParam(name="id", example="", allowMultiple=false, type="String", value="For Company Level Objectives : noting \n  For PI Board Objectives : piBoardId \n  For Collection Objectives : collectionId \n  For Batches Objectives : batchesId ", required=false) @PathVariable(value="id") Optional<String> id, HttpServletRequest request) {
        Map responseJson = new HashMap<String, String>();
        try {
            String boardId = "";
            boolean isPiBoard = false;
            if (type.equals(EnumKendis.PI_BORAD.getCode()) && id.isPresent()) {
                boardId = id.get();
                isPiBoard = true;
            } else if (type.equals(EnumKendis.COLLECTION.getCode()) || type.equals(EnumKendis.BATCHES.getCode())) {
                boardId = id.get();
            } else if (type.equals(EnumKendis.COMPANY_LEVEL.getCode())) {
                boardId = "-1";
            }
            if (PropertyValidator.isValid((Object)boardId)) {
                int startAt = 0;
                if (this.isNumeric(request.getParameter("startAt"))) {
                    startAt = Integer.parseInt(request.getParameter("startAt"));
                }
                int pageLimit = 50;
                if (this.isNumeric(request.getParameter("pageLimit")) && (pageLimit = Integer.parseInt(request.getParameter("pageLimit"))) < 0) {
                    pageLimit = Math.abs(pageLimit);
                }
                if (pageLimit > 50) {
                    pageLimit = 50;
                }
                if (!PropertyValidator.isValid((responseJson = isPiBoard ? this.apiService.getObjectivesByActiveSessionBoardId(boardId, request.getParameter("fields"), request.getParameter("expand"), startAt, pageLimit) : this.apiService.getAllglobalObjectives(boardId, isPiBoard, request.getParameter("fields"), request.getParameter("expand"), startAt, pageLimit)).get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                    return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
                }
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                    return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            responseJson.put("errorMessages", "please send a valid objective type or id");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching team objectice by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Objectives"}, value="Get List of Objective Groups", notes="Retrieve details of objective groups by sending the name of group in the url and the type of objective.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=400, message="Please check your url"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="fields", example="key, title, bvPlan, bvActual, completion", value="You can retrieve objective groups with specific fields by passing fields given below, \n key, title, bvPlan, bvActual, completion, startDate, pageLimit, status, description, linkedItems, Responsible, KR, groupName \n OR \n  To get all fields please pass [all or nothing]", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="groupKey", example="Team 1", value="You can retrieve objective groups by passing groups name. \n For example \n Team 1,Custom Objective 1", required=true, dataType="string", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"{type}/objectivegroups", "{type}/objectivegroups/{id}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getAllglobalObjectivesByGroups(@ApiParam(name="type", example="", allowMultiple=false, allowableValues="companylevel,piboard,collection,batches", type="String", value="type of objectives", required=true) @PathVariable(value="type") String type, @ApiParam(name="id", example="", allowMultiple=false, type="String", value="For Company Level Objectives : noting \n  For PI Board Objectives : piBoardId \n  For Collection Objectives : collectionId \n  For Batches Objectives : batchesId ", required=false) @PathVariable(value="id") Optional<String> id, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            String boardId = "";
            boolean isPiBoard = false;
            if (type.equals(EnumKendis.PI_BORAD.getCode()) && id.isPresent()) {
                boardId = id.get();
                isPiBoard = true;
            } else if (type.equals(EnumKendis.COLLECTION.getCode()) || type.equals(EnumKendis.BATCHES.getCode())) {
                boardId = id.get();
            } else if (type.equals(EnumKendis.COMPANY_LEVEL.getCode())) {
                boardId = "-1";
            }
            if (PropertyValidator.isValid((Object)boardId)) {
                responseJson = isPiBoard ? this.apiService.getGroupObjectiveByGroupNameAndActiveSessionBoardId(request.getParameter("groupKey"), boardId, request.getParameter("fields"), request.getParameter("expand")) : this.apiService.getAllglobalAndOtherGroupObjectiveByGroupName(request.getParameter("groupKey"), boardId, request.getParameter("fields"), request.getParameter("expand"), isPiBoard);
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
                }
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return new ResponseEntity((Object)responseJson, HttpStatus.OK);
            }
            responseJson.put("errorMessages", "please send a valid objective type ");
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching team objectice by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Objectives"}, value="Get List of Group Objectives, objectives and key results title or keys", notes="Retrieve title or key of group objective, objectives and key results by sending the type of objectives in the url and id if it's not global.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved."), @ApiResponse(code=400, message="Please check your url"), @ApiResponse(code=404, message="No data found againest the given type and id's."), @ApiResponse(code=422, message="Please send type correctly."), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header")})
    @RequestMapping(method={RequestMethod.GET}, path={"{type}/objectivesmeta", "{type}/objectivesmeta/{id}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getObjectivesMeta(@ApiParam(name="type", example="", allowMultiple=false, allowableValues="companylevel,piboard,collection,batches", type="String", value="type of objectives", required=true) @PathVariable(value="type") String type, @ApiParam(name="id", example="", allowMultiple=false, type="String", value="For Company Level Objectives : noting \n  For PI Board Objectives : piBoardId \n  For Collection Objectives : collectionId \n  For Batches Objectives : batchesId ", required=false) @PathVariable(value="id") Optional<String> id) {
        HashMap responseJson = new HashMap();
        try {
            String boardId = "";
            boolean isBatchesDataCalled = false;
            if (type.equals(EnumKendis.PI_BORAD.getCode()) && id.isPresent()) {
                SessionBoard activeSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id.get()));
                boardId = activeSessionBoard.getSession().getId();
            } else if (type.equals(EnumKendis.COLLECTION.getCode())) {
                boardId = id.get();
            } else if (type.equals(EnumKendis.BATCHES.getCode()) && !id.isPresent()) {
                isBatchesDataCalled = true;
            } else if (type.equals(EnumKendis.COMPANY_LEVEL.getCode())) {
                boardId = "-1";
            }
            if (PropertyValidator.isValid((Object)boardId) || isBatchesDataCalled) {
                responseJson = this.apiService.getObjectivesMeta(boardId, isBatchesDataCalled);
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
                }
                if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                    return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                return new ResponseEntity((Object)responseJson, HttpStatus.OK);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.UNPROCESSABLE_ENTITY);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Objective Groups"}, value="Get List of Objective Groups", notes="Retrieve details of objective group, objectives and linked items by sending the board id in url from api route '/boards' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved", responseContainer="List"), @ApiResponse(code=404, message="No data is found againest the given parameters"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="boardId", value="Any board id fetched from boards listing api route ", required=true, dataType="string", paramType="query"), @ApiImplicitParam(name="completionType", value="completion type used in objective screen ", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="additionalColumns", value="1 used for teams and sprints information of linked items", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header")})
    @RequestMapping(value={"/objective-groups"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveJson(HttpServletRequest request) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map params = request.getParameterMap();
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            List data = this.apiService.loadObjectiveJson(userApiKey, params);
            if (PropertyValidator.isValid((Collection)data)) {
                responseJson.put("data", data);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            responseJson.put("error", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/items"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getItemsJson(HttpServletRequest request, @RequestBody Map<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            LOGGER.debug("getItemsJson API called");
            LOGGER.debug("Request Body - Number of entries: {}", (Object)(requestBody != null ? requestBody.size() : 0));
            if (requestBody != null && !requestBody.isEmpty()) {
                for (Map.Entry<String, Object> entry : requestBody.entrySet()) {
                    LOGGER.debug("Request Body - Key: '{}', Value: {}", (Object)entry.getKey(), entry.getValue());
                }
            }
            Map params = request.getParameterMap();
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            responseJson = this.apiService.getItemsJson(userApiKey, requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            responseJson.put("error", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/sprints"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getTeamsJson(HttpServletRequest request, @RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map params = request.getParameterMap();
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            requestBody.put("type", "sprints");
            List data = this.apiService.getBoardTeamSprintJson(userApiKey, requestBody);
            if (PropertyValidator.isValid((Collection)data)) {
                responseJson.put("data", data);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            responseJson.put("error", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/teams"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getSpritnsJson(HttpServletRequest request, @RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map params = request.getParameterMap();
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            requestBody.put("type", "teams");
            List data = this.apiService.getBoardTeamSprintJson(userApiKey, requestBody);
            if (PropertyValidator.isValid((Collection)data)) {
                responseJson.put("data", data);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            responseJson.put("error", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/statuses"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getStatusesJson(HttpServletRequest request, @RequestBody Map<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map params = request.getParameterMap();
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            requestBody.put("type", "statuses");
            Map data = this.apiService.getBoardStatusesJson(userApiKey, requestBody);
            if (PropertyValidator.isValid((Object)data)) {
                responseJson.put("data", data);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (KendisException e) {
            responseJson.put("error", e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Program Board"}, value="Get List of Board Collections and Boards with their states and states Ids", notes="Retrieve details of group objective by sending the name of group in the url and the type of objective.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved", responseContainer="List"), @ApiResponse(code=404, message="No data is found againest the given parameters"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="collectionIds", example="", value="Send the comma separated collection ids as parameter for getting only board of specific collection, these ids can be fetch from route '/collections'", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header")})
    @RequestMapping(value={"/boards"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getBoardMeta(HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            responseJson = this.apiService.getBoardMeta(userApiKey, request.getParameter("collectionIds"));
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching board meta by api key -> ", (Throwable)e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Collections"}, value="Get List of all board collections of a company", notes="Retrieve details board collections with collection name and collection id's.")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=404, message="No board collection is found againest the company"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header")
    @RequestMapping(method={RequestMethod.GET}, value={"/collections"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getWorkSpacesMeta(HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            UserApiKey userApiKey = this.apiService.getUserFromRequest(request);
            responseJson = this.apiService.getWorkSpaces(userApiKey);
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Deprecated
    @ApiOperation(tags={"Risk And Risk Register (Deprecated)"}, value="Get List of Risk Register [DEPRECATED - Use V1 API]", notes="**DEPRECATED**: This endpoint is deprecated. Please migrate to V1 API: /api/v1/{companyPrefix}/risk-registers\n\nRetrieve details of Risk Register from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", example="key, title, id, createdBy, status", value="You can retrieve risk register list with specific fields by passing fields given below, \n key,title,id,createdBy,status \n OR \n  To get all fields please pass 'all'", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="startAt", example="1", value=" Start At as a way to navigate through a long list of risk register and user can pass it's value.By default it is set to '0'", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="10", value=" Page limit is like setting a boundary on how many risk register you want to see at once. It's like saying, 'I only want to see 10 (or any number you choose) things on a page. By default it is set to 50 and you can't pass a value higher then 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/riskregister"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getListOfRiskRegister(HttpServletRequest request) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            int startAt = 0;
            if (this.isNumeric(request.getParameter("startAt"))) {
                startAt = Integer.parseInt(request.getParameter("startAt"));
            }
            int pageLimit = 50;
            if (this.isNumeric(request.getParameter("pageLimit")) && (pageLimit = Integer.parseInt(request.getParameter("pageLimit"))) < 0) {
                pageLimit = Math.abs(pageLimit);
            }
            if (pageLimit > 50) {
                pageLimit = 50;
            }
            return new ResponseEntity((Object)this.riskAPIService.getListOfRiskRegister(request.getParameter("fields"), request.getParameter("expand"), startAt, pageLimit), HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Deprecated
    @ApiOperation(tags={"Risk And Risk Register (Deprecated)"}, value="Get List of Risk [DEPRECATED - Use V1 API]", notes="**DEPRECATED**: This endpoint is deprecated. Please migrate to V1 API: /api/v1/{companyPrefix}/risk-registers/{registerIdOrKey}/risks\n\nRetrieve details of Risk linked with specific risk register from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=404, message="No Risk Register Found with the given Id."), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", example="title,id,createdBy,status,linkedItems", value="You can retrieve risk register list with specific fields by passing fields given below, \n title,id,createdBy,status,linkedItems,boardTeams,boardSprints,impact,probability,raisedDate,resolutionDate,riskRegister,watcherList,responsible \n OR \n  To get all fields please pass 'all'", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="startAt", example="1", value=" Start At as a way to navigate through a long list of risk register and user can pass it's value.By default it is set to '0'", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="10", value=" Page limit is like setting a boundary on how many risk register you want to see at once. It's like saying, 'I only want to see 10 (or any number you choose) things on a page. By default it is set to 50 and you can't pass a value higher then 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"{riskregisteridorkey}/risk"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getListOfRiskLinkedWithRiskRegister(@ApiParam(name="riskregisteridorkey", example="", allowMultiple=false, type="String", value="For Risk List please send the linked risk register Id", required=true) @PathVariable(value="riskregisteridorkey") String riskregisteridorkey, HttpServletRequest request) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            RiskRegister linkedRiskRegister;
            int startAt = 0;
            if (this.isNumeric(request.getParameter("startAt"))) {
                startAt = Integer.parseInt(request.getParameter("startAt"));
            }
            int pageLimit = 50;
            if (this.isNumeric(request.getParameter("pageLimit")) && (pageLimit = Integer.parseInt(request.getParameter("pageLimit"))) < 0) {
                pageLimit = Math.abs(pageLimit);
            }
            if (pageLimit > 50) {
                pageLimit = 50;
            }
            if (PropertyValidator.isValid((Object)(linkedRiskRegister = this.riskRegisterRepository.findOneByIdOrRegisterKey(riskregisteridorkey, riskregisteridorkey)))) {
                return new ResponseEntity((Object)this.riskAPIService.getListOfRiskByRiskRegister(linkedRiskRegister.getId(), request.getParameter("fields"), request.getParameter("expand"), startAt, pageLimit), HttpStatus.OK);
            }
            return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @Deprecated
    @ApiOperation(tags={"Risk And Risk Register (Deprecated)"}, value="Get Risk Register by Board [DEPRECATED - Use V1 API]", notes="**DEPRECATED**: This endpoint is deprecated. Please migrate to V1 API: /api/v1/{companyPrefix}/boards/{boardId}/risk-register\n\nRetrieve details of Risk linked with specific risk register from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=404, message="No Risk Register Found with the given Id."), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", example="title, id, createdBy, status, linkedItems", value="You can retrieve risk register list with specific fields by passing fields given below, \n title, id, createdBy, status, linkedItems, boardTeams, boardSprints, impact, probability, raisedDate, resolutionDate, riskRegister, watcherList, responsible \n OR \n  To get all fields please pass 'all'", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header")})
    @RequestMapping(method={RequestMethod.GET}, path={"/{boardid}/riskregister"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisterAndRiskByBoardId(@ApiParam(name="boardid", example="", allowMultiple=false, type="String", value="For Risk list and linked Risk Register please send the linked board Id", required=true) @PathVariable(value="boardid") String boardid, HttpServletRequest request) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.riskAPIService.getRiskRegisterLinkToTheBoard(boardid, request.getParameter("fields"), request.getParameter("expand"));
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("errorMessages"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.NOT_FOUND);
            }
            if (!PropertyValidator.isValid(responseJson.get("Data")) && PropertyValidator.isValid(responseJson.get("error"))) {
                return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risk And Risk Register"}, value="Get List of Linked Boards ", notes="Retrieve details of Risk linked with specific risk register from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=404, message="No Risk Register Found with the given Id."), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="startAt", example="1", value=" Start At as a way to navigate through a long list of risk register and user can pass it's value.By default it is set to '0'", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="10", value=" Page limit is like setting a boundary on how many risk register you want to see at once. It's like saying, 'I only want to see 10 (or any number you choose) things on a page. By default it is set to 50 and you can't pass a value higher then 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/{riskregisteridorkey}/boards"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getLikeBoardByRiskRegister(@ApiParam(name="riskregisteridorkey", example="", allowMultiple=false, type="String", value="For board list linked to Risk Register please send the Risk Register Id", required=true) @PathVariable(value="riskregisteridorkey") String riskregisteridorkey, HttpServletRequest request) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            RiskRegister linkedRiskRegister;
            int startAt = 0;
            if (this.isNumeric(request.getParameter("startAt"))) {
                startAt = Integer.parseInt(request.getParameter("startAt"));
            }
            int pageLimit = 50;
            if (this.isNumeric(request.getParameter("pageLimit")) && (pageLimit = Integer.parseInt(request.getParameter("pageLimit"))) < 0) {
                pageLimit = Math.abs(pageLimit);
            }
            if (pageLimit > 50) {
                pageLimit = 50;
            }
            if (PropertyValidator.isValid((Object)(linkedRiskRegister = this.riskRegisterRepository.findOneByIdOrRegisterKey(riskregisteridorkey, riskregisteridorkey)))) {
                return new ResponseEntity((Object)this.riskAPIService.getRiskRegisterLinkedBoards(linkedRiskRegister.getId(), startAt, pageLimit), HttpStatus.OK);
            }
            responseJson.put("errorMessages", "No risk Register found with the given id.");
            return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(tags={"Risk And Risk Register"}, value="Get Risk By Id", notes="Retrieve details of Risk linked with specific risk register from a start index and the page limit which user need to send and the page limit is not more then 50. Start At and Page Limit is not always required as if user didn't send any of them in that case we use default value and the default value for Start At is '0' and for Page Limit dafault value is '50' ")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved"), @ApiResponse(code=500, message="Some server error occurred during fetching data")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="fields", example="title, id, createdBy, status, linkedItems", value="You can retrieve risk register list with specific fields by passing fields given below, \n title, id, createdBy, status, linkedItems, boardTeams, boardSprints, impact, probability, raisedDate, resolutionDate, riskRegister, watcherList, responsible \n OR \n  To get all fields please pass 'all'", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="Authorization", value="Bearer {token} \n Get your token/Api Key form user profile ", paramType="header"), @ApiImplicitParam(name="startAt", example="1", value=" Start At as a way to navigate through a long list of risk register and user can pass it's value.By default it is set to '0'", required=false, dataType="int", paramType="query"), @ApiImplicitParam(name="pageLimit", example="10", value=" Page limit is like setting a boundary on how many risk register you want to see at once. It's like saying, 'I only want to see 10 (or any number you choose) things on a page. By default it is set to 50 and you can't pass a value higher then 50.", required=false, dataType="int", paramType="query")})
    @RequestMapping(method={RequestMethod.GET}, path={"/risk/{riskid}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getRiskByRiskId(@ApiParam(name="riskid", example="", allowMultiple=false, type="String", value="For Risk please send the risk Id", required=true) @PathVariable(value="riskid") String riskid, HttpServletRequest request) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            return new ResponseEntity((Object)this.riskAPIService.getRiskById(riskid, request.getParameter("fields"), request.getParameter("expand")), HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/dependencies/{programboardid}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getDependenciesByProgramBoardId(@PathVariable(value="programboardid") String programboardid, HttpServletRequest request) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        try {
            return new ResponseEntity((Object)this.dependencyAPIService.getSessionDependencies(programboardid, request.getParameter("fields"), request.getParameter("expand")), HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("error", "There are some issues in fetching data.");
            LOGGER.error("Error occurred while fetching work spaces meta by api key -> ", (Throwable)e);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            Integer.parseInt(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @GetMapping(value={"/me"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Object> getMe() {
        return new ResponseEntity(HttpStatus.OK);
    }
}

