/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.dto.WorkSpaceLinksGroupDTO;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.WorkSpaceLinksGroupService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/workspace/group"})
@RestController
public class WorkSpaceLinksGroupController {
    private final WorkSpaceLinksGroupService workSpaceLinksGroupService;
    private final WorkSpaceRepository workSpaceRepository;
    private final WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLinksGroupController.class);

    @Autowired
    public WorkSpaceLinksGroupController(WorkSpaceLinksGroupService workSpaceLinksGroupService, WorkSpaceRepository workSpaceRepository, WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository) {
        this.workSpaceLinksGroupService = workSpaceLinksGroupService;
        this.workSpaceRepository = workSpaceRepository;
        this.workSpaceAccessRoleRepository = workSpaceAccessRoleRepository;
    }

    @PostMapping(value={"/create"})
    @ResponseBody
    public ResponseEntity createGroup(@RequestBody WorkSpaceLinksGroupDTO group) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            WorkSpaceLinksGroupDTO workSpaceLinksGroup = this.workSpaceLinksGroupService.createGroup(group);
            responseJson.put("group", workSpaceLinksGroup);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("error", "Failed to create link due to an internal error.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get/{collectionId}"})
    @ResponseBody
    public ResponseEntity getGroupsByCollectionId(@PathVariable String collectionId) {
        HashMap responseJson = new HashMap();
        try {
            Map groups = this.workSpaceLinksGroupService.getGroupsByCollectionId(collectionId);
            responseJson.put("groups", groups);
            WorkSpace workSpace = this.workSpaceRepository.findByKey(collectionId);
            List accessRoles = new ArrayList();
            accessRoles = this.workSpaceAccessRoleRepository.findByWorkSpace(workSpace);
            if (PropertyValidator.isValid(accessRoles)) {
                workSpace.setAccessRoles(accessRoles);
            }
            responseJson.put("collection", workSpace);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PutMapping(value={"/update"})
    @ResponseBody
    public ResponseEntity updateGroup(@RequestBody WorkSpaceLinksGroupDTO group) {
        HashMap<String, WorkSpaceLinksGroupDTO> responseJson = new HashMap<String, WorkSpaceLinksGroupDTO>();
        try {
            WorkSpaceLinksGroupDTO updatedGroup = this.workSpaceLinksGroupService.updateGroup(group);
            responseJson.put("group", updatedGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{groupId}"})
    @ResponseBody
    public ResponseEntity deleteGroup(@PathVariable String groupId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            boolean success = this.workSpaceLinksGroupService.deleteGroup(groupId);
            responseJson.put("success", success);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/share/{groupId}"})
    @ResponseBody
    public ResponseEntity shareGroup(@PathVariable String groupId, @RequestBody Map payload) {
        HashMap<String, WorkSpaceLinksGroupDTO> responseJson = new HashMap<String, WorkSpaceLinksGroupDTO>();
        try {
            WorkSpaceLinksGroupDTO group = this.workSpaceLinksGroupService.shareGroup(groupId, payload);
            responseJson.put("group", group);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/duplicate/{groupId}"})
    @ResponseBody
    public ResponseEntity duplicateGroup(@PathVariable String groupId, @RequestBody WorkSpaceLinksGroupDTO payload) {
        HashMap<String, WorkSpaceLinksGroupDTO> responseJson = new HashMap<String, WorkSpaceLinksGroupDTO>();
        try {
            WorkSpaceLinksGroupDTO group = this.workSpaceLinksGroupService.duplicateGroup(groupId, payload);
            responseJson.put("group", group);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }
}

