/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.dto.WorkSpaceLinkDTO;
import com.viztrend.safe.service.WorkSpaceLinkService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/workspace/link"})
@RestController
public class WorkSpaceLinkController {
    private final WorkSpaceLinkService workSpaceLinkService;
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkSpaceLinkController.class);

    @Autowired
    public WorkSpaceLinkController(WorkSpaceLinkService workSpaceLinkService) {
        this.workSpaceLinkService = workSpaceLinkService;
    }

    @PostMapping(value={"/create/{groupId}"})
    @ResponseBody
    public ResponseEntity createLink(@PathVariable String groupId, @RequestBody WorkSpaceLinkDTO linkData) {
        HashMap<String, WorkSpaceLinkDTO> responseJson = new HashMap<String, WorkSpaceLinkDTO>();
        try {
            WorkSpaceLinkDTO workSpaceLink = this.workSpaceLinkService.createLink(groupId, linkData);
            responseJson.put("link", workSpaceLink);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @PutMapping(value={"/update/{linkId}"})
    @ResponseBody
    public ResponseEntity updateLink(@PathVariable String linkId, @RequestBody WorkSpaceLinkDTO linkData) {
        HashMap<String, WorkSpaceLinkDTO> responseJson = new HashMap<String, WorkSpaceLinkDTO>();
        try {
            WorkSpaceLinkDTO workSpaceLink = this.workSpaceLinkService.updateLink(linkId, linkData);
            responseJson.put("link", workSpaceLink);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @DeleteMapping(value={"/delete/{linkId}"})
    @ResponseBody
    public ResponseEntity deleteLink(@PathVariable String linkId) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            boolean success = this.workSpaceLinkService.deleteLink(linkId);
            responseJson.put("success", success);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/move/{sourceGroupId}/{destinationGroupId}"})
    @ResponseBody
    public ResponseEntity moveLink(@PathVariable String sourceGroupId, @PathVariable String destinationGroupId, @RequestBody Map<String, String> requestBody) {
        String linkId = requestBody.get("linkId");
        boolean success = false;
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            if (PropertyValidator.isValid((Object)linkId)) {
                success = this.workSpaceLinkService.moveLink(sourceGroupId, destinationGroupId, linkId);
                responseJson.put("success", success);
            }
        }
        catch (Exception e) {
            responseJson.put("success", false);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/copy"})
    @ResponseBody
    public ResponseEntity copyLinkToMultipleGroups(@RequestBody Map<String, Object> requestBody) {
        String linkId = (String)requestBody.get("linkId");
        List destinationGroupIds = (List)requestBody.get("destinationGroupIds");
        Map copiedLinks = new HashMap();
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            if (PropertyValidator.isValid((Object)linkId) && destinationGroupIds != null && !destinationGroupIds.isEmpty()) {
                copiedLinks = this.workSpaceLinkService.copyLinkToMultipleGroups(destinationGroupIds, linkId);
                responseJson.put("success", Boolean.valueOf(true));
                responseJson.put("links", (Serializable)((Object)copiedLinks));
            }
        }
        catch (Exception e) {
            responseJson.put("success", Boolean.valueOf(false));
            responseJson.put("links", (Serializable)((Object)copiedLinks));
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/update-sequence/{groupId}"})
    @ResponseBody
    public ResponseEntity<Object> updateLinkSequence(@PathVariable String groupId, @RequestBody Map<String, Object> requestBody) {
        try {
            Map responseJson = this.workSpaceLinkService.updateSequence(groupId, requestBody);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("sequences", responseJson);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Failed to update link sequence");
            return new ResponseEntity(errorResponse, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/group/update-sequence/{collectionKey}"})
    @ResponseBody
    public ResponseEntity<Object> updateGroupSequence(@PathVariable String collectionKey, @RequestBody Map<String, Object> requestBody) {
        try {
            Map responseJson = this.workSpaceLinkService.updateGroupSequence(collectionKey, requestBody);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("sequences", responseJson);
            return new ResponseEntity(response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Failed to update group sequence");
            return new ResponseEntity(errorResponse, HttpStatus.BAD_REQUEST);
        }
    }
}

