/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.TimeSeriesDTO;
import com.viztrend.safe.service.TimeSeriesService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/timeSeriesLog"})
@RestController
public class TimeSeriesLogController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesLogController.class);
    private final TimeSeriesService timeSeriesService;

    @Autowired
    public TimeSeriesLogController(TimeSeriesService timeSeriesService) {
        this.timeSeriesService = timeSeriesService;
    }

    @RequestMapping(value={"/chart"})
    public List<TimeSeriesDTO> getChartDataFromDateRangeAndType(@RequestBody TimeSeriesDTO req) {
        try {
            Map queryData = req.getChartOptions();
            Map queryValue = req.getQueryDataIds();
            TimeSeriesDTO.ChartType chartType = TimeSeriesDTO.ChartType.fromValue((String)((String)queryData.get("type")));
            TimeSeriesDTO.Interval interval = TimeSeriesDTO.Interval.fromValue((String)((String)queryData.get("interval")));
            if (PropertyValidator.isValid((Object)queryValue)) {
                return this.timeSeriesService.createDataForAreaChart(req.getStartDate(), req.getEndDate(), req.getTenant(), chartType, interval, (List)queryValue.get("ids"));
            }
            return new ArrayList<TimeSeriesDTO>();
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ArrayList<TimeSeriesDTO>();
        }
    }

    @RequestMapping(value={"/flowtime/chart"})
    public Map<Long, Integer> getFlowTimeChart(@RequestBody TimeSeriesDTO req) {
        try {
            Map queryValueMap;
            List queryValue;
            Map queryData = req.getChartOptions();
            int interval = 10;
            if (PropertyValidator.isValid(queryData.get("interval"))) {
                interval = Integer.parseInt((String)queryData.get("interval"));
            }
            if (PropertyValidator.isValid((Collection)(queryValue = (List)(queryValueMap = req.getQueryDataIds()).get("statusId")))) {
                return this.timeSeriesService.createDataForFlowChart(req.getStartDate(), req.getEndDate(), req.getTenant(), (String)queryValue.get(0), (String)queryValue.get(1), interval);
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/itemStatus/chart"})
    public List<Map<String, List<Long>>> getItemStatusStackedBarChart(@RequestBody TimeSeriesDTO req) {
        try {
            Map queryValueMap = req.getQueryDataIds();
            List itemIds = (List)queryValueMap.get("itemId");
            List statusIds = (List)queryValueMap.get("statusId");
            if (PropertyValidator.isValid((Collection)itemIds) && PropertyValidator.isValid((Collection)statusIds)) {
                List result = this.timeSeriesService.createDataForStackedStatusChart(req.getStartDate(), req.getEndDate(), req.getTenant(), itemIds, statusIds);
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }
}

