/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.service.TimeSeriesInfoService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/timeSeries"})
@RestController
public class TimeSeriesInfoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeSeriesInfoController.class);
    private final TimeSeriesInfoService timeSeriesInfoService;

    public TimeSeriesInfoController(TimeSeriesInfoService timeSeriesInfoService) {
        this.timeSeriesInfoService = timeSeriesInfoService;
    }

    @GetMapping(value={"/items"})
    public Map<String, List<TimeSeriesLog>> fetchItemsData(@RequestParam String startDate, String endDate, String sessionId, String sessionBoardId) {
        HashMap<String, List<TimeSeriesLog>> resultMap = new HashMap();
        try {
            resultMap = this.timeSeriesInfoService.fetchItemsData(startDate, endDate, sessionId, sessionBoardId);
        }
        catch (Exception ex) {
            LOGGER.error("Error while fetching items data: {}", (Object)StringUtils.getTraceString((Throwable)ex));
        }
        return resultMap;
    }
}

