/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.controller.TimeCapsuleController;
import com.viztrend.safe.persistence.entity.TimeCapsule;
import com.viztrend.safe.service.TimeCapsuleService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/time-capsule"})
@RestController
public class TimeCapsuleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeCapsuleController.class);
    @Autowired
    private TimeCapsuleService timeCapsuleService;

    @RequestMapping(value={"/get-time-capsules"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getTimeCapsules() {
        LOGGER.info("Getting time capsules");
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            List timeCapsules = this.timeCapsuleService.getTimeCapsules();
            responseJson.put("timeCapsules", timeCapsules);
        }
        catch (Exception e) {
            LOGGER.error("Error while getting time capsules", (Throwable)e);
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/timecapsule/sequence"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateTimeCapsuleSequence(@RequestBody String payload) {
        try {
            Gson g = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
            return this.timeCapsuleService.updateSequence(requestBody);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    @RequestMapping(value={"/add/timecapsule"}, method={RequestMethod.POST})
    public ResponseEntity<Object> addTimeCapsule(@RequestBody Map<String, Object> requestJson) {
        HashMap responseJson = new HashMap();
        try {
            TimeCapsule timeCapsule = new TimeCapsule((String)requestJson.get("label"), (String)requestJson.get("textColor"), (String)requestJson.get("bgColor"), new Date((Long)requestJson.get("startDate")), new Date((Long)requestJson.get("endDate")));
            return new ResponseEntity((Object)this.timeCapsuleService.addTimeCapsule(timeCapsule), HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/save/edited-timecapsules"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveEditedTimeCapsules(@RequestBody Map<String, Object> requestJson) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List editedTimeCapsuleMap = (List)requestJson.get("editedTimeCapsules");
            ArrayList<TimeCapsule> timeCapsilesTosave = new ArrayList<TimeCapsule>();
            for (Map timeCapsuleMap : editedTimeCapsuleMap) {
                TimeCapsule timeCapsule = new TimeCapsule((String)timeCapsuleMap.get("id"), (String)timeCapsuleMap.get("label"), (String)timeCapsuleMap.get("textColor"), (String)timeCapsuleMap.get("bgColor"), new Date((Long)timeCapsuleMap.get("startDate")), new Date((Long)timeCapsuleMap.get("endDate")));
                TimeCapsule latestTimeCapsule = this.timeCapsuleService.getTimeCapsule(timeCapsule.getId());
                if (!PropertyValidator.isValid((Object)latestTimeCapsule)) continue;
                latestTimeCapsule.setLabel(timeCapsule.getLabel());
                latestTimeCapsule.setTextColor(timeCapsule.getTextColor());
                latestTimeCapsule.setBgColor(timeCapsule.getBgColor());
                latestTimeCapsule.setStartDate(timeCapsule.getStartDate());
                latestTimeCapsule.setEndDate(timeCapsule.getEndDate());
                timeCapsilesTosave.add(latestTimeCapsule);
            }
            if (PropertyValidator.isValid(timeCapsilesTosave)) {
                this.timeCapsuleService.saveEditedTimeCapsules(timeCapsilesTosave);
            }
            responseJson.put("status", "success");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            responseJson.put("kendisError", ex);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/delete/timecapsule/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteTimeCapsule(@PathVariable String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            this.timeCapsuleService.deleteTimeCapsule(id);
            responseJson.put("status", "success");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            responseJson.put("kendisError", ex);
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

