/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.SolutionArea;
import com.viztrend.safe.service.SolutionAreaService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/solutionarea"})
@RestController
public class SolutionAreaController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionAreaController.class);
    @Autowired
    private SolutionAreaService solutionAreaService;

    @RequestMapping(value={"/getSolutionAreasAndCollections"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSolutionAreasAndCollections() {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getSolutionAreasAndCollections(null);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSolutionForCollection/{collectionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSolutionForCollection(@PathVariable(value="collectionId") String collectionId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getSolutionForCollection(collectionId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/sortListingItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> sortListingItem(@RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.sortListingItem(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSolutionBoards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSolutionBoards(@RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getSolutionBoards(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getCollectionTags"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getCollectionTags(@RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getCollectionTags(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSessionTags"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSessionTags(@RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getSessionTags(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/solutionArea/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveSolutionArea(@RequestBody SolutionArea solutionArea) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.saveSolutionArea(solutionArea);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/solutionArea/delete/{solutionAreaId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> deleteSolutionArea(@PathVariable(value="solutionAreaId") String solutionAreaId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.deleteSolutionArea(solutionAreaId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/solutionBoardMoveTo"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> solutionBoardMoveTo(@RequestBody Map<String, String> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.solutionBoardMoveTo(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSolutionBoards/solArea/collections"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSolutionBoardsBySolutionAreaAndCollections(@RequestBody Map<String, Object> payload) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.solutionAreaService.getSolutionBoardsBySolutionAreaAndCollections(payload);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }
}

