/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.api.dto.RoadmapSectionDTO;
import com.viztrend.safe.api.dto.SequenceManagerDTO;
import com.viztrend.safe.persistence.repository.RoadmapSectionRepository;
import com.viztrend.safe.service.RoadmapSectionService;
import com.viztrend.safe.utils.StringUtils;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roadmap-section"})
public class RoadmapSectionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RoadmapSectionController.class);
    private final RoadmapSectionService roadmapSectionService;

    @Autowired
    public RoadmapSectionController(RoadmapSectionService roadmapSectionService, RoadmapSectionRepository roadmapSectionRepository) {
        this.roadmapSectionService = roadmapSectionService;
    }

    @GetMapping(value={"/get-roadmap-sections"})
    public ResponseEntity<Object> getRoadmapSections(@RequestParam String roadmapId) {
        LOGGER.info("Getting roadmap sections");
        try {
            List roadmapSections = this.roadmapSectionService.getRoadmapSections(roadmapId);
            return new ResponseEntity((Object)roadmapSections, HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while getting roadmap sections " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PutMapping(value={"/add-default-roadmap-section"})
    public ResponseEntity<Object> addDefaultRoadmapSection(@RequestParam String roadmapId) {
        LOGGER.info("Adding default roadmap section");
        try {
            this.roadmapSectionService.createDefaultSection(roadmapId);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while adding default roadmap section " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/add-roadmap-section-at-last"})
    public ResponseEntity<Object> addRoadmapSectionAtEnd(@RequestBody @Valid RoadmapSectionDTO roadmapSection) {
        LOGGER.info("Adding roadmap section");
        try {
            return new ResponseEntity(this.roadmapSectionService.addRoadmapSectionAtLast(roadmapSection.cloneToEntity()), HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while adding roadmap section " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/add-roadmap-section"})
    public ResponseEntity<Object> addRoadmapSection(@RequestBody @Valid RoadmapSectionDTO roadmapSection) {
        LOGGER.info("Adding roadmap section");
        try {
            return new ResponseEntity((Object)this.roadmapSectionService.addRoadmapSection(roadmapSection.cloneToEntity()), HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while adding roadmap section " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PatchMapping(value={"/update-roadmap-section"})
    public ResponseEntity<Object> updateRoadmapSection(@RequestBody @Valid RoadmapSectionDTO roadmapSection) {
        LOGGER.info("Updating roadmap section");
        try {
            return new ResponseEntity((Object)this.roadmapSectionService.updateRoadmapSection(roadmapSection), HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while updating roadmap section " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @DeleteMapping(value={"/delete-roadmap-section"})
    public ResponseEntity<Object> deleteRoadmapSection(@RequestParam String roadmapSectionId) {
        LOGGER.info("Deleting roadmap section");
        try {
            this.roadmapSectionService.deleteRoadmapSection(roadmapSectionId);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while deleting roadmap section " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PatchMapping(value={"/update-roadmap-section-sequence"})
    public ResponseEntity<Object> updateRoadmapSectionSequence(@RequestBody @Valid SequenceManagerDTO sequenceManagerDTO) {
        LOGGER.info("Updating roadmap section sequence");
        try {
            return new ResponseEntity((Object)this.roadmapSectionService.updateRoadmapSectionSequence(sequenceManagerDTO), HttpStatus.OK);
        }
        catch (Exception exception) {
            LOGGER.error("Error while updating roadmap section sequence " + StringUtils.getTraceString((Throwable)exception));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

