/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.service.RoadmapService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/roadmap"})
@Controller
public class RoadmapController {
    @Autowired
    private RoadmapService roadmapService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoadmapController.class);

    @RequestMapping(value={"/items/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> roadMapData(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestBody) {
        HashMap response = new HashMap();
        response = this.roadmapService.getroadMapBoardData(sessionId, (String)requestBody.get("requestId"));
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @RequestMapping(value={"/unlink-backlog-item-from-board"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<Object> unlinkBacklogItemFromBoard(@RequestBody Map<String, Object> requestBody) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            String boardId = (String)requestBody.get("boardId");
            String artId = (String)requestBody.get("artId");
            List backlogItemsIds = (List)requestBody.get("backlogItemsIds");
            if (this.roadmapService.unlinkBacklogItemsFromBoard(boardId, artId, backlogItemsIds)) {
                response.put("message", "Backlog items unlinked successfully");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error unlinking backlog items from board", (Throwable)e);
            response.put("message", "Error unlinking backlog items from board");
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/smart-report/items/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> roadMapDataForSmartReport(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestBody) {
        Map response = this.roadmapService.getRoadMapDataForSmartReport(sessionId, (String)requestBody.get("requestId"));
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PostMapping(value={"/create-timeseries-data-roadmaps"})
    @ResponseBody
    public ResponseEntity<Object> createTimeSeriesDataRoadMaps(@RequestBody Map<String, Object> requestBody) {
        Map<String, Boolean> response = new HashMap();
        try {
            response = this.roadmapService.createDataForRoadmapsProgress(requestBody);
        }
        catch (Exception e) {
            LOGGER.error("Error creating timeSeries data for roadmaps: {}", (Object)StringUtils.getTraceString((Throwable)e));
            response.put("errorCase", true);
            return new ResponseEntity(response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }
}

