/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.controller.RiskRegistersController;
import com.viztrend.safe.enums.EnumEmailConfig;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.ConfigAndMapping;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.FieldEntity;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.persistence.entity.Group;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.Notification;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.RiskLevel;
import com.viztrend.safe.persistence.entity.RiskMatrix;
import com.viztrend.safe.persistence.entity.RiskMatrixCoordinate;
import com.viztrend.safe.persistence.entity.RiskRegister;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAttributes;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.Watcher;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ConfigAndMappingRepository;
import com.viztrend.safe.persistence.repository.ConversationAttachmentRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.ExternalLinkRepository;
import com.viztrend.safe.persistence.repository.FieldsRepository;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.RiskImpactRepository;
import com.viztrend.safe.persistence.repository.RiskMatrixRepository;
import com.viztrend.safe.persistence.repository.RiskProbabilityRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.RiskStatusRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.RiskRegisterService;
import com.viztrend.safe.service.TFSRiskService;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.BusinessToVOUtils;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.BoardVO;
import com.viztrend.safe.vos.ItemSessionBoardVO;
import com.viztrend.safe.vos.ItemVO;
import com.viztrend.safe.vos.RiskColumnVO;
import com.viztrend.safe.vos.RiskColumnsVO;
import com.viztrend.safe.vos.RiskLevelVO;
import com.viztrend.safe.vos.RiskVO;
import com.viztrend.safe.vos.SessionVO;
import com.viztrend.safe.vos.SolutionBoardVO;
import com.viztrend.safe.vos.StatusVO;
import com.viztrend.safe.vos.TeamContainerVO;
import com.viztrend.safe.vos.WorkSpaceVO;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

@RequestMapping(value={"/riskregister"})
@Controller
public class RiskRegistersController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RiskRegistersController.class);
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private RiskProbabilityRepository riskProbabilityRepository;
    @Autowired
    private RiskImpactRepository riskImpactRepository;
    @Autowired
    private RiskStatusRepository riskStatusRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private ConversationAttachmentRepository conversationAttachmentRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private GroupRepository groupRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private RiskMatrixRepository riskMatrixRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private ExternalLinkRepository externalLinkRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ExportService exportService;
    @Autowired
    private Environment env;
    @Autowired
    private UserService userService;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private PlanService planService;
    @Autowired
    private TFSRiskService tfsRiskService;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private FieldsRepository fieldsRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private RiskRegisterService riskRegisterService;
    private ConfigAndMappingRepository configAndMappingRepository;

    private List<String> replaceString(List<String> linkedItemIds, String oldId, String newId) {
        int i = 0;
        for (String itemId : linkedItemIds) {
            if (itemId.equals(oldId)) {
                linkedItemIds.set(i, newId);
            }
            ++i;
        }
        return linkedItemIds;
    }

    private List<Item> setActiveBoardItems(Risk risk, List<Session> sessions, Map<String, Object> externalIds, Map<String, Item> externalItemsMap, List<SolutionBoard> solutionBoards) {
        ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
        ArrayList<String> activeSessionBoardIdsStrings = new ArrayList<String>();
        if (PropertyValidator.isValid(sessions)) {
            for (Session s : sessions) {
                activeSessionBoardIdsStrings.add(s.getActiveSessionBoard());
                activeSessionBoardIds.add(new ObjectId(s.getActiveSessionBoard()));
            }
        }
        ArrayList<ObjectId> solutionBoardIds = new ArrayList<ObjectId>();
        ArrayList<String> solutionBoardIdsStrings = new ArrayList<String>();
        if (PropertyValidator.isValid(solutionBoards)) {
            for (SolutionBoard s : solutionBoards) {
                solutionBoardIds.add(new ObjectId(s.getId()));
                solutionBoardIdsStrings.add(s.getId());
            }
        }
        List objectIds = KendisUtils.getListAsObjectIds((Collection)risk.getLinkedItemsIds());
        if (externalIds == null) {
            externalIds = new HashMap<String, Object>();
        }
        if (PropertyValidator.isValid((Collection)risk.getLinkedItemsIds())) {
            BasicDBObject matchQuery = this.createMatchQueryUsingIdAndSessionBoardIds(objectIds, risk.getLinkedItemsIds(), activeSessionBoardIds, solutionBoardIds);
            List itemList = this.findItemsByQuery(matchQuery);
            if (PropertyValidator.isValid((Collection)itemList)) {
                ArrayList<String> itemIds = new ArrayList<String>();
                risk.setLinkedItemsIds(itemIds);
                risk.setLinkedItems(itemList);
                for (Item item : itemList) {
                    itemIds.add(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        String externalLink = this.getItemLink(item);
                        item.setExternalReferenceURL(externalLink);
                    }
                    if (externalIds != null) {
                        externalIds.put(item.getId(), this.toSimpleObject(item));
                    }
                    if (externalItemsMap == null || risk.getLinkedItemsById() == null) continue;
                    risk.getLinkedItemsById().remove(item.getId());
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        externalItemsMap.put(item.getJiraKey(), item);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)item.getTfsId())) continue;
                    externalItemsMap.put(item.getTfsId(), item);
                }
            } else {
                risk.setLinkedItemsIds(new ArrayList());
            }
        }
        if (risk.getLinkedItems() == null) {
            risk.setLinkedItems(new ArrayList());
            risk.setLinkedItemsIds(new ArrayList());
        }
        if (externalItemsMap != null && risk.getLinkedItemsById() != null) {
            Set ids = risk.getLinkedItemsById().keySet();
            ArrayList<String> keys = new ArrayList<String>();
            HashMap<String, String> idByKey = new HashMap<String, String>();
            for (String id : ids) {
                Map obj = (Map)risk.getLinkedItemsById().get(id);
                String localId = (String)obj.get("localId");
                if (PropertyValidator.isValid((Object)localId)) continue;
                String key = (String)obj.get("key");
                idByKey.put(key + "_" + (String)obj.get("session_id"), id);
                keys.add(key);
            }
            BasicDBObject matchQuery = this.createMatchQueryUsingJiraTfsKeyAndSessionBoardIds(keys, activeSessionBoardIds, objectIds);
            List itemList = this.findItemsByQuery(matchQuery);
            if (PropertyValidator.isValid((Collection)itemList)) {
                for (Item item : itemList) {
                    String externalLink = this.getItemLink(item);
                    item.setExternalReferenceURL(externalLink);
                    if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) continue;
                    String sId = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                    if (PropertyValidator.isValid((Object)item.getJiraId())) {
                        if (idByKey.containsKey(item.getJiraKey() + "_" + sId)) {
                            risk.getLinkedItemsById().remove(idByKey.get(item.getJiraKey() + "_" + sId));
                        }
                    } else if (PropertyValidator.isValid((Object)item.getTfsId()) && idByKey.containsKey(item.getTfsId() + "_" + sId)) {
                        risk.getLinkedItemsById().remove(idByKey.get(item.getTfsId() + "_" + sId));
                    }
                    if (externalIds.containsKey(item.getId())) continue;
                    risk.getLinkedItems().add(item);
                    risk.getLinkedItemsIds().add(item.getId());
                }
            }
            if (PropertyValidator.isValid(ids = risk.getLinkedItemsById().keySet())) {
                risk.getLinkedItemsIds().addAll(ids);
            }
        }
        this.setRiskTfsItems(risk, activeSessionBoardIdsStrings, solutionBoardIdsStrings);
        return risk.getLinkedItems();
    }

    private List<RiskRegister> markOwner(List<RiskRegister> riskRegisters) {
        for (RiskRegister riskRegister : riskRegisters) {
            User owner;
            String userName = riskRegister.getCreatedBy();
            if (userName == null) {
                userName = riskRegister.getUpdatedBy();
            }
            if (userName == null || (owner = this.userRepository.findByUserName(userName)) == null) continue;
            riskRegister.setOwnerName(owner.getFullName());
        }
        return riskRegisters;
    }

    @RequestMapping(value={"/get-all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAllRiskRegisters() {
        List riskMatrices;
        List workFlows;
        HashMap<String, List> risksMap = new HashMap<String, List>();
        LinkedList<BasicDBObject> companyUsers = new LinkedList<BasicDBObject>();
        List usersAll = this.customRepositoryImpl.findByUserCompanies_Company_Id(UserContextUtil.getUserContext().getCurrentCompany().getId());
        List nonKendisUsers = this.customRepositoryImpl.findByTenantAndUserTypeNotAndArchiveFalseAndRowStatus(UserContextUtil.getUserContext().getCurrentCompany().getTenant(), User.UserType.KENDIS.toString());
        for (BasicDBObject user : usersAll) {
            companyUsers.add(user);
        }
        if (PropertyValidator.isValid((Collection)nonKendisUsers)) {
            companyUsers.addAll(nonKendisUsers);
        }
        if ((workFlows = this.workFlowRepository.findAllByWorkflowType("Risk")).size() == 0) {
            this.createWorkFlow();
            workFlows = this.workFlowRepository.findAllByWorkflowType("Risk");
        }
        if ((riskMatrices = this.riskMatrixRepository.findAll()).size() == 0) {
            this.createRiskMatrix();
            riskMatrices = this.riskMatrixRepository.findAll();
        }
        risksMap.put("users", companyUsers);
        List statuses = null;
        for (WorkFlow workFlow : workFlows) {
            statuses = this.statusRepository.findByWorkFlow(workFlow);
            workFlow.setStatuses(KendisUtils.sortStatuses((List)statuses, (String)workFlow.getStatusSequence()));
        }
        risksMap.put("workFlows", workFlows);
        risksMap.put("riskMatrices", riskMatrices);
        return new ResponseEntity(risksMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-registers"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisters() {
        List riskRegisters = this.riskRegisterRepository.findAll();
        this.markOwner(riskRegisters);
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        for (RiskRegister register : riskRegisters) {
            if (PropertyValidator.isValid((Collection)register.getFavoriteOfUsers())) {
                int index = register.getFavoriteOfUsers().indexOf(loggedInUser.getId());
                if (index > -1) {
                    register.setFavoriteOfCurrentUser(true);
                    continue;
                }
                register.setFavoriteOfCurrentUser(false);
                continue;
            }
            register.setFavoriteOfCurrentUser(false);
        }
        return new ResponseEntity((Object)riskRegisters, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-registers-optimised"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegistersOptimised() {
        List riskRegisters = this.riskRegisterRepository.findRegistersByArchive(false);
        return new ResponseEntity((Object)riskRegisters, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-archived-registers"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getArchivedRiskRegisters() {
        List riskRegisters = this.riskRegisterRepository.findByArchive(true);
        this.markOwner(riskRegisters);
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        for (RiskRegister register : riskRegisters) {
            if (PropertyValidator.isValid((Collection)register.getFavoriteOfUsers())) {
                int index = register.getFavoriteOfUsers().indexOf(loggedInUser.getId());
                if (index > -1) {
                    register.setFavoriteOfCurrentUser(true);
                    continue;
                }
                register.setFavoriteOfCurrentUser(false);
                continue;
            }
            register.setFavoriteOfCurrentUser(false);
        }
        return new ResponseEntity((Object)riskRegisters, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-details-session/{riskRegisterId}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisterDetailsForSession(@PathVariable String riskRegisterId, @PathVariable String sessionBoardId) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Map risksMap = this.getDetails(riskRegisterId, Arrays.asList(sessionBoard.getSession().getId().split("\\s*,\\s*")), null, null);
        List riskList = (List)risksMap.get("riskList");
        risksMap.put("riskList", riskList);
        return new ResponseEntity((Object)risksMap, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-details/{riskRegisterId}/{sessionId}/{viewtype}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskRegisterDetails(@PathVariable(value="riskRegisterId") String riskRegisterId, @PathVariable(name="sessionId", required=false) String sessionId, @PathVariable(name="viewtype", required=false) String viewtype) {
        try {
            List sessionIdsList = null;
            Map risksMap = this.getDetails(riskRegisterId, sessionIdsList, sessionId, viewtype);
            return new ResponseEntity((Object)risksMap, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private Map<String, Object> getDetails(String riskRegisterId, List<String> sessionIdsList, String sessionId, String viewtype) {
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List riskList = PropertyValidator.isValid((Object)viewtype) ? (viewtype.equalsIgnoreCase("sessionBoard") || viewtype.equalsIgnoreCase("statsView") ? this.customRepositoryImpl.findRiskByLinkedSessionId(sessionId, riskRegisterId) : (viewtype.equalsIgnoreCase("solutionBoard") ? this.customRepositoryImpl.findRiskByLinkedSolutionBoardId(sessionId, riskRegisterId) : this.customRepositoryImpl.findRiskByLinkedOrgCollection(sessionId, riskRegisterId))) : this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            return this.processRiskDetails(riskRegister, riskList, null, sessionId);
        }
        catch (Exception ex) {
            LOGGER.error("Error getting risk register details: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new HashMap<String, Object>();
        }
    }

    private Map<String, Object> processRiskDetails(RiskRegister riskRegister, List<Risk> riskList, List<Session> sessions, String sessionId) {
        HashMap<String, Object> risksMap = new HashMap<String, Object>();
        String ALL_SESSIONS_ID = "-1";
        try {
            HashMap<String, String> obj2;
            for (Risk risk : riskList) {
                if (!PropertyValidator.isValid((Object)risk)) continue;
                risk.adjustLinkedItemIds();
                Integer convCount = this.conversationRepository.countByRiskId(risk.getId());
                risk.setConversationCount(convCount);
                if (!PropertyValidator.isValid((Object)risk.getResponsible()) || PropertyValidator.isValid((Collection)risk.getResponsible().getUserCompanies())) continue;
                risk.getResponsible().setUserCompanies(new ArrayList());
            }
            risksMap.put("riskRegister", riskRegister);
            risksMap.put("riskList", riskList);
            if (PropertyValidator.isValid((Object)riskRegister) && !PropertyValidator.isValid((Object)riskRegister.getLayout())) {
                risksMap.put("defaultLayout", this.customFieldService.getDefaultLayoutFromItemType(EnumKendis.RISK.getCode()));
            }
            if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)sessionId)) {
                List linkedSessions = this.customRepositoryImpl.findSessionsByRiskRegisterId(riskRegister.getId());
                ArrayList sessionMap = new ArrayList();
                if (PropertyValidator.isValid((Collection)linkedSessions)) {
                    for (Session obj : linkedSessions) {
                        obj2 = new HashMap<String, String>();
                        obj2.put("id", obj.getId());
                        obj2.put("title", obj.getTitle());
                        sessionMap.add(obj2);
                    }
                    risksMap.put("linkedSessions", sessionMap);
                    if (sessionId.equals(ALL_SESSIONS_ID)) {
                        risksMap.put("linkedTeamsAndContainers", this.customRepositoryImpl.fetchTeamsAndContainersFromSessions(linkedSessions));
                    }
                }
            }
            if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)sessionId)) {
                List linkedSolutionBoards = this.customRepositoryImpl.findSolutionBoardsByRiskRegisterId(riskRegister.getId());
                ArrayList solutionMap = new ArrayList();
                if (PropertyValidator.isValid((Collection)linkedSolutionBoards)) {
                    for (Session obj : linkedSolutionBoards) {
                        obj2 = new HashMap();
                        obj2.put("id", obj.getId());
                        obj2.put("title", obj.getTitle());
                        obj2.put("name", obj.getTitle());
                        solutionMap.add(obj2);
                    }
                    risksMap.put("linkedSolutionBoards", solutionMap);
                }
            }
            if (PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)sessionId)) {
                List linkedOrgCollections = this.customRepositoryImpl.findOrgCollectionByRiskRegisterId(riskRegister.getId());
                ArrayList orgCollectionMap = new ArrayList();
                if (PropertyValidator.isValid((Collection)linkedOrgCollections)) {
                    for (Session obj : linkedOrgCollections) {
                        obj2 = new HashMap();
                        obj2.put("id", obj.getId());
                        obj2.put("title", obj.getTitle());
                        orgCollectionMap.add(obj2);
                    }
                    risksMap.put("linkedOrgCollections", orgCollectionMap);
                }
            }
            return risksMap;
        }
        catch (Exception ex) {
            LOGGER.error("Error processing risk details: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new HashMap<String, Object>();
        }
    }

    @RequestMapping(value={"/save/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRiskRegister(@PathVariable(value="id") String id, @RequestBody RiskRegister riskRegister) {
        Boolean linkWithOrg = false;
        try {
            if (!PropertyValidator.isValid((Object)riskRegister.getId()) && !id.equalsIgnoreCase("-1")) {
                linkWithOrg = true;
            }
            RiskRegister updatedRiskRegister = this.riskRegisterService.saveRiskRegister(riskRegister);
            if (linkWithOrg.booleanValue()) {
                this.riskRegisterService.linkWithOrg(id, updatedRiskRegister);
            }
            return new ResponseEntity((Object)updatedRiskRegister, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteRiskRegister(@RequestBody String registerId) {
        try {
            if (this.customRepositoryImpl.isRiskRegisterLinkedToAnyBoard(registerId)) {
                return new ResponseEntity((Object)"-1", HttpStatus.OK);
            }
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)registerId));
            riskRegister.setArchive(true);
            this.riskRegisterRepository.save((Object)riskRegister);
            return new ResponseEntity((Object)registerId, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error("Error deleting risk register: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)"Error occurred while deleting risk register", HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/unarchived"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unArchivedRiskRegister(@RequestBody String registerId) {
        RiskRegister riskRegister = this.riskRegisterRepository.findOneByIdAndArchive(registerId, true);
        if (PropertyValidator.isValid((Object)riskRegister)) {
            riskRegister.setArchive(false);
            this.riskRegisterRepository.save((Object)riskRegister);
        }
        return new ResponseEntity((Object)registerId, HttpStatus.OK);
    }

    @RequestMapping(value={"/getRisksByItemId/{id}"})
    @ResponseBody
    public ResponseEntity<?> getRisksByFeatureId(@PathVariable(value="id") String id) {
        List risksList = this.riskRepository.findRisksBylinkedItemsIdsIn(id);
        ArrayList RiskList = new ArrayList();
        boolean index = false;
        for (Risk risks : risksList) {
            HashMap<String, Risk> risk = new HashMap<String, Risk>();
            List sessions = this.sessionRepository.findByRiskRegisterId(risks.getRiskRegister().getId());
            List solBoards = this.customRepositoryImpl.findSolutionBoardsByRiskRegisterId(risks.getRiskRegister().getId());
            this.setActiveBoardItems(risks, sessions, null, null, solBoards);
            risk.put("risk", risks);
            RiskList.add(risk);
        }
        return new ResponseEntity(RiskList, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-risk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRisk(@RequestBody Risk riskVo) {
        boolean notifyWatchers;
        1 T;
        String metaMap;
        Gson g;
        HashMap metaMapJSON;
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        Risk risk = riskVo;
        String riskId = PropertyValidator.isValid((Object)risk) ? risk.getId() : null;
        HashMap emailContentTemp = new HashMap();
        HashMap emailRecipientMap = new HashMap();
        boolean newRisk = false;
        RiskRegister riskRegister = null;
        Risk savedRisk = null;
        if (risk.getId() == null) {
            Integer lastSavedRiskNumber;
            newRisk = true;
            riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)risk.getRiskRegister().getId()));
            Integer n = lastSavedRiskNumber = riskRegister.getLastRiskIndex();
            Integer n2 = lastSavedRiskNumber = Integer.valueOf(lastSavedRiskNumber + 1);
            riskRegister.setLastRiskIndex(lastSavedRiskNumber);
            this.riskRegisterRepository.save((Object)riskRegister);
            risk.setRiskNumber(lastSavedRiskNumber);
            risk.setRiskRegister(riskRegister);
            Watcher watcher = new Watcher();
            watcher.setType("risk");
            watcher.setUser(contextUser);
            Watcher savedWatcher = (Watcher)this.watcherRepository.save((Object)watcher);
            risk.getWatcherList().add(savedWatcher);
            if (PropertyValidator.isValid((Object)risk) && PropertyValidator.isValid((Object)risk.getAppUrl()) && PropertyValidator.isValid((Object)risk.getId())) {
                risk.setAppUrl(risk.getAppUrl().replace("0000000000", risk.getId()));
            }
            savedRisk = (Risk)this.riskRepository.save((Object)risk);
        } else {
            Risk oldRisk = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
            riskRegister = oldRisk.getRiskRegister();
            oldRisk.setRiskTitle(risk.getRiskTitle());
            oldRisk.setRiskDesc(risk.getRiskDesc());
            oldRisk.setMitigationActions(risk.getMitigationActions());
            oldRisk.setImpact(risk.getImpact());
            oldRisk.setStatus(risk.getStatus());
            oldRisk.setProbability(risk.getProbability());
            oldRisk.setRaisedDate(risk.getRaisedDate());
            oldRisk.setResolutionDate(risk.getResolutionDate());
            oldRisk.setResponsible(risk.getResponsible());
            oldRisk.setBoardTeams(risk.getBoardTeams());
            oldRisk.setBoardSprints(risk.getBoardSprints());
            oldRisk.setLinkedPiBoards(risk.getLinkedPiBoards());
            oldRisk.setLinkedSolutionBoards(risk.getLinkedSolutionBoards());
            oldRisk.setLinkedOrgCollections(risk.getLinkedOrgCollections());
            if (PropertyValidator.isValid((Object)risk.getTfsAttributes())) {
                if (oldRisk.getTfsAttributes() == null) {
                    oldRisk.setTfsAttributes(new TFSAttributes());
                }
                oldRisk.getTfsAttributes().setTfsFieldMap(risk.getTfsAttributes().getTfsFieldMap());
                oldRisk.getTfsAttributes().setTfsAreaPath(risk.getTfsAttributes().getTfsAreaPath());
                oldRisk.getTfsAttributes().setTfsIterationPath(risk.getTfsAttributes().getTfsIterationPath());
                oldRisk.getTfsAttributes().setTfsItemTypeIcon(risk.getTfsAttributes().getTfsItemTypeIcon());
            }
            oldRisk.setFields(risk.getFields());
            if (PropertyValidator.isValid((Object)oldRisk) && PropertyValidator.isValid((Object)oldRisk.getAppUrl()) && PropertyValidator.isValid((Object)oldRisk.getId())) {
                oldRisk.setAppUrl(oldRisk.getAppUrl().replace("0000000000", oldRisk.getId()));
            }
            if ((emailContentTemp = this.getEmailContent(risk, oldRisk)).size() == 1 && !PropertyValidator.isValid(emailContentTemp.get("key"))) {
                emailContentTemp.remove("key");
            }
            savedRisk = (Risk)this.riskRepository.save((Object)oldRisk);
        }
        this.riskRegisterService.updateRiskRegisterLastUpdatedOnSavingRisk(riskRegister.getId(), savedRisk.getUpdatedOn());
        if (PropertyValidator.isValid((Object)savedRisk.getStatus()) && !PropertyValidator.isValid((Object)savedRisk.getStatus().getTitle())) {
            Status status = (Status)this.statusRepository.findOne((Serializable)((Object)savedRisk.getStatus().getId()));
            savedRisk.setStatus(status);
        }
        this.userService.setOnboardingMeta("ROAM_Risks", true);
        List itemList = this.itemRepository.findByIdIn(savedRisk.getLinkedItemsIds());
        savedRisk.setLinkedItems(itemList);
        Risk finalRisk = savedRisk = this.filterExternalItems(savedRisk, risk);
        RiskRegister finalRR = riskRegister;
        if (!newRisk && PropertyValidator.isValid((Object)finalRR.getConfigId())) {
            String tfsId = null;
            if (finalRisk.getTfsAttributes() != null) {
                tfsId = finalRisk.getTfsAttributes().getTfsId();
            }
            if (tfsId == null && riskVo.isSendToAlm()) {
                newRisk = true;
            }
        }
        boolean finalNewRisk = newRisk;
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)risk.getMetaMap()) && (metaMapJSON = (HashMap)(g = new Gson()).fromJson(metaMap = risk.getMetaMap(), (T = new /* Unavailable Anonymous Inner Class!! */).getType())).containsKey("requestId")) {
            String requestId = (String)metaMapJSON.get("requestId");
            parameters.put("requestId", requestId);
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        Risk oldRisk = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
        Notification notification = new Notification();
        notification.setType(Notification.ItemType.Risk);
        boolean bl = notifyWatchers = risk.getNotifyWatchers() != null && risk.getNotifyWatchers() != false;
        if (notifyWatchers) {
            this.sendEmailForRisk(notification, oldRisk, risk, savedRisk, contextUser, riskId, (Map)emailContentTemp, emailRecipientMap);
        }
        return new ResponseEntity((Object)savedRisk, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-save-tfs-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchAndSaveTFSFilter(@RequestBody Map<String, Object> request) {
        HashMap result = new HashMap();
        String itemIdsStr = (String)request.get("itemIds");
        String almId = (String)request.get("almId");
        String metaMap = (String)request.get("metaMap");
        String filterJson = (String)request.get("filter");
        String syncId = (String)request.get("syncId");
        String riskRegisterId = (String)request.get("riskRegisterId");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/add-existing-tfs-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> addExistingTfsItems(@RequestBody Map<String, Object> request) {
        HashMap result = new HashMap();
        String itemIdsStr = (String)request.get("itemIds");
        String syncId = (String)request.get("syncId");
        String riskRegisterId = (String)request.get("riskRegisterId");
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteFilter(@RequestBody Map<String, Object> request) {
        HashMap result = new HashMap();
        String riskRegisterId = (String)request.get("riskRegisterId");
        String tfsFilterId = (String)request.get("tfsFilterId");
        if (PropertyValidator.isValid((Object)tfsFilterId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("removeData", request.get("removeData"));
            try {
                result = this.tfsRiskService.removeFilter(riskRegisterId, tfsFilterId, params);
            }
            catch (Exception e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/isRiskRegisterLinkedWithAlm/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> isRiskRegisterLinkedWithAlm(@PathVariable String riskRegisterId) {
        String configId;
        ConfigAndMapping config;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", false);
        RiskRegister rr = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (PropertyValidator.isValid((Object)rr) && PropertyValidator.isValid((Object)rr.getConfigId()) && PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)(configId = rr.getConfigId()))))) && PropertyValidator.isValid((Object)config.getAlmAccount())) {
            result.put("success", true);
            result.put("almAccount", (Boolean)config.getAlmAccount());
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/resync-tfs-risk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTfsRisk(@RequestBody Map<String, Object> request) {
        HashMap result = new HashMap();
        String metaMap = (String)request.get("metaMap");
        String syncId = (String)request.get("syncId");
        String almId = (String)request.get("almId");
        String riskRegisterId = (String)request.get("riskRegisterId");
        List syncGroups = (List)request.get("syncGroups");
        Boolean readonly = (Boolean)request.get("readonly");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (readonly != null) {
            params.put("readonly", readonly);
        } else {
            params.put("readonly", Boolean.FALSE);
        }
        if (request.containsKey("dontAddRisks")) {
            params.put("dontAddRisks", request.get("dontAddRisks"));
        }
        if (request.containsKey("deleteRisks")) {
            params.put("deleteRisks", request.get("deleteRisks"));
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(result, HttpStatus.OK);
    }

    private void onBackgroundTaskCompleted(Map<String, Object> result, String syncId, String event, Boolean isComplete) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String content = mapper.writeValueAsString(result);
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Auto");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", (Object)isComplete);
            pushJson.put("requestParam", (Object)content);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            String pushJsonStr = pushJson.toString();
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJsonStr);
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJsonStr, isComplete));
            }
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    private void sendEmailForRisk(Notification notification, Risk oldRisk, Risk risk, Risk savedRisk, User contextUser, String riskId, Map<String, Object> emailContentTemp, Map<String, List<String>> emailRecipientMap) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    private void addEmailToNotification(String email, Notification notification, String type, Map<String, List<String>> emailRecipientMap) {
        if (!PropertyValidator.isValid((Object)email)) {
            return;
        }
        Set emails = notification.getEmails();
        boolean alreadyExist = false;
        for (String _em : emails) {
            if (!_em.equals(email)) continue;
            alreadyExist = true;
            break;
        }
        if (!alreadyExist) {
            emails.add(email);
            List recepientList = emailRecipientMap.getOrDefault(type, new ArrayList());
            recepientList.add(email);
            emailRecipientMap.put(type, recepientList);
        }
    }

    @RequestMapping(value={"/delete-risk/{riskId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteRisk(@PathVariable String riskId, @RequestBody String url) {
        boolean notifyWatchers;
        Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)riskId));
        boolean bl = notifyWatchers = risk.getNotifyWatchers() != null && risk.getNotifyWatchers() != false;
        if (notifyWatchers) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            Notification notification = new Notification();
            HashMap<String, String> riskContent = new HashMap<String, String>();
            riskContent.put("riskRegisterName", risk.getRiskRegister().getRegisterName());
            riskContent.put("riskId", risk.getRiskRegister().getRegisterKey() + "-" + risk.getRiskNumber());
            riskContent.put("riskTitle", risk.getRiskTitle());
            riskContent.put("url", "");
            riskContent.put("detailsHead", "Risk deleted");
            riskContent.put("details", "");
            notification.setGroupingSubject("Risk has been deleted");
            HashMap emailRecipientMap = new HashMap();
            notification.setRegisterKey(risk.getRiskRegister().getRegisterKey());
            notification.setEmailSubject("Risk has been deleted");
            notification.setDeleted(true);
            notification.setNotificationActionType(Notification.NotificationActionType.DELETE);
            notification.setType(Notification.ItemType.Risk);
            this.addEmailToNotification(risk.getCreatedBy(), notification, EnumEmailConfig.USER_REPORTER.getCode(), emailRecipientMap);
            if (risk.getResponsible() != null) {
                this.addEmailToNotification(risk.getResponsible().getEmail(), notification, EnumEmailConfig.USER_RESPONSIBLE.getCode(), emailRecipientMap);
            }
            for (Watcher watcher : risk.getWatcherList()) {
                if (!PropertyValidator.isValid((Object)watcher)) continue;
                if (PropertyValidator.isValid((Object)watcher.getUser())) {
                    this.addEmailToNotification(watcher.getUser().getEmail(), notification, EnumEmailConfig.USER_WATCHER.getCode(), emailRecipientMap);
                    continue;
                }
                if (!PropertyValidator.isValid((Object)watcher.getGroup()) || !PropertyValidator.isValid((Collection)watcher.getGroup().getUsers())) continue;
                List users = this.userRepository.findByIdIn(watcher.getGroup().getUsers());
                for (User user : users) {
                    this.addEmailToNotification(user.getEmail(), notification, EnumEmailConfig.USER_WATCHER.getCode(), emailRecipientMap);
                }
            }
            ArrayList emails = Lists.newArrayList((Iterable)notification.getEmails());
            HashMap<String, ArrayList> recipientMap = new HashMap<String, ArrayList>();
            recipientMap.put(Notification.ItemType.Risk.name(), emails);
            notification.setRecipientList(recipientMap);
            notification.setContent(riskContent);
            notification.setTemplate("risk_notif_del_template");
            notification.setType(Notification.ItemType.Risk);
            notification.setRecipientList(emailRecipientMap);
            this.notificationRepository.save((Object)notification);
        }
        List watcherIds = risk.getWatcherList().stream().map(BaseEntity::getId).collect(Collectors.toList());
        this.conversationRepository.deleteByRiskId(riskId);
        this.watcherRepository.deleteByIdIn(watcherIds);
        this.riskRepository.delete((Serializable)((Object)riskId));
        return new ResponseEntity((Object)riskId, HttpStatus.OK);
    }

    @RequestMapping(value={"/probabilities"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getProbabilityList() {
        List probabilities = this.riskProbabilityRepository.findAll();
        return new ResponseEntity((Object)probabilities, HttpStatus.OK);
    }

    @RequestMapping(value={"/impacts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getImpactList() {
        List impacts = this.riskImpactRepository.findAll();
        return new ResponseEntity((Object)impacts, HttpStatus.OK);
    }

    @RequestMapping(value={"/statuses"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getStatusList() {
        List statuses = this.riskStatusRepository.findAll();
        return new ResponseEntity((Object)statuses, HttpStatus.OK);
    }

    @RequestMapping(value={"/search-items/{title}/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemsByTitleSearch(@PathVariable String title, @PathVariable String riskRegisterId) {
        List sessions = this.sessionRepository.findByRiskRegisterId(riskRegisterId);
        List sessionsIds = sessions.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        List sessionBoardsUnfiltered = this.sessionBoardRepository.findBySessionIdIn(sessionsIds);
        for (SessionBoard sessionBoard : sessionBoardsUnfiltered) {
            if (sessionBoard.getStatus() != null && !sessionBoard.getStatus().equals("Open")) continue;
            sessionBoards.add(sessionBoard);
        }
        List sessionBoardsIds = sessionBoards.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List items = this.itemRepository.findByTitleContainingIgnoreCaseAndSessionBoardsIdIn(title, sessionBoardsIds);
        List itemsSearchedByJiraKey = this.itemRepository.findByJiraKeyContainingIgnoreCaseAndSessionBoardsIdIn(title, sessionBoardsIds);
        for (Item item : itemsSearchedByJiraKey) {
            if (items.contains(item)) continue;
            items.add(item);
        }
        for (Item item : items) {
            String externalLink = this.getItemLink(item);
            item.setExternalReferenceURL(externalLink);
        }
        this.setFeatureStoryPoints(items);
        return new ResponseEntity((Object)items, HttpStatus.OK);
    }

    @RequestMapping(value={"/geitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemsByBoardItem(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            Item itemCopy;
            ItemVO item2;
            String boardIds = (String)payload.get("boardIds");
            List solutionBoardList = null;
            HashMap<String, SolutionBoard> solutionBoardMapById = new HashMap<String, SolutionBoard>();
            Boolean isSolutionBoard = false;
            if (PropertyValidator.isValid((Object)payload.get("solutionBoard"))) {
                isSolutionBoard = (Boolean)payload.get("solutionBoard");
            }
            List<String> boardIdsList = Arrays.asList(boardIds.split(","));
            ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
            for (String sid : boardIdsList) {
                ids.add(new ObjectId(sid));
            }
            if (isSolutionBoard.booleanValue() && PropertyValidator.isValid((Collection)(solutionBoardList = this.solutionBoardRepository.findEssentialInfoByIdIn(boardIdsList)))) {
                for (SolutionBoard sol : solutionBoardList) {
                    solutionBoardMapById.put(sol.getId(), sol);
                }
            }
            List sessions = this.sessionRepository.findSessionIdsByIdIn(ids);
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            List sessionObjectId = sessions.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
            ArrayList<ObjectId> activeSessionBoardIds = new ArrayList<ObjectId>();
            for (Session session2 : sessions) {
                activeSessionBoardIds.add(new ObjectId(session2.getActiveSessionBoard()));
            }
            List sessionBoardsUnfiltered = this.findBoardsByBoardIdsIn(activeSessionBoardIds);
            Collection configFields = null;
            if (PropertyValidator.isValid((Collection)sessionBoardsUnfiltered)) {
                configFields = this.planService.getItemJiraFieldMap((SessionBoard)sessionBoardsUnfiltered.get(0));
            }
            HashMap<String, SessionBoard> sessionBoardMapById = new HashMap<String, SessionBoard>();
            ArrayList<ObjectId> sessionBoardIds = new ArrayList<ObjectId>();
            for (SessionBoard sessionBoard : sessionBoardsUnfiltered) {
                if (sessionBoard.getStatus() == null || sessionBoard.getStatus().equals("Open")) {
                    sessionBoards.add(sessionBoard);
                    sessionBoardIds.add(new ObjectId(sessionBoard.getId()));
                    sessionBoardMapById.put(sessionBoard.getId(), sessionBoard);
                }
                Session session3 = new Session(sessionBoard.getSession().getId(), sessionBoard.getSession().getTitle());
                sessionBoard.setSession(session3);
            }
            ArrayList<ItemVO> features = new ArrayList<ItemVO>();
            ArrayList<ItemVO> stories = new ArrayList<ItemVO>();
            ArrayList<ItemVO> epics = new ArrayList<ItemVO>();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            if (PropertyValidator.isValid((Object)payload.get("fetchTypes"))) {
                Map fetchTypes = (Map)payload.get("fetchTypes");
                Boolean fetchFeatures = (Boolean)fetchTypes.get("features");
                Boolean fetchUserStories = (Boolean)fetchTypes.get("userStories");
                Boolean fetchCapabilities = (Boolean)fetchTypes.get("capabilities");
                if (!fetchFeatures.booleanValue()) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").ne((Object)"Feature"));
                } else if (!fetchUserStories.booleanValue()) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").ne((Object)"UserStory"));
                }
                if (fetchCapabilities.booleanValue()) {
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)"Epic"));
                }
            }
            if (isSolutionBoard.booleanValue()) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"solutionBoard.$id").in(ids));
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds));
            }
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
            List rawItems = dbCursorPrefix.toArray();
            ArrayList allStatuses = new ArrayList();
            HashMap statusMapById = new HashMap();
            List issueTypes = this.issueTypeRepository.findAll();
            HashMap issueTypeMapById = new HashMap();
            issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
            Set teamContainerRefs = this.findTeamContainerRefsFromRawItems(rawItems);
            ArrayList<String> tcIds = new ArrayList<String>();
            for (DBRef containerRefs : teamContainerRefs) {
                tcIds.add(containerRefs.getId().toString());
            }
            List teamContainers = this.findTeamContainersByIdIn(tcIds);
            HashMap<String, TeamContainer> tcMapById = new HashMap<String, TeamContainer>();
            for (TeamContainer tc : teamContainers) {
                tcMapById.put(tc.getId(), tc);
            }
            for (DBObject rawitem : rawItems) {
                ItemVO item3 = this.createItemVOForReport(rawitem, sessionBoardMapById, statusMapById, allStatuses, issueTypeMapById, tcMapById);
                if (item3.getType().equals(Item.FEATURE)) {
                    features.add(item3);
                    continue;
                }
                if (item3.getType().equals(Item.EPIC)) {
                    if (PropertyValidator.isValid((Object)rawitem.get("solutionBoard"))) {
                        DBRef solRef = (DBRef)rawitem.get("solutionBoard");
                        String id = solRef.getId().toString();
                        SolutionBoardVO solBoardVo = new SolutionBoardVO((SolutionBoard)solutionBoardMapById.get(id));
                        item3.setSolutionBoard(solBoardVo);
                    }
                    epics.add(item3);
                    continue;
                }
                stories.add(item3);
            }
            query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(allStatuses));
            dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject());
            List _statusesRaw = dbCursorPrefix.toArray();
            ArrayList<Status> _statuses = new ArrayList<Status>();
            if (PropertyValidator.isValid((Collection)_statusesRaw)) {
                _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
            }
            HashMap _statusesMap = new HashMap();
            if (PropertyValidator.isValid(_statuses)) {
                _statuses.forEach(item -> {
                    item.setWorkFlow(null);
                    item.setWorkFlowItemType(null);
                    _statusesMap.put(item.getId(), item);
                });
            }
            for (ItemVO it : stories) {
                item2 = it;
                if (PropertyValidator.isValid((Object)item2.getStatus()) && PropertyValidator.isValid(_statusesMap.get(item2.getStatus().getId()))) {
                    item2.setStatus(new StatusVO((Status)_statusesMap.get(item2.getStatus().getId())));
                }
                if (PropertyValidator.isValid((Collection)it.getTeamContainers())) {
                    ArrayList<TeamContainerVO> itTCs = new ArrayList<TeamContainerVO>();
                    for (TeamContainerVO itTC : it.getTeamContainers()) {
                        if (!PropertyValidator.isValid((Object)itTC) || !PropertyValidator.isValid(tcMapById.get(itTC.getId()))) continue;
                        itTCs.add(new TeamContainerVO((TeamContainer)tcMapById.get(itTC.getId())));
                    }
                    item2.setTeamContainers(itTCs);
                }
                if (!PropertyValidator.isValid((Object)item2.getJiraFieldByKey())) continue;
                itemCopy = new Item();
                itemCopy.setType(item2.getType());
                itemCopy.setJiraId(item2.getJiraId());
                itemCopy.putCustomeValuesAsText(item2.getJiraFieldByKey(), configFields, null);
                if (!PropertyValidator.isValid((Object)itemCopy.getJiraFieldTextByKey())) continue;
                item2.setJiraFieldTextByKey(itemCopy.getJiraFieldTextByKey());
            }
            for (ItemVO it : features) {
                item2 = it;
                if (PropertyValidator.isValid((Object)item2.getStatus()) && PropertyValidator.isValid(_statusesMap.get(item2.getStatus().getId()))) {
                    item2.setStatus(new StatusVO((Status)_statusesMap.get(item2.getStatus().getId())));
                }
                if (!PropertyValidator.isValid((Object)item2.getJiraFieldByKey())) continue;
                itemCopy = new Item();
                itemCopy.setType(item2.getType());
                itemCopy.setJiraId(item2.getJiraId());
                itemCopy.putCustomeValuesAsText(item2.getJiraFieldByKey(), configFields, null);
                if (!PropertyValidator.isValid((Object)itemCopy.getJiraFieldTextByKey())) continue;
                item2.setJiraFieldTextByKey(itemCopy.getJiraFieldTextByKey());
            }
            for (ItemVO it : epics) {
                item2 = it;
                if (PropertyValidator.isValid((Object)item2.getStatus()) && PropertyValidator.isValid(_statusesMap.get(item2.getStatus().getId()))) {
                    item2.setStatus(new StatusVO((Status)_statusesMap.get(item2.getStatus().getId())));
                }
                if (!PropertyValidator.isValid((Object)item2.getJiraFieldByKey())) continue;
                itemCopy = new Item();
                itemCopy.setType(item2.getType());
                itemCopy.setJiraId(item2.getJiraId());
                itemCopy.putCustomeValuesAsText(item2.getJiraFieldByKey(), configFields, null);
                if (!PropertyValidator.isValid((Object)itemCopy.getJiraFieldTextByKey())) continue;
                item2.setJiraFieldTextByKey(itemCopy.getJiraFieldTextByKey());
            }
            responseJson.put("stories", stories);
            responseJson.put("features", features);
            responseJson.put("epics", epics);
            responseJson.put("sessionBoards", BusinessToVOUtils.convertSessionBoardsToSessionBoardVOs(sessionBoards));
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-items-and-subitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemsSubItemsByBoardItem(@RequestBody HashMap<String, Object> payload) {
        Item item2;
        Item it;
        String boardIds = (String)payload.get("boardIds");
        List<String> boardIdsList = Arrays.asList(boardIds.split(","));
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        for (String sid : boardIdsList) {
            ids.add(new ObjectId(sid));
        }
        List sessions = this.sessionRepository.findByIdIn(ids);
        List sessionsIds = sessions.stream().map(BaseEntity::getId).collect(Collectors.toList());
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        List sessionBoardsUnfiltered = this.sessionBoardRepository.findBySessionIn(sessions);
        HashMap<String, SessionBoard> sessionBoardMapById = new HashMap<String, SessionBoard>();
        ArrayList<ObjectId> sessionBoardIds = new ArrayList<ObjectId>();
        for (SessionBoard sessionBoard : sessionBoardsUnfiltered) {
            if (sessionBoard.getStatus() != null && !sessionBoard.getStatus().equals("Open")) continue;
            sessionBoards.add(sessionBoard);
            sessionBoardIds.add(new ObjectId(sessionBoard.getId()));
            sessionBoardMapById.put(sessionBoard.getId(), sessionBoard);
        }
        ArrayList<Item> features = new ArrayList<Item>();
        ArrayList<Item> stories = new ArrayList<Item>();
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        if (PropertyValidator.isValid((Object)payload.get("fetchTypes"))) {
            Map fetchTypes = (Map)payload.get("fetchTypes");
            Boolean fetchFeatures = (Boolean)fetchTypes.get("features");
            Boolean fetchUserStories = (Boolean)fetchTypes.get("userStories");
            if (!fetchFeatures.booleanValue()) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").ne((Object)"Feature"));
            } else if (!fetchUserStories.booleanValue()) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").ne((Object)"UserStory"));
            }
        }
        query.fields().include("_id");
        query.fields().include("parent");
        query.fields().include("title");
        query.fields().include("status");
        query.fields().include("jiraKey");
        query.fields().include("jiraId");
        query.fields().include("tfsId");
        query.fields().include("tfsURL");
        query.fields().include("sessionBoards");
        query.fields().include("type");
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").in(sessionBoardIds));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
        List rawItems = dbCursorPrefix.toArray();
        ArrayList allStatuses = new ArrayList();
        HashMap statusMapById = new HashMap();
        List issueTypes = this.issueTypeRepository.findAll();
        HashMap issueTypeMapById = new HashMap();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
        for (DBObject rawitem : rawItems) {
            Item item3 = this.createItemForReport(rawitem, sessionBoardMapById, statusMapById, allStatuses, issueTypeMapById);
            if (item3.getType().equals(Item.FEATURE)) {
                features.add(item3);
                continue;
            }
            stories.add(item3);
        }
        query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(allStatuses));
        dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject());
        List _statusesRaw = dbCursorPrefix.toArray();
        ArrayList<Status> _statuses = new ArrayList<Status>();
        if (PropertyValidator.isValid((Collection)_statusesRaw)) {
            _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
        }
        HashMap _statusesMap = new HashMap();
        if (PropertyValidator.isValid(_statuses)) {
            _statuses.forEach(item -> {
                item.setWorkFlow(null);
                item.setWorkFlowItemType(null);
                _statusesMap.put(item.getId(), item);
            });
        }
        Iterator iterator = stories.iterator();
        while (iterator.hasNext()) {
            item2 = it = (Item)iterator.next();
            item2.setStatus((Status)_statusesMap.get(item2.getStatus().getId()));
        }
        iterator = features.iterator();
        while (iterator.hasNext()) {
            item2 = it = (Item)iterator.next();
            item2.setStatus((Status)_statusesMap.get(item2.getStatus().getId()));
        }
        HashMap<String, ArrayList<Object>> responseJson = new HashMap<String, ArrayList<Object>>();
        responseJson.put("stories", stories);
        responseJson.put("features", features);
        responseJson.put("sessionBoards", sessionBoards);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private ItemVO createItemVOForReport(DBObject vo, HashMap<String, SessionBoard> sessionBoardMapById, HashMap<String, String> statusMapById, ArrayList<Object> allStatuses, HashMap<String, IssueType> issueTypeMapById, Map<String, TeamContainer> teamContainerMapById) {
        List sessionBoardsRef = (List)vo.get("sessionBoards");
        ItemSessionBoardVO sessionBoard = null;
        if (PropertyValidator.isValid((Collection)sessionBoardsRef)) {
            String id = ((DBRef)sessionBoardsRef.get(0)).getId().toString();
            sessionBoard = new ItemSessionBoardVO(sessionBoardMapById.get(id));
        }
        ItemVO parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new ItemVO(String.valueOf(parentRef.getId()));
        }
        StatusVO status = null;
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            status = new StatusVO();
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList<TeamContainerVO> teamContainers = new ArrayList<TeamContainerVO>();
        if (PropertyValidator.isValid((Object)vo.get("teamContainers"))) {
            List teamContainersRef = (List)vo.get("teamContainers");
            for (DBRef tcRef : teamContainersRef) {
                TeamContainer tc = teamContainerMapById.get(tcRef.getId().toString());
                if (!PropertyValidator.isValid((Object)tc)) continue;
                tc.setId(tcRef.getId().toString());
                teamContainers.add(new TeamContainerVO(tc));
            }
        }
        return new ItemVO(vo, sessionBoard, status, issueType, parent, teamContainers);
    }

    private Item createItemForReport(DBObject vo, HashMap<String, SessionBoard> sessionBoardMapById, HashMap<String, String> statusMapById, ArrayList<Object> allStatuses, HashMap<String, IssueType> issueTypeMapById) {
        List sessionBoardsRef = (List)vo.get("sessionBoards");
        String id = ((DBRef)sessionBoardsRef.get(0)).getId().toString();
        SessionBoard sessionBoard = sessionBoardMapById.get(id);
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = issueTypeMapById.get(issueTypeId);
        }
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Object)vo.get("teamContainers"))) {
            List teamContainersRef = (List)vo.get("teamContainers");
            for (DBRef tcRef : teamContainersRef) {
                TeamContainer tc = new TeamContainer();
                tc.setId(tcRef.getId().toString());
                teamContainers.add(tc);
            }
        }
        return new Item(vo, sessionBoard, status, issueType, parent, null, null, teamContainers, null);
    }

    private void setFeatureStoryPoints(List<Item> items) throws RuntimeException {
        Map childMap = this.findChildrenAgainstParentId(items);
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item) || !item.getType().equals("Feature")) continue;
            Double storyPoints = 0.0;
            List childList = (List)childMap.get(item.getId());
            if (PropertyValidator.isValid((Collection)childList)) {
                for (Item childItem : childList) {
                    if (!PropertyValidator.isValid((Object)childItem)) continue;
                    storyPoints = storyPoints + childItem.getStoryPoints();
                }
            }
            item.setStoryPoints(storyPoints);
        }
    }

    private Map<String, List<Item>> findChildrenAgainstParentId(List<Item> items) {
        HashMap<String, List<Item>> childMap = new HashMap<String, List<Item>>();
        ArrayList<ObjectId> parentIds = new ArrayList<ObjectId>();
        for (Item item : items) {
            if (!PropertyValidator.isValid((Object)item) || !item.getType().equals("Feature")) continue;
            parentIds.add(new ObjectId(item.getId()));
        }
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("parent.$id", (Object)new BasicDBObject("$in", parentIds)).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()).append("archive", (Object)false));
        BasicDBObject groupStage = new BasicDBObject("$group", (Object)new BasicDBObject().append("_id", (Object)"$parent.$id").append("items", (Object)new BasicDBObject("$push", (Object)"$$ROOT")));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("parent.$id", (Object)"$_id").append("items", (Object)new BasicDBObject("$map", (Object)new BasicDBObject().append("input", (Object)"$items").append("as", (Object)"item").append("in", (Object)new BasicDBObject().append("_id", (Object)"$$item._id").append("storyPoints", (Object)"$$item.storyPoints")))));
        List<DBObject> pipeline = Arrays.asList(matchStage, groupStage, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                ArrayList<Item> childList = new ArrayList<Item>();
                List itemsList = (List)object.get("items");
                for (BasicDBObject dbItem : itemsList) {
                    try {
                        Item item = new Item(DBUtils.getIdFromDBObject((BasicDBObject)dbItem, (String[])new String[0]));
                        item.setStoryPoints(Double.valueOf(PropertyValidator.isValid((Object)dbItem.get("storyPoints")) ? dbItem.getDouble("storyPoints") : item.getStoryPoints().doubleValue()));
                        childList.add(item);
                    }
                    catch (Exception ex) {
                        LOGGER.error("ERROR => item.setStoryPoints " + dbItem);
                    }
                }
                childMap.put(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]), childList);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return childMap;
    }

    @RequestMapping(value={"/search-items-board/{title}/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemsByTitleSearchAndSessionBoardId(@PathVariable String title, @PathVariable String sessionBoardId) {
        ArrayList<String> sessionBoardsIds = new ArrayList<String>();
        sessionBoardsIds.add(sessionBoardId);
        List items = this.itemRepository.findByTitleContainingIgnoreCaseAndSessionBoardsIdIn(title, sessionBoardsIds);
        List itemsSearchedByJiraKey = this.itemRepository.findByJiraKeyContainingIgnoreCaseAndSessionBoardsIdIn(title, sessionBoardsIds);
        for (Item item : itemsSearchedByJiraKey) {
            if (items.contains(item)) continue;
            items.add(item);
        }
        for (Item item : items) {
            String externalLink = this.getItemLink(item);
            item.setExternalReferenceURL(externalLink);
        }
        this.setFeatureStoryPoints(items);
        return new ResponseEntity((Object)items, HttpStatus.OK);
    }

    @RequestMapping(value={"/is-board-linked/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> isBoardLinked(@PathVariable String riskRegisterId) {
        if (!PropertyValidator.isValid((Object)riskRegisterId)) {
            return new ResponseEntity((Object)false, HttpStatus.OK);
        }
        if (!ObjectId.isValid((String)riskRegisterId)) {
            return new ResponseEntity((Object)false, HttpStatus.OK);
        }
        boolean status = false;
        try {
            status = this.customRepositoryImpl.isBoardLinked(new ObjectId(riskRegisterId));
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity((Object)status, HttpStatus.OK);
    }

    @RequestMapping(value={"/linked-board/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoardLinked(@PathVariable String riskRegisterId) {
        List sessions = this.sessionRepository.findByRiskRegisterId(riskRegisterId);
        List boardNames = sessions.stream().map(Session::getTitle).collect(Collectors.toList());
        return new ResponseEntity(boardNames, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-teams-sprints/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getTeamsSprints(@PathVariable String sessionId) {
        HashMap<String, List> response = new HashMap<String, List>();
        try {
            Session session = this.customRepositoryImpl.findSessionById(sessionId);
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(session.getActiveSessionBoard());
            if (PropertyValidator.isValid((Object)sessionBoard)) {
                List teamList = sessionBoard.getTeams();
                List containerList = sessionBoard.getContainers();
                response.put("linkedSessionTeams", BusinessToVOUtils.convertTeamsToTeamVOs((List)teamList));
                response.put("linkedSessionSprints", BusinessToVOUtils.convertContainersToContainerVOs((List)containerList));
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/linked-boards/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoardsLinkedToRiskRegister(@PathVariable String riskRegisterId) {
        List sessions = this.customRepositoryImpl.findSessionsByRiskRegisterId(riskRegisterId);
        LinkedList<BoardVO> boardList = new LinkedList<BoardVO>();
        for (Session session : sessions) {
            BoardVO boardVO = new BoardVO();
            boardVO.setId(session.getId());
            boardVO.setName(session.getTitle());
            boardList.add(boardVO);
        }
        return new ResponseEntity(boardList, HttpStatus.OK);
    }

    @RequestMapping(value={"/workspaces"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkspaces() {
        LinkedList workspaces = new LinkedList();
        try {
            Query query = new Query();
            query.fields().include("_id");
            query.fields().include("title");
            List dbWorkSpaces = this.mongoTemplate.find(query, WorkSpace.class);
            dbWorkSpaces.forEach(workSpace -> workspaces.add(WorkSpaceVO.fromWorkSpace((WorkSpace)workSpace)));
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(workspaces, HttpStatus.OK);
    }

    @RequestMapping(value={"/sessions/{workSpaceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkSpaceSessions(@PathVariable String workSpaceId, @RequestParam(required=false) Map<String, Object> params) {
        List boardList = null;
        boolean allowLinkedSessions = false;
        if (PropertyValidator.isValid(params)) {
            allowLinkedSessions = Boolean.parseBoolean(params.getOrDefault("allowLinkedSessions", false).toString());
        }
        try {
            List closedStateIds = this.findClosedStateIds();
            boardList = this.findAllSessionsByWorkSpace(workSpaceId, closedStateIds, allowLinkedSessions, UserContextUtil.getUserContext().getLoggedInUser().getTenant(), null);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(boardList, HttpStatus.OK);
    }

    @RequestMapping(value={"/sessions/{workSpaceId}/{almAccountId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWorkSpaceSessionsWithAlmAccount(@PathVariable String workSpaceId, @PathVariable String almAccountId, @RequestParam(required=false) Map<String, Object> params) {
        try {
            List closedStateIds = this.findClosedStateIds();
            boolean allowLinkedSessions = false;
            if (params != null && params.containsKey("allowLinkedSessions")) {
                allowLinkedSessions = Boolean.parseBoolean(params.get("allowLinkedSessions").toString());
            }
            List boards = this.findAllSessionsByWorkSpace(workSpaceId, closedStateIds, allowLinkedSessions, UserContextUtil.getUserContext().getLoggedInUser().getTenant(), almAccountId);
            return new ResponseEntity((Object)boards, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/linked-boards"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoardsLinked() {
        HashMap response = new HashMap();
        List riskRegisters = this.riskRegisterRepository.findAll();
        HashMap map = new HashMap();
        List sessionsAll = this.fetchWorkspaceSessions();
        List solutionBoardAll = this.customRepositoryImpl.fetchSolutionBoardListWithIdTitle();
        List collectionsAll = this.customRepositoryImpl.fetchCollectionListWithIdTitle();
        List linkedSolutionBoardIds = this.customRepositoryImpl.fetchSolutionBoardIdsWithLinkedRiskRegisters();
        collectionsAll.removeIf(obj -> obj.getType() == null);
        LinkedList<BoardVO> boardList = new LinkedList<BoardVO>();
        for (SessionVO session2 : sessionsAll) {
            BoardVO boardVO = new BoardVO();
            boardVO.setId(session2.getId());
            boardVO.setName(session2.getTitle());
            boardList.add(boardVO);
        }
        Collections.reverse(boardList);
        map.put("0", boardList);
        List riskRegisterIds = riskRegisters.stream().map(riskRegister -> new ObjectId(riskRegister.getId())).collect(Collectors.toList());
        List allSessions = this.customRepositoryImpl.findSessionsByRiskRegisterIdIn(riskRegisterIds);
        for (RiskRegister riskRegister2 : riskRegisters) {
            List sessions = allSessions.stream().filter(session -> riskRegister2.getId().equals(session.getRiskRegister().getId())).collect(Collectors.toList());
            boardList = new LinkedList();
            for (Session session3 : sessions) {
                BoardVO boardVO = new BoardVO();
                boardVO.setId(session3.getId());
                boardVO.setName(session3.getTitle());
                boardList.add(boardVO);
            }
            map.put(riskRegister2.getId(), boardList);
        }
        Map linkedBoardsMap = this.riskRegisterService.getLinkedCollectionsAndSolutionBoards();
        response.put("collectionsMap", linkedBoardsMap.get("collections"));
        response.put("solutionMap", linkedBoardsMap.get("solution"));
        response.put("boards", map);
        response.put("solBoards", solutionBoardAll);
        response.put("orgs", collectionsAll);
        response.put("linkedSolutionBoardIds", linkedSolutionBoardIds);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-riskitems/{riskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinkedItems(@PathVariable String riskId) {
        Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)riskId));
        List sessions = this.sessionRepository.findByRiskRegisterId(risk.getRiskRegister().getId());
        List solBoards = this.customRepositoryImpl.findSolutionBoardsByRiskRegisterId(risk.getRiskRegister().getId());
        this.setActiveBoardItems(risk, sessions, null, new HashMap(), solBoards);
        HashMap<String, String> activeBoardIds = new HashMap<String, String>();
        if (PropertyValidator.isValid((Collection)sessions)) {
            for (Session s : sessions) {
                activeBoardIds.put(s.getActiveSessionBoard(), s.getId());
            }
        }
        this.setFeatureStoryPoints(risk.getLinkedItems());
        risk.setActiveBoardIds(activeBoardIds);
        return new ResponseEntity((Object)new RiskVO(risk), HttpStatus.OK);
    }

    private void setRiskTfsItems(Risk risk, Collection<String> activeBoardIds, Collection<String> solutionBoardIds) {
        HashMap<String, String> existingLinkedItemMapById = new HashMap<String, String>();
        if (PropertyValidator.isValid((Collection)risk.getLinkedItems())) {
            for (Item item : risk.getLinkedItems()) {
                existingLinkedItemMapById.put(item.getId(), item.getId());
            }
        }
        if (PropertyValidator.isValid((Object)risk.getTfsAttributes()) && PropertyValidator.isValid((Collection)risk.getTfsAttributes().getTfsLinkedItems())) {
            List almLinkedItems = this.itemRepository.findByTfsIdInAndSessionBoardsIdIn((Collection)risk.getTfsAttributes().getTfsLinkedItems(), activeBoardIds);
            if (risk.getLinkedItems() == null) {
                risk.setLinkedItems(new ArrayList());
            }
            if (PropertyValidator.isValid((Collection)almLinkedItems)) {
                for (Item item : almLinkedItems) {
                    if (existingLinkedItemMapById.containsKey(item.getId())) continue;
                    item.setIsAlmLinked(Boolean.TRUE);
                    risk.getLinkedItems().add(item);
                }
            }
            almLinkedItems = this.itemRepository.findByTfsIdInAndSolutionBoardIdIn((Collection)risk.getTfsAttributes().getTfsLinkedItems(), solutionBoardIds);
            if (risk.getLinkedItems() == null) {
                risk.setLinkedItems(new ArrayList());
            }
            if (PropertyValidator.isValid((Collection)almLinkedItems)) {
                for (Item item : almLinkedItems) {
                    if (existingLinkedItemMapById.containsKey(item.getId())) continue;
                    item.setIsAlmLinked(Boolean.TRUE);
                    risk.getLinkedItems().add(item);
                }
            }
        }
    }

    @RequestMapping(value={"/update-riskItems/{requestId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateRiskItems(@PathVariable String requestId, @RequestBody Risk risk) {
        Risk savedRisk = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
        if (risk.getLinkedItemsIds() == null) {
            risk.setLinkedItemsIds(new ArrayList());
        }
        if (savedRisk.getLinkedItems() == null) {
            savedRisk.setLinkedItemsIds(new ArrayList());
        }
        if (risk.getLinkedItemsIds() != null && savedRisk.getLinkedItemsIds() != null) {
            List itemsRemoved;
            Risk finalRisk = savedRisk;
            List itemsAdded = (List)CollectionUtils.subtract((Collection)risk.getLinkedItemsIds(), (Collection)savedRisk.getLinkedItemsIds());
            if (PropertyValidator.isValid((Collection)itemsAdded)) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            if (PropertyValidator.isValid((Collection)(itemsRemoved = (List)CollectionUtils.subtract((Collection)savedRisk.getLinkedItemsIds(), (Collection)risk.getLinkedItemsIds())))) {
                for (String itemId : itemsRemoved) {
                    if (!PropertyValidator.isValid((Object)savedRisk.getLinkedItemsById()) || !savedRisk.getLinkedItemsById().containsKey(itemId)) continue;
                    savedRisk.getLinkedItemsById().remove(itemId);
                }
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        savedRisk.setLinkedItemsIds(risk.getLinkedItemsIds());
        savedRisk = this.filterExternalItems(savedRisk, risk);
        return new ResponseEntity((Object)savedRisk, HttpStatus.OK);
    }

    private void sendPushResonse(Risk freshItem, String requestId, HashMap<String, Object> metaMap) {
        try {
            Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
            if (metaMap == null) {
                metaMap = new HashMap();
            }
            metaMap.put("event", "RiskCreateLink");
            JSONObject pushJson = new JSONObject();
            HashMap<String, Risk> pushData = new HashMap<String, Risk>();
            pushData.put("risk", freshItem);
            String itemStr = gsonExclusive.toJson(pushData);
            pushJson.put("data", (Object)itemStr);
            pushJson.put("tfs", true);
            String metaMapStr = gsonExclusive.toJson(metaMap);
            pushJson.put("metaMap", (Object)metaMapStr);
            PushSender.sendMsg((String)pushJson.toString());
            this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/delete-lost-link/{riskId}/{itemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> deleteLostLinkedItem(@PathVariable String riskId, @PathVariable String itemId) {
        Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)riskId));
        if (risk.getLinkedItemsById() != null) {
            risk.getLinkedItemsById().remove(itemId);
        }
        risk.getLinkedItemsIds().remove(itemId);
        risk = (Risk)this.riskRepository.save((Object)risk);
        return new ResponseEntity((Object)itemId, HttpStatus.OK);
    }

    @RequestMapping(value={"/update-riskExternalLinks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateRiskExternalLinks(@RequestBody Risk risk) {
        Risk savedRisk = (Risk)this.riskRepository.findOne((Serializable)((Object)risk.getId()));
        savedRisk.setExternalLinks(risk.getExternalLinks());
        Risk updatedRisk = (Risk)this.riskRepository.save((Object)savedRisk);
        return new ResponseEntity((Object)updatedRisk, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-conversations/{riskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getConversations(@PathVariable String riskId) {
        List conversationList = this.conversationRepository.findAllByRiskId(riskId);
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        for (Conversation conversation : conversationList) {
            if (contextUser.getUserName().equals(conversation.getUser().getUserName())) continue;
            conversation.setMine(false);
        }
        return new ResponseEntity((Object)conversationList, HttpStatus.OK);
    }

    private String replaceRegixComments(String original) {
        original = original.replaceAll("\\[-(.*?)\\]", "");
        Pattern p = Pattern.compile("\\[~(.*?)\\]");
        Matcher m = p.matcher(original);
        while (m.find()) {
            original = m.replaceFirst("<b style=\"color: #a79b00\" >" + m.group(1) + "</b>");
            m = p.matcher(original);
        }
        return original;
    }

    @RequestMapping(value={"/save-conversation"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveConversation(@RequestBody Conversation conversation) {
        String conversationId = conversation.getId();
        Conversation savedConversation = (Conversation)this.conversationRepository.save((Object)conversation);
        if (conversationId == null) {
            boolean notifyWatchers;
            Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)savedConversation.getRisk().getId()));
            risk.setConversationCount(Integer.valueOf(risk.getConversationCount() + 1));
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            Boolean watcherExists = false;
            for (Watcher watcher2 : risk.getWatcherList()) {
                if (watcher2.getUser() == null || !watcher2.getUser().getId().equals(savedConversation.getUser().getId())) continue;
                watcherExists = true;
                break;
            }
            if (!watcherExists.booleanValue()) {
                Watcher watcher3 = new Watcher();
                watcher3.setType("risk");
                watcher3.setUser(savedConversation.getUser());
                Watcher savedWatcher = (Watcher)this.watcherRepository.save((Object)watcher3);
                risk.getWatcherList().add(savedWatcher);
            }
            boolean bl = notifyWatchers = risk.getNotifyWatchers() != null && risk.getNotifyWatchers() != false;
            if (conversationId == null && notifyWatchers) {
                HashMap emailRecipientMap = new HashMap();
                List<Watcher> newWatchersList = new ArrayList();
                Notification notification = new Notification();
                notification.setNotificationActionType(Notification.NotificationActionType.COMMENT);
                notification.setType(Notification.ItemType.Risk);
                Pattern p = Pattern.compile("\\[-(.*?)\\-]");
                Matcher m = p.matcher(conversation.getText());
                while (m.find()) {
                    User user = this.userRepository.findByUserNameOrEmail(m.group(1), m.group(1));
                    Optional<Watcher> foundObject = risk.getWatcherList().stream().filter(watcher -> PropertyValidator.isValid((Object)watcher.getUser()) && watcher.getUser().getId().equals(user.getId())).findFirst();
                    if (!foundObject.isPresent()) {
                        Watcher newWatcher = new Watcher();
                        newWatcher.setType("risk");
                        newWatcher.setUser(user);
                        newWatchersList.add(newWatcher);
                    }
                    this.addEmailToNotification(user.getEmail(), notification, EnumEmailConfig.USER_WATCHER.getCode(), emailRecipientMap);
                }
                newWatchersList = this.watcherRepository.save(newWatchersList);
                risk.getWatcherList().addAll(newWatchersList);
                HashMap<String, String> riskContent = new HashMap<String, String>();
                riskContent.put("riskRegisterName", risk.getRiskRegister().getRegisterName());
                riskContent.put("riskId", risk.getRiskRegister().getRegisterKey() + "-" + risk.getRiskNumber());
                riskContent.put("riskTitle", risk.getRiskTitle());
                riskContent.put("url", conversation.getAppUrl());
                riskContent.put("detailsHead", "Following comment added ");
                riskContent.put("details", "\"" + this.replaceRegixComments(conversation.getText()) + "\"");
                notification.setGroupingSubject("Conversation has been added");
                notification.setRegisterKey(risk.getRiskRegister().getRegisterKey());
                notification.setEmailSubject("Conversation has been added");
                this.addEmailToNotification(risk.getCreatedBy(), notification, EnumEmailConfig.USER_REPORTER.getCode(), emailRecipientMap);
                if (risk.getResponsible() != null) {
                    this.addEmailToNotification(risk.getResponsible().getEmail(), notification, EnumEmailConfig.USER_RESPONSIBLE.getCode(), emailRecipientMap);
                }
                for (Watcher watcher4 : risk.getWatcherList()) {
                    if (watcher4.getUser() != null) {
                        this.addEmailToNotification(watcher4.getUser().getEmail(), notification, EnumEmailConfig.USER_WATCHER.getCode(), emailRecipientMap);
                        continue;
                    }
                    if (!PropertyValidator.isValid((Object)watcher4.getGroup()) || !PropertyValidator.isValid((Collection)watcher4.getGroup().getUsers())) continue;
                    List users = this.userRepository.findByIdIn(watcher4.getGroup().getUsers());
                    for (User user : users) {
                        this.addEmailToNotification(user.getEmail(), notification, EnumEmailConfig.USER_WATCHER.getCode(), emailRecipientMap);
                    }
                }
                ArrayList emails = Lists.newArrayList((Iterable)notification.getEmails());
                HashMap<String, ArrayList> recipientMap = new HashMap<String, ArrayList>();
                recipientMap.put(Notification.ItemType.Risk.name(), emails);
                notification.setRecipientList(recipientMap);
                notification.setContent(riskContent);
                notification.setTemplate("risk_notif_template");
                notification.setType(Notification.ItemType.Risk);
                notification.setRecipientList(emailRecipientMap);
                this.notificationRepository.save((Object)notification);
            }
            this.riskRepository.save((Object)risk);
        }
        Conversation conversationFound = (Conversation)this.conversationRepository.findOne((Serializable)((Object)savedConversation.getId()));
        return new ResponseEntity((Object)conversationFound, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-conversation/{conversationId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> deleteConversation(@PathVariable String conversationId) {
        Conversation savedConversation = (Conversation)this.conversationRepository.findOne((Serializable)((Object)conversationId));
        Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)savedConversation.getRisk().getId()));
        Integer conversationCount = risk.getConversationCount() - 1;
        if (conversationCount < 0) {
            conversationCount = 0;
        }
        risk.setConversationCount(conversationCount);
        this.riskRepository.save((Object)risk);
        this.conversationRepository.delete((Serializable)((Object)conversationId));
        return new ResponseEntity((Object)conversationId, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-user-list"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getUserList() {
        List userList = this.userRepository.findAll();
        return new ResponseEntity((Object)userList, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-risk/{riskId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRisk(@PathVariable String riskId) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            HashMap sessionTeamMapById = new HashMap();
            HashMap sessionContainerMapById = new HashMap();
            Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)riskId));
            List sessions = this.customRepositoryImpl.findSessionsByRiskRegisterId(risk.getRiskRegister().getId());
            List boardTeams = risk.getBoardTeams();
            List boardSprints = risk.getBoardSprints();
            List solBoards = this.customRepositoryImpl.findSolutionBoardsByRiskRegisterId(risk.getRiskRegister().getId());
            this.setActiveBoardItems(risk, sessions, null, new HashMap(), solBoards);
            ArrayList activeSessionBoardsIds = new ArrayList();
            sessions.forEach(s -> activeSessionBoardsIds.add(s.getActiveSessionBoard()));
            Set linkedSessionsIds = this.getSessionsLinkedToRisk(boardTeams, boardSprints);
            List<Session> linkedSessions = sessions.stream().filter(session -> linkedSessionsIds.contains(session.getId())).collect(Collectors.toList());
            List activeSessionBoards = linkedSessions.stream().map(session -> new ObjectId(session.getActiveSessionBoard())).collect(Collectors.toList());
            Map activeSessionBoardMap = this.findSessionBoardsByActiveSessionBoardsIn(activeSessionBoards, risk.getTenant());
            if (PropertyValidator.isValid((Object)activeSessionBoardMap)) {
                linkedSessions.forEach(board -> {
                    SessionBoard currentSessionBoard = (SessionBoard)activeSessionBoardMap.get(board.getActiveSessionBoard());
                    if (PropertyValidator.isValid((Object)currentSessionBoard)) {
                        List teamList = currentSessionBoard.getTeams();
                        List containerList = currentSessionBoard.getContainers();
                        sessionTeamMapById.put(board.getId(), BusinessToVOUtils.convertTeamsToTeamVOs((List)teamList));
                        sessionContainerMapById.put(board.getId(), BusinessToVOUtils.convertContainersToContainerVOs((List)containerList));
                    }
                });
            }
            List conversationList = this.findAllConversationsByRiskId(riskId);
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User contextUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            for (Conversation conversation : conversationList) {
                if (contextUser.getUserName().equals(conversation.getUser().getUserName())) continue;
                conversation.setMine(false);
            }
            for (Item item : risk.getLinkedItems()) {
                String externalLink = this.getItemLink(item);
                item.setExternalReferenceURL(externalLink);
            }
            this.setFeatureStoryPoints(risk.getLinkedItems());
            risk.setConversations(conversationList);
            response.put("risk", new RiskVO(risk));
            response.put("linkedBoardCount", sessions.size());
            response.put("linkedSessions", linkedSessionsIds);
            response.put("linkedBoards", BusinessToVOUtils.convertSessionsToSessionVOs(linkedSessions));
            response.put("linkedTeams", boardTeams);
            response.put("linkedContainers", boardSprints);
            response.put("linkedBoardContainers", sessionContainerMapById);
            response.put("linkedBoardTeams", sessionTeamMapById);
        }
        catch (Exception exception) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)exception));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private Set<String> getSessionsLinkedToRisk(List<BoardTeam> boardTeams, List<BoardSprints> boardSprints) {
        HashSet<String> linkedSessions = new HashSet<String>();
        if (PropertyValidator.isValid(boardTeams)) {
            for (BoardTeam boardTeam : boardTeams) {
                linkedSessions.add(boardTeam.getSessionId());
            }
        }
        if (PropertyValidator.isValid(boardSprints)) {
            for (BoardSprints boardSprint : boardSprints) {
                linkedSessions.add(boardSprint.getSessionId());
            }
        }
        return linkedSessions;
    }

    @RequestMapping(value={"/get-linked-boards/{rrId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinkedBoards(@PathVariable String rrId) {
        HashMap<String, List> response = new HashMap<String, List>();
        List sessions = this.customRepositoryImpl.findSessionsByRiskRegisterId(rrId);
        response.put("linkedBoards", BusinessToVOUtils.convertSessionsToSessionVOs((List)sessions));
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-item-risks/{itemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemRisks(@PathVariable String itemId) {
        ArrayList<Risk> riskList = new ArrayList<Risk>();
        List savedRiskList = this.riskRepository.findAll();
        for (Risk risk : savedRiskList) {
            if (risk.getLinkedItemsIds() == null) continue;
            for (String linkedItemId : risk.getLinkedItemsIds()) {
                if (!linkedItemId.equals(itemId)) continue;
                riskList.add(risk);
            }
        }
        return new ResponseEntity(riskList, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-watchers/{type}/{parentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWatchersByRisk(@PathVariable String type, @PathVariable String parentId) {
        ArrayList<Watcher> watcherList = new ArrayList<Watcher>();
        if (type.equals("risk")) {
            Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)parentId));
            for (Watcher watcher : risk.getWatcherList()) {
                if (PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Collection)watcher.getUser().getUserCompanies())) {
                    watcherList.add(watcher);
                    continue;
                }
                if (watcher.getUser() != null || watcher.getGroup() == null || watcher.getGroup().isArchive()) continue;
                watcherList.add(watcher);
            }
            return new ResponseEntity(watcherList, HttpStatus.OK);
        }
        if (type.equals("risk-register")) {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)parentId));
            for (Watcher watcher : riskRegister.getWatcherList()) {
                if (PropertyValidator.isValid((Object)watcher.getUser()) && PropertyValidator.isValid((Collection)watcher.getUser().getUserCompanies())) {
                    watcherList.add(watcher);
                    continue;
                }
                if (watcher.getUser() != null || watcher.getGroup() == null || watcher.getGroup().isArchive()) continue;
                watcherList.add(watcher);
            }
            return new ResponseEntity(watcherList, HttpStatus.OK);
        }
        if (type.equals("link")) {
            List watchers;
            ItemLink itemLink = this.customRepositoryImpl.getItemLink(parentId);
            if (PropertyValidator.isValid((Object)itemLink)) {
                watchers = itemLink.getWatcherList();
            } else {
                ItemJiraDependency itemJiraDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)parentId));
                watchers = itemJiraDependency.getWatcherList();
            }
            for (Watcher watcher : watchers) {
                if (watcher.getUser() != null && PropertyValidator.isValid((Collection)watcher.getUser().getUserCompanies())) {
                    watcherList.add(watcher);
                    continue;
                }
                if (watcher.getUser() != null || watcher.getGroup() == null || watcher.getGroup().isArchive()) continue;
                watcherList.add(watcher);
            }
            return new ResponseEntity(watcherList, HttpStatus.OK);
        }
        return new ResponseEntity(watcherList, HttpStatus.BAD_REQUEST);
    }

    private Boolean isLoggedInCompanyUser(User user) {
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        for (UserCompany userCompany : user.getUserCompanies()) {
            if (!userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/search-watchers/{title}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWatchersByTitleSearch(@PathVariable String title) {
        ArrayList<Watcher> watchers = new ArrayList<Watcher>();
        List users = this.userRepository.findByUserCompanies_Company_IdAndFullNameContainingIgnoreCase(UserContextUtil.getUserContext().getCurrentCompany().getId(), title);
        for (User user : users) {
            if (!this.isLoggedInCompanyUser(user).booleanValue()) continue;
            Watcher watcher = new Watcher();
            watcher.setUser(user);
            watchers.add(watcher);
        }
        List groups = this.groupRepository.findByTitleContainingIgnoreCase(title);
        for (Group group : groups) {
            Watcher watcher = new Watcher();
            watcher.setGroup(group);
            watchers.add(watcher);
        }
        return new ResponseEntity(watchers, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-watcher/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveWatcher(@RequestBody Watcher watcher, @PathVariable String parentId) {
        Watcher savedWatcher = (Watcher)this.watcherRepository.save((Object)watcher);
        if (watcher.getType().equals("risk")) {
            Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)parentId));
            risk.getWatcherList().add(watcher);
            this.riskRepository.save((Object)risk);
        } else if (watcher.getType().equals("risk-register")) {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)parentId));
            riskRegister.getWatcherList().add(watcher);
            this.riskRegisterRepository.save((Object)riskRegister);
        } else if (watcher.getType().equals("link")) {
            ItemLink itemLink = this.customRepositoryImpl.getItemLink(parentId);
            if (PropertyValidator.isValid((Object)itemLink)) {
                ArrayList<Object> watcherList = PropertyValidator.isValid((Collection)itemLink.getWatcherList()) ? new ArrayList(itemLink.getWatcherList()) : new ArrayList<Watcher>();
                watcherList.add(savedWatcher);
                itemLink.setWatcherList(watcherList);
                this.itemLinkRepository.save((Object)itemLink);
            } else {
                ItemJiraDependency itemJiraDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)parentId));
                ArrayList<Object> watcherList = PropertyValidator.isValid((Collection)itemJiraDependency.getWatcherList()) ? new ArrayList(itemJiraDependency.getWatcherList()) : new ArrayList<Watcher>();
                watcherList.add(savedWatcher);
                itemJiraDependency.setWatcherList(watcherList);
                this.itemJiraDependencyRepository.save((Object)itemJiraDependency);
            }
        }
        return new ResponseEntity((Object)savedWatcher, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-watcher/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteWatcher(@RequestBody Watcher watcher, @PathVariable String parentId) {
        this.watcherRepository.delete((Serializable)((Object)watcher.getId()));
        if (watcher.getType().equals("risk")) {
            Risk risk = (Risk)this.riskRepository.findOne((Serializable)((Object)parentId));
            risk.getWatcherList().remove(watcher);
            this.riskRepository.save((Object)risk);
        } else if (watcher.getType().equals("risk-register")) {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)parentId));
            riskRegister.getWatcherList().remove(watcher);
            this.riskRegisterRepository.save((Object)riskRegister);
        } else if (watcher.getType().equals("link")) {
            ItemLink itemLink = this.customRepositoryImpl.getItemLink(parentId);
            if (PropertyValidator.isValid((Object)itemLink)) {
                itemLink.getWatcherList().remove(watcher);
                this.itemLinkRepository.save((Object)itemLink);
            } else {
                ItemJiraDependency itemJiraDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)parentId));
                itemJiraDependency.getWatcherList().remove(watcher);
                this.itemJiraDependencyRepository.save((Object)itemJiraDependency);
            }
        }
        return new ResponseEntity((Object)watcher, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-riskregister/{sessionId}/{riskRegisterId}/{viewtype}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> linkRiskRegister(@PathVariable String sessionId, @PathVariable String riskRegisterId, @PathVariable String viewtype) {
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        Session session = null;
        SolutionBoard solutionBoard = null;
        if (viewtype.equalsIgnoreCase("sessionBoard")) {
            session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (session.getRiskRegister() != null && !session.getRiskRegister().getId().equals(riskRegisterId)) {
                return new ResponseEntity(null, HttpStatus.OK);
            }
            session.setRiskRegister(riskRegister);
            this.sessionRepository.save((Object)session);
        } else if (viewtype.equalsIgnoreCase("solutionBoard")) {
            solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)sessionId));
            if (solutionBoard.getRiskRegisters() != null) {
                return new ResponseEntity(null, HttpStatus.OK);
            }
            solutionBoard.setRiskRegisters(new ArrayList());
            solutionBoard.getRiskRegisters().add(riskRegister);
            this.solutionBoardRepository.save((Object)solutionBoard);
        }
        List riskList = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
        Map map = this.processRiskDetails(riskRegister, riskList, null, sessionId);
        map.put("riskregister", riskRegister);
        List statuses = null;
        statuses = this.statusRepository.findByWorkFlow(riskRegister.getWorkflow());
        ArrayList sortedStatuses = new ArrayList();
        HashMap<String, List> sessionTeamMapById = new HashMap<String, List>();
        HashMap<String, List> sessionContainerMapById = new HashMap<String, List>();
        HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
        String[] sortedStatusIds = riskRegister.getWorkflow().getStatusSequence().split(",");
        for (Status status : statuses) {
            sortedStatusesMap.put(status.getId(), status);
        }
        for (String statusId : sortedStatusIds) {
            sortedStatuses.add(sortedStatusesMap.get(statusId));
        }
        map.put("statuses", sortedStatuses);
        map.put("risks", riskList);
        if (viewtype.equalsIgnoreCase("sessionBoard")) {
            SessionBoard currentSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
            List teamList = currentSessionBoard.getTeams();
            List containerList = currentSessionBoard.getContainers();
            sessionTeamMapById.put(session.getId(), teamList);
            sessionContainerMapById.put(session.getId(), containerList);
            map.put("session", session);
            map.put("sessionTeams", sessionTeamMapById);
            map.put("sessionContainers", sessionContainerMapById);
        } else {
            map.put("solutionBoard", solutionBoard);
        }
        return new ResponseEntity((Object)map, HttpStatus.OK);
    }

    private boolean checkIfBoardExist(List<BoardVO> boardList, String boardId) {
        for (BoardVO boardVO : boardList) {
            if (!boardVO.getId().equals(boardId)) continue;
            return true;
        }
        return false;
    }

    @RequestMapping(value={"/unlink-board/{riskRegisterId}/{sessionId}/{viewType}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBoardLinking(@PathVariable String riskRegisterId, @PathVariable String sessionId, @PathVariable String viewType) {
        boolean success = false;
        try {
            if (viewType.equalsIgnoreCase("piBoards")) {
                Session linkedSession = this.sessionRepository.findByIdAndRiskRegisterId(sessionId, riskRegisterId);
                if (PropertyValidator.isValid((Object)linkedSession) && linkedSession.getRiskRegister() != null && riskRegisterId.equals(linkedSession.getRiskRegister().getId())) {
                    this.unlinkRiskRegisterAndAssociations(linkedSession.getId());
                    success = true;
                }
            } else if (viewType.equalsIgnoreCase("solBoards")) {
                this.unlinkRiskRegisterWithSolutionBoard(sessionId);
                success = true;
            } else if (viewType.equalsIgnoreCase("collections")) {
                this.unlinkRiskRegisterWithCollection(sessionId, riskRegisterId);
                success = true;
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity((Object)success, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-board/{riskRegisterId}/{workSpaceId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBoardLinking1(@PathVariable String riskRegisterId, @PathVariable String workSpaceId, @RequestBody List<BoardVO> boardList) {
        LinkedList<BoardVO> updatedBoardList = new LinkedList<BoardVO>();
        if (!PropertyValidator.isValid(boardList)) {
            return new ResponseEntity(updatedBoardList, HttpStatus.OK);
        }
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List sessionIds = boardList.stream().map(boardVO -> new ObjectId(boardVO.getId())).collect(Collectors.toList());
            List sessionIdsToLinkRiskRegister = this.validateSessionsToLinkWithRiskRegister(sessionIds, workSpaceId);
            if (PropertyValidator.isValid((Collection)sessionIdsToLinkRiskRegister)) {
                List sessionIdsToUpdate = sessionIdsToLinkRiskRegister.stream().map(session -> new ObjectId(session.getId())).collect(Collectors.toList());
                this.customRepositoryImpl.updateRiskRegisterForSessions(sessionIdsToUpdate, riskRegister);
                for (Session session2 : sessionIdsToLinkRiskRegister) {
                    BoardVO board = new BoardVO();
                    board.setId(session2.getId());
                    board.setName(session2.getTitle());
                    updatedBoardList.add(board);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(updatedBoardList, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-board2"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBoardLinking2(@RequestBody Map param) {
        HashMap<String, Boolean> response = new HashMap<String, Boolean>();
        try {
            this.riskRegisterService.linkGlobalRegister(param);
            response.put("success", true);
        }
        catch (Exception ex) {
            response.put("success", false);
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private List<Session> validateSessionsToLinkWithRiskRegister(List<ObjectId> sessionsIds, String workSpaceId) {
        if (!PropertyValidator.isValid((Object)workSpaceId) || !PropertyValidator.isValid(sessionsIds)) {
            return null;
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in(sessionsIds).and("workSpace.$id").is((Object)new ObjectId(workSpaceId)).and("riskRegister").exists(false));
        query.fields().include("_id");
        query.fields().include("title");
        return this.mongoTemplate.find(query, Session.class);
    }

    private List<String> removeBoardItems(List<String> itemList, List<Item> boardItems) {
        ArrayList<String> finalItemList = new ArrayList<String>();
        Boolean isBoardItem = null;
        for (String itemId : itemList) {
            isBoardItem = false;
            for (Item item : boardItems) {
                if (!itemId.equals(item.getId())) continue;
                isBoardItem = true;
                break;
            }
            if (isBoardItem.booleanValue()) continue;
            finalItemList.add(itemId);
        }
        return finalItemList;
    }

    @RequestMapping(value={"/unlink-riskregister/{sessionId}/{viewtype}/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> unlinkRiskRegister(@PathVariable String sessionId, @PathVariable String viewtype, @PathVariable String riskRegisterId) {
        try {
            if (PropertyValidator.isValid((Object)viewtype) && viewtype.equalsIgnoreCase("solutionBoard")) {
                this.unlinkRiskRegisterWithSolutionBoard(sessionId);
            } else if (PropertyValidator.isValid((Object)viewtype) && viewtype.equalsIgnoreCase("org-view")) {
                this.unlinkRiskRegisterWithCollection(sessionId, riskRegisterId);
            } else {
                this.unlinkRiskRegisterAndAssociations(sessionId);
            }
            return new ResponseEntity((Object)sessionId, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error("Error unlinking risk register: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity((Object)"Error occurred while unlinking risk register", HttpStatus.BAD_GATEWAY);
        }
    }

    private void unlinkRiskRegisterAndAssociations(String sessionId) {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        RiskRegister riskRegister = session.getRiskRegister();
        if (riskRegister != null) {
            HashMap<String, Object> itemsMap = new HashMap<String, Object>();
            List riskList = this.riskRepository.findAllByRiskRegisterId(riskRegister.getId());
            List sessionBoards = this.sessionBoardRepository.findBySessionId(sessionId);
            List boardItems = this.itemRepository.findBySessionBoardsIn(sessionBoards);
            for (int i = 0; i < boardItems.size(); ++i) {
                itemsMap.put(((Item)boardItems.get(i)).getId(), boardItems.get(i));
            }
            for (Risk risk : riskList) {
                if (risk.getLinkedItemsById() != null) {
                    Set ids = risk.getLinkedItemsById().keySet();
                    HashMap<String, Map> map = new HashMap<String, Map>();
                    for (String id : ids) {
                        Map item = (Map)risk.getLinkedItemsById().get(id);
                        if (sessionId.equals(item.get("session_id"))) {
                            itemsMap.put(id, new Item());
                            continue;
                        }
                        map.put(id, item);
                    }
                    risk.setLinkedItemsById(map);
                }
                if (risk.getLinkedItemsIds() != null) {
                    ArrayList<String> finalItemList = new ArrayList<String>();
                    for (String itemId : risk.getLinkedItemsIds()) {
                        if (itemsMap.containsKey(itemId)) continue;
                        finalItemList.add(itemId);
                    }
                    risk.setLinkedItemsIds(finalItemList);
                }
                if (risk.getBoardTeams() != null) {
                    ArrayList<BoardTeam> updateBoardTeam = new ArrayList<BoardTeam>();
                    for (BoardTeam boardTeam : risk.getBoardTeams()) {
                        if (boardTeam.getSessionId().equalsIgnoreCase(sessionId)) continue;
                        updateBoardTeam.add(boardTeam);
                    }
                    risk.setBoardTeams(updateBoardTeam);
                }
                if (risk.getBoardSprints() != null) {
                    ArrayList<BoardSprints> updateBoardSprint = new ArrayList<BoardSprints>();
                    for (BoardSprints boardSprint : risk.getBoardSprints()) {
                        if (boardSprint.getSessionId().equalsIgnoreCase(sessionId)) continue;
                        updateBoardSprint.add(boardSprint);
                    }
                    risk.setBoardSprints(updateBoardSprint);
                }
                if (risk.getLinkedPiBoards() != null) {
                    ArrayList<Map> updatedLinkedPiBoards = new ArrayList<Map>();
                    for (Map piBoard : risk.getLinkedPiBoards()) {
                        String boardId = (String)piBoard.get("id");
                        if (boardId.equalsIgnoreCase(sessionId)) continue;
                        updatedLinkedPiBoards.add(piBoard);
                    }
                    risk.setLinkedPiBoards(updatedLinkedPiBoards);
                }
                this.riskRepository.save((Object)risk);
            }
        }
        session.setRiskRegister(null);
        this.sessionRepository.save((Object)session);
    }

    private void unlinkRiskRegisterWithSolutionBoard(String solutionBoardId) {
        try {
            SolutionBoard solutionBoard = (SolutionBoard)this.solutionBoardRepository.findOne((Serializable)((Object)solutionBoardId));
            if (PropertyValidator.isValid((Object)solutionBoard)) {
                RiskRegister riskRegister = (RiskRegister)solutionBoard.getRiskRegisters().get(0);
                if (PropertyValidator.isValid((Object)riskRegister)) {
                    HashMap<String, Object> itemsMap = new HashMap<String, Object>();
                    List riskList = this.riskRepository.findAllByRiskRegisterId(riskRegister.getId());
                    if (PropertyValidator.isValid((Collection)riskList)) {
                        List boardItems = this.itemRepository.findBySolutionBoard(solutionBoard);
                        for (int i = 0; i < boardItems.size(); ++i) {
                            itemsMap.put(((Item)boardItems.get(i)).getId(), boardItems.get(i));
                        }
                        ArrayList<Risk> updatedRisks = new ArrayList<Risk>();
                        for (Risk risk : riskList) {
                            if (risk.getLinkedItemsById() != null) {
                                Set ids = risk.getLinkedItemsById().keySet();
                                HashMap<String, Map> map = new HashMap<String, Map>();
                                for (String id : ids) {
                                    Map item = (Map)risk.getLinkedItemsById().get(id);
                                    if (solutionBoardId.equals(item.get("solution_id"))) {
                                        itemsMap.put(id, new Item());
                                        continue;
                                    }
                                    map.put(id, item);
                                }
                                risk.setLinkedItemsById(map);
                            }
                            if (risk.getLinkedItemsIds() != null) {
                                ArrayList<String> finalItemList = new ArrayList<String>();
                                for (String itemId : risk.getLinkedItemsIds()) {
                                    if (itemsMap.containsKey(itemId)) continue;
                                    finalItemList.add(itemId);
                                }
                                risk.setLinkedItemsIds(finalItemList);
                            }
                            if (risk.getLinkedSolutionBoards() != null) {
                                ArrayList<Map> updatedLinkedSolutionBoards = new ArrayList<Map>();
                                for (Map solBoard : risk.getLinkedSolutionBoards()) {
                                    String boardId = (String)solBoard.get("id");
                                    if (boardId.equalsIgnoreCase(solutionBoardId)) continue;
                                    updatedLinkedSolutionBoards.add(solBoard);
                                }
                                risk.setLinkedSolutionBoards(updatedLinkedSolutionBoards);
                            }
                            updatedRisks.add(risk);
                        }
                        if (PropertyValidator.isValid(updatedRisks)) {
                            this.riskRepository.save(updatedRisks);
                        }
                    }
                }
                solutionBoard.setRiskRegisters(null);
                this.solutionBoardRepository.save((Object)solutionBoard);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error unlinking risk register with solution board: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void unlinkRiskRegisterWithCollection(String workSpaceId, String riskRegisterId) {
        try {
            WorkSpace workSpace = this.workSpaceRepository.findByIdOrKey(workSpaceId, workSpaceId);
            if (PropertyValidator.isValid((Object)workSpace)) {
                RiskRegister riskRegister = workSpace.getRiskRegisters().stream().filter(r -> r.getId().equalsIgnoreCase(riskRegisterId)).findFirst().orElse(null);
                if (PropertyValidator.isValid((Object)riskRegister)) {
                    ArrayList<Risk> updatedRisks = new ArrayList<Risk>();
                    List riskList = this.riskRepository.findAllByRiskRegisterId(riskRegister.getId());
                    for (Risk risk : riskList) {
                        if (risk.getLinkedOrgCollections() == null) continue;
                        ArrayList<Map> updatedLinkedCollections = new ArrayList<Map>();
                        for (Map col : risk.getLinkedOrgCollections()) {
                            String boardId = (String)col.get("id");
                            if (boardId.equalsIgnoreCase(workSpaceId)) continue;
                            updatedLinkedCollections.add(col);
                        }
                        risk.setLinkedOrgCollections(updatedLinkedCollections);
                        updatedRisks.add(risk);
                    }
                    if (PropertyValidator.isValid(updatedRisks)) {
                        this.riskRepository.save(updatedRisks);
                    }
                }
                workSpace.getRiskRegisters().remove(riskRegister);
                this.workSpaceRepository.save((Object)workSpace);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error unlinking risk register with Collection: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
    }

    @RequestMapping(value={"/fetch-sessions"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchSessions() {
        List piBoards = this.fetchWorkspaceSessions();
        return new ResponseEntity((Object)piBoards, HttpStatus.OK);
    }

    private List<SessionVO> fetchWorkspaceSessions() {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        LinkedList<SessionVO> piBoards = new LinkedList<SessionVO>();
        HashSet workSpaces = new HashSet();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findByIsModuleIsFalseOrIsModuleIsNull());
            LOGGER.debug("Workspaces  fetched :: " + workSpaces.size());
        } else {
            List workSpaceAccessRoles = new ArrayList();
            workSpaceAccessRoles = this.customRepositoryImpl.findWorkspaceAccessRoles(user);
            for (WorkSpaceAccessRole workSpaceAccessRole : workSpaceAccessRoles) {
                if (!PropertyValidator.isValid((Object)workSpaceAccessRole.getWorkSpace())) continue;
                workSpaces.add(workSpaceAccessRole.getWorkSpace());
            }
        }
        if (PropertyValidator.isValid((Collection)workSpaces)) {
            List allSessions = this.sessionRepository.findByWorkSpaceInOrderByTitleAsc(new ArrayList(workSpaces));
            allSessions.forEach(session -> piBoards.add(new SessionVO(session)));
        }
        return piBoards;
    }

    @RequestMapping(value={"/get-risk-workflows"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskWorkflows() {
        List workFlows = this.workFlowRepository.findAllByWorkflowType("Risk");
        List statuses = null;
        for (WorkFlow workFlow : workFlows) {
            statuses = this.statusRepository.findByWorkFlow(workFlow);
            ArrayList sortedStatuses = new ArrayList();
            HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
            String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
            for (Status status : statuses) {
                sortedStatusesMap.put(status.getId(), status);
            }
            for (String statusId : sortedStatusIds) {
                sortedStatuses.add(sortedStatusesMap.get(statusId));
            }
            workFlow.setStatuses(sortedStatuses);
        }
        return new ResponseEntity((Object)workFlows, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-risk-matrices"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskMatrices() {
        List riskMatrices = this.riskMatrixRepository.findAll();
        if (riskMatrices.size() == 0) {
            this.createRiskMatrix();
            riskMatrices = this.riskMatrixRepository.findAll();
        }
        return new ResponseEntity((Object)riskMatrices, HttpStatus.OK);
    }

    private void createWorkFlow() {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setWorkflowType(WorkFlow.WorkFlowType.Risk.toString());
        workFlow.setTitle("Risk WorkFlow");
        WorkFlow savedWorkFlow = (WorkFlow)this.workFlowRepository.save((Object)workFlow);
        Status status1 = new Status();
        status1.setCategory("ToDo");
        status1.setTitle("Open");
        status1.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status1);
        Status status2 = new Status();
        status2.setCategory("InProgress");
        status2.setTitle("Owned");
        status2.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status2);
        Status status3 = new Status();
        status3.setCategory("Done");
        status3.setTitle("Accepted");
        status3.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status3);
        Status status4 = new Status();
        status4.setCategory("Done");
        status4.setTitle("Mitigated");
        status4.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status4);
        Status status5 = new Status();
        status5.setCategory("Done");
        status5.setTitle("Resolved");
        status5.setWorkFlow(workFlow);
        this.statusRepository.save((Object)status5);
        String sequence = status1.getId() + "," + status2.getId() + "," + status3.getId() + "," + status4.getId() + "," + status5.getId();
        workFlow.setStatusSequence(sequence);
        this.workFlowRepository.save((Object)workFlow);
    }

    private void createRiskMatrix() {
        String low = "#09c199";
        String med = "#f39c12";
        String high = "#f85359";
        String vhigh = "#c0392b";
        String blue = "";
        RiskMatrix riskMatrix = new RiskMatrix();
        riskMatrix.setTitle("Risk Matrix 1");
        RiskMatrixCoordinate rm1 = new RiskMatrixCoordinate();
        rm1.setTitle("Low");
        rm1.setValue(Integer.valueOf(1));
        RiskMatrixCoordinate rm2 = new RiskMatrixCoordinate();
        rm2.setTitle("Medium");
        rm2.setValue(Integer.valueOf(2));
        RiskMatrixCoordinate rm3 = new RiskMatrixCoordinate();
        rm3.setTitle("High");
        rm3.setValue(Integer.valueOf(3));
        riskMatrix.getProbabilities().add(rm1);
        riskMatrix.getProbabilities().add(rm2);
        riskMatrix.getProbabilities().add(rm3);
        riskMatrix.getImpacts().add(rm1);
        riskMatrix.getImpacts().add(rm2);
        riskMatrix.getImpacts().add(rm3);
        RiskLevel rl1 = new RiskLevel();
        rl1.setTitle("High");
        rl1.setColor(high);
        rl1.setLowerLimit(Integer.valueOf(9));
        RiskLevel rl2 = new RiskLevel();
        rl2.setTitle("Medium");
        rl2.setColor(med);
        rl2.setLowerLimit(Integer.valueOf(4));
        RiskLevel rl3 = new RiskLevel();
        rl3.setTitle("Low");
        rl3.setColor(low);
        rl3.setLowerLimit(Integer.valueOf(0));
        riskMatrix.getRiskLevelList().add(rl1);
        riskMatrix.getRiskLevelList().add(rl2);
        riskMatrix.getRiskLevelList().add(rl3);
        this.riskMatrixRepository.save((Object)riskMatrix);
        riskMatrix = new RiskMatrix();
        riskMatrix.setTitle("Risk Matrix 2");
        rm1 = new RiskMatrixCoordinate();
        rm1.setTitle("Very Low");
        rm1.setValue(Integer.valueOf(1));
        rm2 = new RiskMatrixCoordinate();
        rm2.setTitle("Low");
        rm2.setValue(Integer.valueOf(2));
        rm3 = new RiskMatrixCoordinate();
        rm3.setTitle("Medium");
        rm3.setValue(Integer.valueOf(3));
        RiskMatrixCoordinate rm4 = new RiskMatrixCoordinate();
        rm4.setTitle("High");
        rm4.setValue(Integer.valueOf(4));
        RiskMatrixCoordinate rm5 = new RiskMatrixCoordinate();
        rm5.setTitle("Very High");
        rm5.setValue(Integer.valueOf(5));
        riskMatrix.getProbabilities().add(rm1);
        riskMatrix.getProbabilities().add(rm2);
        riskMatrix.getProbabilities().add(rm3);
        riskMatrix.getProbabilities().add(rm4);
        riskMatrix.getProbabilities().add(rm5);
        riskMatrix.getImpacts().add(rm1);
        riskMatrix.getImpacts().add(rm2);
        riskMatrix.getImpacts().add(rm3);
        riskMatrix.getImpacts().add(rm4);
        riskMatrix.getImpacts().add(rm5);
        rl1 = new RiskLevel();
        rl1.setTitle("Severe");
        rl1.setColor(vhigh);
        rl1.setLowerLimit(Integer.valueOf(16));
        rl2 = new RiskLevel();
        rl2.setTitle("High");
        rl2.setColor(high);
        rl2.setLowerLimit(Integer.valueOf(12));
        rl3 = new RiskLevel();
        rl3.setTitle("Medium");
        rl3.setColor(med);
        rl3.setLowerLimit(Integer.valueOf(8));
        RiskLevel rl4 = new RiskLevel();
        rl4.setTitle("Low");
        rl4.setColor(low);
        rl4.setLowerLimit(Integer.valueOf(0));
        riskMatrix.getRiskLevelList().add(rl1);
        riskMatrix.getRiskLevelList().add(rl2);
        riskMatrix.getRiskLevelList().add(rl3);
        riskMatrix.getRiskLevelList().add(rl4);
        this.riskMatrixRepository.save((Object)riskMatrix);
    }

    @RequestMapping(value={"/status-graph-data/{riskRegisterId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> statusGraphData(@PathVariable String riskRegisterId, @RequestBody HashMap<String, Object> payload) {
        ArrayList listOfLists = new ArrayList();
        try {
            ConfigAndMapping config;
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List statuses = null;
            if (PropertyValidator.isValid((Object)riskRegister.getConfigId()) && PropertyValidator.isValid((Object)(config = (ConfigAndMapping)this.configAndMappingRepository.findOne((Serializable)((Object)riskRegister.getConfigId()))))) {
                List _statuses;
                String workItemType = config.getRiskItemTypeName();
                AlmAccount almAccount = config.getAlmAccount();
                HashMap statusMapByTitle = new HashMap();
                statuses = _statuses = this.statusRepository.findByTfsProjectIdAndAlmIdAndItemType(config.getTfsProjectTfsId(), almAccount.getId(), workItemType);
            }
            if (statuses == null) {
                statuses = this.statusRepository.findByWorkFlow(riskRegister.getWorkflow());
            }
            for (Status status : statuses) {
                Integer riskCount = 0;
                if (PropertyValidator.isValid((Object)payload.get("ids"))) {
                    List ids = (List)payload.get("ids");
                    riskCount = this.customRepositoryImpl.countByStatusIdAndRegister(ids, status.getId(), riskRegister.getId());
                } else {
                    riskCount = this.riskRepository.countByStatusIdAndRiskRegisterId(status.getId(), riskRegisterId).intValue();
                }
                if (riskCount <= 0) continue;
                ArrayList<Object> listItem = new ArrayList<Object>();
                listItem.add(status.getTitle());
                listItem.add(riskCount);
                listOfLists.add(listItem);
            }
            return new ResponseEntity(listOfLists, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(listOfLists, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/risk-responsible-graph-data/{riskRegisterId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> riskResponsibleGraphData(@PathVariable String riskRegisterId, @RequestBody HashMap<String, Object> payload) {
        ArrayList listOfLists = new ArrayList();
        try {
            ArrayList<Risk> riskList = new ArrayList<Risk>();
            List selectedRiskLevels = (List)payload.get("selectedRiskLevels");
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
            List riskListAll = new ArrayList();
            if (PropertyValidator.isValid((Object)payload.get("ids"))) {
                List ids = (List)payload.get("ids");
                riskListAll = this.riskRepository.findByIdIn(ids);
            } else {
                riskListAll = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            }
            for (Risk risk : riskListAll) {
                if (risk.getProbability() == null || risk.getImpact() == null) continue;
                RiskLevel riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                for (Map map : selectedRiskLevels) {
                    if (!riskLevel.getTitle().equals(map.get("name"))) continue;
                    riskList.add(risk);
                }
            }
            List responsibleList = riskList.stream().map(Risk::getResponsible).collect(Collectors.toList());
            HashSet userSet = new HashSet(responsibleList);
            responsibleList.clear();
            responsibleList.addAll(userSet);
            LinkedHashMap<String, Integer> hashMap = new LinkedHashMap<String, Integer>();
            for (User user : responsibleList) {
                if (user == null) continue;
                hashMap.put(user.getFullName(), 0);
            }
            if (riskListAll.size() > 0) {
                hashMap.put("Not assigned", 0);
            }
            for (Risk risk : riskList) {
                Integer count;
                if (risk.getResponsible() != null) {
                    count = (Integer)hashMap.get(risk.getResponsible().getFullName());
                    hashMap.put(risk.getResponsible().getFullName(), count + 1);
                    continue;
                }
                count = (Integer)hashMap.get("Not assigned");
                hashMap.put("Not assigned", count + 1);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                ArrayList<Object> listItem = new ArrayList<Object>();
                listItem.add(entry.getKey());
                listItem.add(entry.getValue());
                listOfLists.add(listItem);
            }
            return new ResponseEntity(listOfLists, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(listOfLists, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/risk-level-graph-data/{riskRegisterId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> riskLevelGraphData(@PathVariable String riskRegisterId, @RequestBody HashMap<String, Object> payload) {
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            LinkedHashMap<String, Integer> hashMap = new LinkedHashMap<String, Integer>();
            List riskList = new ArrayList();
            if (PropertyValidator.isValid((Object)payload.get("ids"))) {
                List ids = (List)payload.get("ids");
                riskList = this.riskRepository.findByIdIn(ids);
            } else {
                riskList = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            }
            List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
            List colorList = riskLevelList.stream().map(RiskLevel::getColor).collect(Collectors.toList());
            colorList.add("#7F7D7E");
            for (RiskLevel riskLevel : riskLevelList) {
                hashMap.put(riskLevel.getTitle(), 0);
            }
            hashMap.put("N/A", 0);
            for (Risk risk : riskList) {
                if (risk.getProbability() != null && risk.getImpact() != null) {
                    RiskLevel riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                    Integer n = (Integer)hashMap.get(riskLevel.getTitle());
                    hashMap.put(riskLevel.getTitle(), n + 1);
                    continue;
                }
                Integer mapValue = (Integer)hashMap.get("N/A");
                hashMap.put("N/A", mapValue + 1);
            }
            boolean isData = false;
            ArrayList listOfLists = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                ArrayList<Object> listItem = new ArrayList<Object>();
                listItem.add(entry.getKey());
                listItem.add(entry.getValue());
                listOfLists.add(listItem);
                if ((Integer)entry.getValue() <= 0) continue;
                isData = true;
            }
            if (!isData) {
                listOfLists = new ArrayList();
            }
            HashMap<String, List<ArrayList<Object>>> data = new HashMap<String, List<ArrayList<Object>>>();
            data.put("data", listOfLists);
            data.put("color", colorList);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    private RiskLevel calculateRiskLevel(Integer probabilityValue, Integer impactValue, List<RiskLevel> riskLevelList) {
        Integer levelValue = probabilityValue * impactValue;
        Comparator compareByLowerLimit = (o1, o2) -> o1.getLowerLimit().compareTo(o2.getLowerLimit());
        Collections.sort(riskLevelList, compareByLowerLimit.reversed());
        for (RiskLevel riskLevel : riskLevelList) {
            if (levelValue < riskLevel.getLowerLimit()) continue;
            return riskLevel;
        }
        return null;
    }

    @RequestMapping(value={"/responsible-stacked-graph-data/{riskRegisterId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> responsibleStackedGraphData(@PathVariable String riskRegisterId, @RequestBody HashMap<String, Object> payload) {
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List riskList = new ArrayList();
            if (PropertyValidator.isValid((Object)payload.get("ids"))) {
                List ids = (List)payload.get("ids");
                riskList = this.riskRepository.findByIdIn(ids);
            } else {
                riskList = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            }
            List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
            List titleList = riskLevelList.stream().map(RiskLevel::getTitle).collect(Collectors.toList());
            List colorList = riskLevelList.stream().map(RiskLevel::getColor).collect(Collectors.toList());
            colorList.add("#7F7D7E");
            List responsibleList = riskList.stream().map(Risk::getResponsible).collect(Collectors.toList());
            LinkedHashMap responsibleHashMap = new LinkedHashMap();
            LinkedHashMap<String, Integer> hashMap = null;
            for (User responsible : responsibleList) {
                hashMap = new LinkedHashMap();
                for (RiskLevel riskLevel : riskLevelList) {
                    hashMap.put(riskLevel.getTitle(), 0);
                }
                hashMap.put("N/A", 0);
                for (Risk risk : riskList) {
                    if (risk.getProbability() != null && risk.getImpact() != null) {
                        RiskLevel riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                        Integer mapValue = (Integer)hashMap.get(riskLevel.getTitle());
                        if (risk.getResponsible() == null || responsible == null || !responsible.getId().equals(risk.getResponsible().getId())) continue;
                        hashMap.put(riskLevel.getTitle(), mapValue + 1);
                        continue;
                    }
                    Integer mapValue = (Integer)hashMap.get("N/A");
                    if (risk.getResponsible() == null || responsible == null || !responsible.getId().equals(risk.getResponsible().getId())) continue;
                    hashMap.put("N/A", mapValue + 1);
                }
                if (responsible == null) continue;
                responsibleHashMap.put(responsible.getFullName(), hashMap);
            }
            hashMap = new LinkedHashMap<String, Integer>();
            for (RiskLevel riskLevel : riskLevelList) {
                hashMap.put(riskLevel.getTitle(), 0);
            }
            hashMap.put("N/A", 0);
            for (Risk risk : riskList) {
                if (risk.getResponsible() != null) continue;
                if (risk.getProbability() != null && risk.getImpact() != null) {
                    RiskLevel riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                    Integer n = (Integer)hashMap.get(riskLevel.getTitle());
                    hashMap.put(riskLevel.getTitle(), n + 1);
                    continue;
                }
                Integer mapValue = (Integer)hashMap.get("N/A");
                hashMap.put("N/A", mapValue + 1);
            }
            responsibleHashMap.put("Not assigned", hashMap);
            ArrayList listOfLists = new ArrayList();
            ArrayList<String> listItem = new ArrayList<String>();
            listItem.add("Responsible");
            listItem.addAll(titleList);
            listItem.add("N/A");
            listOfLists.add(listItem);
            for (Map.Entry entry : responsibleHashMap.entrySet()) {
                listItem = new ArrayList();
                listItem.add((String)entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    listItem.add((String)entry2.getValue());
                }
                listOfLists.add(listItem);
            }
            if (riskList.size() == 0) {
                listOfLists = new ArrayList();
            }
            HashMap<String, List<ArrayList<Object>>> data = new HashMap<String, List<ArrayList<Object>>>();
            data.put("data", listOfLists);
            data.put("color", colorList);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/risk-matrix/{riskRegisterId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> riskMatrix(@PathVariable String riskRegisterId, @RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            RiskMatrix riskMatrix = riskRegister.getRiskMatrix();
            List risks = new ArrayList();
            if (PropertyValidator.isValid((Object)payload.get("ids"))) {
                List ids = (List)payload.get("ids");
                risks = this.riskRepository.findByIdIn(ids);
            } else {
                risks = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            }
            HashMap<String, Integer> risksMap = new HashMap<String, Integer>();
            HashMap<String, List> risksIdsMap = new HashMap<String, List>();
            for (Risk risk : risks) {
                if (risk.getProbability() == null || risk.getImpact() == null) continue;
                String riskValue = "" + risk.getProbability().getValue() + risk.getImpact().getValue();
                if (risksMap.get(riskValue) == null) {
                    risksMap.put(riskValue, 0);
                    risksIdsMap.put(riskValue, new ArrayList());
                }
                risksMap.put(riskValue, (Integer)risksMap.get(riskValue) + 1);
                List riskIds = (List)risksIdsMap.get(riskValue);
                riskIds.add(risk.getId());
                risksIdsMap.put(riskValue, riskIds);
            }
            data.put("riskMatrix", riskMatrix);
            data.put("riskMap", risksMap);
            data.put("risksIdsMap", risksIdsMap);
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(data, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/risk-levels/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> riskLevels(@PathVariable String riskRegisterId) {
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        ArrayList<RiskLevelVO> riskLevelDataList = new ArrayList<RiskLevelVO>();
        List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
        for (RiskLevel riskLevel : riskLevelList) {
            RiskLevelVO riskLevelData = new RiskLevelVO();
            riskLevelData.setName(riskLevel.getTitle());
            riskLevelDataList.add(riskLevelData);
        }
        return new ResponseEntity(riskLevelDataList, HttpStatus.OK);
    }

    @RequestMapping(value={"/mark-favorite/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> markFavorite(@PathVariable String riskRegisterId) {
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (riskRegister != null) {
            riskRegister.setFavorite(!riskRegister.isFavorite());
        }
        RiskRegister savedRiskRegister = (RiskRegister)this.riskRegisterRepository.save((Object)riskRegister);
        return new ResponseEntity((Object)savedRiskRegister, HttpStatus.OK);
    }

    @RequestMapping(value={"/toggle-favorite/{riskRegisterId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> toggleFavorite(@PathVariable String riskRegisterId) {
        int index;
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
        if (riskRegister == null) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
        }
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        if (riskRegister.getFavoriteOfUsers() == null) {
            riskRegister.setFavoriteOfUsers(new ArrayList());
        }
        if ((index = riskRegister.getFavoriteOfUsers().indexOf(loggedInUser.getId())) > -1) {
            riskRegister.getFavoriteOfUsers().remove(index);
        } else {
            riskRegister.getFavoriteOfUsers().add(loggedInUser.getId());
        }
        RiskRegister savedRiskRegister = (RiskRegister)this.riskRegisterRepository.save((Object)riskRegister);
        if (index > -1) {
            riskRegister.setFavoriteOfCurrentUser(false);
        } else {
            riskRegister.setFavoriteOfCurrentUser(true);
        }
        responseJson.put("success", true);
        responseJson.put("riskRegister", (Boolean)savedRiskRegister);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    public Boolean processNotifications() {
        List notifications = this.notificationRepository.findAll();
        this.notificationRepository.deleteAll();
        for (Notification notification : notifications) {
            for (String email : notification.getEmails()) {
                HashMap<String, String> mailData = new HashMap<String, String>();
                mailData.put("riskRegisterName", notification.getRegisterKey());
                mailData.put("riskId", notification.getRiskId());
                mailData.put("riskTitle", notification.getTitle());
                mailData.put("details", notification.getDetails());
                mailData.put("detailsHead", notification.getDetailsHead() + " by <label style=\"color:#09C199;\">" + notification.getUserName() + "</label>");
                mailData.put("url", notification.getUrl());
                if (notification.isDeleted()) {
                    this.mailSender.sendMail(email, notification.getEmailSubject(), "risk_notif_del_template", mailData, true);
                    continue;
                }
                this.mailSender.sendMail(email, notification.getEmailSubject(), "risk_notif_template", mailData, true);
            }
        }
        return true;
    }

    private boolean checkIfRiskColumnActive(String columnValue, List<RiskColumnVO> riskcolumnsList) {
        for (RiskColumnVO column : riskcolumnsList) {
            if (!column.getValue().equals(columnValue)) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> stringArrayToMap(String[] arr) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((String[])arr)) {
            for (String val : arr) {
                hashMap.put(val, val);
            }
        }
        return hashMap;
    }

    @RequestMapping(value={"/export/{type}/{riskRegisterId}/{sessionId}/{side}"})
    @ResponseBody
    public ResponseEntity<Object> exportRiskRegisterRisks(@PathVariable(value="type") String type, @PathVariable(value="riskRegisterId") String riskRegisterId, @PathVariable(value="sessionId") String sessionId, @PathVariable(value="side") String side, @RequestBody RiskColumnsVO riskcolumnsList) {
        try {
            String[] completeHeader;
            String extension = "xlsx";
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
            }
            String fileName = new Date().getTime() + "." + extension;
            String filePath = this.env.getProperty("temp.file.location") + fileName;
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add("Risk #");
            if (this.checkIfRiskColumnActive("riskTitle", riskcolumnsList.getColumnList())) {
                columnList.add("Risk Title");
            }
            if (this.checkIfRiskColumnActive("riskDesc", riskcolumnsList.getColumnList())) {
                columnList.add("Risk Description");
            }
            if (this.checkIfRiskColumnActive("riskAction", riskcolumnsList.getColumnList())) {
                columnList.add("Mitigation Actions");
            }
            if (this.checkIfRiskColumnActive("probability", riskcolumnsList.getColumnList())) {
                columnList.add("Probability");
            }
            if (this.checkIfRiskColumnActive("impact", riskcolumnsList.getColumnList())) {
                columnList.add("Impact");
            }
            if (this.checkIfRiskColumnActive("riskLevel", riskcolumnsList.getColumnList())) {
                columnList.add("Risk Level");
            }
            if (this.checkIfRiskColumnActive("mitigation", riskcolumnsList.getColumnList())) {
                columnList.add("Mitigation Actions");
            }
            if (this.checkIfRiskColumnActive("raisedDate", riskcolumnsList.getColumnList())) {
                columnList.add("Raised On");
            }
            if (this.checkIfRiskColumnActive("updatedOn", riskcolumnsList.getColumnList())) {
                columnList.add("Last Updated");
            }
            if (this.checkIfRiskColumnActive("resolutionDate", riskcolumnsList.getColumnList())) {
                columnList.add("Target Resolution Date");
            }
            if (this.checkIfRiskColumnActive("responsible", riskcolumnsList.getColumnList())) {
                columnList.add("Responsible");
            }
            if (this.checkIfRiskColumnActive("responsibleDetails", riskcolumnsList.getColumnList())) {
                columnList.add("Responsible Details");
            }
            if (this.checkIfRiskColumnActive("status", riskcolumnsList.getColumnList())) {
                columnList.add("Status");
            }
            if (this.checkIfRiskColumnActive("linkedItems", riskcolumnsList.getColumnList())) {
                columnList.add("Linked Items");
            }
            if (this.checkIfRiskColumnActive("convCount", riskcolumnsList.getColumnList())) {
                columnList.add("Conversation Count");
            }
            if (this.checkIfRiskColumnActive("team", riskcolumnsList.getColumnList())) {
                columnList.add("Teams");
            }
            if (this.checkIfRiskColumnActive("sprint", riskcolumnsList.getColumnList())) {
                columnList.add("Sprints");
            }
            if (this.checkIfRiskColumnActive("piBoard", riskcolumnsList.getColumnList())) {
                columnList.add("Program Boards");
            }
            if (this.checkIfRiskColumnActive("solBoard", riskcolumnsList.getColumnList())) {
                columnList.add("Solution Boards");
            }
            if (this.checkIfRiskColumnActive("orgBoard", riskcolumnsList.getColumnList())) {
                columnList.add("Collections");
            }
            FileOutputStream file = new FileOutputStream(filePath);
            RiskRegister riskRegister = (RiskRegister)this.riskRegisterRepository.findOne((Serializable)((Object)riskRegisterId));
            List sessions = this.sessionRepository.findByRiskRegisterId(riskRegister.getId());
            List risks = this.riskRepository.findAllByRiskRegisterId(riskRegisterId);
            FieldsLayout riskLayout = PropertyValidator.isValid((Object)riskRegister) && PropertyValidator.isValid((Object)riskRegister.getLayout()) ? riskRegister.getLayout() : this.customFieldService.getDefaultLayoutFromItemType(EnumKendis.RISK.getCode());
            if (PropertyValidator.isValid((Object)riskLayout)) {
                for (FieldEntity fieldEntity : riskLayout.getFields()) {
                    if (!this.checkIfRiskColumnActive(fieldEntity.getField().getId(), riskcolumnsList.getColumnList())) continue;
                    columnList.add(fieldEntity.getField().getTitle());
                }
            }
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
                CsvMapWriter writer = new CsvMapWriter((Writer)new OutputStreamWriter((OutputStream)file, "UTF-8"), CsvPreference.EXCEL_PREFERENCE);
                completeHeader = columnList.toArray(new String[0]);
                writer.writeHeader(completeHeader);
                for (Risk risk : risks) {
                    Object boardNames;
                    HashMap<String, Object> rowData = new HashMap<String, Object>();
                    String tfsId = null;
                    if (PropertyValidator.isValid((Object)risk.getTfsAttributes())) {
                        tfsId = risk.getTfsAttributes().getTfsId();
                    }
                    if (PropertyValidator.isValid(tfsId)) {
                        rowData.put("Risk #", tfsId);
                    } else {
                        rowData.put("Risk #", riskRegister.getRegisterKey() + "-" + risk.getRiskNumber());
                    }
                    if (this.checkIfRiskColumnActive("riskTitle", riskcolumnsList.getColumnList())) {
                        rowData.put("Risk Title", risk.getRiskTitle());
                    }
                    if (this.checkIfRiskColumnActive("riskDesc", riskcolumnsList.getColumnList())) {
                        rowData.put("Risk Description", PropertyValidator.isValid((Object)risk.getRiskDesc()) ? KendisUtils.parseRichText((String)risk.getRiskDesc()) : risk.getRiskDesc());
                    }
                    if (this.checkIfRiskColumnActive("probability", riskcolumnsList.getColumnList())) {
                        rowData.put("Probability", risk.getProbability() != null ? risk.getProbability().getTitle() : "");
                    }
                    if (this.checkIfRiskColumnActive("impact", riskcolumnsList.getColumnList())) {
                        rowData.put("Impact", risk.getImpact() != null ? risk.getImpact().getTitle() : "");
                    }
                    RiskLevel riskLevel = null;
                    if (risk.getProbability() != null && risk.getImpact() != null) {
                        List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
                        riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                    }
                    if (this.checkIfRiskColumnActive("riskLevel", riskcolumnsList.getColumnList())) {
                        rowData.put("Risk Level", riskLevel != null ? riskLevel.getTitle() : "");
                    }
                    if (this.checkIfRiskColumnActive("mitigation", riskcolumnsList.getColumnList())) {
                        rowData.put("Mitigation Actions", PropertyValidator.isValid((Object)risk.getMitigationActions()) ? KendisUtils.parseRichText((String)risk.getMitigationActions()) : risk.getMitigationActions());
                    }
                    if (this.checkIfRiskColumnActive("raisedDate", riskcolumnsList.getColumnList())) {
                        if (PropertyValidator.isValid((Object)risk.getRaisedDate())) {
                            rowData.put("Raised On", risk.getRaisedDate().toString());
                        } else {
                            rowData.put("Raised On", "");
                        }
                    }
                    if (this.checkIfRiskColumnActive("updatedOn", riskcolumnsList.getColumnList())) {
                        rowData.put("Last Updated", String.valueOf(risk.getUpdatedOn()));
                    }
                    if (this.checkIfRiskColumnActive("resolutionDate", riskcolumnsList.getColumnList())) {
                        rowData.put("Target Resolution Date", risk.getResolutionDate() != null ? risk.getResolutionDate().toString() : "");
                    }
                    if (this.checkIfRiskColumnActive("responsible", riskcolumnsList.getColumnList())) {
                        rowData.put("Responsible", risk.getResponsible() != null ? risk.getResponsible().getFullName() : "");
                    }
                    if (this.checkIfRiskColumnActive("responsibleDetails", riskcolumnsList.getColumnList())) {
                        User responsible = risk.getResponsible();
                        rowData.put("Responsible Details", this.formatResponsibleDetails(responsible));
                    }
                    if (this.checkIfRiskColumnActive("status", riskcolumnsList.getColumnList())) {
                        rowData.put("Status", risk.getStatus().getTitle());
                    }
                    if (this.checkIfRiskColumnActive("linkedItems", riskcolumnsList.getColumnList())) {
                        if (risk.getLinkedItemsIds() == null) {
                            rowData.put("Linked Items", "");
                        } else {
                            this.setActiveBoardItems(risk, sessions, null, new HashMap(), null);
                            String itemIds = "";
                            if (PropertyValidator.isValid((Collection)risk.getLinkedItems())) {
                                for (Item item : risk.getLinkedItems()) {
                                    if (PropertyValidator.isValid((Object)item.getTfsId())) {
                                        if (itemIds.length() == 0) {
                                            itemIds = itemIds + item.getTfsId();
                                            continue;
                                        }
                                        itemIds = itemIds + ", " + item.getTfsId();
                                        continue;
                                    }
                                    if (!PropertyValidator.isValid((Object)item.getJiraKey())) continue;
                                    if (itemIds.length() == 0) {
                                        itemIds = itemIds + item.getJiraKey();
                                        continue;
                                    }
                                    itemIds = itemIds + ", " + item.getJiraKey();
                                }
                            }
                            rowData.put("Linked Items", itemIds);
                        }
                    }
                    if (this.checkIfRiskColumnActive("convCount", riskcolumnsList.getColumnList())) {
                        Integer convCount = this.conversationRepository.countAllByRiskId(risk.getId());
                        rowData.put("Conversation Count", convCount);
                    }
                    if (this.checkIfRiskColumnActive("team", riskcolumnsList.getColumnList())) {
                        StringBuilder teamNames = new StringBuilder();
                        if (PropertyValidator.isValid((Collection)risk.getBoardTeams())) {
                            for (BoardTeam bT : risk.getBoardTeams()) {
                                if (!"risk".equalsIgnoreCase(side) && !bT.getSessionId().equalsIgnoreCase(sessionId)) continue;
                                if (risk.getBoardTeams().size() == 1) {
                                    teamNames.append(bT.getTeamTitle());
                                    continue;
                                }
                                teamNames.append(bT.getTeamTitle()).append(",");
                            }
                            rowData.put("Teams", teamNames.toString());
                        }
                    }
                    if (this.checkIfRiskColumnActive("sprint", riskcolumnsList.getColumnList())) {
                        StringBuilder sprintNames = new StringBuilder();
                        if (PropertyValidator.isValid((Collection)risk.getBoardSprints())) {
                            for (Object bS : risk.getBoardSprints()) {
                                if (!"risk".equalsIgnoreCase(side) && !bS.getSessionId().equalsIgnoreCase(sessionId)) continue;
                                if (risk.getBoardSprints().size() == 1) {
                                    sprintNames.append(bS.getSprintTitle());
                                    continue;
                                }
                                sprintNames.append(bS.getSprintTitle()).append(",");
                            }
                            rowData.put("Sprints", sprintNames.toString());
                        }
                    }
                    if (this.checkIfRiskColumnActive("piBoard", riskcolumnsList.getColumnList())) {
                        boardNames = new StringBuilder();
                        if (PropertyValidator.isValid((Collection)risk.getLinkedPiBoards())) {
                            for (Object bS : risk.getLinkedPiBoards()) {
                                if (risk.getLinkedPiBoards().size() == 1) {
                                    ((StringBuilder)boardNames).append(bS.get("title"));
                                    continue;
                                }
                                ((StringBuilder)boardNames).append(bS.get("title")).append(",");
                            }
                            rowData.put("Program Boards", ((StringBuilder)boardNames).toString());
                        }
                    }
                    if (this.checkIfRiskColumnActive("solBoard", riskcolumnsList.getColumnList())) {
                        boardNames = new StringBuilder();
                        if (PropertyValidator.isValid((Collection)risk.getLinkedSolutionBoards())) {
                            for (Object bS : risk.getLinkedSolutionBoards()) {
                                if (risk.getLinkedSolutionBoards().size() == 1) {
                                    ((StringBuilder)boardNames).append(bS.get("title"));
                                    continue;
                                }
                                ((StringBuilder)boardNames).append(bS.get("title")).append(",");
                            }
                            rowData.put("Solution Boards", ((StringBuilder)boardNames).toString());
                        }
                    }
                    if (this.checkIfRiskColumnActive("orgBoard", riskcolumnsList.getColumnList())) {
                        boardNames = new StringBuilder();
                        if (PropertyValidator.isValid((Collection)risk.getLinkedOrgCollections())) {
                            for (Object bS : risk.getLinkedOrgCollections()) {
                                if (risk.getLinkedOrgCollections().size() == 1) {
                                    ((StringBuilder)boardNames).append(bS.get("title"));
                                    continue;
                                }
                                ((StringBuilder)boardNames).append(bS.get("title")).append(",");
                            }
                            rowData.put("Collections", ((StringBuilder)boardNames).toString());
                        }
                    }
                    if (PropertyValidator.isValid((Object)riskLayout)) {
                        for (FieldEntity fieldEntity : riskLayout.getFields()) {
                            if (!this.checkIfRiskColumnActive(fieldEntity.getField().getId(), riskcolumnsList.getColumnList())) continue;
                            String key = fieldEntity.getField().getId();
                            String title = fieldEntity.getField().getTitle();
                            if (PropertyValidator.isValid((Object)risk.getFields()) && PropertyValidator.isValid(risk.getFields().get(key))) {
                                String str;
                                if (risk.getFields().get(key) instanceof String) {
                                    String str2 = ((String)risk.getFields().get(key)).replaceAll("<[^>]*>", "");
                                    str2 = str2.replaceAll("&nbsp;", "\n");
                                    rowData.put(title, str2);
                                    continue;
                                }
                                if (risk.getFields().get(key) instanceof List) {
                                    ArrayList objs = (ArrayList)risk.getFields().get(key);
                                    str = "";
                                    for (int i = 0; i < objs.size(); ++i) {
                                        Map obj = (Map)objs.get(i);
                                        str = str + obj.get("title");
                                        if (i >= objs.size() - 1) continue;
                                        str = str + ", ";
                                    }
                                    rowData.put(title, str);
                                    continue;
                                }
                                if (!(risk.getFields().get(key) instanceof Object)) continue;
                                HashMap obj = (HashMap)risk.getFields().get(key);
                                if (PropertyValidator.isValid(obj.get("title"))) {
                                    rowData.put(title, (String)obj.get("title"));
                                    continue;
                                }
                                if (PropertyValidator.isValid(obj.get("fullName"))) {
                                    rowData.put(title, (String)obj.get("fullName"));
                                    continue;
                                }
                                if (!PropertyValidator.isValid(obj.get("name"))) continue;
                                str = (String)obj.get("name");
                                String url = "";
                                if (PropertyValidator.isValid(obj.get("url"))) {
                                    url = (String)obj.get("url");
                                }
                                rowData.put(title, str + " : " + url);
                                continue;
                            }
                            rowData.put(title, "");
                        }
                    }
                    try {
                        writer.write(rowData, completeHeader);
                    }
                    catch (Exception boardNames2) {}
                }
                writer.close();
            } else {
                completeHeader = null;
                try (XSSFWorkbook workbook = new XSSFWorkbook();){
                    XSSFSheet worksheet = workbook.createSheet("Kendis Worksheet");
                    int rowIndex = 0;
                    XSSFRow row = worksheet.createRow(rowIndex++);
                    for (int i = 0; i < columnList.size(); ++i) {
                        XSSFCell cell = row.createCell(i);
                        XSSFCellStyle cellStyle = workbook.createCellStyle();
                        cellStyle.setFillForegroundColor(IndexedColors.GOLD.index);
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                        cell.setCellStyle((CellStyle)cellStyle);
                        cell.setCellValue((String)columnList.get(i));
                        worksheet.autoSizeColumn(i);
                    }
                    worksheet.setColumnWidth(1, 10000);
                    worksheet.setColumnWidth(5, 10000);
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setWrapText(true);
                    for (Risk risk : risks) {
                        Object title;
                        int colIndex = 0;
                        row = worksheet.createRow(rowIndex++);
                        XSSFCell cell = null;
                        String tfsId = null;
                        if (PropertyValidator.isValid((Object)risk.getTfsAttributes())) {
                            tfsId = risk.getTfsAttributes().getTfsId();
                        }
                        if (PropertyValidator.isValid(tfsId)) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(tfsId);
                            cell.setCellStyle((CellStyle)cellStyle);
                        } else {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(riskRegister.getRegisterKey() + "-" + risk.getRiskNumber());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("riskTitle", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getRiskTitle());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("riskDesc", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(PropertyValidator.isValid((Object)risk.getRiskDesc()) ? KendisUtils.parseRichText((String)risk.getRiskDesc()) : risk.getRiskDesc());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("probability", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getProbability() != null ? risk.getProbability().getTitle() : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("impact", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getImpact() != null ? risk.getImpact().getTitle() : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        RiskLevel riskLevel = null;
                        if (risk.getProbability() != null && risk.getImpact() != null) {
                            List riskLevelList = riskRegister.getRiskMatrix().getRiskLevelList();
                            riskLevel = this.calculateRiskLevel(risk.getProbability().getValue(), risk.getImpact().getValue(), riskLevelList);
                        }
                        if (this.checkIfRiskColumnActive("riskLevel", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(riskLevel != null ? riskLevel.getTitle() : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("mitigation", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(PropertyValidator.isValid((Object)risk.getMitigationActions()) ? KendisUtils.parseRichText((String)risk.getMitigationActions()) : risk.getMitigationActions());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("raisedDate", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Object)risk.getRaisedDate())) {
                                cell.setCellValue(risk.getRaisedDate().toString());
                            } else {
                                cell.setCellValue("");
                            }
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("updatedOn", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getUpdatedOn() != null ? String.valueOf(risk.getUpdatedOn()) : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("resolutionDate", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getResolutionDate() != null ? risk.getResolutionDate().toString() : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("responsible", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getResponsible() != null ? risk.getResponsible().getFullName() : "");
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("responsibleDetails", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            User responsible = risk.getResponsible();
                            cell.setCellValue(this.formatResponsibleDetails(responsible));
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("status", riskcolumnsList.getColumnList()) && PropertyValidator.isValid((Object)risk.getStatus())) {
                            cell = row.createCell(colIndex++);
                            cell.setCellValue(risk.getStatus().getTitle());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("linkedItems", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (risk.getLinkedItemsIds() == null) {
                                cell.setCellValue(0.0);
                            } else {
                                this.setActiveBoardItems(risk, sessions, null, new HashMap(), null);
                                String itemIds = "";
                                if (PropertyValidator.isValid((Collection)risk.getLinkedItems())) {
                                    for (Item item : risk.getLinkedItems()) {
                                        if (PropertyValidator.isValid((Object)item.getTfsId())) {
                                            if (itemIds.length() == 0) {
                                                itemIds = itemIds + item.getTfsId();
                                                continue;
                                            }
                                            itemIds = itemIds + ", " + item.getTfsId();
                                            continue;
                                        }
                                        if (!PropertyValidator.isValid((Object)item.getJiraKey())) continue;
                                        if (itemIds.length() == 0) {
                                            itemIds = itemIds + item.getJiraKey();
                                            continue;
                                        }
                                        itemIds = itemIds + ", " + item.getJiraKey();
                                    }
                                }
                                cell.setCellValue(itemIds);
                            }
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("convCount", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            Integer convCount = this.conversationRepository.countAllByRiskId(risk.getId());
                            cell.setCellValue((double)convCount.intValue());
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                        if (this.checkIfRiskColumnActive("team", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Collection)risk.getBoardTeams())) {
                                ArrayList<String> teamTitles = new ArrayList<String>();
                                for (BoardTeam bT : risk.getBoardTeams()) {
                                    if (!"risk".equalsIgnoreCase(side) && (bT.getSessionId() == null || !bT.getSessionId().equalsIgnoreCase(sessionId)) || bT.getTeamTitle() == null) continue;
                                    teamTitles.add(bT.getTeamTitle());
                                }
                                cell.setCellValue(String.join((CharSequence)",", teamTitles));
                                cell.setCellStyle((CellStyle)cellStyle);
                            }
                        }
                        if (this.checkIfRiskColumnActive("sprint", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Collection)risk.getBoardSprints())) {
                                ArrayList<String> sprintTitles = new ArrayList<String>();
                                for (Object bS : risk.getBoardSprints()) {
                                    if (!"risk".equalsIgnoreCase(side) && (bS.getSessionId() == null || !bS.getSessionId().equalsIgnoreCase(sessionId)) || bS.getSprintTitle() == null) continue;
                                    sprintTitles.add(bS.getSprintTitle());
                                }
                                cell.setCellValue(String.join((CharSequence)",", sprintTitles));
                                cell.setCellStyle((CellStyle)cellStyle);
                            }
                        }
                        if (this.checkIfRiskColumnActive("piBoard", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Collection)risk.getLinkedPiBoards())) {
                                ArrayList<String> piBoardTitles = new ArrayList<String>();
                                for (Object bS : risk.getLinkedPiBoards()) {
                                    title = bS.get("title");
                                    if (title == null) continue;
                                    piBoardTitles.add(title.toString());
                                }
                                cell.setCellValue(String.join((CharSequence)",", piBoardTitles));
                                cell.setCellStyle((CellStyle)cellStyle);
                            }
                        }
                        if (this.checkIfRiskColumnActive("solBoard", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Collection)risk.getLinkedSolutionBoards())) {
                                ArrayList<String> solBoardTitles = new ArrayList<String>();
                                for (Object bS : risk.getLinkedSolutionBoards()) {
                                    title = bS.get("title");
                                    if (title == null) continue;
                                    solBoardTitles.add(title.toString());
                                }
                                cell.setCellValue(String.join((CharSequence)",", solBoardTitles));
                                cell.setCellStyle((CellStyle)cellStyle);
                            }
                        }
                        if (this.checkIfRiskColumnActive("orgBoard", riskcolumnsList.getColumnList())) {
                            cell = row.createCell(colIndex++);
                            if (PropertyValidator.isValid((Collection)risk.getLinkedOrgCollections())) {
                                ArrayList<String> orgBoardTitles = new ArrayList<String>();
                                for (Object bS : risk.getLinkedOrgCollections()) {
                                    title = bS.get("title");
                                    if (title == null) continue;
                                    orgBoardTitles.add(title.toString());
                                }
                                cell.setCellValue(String.join((CharSequence)",", orgBoardTitles));
                                cell.setCellStyle((CellStyle)cellStyle);
                            }
                        }
                        if (!PropertyValidator.isValid((Object)riskLayout)) continue;
                        for (FieldEntity fieldEntity : riskLayout.getFields()) {
                            if (!this.checkIfRiskColumnActive(fieldEntity.getField().getId(), riskcolumnsList.getColumnList())) continue;
                            cell = row.createCell(colIndex++);
                            String key = fieldEntity.getField().getId();
                            if (PropertyValidator.isValid((Object)risk.getFields()) && PropertyValidator.isValid(risk.getFields().get(key))) {
                                String str;
                                if (risk.getFields().get(key) instanceof String) {
                                    String str3 = ((String)risk.getFields().get(key)).replaceAll("<[^>]*>", "");
                                    str3 = str3.replaceAll("&nbsp;", "\n");
                                    cell.setCellValue(str3);
                                } else if (risk.getFields().get(key) instanceof List) {
                                    ArrayList objs = (ArrayList)risk.getFields().get(key);
                                    str = "";
                                    for (int i = 0; i < objs.size(); ++i) {
                                        Map obj = (Map)objs.get(i);
                                        str = str + obj.get("title");
                                        if (i >= objs.size() - 1) continue;
                                        str = str + ", ";
                                    }
                                    cell.setCellValue(str);
                                } else if (risk.getFields().get(key) instanceof Object) {
                                    HashMap obj = (HashMap)risk.getFields().get(key);
                                    if (PropertyValidator.isValid(obj.get("title"))) {
                                        cell.setCellValue((String)obj.get("title"));
                                    } else if (PropertyValidator.isValid(obj.get("fullName"))) {
                                        cell.setCellValue((String)obj.get("fullName"));
                                    } else if (PropertyValidator.isValid(obj.get("name"))) {
                                        str = (String)obj.get("name");
                                        String url = "";
                                        if (PropertyValidator.isValid(obj.get("url"))) {
                                            url = (String)obj.get("url");
                                        }
                                        cell.setCellValue(str + " : " + url);
                                    }
                                }
                            } else {
                                cell.setCellValue(" ");
                            }
                            cell.setCellStyle((CellStyle)cellStyle);
                        }
                    }
                    workbook.write((OutputStream)file);
                }
                catch (Throwable worksheet) {
                    completeHeader = worksheet;
                    throw worksheet;
                }
            }
            file.flush();
            file.close();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MMM/yyyy HH:mm");
            String downloadName = "risks_" + formatter.format(new Date()) + "." + extension;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", filePath);
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private String formatResponsibleDetails(User responsible) {
        if (responsible == null) {
            return "";
        }
        String fullName = PropertyValidator.isValid((Object)responsible.getFullName()) ? responsible.getFullName() : "";
        String email = PropertyValidator.isValid((Object)responsible.getEmail()) ? " <" + responsible.getEmail() + ">" : "";
        return fullName + email;
    }

    @RequestMapping(value={"/get-risk-history/{riskId}/{zoneOffset}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getRiskHistory(@PathVariable String riskId, @PathVariable String zoneOffset) {
        List historyList = this.getRiskHistoryList(riskId, zoneOffset, Boolean.valueOf(false));
        return new ResponseEntity((Object)historyList, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-selected"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchSelected(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, List> response = new HashMap<String, List>();
        String boardIds = (String)payload.get("boardIds");
        List selectedItems = (List)payload.get("selectedItems");
        List<String> boardIdsList = null;
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        if (PropertyValidator.isValid((Object)boardIds)) {
            boardIdsList = Arrays.asList(boardIds.split(","));
            for (String sid : boardIdsList) {
                if (sid.equalsIgnoreCase("-1")) continue;
                ids.add(new ObjectId(sid));
            }
        }
        List sessions = this.sessionRepository.findSessionIdsByIdIn(ids);
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        List sessionBoardsUnfiltered = this.sessionBoardRepository.findBoardsBySessionIn(sessions);
        ArrayList<ObjectId> sessionBoardIds = new ArrayList<ObjectId>();
        for (SessionBoard sessionBoard : sessionBoardsUnfiltered) {
            if (sessionBoard.getStatus() != null && !sessionBoard.getStatus().equals("Open")) continue;
            sessionBoards.add(sessionBoard);
            sessionBoardIds.add(new ObjectId(sessionBoard.getId()));
        }
        String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
        List items = this.findItemsForFetchSelected(KendisUtils.getListAsObjectIds((Collection)selectedItems), sessionBoardIds, "UserStory", tenant, false);
        response.put("items", items);
        return new ResponseEntity(response, HttpStatus.OK);
    }

    private List<Item> findItemsForFetchSelected(List<ObjectId> selectedItems, List<ObjectId> sessionBoardIds, String type, String tenant, boolean archive) {
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("archive", (Object)archive).append("tenant", (Object)tenant).append("type", (Object)type).append("sessionBoards.$id", (Object)new BasicDBObject("$in", sessionBoardIds)).append("_id", (Object)new BasicDBObject("$in", selectedItems)));
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject sessionBoardLookup = DBUtils.createLookup((String)"sessionBoard", (String)"sessionBoards.$id", (String)"_id", (String)"sessionBoards");
        BasicDBObject statusUnWind = DBUtils.createUnWind((String)"$status");
        BasicDBObject sessionBoardUnWind = DBUtils.createUnWind((String)"$sessionBoards");
        BasicDBObject sessionLookup = DBUtils.createLookup((String)"session", (String)"sessionBoards.session.$id", (String)"_id", (String)"sessionBoards.session");
        BasicDBObject sessionUnWind = DBUtils.createUnWind((String)"$sessionBoards.session");
        BasicDBObject parentLookup = DBUtils.createLookup((String)"item", (String)"parent.$id", (String)"_id", (String)"parent");
        BasicDBObject parentUnWind = DBUtils.createUnWind((String)"$parent");
        BasicDBObject issueTypeLookup = DBUtils.createLookup((String)"issueType", (String)"issueType.$id", (String)"_id", (String)"issueType");
        BasicDBObject issueTypeUnWind = DBUtils.createUnWindWithPath((String)"$issueType", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("parent._id", (Object)1).append("parent.title", (Object)1).append("parent.jiraId", (Object)1).append("parent.jiraKey", (Object)1).append("parent.kendisKey", (Object)1).append("parent.tfsId", (Object)1).append("parent.type", (Object)1).append("title", (Object)1).append("status._id", (Object)1).append("status.title", (Object)1).append("status.color", (Object)1).append("status.category", (Object)1).append("status.jiraProjKey", (Object)1).append("status.jiraIssueTypeId", (Object)1).append("status.jiraStatusId", (Object)1).append("status.jiraStatusCatId", (Object)1).append("status.jiraStatusOriginalCategory", (Object)1).append("status.tfsId", (Object)1).append("status.tfsProject", (Object)1).append("status.tfsProjectId", (Object)1).append("status.sessionId", (Object)1).append("status.solutionId", (Object)1).append("status.almId", (Object)1).append("status.rowStatus", (Object)1).append("jiraKey", (Object)1).append("jiraId", (Object)1).append("tfsId", (Object)1).append("tfsURL", (Object)1).append("sessionBoards", (Object)1).append("type", (Object)1).append("issueType", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, statusLookup, statusUnWind, sessionBoardLookup, sessionBoardUnWind, sessionLookup, sessionUnWind, parentLookup, parentUnWind, issueTypeLookup, issueTypeUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        ArrayList<Item> items = new ArrayList<Item>();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                Item item = new Item();
                item.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]));
                item.setTitle((String)object.get("title"));
                item.setType((String)object.get("type"));
                item.setJiraId((String)object.get("jiraId"));
                item.setJiraKey((String)object.get("jiraKey"));
                item.setTfsId((String)object.get("tfsId"));
                item.setTfsURL((String)object.get("tfsURL"));
                item.setStatus(new Status((BasicDBObject)object.get("status")));
                if (!DBUtils.isEmptyObject((Object)object.get("issueType"))) {
                    item.setIssueType(new IssueType((BasicDBObject)object.get("issueType")));
                }
                if (!DBUtils.isEmptyObject((Object)object.get("sessionBoards"))) {
                    ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                    sessionBoards.add(new SessionBoard((BasicDBObject)object.get("sessionBoards")));
                    item.setSessionBoards(sessionBoards);
                }
                if (!DBUtils.isEmptyObject((Object)object.get("parent"))) {
                    Item parentItem = new Item();
                    parentItem.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object.get("parent")), (String[])new String[0]));
                    parentItem.setTitle((String)object.get("title"));
                    parentItem.setJiraId((String)object.get("jiraId"));
                    parentItem.setJiraKey((String)object.get("jiraKey"));
                    parentItem.setKendisKey((String)object.get("kendisKey"));
                    parentItem.setTfsId((String)object.get("tfsId"));
                    parentItem.setType((String)object.get("type"));
                    item.setParent(parentItem);
                }
                items.add(item);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return items;
    }

    public List<String> getRiskHistoryList(String riskId, String zoneOffset, Boolean forEmail) {
        ArrayList<String> historyList = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        List itemList = this.itemLogRepository.findByItemIdAndItemTypeOrderByCreatedOnDesc(riskId, "Risk");
        for (ItemLog item : itemList) {
            boolean anyActivity = false;
            String historyString = "";
            String jsonChanges = item.getChanges();
            if (jsonChanges == null) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(item.getCreatedOn());
            cal.add(12, Integer.parseInt(zoneOffset));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = dateFormat.format(cal.getTime());
            String eventType = item.getEventType().substring(0, 1).toUpperCase() + item.getEventType().substring(1).toLowerCase();
            if (!forEmail.booleanValue()) {
                historyString = historyString + "<div class='nm-dt'> " + eventType + " by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
            }
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                Iterator iterator = map.entrySet().iterator();
                boolean isFirstMapIter = true;
                while (iterator.hasNext()) {
                    Map.Entry pair = iterator.next();
                    if (pair.getKey().equals("id") || pair.getKey().equals("archive")) continue;
                    anyActivity = true;
                    historyString = historyString + " <div class='line prow '> ";
                    if (forEmail.booleanValue()) {
                        historyString = historyString + "&#8226;    ";
                    }
                    if (!pair.getKey().equals("linkedItemsIds") && !pair.getKey().equals("fields")) {
                        historyString = historyString + StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)pair.getKey().toString()), (char)' '));
                    }
                    if (pair.getKey().equals("status") || pair.getKey().equals("responsible") || pair.getKey().equals("probability") || pair.getKey().equals("impact")) {
                        historyString = historyString + this.getLastHistory(pair, itemList, item);
                    } else if (pair.getKey().equals("linkedItemsIds")) {
                        historyString = historyString + "<span class='a'>Linked Items count updated to " + ((List)pair.getValue()).size() + "</span>";
                    } else if (pair.getKey().equals("fields")) {
                        List fieldsList = this.fieldsRepository.findAll();
                        HashMap fieldsIdMap = new HashMap();
                        fieldsList.forEach(field -> fieldsIdMap.put(field.getId(), field));
                        HashMap fieldsMap = (HashMap)pair.getValue();
                        Iterator fieldsIterator = fieldsMap.entrySet().iterator();
                        if (!fieldsMap.isEmpty()) {
                            while (fieldsIterator.hasNext()) {
                                Map.Entry fieldPair = fieldsIterator.next();
                                String fieldKey = (String)fieldPair.getKey();
                                Fields field2 = (Fields)fieldsIdMap.get(fieldKey);
                                String value = "";
                                Object fieldValue = fieldPair.getValue();
                                if (PropertyValidator.isValid((Object)field2)) {
                                    Object right;
                                    Object left;
                                    historyString = historyString + " <div class='line prow '> ";
                                    historyString = historyString + StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)field2.getTitle()), (char)' '));
                                    if (field2.getType().equals("userpicker")) {
                                        LinkedHashMap user = (LinkedHashMap)fieldValue;
                                        if (PropertyValidator.isValid(user.get("left")) && PropertyValidator.isValid(user.get("right"))) {
                                            left = (Map)user.get("left");
                                            right = (Map)user.get("right");
                                            historyString = historyString + "<span class='b'> changed from \"" + left.get("fullName") + "\" to \"" + right.get("fullName") + "\"</span>";
                                        } else {
                                            historyString = historyString + "<span class='b'> changed to \"" + user.get("fullName") + "\"</span>";
                                        }
                                    } else if (field2.getType().equals("multiselect")) {
                                        if (fieldValue instanceof Map) {
                                            int i;
                                            LinkedHashMap multiselect = (LinkedHashMap)fieldValue;
                                            left = (List)multiselect.get("left");
                                            right = (List)multiselect.get("right");
                                            String str1 = "";
                                            String str2 = "";
                                            for (i = 0; i < right.size(); ++i) {
                                                str2 = str2 + ((Map)right.get(i)).get("title");
                                                if (i == right.size() - 1) continue;
                                                str2 = str2 + ", ";
                                            }
                                            if (left.size() != 0) {
                                                for (i = 0; i < left.size(); ++i) {
                                                    str1 = str1 + ((Map)left.get(i)).get("title");
                                                    if (i == left.size() - 1) continue;
                                                    str1 = str1 + ", ";
                                                }
                                                historyString = historyString + "<span class='b'> changed from \"" + str1 + "\" to \"" + str2 + "\"</span>";
                                            } else {
                                                historyString = historyString + "<span class='b'> changed to \"" + str2 + "\"</span>";
                                            }
                                        } else {
                                            List left2 = (List)fieldValue;
                                            String str1 = (String)((Map)left2.get(0)).get("title");
                                            historyString = historyString + "<span class='b'> changed to \"" + str1 + "\"</span>";
                                        }
                                    } else if (field2.getType().equals("singleselect")) {
                                        LinkedHashMap singleselect = (LinkedHashMap)fieldValue;
                                        if (PropertyValidator.isValid(singleselect.get("left")) && PropertyValidator.isValid(singleselect.get("right"))) {
                                            left = (Map)singleselect.get("left");
                                            right = (Map)singleselect.get("right");
                                            historyString = historyString + "<span class='b'> changed from \"" + left.get("title") + "\" to \"" + right.get("title") + "\"</span>";
                                        } else {
                                            historyString = historyString + "<span class='b'> changed to \"" + singleselect.get("title") + "\"</span>";
                                        }
                                    } else if (field2.getType().equals("datepicker")) {
                                        if (fieldValue instanceof LinkedHashMap) {
                                            LinkedHashMap datepicker = (LinkedHashMap)fieldValue;
                                            String date2 = (String)datepicker.get("right");
                                            date2 = date2.split("T")[0];
                                            if (PropertyValidator.isValid(datepicker.get("left"))) {
                                                String date1 = (String)datepicker.get("left");
                                                date1 = date1.split("T")[0];
                                                historyString = historyString + "<span class='b'> changed from \"" + date1 + "\" to \"" + date2 + "\"</span>";
                                            } else {
                                                historyString = historyString + "<span class='b'> changed to \"" + date2 + "\"</span>";
                                            }
                                        } else {
                                            String date = (String)fieldValue;
                                            date = date.split("T")[0];
                                            historyString = historyString + "<span class='b'> changed to \"" + date + "\"</span>";
                                        }
                                    } else if (field2.getType().equals("link")) {
                                        LinkedHashMap linkType = (LinkedHashMap)fieldValue;
                                        if (PropertyValidator.isValid(linkType.get("left")) && PropertyValidator.isValid(linkType.get("right"))) {
                                            left = (Map)linkType.get("left");
                                            right = (Map)linkType.get("right");
                                            historyString = historyString + "<span class='b'> changed name: \"" + left.get("name") + "\" with URL: \"" + left.get("url") + "\" to name: \"" + right.get("name") + "\" with URL: \"" + right.get("url") + "\"</span>";
                                        } else {
                                            historyString = historyString + "<span class='b'> changed to name: \"" + linkType.get("name") + "\" with URL: \"" + linkType.get("url") + "\"</span>";
                                        }
                                    } else if (fieldValue instanceof Map) {
                                        LinkedHashMap otherField = (LinkedHashMap)fieldValue;
                                        if (PropertyValidator.isValid(otherField.get("left")) && PropertyValidator.isValid(otherField.get("right"))) {
                                            historyString = historyString + "<span class='b'> changed from \"" + otherField.get("left") + "\" to \"" + otherField.get("right") + "\"</span>";
                                        } else if (PropertyValidator.isValid(otherField.get("right"))) {
                                            historyString = historyString + "<span class='b'> changed to \"" + otherField.get("right") + "\"</span>";
                                        }
                                    } else {
                                        historyString = historyString + "<span class='b'> changed to \"" + fieldPair.getValue() + "\"</span>";
                                    }
                                }
                                historyString = historyString + " </div> ";
                                anyActivity = true;
                            }
                        }
                    } else {
                        String value = String.valueOf(pair.getValue());
                        if (pair.getKey().equals("raisedDate") || pair.getKey().equals("resolutionDate")) {
                            SimpleDateFormat formatter = new SimpleDateFormat("MMM d, yyyy H:mm:ss a");
                            Date parsedDate = null;
                            try {
                                parsedDate = formatter.parse(value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            formatter = new SimpleDateFormat("d MMM yyyy");
                            value = formatter.format(parsedDate);
                        }
                        historyString = historyString + "<span class='b'> changed to \"" + value + "\"</span>";
                    }
                    historyString = historyString + " </div> ";
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (anyActivity) {
                historyList.add(historyString);
            }
            if (!forEmail.booleanValue()) continue;
            break;
        }
        Collections.reverse(historyList);
        return historyList;
    }

    private Boolean getLastItemStatus(List<ItemLog> itemList, String id, String type, ItemLog item) {
        Integer count = 0;
        String oldId = "";
        Object history = null;
        String lastStatus = "";
        ObjectMapper mapper = new ObjectMapper();
        boolean startCheck = false;
        boolean breakLoop = false;
        for (ItemLog itemLog : itemList) {
            String jsonChanges;
            if (breakLoop) break;
            if (itemLog.getId().equals(item.getId())) {
                startCheck = true;
            }
            if (!startCheck || (jsonChanges = itemLog.getChanges()) == null) continue;
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (!pair.getKey().equals(type)) continue;
                    Map map2 = (Map)pair.getValue();
                    oldId = type.equals("responsible") ? (String)map2.get("id") : (String)map2.get("title");
                    if (oldId.equals(id)) {
                        Integer n = count;
                        Integer n2 = count = Integer.valueOf(count + 1);
                        continue;
                    }
                    breakLoop = true;
                }
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        if (count != 0 && count % 2 == 0) {
            return true;
        }
        return false;
    }

    private String getLastHistory(Map.Entry mapPair, List<ItemLog> itemList, ItemLog item) {
        String oldId = "";
        String oldTitle = "";
        String history = " changed ";
        String lastStatus = "";
        String type = (String)mapPair.getKey();
        ObjectMapper mapper = new ObjectMapper();
        boolean startCheck = false;
        boolean breakLoop = false;
        for (ItemLog itemLog : itemList) {
            String jsonChanges;
            if (breakLoop) break;
            if (itemLog.getId().equals(item.getId())) {
                startCheck = true;
                continue;
            }
            if (!startCheck || (jsonChanges = itemLog.getChanges()) == null) continue;
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (!pair.getKey().equals(type)) continue;
                    Map map2 = (Map)pair.getValue();
                    oldId = (String)map2.get("id");
                    oldTitle = (String)map2.get("title");
                    if (type.equals("status")) {
                        history = history + "from \"" + this.getObjectTitle(type, map2) + "\"";
                    }
                    breakLoop = true;
                }
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        Map map2 = (Map)mapPair.getValue();
        String newId = null;
        if (type.equals("responsible")) {
            newId = (String)map2.get("id");
        } else if (type.equals("probability") || type.equals("impact")) {
            newId = (String)map2.get("title");
        }
        history = (type.equals("probability") || type.equals("impact")) && this.getLastItemStatus(itemList, newId, type, item) == true ? history + " to \"None\"" : (type.equals("responsible") && this.getLastItemStatus(itemList, newId, type, item) == true ? history + " to \"Unassigned\"" : history + " to \"" + this.getObjectTitle(type, map2) + "\"");
        return history;
    }

    private String getObjectTitle(String type, Map<Object, Object> map) {
        User responsible;
        String id;
        Status status;
        if (type.equals("status") && (status = (Status)this.statusRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return status.getTitle();
        }
        if (type.equals("responsible") && (responsible = (User)this.userRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return responsible.getFullName();
        }
        if (type.equals("probability") || type.equals("impact")) {
            String title = (String)map.get("title");
            return title;
        }
        return null;
    }

    private String getItemLink(Item item) {
        String externalLink = "";
        if (!PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            return null;
        }
        SessionBoard sessionBoard = (SessionBoard)item.getSessionBoards().get(0);
        Session session = sessionBoard.getSession();
        String referenceBaseUrl = null;
        if (session.getAlmEnabled().booleanValue()) {
            if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
                referenceBaseUrl = PropertyValidator.isValid((Object)((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL()) ? ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getJiraAuthRedirectURL() + "/browse" : ((AlmConfigurations)session.getAlmConfigurations().get(0)).getAlmAccount().getUrl() + "/browse";
            } else if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                referenceBaseUrl = item.getTfsURL();
            }
        } else {
            referenceBaseUrl = session.getJiraBaseURL() != null ? session.getJiraBaseURL() : "";
        }
        if (item.getJiraKey() != null && item.getJiraId() != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        } else if (item.getJiraKey() != null && item.getExternalReferenceURL() != null) {
            externalLink = item.getExternalReferenceURL();
        } else if (item.getJiraKey() != null && referenceBaseUrl != null) {
            externalLink = referenceBaseUrl.equals("") ? "javascript:void(0);" : referenceBaseUrl + "/" + item.getJiraKey();
        }
        return externalLink;
    }

    private Risk filterExternalItems(Risk savedRisk, Risk risk) {
        HashMap externalItemIds = new HashMap();
        List sessions = this.customRepositoryImpl.findSessionsByRiskRegisterId(savedRisk.getRiskRegister().getId());
        List solBoards = this.customRepositoryImpl.findSolutionBoardsByRiskRegisterId(savedRisk.getRiskRegister().getId());
        this.setActiveBoardItems(savedRisk, sessions, externalItemIds, new HashMap(), solBoards);
        this.setFeatureStoryPoints(savedRisk.getLinkedItems());
        Map filteredKeys = savedRisk.getLinkedItemsById();
        if (PropertyValidator.isValid((Object)filteredKeys)) {
            externalItemIds.putAll(filteredKeys);
        }
        if (PropertyValidator.isValid((Object)risk.getLinkedItemsById())) {
            externalItemIds.putAll(risk.getLinkedItemsById());
        }
        savedRisk = (Risk)this.riskRepository.save((Object)savedRisk);
        savedRisk.adjustLinkedItemIds();
        return savedRisk;
    }

    public HashMap<String, ? super Object> toSimpleObject(Item item) {
        HashMap<String, String> rowData = new HashMap<String, String>();
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            rowData.put("jiraId", item.getJiraId());
            rowData.put("jiraKey", item.getJiraKey());
            rowData.put("key", item.getJiraKey());
        }
        if (PropertyValidator.isValid((Object)item.getTfsId())) {
            rowData.put("tfsId", item.getTfsId());
            rowData.put("key", item.getTfsId());
            rowData.put("tfsURL", item.getTfsURL());
        }
        if (!PropertyValidator.isValid((Object)item.getTfsId()) && !PropertyValidator.isValid((Object)item.getJiraId())) {
            if (PropertyValidator.isValid((Object)item.getJiraKey())) {
                rowData.put("key", item.getJiraKey());
            } else if (PropertyValidator.isValid((Object)item.getKendisKey())) {
                rowData.put("key", item.getKendisKey());
            } else {
                rowData.put("key", "");
            }
            rowData.put("localId", item.getId());
        } else if (PropertyValidator.isValid((Object)item.getExternalReferenceURL())) {
            rowData.put("externalReferenceURL", this.getItemLink(item));
        } else {
            rowData.put("externalReferenceURL", item.getExternalReferenceURL());
        }
        if (PropertyValidator.isValid((Collection)item.getSessionBoards()) && PropertyValidator.isValid(item.getSessionBoards().get(0)) && PropertyValidator.isValid((Object)((SessionBoard)item.getSessionBoards().get(0)).getSession())) {
            rowData.put("sessionBoard_id", ((SessionBoard)item.getSessionBoards().get(0)).getId());
            rowData.put("session_id", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
            rowData.put("session_title", ((SessionBoard)item.getSessionBoards().get(0)).getSession().getTitle());
        }
        if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
            rowData.put("solution_id", item.getSolutionBoard().getId());
            rowData.put("solution_title", item.getSolutionBoard().getTitle());
        }
        return rowData;
    }

    private Set<DBRef> findTeamContainerRefsFromRawItems(List<DBObject> rawItems) {
        HashSet<DBRef> teamContainerRefs = new HashSet<DBRef>();
        if (PropertyValidator.isValid(rawItems)) {
            rawItems.forEach(rawItem -> {
                if (PropertyValidator.isValid((Object)rawItem.get("teamContainers"))) {
                    List containerRefs = (List)rawItem.get("teamContainers");
                    teamContainerRefs.addAll(containerRefs);
                }
            });
        }
        return teamContainerRefs;
    }

    private List<TeamContainer> findTeamContainersByIdIn(List<String> tcIds) {
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (!PropertyValidator.isValid(tcIds)) {
            return teamContainers;
        }
        List teamContainerObjIds = tcIds.stream().map(ObjectId::new).collect(Collectors.toList());
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", teamContainerObjIds)));
        BasicDBObject containersLookup = DBUtils.createLookup((String)"container", (String)"container.$id", (String)"_id", (String)"container");
        BasicDBObject teamsLookup = DBUtils.createLookup((String)"team", (String)"team.$id", (String)"_id", (String)"team");
        BasicDBObject containersUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$container").append("preserveNullAndEmptyArrays", (Object)true));
        BasicDBObject teamsUnWind = new BasicDBObject("$unwind", (Object)new BasicDBObject("path", (Object)"$team").append("preserveNullAndEmptyArrays", (Object)true));
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("container", (Object)1).append("team._id", (Object)1).append("team.title", (Object)1).append("team.label", (Object)1).append("team.color", (Object)1).append("team.boardId", (Object)1).append("team.projectId", (Object)1).append("team.issueTypeId", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, containersLookup, containersUnWind, teamsLookup, teamsUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(TeamContainer.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]));
                if (!DBUtils.isEmptyObject((Object)object.get("container"))) {
                    teamContainer.setContainer(new Container((BasicDBObject)object.get("container")));
                }
                if (!DBUtils.isEmptyObject((Object)object.get("team"))) {
                    teamContainer.setTeam(new Team((BasicDBObject)object.get("team")));
                }
                teamContainers.add(teamContainer);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return teamContainers;
    }

    private List<SessionBoard> findBoardsByBoardIdsIn(List<ObjectId> boardIds) {
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", boardIds)));
        BasicDBObject sessionLookup = DBUtils.createLookup((String)"session", (String)"session.$id", (String)"_id", (String)"session");
        BasicDBObject sessionUnWind = DBUtils.createUnWind((String)"$session");
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("status", (Object)1).append("session._id", (Object)1).append("session.title", (Object)1).append("session.parentItem", (Object)1).append("session.childItem", (Object)1).append("session.jiraFlaggedFieldEnabled", (Object)1).append("session.kendisFlaggedFieldEnabled", (Object)1).append("session.additionalFieldsValuesFeature", (Object)1).append("session.additionalFieldsValuesUserStory", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, sessionLookup, sessionUnWind, projectStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                SessionBoard sessionBoard = new SessionBoard((BasicDBObject)object);
                sessionBoards.add(sessionBoard);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return sessionBoards;
    }

    private List<SessionBoard> findBoardsBySessionIn(List<ObjectId> sessionIds) {
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("session.$id", (Object)new BasicDBObject("$in", sessionIds)));
        BasicDBObject sessionLookup = DBUtils.createLookup((String)"session", (String)"session.$id", (String)"_id", (String)"session");
        BasicDBObject sessionUnWind = DBUtils.createUnWind((String)"$session");
        BasicDBObject projectStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("status", (Object)1).append("session._id", (Object)1).append("session.title", (Object)1).append("session.parentItem", (Object)1).append("session.childItem", (Object)1).append("session.jiraFlaggedFieldEnabled", (Object)1).append("session.kendisFlaggedFieldEnabled", (Object)1).append("session.additionalFieldsValuesFeature", (Object)1).append("session.additionalFieldsValuesUserStory", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, sessionLookup, sessionUnWind, projectStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                SessionBoard sessionBoard = new SessionBoard((BasicDBObject)object);
                sessionBoards.add(sessionBoard);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return sessionBoards;
    }

    private List<Conversation> findAllConversationsByRiskId(String riskId) {
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("risk.$id", (Object)new ObjectId(riskId)));
        BasicDBObject userLookup = DBUtils.createLookup((String)"user", (String)"user.$id", (String)"_id", (String)"user");
        BasicDBObject userUnWind = DBUtils.createUnWindWithPath((String)"$user", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("text", (Object)1).append("isEdit", (Object)1).append("createdOn", (Object)1).append("createdBy", (Object)1).append("user._id", (Object)1).append("user.userName", (Object)1).append("user.fullName", (Object)1).append("user.firstName", (Object)1).append("user.email", (Object)1).append("user.picturePath", (Object)1).append("user.backgroundColor", (Object)1).append("user.imgPath", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, userLookup, userUnWind, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Conversation.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        ArrayList<Conversation> conversationList = new ArrayList<Conversation>();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                DBObject object = (DBObject)dbCursor.next();
                Conversation conversation = new Conversation();
                conversation.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]));
                if (object.containsField("text")) {
                    conversation.setText((String)object.get("text"));
                }
                if (object.containsField("isEdit")) {
                    conversation.setEdit(((Boolean)object.get("isEdit")).booleanValue());
                }
                if (object.containsField("user")) {
                    conversation.setUser(new User((BasicDBObject)object.get("user")));
                }
                if (object.containsField("createdOn")) {
                    conversation.setCreatedOn(((BasicDBObject)object).getDate("createdOn"));
                }
                if (object.containsField("createdBy")) {
                    conversation.setCreatedBy(((BasicDBObject)object).getString("createdBy"));
                }
                conversationList.add(conversation);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return conversationList;
    }

    private BasicDBObject createMatchQueryUsingIdAndSessionBoardIds(List<ObjectId> itemObjectIds, List<String> itemIds, List<ObjectId> sessionBoardIds, List<ObjectId> solutionBoardIds) {
        return new BasicDBObject("$match", (Object)new BasicDBObject("$and", Arrays.asList(new BasicDBObject("$or", Arrays.asList(new BasicDBObject("_id", (Object)new BasicDBObject("$in", itemObjectIds)), new BasicDBObject("originItemId", (Object)new BasicDBObject("$in", itemIds)))), new BasicDBObject("$or", Arrays.asList(new BasicDBObject("sessionBoards.$id", (Object)new BasicDBObject("$in", sessionBoardIds)), new BasicDBObject("solutionBoard.$id", (Object)new BasicDBObject("$in", solutionBoardIds)))))).append("archive", (Object)new BasicDBObject("$ne", (Object)true)).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
    }

    private BasicDBObject createMatchQueryUsingJiraTfsKeyAndSessionBoardIds(List<String> keys, List<ObjectId> sessionBoardIds, List<ObjectId> exclusionIds) {
        return new BasicDBObject("$match", (Object)new BasicDBObject("$and", Arrays.asList(new BasicDBObject("$or", Arrays.asList(new BasicDBObject("jiraKey", (Object)new BasicDBObject("$in", keys)), new BasicDBObject("tfsId", (Object)new BasicDBObject("$in", keys)))), new BasicDBObject("sessionBoards.$id", (Object)new BasicDBObject("$in", sessionBoardIds)), new BasicDBObject("_id", (Object)new BasicDBObject("$nin", exclusionIds)))).append("archive", (Object)new BasicDBObject("$ne", (Object)true)).append("tenant", (Object)UserContextUtil.getUserContext().getLoggedInUser().getTenant()));
    }

    private List<Item> findItemsByQuery(BasicDBObject matchStage) {
        BasicDBObject statusLookup = DBUtils.createLookup((String)"status", (String)"status.$id", (String)"_id", (String)"status");
        BasicDBObject sessionBoardLookup = DBUtils.createLookup((String)"sessionBoard", (String)"sessionBoards.$id", (String)"_id", (String)"sessionBoards");
        BasicDBObject statusUnWind = DBUtils.createUnWind((String)"$status");
        BasicDBObject sessionBoardUnWind = DBUtils.createUnWind((String)"$sessionBoards");
        BasicDBObject solutionBoardUnWind = DBUtils.createUnWind((String)"$solutionBoard");
        BasicDBObject solutionBoardLookup = DBUtils.createLookup((String)"solutionBoard", (String)"solutionBoard.$id", (String)"_id", (String)"solutionBoard");
        BasicDBObject sessionLookup = DBUtils.createLookup((String)"session", (String)"sessionBoards.session.$id", (String)"_id", (String)"sessionBoards.session");
        BasicDBObject sessionUnWind = DBUtils.createUnWind((String)"$sessionBoards.session");
        BasicDBObject almConfigurationsLookup = DBUtils.createLookup((String)"almConfigurations", (String)"sessionBoards.session.almConfigurations.$id", (String)"_id", (String)"sessionBoards.session.almConfigurations");
        BasicDBObject almConfigurationsUnWind = DBUtils.createUnWindWithPath((String)"$sessionBoards.session.almConfigurations", (boolean)true);
        BasicDBObject tfsAlmConfigurationsLookup = DBUtils.createLookup((String)"tFSAlmConfigurations", (String)"sessionBoards.session.tfsAlmConfigurations.$id", (String)"_id", (String)"sessionBoards.session.tfsAlmConfigurations");
        BasicDBObject tfsAlmConfigurationsUnWind = DBUtils.createUnWindWithPath((String)"$sessionBoards.session.tfsAlmConfigurations", (boolean)true);
        BasicDBObject almAccountLookup = DBUtils.createLookup((String)"almAccount", (String)"sessionBoards.session.almConfigurations.almAccount.$id", (String)"_id", (String)"sessionBoards.session.almConfigurations.almAccount");
        BasicDBObject almAccountUnWind = DBUtils.createUnWindWithPath((String)"$sessionBoards.session.almConfigurations.almAccount", (boolean)true);
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("title", (Object)1).append("type", (Object)1).append("storyPoints", (Object)1).append("sequence", (Object)1).append("backlogSequence", (Object)1).append("subItemEstimate", (Object)1).append("jiraId", (Object)1).append("jiraURL", (Object)1).append("jiraIssueTypeId", (Object)1).append("kendisKey", (Object)1).append("jiraKey", (Object)1).append("tfsId", (Object)1).append("tfsURL", (Object)1).append("externalReferenceURL", (Object)1).append("tfsLinkTypes", (Object)1).append("tfsFieldByKey", (Object)1).append("tfsItemTypeIcon", (Object)1).append("notifyWatchers", (Object)1).append("status._id", (Object)1).append("status.title", (Object)1).append("status.color", (Object)1).append("status.category", (Object)1).append("status.jiraProjKey", (Object)1).append("status.jiraIssueTypeId", (Object)1).append("status.jiraStatusId", (Object)1).append("status.jiraStatusCatId", (Object)1).append("status.jiraStatusOriginalCategory", (Object)1).append("status.tfsId", (Object)1).append("status.tfsProject", (Object)1).append("status.tfsProjectId", (Object)1).append("status.sessionId", (Object)1).append("status.solutionId", (Object)1).append("status.almId", (Object)1).append("status.rowStatus", (Object)1).append("sessionBoards", (Object)1).append("solutionBoard", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, statusLookup, statusUnWind, sessionBoardLookup, sessionBoardUnWind, sessionLookup, sessionUnWind, almConfigurationsLookup, almConfigurationsUnWind, almAccountLookup, almAccountUnWind, tfsAlmConfigurationsLookup, tfsAlmConfigurationsUnWind, projectionStage);
        List<DBObject> pipeline2 = Arrays.asList(matchStage, statusLookup, statusUnWind, solutionBoardLookup, solutionBoardUnWind);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Item.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        ArrayList<Item> itemList = new ArrayList<Item>();
        try {
            Item item;
            DBObject object;
            Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);
            while (dbCursor.hasNext()) {
                object = (DBObject)dbCursor.next();
                item = new Item();
                item.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]));
                item.setTitle((String)object.get("title"));
                item.setType((String)object.get("type"));
                if (object.get("storyPoints") != null) {
                    item.setStoryPoints((Double)object.get("storyPoints"));
                }
                item.setSequence((Double)object.get("sequence"));
                item.setBacklogSequence((Double)object.get("backlogSequence"));
                item.setSubItemEstimate((Double)object.get("subItemEstimate"));
                item.setKendisKey((String)object.get("kendisKey"));
                item.setJiraId((String)object.get("jiraId"));
                item.setJiraKey((String)object.get("jiraKey"));
                item.setJiraIssueTypeId((String)object.get("jiraIssueTypeId"));
                item.setTfsItemTypeIcon((String)object.get("tfsItemTypeIcon"));
                item.setJiraURL((String)object.get("jiraURL"));
                item.setTfsId((String)object.get("tfsId"));
                item.setTfsURL((String)object.get("tfsURL"));
                item.setTfsLinkTypes((List)object.get("tfsLinkTypes"));
                item.setTfsFieldByKey((Map)object.get("tfsFieldByKey"));
                item.setNotifyWatchers((Boolean)object.get("notifyWatchers"));
                item.setStatus(new Status((BasicDBObject)object.get("status")));
                item.setExternalReferenceURL((String)object.get("externalReferenceURL"));
                if (!DBUtils.isEmptyObject((Object)object.get("sessionBoards"))) {
                    ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                    sessionBoards.add(new SessionBoard((BasicDBObject)object.get("sessionBoards")));
                    item.setSessionBoards(sessionBoards);
                }
                itemList.add(item);
            }
            dbCursor = collection.aggregate(pipeline2, aggregationOptions);
            while (dbCursor.hasNext()) {
                object = (DBObject)dbCursor.next();
                item = new Item();
                item.setId(DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object), (String[])new String[0]));
                item.setTitle((String)object.get("title"));
                item.setType((String)object.get("type"));
                if (object.get("storyPoints") != null) {
                    item.setStoryPoints((Double)object.get("storyPoints"));
                }
                item.setSequence((Double)object.get("sequence"));
                item.setBacklogSequence((Double)object.get("backlogSequence"));
                item.setSubItemEstimate((Double)object.get("subItemEstimate"));
                item.setKendisKey((String)object.get("kendisKey"));
                item.setJiraId((String)object.get("jiraId"));
                item.setJiraKey((String)object.get("jiraKey"));
                item.setJiraIssueTypeId((String)object.get("jiraIssueTypeId"));
                item.setTfsItemTypeIcon((String)object.get("tfsItemTypeIcon"));
                item.setJiraURL((String)object.get("jiraURL"));
                item.setTfsId((String)object.get("tfsId"));
                item.setTfsURL((String)object.get("tfsURL"));
                item.setTfsLinkTypes((List)object.get("tfsLinkTypes"));
                item.setTfsFieldByKey((Map)object.get("tfsFieldByKey"));
                item.setNotifyWatchers((Boolean)object.get("notifyWatchers"));
                item.setStatus(new Status((BasicDBObject)object.get("status")));
                item.setExternalReferenceURL((String)object.get("externalReferenceURL"));
                if (!DBUtils.isEmptyObject((Object)object.get("solutionBoard"))) {
                    String id = DBUtils.getIdFromDBObject((BasicDBObject)((BasicDBObject)object.get("solutionBoard")), (String[])new String[0]);
                    BasicDBObject board = (BasicDBObject)object.get("solutionBoard");
                    String title = board.getString("title");
                    SolutionBoard sol = new SolutionBoard(id);
                    sol.setTitle(title);
                    item.setSolutionBoard(sol);
                }
                itemList.add(item);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return itemList;
    }

    private List<BoardVO> findAllSessionsByWorkSpace(String workSpaceId, List<ObjectId> closedStateIds, boolean allowLinkedSessions, String tenant, String almAccountId) {
        if (!PropertyValidator.isValid((Object)workSpaceId)) {
            return null;
        }
        LinkedList<BoardVO> boardList = new LinkedList<BoardVO>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject().append("workSpace.$id", (Object)new ObjectId(workSpaceId)).append("archive", (Object)false).append("tenant", (Object)tenant));
        BasicDBObject almConfigsLookup = DBUtils.createLookup((String)"almConfigurations", (String)"almConfigurations.$id", (String)"_id", (String)"almConfigsDetails");
        BasicDBObject tfsAlmConfigsLookup = DBUtils.createLookup((String)"tFSAlmConfigurations", (String)"tfsAlmConfigurations.$id", (String)"_id", (String)"tfsAlmConfigsDetails");
        BasicDBObject almAccountMatchStage = null;
        if (PropertyValidator.isValid((Object)almAccountId)) {
            BasicDBObject almAccountMatch;
            ObjectId almAccountObjectId = new ObjectId(almAccountId);
            almAccountMatchStage = almAccountMatch = new BasicDBObject("$match", (Object)new BasicDBObject("$or", Arrays.asList(new BasicDBObject("almConfigsDetails.almAccount.$id", (Object)almAccountObjectId), new BasicDBObject("tfsAlmConfigsDetails.almAccount.$id", (Object)almAccountObjectId))));
        }
        BasicDBObject addFields = new BasicDBObject("$addFields", (Object)new BasicDBObject("activeSessionBoardObjectId", (Object)new BasicDBObject("$toObjectId", (Object)"$activeSessionBoard")));
        BasicDBObject sessionBoardLookup = DBUtils.createLookup((String)"sessionBoard", (String)"activeSessionBoardObjectId", (String)"_id", (String)"sessionBoard");
        BasicDBObject unwindStage = new BasicDBObject("$unwind", (Object)"$sessionBoard");
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)1).append("title", (Object)1).append("riskRegister", (Object)1).append("sessionBoard", (Object)1));
        ArrayList<BasicDBObject> pipeline = new ArrayList<BasicDBObject>();
        pipeline.add(matchStage);
        pipeline.add(almConfigsLookup);
        pipeline.add(tfsAlmConfigsLookup);
        if (almAccountMatchStage != null) {
            pipeline.add(almAccountMatchStage);
        }
        pipeline.add(addFields);
        pipeline.add(sessionBoardLookup);
        pipeline.add(unwindStage);
        pipeline.add(projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(Session.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                BasicDBObject object = (BasicDBObject)dbCursor.next();
                BoardVO board = new BoardVO();
                board.setId(DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]));
                board.setName(object.getString("title"));
                if (!allowLinkedSessions && PropertyValidator.isValid((Object)object.get("riskRegister"))) {
                    board.setDisabled(true);
                }
                if (!allowLinkedSessions && PropertyValidator.isValid((Object)object.get("sessionBoard"))) {
                    BasicDBObject sessionBoardObj = (BasicDBObject)object.get("sessionBoard");
                    DBRef stateRef = (DBRef)sessionBoardObj.get("state");
                    ObjectId stateId = new ObjectId(stateRef.getId().toString());
                    Optional<ObjectId> closedStateId = closedStateIds.stream().filter(arg_0 -> ((ObjectId)stateId).equals(arg_0)).findAny();
                    if (closedStateId.isPresent()) {
                        board.setDisabled(true);
                    }
                }
                boardList.add(board);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return boardList;
    }

    private List<ObjectId> findClosedStateIds() {
        LinkedList<ObjectId> closedStateIds = new LinkedList<ObjectId>();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"title").is((Object)"Close"));
        query.fields().include("_id");
        List closedStates = this.mongoTemplate.find(query, State.class);
        for (State state : closedStates) {
            closedStateIds.add(new ObjectId(state.getId()));
        }
        return closedStateIds;
    }

    private Map<String, SessionBoard> findSessionBoardsByActiveSessionBoardsIn(List<ObjectId> activeSessionBoardIds, String tenant) {
        if (!PropertyValidator.isValid(activeSessionBoardIds)) {
            return null;
        }
        HashMap<String, SessionBoard> sessionBoardData = new HashMap<String, SessionBoard>();
        BasicDBObject matchStage = new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("$in", activeSessionBoardIds)).append("archive", (Object)false).append("tenant", (Object)tenant));
        BasicDBObject teamsLookup = DBUtils.createLookup((String)"team", (String)"teams.$id", (String)"_id", (String)"teams");
        BasicDBObject containersLookup = DBUtils.createLookup((String)"container", (String)"containers.$id", (String)"_id", (String)"containers");
        BasicDBObject projectionStage = new BasicDBObject("$project", (Object)new BasicDBObject().append("_id", (Object)1).append("containers", (Object)1).append("teams._id", (Object)1).append("teams.title", (Object)1).append("teams.label", (Object)1).append("teams.color", (Object)1).append("teams.boardId", (Object)1).append("teams.projectId", (Object)1).append("teams.issueTypeId", (Object)1));
        List<DBObject> pipeline = Arrays.asList(matchStage, teamsLookup, containersLookup, projectionStage);
        DBCollection collection = this.mongoTemplate.getCollection(KendisUtils.dbName(SessionBoard.class));
        AggregationOptions aggregationOptions = AggregationOptions.builder().allowDiskUse(Boolean.valueOf(true)).build();
        try (Cursor dbCursor = collection.aggregate(pipeline, aggregationOptions);){
            while (dbCursor.hasNext()) {
                BasicDBObject object = (BasicDBObject)dbCursor.next();
                SessionBoard sessionBoard = new SessionBoard();
                LinkedList teams = new LinkedList();
                LinkedList containers = new LinkedList();
                String id = DBUtils.getIdFromDBObject((BasicDBObject)object, (String[])new String[0]);
                if (PropertyValidator.isValid((Object)object.get("teams"))) {
                    List teamsObj = (List)object.get("teams");
                    teamsObj.forEach(teamObj -> {
                        Team team = new Team(teamObj);
                        teams.add(team);
                    });
                }
                if (PropertyValidator.isValid((Object)object.get("containers"))) {
                    List containersObj = (List)object.get("containers");
                    containersObj.forEach(containerObj -> {
                        Container container = new Container(containerObj);
                        containers.add(container);
                    });
                }
                sessionBoard.setId(id);
                sessionBoard.setTeams(teams);
                sessionBoard.setContainers(containers);
                sessionBoardData.put(id, sessionBoard);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        return sessionBoardData;
    }

    private HashMap<String, Object> getEmailContent(Risk newRisk, Risk oldRisk) {
        HashMap<String, Object> objEmailContent = new HashMap<String, Object>();
        if (!PropertyValidator.isValid((Object)oldRisk)) {
            String key = newRisk.getRiskRegister().getRegisterKey() + "-" + newRisk.getRiskNumber();
            String title = newRisk.getRiskTitle();
            objEmailContent.put("key", key);
            objEmailContent.put("isNew", true);
            objEmailContent.put("title", title);
            if (PropertyValidator.isValid((Object)newRisk.getProbability())) {
                objEmailContent.put("probability", newRisk.getProbability().getTitle());
            }
            if (PropertyValidator.isValid((Object)newRisk.getImpact())) {
                objEmailContent.put("impact", newRisk.getImpact().getTitle());
            }
            if (PropertyValidator.isValid((Object)newRisk.getRaisedDate())) {
                objEmailContent.put("raisedOn", newRisk.getRaisedDate());
            }
            if (PropertyValidator.isValid((Object)newRisk.getResolutionDate())) {
                objEmailContent.put("targetResolutionDate", newRisk.getResolutionDate());
            }
            if (PropertyValidator.isValid((Object)newRisk.getResponsible())) {
                objEmailContent.put("responsible", newRisk.getResponsible().getFullName());
            }
            if (PropertyValidator.isValid((Object)newRisk.getStatus())) {
                objEmailContent.put("status", newRisk.getStatus().getTitle());
            }
            if (PropertyValidator.isValid((Object)newRisk.getRiskDesc())) {
                objEmailContent.put("description", newRisk.getRiskDesc());
            }
            if (PropertyValidator.isValid((Object)newRisk.getMitigationActions())) {
                objEmailContent.put("mitigationActions", newRisk.getMitigationActions());
            }
        } else {
            objEmailContent.put("key", null);
            if (!Objects.equals(newRisk.getRiskTitle(), oldRisk.getRiskTitle())) {
                objEmailContent.put("title", newRisk.getRiskTitle());
                objEmailContent.put("oldTitle", oldRisk.getRiskTitle());
            }
            if (!RiskMatrixCoordinate.areTitlesEqual((RiskMatrixCoordinate)newRisk.getProbability(), (RiskMatrixCoordinate)oldRisk.getProbability())) {
                if (PropertyValidator.isValid((Object)newRisk.getProbability())) {
                    objEmailContent.put("probability", newRisk.getProbability().getTitle());
                } else {
                    objEmailContent.put("probability", "Unselected");
                }
                if (PropertyValidator.isValid((Object)oldRisk.getProbability())) {
                    objEmailContent.put("oldProbability", oldRisk.getProbability().getTitle());
                }
            }
            if (!RiskMatrixCoordinate.areTitlesEqual((RiskMatrixCoordinate)newRisk.getImpact(), (RiskMatrixCoordinate)oldRisk.getImpact())) {
                if (PropertyValidator.isValid((Object)newRisk.getImpact())) {
                    objEmailContent.put("impact", newRisk.getImpact().getTitle());
                } else {
                    objEmailContent.put("impact", "Unselected");
                }
                if (PropertyValidator.isValid((Object)oldRisk.getImpact())) {
                    objEmailContent.put("oldImpact", oldRisk.getImpact().getTitle());
                }
            }
            if (!Objects.equals(newRisk.getRaisedDate(), oldRisk.getRaisedDate())) {
                objEmailContent.put("raisedOn", newRisk.getRaisedDate());
                if (PropertyValidator.isValid((Object)oldRisk.getRaisedDate())) {
                    objEmailContent.put("oldRaisedOn", oldRisk.getRaisedDate());
                }
            }
            if (!Objects.equals(newRisk.getResolutionDate(), oldRisk.getResolutionDate())) {
                objEmailContent.put("targetResolutionDate", newRisk.getResolutionDate());
                if (PropertyValidator.isValid((Object)oldRisk.getResolutionDate())) {
                    objEmailContent.put("oldTargetResolutionDate", oldRisk.getResolutionDate());
                }
            }
            if (!Objects.equals(newRisk.getResponsible(), oldRisk.getResponsible())) {
                if (PropertyValidator.isValid((Object)newRisk.getResponsible())) {
                    objEmailContent.put("responsible", newRisk.getResponsible().getFullName());
                } else {
                    objEmailContent.put("responsible", "Unassigned");
                }
                if (PropertyValidator.isValid((Object)oldRisk.getResponsible())) {
                    objEmailContent.put("oldResponsible", oldRisk.getResponsible().getFullName());
                }
            }
            if (!Objects.equals(newRisk.getStatus(), oldRisk.getStatus())) {
                objEmailContent.put("status", newRisk.getStatus().getTitle());
                if (PropertyValidator.isValid((Object)oldRisk.getStatus())) {
                    objEmailContent.put("oldStatus", oldRisk.getStatus().getTitle());
                }
            }
            if (!Objects.equals(newRisk.getRiskDesc(), oldRisk.getRiskDesc())) {
                objEmailContent.put("description", newRisk.getRiskDesc());
                if (PropertyValidator.isValid((Object)oldRisk.getRiskDesc())) {
                    objEmailContent.put("oldDescription", oldRisk.getRiskDesc());
                }
            }
            if (!Objects.equals(newRisk.getMitigationActions(), oldRisk.getMitigationActions())) {
                objEmailContent.put("mitigationActions", newRisk.getMitigationActions());
                if (PropertyValidator.isValid((Object)oldRisk.getMitigationActions())) {
                    objEmailContent.put("oldMitigationActions", oldRisk.getMitigationActions());
                }
            }
        }
        return objEmailContent;
    }

    @RequestMapping(value={"/get-org-registers/{id}/{archive}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getOrgRiskRegisters(@PathVariable(value="id") String id, @PathVariable(value="archive") Boolean archive) {
        Map<String, Boolean> responseJson = new HashMap();
        try {
            responseJson = this.riskRegisterService.getLinkedWithOrgRegisters(id, archive);
            responseJson.put("success", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-bulk/risks"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBulkRisks(@RequestBody Map map) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.riskRegisterService.saveBulkRisks(map);
            result.put("message", "success");
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            String solutionBoardId = (String)map.get("solutionBoardId");
            this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.RISK.getCode());
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            String sessionId = (String)map.get("sessionId");
            String riskRegisterId = (String)map.get("riskRegisterId");
            String solutionBoardId = (String)map.get("solutionBoardId");
            if (PropertyValidator.isValid((Object)sessionId)) {
                this.customRepositoryImpl.removeSessionLock(sessionId);
            } else if (PropertyValidator.isValid((Object)riskRegisterId)) {
                this.customRepositoryImpl.removeRiskRegisterLock(riskRegisterId, EnumKendis.RISK.getCode());
            } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
                this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.RISK.getCode());
            }
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/inline-save/risk"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> inlineSaveRisk(@RequestBody Map map) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.riskRegisterService.saveInlineRisk(map);
            result.put("message", "success");
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/link/org/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkWithOrg(@PathVariable(value="id") String id, @RequestBody RiskRegister riskRegister) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            this.riskRegisterService.linkWithOrg(id, riskRegister);
            result.put("success", true);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            result.put("success", false);
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/update-title"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateRiskRegisterTitle(@RequestBody Map<String, Object> request) {
        try {
            String riskRegisterId = (String)request.get("id");
            String registerName = (String)request.get("registerName");
            Map result = this.riskRegisterService.updateRiskRegisterTitle(riskRegisterId, registerName.trim());
            if (((Boolean)result.get("success")).booleanValue()) {
                return ResponseEntity.ok((Object)result);
            }
            return ResponseEntity.badRequest().body((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("Error updating risk register title", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Internal server error: " + e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(errorResponse);
        }
    }

    static /* synthetic */ TFSRiskService access$000(RiskRegistersController x0) {
        return x0.tfsRiskService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ AlmAccountRepository access$200(RiskRegistersController x0) {
        return x0.almAccountRepository;
    }

    static /* synthetic */ void access$300(RiskRegistersController x0, Map x1, String x2, String x3, Boolean x4) {
        x0.onBackgroundTaskCompleted(x1, x2, x3, x4);
    }

    static /* synthetic */ HashMap access$400(RiskRegistersController x0, Risk x1, Risk x2) {
        return x0.getEmailContent(x1, x2);
    }

    static /* synthetic */ void access$500(RiskRegistersController x0, String x1, Notification x2, String x3, Map x4) {
        x0.addEmailToNotification(x1, x2, x3, x4);
    }

    static /* synthetic */ UserRepository access$600(RiskRegistersController x0) {
        return x0.userRepository;
    }

    static /* synthetic */ NotificationRepository access$700(RiskRegistersController x0) {
        return x0.notificationRepository;
    }

    static /* synthetic */ ItemRepository access$800(RiskRegistersController x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ RiskRepository access$900(RiskRegistersController x0) {
        return x0.riskRepository;
    }

    static /* synthetic */ void access$1000(RiskRegistersController x0, Risk x1, String x2, HashMap x3) {
        x0.sendPushResonse(x1, x2, x3);
    }
}

