/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.utils.PushSender;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/peer"})
@RestController
public class PeerPushController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerPushController.class);

    @RequestMapping(value={"/push/{cid}"}, method={RequestMethod.POST})
    public void push(@RequestBody String requestBody, @PathVariable(value="cid") String cid) {
        try {
            byte[] decodedBytes = Base64.getUrlDecoder().decode(cid);
            String decoded = new String(decodedBytes);
            PushSender.sendPushMsg((String)decoded, (String)requestBody);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

