/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.tfs.TFSFilter;
import com.viztrend.safe.alm.tfs.TFSMeta;
import com.viztrend.safe.alm.tfs.TFSProject;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.PIController;
import com.viztrend.safe.dto.PiItemsRequestDTO;
import com.viztrend.safe.enums.EnumKendis;
import com.viztrend.safe.enums.EnumRTModules;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.AzureOAuthToken;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.BoardFilter;
import com.viztrend.safe.persistence.entity.BoardSprints;
import com.viztrend.safe.persistence.entity.BoardTeam;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Conversation;
import com.viztrend.safe.persistence.entity.IssueType;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.PiContainerCapacity;
import com.viztrend.safe.persistence.entity.PiTeamCapacity;
import com.viztrend.safe.persistence.entity.PiUserCapacity;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Sprint;
import com.viztrend.safe.persistence.entity.State;
import com.viztrend.safe.persistence.entity.StateScheme;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.TFSAlmConfigurations;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.TeamSprintDependencyLimit;
import com.viztrend.safe.persistence.entity.TeamSprintVelocity;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.persistence.entity.WorkFlow;
import com.viztrend.safe.persistence.entity.WorkSpace;
import com.viztrend.safe.persistence.entity.WorkSpaceAccessRole;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.AlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.AlmErrorRepository;
import com.viztrend.safe.persistence.repository.AlmInfoRepository;
import com.viztrend.safe.persistence.repository.AuditLogRepository;
import com.viztrend.safe.persistence.repository.ConfigRepository;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.ConversationRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.persistence.repository.GroupRepository;
import com.viztrend.safe.persistence.repository.IssueTypeRepository;
import com.viztrend.safe.persistence.repository.ItemJiraDependencyRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLinkTypeRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.ItemSyncMapperRepository;
import com.viztrend.safe.persistence.repository.ItemTypeRepository;
import com.viztrend.safe.persistence.repository.JiraFieldRepository;
import com.viztrend.safe.persistence.repository.JiraIssueRepository;
import com.viztrend.safe.persistence.repository.JiraProjectIssueTypesRepository;
import com.viztrend.safe.persistence.repository.KendisStatsRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.PiAgendaRepository;
import com.viztrend.safe.persistence.repository.PiTeamCapacityRepository;
import com.viztrend.safe.persistence.repository.PiUserCapacityRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.ReportRepository;
import com.viztrend.safe.persistence.repository.RiskRegisterRepository;
import com.viztrend.safe.persistence.repository.RiskRepository;
import com.viztrend.safe.persistence.repository.RoleRepository;
import com.viztrend.safe.persistence.repository.ScoreCardRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.SprintRepository;
import com.viztrend.safe.persistence.repository.StateCategoryRepository;
import com.viztrend.safe.persistence.repository.StateRepository;
import com.viztrend.safe.persistence.repository.StateSchemeRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TFSAlmConfigurationsRepository;
import com.viztrend.safe.persistence.repository.TFSFilterRepository;
import com.viztrend.safe.persistence.repository.TFSPreferencesRepository;
import com.viztrend.safe.persistence.repository.TFSProjectRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.persistence.repository.TeamSprintDependencyLimitRepository;
import com.viztrend.safe.persistence.repository.TeamSprintVelocityRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.persistence.repository.WatcherRepository;
import com.viztrend.safe.persistence.repository.WorkFlowItemTypeRepository;
import com.viztrend.safe.persistence.repository.WorkFlowRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceAccessRoleRepository;
import com.viztrend.safe.persistence.repository.WorkSpaceRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.BatchService;
import com.viztrend.safe.service.CreateBoardService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.service.ExportService;
import com.viztrend.safe.service.ExternalEntitiesService;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.PIServiceImpl;
import com.viztrend.safe.service.PiJourneyBoardService;
import com.viztrend.safe.service.PiJourneyService;
import com.viztrend.safe.service.PlanService;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.service.StateChangeService;
import com.viztrend.safe.service.TFSservice;
import com.viztrend.safe.service.UserService;
import com.viztrend.safe.service.WebHookSyncService;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.LocalMailSender;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.ObjectId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/pi"})
@RestController
public class PIController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PIController.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ItemRepository itemRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository accessRoleRepository;
    @Autowired
    private StateCategoryRepository stateCategoryRepository;
    @Autowired
    private StateRepository stateRepository;
    @Autowired
    private StatusRepository statusRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private WorkFlowRepository workFlowRepository;
    @Autowired
    private StateSchemeRepository stateSchemeRepository;
    @Autowired
    private ItemTypeRepository itemTypeRepository;
    @Autowired
    private ItemLinkRepository itemLinkRepository;
    @Autowired
    private ScoreCardRepository scoreCardRepository;
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private WatcherRepository watcherRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private PiUserCapacityRepository piUserCapacityRepository;
    @Autowired
    private KendisStatsRepository kendisStatsRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private JiraProjectIssueTypesRepository jiraProjectIssueTypesRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private RiskRepository riskRepository;
    @Autowired
    private TeamSprintVelocityRepository teamSprintVelocityRepository;
    @Autowired
    private WebHookSyncService webHookSyncService;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private TeamSprintDependencyLimitRepository teamSprintDependencyLimitRepository;
    @Autowired
    private SprintRepository sprintRepository;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private PlanService planService;
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private ItemLogRepository itemLogRepository;
    @Autowired
    private RiskRegisterRepository riskRegisterRepository;
    @Autowired
    private ReleaseTrainService releaseTrainService;
    @Autowired
    private ExportService exportService;
    @Autowired
    ALMSyncService aLMSyncService;
    @Autowired
    private CustomRepository<Object> customRepository;
    @Autowired
    private WorkSpaceRepository workSpaceRepository;
    @Autowired
    private WorkSpaceAccessRoleRepository workSpaceAccessRoleRepository;
    @Autowired
    RoleRepository roleRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private AuditLogRepository auditLogRepository;
    @Autowired
    private ItemSyncMapperRepository itemSyncMapperRepository;
    @Autowired
    private LocalMailSender mailSender;
    @Autowired
    private ConfigRepository configRepository;
    @Autowired
    private AlmConfigurationsRepository almConfigurationsRepository;
    @Autowired
    private CustomRepositoryImpl<?> customRepositoryImpl;
    @Autowired
    private AlmErrorRepository almErrorRepository;
    @Autowired
    private AlmInfoRepository almInfoRepository;
    @Autowired
    private JiraFieldRepository jiraFieldRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    @Autowired
    private JiraIssueRepository jiraIssueRepository;
    @Autowired
    private IssueTypeRepository issueTypeRepository;
    @Autowired
    private ReportRepository reportRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private ItemJiraDependencyRepository itemJiraDependencyRepository;
    @Autowired
    private TFSUtils tfsUtils;
    @Autowired
    private TFSservice tfSservice;
    @Autowired
    private TFSProjectRepository tfsProjectRepository;
    @Autowired
    private TFSPreferencesRepository tfsPreferencesRepository;
    @Autowired
    private TFSFilterRepository tfsFilterRepository;
    @Autowired
    private TFSAlmConfigurationsRepository tfsAlmConfigurationsRepository;
    @Autowired
    private WorkFlowItemTypeRepository workFlowItemTypeRepository;
    @Autowired
    private ServerCacheRepository serverCacheRepository;
    @Autowired
    private Environment env;
    @Autowired
    private PiJourneyService piJourneyService;
    @Autowired
    private PiJourneyBoardService piJourneyBoardService;
    @Autowired
    private ExternalEntitiesService externalEntitiesService;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private ItemLinkTypeRepository itemLinkTypeRepository;
    @Autowired
    private PiAgendaRepository piAgendaRepository;
    @Autowired
    private PiTeamCapacityRepository piTeamCapacityRepository;
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    private BatchService batchService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    private RTItemFetchService rtItemFetchService;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private StateChangeService stateChangeService;
    @Autowired
    private PIServiceImpl piService;
    @Autowired
    private CreateBoardService createBoardService;
    protected Item savedItem = null;
    protected Item item = null;

    @RequestMapping(value={"/hit-tfs"})
    @ResponseBody
    public ResponseEntity<Object> hitTfs(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> responseJson;
        block9: {
            responseJson = new HashMap<String, Object>();
            String methodType = (String)request.get("method");
            String almId = (String)request.get("almAccountId");
            String url = (String)request.get("url");
            String body = (String)request.get("body");
            try {
                if (!PropertyValidator.isValid((Object)methodType) || !PropertyValidator.isValid((Object)almId)) break block9;
                AlmAccount almAccount = this.almAccountRepository.findById(almId);
                if (methodType.equals("post")) {
                    try {
                        TFSResponse response = this.tfsUtils.postRequest(url, body, almAccount);
                        if (PropertyValidator.isValid((Object)response)) {
                            responseJson.put("response", response.getContent());
                        }
                        break block9;
                    }
                    catch (ViztrendJiraException vje) {
                        responseJson.put("error", (Object)vje);
                    }
                    break block9;
                }
                if (!methodType.equals("get")) break block9;
                try {
                    String response = this.tfsUtils.getRequest(url, almAccount);
                    if (PropertyValidator.isValid((Object)response)) {
                        responseJson.put("response", response);
                    }
                }
                catch (ViztrendJiraException vje) {
                    responseJson.put("error", (Object)vje);
                }
            }
            catch (Exception e) {
                String err = com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                responseJson.put("kendisError", e);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/hit-tfs-complete-url"})
    @ResponseBody
    public ResponseEntity<Object> hitTfsUri(@RequestBody Map<String, Object> request) {
        HashMap<String, Object> responseJson;
        block9: {
            responseJson = new HashMap<String, Object>();
            String methodType = (String)request.get("method");
            String almId = (String)request.get("almAccountId");
            String url = (String)request.get("url");
            String body = (String)request.get("body");
            try {
                if (!PropertyValidator.isValid((Object)methodType) || !PropertyValidator.isValid((Object)almId)) break block9;
                AlmAccount almAccount = this.almAccountRepository.findById(almId);
                if (methodType.equals("post")) {
                    try {
                        TFSResponse response = this.tfsUtils.postRequestWithCompleteUrl(url, body, almAccount);
                        if (PropertyValidator.isValid((Object)response)) {
                            responseJson.put("response", response.getContent());
                        }
                        break block9;
                    }
                    catch (ViztrendJiraException vje) {
                        responseJson.put("error", (Object)vje);
                    }
                    break block9;
                }
                if (!methodType.equals("get")) break block9;
                try {
                    String response = this.tfsUtils.getRequestWithCompleteUrl(url, almAccount);
                    if (PropertyValidator.isValid((Object)response)) {
                        responseJson.put("response", response);
                    }
                }
                catch (ViztrendJiraException vje) {
                    responseJson.put("error", (Object)vje);
                }
            }
            catch (Exception e) {
                String err = com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e);
                LOGGER.error(err);
                responseJson.put("kendisError", e);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private StateScheme getDefaultStateScheme() {
        StateScheme defaultStateScheme = this.stateSchemeRepository.findByIsDefaultIsTrue();
        return defaultStateScheme;
    }

    private Item createItemForReport(DBObject vo, Map<String, Object> metaPlaceHolder) {
        ArrayList itemLinks = (ArrayList)metaPlaceHolder.get("itemLinks");
        ArrayList jiraLinks = (ArrayList)metaPlaceHolder.get("jiraLinks");
        ArrayList allStatuses = (ArrayList)metaPlaceHolder.get("allStatuses");
        HashMap teamMapById = (HashMap)metaPlaceHolder.get("teamMapById");
        HashMap statusMapById = (HashMap)metaPlaceHolder.get("statusMapById");
        HashMap itemLinkMapById = (HashMap)metaPlaceHolder.get("itemLinkMapById");
        HashMap jiraLinkMapById = (HashMap)metaPlaceHolder.get("jiraLinkMapById");
        HashMap containerMapById = (HashMap)metaPlaceHolder.get("containerMapById");
        HashMap issueTypeMapById = (HashMap)metaPlaceHolder.get("issueTypeMapById");
        Collection configFields = (Collection)metaPlaceHolder.get("configFields");
        Item parent = null;
        DBRef parentRef = (DBRef)vo.get("parent");
        if (PropertyValidator.isValid((Object)parentRef)) {
            parent = new Item(String.valueOf(parentRef.getId()));
        }
        Status status = new Status();
        DBRef statusRef = (DBRef)vo.get("status");
        if (statusRef != null && statusRef.getId() != null) {
            String statusId = String.valueOf(statusRef.getId());
            status.setId(statusId);
            if (statusMapById.get(statusId) == null) {
                statusMapById.put(statusId, statusId);
                allStatuses.add(statusRef.getId());
            }
        }
        IssueType issueType = null;
        DBRef issueTypeRef = (DBRef)vo.get("issueType");
        if (PropertyValidator.isValid((Object)issueTypeRef)) {
            String issueTypeId = String.valueOf(issueTypeRef.getId());
            issueType = (IssueType)issueTypeMapById.get(issueTypeId);
        }
        ArrayList _itemLinks = new ArrayList();
        List itemLinksRef = (List)vo.get("itemLinks");
        if (PropertyValidator.isValid((Collection)itemLinksRef)) {
            itemLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemLink link = new ItemLink();
                link.setId(linkId);
                if (itemLinkMapById.get(linkId) == null) {
                    itemLinkMapById.put(linkId, linkId);
                    itemLinks.add(linkId);
                }
                _itemLinks.add(link);
            });
        }
        ArrayList _jiraLinks = new ArrayList();
        List jiraLinksRef = (List)vo.get("jiraDependencies");
        if (PropertyValidator.isValid((Collection)jiraLinksRef)) {
            jiraLinksRef.forEach(linkRef -> {
                String linkId = String.valueOf(linkRef.getId());
                ItemJiraDependency link = new ItemJiraDependency();
                link.setId(linkId);
                if (jiraLinkMapById.get(linkId) == null) {
                    jiraLinkMapById.put(linkId, linkId);
                    jiraLinks.add(linkId);
                }
                _jiraLinks.add(link);
            });
        }
        List teamContainersRef = (List)vo.get("teamContainers");
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        if (PropertyValidator.isValid((Collection)teamContainersRef)) {
            for (int i = 0; i < teamContainersRef.size(); ++i) {
                DBRef tcRef = (DBRef)teamContainersRef.get(i);
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is(tcRef.getId()));
                DBCursor dbCursorDomain = this.customRepositoryImpl.getMongoTemplate().getCollection("teamContainer").find(query.getQueryObject());
                if (!dbCursorDomain.hasNext()) continue;
                DBObject tcObject = dbCursorDomain.next();
                DBRef teamRef = (DBRef)tcObject.get("team");
                DBRef containerRef = (DBRef)tcObject.get("container");
                Double sequence = (Double)tcObject.get("sequence");
                if (!PropertyValidator.isValid((Object)teamRef) || !PropertyValidator.isValid((Object)containerRef)) continue;
                Team team = (Team)teamMapById.get(String.valueOf(teamRef.getId()));
                Container container = (Container)containerMapById.get(String.valueOf(containerRef.getId()));
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)container)) continue;
                TeamContainer teamContainer = new TeamContainer();
                teamContainer.setId(String.valueOf(tcObject.get("_id")));
                teamContainer.setOriginItemId((String)tcObject.get("originItemId"));
                teamContainer.setTeam(team);
                teamContainer.setContainer(container);
                teamContainer.setSequence(sequence);
                if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                teamContainers.add(teamContainer);
            }
        }
        ArrayList _jiraLinkTypes = new ArrayList();
        List jiraLinkTypesRef = (List)vo.get("linkTypes");
        if (PropertyValidator.isValid((Collection)jiraLinkTypesRef)) {
            jiraLinkTypesRef.forEach(linkRef -> {
                JiraIssueLinkType link = new JiraIssueLinkType(linkRef);
                _jiraLinkTypes.add(link);
            });
        }
        Item item = new Item(vo, null, status, issueType, parent, _itemLinks, _jiraLinks, teamContainers, _jiraLinkTypes);
        DBRef userRef = (DBRef)vo.get("fetchedBy");
        if (userRef != null) {
            item.setFetchedBy(new User(String.valueOf(userRef.getId())));
        }
        if (item.getType().equals(Item.FEATURE)) {
            item.setSubItems(new ArrayList());
            if (PropertyValidator.isValid((Object)item.getJiraFieldByKey())) {
                item.putCustomeValuesAsText(item.getJiraFieldByKey(), configFields, null);
            }
        }
        return item;
    }

    private List<Query> buildItemsQuery(String sessionBoardId, String tenant, Map<String, Object> metaPlaceHolder) throws Exception {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        ArrayList tids = new ArrayList();
        ArrayList sids = new ArrayList();
        ArrayList tcIds = new ArrayList();
        HashMap teamMapById = new HashMap();
        HashMap containerMapById = new HashMap();
        Map tcMap = null;
        List containers = sessionBoard.getContainers();
        List teams = sessionBoard.getTeams();
        containers.forEach(container -> {
            containerMapById.put(container.getId(), container);
            if (ObjectId.isValid((String)container.getId())) {
                sids.add(new ObjectId(container.getId()));
            } else {
                sids.add(container.getId());
            }
        });
        teams.forEach(team -> {
            teamMapById.put(team.getId(), team);
            tids.add(new ObjectId(team.getId()));
        });
        ArrayList<Query> queries = new ArrayList<Query>();
        Query query1 = new Query();
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query1.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
        boolean tcFlag = metaPlaceHolder.containsKey("tcMap");
        if (tcFlag) {
            tcMap = this.customRepositoryImpl.findTeamContainers(tcIds, tids, sids, teamMapById, containerMapById);
            List ids = KendisUtils.getListAsObjectIds(tcIds);
            Criteria inner = new Criteria();
            inner.orOperator(new Criteria[]{Criteria.where((String)"teamContainers.$id").in((Collection)ids), Criteria.where((String)"type").is((Object)Item.Type.Feature.name())});
            query1.addCriteria((CriteriaDefinition)inner);
            query1.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            queries.add(query1);
            Query query2 = new Query();
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").nin((Collection)ids));
            query2.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.Type.UserStory.name()));
            query2.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            queries.add(query2);
        } else {
            query1.with(new Sort(Sort.Direction.ASC, new String[]{"sequence"}));
            queries.add(query1);
        }
        List issueTypes = this.issueTypeRepository.findAll();
        HashMap issueTypeMapById = new HashMap();
        issueTypes.forEach(issueType -> issueTypeMapById.put(issueType.getId(), issueType));
        ArrayList allStatuses = new ArrayList();
        HashMap statusMapById = new HashMap();
        ArrayList itemLinks = new ArrayList();
        HashMap itemLinkMapById = new HashMap();
        ArrayList jiraLinks = new ArrayList();
        HashMap jiraLinkMapById = new HashMap();
        Collection configFields = this.getItemJiraFieldMap(sessionBoard.getSession());
        metaPlaceHolder.put("issueTypeMapById", issueTypeMapById);
        metaPlaceHolder.put("allStatuses", allStatuses);
        metaPlaceHolder.put("statusMapById", statusMapById);
        metaPlaceHolder.put("itemLinks", itemLinks);
        metaPlaceHolder.put("itemLinkMapById", itemLinkMapById);
        metaPlaceHolder.put("jiraLinks", jiraLinks);
        metaPlaceHolder.put("jiraLinkMapById", jiraLinkMapById);
        metaPlaceHolder.put("configFields", configFields);
        if (Boolean.TRUE.equals(metaPlaceHolder.get("teamMapById"))) {
            metaPlaceHolder.put("teamMapById", teamMapById);
        }
        if (Boolean.TRUE.equals(metaPlaceHolder.get("containerMapById"))) {
            metaPlaceHolder.put("containerMapById", containerMapById);
        }
        if (tcFlag) {
            metaPlaceHolder.put("tcMap", tcMap);
        }
        metaPlaceHolder.put("preItemsQuery", true);
        return queries;
    }

    private void postItemQuery(String tenant, Map<String, Object> metaPlaceHolder) {
        LOGGER.debug("fetching linked db refs of status and links after items query");
        HashMap _itemLinksMap = new HashMap();
        HashMap _jiraLinksMap = new HashMap();
        HashMap _statusesMap = new HashMap();
        List _itemLinks = this.itemLinkRepository.findByIdIn((List)metaPlaceHolder.get("itemLinks"));
        List _jiraLinks = this.itemJiraDependencyRepository.findByIdIn((List)metaPlaceHolder.get("jiraLinks"));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").in((Collection)((List)metaPlaceHolder.get("allStatuses"))));
        DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("status").find(query.getQueryObject());
        List _statusesRaw = dbCursorPrefix.toArray();
        dbCursorPrefix.close();
        ArrayList<Status> _statuses = new ArrayList<Status>();
        if (PropertyValidator.isValid((Collection)_statusesRaw)) {
            _statusesRaw.forEach(vo -> _statuses.add(new Status(vo)));
        }
        if (PropertyValidator.isValid((Collection)_itemLinks)) {
            _itemLinks.forEach(item -> _itemLinksMap.put(item.getId(), item));
        }
        if (PropertyValidator.isValid((Collection)_jiraLinks)) {
            _jiraLinks.forEach(item -> _jiraLinksMap.put(item.getId(), item));
        }
        if (PropertyValidator.isValid(_statuses)) {
            _statuses.forEach(item -> {
                item.setWorkFlow(null);
                item.setWorkFlowItemType(null);
                _statusesMap.put(item.getId(), item);
            });
        }
        metaPlaceHolder.clear();
        metaPlaceHolder.put("_itemLinksMap", _itemLinksMap);
        metaPlaceHolder.put("_jiraLinksMap", _jiraLinksMap);
        metaPlaceHolder.put("_statusesMap", _statusesMap);
        metaPlaceHolder.put("postItemQuery", true);
    }

    public HashMap<String, Object> getBoardItems1(String sessionBoardId, String sortOpt) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            HashMap<String, Boolean> metaPlaceHolder = new HashMap<String, Boolean>();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            ArrayList<Item> parentItems = null;
            ArrayList<Item> _boardItems = null;
            HashMap<String, ArrayList<Item>> childItemsByParentId = null;
            metaPlaceHolder.put("teamMapById", true);
            metaPlaceHolder.put("containerMapById", true);
            parentItems = new ArrayList<Item>();
            _boardItems = new ArrayList<Item>();
            childItemsByParentId = new HashMap<String, ArrayList<Item>>();
            List queries = this.buildItemsQuery(sessionBoardId, tenant, metaPlaceHolder);
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(((Query)queries.get(0)).getQueryObject()).sort((DBObject)BasicDBObject.parse((String)(PropertyValidator.isValid((Object)sortOpt) ? sortOpt : "{'backlogSequence':1}")));
            List allItems = dbCursorPrefix.toArray();
            dbCursorPrefix.close();
            if (PropertyValidator.isValid((Collection)allItems)) {
                for (DBObject vo : allItems) {
                    DBRef userRef;
                    ArrayList subItems;
                    Item item = this.createItemForReport(vo, metaPlaceHolder);
                    _boardItems.add(item);
                    if (item.getType().equals(Item.FEATURE)) {
                        parentItems.add(item);
                        subItems = (ArrayList)childItemsByParentId.get(item.getId());
                        if (subItems == null) {
                            subItems = new ArrayList();
                            childItemsByParentId.put(item.getId(), subItems);
                        }
                        item.setSubItems((List)subItems);
                    } else if (item.getParent() != null) {
                        subItems = (ArrayList)childItemsByParentId.get(item.getParent().getId());
                        if (subItems == null) {
                            subItems = new ArrayList();
                            childItemsByParentId.put(item.getParent().getId(), subItems);
                        }
                        subItems.add(item);
                    }
                    if ((userRef = (DBRef)vo.get("fetchedBy")) == null) continue;
                    item.setFetchedBy(new User(String.valueOf(userRef.getId())));
                }
            }
            if (PropertyValidator.isValid(_boardItems)) {
                for (Item item : _boardItems) {
                    this.processItem(item, tenant, metaPlaceHolder);
                }
            }
            responseJson.put("items", parentItems);
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public HashMap<String, Object> getBoardItems2(String sessionBoardId, String sortOpt, String planning, String pollingId) {
        try {
            HashMap<String, Object> responseJson = new HashMap<String, Object>();
            HashMap<String, Boolean> metaPlaceHolder = new HashMap<String, Boolean>();
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            ArrayList plannedIDs = new ArrayList();
            ArrayList unplannedIDs = new ArrayList();
            HashMap<String, Item> planned = new HashMap<String, Item>();
            HashMap<String, Item> unplanned = new HashMap<String, Item>();
            metaPlaceHolder.put("tcMap", true);
            List queries = this.buildItemsQuery(sessionBoardId, tenant, metaPlaceHolder);
            Map tcMap = (Map)metaPlaceHolder.get("tcMap");
            HashMap<String, List> itemTCs = new HashMap<String, List>();
            boolean isPlanned = false;
            if (PropertyValidator.isValid((Object)planning)) {
                if (planning.startsWith("planned")) {
                    isPlanned = true;
                    queries.remove(1);
                } else {
                    queries.remove(0);
                }
            }
            for (int i = 0; i < queries.size(); ++i) {
                DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(((Query)queries.get(i)).getQueryObject()).sort((DBObject)BasicDBObject.parse((String)(PropertyValidator.isValid((Object)sortOpt) ? sortOpt : "{'backlogSequence':1}")));
                List allItems = dbCursorPrefix.toArray();
                dbCursorPrefix.close();
                if (!PropertyValidator.isValid((Collection)allItems)) continue;
                for (DBObject vo : allItems) {
                    List tcs = (List)vo.get("teamContainers");
                    vo.put("teamContainers", null);
                    Item item = this.createItemForReport(vo, metaPlaceHolder);
                    itemTCs.put(item.getId(), this.parseItemTeamContainers(item.getId(), tcs, tcMap));
                    if (PropertyValidator.isValid((Collection)((Collection)itemTCs.get(item.getId()))) || isPlanned || Item.Type.Feature.name().equals(item.getType())) {
                        planned.put(item.getId(), item);
                        if (plannedIDs.size() == 0 || pollingId != null && plannedIDs.size() > 0 && ((List)plannedIDs.get(plannedIDs.size() - 1)).size() % 2 == 0) {
                            plannedIDs.add(new ArrayList());
                        }
                        ((List)plannedIDs.get(plannedIDs.size() - 1)).add(item.getId());
                        continue;
                    }
                    unplanned.put(item.getId(), item);
                    if (unplannedIDs.size() == 0 || pollingId != null && unplannedIDs.size() > 0 && ((List)unplannedIDs.get(unplannedIDs.size() - 1)).size() % 2 == 0) {
                        unplannedIDs.add(new ArrayList());
                    }
                    ((List)unplannedIDs.get(unplannedIDs.size() - 1)).add(item.getId());
                }
            }
            responseJson.put("itemTCs", itemTCs);
            if (pollingId != null) {
                this.pushResponseRepository.save((Object)new PushResponse(pollingId, responseJson, Boolean.valueOf(false)));
                this.pushBoardItems(pollingId, tenant, "planned", plannedIDs, planned, metaPlaceHolder);
                this.pushBoardItems(pollingId, tenant, "unplanned", unplannedIDs, unplanned, metaPlaceHolder);
                this.pushResponseRepository.save((Object)new PushResponse(pollingId, (Object)new /* Unavailable Anonymous Inner Class!! */, Boolean.valueOf(true)));
            } else if (isPlanned) {
                this.pushBoardItems(pollingId, tenant, "planned", plannedIDs, planned, metaPlaceHolder);
                responseJson.put("ids", plannedIDs.size() > 0 ? (Object)plannedIDs.get(0) : null);
                responseJson.put("items", planned);
            } else {
                this.pushBoardItems(pollingId, tenant, "unplanned", unplannedIDs, unplanned, metaPlaceHolder);
                responseJson.put("ids", unplannedIDs.size() > 0 ? (Object)unplannedIDs.get(0) : null);
                responseJson.put("items", unplanned);
            }
            return responseJson;
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public HashMap<String, Object> getBoardItems3(String polling, HashMap<String, Object> payload) {
        boolean completed = false;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            ArrayList<String> sids = new ArrayList<String>();
            ArrayList<WorkSpace> wids = new ArrayList<WorkSpace>();
            ArrayList<ObjectId> bids = new ArrayList<ObjectId>();
            bids.add(new ObjectId((String)payload.get("boardId")));
            sids.add((String)payload.get("sessionId"));
            wids.add(new WorkSpace((String)payload.get("workSpaceId")));
            List sessions = this.sessionRepository.findSessionsByIdInAndWorkSpaceIn(sids, wids);
            Set fields = ((Session)sessions.get(0)).combineAdditionalFields(null, null, true, null);
            if (PropertyValidator.isValid((Collection)fields)) {
                HashSet<String> keys = new HashSet<String>();
                for (ItemJiraFieldMap field : fields) {
                    keys.add(field.getKey());
                }
                payload.put("configFieldKeys", String.join((CharSequence)"','", keys));
            }
            Query query = new Query();
            if (PropertyValidator.isValid((Object)payload.get("parentIds"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in((Collection)KendisUtils.getListAsObjectIds2((Collection)((Collection)payload.get("parentIds")))));
            }
            if (PropertyValidator.isValid((Object)payload.get("teamIds"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.team.$id").in((Collection)KendisUtils.getListAsObjectIds2((Collection)((Collection)payload.get("teamIds")))));
            }
            if (PropertyValidator.isValid((Object)payload.get("containerIds"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.container.$id").in((Collection)KendisUtils.getListAsObjectIds2((Collection)((Collection)payload.get("containerIds")))));
            }
            if (PropertyValidator.isValid((Object)payload.get("issueTypes"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"issueType._id").in((Collection)KendisUtils.getListAsObjectIds2((Collection)((Collection)payload.get("issueTypes")))));
            }
            if (PropertyValidator.isValid((Object)payload.get("issueTypesNot"))) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"issueType._id").nin((Collection)KendisUtils.getListAsObjectIds2((Collection)((Collection)payload.get("issueTypesNot")))));
            }
            if (polling != null) {
                List count = this.customRepositoryImpl.findItemsByAggregation(null, bids, payload, Boolean.valueOf(true), query);
                Integer total = 0;
                if (PropertyValidator.isValid((Collection)count)) {
                    total = (Integer)((DBObject)count.get(0)).get("total");
                }
                Integer size = 500;
                Integer num = total / size;
                Integer rem = total % size;
                if (rem > 0) {
                    Integer n = num;
                    Integer n2 = num = Integer.valueOf(num + 1);
                }
                for (int i = 0; i < num; ++i) {
                    Integer start = i * size;
                    query.skip(start.intValue());
                    HashMap<String, Object> responsePages = new HashMap<String, Object>();
                    responsePages.put("pageNumber", i + 1);
                    responsePages.put("pageCount", num);
                    if (start + size > total) {
                        completed = true;
                        responsePages.put("done", completed);
                        query.limit(total % size);
                    } else {
                        query.limit(size.intValue());
                    }
                    responsePages.put("groups", this.customRepositoryImpl.findItemsByAggregation(null, bids, payload, Boolean.valueOf(false), query));
                    PushResponse pr = new PushResponse();
                    pr.setRequestId(polling);
                    pr.setResponseCompleted(Boolean.valueOf(completed));
                    pr.setFileReferenceKey(UUID.randomUUID().toString());
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    MongoSyncUtils.storeData((String)pr.getFileReferenceKey(), (String)mapper.writeValueAsString(responsePages), (AppConfig.MongoConfig)this.mongoConfig);
                    pr.setContentType("JSON");
                    this.pushResponseRepository.save((Object)pr);
                }
            } else {
                responseJson.put("groups", this.customRepositoryImpl.findItemsByAggregation(null, bids, payload, Boolean.valueOf(false), query));
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            responseJson.put("kendisError", ex);
        }
        if (polling != null && !completed) {
            PushResponse pr = new PushResponse();
            pr.setRequestId(polling);
            pr.setResponseCompleted(Boolean.valueOf(true));
            pr.setFileReferenceKey(UUID.randomUUID().toString());
            responseJson.put("done", true);
            responseJson.put("groups", new ArrayList());
            MongoSyncUtils.storeData((String)pr.getFileReferenceKey(), (String)new Gson().toJson(responseJson), (AppConfig.MongoConfig)this.mongoConfig);
            pr.setContentType("JSON");
            this.pushResponseRepository.save((Object)pr);
        }
        return responseJson;
    }

    private List<Map<String, Object>> parseItemTeamContainers(String itemId, List<DBRef> refs, Map<String, Object> tcMap) {
        if (PropertyValidator.isValid(refs)) {
            ArrayList<Map<String, Object>> teamContainers = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < refs.size(); ++i) {
                Object val;
                DBRef ref = refs.get(i);
                if (!PropertyValidator.isValid((Object)ref) || !PropertyValidator.isValid((Object)ref.getId()) || (val = tcMap.get(String.valueOf(ref.getId()))) == null) continue;
                if (val instanceof TeamContainer) {
                    TeamContainer tc = (TeamContainer)val;
                    if (tc == null) continue;
                    Team team = tc.getTeam();
                    Container container = tc.getContainer();
                    if (!PropertyValidator.isValid((Object)team) || !PropertyValidator.isValid((Object)team.getId()) || !PropertyValidator.isValid((Object)container) || !PropertyValidator.isValid((Object)container.getId())) continue;
                    HashMap<String, Object> o = new HashMap<String, Object>();
                    o.put("id", tc.getId());
                    o.put("sequence", tc.getSequence());
                    o.put("originItemId", tc.getOriginItemId());
                    o.put("duplicateOfId", tc.getDuplicateOfId());
                    o.put("teamId", tc.getTeam().getId());
                    o.put("containerId", tc.getContainer().getId());
                    teamContainers.add(o);
                    continue;
                }
                teamContainers.add((Map)val);
            }
            return teamContainers;
        }
        return null;
    }

    private void processItem(Item item, String tenant, Map<String, Object> metaPlaceHolder) throws Exception {
        List orgJiraLinks;
        if (metaPlaceHolder.containsKey("preItemsQuery")) {
            this.postItemQuery(tenant, metaPlaceHolder);
        }
        Map _itemLinksMap = (Map)metaPlaceHolder.get("_itemLinksMap");
        Map _jiraLinksMap = (Map)metaPlaceHolder.get("_jiraLinksMap");
        Map _statusesMap = (Map)metaPlaceHolder.get("_statusesMap");
        item.setStatus((Status)_statusesMap.get(item.getStatus().getId()));
        List orgItemLinks = item.getItemLinks();
        if (PropertyValidator.isValid((Collection)orgItemLinks)) {
            ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
            for (ItemLink link : orgItemLinks) {
                ItemLink newlink = (ItemLink)_itemLinksMap.get(link.getId());
                if (!PropertyValidator.isValid((Object)newlink)) continue;
                if (PropertyValidator.isValid((Object)newlink.getWfStatus())) {
                    newlink.getWfStatus().setWorkFlow(null);
                    newlink.getWfStatus().setWorkFlowItemType(null);
                }
                newItemLinks.add(newlink);
            }
            item.setItemLinks(newItemLinks);
        }
        if (PropertyValidator.isValid((Collection)(orgJiraLinks = item.getJiraDependencies()))) {
            ArrayList newJiraLinks = new ArrayList();
            for (ItemJiraDependency link : orgJiraLinks) {
                if (!PropertyValidator.isValid(_jiraLinksMap.get(link.getId()))) continue;
                ItemJiraDependency almLink = (ItemJiraDependency)_jiraLinksMap.get(link.getId());
                if (!PropertyValidator.isValid((Object)almLink.getJiraDependencyId()) && PropertyValidator.isValid((Object)almLink.getSourceItemId()) && PropertyValidator.isValid((Object)almLink.getTargetItemId())) {
                    String[] type = almLink.getTfsLinkType().split("-");
                    List<String> typeList = Arrays.asList(type);
                    if (typeList.size() > 1) {
                        if (typeList.get(1).equals("Reverse")) {
                            almLink.setJiraDependencyId(almLink.getTargetTFSItem().getTfsId() + "-" + almLink.getSourceTFSItem().getTfsId());
                        } else {
                            almLink.setJiraDependencyId(almLink.getSourceTFSItem().getTfsId() + "-" + almLink.getTargetTFSItem().getTfsId());
                        }
                    } else {
                        almLink.setJiraDependencyId(almLink.getSourceTFSItem().getTfsId() + "-" + almLink.getTargetTFSItem().getTfsId());
                    }
                }
                newJiraLinks.add(_jiraLinksMap.get(link.getId()));
            }
            item.setJiraDependencies(newJiraLinks);
        }
    }

    private void pushBoardItems(String requestId, String tenant, String planned, List<List<String>> sets, Map<String, Item> items, Map<String, Object> metaPlaceHolder) {
        boolean isunplanned;
        boolean bl = isunplanned = !planned.equals("planned");
        if (PropertyValidator.isValid(sets)) {
            for (int i = 0; i < sets.size(); ++i) {
                boolean done;
                Map<String, Item> push = null;
                push = requestId != null ? new HashMap<String, Item>() : items;
                List<String> subset = sets.get(i);
                try {
                    for (String id : subset) {
                        Item item = items.get(id);
                        if (item == null) continue;
                        this.processItem(item, tenant, metaPlaceHolder);
                        push.put(item.getId(), item);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
                boolean bl2 = done = i == sets.size() - 1;
                if (requestId == null) continue;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("set", planned);
                data.put("done", done);
                data.put("items", push);
                data.put("ids", subset);
                data.put("done", done && isunplanned);
                this.pushResponseRepository.save((Object)new PushResponse(requestId, data, Boolean.valueOf(false)));
            }
        } else if (isunplanned && requestId != null) {
            this.pushResponseRepository.save((Object)new PushResponse(requestId, (Object)new /* Unavailable Anonymous Inner Class!! */, Boolean.valueOf(true)));
        }
    }

    private Boolean isLoggedInCompanyUser(User user) {
        String loggedinCompanyId = UserContextUtil.getUserContext().getCurrentCompany().getId();
        for (UserCompany userCompany : user.getUserCompanies()) {
            if (userCompany.getCompany() == null || !userCompany.getCompany().getId().equals(loggedinCompanyId) || !userCompany.getIsActive().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Collection<ItemJiraFieldMap> getItemJiraFieldMap(Session session) throws Exception {
        ArrayList<ItemJiraFieldMap> configFields = new ArrayList<ItemJiraFieldMap>();
        if (PropertyValidator.isValid((Collection)session.getAlmConfigurations())) {
            List tmp;
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.reporter.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.assignee.name(), null, "JSONObject"));
            configFields.add(new ItemJiraFieldMap(JiraField.FIXED.updated.name(), null, "string"));
            if (PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesFeature())) {
                tmp = session.getAdditionalFieldsValuesFeature();
                for (ItemJiraFieldMap field : tmp) {
                    field.setClientTimeZone(session.getClientTimeZone());
                    configFields.add(field);
                }
            }
            if (PropertyValidator.isValid((Collection)session.getAdditionalFieldsValuesUserStory())) {
                tmp = session.getAdditionalFieldsValuesUserStory();
                for (ItemJiraFieldMap field : tmp) {
                    field.setClientTimeZone(session.getClientTimeZone());
                    configFields.add(field);
                }
            }
        }
        return configFields;
    }

    @RequestMapping(value={"/getAllBoards"})
    @ResponseBody
    public ResponseEntity<Object> getAllAccessableBoards() {
        HashMap<String, AbstractCollection> responseJson = new HashMap<String, AbstractCollection>();
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        HashSet workSpaces = new HashSet();
        HashSet<WorkSpace> activeWorkSpaces = new HashSet<WorkSpace>();
        ArrayList<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList<WorkSpaceAccessRole>();
        if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
            workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpacesByIsModuleIsFalseOrIsModuleIsNull());
            for (WorkSpace workSpace : workSpaces) {
                Boolean showWorkspace = false;
                if (PropertyValidator.isValid((Object)workSpace.getType()) && PropertyValidator.isValid((Collection)workSpace.getModules())) {
                    for (HashMap map : workSpace.getModules()) {
                        String id = (String)map.get("id");
                        if (!id.equalsIgnoreCase(EnumRTModules.ART_BOARDS.getCode())) continue;
                        showWorkspace = true;
                    }
                } else {
                    showWorkspace = true;
                }
                if (!showWorkspace.booleanValue()) continue;
                WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                accessRole.setWorkSpace(workSpace);
                accessRole.setUser(new User(user.getId()));
                workSpaceAccessRoles.add(accessRole);
                activeWorkSpaces.add(workSpace);
            }
        } else {
            Query query = new Query();
            List groupIds = user.getGroups().stream().filter(s -> ObjectId.isValid((String)s)).map(ObjectId::new).collect(Collectors.toList());
            Criteria criteria = new Criteria();
            criteria.orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group.$id").in(groupIds)});
            query.addCriteria((CriteriaDefinition)criteria);
            DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("workSpaceAccessRole").find(query.getQueryObject());
            List accessRoles = dbCursorPrefix.toArray();
            if (PropertyValidator.isValid((Collection)accessRoles)) {
                ArrayList<String> workSpaceIds = new ArrayList<String>();
                for (DBObject workSpaceAccessRole : accessRoles) {
                    DBRef workSpaceRef = (DBRef)workSpaceAccessRole.get("workSpace");
                    if (!PropertyValidator.isValid((Object)workSpaceRef) || !PropertyValidator.isValid((Object)workSpaceRef.getId())) continue;
                    workSpaceIds.add(String.valueOf(workSpaceRef.getId()));
                }
                if (!workSpaceIds.isEmpty() && PropertyValidator.isValid((Collection)(workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpaceByIdIn(workSpaceIds))))) {
                    for (WorkSpace workSpace : workSpaces) {
                        Boolean showWorkspace = false;
                        if (PropertyValidator.isValid((Object)workSpace.getType()) && PropertyValidator.isValid((Collection)workSpace.getModules())) {
                            for (HashMap map : workSpace.getModules()) {
                                String id = (String)map.get("id");
                                if (!EnumRTModules.ART_BOARDS.getCode().equalsIgnoreCase(id)) continue;
                                showWorkspace = true;
                                break;
                            }
                        } else {
                            showWorkspace = true;
                        }
                        if (!showWorkspace.booleanValue()) continue;
                        activeWorkSpaces.add(workSpace);
                    }
                }
            }
        }
        List sessions = new ArrayList();
        List parentBoards = new ArrayList();
        if (PropertyValidator.isValid(activeWorkSpaces)) {
            sessions = this.sessionRepository.findSessionsByWorkSpaceIn(new ArrayList(activeWorkSpaces));
            Map sidsTFS = this.planService.getSessionIdsMapForTfsBoards(sessions);
            if (!sessions.isEmpty()) {
                ArrayList<Integer> seqs = new ArrayList<Integer>();
                seqs.add(0);
                seqs.add(1);
                seqs.add(2);
                List states = this.stateRepository.findBySequenceIn(seqs);
                parentBoards = this.planService.getSessionBoardsBySessions(sessions, states, sidsTFS, null, null, null);
            }
        }
        responseJson.put("boards", (AbstractCollection)((Object)parentBoards));
        responseJson.put("workSpaces", activeWorkSpaces);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/journey-meta"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> piJourneyMeta(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        try {
            SessionBoard board = new SessionBoard();
            board.setId((String)payload.get("boardId"));
            board.setSession(new Session((String)payload.get("sessionId")));
            payload.get("sessionId");
            payload.get("teamIds");
            String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
            responseJson.put("piJourneyCapacities", this.piJourneyService.findCapacitiesByAggregation(tenant, board, (List)payload.get("teamIds"), "user"));
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/board/{id}", "/{id}/board"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoard(@PathVariable(value="id") String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(id);
            if (PropertyValidator.isValid((Object)sessionBoard)) {
                Session session;
                ArrayList<String> teamIds = new ArrayList<String>();
                if (PropertyValidator.isValid((Collection)sessionBoard.getTeams())) {
                    for (Team team : sessionBoard.getTeams()) {
                        team.setDeleteFromSystem(team.isArchive());
                        teamIds.add(team.getId());
                    }
                }
                List linkedBoards = PropertyValidator.isValid((Object)sessionBoard.getParentBoard()) ? this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getParentBoard(), sessionBoard.getParentBoard()) : this.sessionBoardRepository.findByIdOrParentBoardOrderByCreatedOnAsc(sessionBoard.getId(), sessionBoard.getId());
                List dependencyLimit = null;
                if (PropertyValidator.isValid((Object)sessionBoard.getSession())) {
                    dependencyLimit = this.almSyncService.getTeamSprintDependencies(sessionBoard);
                    sessionBoard.getSession().setStateScheme(this.getDefaultStateScheme());
                    sessionBoard.getSession().getStateScheme().setStates(this.stateRepository.findByStateScheme(sessionBoard.getSession().getStateScheme()));
                    sessionBoard.getSession().getItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getItemWorkFlow()));
                    sessionBoard.getSession().getSubItemWorkFlow().setStatuses(this.statusRepository.findByWorkFlow(sessionBoard.getSession().getSubItemWorkFlow()));
                    if (sessionBoard.getSession().getNewSystemLinkTypes().booleanValue()) {
                        List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
                        if (!PropertyValidator.isValid((Collection)kendisLinkTypes)) {
                            kendisLinkTypes = this.tfSservice.createNewKendisLinkTypes();
                        }
                        responseJson.put("kendisLinkTypes", kendisLinkTypes);
                    }
                }
                sessionBoard.setTeamSprintVelocities(this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoard.getId()));
                sessionBoard.setLinkedBoards(linkedBoards);
                ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
                sessionBoards.add(new SessionBoard(id));
                sessionBoard.setItems(new ArrayList());
                sessionBoard.setServerTimeZone(AlmUtils.getServerTimeZone());
                if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User user = this.customRepositoryImpl.findUserByAlmAccount(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getId(), sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getId());
                    if (PropertyValidator.isValid((Object)user)) {
                        sessionBoard.getSession().setLoggedUserHasAlm(Boolean.valueOf(true));
                    }
                    HashMap meta = KendisUtils.getTfsMeta((SessionBoard)sessionBoard, (TFSProjectRepository)this.tfsProjectRepository, (WorkFlowItemTypeRepository)this.workFlowItemTypeRepository, (WorkFlowRepository)this.workFlowRepository, (StatusRepository)this.statusRepository, (TFSservice)this.tfSservice);
                    responseJson.putAll(meta);
                }
                if ((session = sessionBoard.getSession()).getHideMilestonesBar() == null) {
                    session.setHideMilestonesBar(Boolean.TRUE);
                    sessionBoard.setSession(session);
                }
                responseJson.put("boardFilters", this.tfSservice.fetchBoardFilters(sessionBoard.getSession().getId(), UserContextUtil.getUserContext().getLoggedInUser().getId()));
                responseJson.put("sessionBoard", sessionBoard);
                this.customRepository.createDefaulBuckets();
                List allIssueTypes = this.issueTypeRepository.findAllByOrderBySequenceAsc();
                responseJson.put("allIssueTypes", allIssueTypes);
                StateScheme stateScheme = new StateScheme();
                stateScheme.setId(sessionBoard.getSession().getStateScheme().getId());
                responseJson.put("allStates", this.stateRepository.findByStateScheme(stateScheme));
                List itemSyncMappers = this.itemSyncMapperRepository.findBySessionBoard(sessionBoard);
                if (itemSyncMappers != null) {
                    responseJson.put("itemSyncMappers", itemSyncMappers);
                }
                List teamSprintVelocity = this.teamSprintVelocityRepository.findBySessionBoardId(sessionBoard.getId());
                responseJson.put("teamSprintVelocity", teamSprintVelocity);
                responseJson.put("teamSprintDependencyLimit", dependencyLimit);
                Instant start = Instant.now();
                Duration timeElapsed = null;
                List workFlowList = this.workFlowRepository.findAllByWorkflowType("Dependency");
                boolean addWorkflow = false;
                if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
                    if (PropertyValidator.isValid((Collection)workFlowList)) {
                        sessionBoard.getSession().setDependencyWorkFlow((WorkFlow)workFlowList.get(0));
                    } else {
                        sessionBoard.getSession().setDependencyWorkFlow(this.tfSservice.createDefaultDependencyWorkflow());
                    }
                    addWorkflow = true;
                }
                if (addWorkflow) {
                    this.sessionRepository.save((Object)sessionBoard.getSession());
                }
                if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getKendisOnlyLayout())) {
                    sessionBoard.getSession().setKendisOnlyLayout(this.customFieldService.getDefaultLayoutFromItemType(EnumKendis.KENDIS_ONLY_CARD.getCode()));
                }
                List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
                WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
                ArrayList sortedStatuses = new ArrayList();
                HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
                if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
                    String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
                    for (Status status : dependencyStatuses) {
                        sortedStatusesMap.put(status.getId(), status);
                    }
                    for (String statusId : sortedStatusIds) {
                        sortedStatuses.add(sortedStatusesMap.get(statusId));
                    }
                    responseJson.put("dependencyStatuses", sortedStatuses);
                } else {
                    responseJson.put("dependencyStatuses", dependencyStatuses);
                }
                List usersAll = this.userRepository.findUsersByUserCompanies_Company_IdAndUserCompanies_isArchive(UserContextUtil.getUserContext().getCurrentCompany().getId(), Boolean.valueOf(false));
                responseJson.put("users", usersAll);
                Instant end = Instant.now();
                timeElapsed = Duration.between(start, end);
            }
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private List<Status> getDependencyStatuses(SessionBoard sessionBoard) {
        List dependencyStatuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
        WorkFlow workFlow = sessionBoard.getSession().getDependencyWorkFlow();
        ArrayList<Status> sortedStatuses = new ArrayList<Status>();
        HashMap<String, Status> sortedStatusesMap = new HashMap<String, Status>();
        if (PropertyValidator.isValid((Object)workFlow.getStatusSequence())) {
            String[] sortedStatusIds = workFlow.getStatusSequence().split(",");
            for (Status status : dependencyStatuses) {
                sortedStatusesMap.put(status.getId(), status);
            }
            for (String statusId : sortedStatusIds) {
                sortedStatuses.add((Status)sortedStatusesMap.get(statusId));
            }
            return sortedStatuses;
        }
        return dependencyStatuses;
    }

    @RequestMapping(value={"/boardAlmCredentials/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardAlmCredentials(@PathVariable(value="id") String id) {
        AlmError almErr;
        TFSResponse authResponse;
        AzureOAuthToken azureOAuthToken;
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        responseJson.put("success", true);
        AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        AlmAccUser almAccUser = this.tfsUtils.getUserAlmCredntials(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getId(), loggedInUser);
        if (PropertyValidator.isValid((Object)almAccUser)) {
            almAccUser.getAlmUsername();
            almAccUser.getAlmPassword();
            azureOAuthToken = almAccUser.getAzureOAuthToken();
            if (PropertyValidator.isValid((Object)azureOAuthToken) && this.tfsUtils.isInValidToken(azureOAuthToken)) {
                try {
                    azureOAuthToken = this.tfsUtils.refreshAlmToken(azureOAuthToken, almAccount.getId());
                    this.tfsUtils.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), null);
                }
                catch (ViztrendJiraException exception) {
                    LOGGER.error(exception.toString());
                }
            }
            if (PropertyValidator.isValid((Object)(authResponse = this.tfsUtils.authenticate(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getUrl(), almAccUser.getAlmUsername(), almAccUser.getAlmPassword(), azureOAuthToken))) && PropertyValidator.isValid((Object)authResponse.getStatusCode()) && !authResponse.getStatusCode().equals(200)) {
                almErr = new AlmError();
                almErr.setRequestJson(authResponse.getContent());
                almErr.setEndPoint(authResponse.getUrl());
                almErr.setIsTaggedUserAlm(Boolean.valueOf(true));
                almErr.setUserName(loggedInUser.getFullName());
                almErr.setHttpErrorCode(authResponse.getStatusCode());
                almErr.setErrorJson(authResponse.getContent());
                almErr.setReason(authResponse.getReason());
                responseJson.put("success", false);
                responseJson.put("tfsProfileUserError", (Object)new ViztrendJiraException(authResponse.getStatusCode(), authResponse.getReason(), almErr));
                responseJson.put("alm", almAccount);
            }
        }
        if (PropertyValidator.isValid((Object)(azureOAuthToken = almAccount.getAzureOAuthToken())) && this.tfsUtils.isInValidToken(azureOAuthToken)) {
            try {
                azureOAuthToken = this.tfsUtils.refreshAlmToken(azureOAuthToken, almAccount.getId());
                this.tfsUtils.updateAlmAccount(azureOAuthToken, almAccount.getId());
            }
            catch (ViztrendJiraException exception) {
                LOGGER.error("Error occurred while refreshing Alm Token", (Throwable)exception);
            }
        }
        if (PropertyValidator.isValid((Object)(authResponse = this.tfsUtils.authenticate(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount().getUrl(), almAccount.getUsername(), almAccount.getPassword(), azureOAuthToken))) && PropertyValidator.isValid((Object)authResponse.getStatusCode()) && !authResponse.getStatusCode().equals(200)) {
            almErr = new AlmError();
            almErr.setRequestJson(authResponse.getContent());
            almErr.setEndPoint(authResponse.getUrl());
            almErr.setIsTaggedUserAlm(Boolean.valueOf(false));
            almErr.setUserName(loggedInUser.getFullName());
            almErr.setHttpErrorCode(authResponse.getStatusCode());
            almErr.setErrorJson(authResponse.getContent());
            almErr.setReason(authResponse.getReason());
            responseJson.put("success", false);
            responseJson.put("tfsALMError", (Object)new ViztrendJiraException(authResponse.getStatusCode(), authResponse.getReason(), almErr));
            responseJson.put("alm", almAccount);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/dependencyTeamContainers"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getDependencyTeamContainers(@RequestBody HashMap<String, Object> payload) {
        String sessionBoardId = (String)payload.get("sessionBoardId");
        String tcIdsString = (String)payload.get("tcIds");
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        HashMap<String, List> responseJson = new HashMap<String, List>();
        if (PropertyValidator.isValid((Object)tcIdsString)) {
            String[] tcIds = tcIdsString.split(",");
            List<String> tcIdList = Arrays.asList(tcIds);
            List teamContainers = this.teamContainerRepository.findByIdIn(tcIdList);
            List items = this.itemRepository.findByTypeAndTeamContainersIn(Item.FEATURE, teamContainers);
            responseJson.put("teamContainers", teamContainers);
            responseJson.put("items", items);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/boardTfsLinkTypes/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardTfsLinkTypes(@PathVariable(value="id") String id) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        Object tfsLinkTypesStr = this.tfsUtils.getRelationShipTypes(almAccount);
        if (tfsLinkTypesStr instanceof String) {
            TFSMeta tfsMeta = new TFSMeta();
            tfsMeta.setLinkTypes((String)tfsLinkTypesStr);
            if (PropertyValidator.isValid((Collection)sessionBoard.getSession().getAlmConfigurations())) {
                tfsMeta.setAlmAccount(sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount());
            }
            responseJson.put("tfsMeta", tfsMeta);
        } else {
            ViztrendJiraException exception = (ViztrendJiraException)((Object)tfsLinkTypesStr);
            if (!PropertyValidator.isValid((Object)exception.getCode()) || !exception.getCode().equals(200)) {
                responseJson.put("tfsALMErrorCode", exception.getCode());
                responseJson.put("tfsALMErrorMessage", exception.getAlmError());
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/items/{id}"})
    @ResponseBody
    public ResponseEntity<Object> getBoardItemsCall(@PathVariable(value="id") String id, HttpServletRequest request) {
        try {
            HashMap responseJson = this.getBoardItems1(id, request.getParameter("sortOpt"));
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(new HashMap(), HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/{type}items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadBoardItemsCall(@PathVariable(value="type") String type, @RequestBody HashMap<String, Object> payload) {
        String polling = (String)payload.get("polling");
        if (PropertyValidator.isValid((Object)type) && type.indexOf("planned") > -1) {
            if (PropertyValidator.isValid((Object)polling)) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                return new ResponseEntity(new HashMap(), HttpStatus.OK);
            }
            return new ResponseEntity((Object)this.getBoardItems2((String)payload.get("boardId"), null, type, polling), HttpStatus.OK);
        }
        if (PropertyValidator.isValid((Object)polling)) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            return new ResponseEntity(new HashMap(), HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.getBoardItems3(polling, payload), HttpStatus.OK);
    }

    public HashMap<String, Object> getBoardItems(String sessionBoardId) {
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        SessionBoard board = new SessionBoard(sessionBoardId);
        sessionBoards.add(board);
        List bos = this.itemRepository.findBySessionBoardsInOrderBySequence(sessionBoards);
        ArrayList<Item> boardItems = new ArrayList<Item>();
        HashMap<String, Item> parentItems = new HashMap<String, Item>();
        HashMap childItemsByParentId = new HashMap();
        if (PropertyValidator.isValid((Collection)bos)) {
            for (Item it : bos) {
                Item item = this.transform(it);
                if (PropertyValidator.isValid((Object)item.getParent())) {
                    if (!childItemsByParentId.containsKey(item.getParent().getId())) {
                        childItemsByParentId.put(item.getParent().getId(), new ArrayList());
                    }
                    ((List)childItemsByParentId.get(item.getParent().getId())).add(item);
                    continue;
                }
                item.setSubItems(new ArrayList());
                parentItems.put(item.getId(), item);
                boardItems.add(item);
            }
        }
        for (String parentId : childItemsByParentId.keySet()) {
            if (!parentItems.containsKey(parentId)) continue;
            ((Item)parentItems.get(parentId)).getSubItems().addAll((Collection)childItemsByParentId.get(parentId));
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("items", boardItems);
        return responseJson;
    }

    @RequestMapping(value={"/dependencies/download"}, method={RequestMethod.POST})
    public ResponseEntity<Object> downloadDeps(@RequestBody String reqBody) {
        try {
            String extension = "xls";
            JSONObject reqBodyObj = new JSONObject(reqBody);
            int exportType = 1;
            String viewType = reqBodyObj.getString("viewType");
            if (PropertyValidator.isValid((Object)reqBodyObj.getString("exportType")) && "csv".equalsIgnoreCase(reqBodyObj.getString("exportType"))) {
                extension = "csv";
                exportType = 0;
            }
            String filePath = this.exportService.exportDepsDataTFS(reqBodyObj.getJSONArray("dependencyData"), exportType, viewType);
            String cleanedSessionTitle = AlmUtils.cleanText((String)reqBodyObj.getString("boardName"));
            String downloadName = AlmUtils.cleanText((String)(cleanedSessionTitle + AlmUtils.cleanText((String)"_dependencies"))) + "." + extension;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", filePath);
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }

    @RequestMapping(value={"/getBoardDependencies/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getBoardDependencies(@PathVariable(value="sessionBoardId") String sessionBoardId) {
        List itemLinks;
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        WorkFlow depWorkflow = sessionBoard.getSession().getDependencyWorkFlow();
        List depWorkflowStatusesAll = null;
        ArrayList<Status> depWorkflowStatuses = new ArrayList<Status>();
        if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getDependencyWorkFlow())) {
            depWorkflow = this.workFlowRepository.findByIsDefaultIsTrueAndWorkflowType("Dependency");
        }
        if (PropertyValidator.isValid((Object)depWorkflow)) {
            depWorkflowStatusesAll = this.statusRepository.findByWorkFlow(depWorkflow);
            for (Status s : depWorkflowStatusesAll) {
                if (depWorkflowStatuses.size() == 0) {
                    if (!s.getCategory().equals("ToDo")) continue;
                    depWorkflowStatuses.add(s);
                    continue;
                }
                if (!s.getCategory().equals("Done")) continue;
                depWorkflowStatuses.add(s);
                break;
            }
        }
        if (PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findBySessionBoardId(sessionBoardId)))) {
            this.transformItemLinksStatus(itemLinks, depWorkflowStatuses);
        }
        HashMap responseJson = new HashMap();
        return new ResponseEntity((Object)itemLinks, HttpStatus.OK);
    }

    @RequestMapping(value={"/getPiDependenciesForSolution/{solutionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPiDependenciesForSolution(@PathVariable(value="solutionId") String solutionId) {
        SolutionBoard solutionBoard = this.solutionBoardRepository.findById(solutionId);
        List sessions = this.sessionRepository.findByIdIn((List)solutionBoard.getPiSessions());
        ArrayList<String> sessionBoardIds = new ArrayList<String>();
        HashMap<String, Object> responseObject = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Collection)sessions)) {
            for (Session session : sessions) {
                AlmAccount almAccount;
                sessionBoardIds.add(session.getActiveSessionBoard());
                if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations())) {
                    almAccount = session.getTfsAlmConfigurations().getAlmAccount();
                    HashMap linkTypesResult = this.tfSservice.retrieveJiraIssueLinkTypesList(almAccount, false);
                    String linkTypes = (String)linkTypesResult.get("linkTypes");
                    responseObject.put("tfsLinkTypes", linkTypes);
                    continue;
                }
                if (!PropertyValidator.isValid((Collection)session.getAlmConfigurations())) continue;
                almAccount = session.getTfsAlmConfigurations().getAlmAccount();
                responseObject.put("jiraLinkTypes", this.aLMSyncService.retrieveJiraIssueLinkTypesList(almAccount, false));
            }
        }
        List itemLinks = this.itemLinkRepository.findBySessionBoardIdIn(sessionBoardIds);
        HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList<String> teamContainerIds = new ArrayList<String>();
        if (PropertyValidator.isValid((Collection)itemLinks)) {
            for (ItemLink itemLink : itemLinks) {
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    if (duplicationCheckMap.get(itemLink.getSourceUserStoryId()) == null) {
                        duplicationCheckMap.put(itemLink.getSourceUserStoryId(), itemLink.getSourceUserStoryId());
                        itemIds.add(itemLink.getSourceUserStoryId());
                    }
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    if (duplicationCheckMap.get(itemLink.getSourceFeatureId()) == null) {
                        duplicationCheckMap.put(itemLink.getSourceFeatureId(), itemLink.getSourceFeatureId());
                        itemIds.add(itemLink.getSourceFeatureId());
                    }
                } else if (PropertyValidator.isValid((Object)itemLink.getSourceItemId()) && duplicationCheckMap.get(itemLink.getSourceItemId()) == null) {
                    duplicationCheckMap.put(itemLink.getSourceItemId(), itemLink.getSourceItemId());
                    itemIds.add(itemLink.getSourceItemId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    if (duplicationCheckMap.get(itemLink.getTargetUserStoryId()) == null) {
                        duplicationCheckMap.put(itemLink.getTargetUserStoryId(), itemLink.getTargetUserStoryId());
                        itemIds.add(itemLink.getTargetUserStoryId());
                    }
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    if (duplicationCheckMap.get(itemLink.getTargetFeatureId()) == null) {
                        duplicationCheckMap.put(itemLink.getTargetFeatureId(), itemLink.getTargetFeatureId());
                        itemIds.add(itemLink.getTargetFeatureId());
                    }
                } else if (PropertyValidator.isValid((Object)itemLink.getTargetItemId()) && duplicationCheckMap.get(itemLink.getTargetItemId()) == null) {
                    duplicationCheckMap.put(itemLink.getTargetItemId(), itemLink.getTargetItemId());
                    itemIds.add(itemLink.getTargetItemId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId()) && duplicationCheckMap.get(itemLink.getSourceTeamContainerId()) == null) {
                    duplicationCheckMap.put(itemLink.getSourceTeamContainerId(), itemLink.getSourceTeamContainerId());
                    teamContainerIds.add(itemLink.getSourceTeamContainerId());
                }
                if (!PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId()) || duplicationCheckMap.get(itemLink.getTargetTeamContainerId()) != null) continue;
                duplicationCheckMap.put(itemLink.getTargetTeamContainerId(), itemLink.getTargetTeamContainerId());
                teamContainerIds.add(itemLink.getTargetTeamContainerId());
            }
        }
        List items = this.itemRepository.findByIdIn(itemIds);
        List teamContainers = this.teamContainerRepository.findByIdIn(teamContainerIds);
        responseObject.put("items", items);
        responseObject.put("teamContainers", teamContainers);
        responseObject.put("itemLinks", itemLinks);
        return new ResponseEntity(responseObject, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSolutionDependencies/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSolutionDependencies(@PathVariable(value="sessionBoardId") String sessionBoardId) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = sessionBoard.getSession();
        List itemLinks = this.itemLinkRepository.findBySourceSessionIdOrTargetSessionId(session.getId(), session.getId());
        ArrayList<String> solutionsIds = new ArrayList<String>();
        ArrayList<String> sessionIds = new ArrayList<String>();
        ArrayList<String> itemIds = new ArrayList<String>();
        ArrayList<String> containerIds = new ArrayList<String>();
        HashMap<String, String> duplicationCheckMap = new HashMap<String, String>();
        if (PropertyValidator.isValid((Collection)itemLinks)) {
            for (ItemLink itemLink : itemLinks) {
                if (duplicationCheckMap.get(itemLink.getSolutionId()) == null) {
                    duplicationCheckMap.put(itemLink.getSolutionId(), itemLink.getSolutionId());
                    solutionsIds.add(itemLink.getSolutionId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceSessionId()) && duplicationCheckMap.get(itemLink.getSourceSessionId()) == null) {
                    duplicationCheckMap.put(itemLink.getSourceSessionId(), itemLink.getSourceSessionId());
                    sessionIds.add(itemLink.getSourceSessionId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetSessionId()) && duplicationCheckMap.get(itemLink.getTargetSessionId()) == null) {
                    duplicationCheckMap.put(itemLink.getTargetSessionId(), itemLink.getTargetSessionId());
                    sessionIds.add(itemLink.getTargetSessionId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceContainerId()) && duplicationCheckMap.get(itemLink.getSourceContainerId()) == null) {
                    duplicationCheckMap.put(itemLink.getSourceContainerId(), itemLink.getSourceContainerId());
                    containerIds.add(itemLink.getSourceContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetContainerId()) && duplicationCheckMap.get(itemLink.getTargetContainerId()) == null) {
                    duplicationCheckMap.put(itemLink.getTargetContainerId(), itemLink.getTargetContainerId());
                    containerIds.add(itemLink.getTargetContainerId());
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceItemId()) && duplicationCheckMap.get(itemLink.getSourceItemId()) == null) {
                    duplicationCheckMap.put(itemLink.getSourceItemId(), itemLink.getSourceItemId());
                    itemIds.add(itemLink.getSourceItemId());
                }
                if (!PropertyValidator.isValid((Object)itemLink.getTargetItemId()) || duplicationCheckMap.get(itemLink.getTargetItemId()) != null) continue;
                duplicationCheckMap.put(itemLink.getTargetItemId(), itemLink.getTargetItemId());
                itemIds.add(itemLink.getTargetItemId());
            }
        }
        List solutionBoards = this.solutionBoardRepository.findByIdIn(solutionsIds);
        List containers = this.containerRepository.findByIdIn(containerIds);
        List items = this.itemRepository.findByIdIn(itemIds);
        List sessions = this.sessionRepository.findByIdIn(sessionIds);
        HashMap<String, List> responseObject = new HashMap<String, List>();
        responseObject.put("links", itemLinks);
        responseObject.put("solutionBoards", solutionBoards);
        responseObject.put("sessions", sessions);
        responseObject.put("containers", containers);
        responseObject.put("items", items);
        return new ResponseEntity(responseObject, HttpStatus.OK);
    }

    private void transformItemLinksStatus(Item item, List<Status> statuses) {
        if (PropertyValidator.isValid(statuses) && statuses.size() == 2) {
            List itemLinks = item.getItemLinks();
            this.transformItemLinksStatus(itemLinks, statuses);
        }
    }

    private void transformItemLinksStatus(List<ItemLink> itemLinks, List<Status> statuses) {
        if (PropertyValidator.isValid(statuses) && statuses.size() == 2 && PropertyValidator.isValid(itemLinks)) {
            for (ItemLink link : itemLinks) {
                if (PropertyValidator.isValid((Object)link.getWfStatus())) continue;
                if (link.getStatus().equals("Open")) {
                    link.setWfStatus(statuses.get(0));
                    continue;
                }
                link.setWfStatus(statuses.get(1));
            }
        }
    }

    @RequestMapping(value={"/board/saveteamorder"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTeamOrder(@RequestBody HashMap<String, Object> payload) {
        SessionBoard sessionBoard;
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        String sessionBoardId = (String)payload.get("sessionBoardId");
        String teamSeqStr = (String)payload.get("teamSequence");
        if (!PropertyValidator.isValid((Object)teamSeqStr)) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        ArrayList<String> finalSequence = new ArrayList<String>();
        String[] newTeamSequences = teamSeqStr.split(",");
        HashMap<String, String> newTeamSequencesMap = new HashMap<String, String>();
        for (String sequence : newTeamSequences) {
            newTeamSequencesMap.put(sequence, sequence);
            finalSequence.add(sequence);
        }
        if (PropertyValidator.isValid((Object)sessionBoardId) && PropertyValidator.isValid((Object)(sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId))))) {
            HashMap<String, String> saveTeamSequencesMap = new HashMap<String, String>();
            for (String sequence : sessionBoard.getTeamSequence()) {
                saveTeamSequencesMap.put(sequence, sequence);
                if (newTeamSequencesMap.get(sequence) != null) continue;
                finalSequence.add(sequence);
            }
            for (int i = 0; i < finalSequence.size(); ++i) {
                String sequence = (String)finalSequence.get(i);
                if (saveTeamSequencesMap.get(sequence) != null) continue;
                finalSequence.remove(i);
                --i;
            }
            sessionBoard.setTeamSequence(finalSequence.toArray(new String[0]));
            sessionBoard = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
            responseJson.put("success", true);
            responseJson.put("sessionBoard", (Boolean)sessionBoard);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
    }

    private Item transform(Item vo) {
        Item bo = new Item(vo);
        return bo;
    }

    @RequestMapping(value={"/board/{boardId}/errors"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSessionErrors(@PathVariable(value="boardId") String boardId, @RequestBody HashMap<String, Object> payload) {
        List list = this.almErrorRepository.findBySessionBoardId(boardId);
        return new ResponseEntity((Object)list, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchtfsmeta/{almId}"})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSMeta(@PathVariable(value="almId") String almId) {
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        this.tfSservice.fetchTFSMeta(almAccount);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchtfsprojects/{almId}"})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSProjects1(@PathVariable(value="almId") String almId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        try {
            String tfsProjects = this.tfSservice.fetchTFSProjects(almAccount);
            responseJson.put("tfsProjects", tfsProjects);
            responseJson.put("success", true);
        }
        catch (ViztrendJiraException e2) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)e2);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignoreKanbanMappedItems/{sessionId}"})
    @ResponseBody
    public ResponseEntity<Object> ignoreKanbanMappedItems(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            session.setItemsAddedFromKanban(new ArrayList());
            session = (Session)this.sessionRepository.save((Object)session);
            responseJson.put("session", session);
            responseJson.put("success", true);
        }
        catch (ViztrendJiraException e2) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)e2);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/arrangeItemsWithTeamMapping/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> arrangeItemsWithTeamMapping(@PathVariable(value="sessionBoardId") String sessionBoardId, @RequestBody HashMap<String, String> payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/updateItemTeamContainer"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateItemTeamContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String parentChange = (String)payload.get("parentChange");
        String teamChange = (String)payload.get("teamChange");
        String tfsSprintChange = (String)payload.get("tfsSprintChange");
        String tfsSprintPath = (String)payload.get("tfsSprintPath");
        String tfsAreaPath = (String)payload.get("tfsAreaPath");
        String tfsProjectId = (String)payload.get("tfsProjectId");
        String tfsProject = (String)payload.get("tfsProject");
        String igonreAreaPath = (String)payload.get("igonreAreaPath");
        ArrayList tfsAreaPathsForTeam = (ArrayList)payload.get("tfsAreaPathsForTeam");
        Boolean includeSubAreaPaths = (Boolean)payload.get("includeSubAreaPaths");
        String itemId = (String)payload.get("itemId");
        String parentId = (String)payload.get("parentId");
        String teamContainerStr = (String)payload.get("addTC");
        boolean changeParent = PropertyValidator.isValid((Object)parentChange) && parentChange.equals("true");
        boolean setSequence = false;
        double sequence = 0.0;
        String sequenceKey = "";
        if (payload.get("sequence") != null) {
            setSequence = true;
            sequence = Double.parseDouble((String)payload.get("sequence"));
            sequenceKey = (String)payload.get("sequenceKey");
        }
        boolean isChildTeamContainerUpdate = false;
        String metaMap = (String)payload.get("metaMap");
        Gson gson = new Gson();
        6 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap _meta = (HashMap)gson.fromJson(metaMap, T.getType());
        String jiraFieldsJson = (String)_meta.get("itemJiraFields");
        ItemJiraFieldMap jiraField = null;
        if (PropertyValidator.isValid((Object)jiraFieldsJson)) {
            jiraField = (ItemJiraFieldMap)gson.fromJson(jiraFieldsJson, ItemJiraFieldMap.class);
        }
        String updateChildId = (String)payload.get("childId");
        HashMap removeTC = (HashMap)payload.get("removeTC");
        Item item = this.itemRepository.findById(itemId);
        if (item.getKendisId() != null && item.getFields() != null && _meta.containsKey("popupLinkedARTs")) {
            item.getFields().put("popupLinkedARTs", _meta.get("popupLinkedARTs"));
            _meta.remove("popupLinkedARTs");
        }
        if (item.getPhoenixSequence() == null) {
            item.setPhoenixSequence(item.maxPhoenixSequence());
        }
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)item.getSessionBoards().get(0)).getId()));
        Item movingStory = null;
        String oldParentId = null;
        String oldParenKendistId = null;
        if (item.getParent() != null) {
            oldParentId = item.getParent().getTfsId();
            oldParenKendistId = item.getParent().getId();
            movingStory = item;
        }
        item.setMetaMap(metaMap);
        List childs = null;
        boolean avoidParentLog = false;
        if (updateChildId != null && !updateChildId.equals("all") && !updateChildId.equals("teamcontainer")) {
            Item child = this.itemRepository.findById(updateChildId);
            childs = new ArrayList<Item>();
            childs.add(child);
            if (changeParent) {
                oldParentId = child.getParent().getTfsId();
                oldParenKendistId = child.getParent().getId();
                movingStory = child;
                child.setParent(item);
            }
            if (PropertyValidator.isValid((Object)teamChange) && !teamChange.equals("true")) {
                avoidParentLog = true;
            }
        }
        if (item.getType().equals(Item.Type.UserStory.name()) && PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            item.setContainer(((TeamContainer)item.getTeamContainers().get(0)).getContainer());
            item.setTeam(((TeamContainer)item.getTeamContainers().get(0)).getTeam());
        }
        TeamContainer teamContainer = null;
        TeamContainer removedTC = null;
        if (removeTC != null) {
            String removeTCId = (String)removeTC.get("id");
            List teamContainers = item.getTeamContainers();
            if (teamContainers != null) {
                for (int i = 0; i < teamContainers.size(); ++i) {
                    TeamContainer tc = (TeamContainer)teamContainers.get(i);
                    if (!tc.getId().equals(removeTCId)) continue;
                    removedTC = (TeamContainer)teamContainers.remove(i);
                    break;
                }
            }
            item.setTeamContainers(teamContainers);
            Boolean removeChild = (Boolean)removeTC.get("child");
            if (childs == null) {
                ArrayList tcs = new ArrayList();
                TeamContainer tc = new TeamContainer();
                tc.setId(removeTCId);
                tcs.add(tc);
                Item parent = new Item();
                parent.setId(item.getId());
                childs = this.itemRepository.findByParentAndTeamContainersIn(parent, (List)tcs);
            }
            if (removeChild != null && removeChild.booleanValue() && childs != null) {
                for (Item child : childs) {
                    child.setTeamContainers(new ArrayList());
                }
            }
        }
        Container oldContainer = null;
        Team oldTeam = null;
        HashMap<String, String> childPreviousAreaPathMap = new HashMap<String, String>();
        if (teamContainerStr != null) {
            ArrayList<TeamContainer> itemTeamContainers;
            ObjectMapper mapper = new ObjectMapper();
            try {
                teamContainer = (TeamContainer)mapper.readValue(teamContainerStr, TeamContainer.class);
            }
            catch (JsonParseException child) {
            }
            catch (JsonMappingException child) {
            }
            catch (IOException child) {
                // empty catch block
            }
            if (item.getType().equals(Item.Type.Feature.name()) && PropertyValidator.isValid((Object)teamContainer.getId())) {
                isChildTeamContainerUpdate = true;
                TeamContainer old = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)teamContainer.getId()));
                if (old != null) {
                    oldContainer = old.getContainer();
                    oldTeam = old.getTeam();
                }
            }
            teamContainer.setContainer((Container)this.containerRepository.findOne((Serializable)((Object)teamContainer.getContainer().getId())));
            teamContainer = (TeamContainer)this.teamContainerRepository.save((Object)teamContainer);
            if (updateChildId != null && updateChildId.equals("teamcontainer")) {
                ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
                TeamContainer tc = new TeamContainer();
                tc.setId(teamContainer.getId());
                tcs.add(tc);
                Item parent = new Item();
                parent.setId(item.getId());
                childs = this.itemRepository.findByParentAndTeamContainersIn(parent, tcs);
            }
            if ((itemTeamContainers = item.getTeamContainers()) == null) {
                itemTeamContainers = new ArrayList<TeamContainer>();
                item.setTeamContainers(itemTeamContainers);
            }
            if (item.getParent() != null) {
                List inboundItemLinks;
                if (itemTeamContainers != null) {
                    itemTeamContainers.clear();
                }
                ArrayList allItemLinks = new ArrayList();
                List outboundItemLinks = item.getItemLinks();
                if (PropertyValidator.isValid((Collection)outboundItemLinks)) {
                    for (int i = 0; i < outboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)outboundItemLinks.get(i);
                        link.setSourceTeamContainerId(teamContainer.getId());
                        if (PropertyValidator.isValid((Object)parentId)) {
                            link.setSourceFeatureId(parentId);
                            continue;
                        }
                        link.setSourceFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(outboundItemLinks);
                }
                if (PropertyValidator.isValid((Collection)(inboundItemLinks = this.itemLinkRepository.findByTargetUserStoryId(item.getId())))) {
                    for (int i = 0; i < inboundItemLinks.size(); ++i) {
                        ItemLink link = (ItemLink)inboundItemLinks.get(i);
                        link.setTargetTeamContainerId(teamContainer.getId());
                        if (PropertyValidator.isValid((Object)parentId)) {
                            link.setTargetFeatureId(parentId);
                            continue;
                        }
                        link.setTargetFeatureId(item.getParent().getId());
                    }
                    allItemLinks.addAll(inboundItemLinks);
                }
                if (PropertyValidator.isValid(allItemLinks)) {
                    this.itemLinkRepository.save(allItemLinks);
                    responseJson.put("updatedLinks", allItemLinks);
                }
            }
            HashMap<Object, Boolean> duplicationCheckMapTeamContainer = new HashMap<Object, Boolean>();
            for (int i = 0; i < itemTeamContainers.size(); ++i) {
                TeamContainer tc = (TeamContainer)itemTeamContainers.get(i);
                int index = -1;
                if (tc == null) {
                    index = i;
                } else {
                    if (tc.getId().equals(teamContainer.getId())) {
                        index = i;
                    }
                    if (PropertyValidator.isValid((Object)tc.getTeam()) && PropertyValidator.isValid((Object)tc.getContainer())) {
                        String key = tc.getTeam().getId() + ":" + tc.getContainer().getId();
                        if (tc.getTeam().getId().equals(teamContainer.getTeam().getId()) && tc.getContainer().getId().equals(teamContainer.getContainer().getId())) {
                            index = i;
                        } else if (PropertyValidator.isValid(duplicationCheckMapTeamContainer.get(key))) {
                            index = i;
                        }
                        if (index > -1) {
                            duplicationCheckMapTeamContainer.put(key, Boolean.TRUE);
                        }
                    } else {
                        index = i;
                    }
                }
                if (index <= -1 || index >= itemTeamContainers.size()) continue;
                itemTeamContainers.remove(index);
                --i;
            }
            itemTeamContainers.add(teamContainer);
            if (childs != null) {
                ArrayList<TeamContainer> citemTeamContainers = new ArrayList<TeamContainer>();
                citemTeamContainers.add(teamContainer);
                ArrayList inboundDeps = new ArrayList();
                ArrayList outboundDeps = new ArrayList();
                for (Item child : childs) {
                    ItemLink link;
                    Object itemLinks;
                    if (PropertyValidator.isValid((Object)tfsProjectId) && PropertyValidator.isValid((Object)tfsProject)) {
                        String previousChildProject = child.getTfsProjectId();
                        String previousChildAreaPath = child.getTfsAreaPath();
                        childPreviousAreaPathMap.put(child.getId(), previousChildAreaPath);
                        child.setTfsProjectId(tfsProjectId);
                        child.setTfsProject(tfsProject);
                        if (PropertyValidator.isValid((Object)tfsSprintChange) && tfsSprintChange.equals("true")) {
                            if (tfsAreaPath != null && !tfsAreaPath.equals(previousChildAreaPath)) {
                                String _areaPath = null;
                                if (PropertyValidator.isValid((Collection)tfsAreaPathsForTeam)) {
                                    _areaPath = tfsAreaPathsForTeam.stream().filter(ap -> ap.equals(previousChildAreaPath)).findAny().orElse(null);
                                }
                                if (includeSubAreaPaths != null && includeSubAreaPaths.booleanValue() && PropertyValidator.isValid((Object)previousChildAreaPath) && previousChildAreaPath.startsWith(tfsAreaPath + "\\")) {
                                    _areaPath = previousChildAreaPath;
                                }
                                if (_areaPath == null && PropertyValidator.isValid((Object)tfsSprintPath)) {
                                    String project = tfsSprintPath.substring(0, tfsSprintPath.indexOf("\\"));
                                    if (!sessionBoard.getSession().getAreaPathDisabled().booleanValue()) {
                                        if (PropertyValidator.isValid((Object)tfsAreaPath)) {
                                            child.setTfsAreaPath(tfsAreaPath);
                                        } else {
                                            child.setTfsAreaPath(project);
                                        }
                                    } else if (previousChildProject != null && !previousChildProject.equals(tfsProjectId)) {
                                        if (PropertyValidator.isValid((Object)tfsAreaPath)) {
                                            child.setTfsAreaPath(tfsAreaPath);
                                        } else {
                                            child.setTfsAreaPath(project);
                                        }
                                    }
                                }
                            }
                            child.setTfsIterationPath(tfsSprintPath);
                        }
                    }
                    if (PropertyValidator.isValid((Collection)(itemLinks = child.getItemLinks()))) {
                        for (int i = 0; i < itemLinks.size(); ++i) {
                            link = (ItemLink)itemLinks.get(i);
                            link.setSourceTeamContainerId(teamContainer.getId());
                            link.setSourceFeatureId(item.getId());
                        }
                        outboundDeps.addAll(itemLinks);
                    }
                    if (PropertyValidator.isValid((Collection)(itemLinks = this.itemLinkRepository.findByTargetUserStoryId(child.getId())))) {
                        for (int i = 0; i < itemLinks.size(); ++i) {
                            link = (ItemLink)itemLinks.get(i);
                            link.setTargetTeamContainerId(teamContainer.getId());
                            link.setTargetFeatureId(item.getId());
                        }
                        inboundDeps.addAll(itemLinks);
                    }
                    if (PropertyValidator.isValid((Collection)child.getTeamContainers())) {
                        child.setContainer(((TeamContainer)child.getTeamContainers().get(0)).getContainer());
                        child.setTeam(((TeamContainer)child.getTeamContainers().get(0)).getTeam());
                    }
                    child.setTeamContainers(citemTeamContainers);
                    child.putLastUpdatedValue(Item.Actions.teamContainer.name(), (Object)teamContainer);
                }
                if (PropertyValidator.isValid(outboundDeps)) {
                    this.itemLinkRepository.save(outboundDeps);
                }
                if (PropertyValidator.isValid(inboundDeps)) {
                    this.itemLinkRepository.save(inboundDeps);
                    responseJson.put("updatedLinks", inboundDeps);
                }
            }
            responseJson.put("teamContainer", teamContainer);
            if (!avoidParentLog) {
                item.putLastUpdatedValue(Item.Actions.teamContainer.name(), (Object)teamContainer);
            }
            if (oldContainer != null) {
                item.putLastUpdatedValue("oldContainer", (Object)oldContainer);
                if (!PropertyValidator.isValid((Object)item.getContainer())) {
                    item.setContainer(oldContainer);
                }
            }
            if (oldTeam != null) {
                item.putLastUpdatedValue("oldTeam", (Object)oldTeam);
                if (!PropertyValidator.isValid((Object)item.getTeam())) {
                    item.setTeam(oldTeam);
                }
            }
        }
        if (setSequence) {
            if (sequenceKey.equals("sequence")) {
                item.setSequence(Double.valueOf(sequence));
            } else {
                item.setBacklogSequence(Double.valueOf(sequence));
            }
        }
        if (parentId != null && item.getType().equals(Item.Type.UserStory.name())) {
            Item parent = new Item();
            parent.setId(parentId);
            item.setParent(parent);
        }
        String movingTfsId = null;
        String movingTfsProject = null;
        ArrayList<Item> tfsItemsToBeUpdated = new ArrayList<Item>();
        String[] oldPaths = new String[]{null, null};
        if (movingStory != null) {
            oldPaths = this.putAreaPathInItem(movingStory, sessionBoard, payload);
            movingTfsId = movingStory.getTfsId();
            movingTfsProject = movingStory.getTfsProject();
        }
        if (PropertyValidator.isValid((Collection)item.getTeamContainers())) {
            System.out.println("teamContainerBeforeSave : " + ((TeamContainer)item.getTeamContainers().get(0)).getId());
        }
        Session session = null;
        if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            session = ((SessionBoard)item.getSessionBoards().get(0)).getSession();
        }
        Date itemStartDate = null;
        Date itemEndDate = null;
        if (_meta.containsKey("startDateStr") && _meta.containsKey("endDateStr")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy");
                itemStartDate = sdf.parse((String)_meta.get("startDateStr"));
                itemEndDate = sdf.parse((String)_meta.get("endDateStr"));
                if (item.getType().equals(Item.Type.UserStory.name())) {
                    item.setStartDate(itemStartDate);
                    item.setEndDate(itemEndDate);
                }
            }
            catch (ParseException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        if (!item.getType().equals(Item.Type.Feature.name())) {
            if (session != null && item.storySprintChanged()) {
                item.applySprintDates(session, itemStartDate, itemEndDate);
            }
        } else if (childs != null && session != null) {
            _meta.put("event", "Child-Update-Event");
            _meta.put("syncId", UUID.randomUUID());
            _meta.put("type", Item.Type.UserStory.name());
            _meta.put("oldParentId", oldParenKendistId);
            _meta.put("newParentId", item.getId());
            _meta.put("parentChange", !item.getId().equals(oldParenKendistId));
            _meta.put("newIndex", "0");
            _meta.remove("childId");
            String storyMeta = gson.toJson((Object)_meta);
            for (Item child : childs) {
                if (!child.storySprintChanged() && (child.getContainer() == null || child.getContainer().equals((Object)oldContainer))) continue;
                child.applySprintDates(session, itemStartDate, itemEndDate);
                if (PropertyValidator.isValid((Object)child.getMetaMap())) continue;
                child.setMetaMap(storyMeta);
            }
        }
        int emptyCard = -1;
        if (PropertyValidator.isValid((Collection)(item = (Item)this.itemRepository.save((Object)item)).getTeamContainers())) {
            System.out.println("teamContainerAfterSave : " + ((TeamContainer)item.getTeamContainers().get(0)).getId());
        }
        if (!item.getType().equals(Item.Type.Feature.name())) {
            tfsItemsToBeUpdated.add(item);
            emptyCard = tfsItemsToBeUpdated.size() - 1;
        }
        if (childs != null) {
            if (childs.size() == 1) {
                Item child = (Item)childs.get(0);
                child = (Item)this.itemRepository.save((Object)child);
                responseJson.put("child", child);
                tfsItemsToBeUpdated.add(child);
                emptyCard = tfsItemsToBeUpdated.size() - 1;
            } else {
                responseJson.put("childs", childs);
                tfsItemsToBeUpdated.addAll(this.itemRepository.save(childs));
            }
        }
        responseJson.put("item", item);
        responseJson.put("newGroup", _meta.get("newGroup"));
        this.updateTFSOnDragDrop(item, sessionBoard, payload, tfsItemsToBeUpdated, parentId, oldParentId, movingTfsId, movingTfsProject, oldPaths[0], oldPaths[1], childPreviousAreaPathMap, changeParent, isChildTeamContainerUpdate);
        this.updateJiraOnDragDrop(item, childs, teamContainer, removedTC, "true".equals(parentChange) ? oldParenKendistId : null, jiraField, sessionBoard);
        if (emptyCard > -1 && ((Item)tfsItemsToBeUpdated.get(emptyCard)).getType().equals(Item.Type.UserStory.name())) {
            ArrayList<String> parents = new ArrayList<String>();
            if (((Item)tfsItemsToBeUpdated.get(emptyCard)).storySprintChanged() || ((Item)tfsItemsToBeUpdated.get(emptyCard)).storyTeamChanged()) {
                parents.add(((Item)tfsItemsToBeUpdated.get(emptyCard)).getParent().getId());
            }
            if (oldParenKendistId != null && !((Item)tfsItemsToBeUpdated.get(emptyCard)).getParent().getId().equals(oldParenKendistId)) {
                parents.add(oldParenKendistId);
            }
            responseJson.put("removedTcKeys", this.customRepositoryImpl.removeEmptyCards(parents, true));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void updateTFSOnDragDrop(Item item, SessionBoard sessionBoard, HashMap<String, Object> payload, List<Item> tfsItemsToBeUpdated, String parentId, String oldParentItemId, String itemTfsId, String itemTfsProject, String previousAreaPath, String previousProjectId, HashMap<String, String> childPreviousAreaPathMap, boolean changeParent, boolean isChildTeamContainerUpdate) {
        String tfsSprintChange = (String)payload.get("tfsSprintChange");
        String tfsSprintPath = (String)payload.get("tfsSprintPath");
        String tfsAreaPath = (String)payload.get("tfsAreaPath");
        String tfsProjectId = (String)payload.get("tfsProjectId");
        String tfsProject = (String)payload.get("tfsProject");
        String igonreAreaPath = (String)payload.get("igonreAreaPath");
        ArrayList tfsAreaPathsForTeam = (ArrayList)payload.get("tfsAreaPathsForTeam");
        Boolean includeSubAreaPaths = (Boolean)payload.get("includeSubAreaPaths");
        if (PropertyValidator.isValid((Object)tfsSprintChange) && tfsSprintChange.equals("true") || changeParent) {
            if (isChildTeamContainerUpdate) {
                // empty if block
            }
            if (PropertyValidator.isValid((Object)item.getTfsId()) && PropertyValidator.isValid((Object)tfsSprintChange) && tfsSprintChange.equals("true") && (!item.getType().equals("Feature") || PropertyValidator.isValid(tfsItemsToBeUpdated))) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
    }

    private String[] putAreaPathInItem(Item item, SessionBoard sessionBoard, HashMap<String, Object> payload) {
        String tfsSprintChange = (String)payload.get("tfsSprintChange");
        String tfsSprintPath = (String)payload.get("tfsSprintPath");
        String tfsAreaPath = (String)payload.get("tfsAreaPath");
        String tfsProjectId = (String)payload.get("tfsProjectId");
        String tfsProject = (String)payload.get("tfsProject");
        ArrayList tfsAreaPathsForTeam = (ArrayList)payload.get("tfsAreaPathsForTeam");
        Boolean includeSubAreaPaths = (Boolean)payload.get("includeSubAreaPaths");
        String previousAreaPath = item.getTfsAreaPath();
        String previousProjectId = item.getTfsProjectId();
        if (PropertyValidator.isValid((Object)tfsProjectId) && PropertyValidator.isValid((Object)tfsProject) && !Item.Type.Feature.toString().equals(item.getType())) {
            item.setTfsProjectId(tfsProjectId);
            item.setTfsProject(tfsProject);
            if (PropertyValidator.isValid((Object)tfsSprintChange) && tfsSprintChange.equals("true")) {
                if (tfsAreaPath != null && !tfsAreaPath.equals(previousAreaPath) && PropertyValidator.isValid((Object)tfsSprintPath)) {
                    String project = tfsSprintPath.substring(0, tfsSprintPath.indexOf("\\"));
                    if (!sessionBoard.getSession().getAreaPathDisabled().booleanValue()) {
                        if (PropertyValidator.isValid((Object)tfsAreaPath)) {
                            String _areaPath = null;
                            if (PropertyValidator.isValid((Collection)tfsAreaPathsForTeam)) {
                                _areaPath = tfsAreaPathsForTeam.stream().filter(ap -> ap.equals(previousAreaPath)).findAny().orElse(null);
                            }
                            if (includeSubAreaPaths != null && includeSubAreaPaths.booleanValue() && PropertyValidator.isValid((Object)previousAreaPath) && previousAreaPath.startsWith(tfsAreaPath + "\\")) {
                                _areaPath = previousAreaPath;
                            }
                            if (_areaPath == null) {
                                item.setTfsAreaPath(tfsAreaPath);
                            }
                        } else {
                            item.setTfsAreaPath(project);
                        }
                    } else if (previousProjectId != null && !previousProjectId.equals(tfsProjectId)) {
                        if (PropertyValidator.isValid((Object)tfsAreaPath)) {
                            item.setTfsAreaPath(tfsAreaPath);
                        } else {
                            item.setTfsAreaPath(project);
                        }
                    }
                }
                item.setTfsIterationPath(tfsSprintPath);
            }
        }
        return new String[]{previousAreaPath, previousProjectId};
    }

    @RequestMapping(value={"/getWorkItemUpdateWebhook"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getWorkItemUpdateWebhook(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String workItemId = (String)payload.get("workItemId");
            String workItemTitle = (String)payload.get("workItemTitle");
            String almAccId = (String)payload.get("almAccId");
            String boardId = (String)payload.get("boardId");
            if (PropertyValidator.isValid((Object)workItemId) && PropertyValidator.isValid((Object)almAccId) && PropertyValidator.isValid((Object)boardId)) {
                HashMap response = this.tfSservice.getWorkItemUpdateWebhook(workItemId, almAccId, boardId, workItemTitle);
                responseJson.put("response", response);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("almError", "Something went wrong..");
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/updatecategory"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateCategory(@RequestBody String payload) {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        Gson g = new Gson();
        8 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        List statuses = this.tfSservice.updateStatusCategory(reqbody);
        responseJson.put("statuses", statuses);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTfsProjectsWebhookStatusForWorkItems/{requestId}"}, method={RequestMethod.POST})
    @ResponseBody
    public HashMap<String, Object> getTfsProjectsWebhookStatusForWorkItems(@PathVariable(value="requestId") String requestId, @RequestBody String payload) {
        HashMap responseJson = new HashMap();
        Gson g = new Gson();
        9 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String tfsProjectIds = (String)reqbody.get("tfsProjectIds");
        String sessionId = (String)reqbody.get("sessionId");
        String metaMap = (String)reqbody.get("metaMap");
        String url = (String)reqbody.get("url");
        if (PropertyValidator.isValid((Object)tfsProjectIds) && PropertyValidator.isValid((Object)sessionId)) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
        return null;
    }

    @RequestMapping(value={"/createTfsProjectWebhookAgainstEventType"}, method={RequestMethod.POST})
    @ResponseBody
    public HashMap<String, Object> createTfsProjectWebhookAgainstEventType(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Gson g = new Gson();
            11 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
            String tfsProjectId = (String)reqbody.get("tfsProjectId");
            String sessionId = (String)reqbody.get("sessionId");
            String eventType = (String)reqbody.get("eventType");
            if (PropertyValidator.isValid((Object)tfsProjectId) && PropertyValidator.isValid((Object)sessionId) && PropertyValidator.isValid((Object)eventType)) {
                HashMap tfsProjectsUpdatedWorkItems = this.tfSservice.createTfsProjectWebhook(tfsProjectId, sessionId, eventType);
                responseJson.put("tfsProjectsUpdatedWorkItems", tfsProjectsUpdatedWorkItems);
            }
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("failure", "Something went wrong..");
        }
        return responseJson;
    }

    @RequestMapping(value={"/linktfsprojects"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSProjects(@RequestBody String payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap _responseJson = new HashMap();
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resyncTfsProjectIterations"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTfsProjectIterations(@RequestBody String payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap _responseJson = new HashMap();
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/canremovetfsproject/{sessionId}/{projectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> canUnlinkTFSProjects(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="projectId") String projectId) {
        HashMap<String, String> responseJson;
        TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(sessionId, projectId);
        List sbs = this.sessionBoardRepository.findBySessionId(sessionId);
        long itemsCount = 0L;
        if (PropertyValidator.isValid((Collection)sbs)) {
            for (SessionBoard sb : sbs) {
                itemsCount += this.itemRepository.countByTfsProjectIdAndSessionBoardsIdInAndArchive(tfsProject.getTfsId(), sb.getId(), false).longValue();
            }
        }
        if (itemsCount > 0L) {
            responseJson = new HashMap<String, String>();
            responseJson.put("status", "failure");
            responseJson.put("reason", "Item exist");
            responseJson.put("projectId", projectId);
            return new ResponseEntity(responseJson, HttpStatus.IM_USED);
        }
        responseJson = new HashMap();
        responseJson.put("status", "success");
        responseJson.put("projectId", projectId);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/removetfsprojectCreateBoard/{sessionId}/{projectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Object> unlinkTFSProjectsCreateBoard(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="projectId") String projectId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(sessionId, projectId);
            if (tfsProject != null) {
                this.workFlowRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
                this.workFlowItemTypeRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
                this.statusRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
                this.tfsProjectRepository.deleteBySessionIdAndTfsId(sessionId, tfsProject.getTfsId());
                responseJson.put("success", true);
                responseJson.put("projectId", projectId);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            responseJson.put("success", false);
            responseJson.put("reason", "Project doesn't exist");
            responseJson.put("projectId", projectId);
            return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/removetfsproject/{sessionId}/{sessionBoardId}/{projectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> unlinkTFSProjects(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId, @PathVariable(value="projectId") String projectId, @RequestBody String payload) {
        Gson g = new Gson();
        14 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        TFSProject tfsProject = this.tfsProjectRepository.findBySessionIdAndTfsId(sessionId, projectId);
        if (tfsProject != null) {
            int i;
            HashMap<String, String> responseJson;
            List sbs = this.sessionBoardRepository.findBySessionId(sessionId);
            long itemsCount = 0L;
            if (PropertyValidator.isValid((Collection)sbs)) {
                for (SessionBoard sb : sbs) {
                    itemsCount += this.itemRepository.countByTfsProjectIdAndSessionBoardsIdInAndArchiveAndType(tfsProject.getTfsId(), sb.getId(), false, Item.FEATURE).longValue();
                }
            }
            if (itemsCount > 0L) {
                responseJson = new HashMap<String, String>();
                responseJson.put("status", "failure");
                responseJson.put("reason", "Item exist");
                responseJson.put("projectId", projectId);
                return new ResponseEntity(responseJson, HttpStatus.IM_USED);
            }
            this.workFlowRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
            this.workFlowItemTypeRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
            this.statusRepository.deleteBySessionIdAndTfsProjectId(sessionId, tfsProject.getTfsId());
            this.itemRepository.deleteByTfsProjectIdAndSessionBoardsIdIn(tfsProject.getTfsId(), sessionBoardId);
            this.tfsProjectRepository.deleteBySessionIdAndTfsId(sessionId, tfsProject.getTfsId());
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            TFSAlmConfigurations almConfiguration = session.getTfsAlmConfigurations();
            if (PropertyValidator.isValid((Collection)almConfiguration.getFeatureFilters())) {
                for (i = 0; i < almConfiguration.getFeatureFilters().size(); ++i) {
                    TFSFilter tfsFilter = (TFSFilter)almConfiguration.getFeatureFilters().get(i);
                    if (!tfsFilter.getTfsProjectId().equals(tfsProject.getTfsId())) continue;
                    almConfiguration.getFeatureFilters().remove(i);
                    --i;
                }
            }
            if (PropertyValidator.isValid((Collection)almConfiguration.getTeamMappings())) {
                for (i = 0; i < almConfiguration.getTeamMappings().size(); ++i) {
                    TFSTeamMapping teamMapping = (TFSTeamMapping)almConfiguration.getTeamMappings().get(i);
                    if (!teamMapping.getTfsProjectTfsId().equals(tfsProject.getTfsId())) continue;
                    almConfiguration.getTeamMappings().remove(i);
                    --i;
                }
            }
            this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
            this.tfsFilterRepository.deleteByTfsProjectIdAndSessionId(tfsProject.getTfsId(), sessionId);
            SessionBoard sessionBoard = new SessionBoard();
            sessionBoard.setId(sessionBoardId);
            this.itemSyncMapperRepository.deleteBySessionBoardAndTfsProjectId(sessionBoard, tfsProject.getTfsId());
            JSONObject pushJson = new JSONObject();
            try {
                String metaMap = (String)reqbody.get("metaMap");
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                pushJson.put("projectId", (Object)projectId);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
            responseJson = new HashMap();
            responseJson.put("status", "success");
            responseJson.put("projectId", projectId);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        HashMap<String, String> responseJson = new HashMap<String, String>();
        responseJson.put("status", "failure");
        responseJson.put("reason", "Project does't exist");
        responseJson.put("projectId", projectId);
        return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/resynctfsprojects"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTFSProjects(@RequestBody String payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap _responseJson = new HashMap();
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveTfsProjectSettings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTfsProjectSettings(@RequestBody HashMap<String, Object> reqbody) {
        String pid = (String)reqbody.get("projectId");
        String itemEstimationField = (String)reqbody.get("itemEstimationField");
        String subItemEstimationField = (String)reqbody.get("subItemEstimationField");
        String itemDueDateField = (String)reqbody.get("itemDueDateField");
        String subItemDueDateField = (String)reqbody.get("subItemDueDateField");
        String wsjfAlmField = (String)reqbody.get("wsjfAlmField");
        String wsjfAlmFieldForUnplannedFeatures = (String)reqbody.get("wsjfAlmFieldForUnplannedFeatures");
        List selectedFields = (List)reqbody.get("selectedFields");
        String itemStartDateField = (String)reqbody.get("itemStartDateField");
        String itemEndDateField = (String)reqbody.get("itemEndDateField");
        String subItemStartDateField = (String)reqbody.get("subItemStartDateField");
        String subItemEndDateField = (String)reqbody.get("subItemEndDateField");
        TFSProject project = (TFSProject)this.tfsProjectRepository.findOne((Serializable)((Object)pid));
        if (PropertyValidator.isValid((Object)itemEstimationField)) {
            project.setItemEstimationField(itemEstimationField);
        }
        if (PropertyValidator.isValid((Object)subItemEstimationField)) {
            project.setSubItemEstimationField(subItemEstimationField);
        }
        if (PropertyValidator.isValid((Object)itemDueDateField)) {
            project.setItemDueDateField(itemDueDateField);
        }
        if (PropertyValidator.isValid((Object)subItemDueDateField)) {
            project.setSubItemDueDateField(subItemDueDateField);
        }
        if (PropertyValidator.isValid((Object)wsjfAlmField)) {
            project.setWsjfAlmField(wsjfAlmField);
        }
        if (PropertyValidator.isValid((Object)wsjfAlmFieldForUnplannedFeatures)) {
            project.setWsjfAlmFieldForUnplannedFeatures(wsjfAlmFieldForUnplannedFeatures);
        }
        if (PropertyValidator.isValid((Object)wsjfAlmField)) {
            project.setWsjfAlmField(wsjfAlmField);
        }
        if (PropertyValidator.isValid((Object)wsjfAlmFieldForUnplannedFeatures)) {
            project.setWsjfAlmFieldForUnplannedFeatures(wsjfAlmFieldForUnplannedFeatures);
        }
        if (selectedFields != null) {
            project.setSelectedFields(selectedFields);
        }
        if (PropertyValidator.isValid((Object)itemStartDateField)) {
            project.setItemStartDateField(itemStartDateField);
        }
        if (PropertyValidator.isValid((Object)itemEndDateField)) {
            project.setItemEndDateField(itemEndDateField);
        }
        if (PropertyValidator.isValid((Object)subItemStartDateField)) {
            project.setSubItemStartDateField(subItemStartDateField);
        }
        if (PropertyValidator.isValid((Object)subItemEndDateField)) {
            project.setSubItemEndDateField(subItemEndDateField);
        }
        TFSProject _project = (TFSProject)this.tfsProjectRepository.save((Object)project);
        return new ResponseEntity((Object)_project, HttpStatus.OK);
    }

    private HashMap<String, Object> updateDependencyStatusBasedOnItemStatus(Item item1, Item savedItem, SessionBoard sessionBoard) {
        boolean canReopen;
        String key;
        if (item1.getType().equals(Item.USER_STORY)) {
            key = sessionBoard.getSession().getSubItemLinkStatusDependentOn();
            canReopen = sessionBoard.getSession().getReOpenDependencyIfSubItemReOpen();
        } else {
            key = sessionBoard.getSession().getItemLinkStatusDependentOn();
            canReopen = sessionBoard.getSession().getReOpenDependencyIfItemReOpen();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (PropertyValidator.isValid((Object)key) && !key.equals("-1")) {
            boolean resolveDependencies = false;
            boolean openDependencies = false;
            List statuses = this.statusRepository.findByWorkFlow(sessionBoard.getSession().getDependencyWorkFlow());
            List kendisLinkTypes = this.itemLinkTypeRepository.findBySystem(Boolean.TRUE);
            Status openStatus = null;
            Status closeStatus = null;
            for (Status st : statuses) {
                if (openStatus == null && st.getCategory().equals("ToDo")) {
                    openStatus = st;
                }
                if (closeStatus != null || !st.getCategory().equals("Done")) continue;
                closeStatus = st;
            }
            if (PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && item1.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                resolveDependencies = true;
            }
            if (canReopen && PropertyValidator.isValid((Object)item1.getStatus()) && PropertyValidator.isValid((Object)item1.getStatus().getCategory()) && PropertyValidator.isValid((Object)savedItem.getStatus()) && PropertyValidator.isValid((Object)savedItem.getStatus().getCategory()) && savedItem.getStatus().getCategory().equals("Done") && !savedItem.getStatus().getCategory().equals(item1.getStatus().getCategory())) {
                openDependencies = true;
            }
            if (openDependencies || resolveDependencies) {
                boolean ignoreIfWrongItem;
                List itemLinks = new ArrayList();
                List itemJiraDependencies = new ArrayList();
                itemJiraDependencies = this.itemJiraDependencyRepository.findBySourceItemIdInOrTargetItemIdIn(item1.getId(), item1.getId());
                if (Item.USER_STORY.equals(savedItem.getType())) {
                    itemLinks = this.itemLinkRepository.findByTargetUserStoryIdOrSourceUserStoryId(savedItem.getId(), savedItem.getId());
                } else {
                    ArrayList tcIds = new ArrayList();
                    if (PropertyValidator.isValid((Collection)savedItem.getTeamContainers())) {
                        savedItem.getTeamContainers().forEach(tc -> {
                            if (PropertyValidator.isValid((Object)tc)) {
                                tcIds.add(tc.getId());
                            }
                        });
                    }
                    if (PropertyValidator.isValid(tcIds)) {
                        itemLinks.addAll(this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(tcIds, tcIds));
                    }
                }
                List<ItemLink> linksToBeUpdated = new ArrayList();
                ArrayList<ItemJiraDependency> itemJiraDependencyToBeUpdated = new ArrayList<ItemJiraDependency>();
                if (PropertyValidator.isValid(itemLinks)) {
                    for (ItemLink itemLink : itemLinks) {
                        boolean ignoreUpdateIfManualResolved = false;
                        ignoreIfWrongItem = true;
                        if (Item.FEATURE.equals(savedItem.getType())) {
                            if (key.equals(Session.DependencyStatusOption.Source.toString()) && PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId()) || key.equals(Session.DependencyStatusOption.Target.toString()) && PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) continue;
                            ignoreUpdateIfManualResolved = sessionBoard.getSession().getIgnoreUpdateIfManualResolvedForItem() != false && itemLink.getIsManuallyResolved() != false;
                        } else {
                            ignoreUpdateIfManualResolved = sessionBoard.getSession().getIgnoreUpdateIfManualResolvedForSubItem() != false && itemLink.getIsManuallyResolved() != false;
                        }
                        ignoreIfWrongItem = this.tfSservice.checkDependencyStatusUpdateOnItemStatusUpdate((Object)itemLink, item1.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                        if (ignoreUpdateIfManualResolved || ignoreIfWrongItem) continue;
                        if (resolveDependencies) {
                            itemLink.setStatus("Resolved");
                            itemLink.setWfStatus(closeStatus);
                            itemLink.setResolvedOn(new Date());
                            itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                            linksToBeUpdated.add(itemLink);
                            continue;
                        }
                        itemLink.setStatus("Open");
                        itemLink.setWfStatus(openStatus);
                        itemLink.setResolvedOn(null);
                        itemLink.setIsManuallyResolved(Boolean.valueOf(false));
                        linksToBeUpdated.add(itemLink);
                    }
                    linksToBeUpdated = this.itemLinkRepository.save(linksToBeUpdated);
                }
                if (PropertyValidator.isValid(itemJiraDependencies)) {
                    for (ItemJiraDependency jD : itemJiraDependencies) {
                        String linkDirection = "";
                        ignoreIfWrongItem = true;
                        ignoreIfWrongItem = this.tfSservice.checkDependencyStatusUpdateOnItemStatusUpdate((Object)jD, item1.getId(), kendisLinkTypes, key, sessionBoard.getSession());
                        if (ignoreIfWrongItem) continue;
                        if (resolveDependencies) {
                            jD.setWfStatus(closeStatus);
                        } else {
                            jD.setWfStatus(openStatus);
                        }
                        itemJiraDependencyToBeUpdated.add(jD);
                    }
                    this.itemJiraDependencyRepository.save(itemJiraDependencyToBeUpdated);
                }
                if (PropertyValidator.isValid(linksToBeUpdated)) {
                    result.put("itemLinks", linksToBeUpdated);
                }
                if (PropertyValidator.isValid(itemJiraDependencyToBeUpdated)) {
                    result.put("itemJiraDependencies", itemJiraDependencies);
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/saveItemScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveItemScore(@RequestBody String payload) {
        Double score = null;
        String sessionBoardId = null;
        ArrayList sessionBoardMap = new ArrayList();
        Gson gson = new Gson();
        HashMap<String, Item> responseJson = new HashMap<String, Item>();
        try {
            16 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(payload, T.getType());
            String itemId = (String)reqbody.get("id");
            score = (Double)reqbody.get("score");
            sessionBoardMap = (ArrayList)reqbody.get("sessionBoards");
            sessionBoardId = (String)((Map)sessionBoardMap.get(0)).get("id");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            Item item = this.itemRepository.findById(itemId);
            AlmAccount almAccount = null;
            if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
                almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
            }
            if (PropertyValidator.isValid(almAccount) && PropertyValidator.isValid((Object)item.getTfsProject()) && PropertyValidator.isValid((Object)item.getTfsId())) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
            responseJson.put("item", item);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(path={"/update/item"})
    @ResponseBody
    public ResponseEntity<Object> updateItem(@RequestBody Item oldItem) {
        Gson gson = new Gson();
        try {
            Item item1 = (Item)this.itemRepository.findOne((Serializable)((Object)oldItem.getId()));
            if (PropertyValidator.isValid((Object)item1)) {
                if (PropertyValidator.isValid((Object)oldItem.getMetaMap())) {
                    18 T = new /* Unavailable Anonymous Inner Class!! */;
                    HashMap meta = (HashMap)gson.fromJson(oldItem.getMetaMap(), T.getType());
                    meta.put("boardType", "tfs");
                    meta.put("type", item1.getType());
                    item1.setMetaMap(gson.toJson((Object)meta));
                }
                if (PropertyValidator.isValid((Collection)oldItem.getTeamContainers())) {
                    Container container;
                    item1.setTeamContainers(oldItem.getTeamContainers());
                    if (PropertyValidator.isValid((Collection)item1.getTeamContainers()) && PropertyValidator.isValid((Object)((TeamContainer)item1.getTeamContainers().get(0)).getContainer()) && PropertyValidator.isValid((Object)(container = (Container)this.containerRepository.findOne((Serializable)((Object)((TeamContainer)item1.getTeamContainers().get(0)).getContainer().getId()))))) {
                        ((TeamContainer)item1.getTeamContainers().get(0)).setContainer(container);
                    }
                }
                if (PropertyValidator.isValid((Object)oldItem.getStartDate())) {
                    item1.setStartDate(oldItem.getStartDate());
                }
                if (PropertyValidator.isValid((Object)oldItem.getEndDate())) {
                    item1.setEndDate(oldItem.getEndDate());
                }
                ResponseEntity itema1 = this.saveItem(item1);
                return itema1;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Item json : " + gson.toJson((Object)oldItem));
            LOGGER.error("Inside : count not upadate item --> " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    @RequestMapping(value={"/saveItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveItem(@RequestBody Item item) {
        boolean editMode = false;
        boolean isNewItem = true;
        if (PropertyValidator.isValid((Object)item.getId())) {
            editMode = true;
            isNewItem = false;
        }
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)((SessionBoard)item.getSessionBoards().get(0)).getId()));
        AlmAccount almAccount = null;
        if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations())) {
            almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoards.add(sessionBoard);
        if (PropertyValidator.isValid((Object)almAccount) && !editMode && PropertyValidator.isValid((Object)item.getTfsProject())) {
            item.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
        }
        item.setSessionBoards(sessionBoards);
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid((Object)item.getId())) {
            Item dbItem = this.itemRepository.findById(item.getId());
            item.setKendisId(dbItem.getKendisId());
            if (dbItem.getKendisId() != null) {
                item.setKendisKey(dbItem.getKendisKey());
            }
            item.setSolutionSourceItemLinks(dbItem.getSolutionSourceItemLinks());
            item.setSolutionTargetItemLinks(dbItem.getSolutionTargetItemLinks());
            HashMap updatedLinksMap = this.updateDependencyStatusBasedOnItemStatus(item, dbItem, sessionBoard);
            List itemsLinks = (List)updatedLinksMap.get("itemLinks");
            List itemJiraDependencies = (List)updatedLinksMap.get("itemJiraDependencies");
            if (PropertyValidator.isValid((Collection)itemsLinks) || PropertyValidator.isValid((Collection)itemJiraDependencies)) {
                String metaData = item.getMetaMap();
                if (PropertyValidator.isValid((Object)metaData)) {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        Object linksJson;
                        if (PropertyValidator.isValid((Collection)itemsLinks) && (linksJson = mapper.writeValueAsString((Object)itemsLinks)) != null) {
                            metaData = metaData.substring(0, metaData.length() - 1) + ",\"updatedLinks\":" + (String)linksJson + "}";
                        }
                        if (PropertyValidator.isValid((Collection)itemJiraDependencies)) {
                            for (ItemJiraDependency jD : itemJiraDependencies) {
                                String[] type;
                                List<String> typeList;
                                if (PropertyValidator.isValid((Object)jD.getJiraDependencyId()) || !PropertyValidator.isValid((Object)jD.getSourceItemId()) || !PropertyValidator.isValid((Object)jD.getTargetItemId()) || (typeList = Arrays.asList(type = jD.getTfsLinkType().split("-"))).size() <= 1) continue;
                                if (typeList.get(1).equals("Reverse")) {
                                    jD.setJiraDependencyId(jD.getTargetTFSItem().getTfsId() + "-" + jD.getSourceTFSItem().getTfsId());
                                    continue;
                                }
                                jD.setJiraDependencyId(jD.getSourceTFSItem().getTfsId() + "-" + jD.getTargetTFSItem().getTfsId());
                            }
                            linksJson = mapper.writeValueAsString((Object)itemJiraDependencies);
                            if (linksJson != null) {
                                metaData = metaData.substring(0, metaData.length() - 1) + ",\"updatedItemJiraDependencies\":" + (String)linksJson + "}";
                            }
                        }
                        item.setMetaMap(metaData);
                    }
                    catch (Exception e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
                responseJson.put("updatedLinks", itemsLinks);
                responseJson.put("updatedItemJiraDependencies", itemJiraDependencies);
            }
        }
        if (Item.Type.UserStory.name().equals(item.getType()) && item.getStartDate() == null && item.getEndDate() == null) {
            item.applySprintDates(sessionBoard.getSession(), null, null);
        }
        boolean sendToAlm = false;
        if (item.getSendToAlm() != null) {
            sendToAlm = item.getSendToAlm();
        }
        if (PropertyValidator.isValid((Object)almAccount) && sendToAlm && PropertyValidator.isValid((Object)item.getTfsProject())) {
            item.setFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
        }
        this.savedItem = (Item)this.itemRepository.save((Object)item);
        this.savedItem.setSessionBoards(sessionBoards);
        if (Item.Type.UserStory.name().equals(this.savedItem.getType())) {
            Item parentItem = null;
            if (PropertyValidator.isValid((Object)this.savedItem.getParent()) && PropertyValidator.isValid((Object)this.savedItem.getParent().getId())) {
                parentItem = (Item)this.itemRepository.findOne((Serializable)((Object)this.savedItem.getParent().getId()));
            }
            if (PropertyValidator.isValid((Object)almAccount) && PropertyValidator.isValid((Collection)this.savedItem.getTfsLinkTypes()) && PropertyValidator.isValid(parentItem) && PropertyValidator.isValid((Collection)parentItem.getTfsLinkTypes()) && parentItem.getTfsLinkTypes().indexOf(this.savedItem.getTfsLinkTypes().get(0)) == -1) {
                parentItem.getTfsLinkTypes().add(this.savedItem.getTfsLinkTypes().get(0));
                this.savedItem.setParent((Item)this.itemRepository.save((Object)parentItem));
            }
        }
        boolean sendCallToAlm = false;
        boolean newToAlm = false;
        if (isNewItem) {
            newToAlm = true;
            sendCallToAlm = true;
        } else if (PropertyValidator.isValid((Object)item.getTfsId())) {
            sendCallToAlm = true;
        } else if (sendToAlm) {
            newToAlm = true;
            sendCallToAlm = true;
        }
        if (PropertyValidator.isValid((Object)almAccount) && PropertyValidator.isValid((Object)item.getTfsProject()) && sendCallToAlm) {
            boolean finalSendToAlm = sendToAlm;
            if (!newToAlm) {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            } else {
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        this.userService.setOnboardingMeta("Get_Features_from_Jira", true);
        responseJson.put("item", item);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private boolean skipTimeSeriesEntryForAddExistingItem(Item item, AlmAccount almAccount) {
        if (!PropertyValidator.isValid((Object)item.getId())) {
            return PropertyValidator.isValid((Object)almAccount) && PropertyValidator.isValid((Object)item.getTfsProject());
        }
        return false;
    }

    @RequestMapping(value={"/deleteItem"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteItem(HttpServletRequest request, @RequestBody Item itemToRemove) {
        String metaMap = itemToRemove.getMetaMap();
        if (PropertyValidator.isValid((Object)itemToRemove.getType()) && itemToRemove.getType().equals("Feature")) {
            this.customRepository.updateAlmErrorFlag(itemToRemove.getId(), false);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            SessionBoard board = this.sessionBoardRepository.findById(((SessionBoard)itemToRemove.getSessionBoards().get(0)).getId());
            itemToRemove.getSessionBoards().set(0, board);
            this.customRepository.setBulkArchiveUserStoriesByParent(itemToRemove, true);
        } else {
            itemToRemove = this.itemRepository.findById(itemToRemove.getId());
            itemToRemove.setErrorInAlmSync(Boolean.FALSE);
            this.almErrorRepository.deleteByItemId(itemToRemove.getId());
            this.item = itemToRemove;
            this.item.setMetaMap(metaMap);
            if (PropertyValidator.isValid((Object)itemToRemove.getTfsId())) {
                AlmAccount almAccount = ((SessionBoard)itemToRemove.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount();
                String itemTFSId = itemToRemove.getTfsId();
                String itemParentTFSId = itemToRemove.getParent().getTfsId();
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            } else {
                this.updateJiraOnUnlink(itemToRemove);
            }
        }
        itemToRemove.setMetaMap(metaMap);
        itemToRemove.setArchive(true);
        if (PropertyValidator.isValid((Object)itemToRemove.getKendisId())) {
            this.releaseTrainService.unlinkBacklogItemFromPi(itemToRemove, "delete".equals(request.getParameter("action")));
        }
        this.itemRepository.save((Object)itemToRemove);
        if (!itemToRemove.getType().equals("Feature") && PropertyValidator.isValid((Object)itemToRemove.getParent().getId())) {
            List childItems = this.itemRepository.findByParentId(itemToRemove.getParent().getId());
            Double totalEstimate = 0.0;
            for (Item childItem : childItems) {
                totalEstimate = totalEstimate + childItem.getStoryPoints();
            }
            this.customRepository.updateItemStoryPoints(itemToRemove.getParent().getId(), totalEstimate);
        }
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", true);
        responseJson.put("item", (Boolean)itemToRemove);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/copyBoardMeta/{sessionBoardId}"})
    @ResponseBody
    public ResponseEntity<Object> getCopyBoardMeta(@PathVariable String sessionBoardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List tfsProjects = new ArrayList();
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
            responseJson.put("sessionBoard", sessionBoard);
            tfsProjects = this.tfsProjectRepository.findBySessionId(sessionBoard.getSession().getId());
            if (PropertyValidator.isValid(tfsProjects)) {
                for (int i = 0; i < tfsProjects.size(); ++i) {
                    TFSProject project = (TFSProject)tfsProjects.get(i);
                    List itemTypes = this.workFlowItemTypeRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                    project.setItemTypes(itemTypes);
                    WorkFlow workflow = this.workFlowRepository.findBySessionIdAndTfsProjectId(sessionBoard.getSession().getId(), project.getTfsId());
                    project.setWorkFlow(workflow);
                    List statuses = this.statusRepository.findByWorkFlow(workflow);
                    workflow.setStatuses(statuses);
                }
            }
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User user = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            HashSet workSpaces = new HashSet();
            HashSet<WorkSpace> activeWorkSpaces = new HashSet<WorkSpace>();
            ArrayList<WorkSpaceAccessRole> workSpaceAccessRoles = new ArrayList<WorkSpaceAccessRole>();
            if (PropertyValidator.isValid((Object)user) && (user.getIsAdmin().booleanValue() || user.getIsSuperAdmin().booleanValue())) {
                workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpacesByIsModuleIsFalseOrIsModuleIsNull());
                for (WorkSpace workSpace : workSpaces) {
                    Boolean showWorkspace = false;
                    if (PropertyValidator.isValid((Object)workSpace.getType()) && PropertyValidator.isValid((Collection)workSpace.getModules())) {
                        for (HashMap map : workSpace.getModules()) {
                            String id = (String)map.get("id");
                            if (!id.equalsIgnoreCase(EnumRTModules.ART_BOARDS.getCode())) continue;
                            showWorkspace = true;
                        }
                    } else {
                        showWorkspace = true;
                    }
                    if (!showWorkspace.booleanValue()) continue;
                    WorkSpaceAccessRole accessRole = new WorkSpaceAccessRole();
                    accessRole.setWorkSpace(workSpace);
                    accessRole.setUser(new User(user.getId()));
                    workSpaceAccessRoles.add(accessRole);
                    activeWorkSpaces.add(workSpace);
                }
            } else {
                List accessRoles;
                Query query = new Query();
                List groupIds = user.getGroups().stream().filter(s -> ObjectId.isValid((String)s)).map(ObjectId::new).collect(Collectors.toList());
                String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"user.$id").is((Object)new ObjectId(user.getId())), Criteria.where((String)"group.$id").in(groupIds)});
                query.addCriteria((CriteriaDefinition)criteria);
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                try (DBCursor dbCursorPrefix = null;){
                    dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("workSpaceAccessRole").find(query.getQueryObject());
                    List id = dbCursorPrefix.toArray();
                }
                if (PropertyValidator.isValid((Object)dbCursorPrefix) && PropertyValidator.isValid((Collection)(accessRoles = dbCursorPrefix.toArray()))) {
                    ArrayList<String> workSpaceIds = new ArrayList<String>();
                    for (DBObject workSpaceAccessRole : accessRoles) {
                        DBRef workSpaceRef = (DBRef)workSpaceAccessRole.get("workSpace");
                        if (!PropertyValidator.isValid((Object)workSpaceRef) || !PropertyValidator.isValid((Object)workSpaceRef.getId())) continue;
                        workSpaceIds.add(String.valueOf(workSpaceRef.getId()));
                    }
                    if (!workSpaceIds.isEmpty() && PropertyValidator.isValid((Collection)(workSpaces = Sets.newHashSet((Iterable)this.workSpaceRepository.findWorkSpaceByIdIn(workSpaceIds))))) {
                        for (WorkSpace workSpace : workSpaces) {
                            Boolean showWorkspace = false;
                            if (PropertyValidator.isValid((Object)workSpace.getType()) && PropertyValidator.isValid((Collection)workSpace.getModules())) {
                                for (HashMap map : workSpace.getModules()) {
                                    String id = (String)map.get("id");
                                    if (!EnumRTModules.ART_BOARDS.getCode().equalsIgnoreCase(id)) continue;
                                    showWorkspace = true;
                                    break;
                                }
                            } else {
                                showWorkspace = true;
                            }
                            if (!showWorkspace.booleanValue()) continue;
                            activeWorkSpaces.add(workSpace);
                        }
                    }
                }
            }
            responseJson.put("workSpaces", activeWorkSpaces);
        }
        responseJson.put("tfsProjects", tfsProjects);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsnestedqueries"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSNestedQueries(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String almId = (String)payload.get("almId");
            String projectId = (String)payload.get("pid");
            String url = (String)payload.get("url");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            responseJson.put("queries", this.tfsUtils.getNestedQueries(url.substring(url.indexOf(projectId)), almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsqueries/{almId}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueries(@PathVariable String almId, @PathVariable String pid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            responseJson.put("success", true);
            responseJson.put("queries", this.tfsUtils.getProjectQueries(pid, "all", "2", almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsqueriesWithFilter/{almId}/{pid}/{filter}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueriesWithFilter(@PathVariable String almId, @PathVariable String pid, @PathVariable String filter) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            responseJson.put("success", true);
            responseJson.put("queries", this.tfsUtils.getProjectQueriesWithFilter(pid, filter, "all", "2", almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateTfsFilter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateTfsFilter(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
            String filterId = (String)requestBody.get("id");
            String tfsId = (String)requestBody.get("tfsId");
            String name = (String)requestBody.get("name");
            Boolean isWiql = (Boolean)requestBody.get("isWiql");
            String htmlUrl = (String)requestBody.get("htmlUrl");
            String queryJSON = (String)requestBody.get("queryJSON");
            TFSFilter saveTfsFilter = (TFSFilter)this.tfsFilterRepository.findOne((Serializable)((Object)filterId));
            if (PropertyValidator.isValid((Object)saveTfsFilter)) {
                if (PropertyValidator.isValid((Object)saveTfsFilter.getTfsId())) {
                    if (saveTfsFilter.getOldTfsIds() == null) {
                        saveTfsFilter.setOldTfsIds(new ArrayList());
                    }
                    if (!saveTfsFilter.getOldTfsIds().contains(saveTfsFilter.getTfsId())) {
                        saveTfsFilter.getOldTfsIds().add(saveTfsFilter.getTfsId());
                    }
                }
                if (requestBody.containsKey("wiqlParams") && Boolean.TRUE.equals(requestBody.get("wiqlParams"))) {
                    String workItemType = (String)requestBody.get("workItemType");
                    String iterationPath = (String)requestBody.get("iterationPath");
                    String iterationPathId = (String)requestBody.get("iterationPathId");
                    String areaPath = (String)requestBody.get("areaPath");
                    String areaPathId = (String)requestBody.get("areaPathId");
                    queryJSON = AlmUtils.createWIQLQuery(requestBody);
                    Object _state = requestBody.get("state");
                    String iterationPathOp = (String)requestBody.get("iterationPathOp");
                    String areaPathOp = (String)requestBody.get("areaPathOp");
                    String stateOp = (String)requestBody.get("stateOp");
                    isWiql = Boolean.TRUE;
                    saveTfsFilter.setMoreInfo(new HashMap());
                    saveTfsFilter.getMoreInfo().put("iterationPathOp", iterationPathOp);
                    saveTfsFilter.getMoreInfo().put("areaPathOp", areaPathOp);
                    saveTfsFilter.getMoreInfo().put("stateOp", stateOp);
                    saveTfsFilter.getMoreInfo().put("itemType", workItemType);
                    saveTfsFilter.getMoreInfo().put("areaPath", areaPath);
                    saveTfsFilter.getMoreInfo().put("iterationPath", iterationPath);
                    saveTfsFilter.getMoreInfo().put("iterationPathId", iterationPathId);
                    saveTfsFilter.getMoreInfo().put("areaPathId", areaPathId);
                    saveTfsFilter.getMoreInfo().put("state", _state);
                }
                saveTfsFilter.setTfsId(tfsId);
                saveTfsFilter.setName(name);
                saveTfsFilter.setIsWiql(isWiql);
                saveTfsFilter.setHtmlUrl(htmlUrl);
                saveTfsFilter.setQueryJSON(queryJSON);
                saveTfsFilter = (TFSFilter)this.tfsFilterRepository.save((Object)saveTfsFilter);
                responseJson.put("success", true);
                responseJson.put("filter", (Boolean)saveTfsFilter);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error updating TFS filter: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            AlmError almerr = new AlmError();
            almerr.setAlmErrorMessage("An unexpected error occurred while updating the TFS filter.");
            almerr.setHttpErrorCode(Integer.valueOf(500));
            return new ResponseEntity((Object)almerr, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/createItemInTFS/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> createDummyItemInTFS(@PathVariable String pid) {
        HashMap responseJson = new HashMap();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateItemInTFS/{itemId}"})
    @ResponseBody
    public ResponseEntity<Object> updateItemInTFS(@PathVariable String itemId) {
        HashMap responseJson = new HashMap();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/preview-sprint"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getWiqlLDataForSprint(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        String almId = (String)payload.get("almAccId");
        String qid = (String)payload.get("wiql");
        String syncId = (String)payload.get("syncId");
        String piSessionId = (String)payload.get("piSessionId");
        String max = (String)payload.get("max");
        Gson gson = new Gson();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(qid, almAccount, false);
            if (PropertyValidator.isValid((Object)tfsResponse)) {
                responseJson.put("data", tfsResponse.getContent());
                JSONObject responseObj = new JSONObject(tfsResponse.getContent());
                ArrayList<String> itemIds = new ArrayList<String>();
                JSONArray workItemsArray = responseObj.getJSONArray("workItems");
                for (int i = 0; i < workItemsArray.length(); ++i) {
                    JSONObject wiObject = workItemsArray.getJSONObject(i);
                    String itemId = wiObject.getString("id");
                    itemIds.add(itemId);
                    if (max != null) break;
                }
                List subSetIds = Lists.partition(new ArrayList(itemIds), (int)100);
                for (List subItemIds : subSetIds) {
                    String idsItemStr = String.join((CharSequence)",", subItemIds);
                    KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)this.tfsUtils.getItems("1", idsItemStr, almAccount), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
                }
            } else {
                responseJson.put("data", "{}");
            }
            AuditLog auditLogObject = new AuditLog(piSessionId, "SPRINT_COMPARED");
            this.auditLogRepository.save((Object)auditLogObject);
        }
        catch (Exception e) {
            HashMap<String, String> exp = new HashMap<String, String>();
            exp.put("error", com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            LOGGER.error("Exception while Wiql ::   : " + exp.get("error"));
            KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)gson.toJson(exp), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
        }
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        done.put("preview_done", true);
        KendisUtils.pushProgressUpdates((String)"JQL", (String)syncId, (Object)gson.toJson(done), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
        return new ResponseEntity(null, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsquery"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueryResults(@RequestBody HashMap<String, Object> payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/validateTfsQueryForCopyBoard"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> validateTfsQueryForCopyBoard(@RequestBody HashMap<String, Object> payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    private void sendSyncResponse(String syncId, HashMap<String, Object> responseJson) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String content = mapper.writeValueAsString(responseJson);
            this.onResyncComplete(syncId, "", content, "FetchTfsQuery");
        }
        catch (JsonProcessingException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/fetchTFSItemsScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSItemsScore(@RequestBody String payload) {
        String itemIds = null;
        String almAccountId = null;
        String field = null;
        String wsjfFieldForUnplannedFeatures = null;
        String syncId = null;
        Gson gson = new Gson();
        try {
            24 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)gson.fromJson(payload, T.getType());
            itemIds = (String)reqbody.get("ids");
            almAccountId = (String)reqbody.get("almAccId");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            field = (String)reqbody.get("field");
            wsjfFieldForUnplannedFeatures = (String)reqbody.get("wsjfFieldForUnplannedFeatures");
            syncId = (String)reqbody.get("syncId");
            String json = null;
            json = PropertyValidator.isValid((Object)wsjfFieldForUnplannedFeatures) ? this.tfsUtils.getItems("1", itemIds, "fields=" + field + "," + wsjfFieldForUnplannedFeatures, almAccount) : this.tfsUtils.getItems("1", itemIds, "fields=" + field, almAccount);
            KendisUtils.pushProgressUpdates((String)"WSJF_DATA", (String)syncId, (Object)json, (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        catch (Exception e) {
            HashMap<String, Exception> exp = new HashMap<String, Exception>();
            exp.put("error", e);
            LOGGER.error("Exception ::   : " + exp.get("error"));
            KendisUtils.pushProgressUpdates((String)"WSJF_DATA", syncId, (Object)gson.toJson(exp), (PushResponseRepository)this.pushResponseRepository, (boolean)true);
        }
        HashMap<String, Boolean> done = new HashMap<String, Boolean>();
        done.put("preview_done", true);
        KendisUtils.pushProgressUpdates((String)"WSJF_DATA", (String)syncId, (Object)gson.toJson(done), (PushResponseRepository)this.pushResponseRepository, (boolean)false);
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/updateTFSItemsScore"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateTFSItemsScore(@RequestBody String payload) {
        Gson gson = new Gson();
        25 T = new /* Unavailable Anonymous Inner Class!! */;
        List requestMap = (List)gson.fromJson(payload, T.getType());
        ArrayList<String> idsList = new ArrayList<String>();
        HashMap<String, Double> itemsMapByScore = new HashMap<String, Double>();
        for (int i = 0; i < requestMap.size(); ++i) {
            String id = (String)((HashMap)requestMap.get(i)).get("itemID");
            Double score = (Double)((HashMap)requestMap.get(i)).get("score");
            idsList.add(id);
            itemsMapByScore.put(id, score);
        }
        ArrayList savedItems = (ArrayList)this.itemRepository.findByTfsIdIn(idsList);
        savedItems.forEach(item -> item.setAlmScoreField((Double)itemsMapByScore.get(item.getTfsId())));
        this.itemRepository.save((Iterable)savedItems);
        HashMap<String, HashMap<String, Double>> responseJson = new HashMap<String, HashMap<String, Double>>();
        responseJson.put("items", itemsMapByScore);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSQueryResults1(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String itemIds = null;
        String almAccountId = null;
        try {
            Gson g = new Gson();
            26 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
            itemIds = (String)reqbody.get("itemIds");
            almAccountId = (String)reqbody.get("almAccountId");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("items", this.tfsUtils.getItems("1", itemIds, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfssearch"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTFSSearchResults(@RequestBody String payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            String almAccountId = null;
            Gson g = new Gson();
            27 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
            String tfsIds = (String)reqbody.get("ids");
            almAccountId = (String)reqbody.get("almAccountId");
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("success", true);
            responseJson.put("tfsitems", this.tfsUtils.getItems("1", tfsIds, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTfsProjectWorkItemsJson"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTfsProjectWorkItemsJson(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        HashMap projectsMap = new HashMap();
        try {
            String almId = (String)reqbody.get("almAccId");
            String qid = (String)reqbody.get("wiql");
            Gson gson = new Gson();
            ArrayList<String> tfsIds = new ArrayList<String>();
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
            TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(qid, almAccount, false);
            String responseStr = "";
            if (PropertyValidator.isValid((Object)tfsResponse)) {
                responseStr = tfsResponse.getContent();
                JSONObject responseObj = new JSONObject(responseStr);
                String queryType = responseObj.getString("queryType");
                if (PropertyValidator.isValid((Object)queryType) && queryType.equals("flat")) {
                    JSONArray workItemsArray = responseObj.getJSONArray("workItems");
                    for (int i = 0; i < workItemsArray.length(); ++i) {
                        JSONObject wiObject = workItemsArray.getJSONObject(i);
                        String itemId = wiObject.getString("id");
                        tfsIds.add(itemId);
                    }
                    responseJson.put("workItemsArray", gson.toJson(responseObj.get("workItems")));
                }
                String idsItemStr = String.join((CharSequence)",", tfsIds);
                responseJson.put("items", this.tfsUtils.getItems("1", idsItemStr, almAccount));
            } else {
                responseJson.put("status", "failure");
                responseJson.put("reason", "Invalid WIQL");
            }
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("status", "failure");
            responseJson.put("reason", "Invalid response from server");
            responseJson.put("error", (String)vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchTFSFilterItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSFilterItems(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String almAccountId = null;
        String filterStr = (String)reqbody.get("filter");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String shouldSave = (String)reqbody.get("shouldSave");
        List loadedProjects = (List)reqbody.get("loadProjects");
        String metaMap = (String)reqbody.get("metaMap");
        ObjectMapper mapper = new ObjectMapper();
        TFSFilter filter = null;
        try {
            filter = (TFSFilter)mapper.readValue(filterStr, TFSFilter.class);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<String> tfsIds = new ArrayList<String>();
        almAccountId = (String)reqbody.get("almAccountId");
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        if (PropertyValidator.isValid((Object)shouldSave) && PropertyValidator.isValid((Object)filter)) {
            filter.setFilterFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
            filter = (TFSFilter)this.tfsFilterRepository.save((Object)filter);
        }
        if (PropertyValidator.isValid((Object)filter.getFilterFetchedBy())) {
            AlmAccount taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount);
            if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                almAccount = taggedAlmAccount;
            }
        } else {
            almAccount.setIsTaggedUser(Boolean.valueOf(true));
        }
        Boolean success = false;
        try {
            if (filter != null) {
                String tfsItemIdsStr;
                if (PropertyValidator.isValid((Object)filter.getIsWiql()) && filter.getIsWiql() == Boolean.TRUE) {
                    String queryStr = "{query:\"" + filter.getQueryJSON() + "\"}";
                    TFSResponse tfsResponse = this.tfsUtils.getWorkItemsByTFSQueryString(queryStr, almAccount, false);
                    tfsItemIdsStr = tfsResponse.getContent();
                } else {
                    tfsItemIdsStr = this.tfsUtils.getWorkItemsByTFSQueryId(filter.getTfsProjectId(), filter.getTfsId(), almAccount);
                }
                try {
                    JSONObject jsonObject = new JSONObject(tfsItemIdsStr);
                    String queryType = jsonObject.getString("queryType");
                    ArrayList<String> relations = new ArrayList<String>();
                    if (queryType.equals("flat")) {
                        JSONArray workItemsArray = jsonObject.getJSONArray("workItems");
                        for (int i = 0; i < workItemsArray.length(); ++i) {
                            JSONObject wiObject = workItemsArray.getJSONObject(i);
                            String itemId = wiObject.getString("id");
                            tfsIds.add(itemId);
                        }
                    } else {
                        JSONObject responseObject = new JSONObject();
                        JSONArray workItemsArray = new JSONArray();
                        JSONArray workItemsRelationsArray = jsonObject.getJSONArray("workItemRelations");
                        ArrayList<String> subItemIds = new ArrayList<String>();
                        for (int i = 0; i < workItemsRelationsArray.length(); ++i) {
                            JSONObject wirObject = workItemsRelationsArray.getJSONObject(i);
                            Object sourceObject = null;
                            JSONObject targetObject = null;
                            String relation = null;
                            if (wirObject.isNull("source") && !wirObject.isNull("target")) {
                                targetObject = wirObject.getJSONObject("target");
                            }
                            if (!wirObject.isNull("rel")) {
                                relation = wirObject.getString("rel");
                            }
                            if (PropertyValidator.isValid(targetObject)) {
                                JSONObject workItemObject = new JSONObject();
                                String itemId = targetObject.getString("id");
                                String itemURL = targetObject.getString("url");
                                tfsIds.add(itemId);
                                workItemObject.put("id", (Object)itemId);
                                workItemObject.put("url", (Object)itemURL);
                                workItemsArray.put((Object)workItemObject);
                            }
                            if (PropertyValidator.isValid((Object)targetObject)) {
                                String itemId = targetObject.getString("id");
                                subItemIds.add(itemId);
                            }
                            if (!PropertyValidator.isValid((Object)relation)) continue;
                            relations.add(relation);
                        }
                    }
                    String tfsProjectStr = this.tfsUtils.getTFSProjectsByPage(almAccount);
                    HashMap<String, String> projectsMap = new HashMap<String, String>();
                    if (PropertyValidator.isValid((Object)tfsProjectStr)) {
                        JSONObject dataObjects = new JSONObject(tfsProjectStr);
                        String count = dataObjects.getString("count");
                        JSONArray projectsArray = dataObjects.getJSONArray("value");
                        for (int i = 0; i < projectsArray.length(); ++i) {
                            JSONObject projectObject = projectsArray.getJSONObject(i);
                            String projectId = projectObject.getString("id");
                            String projectName = projectObject.getString("name");
                            projectsMap.put(projectName, projectId);
                        }
                    }
                    List subSetIds = Lists.partition(new ArrayList(tfsIds), (int)100);
                    HashMap projectsMapResponse = new HashMap();
                    for (List subItemIds : subSetIds) {
                        String idsItemStr = String.join((CharSequence)",", subItemIds);
                        String itemsStr = this.tfsUtils.getItems("1", idsItemStr, almAccount);
                        try {
                            JSONObject dataObjects = new JSONObject(itemsStr);
                            String count = dataObjects.getString("count");
                            JSONArray itemsArray = dataObjects.getJSONArray("value");
                            for (int i = 0; i < itemsArray.length(); ++i) {
                                JSONObject itemObject = itemsArray.getJSONObject(i);
                                JSONObject tfsFields = itemObject.getJSONObject("fields");
                                String areaPath = tfsFields.getString("System.AreaLevel1");
                                String projectId = "";
                                projectsMapResponse.put(areaPath, projectsMap.get(areaPath));
                            }
                        }
                        catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                    }
                    ArrayList projectsNeedToBeLoaded = new ArrayList();
                    for (String projectName : projectsMapResponse.keySet()) {
                        HashMap<String, String> project = new HashMap<String, String>();
                        String pid = (String)projectsMapResponse.get(projectName);
                        if (loadedProjects.contains(pid)) continue;
                        project.put("id", pid);
                        project.put("name", projectName);
                        projectsNeedToBeLoaded.add(project);
                    }
                    if (projectsNeedToBeLoaded.size() > 0) {
                        responseJson.put("reason", "projectsNotLoaded");
                        responseJson.put("projects", projectsNeedToBeLoaded);
                    } else {
                        success = true;
                        responseJson.put("success", true);
                        this.tfSservice.fetchTFSItems(tfsIds, sessionBoardId, filter.getLinkTypes(), filter.getIssueType(), filter, null, almAccount, null);
                    }
                }
                catch (JSONException e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
            }
            if (success.booleanValue()) {
                JSONObject pushJson = new JSONObject();
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            responseJson.put("success", success);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (JSONException e) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/removeEmptyItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeEmptyItems(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Map> responseJson = new HashMap<String, Map>();
        List parentItems = null;
        List itemIds = (List)reqbody.get("itemIds");
        if (PropertyValidator.isValid((Collection)itemIds)) {
            parentItems = this.itemRepository.findByIdIn(itemIds);
        } else if (PropertyValidator.isValid((Object)reqbody.get("sessionBoardId"))) {
            SessionBoard sessionBoard = new SessionBoard((String)reqbody.get("sessionBoardId"));
            ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
            sessionBoards.add(sessionBoard);
            parentItems = this.itemRepository.findBySessionBoardsInAndTypeAndTeamContainersExists(sessionBoards, Item.FEATURE, Boolean.valueOf(true));
            itemIds = parentItems.stream().map(BaseEntity::getId).collect(Collectors.toList());
        }
        if (PropertyValidator.isValid((Collection)parentItems)) {
            responseJson.put("removedTcKeys", this.customRepositoryImpl.removeEmptyCards((Collection)itemIds, false));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/smartSyncTFS"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> smartSyncTFS(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap<String, Boolean> _responseJson = new HashMap<String, Boolean>();
        _responseJson.put("success", true);
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/compareBoardFeatures/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> compareBoardFeatures(@PathVariable String sessionBoardId, @RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Boolean isAuto = (Boolean)reqbody.get("isAuto");
        if (PropertyValidator.isValid((Object)sessionBoardId)) {
            if (isAuto.booleanValue()) {
                try {
                    this.customRepositoryImpl.checkIfSessionLocked(sessionBoardId, "Fetch New Issues");
                }
                catch (ViztrendJiraException vJe) {
                    responseJson.put("countOnly", true);
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
            }
        } else {
            return new ResponseEntity((Object)"Invalid Board Id", HttpStatus.BAD_REQUEST);
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/compareBoardFeaturesFetch/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> compareBoardFeaturesFetch(@PathVariable String sessionBoardId, @RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        ArrayList filtersData = (ArrayList)reqbody.get("filters");
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = board.getSession();
        try {
            this.customRepositoryImpl.checkIfSessionLocked(session.getId(), "AddFeatures");
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        responseJson.put("success", true);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchupdatedtfsitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchUpdatedTfsItems(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap<String, Boolean> _responseJson = new HashMap<String, Boolean>();
        _responseJson.put("success", true);
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/optimizedResyncTfsItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> optimizedResyncTfsItems(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap<String, Boolean> _responseJson = new HashMap<String, Boolean>();
        _responseJson.put("success", true);
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resynctfsitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> resyncTFSItems(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        HashMap<String, Boolean> _responseJson = new HashMap<String, Boolean>();
        _responseJson.put("success", true);
        return new ResponseEntity(_responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/savetfsquery"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveQuery(@RequestBody HashMap<String, Object> reqbody) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/fetchtfsitems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchTFSItems(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        String itemIdsStr = (String)reqbody.get("itemIds");
        String sessionId = (String)reqbody.get("sessionId");
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String almAccountId = (String)reqbody.get("almAccountId");
        String tfsSprintPath = (String)reqbody.get("tfsSprintPath");
        String tfsAreaPath = (String)reqbody.get("tfsAreaPath");
        String filterStr = null;
        boolean removeItemsFromKanbanItems = false;
        if (reqbody.containsKey("removeItemsFromKanbanItems")) {
            removeItemsFromKanbanItems = (Boolean)reqbody.get("removeItemsFromKanbanItems");
        }
        if (reqbody.get("filter") != null) {
            filterStr = (String)reqbody.get("filter");
        }
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        String metaMap = (String)reqbody.get("metaMap");
        IssueType issueType = null;
        String issueTypeStr = null;
        String parentId = (String)reqbody.get("parentId");
        String teamContainerStr = (String)reqbody.get("teamContainer");
        if (reqbody.get("issueType") != null) {
            issueTypeStr = (String)reqbody.get("issueType");
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayList linkTypes = (ArrayList)reqbody.get("linkTypes");
        try {
            AlmAccount taggedAlmAccount;
            TFSFilter filter = null;
            TeamContainer teamContainer = null;
            try {
                if (issueTypeStr != null) {
                    issueType = (IssueType)mapper.readValue(issueTypeStr, IssueType.class);
                }
                if (filterStr != null) {
                    filter = (TFSFilter)mapper.readValue(filterStr, TFSFilter.class);
                }
                if (teamContainerStr != null) {
                    teamContainer = (TeamContainer)mapper.readValue(teamContainerStr, TeamContainer.class);
                }
            }
            catch (JsonParseException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
            catch (JsonMappingException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
            if (!PropertyValidator.isValid((Object)itemIdsStr)) return new ResponseEntity(responseJson, HttpStatus.OK);
            if (PropertyValidator.isValid((Object)filter)) {
                filter.setFilterFetchedBy(this.tfsUtils.getProfileAlmUser(almAccount));
                if (PropertyValidator.isValid((Object)filter.getFilterFetchedBy()) && PropertyValidator.isValid((Object)(taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)filter.getFilterFetchedBy(), (AlmAccount)almAccount)))) {
                    almAccount = taggedAlmAccount;
                }
            } else {
                taggedAlmAccount = TFSUtils.getTaggedAlmUser((User)UserContextUtil.getUserContext().getLoggedInUser(), (AlmAccount)almAccount);
                if (PropertyValidator.isValid((Object)taggedAlmAccount)) {
                    almAccount = taggedAlmAccount;
                }
            }
            if (PropertyValidator.isValid((Object)parentId)) {
                List<String> itemIds = Arrays.asList(itemIdsStr.split("\\s*,\\s*"));
                ArrayList<SessionBoard> sessionBoardIds = new ArrayList<SessionBoard>();
                sessionBoardIds.add(new SessionBoard(sessionBoardId));
                List items = this.itemRepository.findBySessionBoardsInAndTfsIdInAndType(sessionBoardIds, itemIds, Item.USER_STORY);
                if (PropertyValidator.isValid((Collection)items)) {
                    responseJson.put("success", false);
                    responseJson.put("reason", "AlreadyExist");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                this.tfSservice.fetchTFSSubItems(itemIds, sessionBoardId, (List)linkTypes, parentId, teamContainer, issueType, metaMap, almAccount, tfsSprintPath, tfsAreaPath);
            } else {
                if (removeItemsFromKanbanItems && sessionId != null) {
                    Session session = this.sessionRepository.findById(sessionId);
                    List<String> itemIds = Arrays.asList(itemIdsStr.split("\\s*,\\s*"));
                    HashMap<String, String> itemIdsMap = new HashMap<String, String>();
                    for (String tfsId : itemIds) {
                        itemIdsMap.put(tfsId, tfsId);
                    }
                    if (PropertyValidator.isValid((Collection)session.getItemsAddedFromKanban())) {
                        for (int i = 0; i < session.getItemsAddedFromKanban().size(); ++i) {
                            Map itemMap = (Map)session.getItemsAddedFromKanban().get(i);
                            if (!itemIdsMap.containsKey(itemMap.get("itemId"))) continue;
                            session.getItemsAddedFromKanban().remove(i);
                            --i;
                        }
                        this.sessionRepository.save((Object)session);
                    }
                }
                this.tfSservice.fetchTFSItems(Arrays.asList(itemIdsStr.split("\\s*,\\s*")), sessionBoardId, (List)linkTypes, issueType, filter, metaMap, almAccount, null);
            }
            responseJson.put("success", true);
            this.userService.setOnboardingMeta("Get_Features_from_Jira", true);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
    }

    @RequestMapping(value={"/fetchAndSaveTFSFilter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchtAndSaveTFSFilter(@RequestBody String payload) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/getAlmAccounts"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getAlmAccounts() {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List alms = this.almAccountRepository.findByType("tfs");
        if (alms != null && alms.size() > 0) {
            responseJson.put("count", alms.size());
            responseJson.put("accounts", alms);
        } else {
            responseJson.put("count", 0);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/removeFilter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeFilter(@RequestBody String payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Gson g = new Gson();
        36 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String sessionBoardId = (String)reqbody.get("sessionBoardId");
        String metaMap = (String)reqbody.get("metaMap");
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        Session session = board.getSession();
        String filterId = (String)reqbody.get("filterId");
        try {
            if (filterId != null) {
                this.tfsFilterRepository.delete((Serializable)((Object)filterId));
                TFSAlmConfigurations configuration = session.getTfsAlmConfigurations();
                List filters = configuration.getFeatureFilters();
                TFSFilter filter = null;
                for (int i = 0; i < filters.size(); ++i) {
                    filter = (TFSFilter)filters.get(i);
                    if (!filter.getId().equals(filterId)) continue;
                    filters.remove(i);
                    break;
                }
                configuration.setFeatureFilters(filters);
                this.tfsAlmConfigurationsRepository.save((Object)configuration);
                responseJson.put("success", true);
                responseJson.put("configuration", (Boolean)configuration);
                if (filter != null) {
                    String tenant = UserContextUtil.getUserContext().getCurrentCompany().getTenant();
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                    query.fields().include("_id");
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"sessionBoards.$id").is((Object)new ObjectId(sessionBoardId)));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tfsFilter").is((Object)filter.getTfsId()));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)Item.FEATURE));
                    DBCursor dbCursorPrefix = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query.getQueryObject());
                    List parents = dbCursorPrefix.toArray();
                    if (PropertyValidator.isValid((Collection)parents)) {
                        ArrayList allIds = new ArrayList();
                        ArrayList parentIds = new ArrayList();
                        parents.forEach(pi -> {
                            String id = String.valueOf(pi.get("_id"));
                            parentIds.add(new ObjectId(id));
                            allIds.add(id);
                        });
                        Query query2 = new Query();
                        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
                        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                        query2.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").in(parentIds));
                        DBCursor dbCursorPrefix1 = this.customRepositoryImpl.getMongoTemplate().getCollection("item").find(query2.getQueryObject());
                        List children = dbCursorPrefix1.toArray();
                        if (PropertyValidator.isValid((Collection)children)) {
                            children.forEach(ci -> allIds.add(String.valueOf(ci.get("_id"))));
                        }
                        if (PropertyValidator.isValid(allIds)) {
                            this.customRepositoryImpl.saveLogsForDeletedItems(this.itemRepository.deleteByIdIn(allIds));
                        }
                    }
                }
                JSONObject pushJson = new JSONObject();
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
                if (PropertyValidator.isValid((Object)filter)) {
                    AuditLog auditLogObject = new AuditLog(sessionBoardId, "FILTER_REMOVED", null);
                    JSONObject auditResource = new JSONObject();
                    auditResource.put("name", (Object)filter.getName());
                    auditResource.put("tfsId", (Object)filter.getId());
                    auditLogObject.setAuditResource(auditResource.toString());
                    this.auditLogRepository.save((Object)auditLogObject);
                }
            } else {
                responseJson.put("success", false);
            }
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", (Boolean)vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsteam/{almId}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjectTeams(@PathVariable(value="almId") String almAccountId, @PathVariable(value="pid") String pid) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
        responseJson.put("teams", this.tfsUtils.getProjectTeams(pid, almAccount));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsteamsprints/{almId}/{pid}/{tid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjectTeamSprints(@PathVariable(value="almId") String almAccountId, @PathVariable(value="pid") String pid, @PathVariable(value="tid") String tid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("success", true);
            responseJson.put("sprints", this.tfsUtils.getTeamIterations(pid, tid, almAccount));
            responseJson.put("teamSettingsFieldValues", this.tfsUtils.getTeamSettingsFieldValues(pid, tid, almAccount));
            responseJson.put("teamSettings", this.tfsUtils.getTeamSettings(pid, tid, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfssprints/{almId}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjectSprints(@PathVariable(value="almId") String almAccountId, @PathVariable(value="pid") String pid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("success", true);
            responseJson.put("sprints", this.tfsUtils.getProjectIterations(pid, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("almError", (Object)vJe);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsteamareapaths/{almId}/{pid}/{tid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjectTeamAreaPaths(@PathVariable(value="almId") String almAccountId, @PathVariable(value="pid") String pid, @PathVariable(value="tid") String tid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            responseJson.put("teamSettings", this.tfsUtils.getTeamSettingsFieldValues(pid, tid, almAccount));
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/tfsprojectareapaths/{almId}/{pid}"})
    @ResponseBody
    public ResponseEntity<Object> getTFSProjectAreaPaths(@PathVariable(value="almId") String almAccountId, @PathVariable(value="pid") String pid) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almAccountId));
            String response = this.tfsUtils.getProjectAreaNodes(pid, null, almAccount);
            responseJson.put("data", response);
        }
        catch (ViztrendJiraException vJe) {
            responseJson.put("success", false);
            responseJson.put("error", vJe.getAlmError());
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/linkTFSWithBoard/{sessionId}/{almId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> linkTFSWithBoard(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="almId") String almId) throws JsonParseException {
        HashMap<String, Session> responseJson = new HashMap<String, Session>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        AlmAccount almAccount = new AlmAccount();
        almAccount.setId(almId);
        TFSAlmConfigurations configuration = new TFSAlmConfigurations();
        configuration.setAlmAccount(almAccount);
        configuration = (TFSAlmConfigurations)this.tfsAlmConfigurationsRepository.save((Object)configuration);
        session.setTfsAlmConfigurations(configuration);
        session.setAlmEnabled(Boolean.valueOf(true));
        session = (Session)this.sessionRepository.save((Object)session);
        responseJson.put("session", session);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTeamMappingData/{almId}/{sessionId}/{sessionBoardId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getTeamMappingDate(@RequestBody TFSTeamMapping teamMapping, @PathVariable(value="almId") String almId, @PathVariable(value="sessionId") String sessionId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        Team team = new Team();
        team.setId(teamMapping.getKendisTeamId());
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        List tfsProjects = this.tfsProjectRepository.findBySessionId(sessionId);
        AlmAccount almAccount = (AlmAccount)this.almAccountRepository.findOne((Serializable)((Object)almId));
        responseJson.put("projects", tfsProjects);
        responseJson.put("sprints", this.tfsUtils.getTeamIterations(teamMapping.getTfsProjectTfsId(), teamMapping.getTfsTeamId(), almAccount));
        responseJson.put("teamSettingsFieldValues", this.tfsUtils.getTeamSettingsFieldValues(teamMapping.getTfsProjectTfsId(), teamMapping.getTfsTeamId(), almAccount));
        responseJson.put("teamSettings", this.tfsUtils.getTeamSettings(teamMapping.getTfsProjectTfsId(), teamMapping.getTfsTeamId(), almAccount));
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard.setId(sessionBoardId);
        responseJson.put("itemSyncMappers", this.itemSyncMapperRepository.findByTeamAndSessionBoard(team, sessionBoard));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveTfsTeamSettings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveTfsTeamSettings(@RequestBody HashMap<String, Object> payload) throws JsonParseException {
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)((String)payload.get("sessionId"))));
        String sessionBoardId = (String)payload.get("sessionBoardId");
        SessionBoard sessionBoard = new SessionBoard();
        sessionBoard.setId(sessionBoardId);
        AuditLog auditLogObject = new AuditLog(sessionBoardId, "TEAM_SETTINGS");
        this.auditLogRepository.save((Object)auditLogObject);
        List existingItemSyncMappers = this.itemSyncMapperRepository.findBySessionBoard(sessionBoard);
        HashMap<String, ItemSyncMapper> existingItemSyncMappersMap = new HashMap<String, ItemSyncMapper>();
        if (existingItemSyncMappers != null) {
            for (ItemSyncMapper syncMapper : existingItemSyncMappers) {
                String key = syncMapper.getTeam().getId() + ":" + syncMapper.getContainer().getId();
                existingItemSyncMappersMap.put(key, syncMapper);
            }
        }
        TFSTeamMapping teamMapping = null;
        List itemSyncMappers = null;
        ObjectMapper mapper = new ObjectMapper();
        String tmJson = (String)payload.get("teamMapping");
        String metaMap = (String)payload.get("metaMap");
        String ismJson = (String)payload.get("itemSyncMappers");
        TFSAlmConfigurations almConfiguration = session.getTfsAlmConfigurations();
        try {
            teamMapping = (TFSTeamMapping)mapper.readValue(tmJson, TFSTeamMapping.class);
            itemSyncMappers = (List)mapper.readValue(ismJson, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ItemSyncMapper.class));
        }
        catch (JsonParseException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        if (almConfiguration.getTeamMappings() != null) {
            for (int i = 0; i < almConfiguration.getTeamMappings().size(); ++i) {
                if (!((TFSTeamMapping)almConfiguration.getTeamMappings().get(i)).getKendisTeamId().equals(teamMapping.getKendisTeamId())) continue;
                almConfiguration.getTeamMappings().remove(i);
                break;
            }
        } else {
            almConfiguration.setTeamMappings(new ArrayList());
        }
        almConfiguration.getTeamMappings().add(teamMapping);
        for (ItemSyncMapper syncMapper : itemSyncMappers) {
            String key = syncMapper.getTeam().getId() + ":" + syncMapper.getContainer().getId();
            ItemSyncMapper existingSyncMapper = (ItemSyncMapper)existingItemSyncMappersMap.get(key);
            if (existingSyncMapper == null) continue;
            syncMapper.setId(existingSyncMapper.getId());
        }
        this.itemSyncMapperRepository.save((Iterable)itemSyncMappers);
        this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
        teamMapping.setItemSyncMappers(itemSyncMappers);
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("teamMappings", almConfiguration.getTeamMappings());
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("isTFS", true);
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/bulkSaveTfsTeamSettings"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> bulkSaveTfsTeamSettings(@RequestBody HashMap<String, Object> payload) throws JsonParseException {
        String sessionId = (String)payload.get("sessionId");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        String tfsProjectTfsId = (String)payload.get("tfsProjectTfsId");
        HashMap selectedSprintsByKendisSprintId = (HashMap)payload.get("selectedSprintsByKendisSprintId");
        SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
        Session session = sessionBoard.getSession();
        ArrayList<Team> teamsToUpdate = new ArrayList<Team>();
        HashMap<String, TFSTeamMapping> teamMappingsByTeamId = new HashMap<String, TFSTeamMapping>();
        if (PropertyValidator.isValid((Object)session.getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)session.getTfsAlmConfigurations().getTeamMappings())) {
            for (TFSTeamMapping tm : session.getTfsAlmConfigurations().getTeamMappings()) {
                teamMappingsByTeamId.put(tm.getKendisTeamId(), tm);
                if (!tm.getTfsProjectTfsId().equals(tfsProjectTfsId)) continue;
                Team team = new Team();
                team.setId(tm.getKendisTeamId());
                teamsToUpdate.add(team);
            }
        }
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        if (PropertyValidator.isValid(teamsToUpdate)) {
            List existingItemSyncMappers = this.itemSyncMapperRepository.findBySessionBoardAndTeamIn(sessionBoard, teamsToUpdate);
            HashMap<String, ItemSyncMapper> itemSyncMappersByKey = new HashMap<String, ItemSyncMapper>();
            for (ItemSyncMapper syncMapper : existingItemSyncMappers) {
                if (!PropertyValidator.isValid((Object)syncMapper.getTeam()) || !PropertyValidator.isValid((Object)syncMapper.getContainer())) continue;
                String key = syncMapper.getTeam().getId() + ":" + syncMapper.getContainer().getId();
                itemSyncMappersByKey.put(key, syncMapper);
            }
            ArrayList<ItemSyncMapper> syncMappersToSave = new ArrayList<ItemSyncMapper>();
            for (Team team : teamsToUpdate) {
                TFSTeamMapping teamMapping = (TFSTeamMapping)teamMappingsByTeamId.get(team.getId());
                if (!PropertyValidator.isValid((Object)teamMapping)) continue;
                for (Container sprint : sessionBoard.getContainers()) {
                    HashMap tfsSprintDetails;
                    String key = team.getId() + ":" + sprint.getId();
                    ItemSyncMapper syncMapper = (ItemSyncMapper)itemSyncMappersByKey.get(key);
                    if (syncMapper == null) {
                        syncMapper = new ItemSyncMapper();
                        syncMapper.setTeam(team);
                        syncMapper.setContainer(sprint);
                        syncMapper.setTfsProjectId(teamMapping.getTfsProjectTfsId());
                    }
                    if ((tfsSprintDetails = (HashMap)selectedSprintsByKendisSprintId.get(sprint.getId())) == null) {
                        syncMapper.setTfsSprint(null);
                    } else {
                        String sprintId = (String)tfsSprintDetails.get("id");
                        String sprintpath = (String)tfsSprintDetails.get("path");
                        String sprintname = (String)tfsSprintDetails.get("name");
                        if (!sprintId.equals("-1")) {
                            Sprint tfsSprint = new Sprint();
                            tfsSprint.setTfsId(sprintId);
                            tfsSprint.setIterationPath(sprintpath);
                            tfsSprint.setTitle(sprintname);
                            syncMapper.setTfsSprint(tfsSprint);
                        }
                    }
                    syncMappersToSave.add(syncMapper);
                }
            }
            this.itemSyncMapperRepository.save(syncMappersToSave);
            responseJson.put("syncMappers", syncMappersToSave);
            responseJson.put("success", Boolean.valueOf(true));
        } else {
            responseJson.put("success", Boolean.valueOf(false));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/resyncTfsTeamSettings/{sessionBoardId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> resyncTfsTeamSettings(@PathVariable String sessionBoardId) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        TFSAlmConfigurations almConfiguration = sessionBoard.getSession().getTfsAlmConfigurations();
        AlmAccount almAccount = sessionBoard.getSession().getTfsAlmConfigurations().getAlmAccount();
        if (almConfiguration.getTeamMappings() != null) {
            for (int i = 0; i < almConfiguration.getTeamMappings().size(); ++i) {
                TFSTeamMapping teamMapping = (TFSTeamMapping)almConfiguration.getTeamMappings().get(i);
                String reponse = this.tfsUtils.getTeamSettings(teamMapping.getTfsProjectTfsId(), teamMapping.getTfsTeamId(), almAccount);
                Map kv = (Map)new Gson().fromJson(reponse, Map.class);
                LinkedTreeMap backlogIteration = (LinkedTreeMap)kv.get("backlogIteration");
                if (!PropertyValidator.isValid((Object)backlogIteration)) continue;
                String path = (String)backlogIteration.get((Object)"path");
                if (PropertyValidator.isValid((Object)path) && path.length() > 0) {
                    teamMapping.setTfsBacklogIteration(teamMapping.getTfsProjectName() + "\\" + path);
                    continue;
                }
                teamMapping.setTfsBacklogIteration(teamMapping.getTfsProjectName());
            }
        }
        this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("teamMappings", almConfiguration.getTeamMappings());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteTfsTeamSettings/{sessionBoardId}/{teamId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteTfsTeamSettings(@PathVariable String sessionBoardId, @PathVariable String teamId, @RequestBody HashMap<String, Object> payload) {
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        TFSAlmConfigurations almConfiguration = sessionBoard.getSession().getTfsAlmConfigurations();
        int teamMappingIndex = -1;
        String metaMap = (String)payload.get("metaMap");
        if (almConfiguration.getTeamMappings() != null) {
            for (int i = 0; i < almConfiguration.getTeamMappings().size(); ++i) {
                if (!((TFSTeamMapping)almConfiguration.getTeamMappings().get(i)).getKendisTeamId().equals(teamId)) continue;
                teamMappingIndex = i;
                break;
            }
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (teamMappingIndex > -1) {
            almConfiguration.getTeamMappings().remove(teamMappingIndex);
            this.tfsAlmConfigurationsRepository.save((Object)almConfiguration);
            Team _team = new Team();
            _team.setId(teamId);
            SessionBoard _sessionBoard = new SessionBoard();
            _sessionBoard.setId(sessionBoardId);
            this.itemSyncMapperRepository.deleteBySessionBoardAndTeam(_sessionBoard, _team);
            responseJson.put("success", true);
            responseJson.put("status", "settings removed");
            responseJson.put("teamMappings", almConfiguration.getTeamMappings());
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        } else {
            responseJson.put("success", false);
            responseJson.put("status", "settings for this team does't exist");
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/getteams"})
    @ResponseBody
    public ResponseEntity<Object> getAllTeams() {
        HashMap<String, List> responseJson = new HashMap<String, List>();
        responseJson.put("teams", this.teamRepository.findAll());
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/changeState1"})
    public SessionBoard changeState1(@RequestBody SessionBoard requestBoard) {
        Optional<Container> container;
        List mappers;
        String boardId = requestBoard.getId();
        String stateId = requestBoard.getState().getId();
        SessionBoard savedSessionBoard = null;
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        savedSessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)boardId));
        if (!PropertyValidator.isValid((Object)savedSessionBoard.getState())) {
            savedSessionBoard.setState(new State(stateId));
            this.sessionBoardRepository.save((Object)savedSessionBoard);
            return savedSessionBoard;
        }
        List newTeams = savedSessionBoard.getTeams();
        List newContainers = savedSessionBoard.getContainers();
        ArrayList<ItemLink> newItemLinks = new ArrayList<ItemLink>();
        ArrayList<Item> newItems = new ArrayList<Item>();
        ArrayList<TeamContainer> newTeamContainers = new ArrayList<TeamContainer>();
        sessionBoards.add(savedSessionBoard);
        List items = this.itemRepository.findBySessionBoardsIn(sessionBoards);
        try {
            for (Item item2 : items) {
                List itemLinks;
                TeamContainer tc22;
                List teamContainers = item2.getTeamContainers();
                if (PropertyValidator.isValid((Collection)teamContainers)) {
                    for (TeamContainer tc22 : teamContainers) {
                        Optional<TeamContainer> duplicateTc;
                        if (!PropertyValidator.isValid((Object)tc22) || (duplicateTc = newTeamContainers.stream().filter(x -> tc22.getId().equals(x.getId())).findFirst()).isPresent()) continue;
                        newTeamContainers.add(tc22);
                    }
                }
                if (!PropertyValidator.isValid((Collection)(itemLinks = item2.getItemLinks()))) continue;
                tc22 = itemLinks.iterator();
                while (tc22.hasNext()) {
                    ItemLink itemLink = (ItemLink)tc22.next();
                    newItemLinks.add(itemLink);
                }
            }
            newContainers.forEach(f -> {
                f.setDuplicateOfId(f.getId());
                if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                    f.setOriginItemId(f.getId());
                }
                f.setId(null);
            });
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String sStackTrace = sw.toString();
            LOGGER.debug(" :: JsonProcessingException ..  " + sStackTrace);
        }
        newContainers = this.containerRepository.save((Iterable)newContainers);
        ArrayList<TeamContainer> modTeamContainers = new ArrayList<TeamContainer>();
        for (TeamContainer tc : newTeamContainers) {
            Optional<Container> container2 = newContainers.stream().filter(x -> tc.getContainer().getId().equals(x.getDuplicateOfId())).findFirst();
            tc.setContainer(container2.get());
            modTeamContainers.add(tc);
        }
        modTeamContainers.forEach(f -> {
            f.setDuplicateOfId(f.getId());
            if (!PropertyValidator.isValid((Object)f.getOriginItemId())) {
                f.setOriginItemId(f.getId());
            }
            f.setId(null);
        });
        List subSetsModTeamContainers = Lists.partition(new ArrayList(modTeamContainers), (int)100);
        ArrayList tempModTeamContainers = new ArrayList();
        for (List subSetModTeamContainer : subSetsModTeamContainers) {
            tempModTeamContainers.addAll(this.teamContainerRepository.save((Iterable)subSetModTeamContainer));
            LOGGER.debug(" subSetModTeamContainer....  ");
        }
        modTeamContainers = tempModTeamContainers;
        HashMap<String, String> userstoryIdsMap = new HashMap<String, String>();
        HashMap<String, String> featureIdsMap = new HashMap<String, String>();
        ArrayList<ItemLink> newItemLinksNotNullList = new ArrayList<ItemLink>();
        for (ItemLink itemLink : newItemLinks) {
            String newFeatureId;
            String newUserStoryId;
            if (itemLink == null) continue;
            Optional<TeamContainer> srcTc = modTeamContainers.stream().filter(x -> itemLink.getSourceTeamContainerId() != null && itemLink.getSourceTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            Optional<TeamContainer> targetTc = modTeamContainers.stream().filter(x -> itemLink.getTargetTeamContainerId() != null && itemLink.getTargetTeamContainerId().equals(x.getDuplicateOfId())).findFirst();
            if (srcTc.isPresent()) {
                itemLink.setSourceTeamContainerId(srcTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink.getSourceUserStoryId())) {
                        itemLink.setSourceUserStoryId((String)userstoryIdsMap.get(itemLink.getSourceUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink.getSourceUserStoryId(), newUserStoryId);
                        itemLink.setSourceUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getSourceFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink.getSourceFeatureId())) {
                        itemLink.setSourceFeatureId((String)featureIdsMap.get(itemLink.getSourceFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getSourceFeatureId(), newFeatureId);
                        itemLink.setSourceFeatureId(newFeatureId);
                    }
                }
            }
            if (targetTc.isPresent()) {
                itemLink.setTargetTeamContainerId(targetTc.get().getId());
                if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                    if (userstoryIdsMap.containsKey(itemLink.getTargetUserStoryId())) {
                        itemLink.setTargetUserStoryId((String)userstoryIdsMap.get(itemLink.getTargetUserStoryId()));
                    } else {
                        newUserStoryId = ObjectId.get().toString();
                        userstoryIdsMap.put(itemLink.getTargetUserStoryId(), newUserStoryId);
                        itemLink.setTargetUserStoryId(newUserStoryId);
                    }
                }
                if (PropertyValidator.isValid((Object)itemLink.getTargetFeatureId())) {
                    if (featureIdsMap.containsKey(itemLink.getTargetFeatureId())) {
                        itemLink.setTargetFeatureId((String)featureIdsMap.get(itemLink.getTargetFeatureId()));
                    } else {
                        newFeatureId = ObjectId.get().toString();
                        featureIdsMap.put(itemLink.getTargetFeatureId(), newFeatureId);
                        itemLink.setTargetFeatureId(newFeatureId);
                    }
                }
            }
            itemLink.setOriginItemId(itemLink.getOriginItemId() == null ? itemLink.getId() : itemLink.getOriginItemId());
            itemLink.setDuplicateOfId(itemLink.getId());
            itemLink.setId(null);
            newItemLinksNotNullList.add(itemLink);
        }
        List subSetsNewItemLinksNotNullList = Lists.partition(new ArrayList(newItemLinksNotNullList), (int)100);
        for (List subSetNewItemLinksNotNullList : subSetsNewItemLinksNotNullList) {
            this.itemLinkRepository.save((Iterable)subSetNewItemLinksNotNullList);
            LOGGER.debug(" subSetNewItemLinksNotNullList....  ");
        }
        SessionBoard sessionBoard = new SessionBoard();
        if (PropertyValidator.isValid((Object)requestBoard.getState().getIsFinal()) && requestBoard.getState().getIsFinal().booleanValue()) {
            sessionBoard.setStatus(SessionBoard.CLOSED);
        } else {
            sessionBoard.setStatus(SessionBoard.OPEN);
        }
        sessionBoard.setState(new State(stateId));
        sessionBoard.setContainers(newContainers);
        sessionBoard.setTeams(newTeams);
        sessionBoard.setTeamSequence(savedSessionBoard.getTeamSequence());
        sessionBoard.setObjectiveIds(savedSessionBoard.getObjectiveIds());
        sessionBoard.setObjectivesMap(savedSessionBoard.getObjectivesMap());
        sessionBoard.setCreationDate(new Date());
        sessionBoard.setSession(savedSessionBoard.getSession());
        SessionBoard sessionBoard2 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard);
        if (savedSessionBoard.getSession().getAlmEnabled().booleanValue() && PropertyValidator.isValid((Collection)(mappers = this.itemSyncMapperRepository.findBySessionBoard(savedSessionBoard)))) {
            Object itemSyncMapper22;
            for (Object itemSyncMapper22 : mappers) {
                itemSyncMapper22.setSessionBoard(sessionBoard2);
                container = newContainers.stream().filter(arg_0 -> PIController.lambda$changeState1$24((ItemSyncMapper)itemSyncMapper22, arg_0)).findFirst();
                if (!container.isPresent()) continue;
                itemSyncMapper22.setContainer(container.get());
            }
            List subSetsMappers = Lists.partition(new ArrayList(mappers), (int)100);
            itemSyncMapper22 = subSetsMappers.iterator();
            while (itemSyncMapper22.hasNext()) {
                List subSetMappers = (List)itemSyncMapper22.next();
                this.itemSyncMapperRepository.save((Iterable)subSetMappers);
                LOGGER.debug(" subSetMappers....  ");
            }
        }
        List tsvList = this.teamSprintVelocityRepository.findBySessionBoardId(savedSessionBoard.getId());
        tsvList.forEach(f -> f.setDuplicateOfId(f.getId()));
        for (Object newTsv : tsvList) {
            container = newContainers.stream().filter(arg_0 -> PIController.lambda$changeState1$26((TeamSprintVelocity)newTsv, arg_0)).findFirst();
            if (container.isPresent()) {
                newTsv.setSprintId(container.get().getId());
            }
            newTsv.setId(null);
            newTsv.setSessionBoardId(sessionBoard2.getId());
        }
        List subSetsTSVList = Lists.partition(new ArrayList(tsvList), (int)100);
        for (Object subSetTSVList : subSetsTSVList) {
            this.teamSprintVelocityRepository.save((Iterable)subSetTSVList);
            LOGGER.debug(" subSetTSVList....  ");
        }
        ArrayList<SessionBoard> newSessionBoardList = new ArrayList<SessionBoard>();
        newSessionBoardList.add(sessionBoard2);
        for (Item item3 : items) {
            if (PropertyValidator.isValid((Collection)item3.getTeamContainers())) {
                for (TeamContainer tc : item3.getTeamContainers()) {
                    for (TeamContainer xtc : modTeamContainers) {
                        if (!PropertyValidator.isValid((Object)tc) || !PropertyValidator.isValid((Object)xtc) || !tc.getId().equals(xtc.getDuplicateOfId())) continue;
                        tc.setId(xtc.getId());
                    }
                }
            }
            item3.setSessionBoards(newSessionBoardList);
            newItems.add(item3);
        }
        ArrayList itemJiraDependencies = new ArrayList();
        HashMap oldIdsMap = new HashMap();
        HashMap itemDuplicateOfMap = new HashMap();
        newItems.forEach(item -> {
            String newItemId = ObjectId.get().toString();
            oldIdsMap.put(item.getId(), newItemId);
            item.setDuplicateOfId(item.getId());
            if (!PropertyValidator.isValid((Object)item.getOriginItemId())) {
                item.setOriginItemId(item.getId());
            }
            if ("UserStory".equals(item.getType())) {
                if (userstoryIdsMap.containsKey(item.getId())) {
                    oldIdsMap.put(item.getId(), userstoryIdsMap.get(item.getId()));
                    item.setId((String)userstoryIdsMap.get(item.getId()));
                } else {
                    item.setId(newItemId);
                }
            } else if (featureIdsMap.containsKey(item.getId())) {
                oldIdsMap.put(item.getId(), featureIdsMap.get(item.getId()));
                item.setId((String)featureIdsMap.get(item.getId()));
            } else {
                item.setId(newItemId);
            }
            item.setSuspendActivity(true);
            if (PropertyValidator.isValid((Collection)item.getJiraDependencies())) {
                for (ItemJiraDependency itemJiraDependency : item.getJiraDependencies()) {
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getSourceItemId()) && oldIdsMap.containsKey(itemJiraDependency.getSourceItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setSourceItemId((String)oldIdsMap.get(itemJiraDependency.getSourceItemId()));
                    }
                    if (PropertyValidator.isValid((Object)itemJiraDependency.getTargetItemId()) && oldIdsMap.containsKey(itemJiraDependency.getTargetItemId())) {
                        itemJiraDependency.setId(null);
                        itemJiraDependency.setTargetItemId((String)oldIdsMap.get(itemJiraDependency.getTargetItemId()));
                    }
                    itemJiraDependencies.add(itemJiraDependency);
                }
            }
            itemDuplicateOfMap.put(item.getDuplicateOfId(), item.getId());
        });
        if (PropertyValidator.isValid(itemJiraDependencies)) {
            List subSetsItemJiraDependencies = Lists.partition(new ArrayList(itemJiraDependencies), (int)100);
            for (Object subSetItemJiraDependencies : subSetsItemJiraDependencies) {
                this.itemJiraDependencyRepository.save((Iterable)subSetItemJiraDependencies);
                LOGGER.debug(" subSetItemJiraDependencies....  ");
            }
        }
        List subSetsNewItems = Lists.partition(new ArrayList(newItems), (int)100);
        ArrayList tempNewItems = new ArrayList();
        for (List subSetNewItems : subSetsNewItems) {
            tempNewItems.addAll(this.itemRepository.save((Iterable)subSetNewItems));
            LOGGER.debug(" subSetNewItems....  ");
        }
        newItems = tempNewItems;
        ArrayList<Item> itemsWithParent = new ArrayList<Item>();
        int ind = 0;
        for (Item item2 : newItems) {
            if (!Item.USER_STORY.equals(item2.getType()) || !PropertyValidator.isValid((Object)item2.getParent())) continue;
            if (itemDuplicateOfMap.containsKey(item2.getParent().getId())) {
                item2.setParent(new Item((String)itemDuplicateOfMap.get(item2.getParent().getId())));
                itemsWithParent.add(item2);
            }
            LOGGER.debug(" Item.USER_STORY.equals(item.getType()) loop....  " + ind++);
        }
        List subSetsItemsWithParent = Lists.partition(new ArrayList(itemsWithParent), (int)100);
        for (List subSetItemsWithParent : subSetsItemsWithParent) {
            this.itemRepository.save((Iterable)subSetItemsWithParent);
            LOGGER.debug(" subSetItemsWithParent....  ");
        }
        sessionBoard2.copyObjectives(itemDuplicateOfMap);
        this.customRepository.setSessionBoardParent(savedSessionBoard.getId(), sessionBoard2.getId());
        this.customRepository.lockSessionBoard(savedSessionBoard.getId(), Boolean.valueOf(true));
        this.customRepository.updateSessionBoardsParent(boardId, sessionBoard2.getId());
        this.customRepository.updateActiveSessionBoard(sessionBoard2.getSession().getId(), sessionBoard2.getId());
        SessionBoard sessionBoard3 = (SessionBoard)this.sessionBoardRepository.save((Object)sessionBoard2);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("type", (Object)"Board");
            jSONObject.put("newStateId", (Object)stateId);
            jSONObject.put("newBoardId", (Object)sessionBoard3.getId());
            jSONObject.put("metaMap", (Object)requestBoard.getMetaMap());
            PushSender.sendMsg((String)jSONObject.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return sessionBoard3;
    }

    @RequestMapping(value={"/changeStateNew"})
    @ResponseBody
    public ResponseEntity<Object> changeStateNew(@RequestBody String request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/changeState"})
    @ResponseBody
    public ResponseEntity<Object> changeState(@RequestBody String request) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        return new ResponseEntity((Object)"success", HttpStatus.OK);
    }

    @RequestMapping(value={"/board/export/{id}/{type}"})
    public ResponseEntity<ByteArrayResource> exportBoard(@PathVariable(value="id") String id, @PathVariable(value="type") String type) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
        try {
            String extension = "xls";
            int exportType = 1;
            if (PropertyValidator.isValid((Object)type) && "csv".equalsIgnoreCase(type)) {
                extension = "csv";
                exportType = 0;
            }
            String csvHeader = "Position,Key,Summary,Story Points,Due Date,Status,Created by,Created on,Updated by,Updated on,Type,Card Type,Parent Key,Parent Title,Session Board,Sprints,Teams,Linked Items,Iteration,Area Path,Wsjf Score";
            String filePath = this.exportService.exportBoardData(id, board, exportType, csvHeader);
            String cleanedSessionTitle = AlmUtils.cleanText((String)board.getSession().getTitle());
            File responsefile = new File(filePath);
            Path path = Paths.get(filePath, new String[0]);
            ByteArrayResource resource = new ByteArrayResource(Files.readAllBytes(path));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"" + cleanedSessionTitle + "." + extension + "\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength(responsefile.length()).contentType(MediaType.parseMediaType((String)"application/octet-stream")).body((Object)resource);
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            System.out.println(id);
            return null;
        }
    }

    @RequestMapping(value={"/remove/tfslink"})
    public ResponseEntity<Object> removeTFSLink(@RequestBody Item item) {
        Item savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
        ItemJiraDependency jdtodel = null;
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        for (ItemJiraDependency il : savedItem.getJiraDependencies()) {
            if (!PropertyValidator.isValid((Object)il) || !PropertyValidator.isValid((Object)il.getId()) || !il.getId().equals(((ItemJiraDependency)item.getJiraDependencies().get(0)).getId())) continue;
            jdtodel = il;
        }
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        if (PropertyValidator.isValid(jdtodel)) {
            ItemJiraDependency reverseDependency;
            if (PropertyValidator.isValid((Object)jdtodel.getSourceItemId()) && PropertyValidator.isValid((Object)jdtodel.getTargetItemId()) && PropertyValidator.isValid((Object)(reverseDependency = this.itemJiraDependencyRepository.findBySourceItemIdAndTargetItemId(jdtodel.getTargetItemId(), jdtodel.getSourceItemId())))) {
                Item reverseItem = this.itemRepository.findById(reverseDependency.getSourceItemId());
                this.itemJiraDependencyRepository.delete((Object)reverseDependency);
                responseJson.put("reverseDependency", reverseDependency);
                if (PropertyValidator.isValid((Object)reverseItem)) {
                    reverseItem.getJiraDependencies().remove(reverseDependency);
                    this.itemRepository.save((Object)reverseItem);
                    responseJson.put("reverseItem", reverseItem);
                }
            }
            boolean isTFS = jdtodel.getIsTFS();
            String jiraIssueLinkId = jdtodel.getJiraDependencyId();
            this.itemJiraDependencyRepository.delete(jdtodel);
            savedItem.setMetaMap(item.getMetaMap());
            savedItem.getJiraDependencies().remove(jdtodel);
            HashMap linkedDependencyMap = this.almSyncService.deleteKendisAndAlmLink((Object)jdtodel, savedItem, null);
            if (PropertyValidator.isValid((Object)linkedDependencyMap) && PropertyValidator.isValid(linkedDependencyMap.get("id"))) {
                responseJson.put("linkedKendisLink", linkedDependencyMap.get("id"));
            }
            this.itemRepository.save((Object)savedItem);
            String targetFeatureId = jdtodel.getTargetItemId();
            AlmAccount almAccount = PropertyValidator.isValid((Object)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations()) ? ((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount() : ((AlmConfigurations)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0)).getAlmAccount();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            responseJson.put("item", savedItem);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        responseJson.put("item", savedItem);
        return new ResponseEntity(responseJson, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/remove/link"})
    public ResponseEntity<Object> removeLink(@RequestBody Item item) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Gson g = new Gson();
            40 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestMap = (HashMap)g.fromJson(item.getMetaMap(), T.getType());
            Item savedItem = null;
            if (PropertyValidator.isValid((Object)item.getId())) {
                savedItem = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
            }
            if (savedItem == null) {
                ArrayList itemLinks = new ArrayList();
                itemLinks.add(item.getItemLinks().get(0));
                List items = this.itemRepository.findByItemLinksIn(itemLinks);
                if (PropertyValidator.isValid((Collection)items)) {
                    savedItem = (Item)items.get(0);
                }
            }
            ItemLink linktodel = null;
            if (!PropertyValidator.isValid(savedItem) || !PropertyValidator.isValid((Collection)savedItem.getItemLinks())) {
                this.itemLinkRepository.delete(item.getItemLinks().get(0));
                responseJson.put("success", true);
                responseJson.put("linkId", ((ItemLink)item.getItemLinks().get(0)).getId());
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
            for (ItemLink il : savedItem.getItemLinks()) {
                if (!PropertyValidator.isValid((Object)il) || !PropertyValidator.isValid((Object)il.getId()) || !il.getId().equals(((ItemLink)item.getItemLinks().get(0)).getId())) continue;
                linktodel = il;
                break;
            }
            if (linktodel != null) {
                this.notificationService.startNotificationThread(linktodel, linktodel, "dependency_delete_template", Boolean.valueOf(false), "");
                String savedItemTfsId = savedItem.getTfsId();
                List linkedAlmLinks = null;
                if (PropertyValidator.isValid((Collection)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations())) {
                    linkedAlmLinks = JiraUtils.removeLink((ItemLink)linktodel, (Item)savedItem, (boolean)((ItemLink)item.getItemLinks().get(0)).isRemoveAlmLink());
                } else if (PropertyValidator.isValid((Object)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations())) {
                    linkedAlmLinks = this.removeLink(linktodel, item, savedItem);
                }
                this.itemLinkRepository.delete((Object)linktodel);
                savedItem.setMetaMap(item.getMetaMap());
                savedItem.getItemLinks().remove(linktodel);
                savedItem.putLastUpdatedValue(Item.Actions.itemLinkRemoved.name(), (Object)linktodel);
                this.itemRepository.save((Object)savedItem);
                responseJson.put("success", true);
                responseJson.put("linkId", linktodel.getId());
                responseJson.put("item", savedItem);
                responseJson.put("linkedAlmLinks", linkedAlmLinks);
                return new ResponseEntity(responseJson, HttpStatus.OK);
            }
        }
        catch (Exception ex) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
        }
        responseJson.put("success", false);
        return new ResponseEntity(responseJson, HttpStatus.NO_CONTENT);
    }

    private List<ItemJiraDependency> removeLink(ItemLink linktodel, Item item, Item savedItem) {
        String savedItemTfsId = savedItem.getTfsId();
        List linkedAlmLinks = null;
        if (PropertyValidator.isValid((Object)linktodel.getAlmLinkId())) {
            HashMap linkedMap = this.almSyncService.deleteKendisAndAlmLink((Object)linktodel, savedItem, linktodel.getTargetUserStoryId() != null ? linktodel.getTargetUserStoryId() : linktodel.getTargetFeatureId());
            if (PropertyValidator.isValid((Object)linkedMap) && PropertyValidator.isValid(linkedMap.get("jiraDependencies"))) {
                linkedAlmLinks = (List)linkedMap.get("jiraDependencies");
            }
            if (((ItemLink)item.getItemLinks().get(0)).isRemoveAlmLink()) {
                String targetFeatureId = linktodel.getTargetUserStoryId() != null ? linktodel.getTargetUserStoryId() : linktodel.getTargetFeatureId();
                AlmAccount almAccount = ((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getTfsAlmConfigurations().getAlmAccount();
                new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            }
        }
        return linkedAlmLinks;
    }

    @RequestMapping(value={"/check/teamcontainer"})
    public ResponseEntity<Object> checkTeamContainer(@RequestBody String requestBody) {
        String sourceTeamContainerJson;
        Gson g = new Gson();
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        42 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String targetTeamContainerJson = (String)requestMap.get("TteamContainer");
        if (targetTeamContainerJson != null) {
            String id = (String)requestMap.get("TteamContainerId");
            ObjectMapper map = new ObjectMapper();
            List teamContainer = null;
            try {
                teamContainer = (List)map.readValue(targetTeamContainerJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, TeamContainer.class));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            TeamContainer oldTeamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)id));
            responseJson.put("targetNotPresent", true);
            if (PropertyValidator.isValid((Collection)teamContainer)) {
                teamContainer.forEach(tC -> {
                    if (tC.getContainer().getId().equals(oldTeamContainer.getContainer().getId()) && tC.getTeam().getId().equals(oldTeamContainer.getTeam().getId())) {
                        responseJson.put("targetNotPresent", false);
                    }
                });
            }
        }
        if ((sourceTeamContainerJson = (String)requestMap.get("SteamContainer")) != null) {
            String id = (String)requestMap.get("SteamContainerId");
            ObjectMapper map = new ObjectMapper();
            List teamContainer = null;
            try {
                teamContainer = (List)map.readValue(sourceTeamContainerJson, (JavaType)map.getTypeFactory().constructCollectionType(List.class, TeamContainer.class));
            }
            catch (IOException e) {
                System.out.println(e);
            }
            TeamContainer oldTeamContainer = (TeamContainer)this.teamContainerRepository.findOne((Serializable)((Object)id));
            responseJson.put("sourceNotPresent", true);
            if (PropertyValidator.isValid((Collection)teamContainer)) {
                teamContainer.forEach(tC -> {
                    if (tC.getContainer().getId().equals(oldTeamContainer.getContainer().getId()) && tC.getTeam().getId().equals(oldTeamContainer.getTeam().getId())) {
                        responseJson.put("sourceNotPresent", false);
                    }
                });
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/update/links"})
    @ResponseBody
    public ResponseEntity<Object> updateLinks(@RequestBody String requestBody) {
        Gson g = new Gson();
        43 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestMap = (HashMap)g.fromJson(requestBody, T.getType());
        String itemJson = (String)requestMap.get("item");
        String syncId = (String)requestMap.get("syncId");
        String boardId = (String)requestMap.get("boardId");
        HashMap response = new HashMap();
        ObjectMapper mapper = new ObjectMapper();
        Item item = null;
        try {
            item = (Item)mapper.readValue(itemJson, mapper.getTypeFactory().constructType(Item.class));
        }
        catch (JsonParseException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonMappingException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        catch (IOException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        ItemLink itemLinkToUpdate = (ItemLink)item.getItemLinks().get(0);
        ItemLink savedLink = (ItemLink)this.itemLinkRepository.findOne((Serializable)((Object)itemLinkToUpdate.getId()));
        String st1 = "";
        String st2 = "";
        if (PropertyValidator.isValid((Object)savedLink.getWfStatus()) && PropertyValidator.isValid((Object)itemLinkToUpdate.getWfStatus())) {
            st1 = savedLink.getWfStatus().getId();
            st2 = itemLinkToUpdate.getWfStatus().getId();
        } else {
            st1 = itemLinkToUpdate.getWfStatus().getCategory();
            st2 = savedLink.getStatus().equals("Resolved") ? "Done" : "ToDo";
        }
        HashMap emailTemp = new HashMap();
        if (!st1.equals(st2)) {
            if (itemLinkToUpdate.getWfStatus().getCategory().equals("Done")) {
                itemLinkToUpdate.setIsManuallyResolved(Boolean.valueOf(true));
                itemLinkToUpdate.setResolvedOn(new Date());
            } else {
                itemLinkToUpdate.setResolvedOn(null);
            }
            this.notificationService.startNotificationThread(itemLinkToUpdate, savedLink, "dependency_statuschange_template", Boolean.valueOf(false), "");
        }
        if (!(itemLinkToUpdate.getResponsible() == null && savedLink.getResponsible() == null || itemLinkToUpdate.getResponsible() != null && savedLink.getResponsible() != null && itemLinkToUpdate.getResponsible().getId().equals(savedLink.getResponsible().getId()))) {
            this.notificationService.startNotificationThread(itemLinkToUpdate, savedLink, "dependency_responsible_template", Boolean.valueOf(false), "");
            if (PropertyValidator.isValid((Object)savedLink.getResponsible())) {
                this.notificationService.startNotificationThread(itemLinkToUpdate, savedLink, "dependency_old_responsible_template", Boolean.valueOf(true), "");
            }
        }
        itemLinkToUpdate.setWatcherList(savedLink.getWatcherList());
        if (PropertyValidator.isValid((Object)itemLinkToUpdate.getAlmLinkId())) {
            List linkedAlmLinks = (List)this.almSyncService.syncKendisAndAlmLink((Object)itemLinkToUpdate);
            response.put("linkedAlmLinks", linkedAlmLinks);
        }
        this.itemLinkRepository.save((Object)itemLinkToUpdate);
        Item itemToUpdate = (Item)this.itemRepository.findOne((Serializable)((Object)item.getId()));
        response.put("link", itemLinkToUpdate);
        itemToUpdate.putLastUpdatedValue(Item.Actions.itemLinks.name(), (Object)itemToUpdate.getItemLinks());
        this.itemRepository.save((Object)itemToUpdate);
        itemToUpdate.setSessionBoards(itemToUpdate.getSessionBoards());
        response.put("item", itemToUpdate);
        HashMap<String, String> metaMapObject = new HashMap<String, String>();
        metaMapObject.put("type", "Links");
        metaMapObject.put("event", "UpdateLink");
        metaMapObject.put("boardId", boardId);
        metaMapObject.put("syncId", syncId);
        metaMapObject.put("link", (String)itemLinkToUpdate);
        metaMapObject.put("item", (String)itemToUpdate);
        Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).create();
        String metaMap = gsonExclusive.toJson(metaMapObject);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Links");
            pushJson.put("event", (Object)"UpdateLink");
            pushJson.put("metaMap", (Object)metaMap);
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/links"})
    @ResponseBody
    public ResponseEntity<Object> saveLinks(@RequestBody String requestBody) {
        try {
            Map response = this.piService.saveLinks(requestBody);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception ex) {
            LOGGER.debug(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/search/activities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getActvities(HttpServletRequest request, @RequestBody String requestPayload) {
        Gson g = new Gson();
        44 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
        if (request.getParameter("page") != null) {
            reqbody.put("page", request.getParameter("page"));
        } else {
            reqbody.put("page", 0);
        }
        reqbody.put("activies", this.planService.getActivitiesByTeamAndSprint((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (String)reqbody.get("teamId"), (String)reqbody.get("sprintId"), (Boolean)reqbody.get("isWebhook"), request.getParameter("page")));
        return new ResponseEntity((Object)reqbody, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-itemlink-history/{itemlinkId}/{zoneOffset}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemLinkHistory(@PathVariable(value="itemlinkId") String itemlinkId, @PathVariable String zoneOffset) {
        List historyList = this.getItemLinkHistoryList(itemlinkId, zoneOffset, Boolean.valueOf(false));
        return new ResponseEntity((Object)historyList, HttpStatus.OK);
    }

    public List<String> getItemLinkHistoryList(String itemlinkId, String zoneOffset, Boolean forEmail) {
        ArrayList<String> historyList = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        List itemList = this.itemLogRepository.findByItemIdAndItemTypeOrderByCreatedOnAsc(itemlinkId, "ItemLink");
        HashMap<String, Boolean> validFieldsMap = new HashMap<String, Boolean>();
        validFieldsMap.put("type", true);
        validFieldsMap.put("title", true);
        validFieldsMap.put("status", true);
        validFieldsMap.put("wfStatus", true);
        validFieldsMap.put("responsible", true);
        validFieldsMap.put("dueDate", true);
        validFieldsMap.put("raisedOn", true);
        validFieldsMap.put("reporter", true);
        validFieldsMap.put("description", true);
        HashMap<String, String> nameForFeilds = new HashMap<String, String>();
        nameForFeilds.put("type", "Type");
        nameForFeilds.put("title", "Title");
        nameForFeilds.put("status", "Status");
        nameForFeilds.put("wfStatus", "Statue");
        nameForFeilds.put("responsible", "Responsible");
        nameForFeilds.put("dueDate", "Target Resolution Date");
        nameForFeilds.put("raisedOn", "Raised On");
        nameForFeilds.put("reporter", "Reporter");
        nameForFeilds.put("description", "Description");
        HashMap previousValueMap = new HashMap();
        for (ItemLog item : itemList) {
            boolean anyActivity = false;
            String historyString = "";
            String jsonChanges = item.getChanges();
            if (jsonChanges == null || jsonChanges.equals("{}")) continue;
            Calendar cal = Calendar.getInstance();
            cal.setTime(item.getCreatedOn());
            cal.add(12, Integer.parseInt(zoneOffset));
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String strDate = dateFormat.format(cal.getTime());
            String eventType = item.getEventType().substring(0, 1).toUpperCase() + item.getEventType().substring(1).toLowerCase();
            if (!forEmail.booleanValue()) {
                historyString = historyString + "<div class='nm-dt'> " + eventType + " by <span class='by'>" + StringUtils.capitalize((String)item.getActivityBy()) + "</span> on " + strDate + "</div>";
            }
            ArrayList<String> historyLogs = new ArrayList<String>();
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                System.err.println(map);
                Iterator iterator = map.entrySet().iterator();
                boolean isFirstMapIter = true;
                ArrayList statusLogIndex = new ArrayList();
                while (iterator.hasNext()) {
                    Map.Entry pair = iterator.next();
                    if (validFieldsMap.get(pair.getKey()) == null) continue;
                    anyActivity = true;
                    String historyChange = " <div class='line prow '> ";
                    if (forEmail.booleanValue()) {
                        historyChange = historyChange + "&#8226;    ";
                    }
                    historyChange = historyChange + (String)nameForFeilds.get(pair.getKey());
                    if (pair.getKey().equals("status") || pair.getKey().equals("wfStatus") || pair.getKey().equals("responsible") || pair.getKey().equals("reporter")) {
                        String result = this.getLastHistory1(historyChange, pair, historyLogs, eventType, previousValueMap, statusLogIndex);
                        if (result == null) continue;
                        historyChange = result;
                    } else {
                        Date parsedDate;
                        SimpleDateFormat formatter;
                        String value = (String)pair.getValue();
                        if (pair.getKey().equals("dueDate")) {
                            formatter = new SimpleDateFormat("MMM d, yyyy H:mm:ss a");
                            parsedDate = null;
                            try {
                                parsedDate = formatter.parse(value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            formatter = new SimpleDateFormat("d MMM yyyy");
                            value = formatter.format(parsedDate);
                        } else if (pair.getKey().equals("raisedOn")) {
                            formatter = new SimpleDateFormat("MMM d, yyyy H:mm:ss a");
                            parsedDate = null;
                            try {
                                parsedDate = formatter.parse(value);
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            formatter = new SimpleDateFormat("d MMM yyyy");
                            value = formatter.format(parsedDate);
                        }
                        historyChange = historyChange + "<span class='b'> changed to \"" + value + "\"</span>";
                    }
                    historyChange = historyChange + " </div> ";
                    historyLogs.add(historyChange);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            for (String log : historyLogs) {
                historyString = historyString + log;
            }
            if (anyActivity) {
                historyList.add(historyString);
            }
            if (!forEmail.booleanValue()) continue;
            break;
        }
        return historyList;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String getLastHistory1(String historyChange, Map.Entry pair, ArrayList<String> historyLogs, String eventType, HashMap<String, ArrayList<String>> previousValueMap, ArrayList<Integer> statusLogIndex) {
        String key = (String)pair.getKey();
        String value = "";
        if (key.equals("status")) {
            value = (String)pair.getValue();
        } else {
            Map objectMap = (Map)pair.getValue();
            value = this.getObjectTitle(key, objectMap);
        }
        String finalString = " changed ";
        if (eventType.equals("Created")) {
            void var10_12;
            finalString = finalString + "to \"" + value + "\"";
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                previousValueMap.put(key, arrayList2);
            }
            var10_12.add(value);
            if (!key.equals("status") && !key.equals("wfStatus")) {
                return historyChange + finalString;
            }
            if (statusLogIndex.size() == 0) {
                historyChange = historyChange + finalString;
                statusLogIndex.add(historyLogs.size());
                return historyChange;
            }
            if (!key.equals("wfStatus")) return historyChange;
            historyChange = historyChange + finalString;
            historyChange = historyChange + " </div> ";
            historyLogs.set(statusLogIndex.get(statusLogIndex.size() - 1), historyChange);
            return null;
        }
        if (key.equals("wfStatus")) {
            void var10_15;
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList3 = new ArrayList();
                previousValueMap.put(key, arrayList3);
            }
            if (var10_15.size() > 0) {
                finalString = finalString + "from \"" + (String)var10_15.get(var10_15.size() - 1) + "\"";
                finalString = finalString + " to \"" + value + "\"";
            } else {
                ArrayList<String> previousValuesStatus = previousValueMap.get("status");
                if (previousValuesStatus.size() > 0) {
                    finalString = finalString + "from \"" + previousValuesStatus.get(previousValuesStatus.size() - 1) + "\"";
                    finalString = finalString + " to \"" + value + "\"";
                } else {
                    finalString = finalString + "to \"" + value + "\"";
                }
            }
            var10_15.add(value);
        } else {
            void var10_18;
            ArrayList<String> arrayList = previousValueMap.get(key);
            if (arrayList == null) {
                ArrayList arrayList4 = new ArrayList();
                previousValueMap.put(key, arrayList4);
            }
            if (var10_18.size() > 0) {
                finalString = finalString + "from \"" + (String)var10_18.get(var10_18.size() - 1) + "\"";
                finalString = finalString + " to \"" + value + "\"";
            } else {
                finalString = finalString + "to \"" + value + "\"";
            }
        }
        if (!key.equals("status") && !key.equals("wfStatus")) {
            return historyChange + finalString;
        }
        if (statusLogIndex.size() != 0) return null;
        historyChange = historyChange + finalString;
        statusLogIndex.add(historyLogs.size());
        return historyChange;
    }

    private String getLastHistory(Map.Entry mapPair, List<ItemLog> itemList, ItemLog item) {
        String oldId = "";
        String oldTitle = "";
        String history = " changed ";
        String lastStatus = "";
        String type = (String)mapPair.getKey();
        ObjectMapper mapper = new ObjectMapper();
        boolean startCheck = false;
        boolean breakLoop = false;
        for (ItemLog itemLog : itemList) {
            String jsonChanges;
            if (breakLoop) break;
            if (itemLog.getId().equals(item.getId())) {
                startCheck = true;
                continue;
            }
            if (!startCheck || (jsonChanges = itemLog.getChanges()) == null) continue;
            try {
                Map map = (Map)mapper.readValue(jsonChanges, Map.class);
                for (Map.Entry pair : map.entrySet()) {
                    if (!pair.getKey().equals(type)) continue;
                    if (type.equals("responsible") || type.equals("reporter")) {
                        Map map2 = (Map)pair.getValue();
                        history = history + "from \"" + this.getObjectTitle(type, map2) + "\"";
                    } else {
                        String value = (String)pair.getValue();
                        history = history + "from \"" + value + "\"";
                    }
                    breakLoop = true;
                }
            }
            catch (IOException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        if (type.equals("responsible") || type.equals("reporter") || type.equals("wfStatus")) {
            Map map2 = (Map)mapPair.getValue();
            history = history + " to \"" + this.getObjectTitle(type, map2) + "\"";
        } else {
            String value = (String)mapPair.getValue();
            history = history + " to \"" + value + "\"";
        }
        return history;
    }

    private String getObjectTitle(String type, Map<Object, Object> map) {
        Status status;
        String id;
        User responsible;
        if ((type.equals("responsible") || type.equals("reporter")) && (responsible = (User)this.userRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return responsible.getFullName();
        }
        if (type.equals("wfStatus") && (status = (Status)this.statusRepository.findOne((Serializable)((Object)(id = (String)map.get("id"))))) != null) {
            return status.getTitle();
        }
        return null;
    }

    @RequestMapping(value={"/update-autoUpdateEnabledStates"})
    public ResponseEntity<Object> updateAutoUpdateEnabledStates(@RequestBody Session request) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)request.getId()));
        if (PropertyValidator.isValid((Object)session)) {
            session.setAutoUpdateEnabledStates(request.getAutoUpdateEnabledStates());
            this.sessionRepository.save((Object)session);
            responseJson.put("success", true);
            responseJson.put("session", (Boolean)session);
        } else {
            responseJson.put("success", false);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/basic/save"})
    public ResponseEntity<Object> saveBasicSettings(@RequestBody HashMap<String, Object> request) {
        String sessionStr = (String)request.get("session");
        String metaMap = (String)request.get("metaMap");
        String piSessionId = (String)request.get("piSessionId");
        String teamSprintDependencyLimitStr = (String)request.get("teamSprintDependencyLimit");
        String mappingsStr = null;
        List mappings = null;
        if (request.containsKey("mappings")) {
            mappingsStr = (String)request.get("mappings");
        }
        ObjectMapper mapper = new ObjectMapper();
        List TeamSprintDependencyLimitList = null;
        try {
            Session session = (Session)mapper.readValue(sessionStr, Session.class);
            if (mappingsStr != null) {
                mappings = (List)mapper.readValue(mappingsStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            Session savedSession = (Session)this.sessionRepository.findOne((Serializable)((Object)session.getId()));
            savedSession.setTitle(session.getTitle());
            savedSession.setPrefix(session.getPrefix());
            savedSession.setPrefixColor(session.getPrefixColor());
            savedSession.setParentItem(session.getParentItem());
            savedSession.setChildItem(session.getChildItem());
            savedSession.setParentItems(session.getParentItems());
            savedSession.setChildItems(session.getChildItems());
            savedSession.setSprintLabel(session.getSprintLabel());
            savedSession.setSprintsLabel(session.getSprintsLabel());
            savedSession.setTeamLabel(session.getTeamLabel());
            savedSession.setTeamsLabel(session.getTeamsLabel());
            savedSession.setParentItemColor(session.getParentItemColor());
            savedSession.setChildItemColor(session.getChildItemColor());
            savedSession.setParentItemTextColor(session.getParentItemTextColor());
            savedSession.setChildItemTextColor(session.getChildItemTextColor());
            savedSession.setJiraBaseURL(session.getJiraBaseURL());
            savedSession.setStartDate(session.getStartDate());
            savedSession.setEndDate(session.getEndDate());
            savedSession.setPlanningStartDate(session.getPlanningStartDate());
            savedSession.setPlanningEndDate(session.getPlanningEndDate());
            savedSession.setStartDateAction(session.getStartDateAction());
            savedSession.setTeamFieldEnable(session.getTeamFieldEnable());
            savedSession.setTeamFieldTeamName(session.getTeamFieldTeamName());
            savedSession.setTeamFieldTeamRefrence(session.getTeamFieldTeamRefrence());
            savedSession.setItemParent(session.getItemParent());
            savedSession.setJiraDependencyEnabled(session.getJiraDependencyEnabled());
            savedSession.setJiraFeatureParentEnabled(session.getJiraFeatureParentEnabled());
            savedSession.setJiraFeatureParentIssueType(session.getJiraFeatureParentIssueType());
            savedSession.setJiraFeatureParentLinkType(session.getJiraFeatureParentLinkType());
            savedSession.setAreaPathDisabled(session.getAreaPathDisabled());
            savedSession.setJiraLinkTypes(session.getJiraLinkTypes());
            savedSession.setItemLinkStatusDependentOn(session.getItemLinkStatusDependentOn());
            savedSession.setReOpenDependencyIfItemReOpen(session.getReOpenDependencyIfItemReOpen());
            savedSession.setSubItemLinkStatusDependentOn(session.getSubItemLinkStatusDependentOn());
            savedSession.setReOpenDependencyIfSubItemReOpen(session.getReOpenDependencyIfSubItemReOpen());
            savedSession.setDependencyReceiveLimit(session.getDependencyReceiveLimit());
            savedSession.setReadOnlyWithOutALMProfile(session.getReadOnlyWithOutALMProfile());
            savedSession.setWsjfEnabled(session.getWsjfEnabled());
            savedSession.setHidePiJourney(session.getHidePiJourney());
            savedSession.setwsjfAlmEnabled(session.getwsjfAlmEnabled());
            savedSession.setWsjfKendisEnabled(session.getWsjfKendisEnabled());
            savedSession.setwsjfAlmFieldKey(session.getwsjfAlmFieldKey());
            savedSession.setSetWsjfAlmFieldForAllProjects(session.getSetWsjfAlmFieldForAllProjects());
            savedSession.setStartDateAction(session.getStartDateAction());
            savedSession.setLineArrowDirection(session.getLineArrowDirection());
            savedSession.setReverseDependencyDirection(session.getReverseDependencyDirection());
            savedSession.setWsjfWithMappingEnabled(session.getWsjfWithMappingEnabled());
            savedSession.setKendisOnlyLayout(session.getKendisOnlyLayout());
            savedSession.setKendisOnlyCreateEnabled(session.getKendisOnlyCreateEnabled());
            savedSession.setBucketEnabled(session.getBucketEnabled());
            savedSession.setBuckets(session.getBuckets());
            savedSession.setKendisLinkTypeDisabled(session.getKendisLinkTypeDisabled());
            savedSession.setHideMilestonesBar(session.getHideMilestonesBar());
            savedSession.setMilestoneWidgetHeader(session.getMilestoneWidgetHeader());
            if (PropertyValidator.isValid((Object)savedSession.getSetWsjfAlmFieldForAllProjects()) && savedSession.getSetWsjfAlmFieldForAllProjects().booleanValue()) {
                String tfsProjectIds = (String)request.get("tfsProjectIds");
                this.setWsjfFieldForTfsProjects(tfsProjectIds, savedSession);
            }
            this.aLMSyncService.createScoreCard(session, savedSession);
            if (mappings != null) {
                this.aLMSyncService.saveMappings(session, mappings);
            }
            this.sessionRepository.save((Object)savedSession);
            this.customRepositoryImpl.addItemsAsBuckets(savedSession);
            if (teamSprintDependencyLimitStr != null) {
                TeamSprintDependencyLimitList = (List)mapper.readValue(teamSprintDependencyLimitStr, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, TeamSprintDependencyLimit.class));
                TeamSprintDependencyLimitList = this.teamSprintDependencyLimitRepository.save((Iterable)TeamSprintDependencyLimitList);
            }
            AuditLog auditLogObject = new AuditLog(piSessionId, "BOARD_ADD_DEL");
            this.auditLogRepository.save((Object)auditLogObject);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setWsjfFieldForTfsProjects(String tfsProjectIds, Session savedSession) {
        ArrayList<String> tfsProjectIdsList = new ArrayList<String>(Arrays.asList(tfsProjectIds.split(",")));
        List tfsProject = (List)this.tfsProjectRepository.findAll(tfsProjectIdsList);
        tfsProject.forEach(project -> project.setWsjfAlmField(savedSession.getwsjfAlmFieldKey()));
        this.tfsProjectRepository.save((Iterable)tfsProject);
    }

    @RequestMapping(value={"/team/add"})
    public ResponseEntity<Object> addTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        String teamStr = (String)payload.get("team");
        String metaMap = (String)payload.get("metaMap");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        try {
            ObjectMapper mapper = new ObjectMapper();
            Team team = (Team)mapper.readValue(teamStr, Team.class);
            if (payload.containsKey("workSpace")) {
                String workSpaceId = (String)payload.get("workSpace");
                team.setWorkSpaces(new ArrayList());
                WorkSpace workspace = new WorkSpace();
                workspace.setId(workSpaceId);
                team.getWorkSpaces().add(workspace);
            }
            Team savedTeam = null;
            if (PropertyValidator.isValid((Object)team.getId())) {
                savedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
                savedTeam.setWorkSpaces(team.getWorkSpaces());
                savedTeam = (Team)this.teamRepository.save((Object)savedTeam);
                responseJson.put("newTeam", false);
            } else {
                if (team.getWorkSpaces() != null && !team.getWorkSpaces().isEmpty()) {
                    String workspaceId = ((WorkSpace)team.getWorkSpaces().get(0)).getId();
                    Team existingTeam = this.teamRepository.findByTitleIgnoreCase(team.getTitle());
                    if (existingTeam != null) {
                        LOGGER.warn("Attempt to create duplicate team '{}' in workspace '{}'", (Object)team.getTitle(), (Object)workspaceId);
                        responseJson.put("success", false);
                        responseJson.put("error", "TEAM_NAME_EXISTS");
                        responseJson.put("message", "A team with the name '" + team.getTitle() + "' already exists.");
                        return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                    }
                }
                savedTeam = (Team)this.teamRepository.save((Object)team);
                responseJson.put("newTeam", true);
            }
            if (PropertyValidator.isValid((Object)sessionBoardId)) {
                SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                ArrayList<Team> teams = sessionBoard.getTeams();
                if (!PropertyValidator.isValid((Collection)teams)) {
                    teams = new ArrayList<Team>();
                }
                for (Team t : sessionBoard.getTeams()) {
                    if (!t.getId().equals(savedTeam.getId())) continue;
                    responseJson.put("success", false);
                    responseJson.put("reason", "AlreadyExist");
                    return new ResponseEntity(responseJson, HttpStatus.OK);
                }
                teams.add(savedTeam);
                sessionBoard.setTeams(teams);
                if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence())) {
                    sessionBoard.setTeamSequence((String[])ArrayUtils.add((Object[])sessionBoard.getTeamSequence(), (int)sessionBoard.getTeamSequence().length, (Object)savedTeam.getId()));
                } else {
                    String[] teamSequence = new String[]{savedTeam.getId()};
                    sessionBoard.setTeamSequence(teamSequence);
                }
                this.almSyncService.updateTeamSprintDependencyOnAddTeam(sessionBoard, savedTeam);
                this.sessionBoardRepository.save((Object)sessionBoard);
                responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            }
            if (PropertyValidator.isValid((Object)savedTeam)) {
                responseJson.put("success", true);
                responseJson.put("data", savedTeam);
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("isTFS", true);
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
            }
            AuditLog auditLogObject = new AuditLog((String)payload.get("sessionBoardId"), "TEAM_ADD", null);
            auditLogObject.setEventText("Team " + savedTeam.getTitle() + " added");
            this.auditLogRepository.save((Object)auditLogObject);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/save"})
    public ResponseEntity<Object> saveTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson;
        block9: {
            responseJson = new HashMap<String, Boolean>();
            responseJson.put("success", false);
            String teamStr = (String)payload.get("team");
            String metaMap = (String)payload.get("metaMap");
            try {
                ObjectMapper mapper = new ObjectMapper();
                Team team = (Team)mapper.readValue(teamStr, Team.class);
                Team savedTeam = null;
                if (PropertyValidator.isValid((Object)team) && PropertyValidator.isValid((Object)team.getId())) {
                    savedTeam = (Team)this.teamRepository.findOne((Serializable)((Object)team.getId()));
                    boolean titleUpdated = false;
                    if (PropertyValidator.isValid((Object)team.getTitle()) && !team.getTitle().equals(savedTeam.getTitle())) {
                        savedTeam.setTitle(team.getTitle());
                        titleUpdated = true;
                    }
                    if (PropertyValidator.isValid((Object)team.getLabel())) {
                        savedTeam.setLabel(team.getLabel());
                    }
                    if (PropertyValidator.isValid((Object)team.getColor())) {
                        savedTeam.setColor(team.getColor());
                    }
                    savedTeam.setWorkSpaces(team.getWorkSpaces());
                    if (PropertyValidator.isValid((Object)team.getSequence())) {
                        savedTeam.setSequence(team.getSequence());
                    }
                    savedTeam = (Team)this.teamRepository.save((Object)savedTeam);
                    boolean titleUpdatedFlag = titleUpdated;
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                }
                if (!PropertyValidator.isValid(savedTeam)) break block9;
                JSONObject pushJson = new JSONObject();
                try {
                    pushJson.put("isTFS", true);
                    pushJson.put("metaMap", (Object)metaMap);
                    PushSender.sendMsg((String)pushJson.toString());
                }
                catch (JSONException e) {
                    LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                }
                responseJson.put("success", true);
                responseJson.put("data", (Boolean)savedTeam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/teams/bulk-create"}, method={RequestMethod.POST})
    public ResponseEntity<Object> bulkCreateTeams(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List teamsData = (List)payload.get("teams");
            if (!PropertyValidator.isValid((Collection)teamsData)) {
                responseJson.put("success", false);
                responseJson.put("message", "Teams data is required");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            ArrayList<String> teamTitles = new ArrayList<String>();
            for (Object teamData : teamsData) {
                String title = (String)((HashMap)teamData).get("title");
                if (teamTitles.contains(title)) {
                    responseJson.put("success", false);
                    responseJson.put("error", "TEAM_NAME_EXISTS");
                    responseJson.put("message", "A team with the name '" + title + "' already exists in your selection");
                    return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                }
                teamTitles.add(title);
            }
            ArrayList<String> teamsTfsIds = new ArrayList<String>();
            for (HashMap teamData : teamsData) {
                String tfsId = (String)teamData.get("tfsId");
                teamsTfsIds.add(tfsId);
            }
            List existingTeams = this.teamRepository.findByTfsIdIn(teamsTfsIds);
            HashMap<String, Team> teamsMapByTfsId = new HashMap<String, Team>();
            if (PropertyValidator.isValid((Collection)existingTeams)) {
                for (Team team : existingTeams) {
                    teamsMapByTfsId.put(team.getTfsId(), team);
                }
            }
            List<Team> teamsToSave = new ArrayList();
            for (HashMap teamData : teamsData) {
                String tfsId = (String)teamData.get("tfsId");
                String title = (String)teamData.get("title");
                String color = (String)teamData.get("color");
                String label = (String)teamData.get("label");
                String tfsProjectId = (String)teamData.get("tfsProjectId");
                String workSpace = (String)teamData.get("workSpace");
                Team existingTeamWithTitle = this.teamRepository.findByTitleIgnoreCase(title);
                if (existingTeamWithTitle != null) {
                    responseJson.put("success", false);
                    responseJson.put("error", "TEAM_NAME_EXISTS");
                    responseJson.put("message", "A team with the name '" + title + "' already exists");
                    return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
                }
                Team team = (Team)teamsMapByTfsId.get(tfsId);
                if (team == null) {
                    team = new Team();
                }
                team.setTitle(title);
                team.setTfsId(tfsId);
                team.setColor(color);
                team.setLabel(label);
                team.setTfsProjectId(tfsProjectId);
                if (teamData.containsKey("workSpace")) {
                    WorkSpace existing;
                    if (team.getWorkSpaces() == null) {
                        team.setWorkSpaces(new ArrayList());
                    }
                    if ((existing = (WorkSpace)team.getWorkSpaces().stream().filter(wo -> wo.getId().equals(workSpace)).findAny().orElse(null)) == null) {
                        WorkSpace ws = new WorkSpace();
                        ws.setId(workSpace);
                        team.getWorkSpaces().add(ws);
                    }
                }
                teamsToSave.add(team);
            }
            teamsToSave = this.teamRepository.save(teamsToSave);
            responseJson.put("success", true);
            responseJson.put("teams", teamsToSave);
        }
        catch (Exception e) {
            LOGGER.error("Error in bulkCreateOrFetchTeams: " + com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            responseJson.put("message", "Error processing teams: " + e.getMessage());
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/team/delete"})
    public ResponseEntity<Object> deleteTeam(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        responseJson.put("success", false);
        try {
            String metaMap = (String)payload.get("metaMap");
            String teamId = (String)payload.get("teamId");
            String sessionBoardId = (String)payload.get("sessionBoardId");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            int index = sessionBoard.getTeams().indexOf(new Team(teamId));
            Team team = null;
            if (index > -1) {
                team = (Team)sessionBoard.getTeams().remove(index);
            }
            if (PropertyValidator.isValid((Object)sessionBoardId)) {
                List teamMappings;
                TFSAlmConfigurations configurations = null;
                if (PropertyValidator.isValid((Object)sessionBoard.getSession().getTfsAlmConfigurations()) && PropertyValidator.isValid((Collection)(teamMappings = (configurations = sessionBoard.getSession().getTfsAlmConfigurations()).getTeamMappings()))) {
                    int teamMappingsLength = teamMappings.size();
                    for (int i = 0; i < teamMappingsLength; ++i) {
                        if (!((TFSTeamMapping)teamMappings.get(i)).getKendisTeamId().equals(teamId)) continue;
                        teamMappings.remove(i);
                        break;
                    }
                    if (teamMappings.size() == 0) {
                        configurations.setTeamMappings(null);
                    } else {
                        configurations.setTeamMappings(teamMappings);
                    }
                }
                this.teamSprintDependencyLimitRepository.deleteBySessionIdAndTeamId(sessionBoard.getSession().getId(), teamId);
                List teamContainersToBeDeleted = this.teamContainerRepository.findByTeamAndContainerIn(new Team(teamId), sessionBoard.getContainers());
                if (PropertyValidator.isValid((Collection)teamContainersToBeDeleted)) {
                    List items = this.itemRepository.findByTeamContainersIn(teamContainersToBeDeleted);
                    if (PropertyValidator.isValid((Collection)items)) {
                        for (Item item : items) {
                            ArrayList<TeamContainer> deletedTCs = new ArrayList<TeamContainer>();
                            for (TeamContainer tc : item.getTeamContainers()) {
                                TeamContainer deletedTC = teamContainersToBeDeleted.stream().filter(lt -> lt.getId().equals(tc.getId())).findAny().orElse(null);
                                if (!PropertyValidator.isValid((Object)deletedTC)) continue;
                                deletedTCs.add(deletedTC);
                            }
                            item.getTeamContainers().removeAll(deletedTCs);
                        }
                        this.itemRepository.save((Iterable)items);
                    }
                    this.teamContainerRepository.delete((Iterable)teamContainersToBeDeleted);
                    ArrayList teamContainerIds = new ArrayList();
                    teamContainersToBeDeleted.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                    List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn(teamContainerIds, teamContainerIds);
                    if (PropertyValidator.isValid((Collection)itemLinks)) {
                        items = this.itemRepository.findByItemLinksIn(itemLinks);
                        if (PropertyValidator.isValid((Collection)items)) {
                            for (int i = 0; i < items.size(); ++i) {
                                List savedItemLinks;
                                List deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                                for (int j = 0; j < savedItemLinks.size(); ++j) {
                                    int tcIndex = j;
                                    ItemLink it = itemLinks.stream().filter(lt -> lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId())).findAny().orElse(null);
                                    if (!PropertyValidator.isValid((Object)it)) continue;
                                    deletedItemLinks.remove(j);
                                }
                                ((Item)items.get(i)).setItemLinks(deletedItemLinks);
                            }
                            this.itemRepository.save((Iterable)items);
                        }
                        KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                    }
                }
                this.itemSyncMapperRepository.deleteBySessionBoardAndTeam(sessionBoard, new Team(teamId));
                sessionBoard.getTeams().remove(new Team(teamId));
                if (PropertyValidator.isValid((String[])sessionBoard.getTeamSequence()) && ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId) > -1) {
                    sessionBoard.setTeamSequence((String[])ArrayUtils.remove((Object[])sessionBoard.getTeamSequence(), (int)ArrayUtils.indexOf((Object[])sessionBoard.getTeamSequence(), (Object)teamId)));
                }
                this.tfsAlmConfigurationsRepository.save((Object)configurations);
                List riskLinkToBeDeleted = this.riskRepository.findAll();
                for (Risk risk : riskLinkToBeDeleted) {
                    boolean found = false;
                    List boardTeams = risk.getBoardTeams();
                    if (boardTeams == null) continue;
                    Iterator itr = boardTeams.iterator();
                    while (itr.hasNext()) {
                        BoardTeam bT = (BoardTeam)itr.next();
                        if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getTeamId().equalsIgnoreCase(teamId)) continue;
                        itr.remove();
                        found = true;
                    }
                    if (!found) continue;
                    this.riskRepository.save((Object)risk);
                }
                this.sessionBoardRepository.save((Object)sessionBoard);
                responseJson.put("teamSequence", sessionBoard.getTeamSequence());
            }
            this.piJourneyBoardService.updateTeamBreakoutOnTeamRemove(sessionBoard.getSession().getId(), teamId);
            AuditLog auditLogObject = new AuditLog((String)payload.get("sessionBoardId"), "TEAM_REMOVED", null);
            auditLogObject.setEventText("Team " + team.getTitle() + " removed");
            this.auditLogRepository.save((Object)auditLogObject);
            responseJson.put("teamId", teamId);
            responseJson.put("success", true);
            JSONObject pushJson = new JSONObject();
            try {
                pushJson.put("isTFS", true);
                pushJson.put("metaMap", (Object)metaMap);
                PushSender.sendMsg((String)pushJson.toString());
            }
            catch (JSONException e) {
                LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            }
        }
        catch (Exception e) {
            responseJson.put("error", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/ipsprint/{boardId}/{sprintId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> markIPSprint(@PathVariable(value="boardId") String boardId, @PathVariable(value="sprintId") String sprintId) {
        HashMap responseJson = new HashMap();
        if (PropertyValidator.isValid((Object)boardId)) {
            Container container2;
            SessionBoard board = this.customRepository.getSessionBoardbyId(boardId);
            board.getContainers().forEach(container -> container.setIsIPSprint(Boolean.valueOf(false)));
            this.containerRepository.save((Iterable)board.getContainers());
            if (PropertyValidator.isValid((Object)sprintId) && !sprintId.equals("undefined") && PropertyValidator.isValid((Object)(container2 = (Container)board.getContainers().stream().filter(sprint -> sprint.getId().equals(sprintId)).findAny().orElse(null)))) {
                container2.setIsIPSprint(Boolean.valueOf(true));
                this.containerRepository.save((Object)container2);
            }
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void updatePiBoardOnSprintDateChange(Session session, SessionBoard sessionBoard) {
        if (PropertyValidator.isValid((Object)session.isAutoFillStartEndDate()) && session.isAutoFillStartEndDate()) {
            Date smallestDate = null;
            Date largestDate = null;
            for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                Container sprint = (Container)sessionBoard.getContainers().get(i);
                if (PropertyValidator.isValid((Object)sprint.getStartDate())) {
                    if (smallestDate == null) {
                        smallestDate = sprint.getStartDate();
                    } else if (sprint.getStartDate().getTime() < smallestDate.getTime()) {
                        smallestDate = sprint.getStartDate();
                    }
                }
                if (!PropertyValidator.isValid((Object)sprint.getEndDate())) continue;
                if (largestDate == null) {
                    largestDate = sprint.getEndDate();
                    continue;
                }
                if (sprint.getEndDate().getTime() <= largestDate.getTime()) continue;
                largestDate = sprint.getEndDate();
            }
            if (PropertyValidator.isValid(smallestDate)) {
                session.setStartDate(smallestDate);
            }
            if (PropertyValidator.isValid(largestDate)) {
                session.setEndDate(largestDate);
            }
        }
    }

    @RequestMapping(value={"/piboardupdatedate"})
    public ResponseEntity<Object> updatePiBoardDate(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            String sessionBoardId = (String)payload.get("sessionBoardId");
            Boolean autoFillStartEndDate = (Boolean)payload.get("autoFillStartEndDate");
            Boolean manualUpdate = (Boolean)payload.get("manualUpdate");
            boolean setAutoFil = false;
            if (autoFillStartEndDate != null) {
                setAutoFil = true;
            }
            if (manualUpdate == null) {
                manualUpdate = false;
            }
            SessionBoard sessionBoard = this.sessionBoardRepository.findById(sessionBoardId);
            Session session = sessionBoard.getSession();
            if (setAutoFil) {
                session.setAutoFillStartEndDate(autoFillStartEndDate.booleanValue());
            }
            if (autoFillStartEndDate == null) {
                autoFillStartEndDate = Boolean.FALSE;
            }
            this.updatePiBoardOnSprintDateChange(session, sessionBoard);
            if (manualUpdate.booleanValue()) {
                SimpleDateFormat dateFormat;
                if (payload.containsKey("startDate")) {
                    String startDateStr = (String)payload.get("startDate");
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    Date startDate = dateFormat.parse(startDateStr);
                    session.setStartDate(startDate);
                }
                if (payload.containsKey("endDate")) {
                    String endDateStr = (String)payload.get("endDate");
                    dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    Date endDate = dateFormat.parse(endDateStr);
                    session.setEndDate(endDate);
                }
            }
            this.sessionRepository.save((Object)session);
            responseJson.put("success", true);
            responseJson.put("session", (Boolean)session);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/savesequence"})
    public ResponseEntity<Object> saveContainerSequence(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        String containerId = (String)payload.get("containerId");
        String sequenceStr = (String)payload.get("sequence");
        try {
            double sequence = Double.parseDouble(sequenceStr);
            Container container = this.containerRepository.findById(containerId);
            if (PropertyValidator.isValid((Object)container)) {
                container.setSequence(Double.valueOf(sequence));
                responseJson.put("success", true);
                container = (Container)this.containerRepository.save((Object)container);
                responseJson.put("container", (Boolean)container);
            }
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/container/save"})
    public ResponseEntity<Object> saveContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        responseJson.put("success", false);
        String containerStr = (String)payload.get("container");
        String metaMap = (String)payload.get("metaMap");
        String sessionBoardId = (String)payload.get("sessionBoardId");
        SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
        LOGGER.info("BEFORE Going to save sprint");
        long currTime = System.currentTimeMillis();
        try {
            if (PropertyValidator.isValid(payload)) {
                ObjectMapper mapper = new ObjectMapper();
                Container container = (Container)mapper.readValue(containerStr, Container.class);
                Container savedContainer = null;
                if (PropertyValidator.isValid((Object)container.getId())) {
                    savedContainer = (Container)this.containerRepository.findOne((Serializable)((Object)container.getId()));
                    boolean titleUpdated = false;
                    if (PropertyValidator.isValid((Object)container.getTitle()) && !container.getTitle().equals(savedContainer.getTitle())) {
                        savedContainer.setTitle(container.getTitle());
                        titleUpdated = true;
                    }
                    if (PropertyValidator.isValid((Object)container.getLabel())) {
                        savedContainer.setLabel(container.getLabel());
                    }
                    if (PropertyValidator.isValid((Object)container.getSequence())) {
                        savedContainer.setSequence(container.getSequence());
                    }
                    savedContainer.setStartDate(container.getStartDate());
                    savedContainer.setEndDate(container.getEndDate());
                    ArrayList<Container> sprints = new ArrayList<Container>();
                    if (Boolean.TRUE.equals(sessionBoard.getTzEnabled())) {
                        sprints.add(savedContainer);
                        sessionBoard.calcSchedulerTime(null, sprints);
                    }
                    String uname = UserContextUtil.getUserContext().getLoggedInUser().getUserName();
                    savedContainer = (Container)this.containerRepository.save((Object)savedContainer);
                    boolean titleUpdatedFlag = titleUpdated;
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                } else {
                    savedContainer = (Container)this.containerRepository.save((Object)container);
                    if (PropertyValidator.isValid((Object)sessionBoardId)) {
                        ArrayList<Container> containers = sessionBoard.getContainers();
                        if (!PropertyValidator.isValid((Collection)containers)) {
                            containers = new ArrayList<Container>();
                        }
                        containers.add(savedContainer);
                        sessionBoard.setContainers(containers);
                        this.sessionBoardRepository.save((Object)sessionBoard);
                        Session session = sessionBoard.getSession();
                        this.almSyncService.updateTeamSprintDependencyOnAddContainer(sessionBoard, savedContainer);
                        TFSAlmConfigurations almConfiguration = session.getTfsAlmConfigurations();
                        ArrayList<ItemSyncMapper> itemSyncMappers = new ArrayList<ItemSyncMapper>();
                        if (PropertyValidator.isValid((Object)almConfiguration) && PropertyValidator.isValid((Collection)almConfiguration.getTeamMappings())) {
                            for (TFSTeamMapping teamMap : almConfiguration.getTeamMappings()) {
                                ItemSyncMapper itemSyncMapper = new ItemSyncMapper();
                                itemSyncMapper.setCreateNewInJira(Boolean.valueOf(true));
                                SessionBoard sb = new SessionBoard();
                                sb.setId(sessionBoard.getId());
                                itemSyncMapper.setSessionBoard(sb);
                                Container cont = new Container();
                                Team team = new Team();
                                team.setId(teamMap.getKendisTeamId());
                                cont.setId(savedContainer.getId());
                                itemSyncMapper.setContainer(cont);
                                itemSyncMapper.setTeam(team);
                                itemSyncMapper.setTfsProjectId(teamMap.getTfsProjectTfsId());
                                itemSyncMappers.add(itemSyncMapper);
                            }
                        }
                        if (PropertyValidator.isValid(itemSyncMappers)) {
                            this.itemSyncMapperRepository.save(itemSyncMappers);
                        }
                        this.piJourneyBoardService.updateTeamCapacityOnAddSprint(sessionBoard, savedContainer);
                    }
                    responseJson.put("newContainer", true);
                    AuditLog auditLogObject = new AuditLog(sessionBoardId, "CONTAINER_ADD", null);
                    auditLogObject.setEventText("Sprint " + savedContainer.getTitle() + " added");
                    this.auditLogRepository.save((Object)auditLogObject);
                }
                SessionBoard _sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
                this.updateComingSprintDate(savedContainer, _sessionBoard, responseJson);
                if (PropertyValidator.isValid((Object)savedContainer)) {
                    responseJson.put("success", true);
                    responseJson.put("data", (Boolean)savedContainer);
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("isTFS", true);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    private void updateComingSprintDate(Container savedContainer, SessionBoard sessionBoard, HashMap<String, Object> response) throws Exception {
        if (PropertyValidator.isValid((Object)savedContainer.getStartDate()) && PropertyValidator.isValid((Object)savedContainer.getEndDate()) && PropertyValidator.isValid((Collection)sessionBoard.getContainers())) {
            Calendar calendar;
            sessionBoard.getContainers().sort(Comparator.comparing(Container::getSequence));
            Calendar calender = Calendar.getInstance();
            calender.setTime(savedContainer.getEndDate());
            int dayOfWeek = calender.get(7);
            long diff = savedContainer.getEndDate().getTime() - savedContainer.getStartDate().getTime();
            long daysDifference = diff / 1000L / 60L / 60L / 24L;
            boolean isNextToUpdatedSprint = false;
            Date startDateForNextSprint = savedContainer.getEndDate();
            if (dayOfWeek == 6) {
                calendar = Calendar.getInstance();
                calendar.setTime(startDateForNextSprint);
                calendar.add(5, 3);
                startDateForNextSprint = calendar.getTime();
            } else if (dayOfWeek == 7) {
                calendar = Calendar.getInstance();
                calendar.setTime(startDateForNextSprint);
                calendar.add(5, 2);
                startDateForNextSprint = calendar.getTime();
            } else {
                calendar = Calendar.getInstance();
                calendar.setTime(startDateForNextSprint);
                calendar.add(5, 1);
                startDateForNextSprint = calendar.getTime();
            }
            ArrayList<Container> containersToSave = new ArrayList<Container>();
            for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                Container currentSprint = (Container)sessionBoard.getContainers().get(i);
                if (isNextToUpdatedSprint) {
                    currentSprint.setStartDate(startDateForNextSprint);
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(startDateForNextSprint);
                    calendar2.add(5, (int)daysDifference);
                    startDateForNextSprint = calendar2.getTime();
                    currentSprint.setEndDate(startDateForNextSprint);
                    calender = Calendar.getInstance();
                    calender.setTime(startDateForNextSprint);
                    dayOfWeek = calender.get(7);
                    if (dayOfWeek == 6) {
                        calendar2 = Calendar.getInstance();
                        calendar2.setTime(startDateForNextSprint);
                        calendar2.add(5, 3);
                        startDateForNextSprint = calendar2.getTime();
                    } else if (dayOfWeek == 7) {
                        calendar2 = Calendar.getInstance();
                        calendar2.setTime(startDateForNextSprint);
                        calendar2.add(5, 2);
                        startDateForNextSprint = calendar2.getTime();
                    } else {
                        calendar2 = Calendar.getInstance();
                        calendar2.setTime(startDateForNextSprint);
                        calendar2.add(5, 1);
                        startDateForNextSprint = calendar2.getTime();
                    }
                    containersToSave.add(currentSprint);
                }
                if (!currentSprint.getId().equals(savedContainer.getId())) continue;
                isNextToUpdatedSprint = true;
            }
            if (PropertyValidator.isValid(containersToSave)) {
                this.containerRepository.save(containersToSave);
                response.put("otherContainers", containersToSave);
            }
        }
        Boolean autoFillStartEndDate = sessionBoard.getSession().isAutoFillStartEndDate();
        Session session = sessionBoard.getSession();
        if (autoFillStartEndDate == null) {
            autoFillStartEndDate = Boolean.FALSE;
        }
        if (autoFillStartEndDate.booleanValue()) {
            if (PropertyValidator.isValid((Collection)sessionBoard.getContainers())) {
                Date smallestDate = null;
                Date largestDate = null;
                for (int i = 0; i < sessionBoard.getContainers().size(); ++i) {
                    Container sprint = (Container)sessionBoard.getContainers().get(i);
                    if (PropertyValidator.isValid((Object)sprint.getStartDate())) {
                        if (smallestDate == null) {
                            smallestDate = sprint.getStartDate();
                        } else if (sprint.getStartDate().getTime() < smallestDate.getTime()) {
                            smallestDate = sprint.getStartDate();
                        }
                    }
                    if (!PropertyValidator.isValid((Object)sprint.getEndDate())) continue;
                    if (largestDate == null) {
                        largestDate = sprint.getEndDate();
                        continue;
                    }
                    if (sprint.getEndDate().getTime() <= largestDate.getTime()) continue;
                    largestDate = sprint.getEndDate();
                }
                if (PropertyValidator.isValid(smallestDate)) {
                    session.setStartDate(smallestDate);
                }
                if (PropertyValidator.isValid(largestDate)) {
                    session.setEndDate(largestDate);
                }
            }
            this.sessionRepository.save((Object)session);
            response.put("session", session);
        }
    }

    @RequestMapping(value={"/container/delete"})
    public ResponseEntity<Object> deleteContainer(@RequestBody HashMap<String, Object> payload) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        responseJson.put("success", Boolean.valueOf(false));
        try {
            if (PropertyValidator.isValid(payload)) {
                SessionBoard sessionBoard;
                List containers;
                String containerStr = (String)payload.get("container");
                String metaMap = (String)payload.get("metaMap");
                String sessionBoardId = (String)payload.get("sessionBoardId");
                ObjectMapper mapper = new ObjectMapper();
                Container container = (Container)mapper.readValue(containerStr, Container.class);
                if (PropertyValidator.isValid((Object)container.getId()) && PropertyValidator.isValid((Object)sessionBoardId) && PropertyValidator.isValid((Collection)(containers = (sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId))).getContainers()))) {
                    for (int i = 0; i < containers.size(); ++i) {
                        if (!((Container)containers.get(i)).getId().equals(container.getId())) continue;
                        containers.remove(i);
                    }
                    sessionBoard.setContainers(containers);
                    Session session = sessionBoard.getSession();
                    this.updatePiBoardOnSprintDateChange(session, sessionBoard);
                    this.sessionBoardRepository.save((Object)sessionBoard);
                    this.sessionRepository.save((Object)session);
                    responseJson.put("session", (Serializable)session);
                    List riskLinkToBeDeleted = this.riskRepository.findAll();
                    for (Risk risk : riskLinkToBeDeleted) {
                        boolean found = false;
                        List boardSprint = risk.getBoardSprints();
                        if (boardSprint == null) continue;
                        Iterator itr = boardSprint.iterator();
                        while (itr.hasNext()) {
                            BoardSprints bT = (BoardSprints)itr.next();
                            if (!bT.getSessionId().equalsIgnoreCase(sessionBoard.getSession().getId()) || !bT.getSprintId().equalsIgnoreCase(container.getId())) continue;
                            itr.remove();
                            found = true;
                        }
                        if (!found) continue;
                        this.riskRepository.save((Object)risk);
                    }
                    List teamContainers = this.teamContainerRepository.findByContainer_Id(container.getId());
                    if (PropertyValidator.isValid((Collection)teamContainers)) {
                        List items = this.itemRepository.findByTeamContainersIn(teamContainers);
                        if (PropertyValidator.isValid((Collection)items)) {
                            for (int i = 0; i < items.size(); ++i) {
                                List itemTeamContainers;
                                List newItemTeamContainers = itemTeamContainers = ((Item)items.get(i)).getTeamContainers();
                                for (int j = 0; j < itemTeamContainers.size(); ++j) {
                                    int tcIndex = j;
                                    TeamContainer tc = teamContainers.stream().filter(lt -> lt.getId().equals(((TeamContainer)itemTeamContainers.get(tcIndex)).getId())).findAny().orElse(null);
                                    if (!PropertyValidator.isValid((Object)tc)) continue;
                                    newItemTeamContainers.remove(j);
                                }
                                ((Item)items.get(i)).setTeamContainers(newItemTeamContainers);
                            }
                            this.itemRepository.save((Iterable)items);
                        }
                        ArrayList teamContainerIds = new ArrayList();
                        teamContainers.forEach(teamContainer -> teamContainerIds.add(teamContainer.getId()));
                        List itemLinks = this.itemLinkRepository.findBySourceTeamContainerIdInOrTargetTeamContainerIdIn((Collection)teamContainerIds, (Collection)teamContainerIds);
                        if (PropertyValidator.isValid((Collection)itemLinks)) {
                            items = this.itemRepository.findByItemLinksIn(itemLinks);
                            if (PropertyValidator.isValid((Collection)items)) {
                                for (int i = 0; i < items.size(); ++i) {
                                    List savedItemLinks;
                                    List deletedItemLinks = savedItemLinks = ((Item)items.get(i)).getItemLinks();
                                    for (int j = 0; j < savedItemLinks.size(); ++j) {
                                        int tcIndex = j;
                                        ItemLink it = itemLinks.stream().filter(lt -> lt.getId().equals(((ItemLink)savedItemLinks.get(tcIndex)).getId())).findAny().orElse(null);
                                        if (!PropertyValidator.isValid((Object)it)) continue;
                                        deletedItemLinks.remove(j);
                                    }
                                    ((Item)items.get(i)).setItemLinks(deletedItemLinks);
                                }
                                this.itemRepository.save((Iterable)items);
                            }
                            KendisUtils.archiveItemLinks((ItemLinkRepository)this.itemLinkRepository, (List)itemLinks);
                        }
                        this.teamContainerRepository.delete((Iterable)teamContainers);
                    }
                    this.containerRepository.delete((Serializable)((Object)container.getId()));
                    List piTeamCapacityList = this.piTeamCapacityRepository.findBySessionId(sessionBoard.getSession().getId());
                    for (PiTeamCapacity piTeamCapacity : piTeamCapacityList) {
                        for (PiUserCapacity userCapacity : piTeamCapacity.getUsersCapacity()) {
                            PiContainerCapacity containerCapacityToBeRemoved = null;
                            for (PiContainerCapacity containerCapacity : userCapacity.getContainersCapacity()) {
                                if (!containerCapacity.getContainerId().equals(container.getId())) continue;
                                containerCapacityToBeRemoved = containerCapacity;
                                break;
                            }
                            if (containerCapacityToBeRemoved == null) continue;
                            userCapacity.getContainersCapacity().remove(containerCapacityToBeRemoved);
                            this.piUserCapacityRepository.save((Object)userCapacity);
                        }
                    }
                    this.itemSyncMapperRepository.deleteBySessionBoardAndContainer(sessionBoard, container);
                    this.teamSprintDependencyLimitRepository.deleteBySessionIdAndSprintId(sessionBoard.getSession().getId(), container.getId());
                    responseJson.put("success", Boolean.valueOf(true));
                    responseJson.put("data", (Serializable)container);
                    AuditLog auditLogObject = new AuditLog(sessionBoardId, "CONTAINER_DEL", null);
                    auditLogObject.setEventText("Sprint " + (container.getTitle() == null ? "" : container.getTitle()) + " removed");
                    this.auditLogRepository.save((Object)auditLogObject);
                    JSONObject pushJson = new JSONObject();
                    try {
                        pushJson.put("isTFS", true);
                        pushJson.put("metaMap", (Object)metaMap);
                        PushSender.sendMsg((String)pushJson.toString());
                    }
                    catch (JSONException e) {
                        LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
                    }
                }
            }
        }
        catch (Exception e) {
            responseJson.put("error", e);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/save/tfslink"})
    @ResponseBody
    public ResponseEntity<Object> saveJiraLink(@RequestBody ItemJiraDependency dependency) {
        try {
            return this.piService.saveTfsLink(dependency);
        }
        catch (Exception ex) {
            LOGGER.debug(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)ex));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/session/status"}, method={RequestMethod.POST})
    public void changeSessionStatus(@RequestBody SessionBoard sessionBoard) {
        SessionBoard board = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoard.getId()));
        board.setStatus(sessionBoard.getStatus());
        this.sessionBoardRepository.save((Object)board);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("boardId", (Object)sessionBoard.getId());
            pushJson.put("status", (Object)sessionBoard.getStatus());
            pushJson.put("metaMap", (Object)sessionBoard.getMetaMap());
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/save/velocity"})
    @ResponseBody
    public ResponseEntity<Object> saveVelocity(@RequestBody TeamSprintVelocity teamSprintVelocity) {
        teamSprintVelocity.setManualUpdate(Boolean.valueOf(true));
        TeamSprintVelocity tsv = (TeamSprintVelocity)this.teamSprintVelocityRepository.save((Object)teamSprintVelocity);
        JSONObject pushJson = new JSONObject();
        try {
            pushJson.put("type", (Object)"Board");
            pushJson.put("teamSprintVelocityId", (Object)tsv.getId());
            pushJson.put("metaMap", (Object)teamSprintVelocity.getMetaMap());
            PushSender.sendMsg((String)pushJson.toString());
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
        return new ResponseEntity((Object)tsv, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-conversations/{parentId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getConversationByItemLink(@PathVariable String parentId) {
        List conv;
        ItemLink itemLink = this.customRepository.getItemLink(parentId);
        if (PropertyValidator.isValid((Object)itemLink)) {
            conv = itemLink.getConversations();
        } else {
            ItemJiraDependency itemJiraDependency = (ItemJiraDependency)this.itemJiraDependencyRepository.findOne((Serializable)((Object)parentId));
            conv = itemJiraDependency.getConversations();
        }
        if (PropertyValidator.isValid((Collection)conv)) {
            ArrayList ids = new ArrayList();
            conv.forEach(con -> ids.add(con.getId()));
            List conversations = this.conversationRepository.findAllByIdIn(ids);
            return new ResponseEntity((Object)conversations, HttpStatus.OK);
        }
        ArrayList conversations = new ArrayList();
        return new ResponseEntity(conversations, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-conversations/{parentId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveConversationByItemLink(@PathVariable String parentId, @RequestBody List<Conversation> conversations) {
        try {
            return this.piService.saveConversationByItemLink(parentId, conversations);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public String formatedEmailText(String summary, String sTeam, String sSprint, String sTitle, String tTitle, String tSprint, String tTeam, String LinkType, String newStatus, String Reporter, String dueDate, String boardName, String userType, String prevStatus, String oldResponsible, String newResponsible, String sKey, String tKey) {
        sKey = sKey != null ? sKey : "";
        tKey = tKey != null ? tKey : "";
        String template = "<ul>";
        template = template + (summary != null ? "<li>Summary:" + summary + "</li>" : "");
        template = template + "<li>Creator:" + sTeam + "," + sSprint + "," + sKey + " " + sTitle + "</li>";
        template = template + "<li>Reciever :" + tTeam + "," + tSprint + "," + tKey + " " + tTitle + "</li>";
        template = template + "<li>Link Type : " + LinkType + "</li>";
        template = template + (prevStatus != null ? "<li>Status :" + prevStatus + " To " + newStatus + "</li>" : "<li>Status :" + newStatus + "</li>");
        template = template + (Reporter != null && userType.equals("Responsible") ? "<li>Responsible : " + Reporter + "</li>" : (userType.equals("Reporter") ? "<li> Reporter: " + UserContextUtil.getUserContext().getLoggedInUser().getFullName() + "</li>" : ""));
        template = template + (oldResponsible != null && newResponsible != null ? "<li>Responsible :" + oldResponsible + " To " + newResponsible + "</li>" : "");
        template = template + (dueDate != null ? "<li>Target Resoulation Date :" + dueDate + "</li>" : "");
        template = template + "<li>Board Name :" + boardName + "</li>";
        template = template + "</ul>";
        return template;
    }

    public String emailText(String action, HashMap<String, Object> mailParam, String UserType2) {
        String firstName = (String)mailParam.get("firstName");
        String sourceItem = (String)mailParam.get("sourceItem");
        String targetItem = (String)mailParam.get("targetItem");
        String board = (String)mailParam.get("board");
        String sourceSprintTitle = (String)mailParam.get("sourceSprintTitle");
        String targetSprintTitle = (String)mailParam.get("targetSprintTitle");
        String sourceTeamTitle = (String)mailParam.get("sourceTeamTitle");
        String targetTeamTitle = (String)mailParam.get("targetTeamTitle");
        String newStatus = (String)mailParam.get("newstatus");
        String earlierStatus = (String)mailParam.get("earlierstatus");
        String summary = (String)mailParam.get("summary");
        String linkType = (String)mailParam.get("linkType");
        String dueDate = mailParam.get("dueDate") != null ? mailParam.get("dueDate").toString() : null;
        String reporter = (String)mailParam.get("repoter");
        String oldResponsible = (String)mailParam.get("oldResponsible");
        String newResponsible = (String)mailParam.get("newResponsible");
        String sKey = (String)mailParam.get("sKey");
        String tKey = (String)mailParam.get("tKey");
        String text = "";
        String template = "";
        if (action.equals("created")) {
            template = "Hi " + firstName + ",<br/> A new dependency has been reported with the following details, on. <br/>";
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, null, null, sKey, tKey);
        } else if (action.equals("statuschange")) {
            template = "Hi " + firstName + "<br/> The status of the following dependency has been changed";
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, "Reporter", earlierStatus, null, null, sKey, tKey);
        } else if (action.equals("removedependency")) {
            template = "Hi " + firstName + "<br/> The dependency has been deleted by your Kendis board user" + UserContextUtil.getUserContext().getLoggedInUser().getFullName();
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, null, null, sKey, tKey);
        } else if (action.equals("changeresponsible")) {
            template = "Hi " + firstName + "<br/> You\u2019ve been set responsible for the following dependency by the user" + UserContextUtil.getUserContext().getLoggedInUser().getFullName();
            text = this.formatedEmailText(summary, sourceTeamTitle, sourceSprintTitle, sourceItem, targetItem, targetSprintTitle, targetTeamTitle, linkType, newStatus, reporter, dueDate, board, UserType2, null, oldResponsible, newResponsible, sKey, tKey);
        }
        template = template + text;
        template = template + "<br/>Sincerely,<br/>Kendis Support";
        return template;
    }

    private String tfsToKendisStatusCategory(String tfs) {
        if (tfs.equals("Proposed")) {
            return "ToDo";
        }
        if (tfs.equals("In Progress") || tfs.equals("InProgress")) {
            return "InProgress";
        }
        if (tfs.equals("Resolved")) {
            return "Done";
        }
        if (tfs.equals("Completed")) {
            return "Done";
        }
        return "Misc";
    }

    private void onResyncComplete(String syncId, String url, String payload, String event) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Board");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestURL", (Object)url);
            pushJson.put("requestParam", (Object)payload);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(true)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    private void onResyncError(String syncId, String url, String payload, String event) {
        try {
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Board");
            pushJson.put("push", (Object)"Self");
            pushJson.put("error", true);
            pushJson.put("requestURL", (Object)url);
            pushJson.put("data", (Object)payload);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJson.toString());
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJson.toString(), Boolean.valueOf(false)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
        }
    }

    private void updateJiraOnDragDrop(Item item, List<Item> items, TeamContainer newTC, TeamContainer removedTC, String oldParentId, ItemJiraFieldMap jiraField, SessionBoard board) {
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        if (Boolean.TRUE.equals(board.getSession().getAlmEnabled()) && PropertyValidator.isValid((Collection)board.getSession().getAlmConfigurations())) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    private void updateJiraOnUnlink(Item item) {
        User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
        if (PropertyValidator.isValid((Object)item.getJiraId())) {
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    private ResponseEntity<Object> downloadActivityLogExcelFile(String sessionBoardId, String timeZone, List activityLogList) {
        try {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)sessionBoardId));
            ArrayList<String> sessionBoardIds = new ArrayList<String>();
            sessionBoardIds.add(sessionBoardId);
            List itemRepoList = this.itemRepository.findBySessionBoardsIdIn(sessionBoardIds);
            String filePath = this.exportService.exportActivityLogs(activityLogList, sessionBoard.getTeams(), sessionBoard.getContainers(), this.issueTypeRepository.findAllByOrderBySequenceAsc(), itemRepoList, timeZone, sessionBoard);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoard.getSession().getTitle()) + "_Activity_logs_" + formatter.format(new Date()) + ".xlsx";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/export/activities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportAllActivities(@RequestBody String requestPayload) {
        try {
            Gson g = new Gson();
            50 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestPayload, T.getType());
            reqbody.put("activies", this.planService.getAllActivitiesByTeamAndSprint((String)reqbody.get("searchString"), (String)reqbody.get("boardId"), (String)reqbody.get("teamId"), (String)reqbody.get("sprintId"), (Boolean)reqbody.get("isWebhook")));
            return this.downloadActivityLogExcelFile(reqbody.get("boardId").toString(), reqbody.get("timeZone").toString(), (List)reqbody.get("activies"));
        }
        catch (Exception e) {
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/get-preview-email-template"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getSharePopUpData(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        HashMap dataJson = new HashMap();
        this.tfSservice.createEmailDataForSharing(requestBody, dataJson);
        String templateHtml = LocalMailSender.generateHtml((String)"share_template", dataJson);
        responseJson.put("template", templateHtml);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/share-email-pdf"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> shareEmailPDF(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        String templateType = (String)requestBody.get("templateType");
        String showViewReportURL = "";
        if (templateType.equalsIgnoreCase("Reports")) {
            requestBody.put("templateName", "share_template");
            requestBody.put("urlTag", "#/reports=1");
        }
        this.tfSservice.sendEmailWithPdf(requestBody);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/download-pdf-preview"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> downloadPDFPreview(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, String> responseJson = new HashMap<String, String>();
        String downloadUrl = this.tfSservice.createDownloadPDFData((String)requestBody.get("img"));
        responseJson.put("url", downloadUrl);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/create-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createFilter(@RequestBody BoardFilter boardFilter) {
        HashMap<String, BoardFilter> responseJson = new HashMap<String, BoardFilter>();
        responseJson.put("boardFilter", this.tfSservice.createBoardFilter(boardFilter));
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteFilter(@RequestBody BoardFilter boardFilter) {
        try {
            this.tfSservice.deleteBoardFilter(boardFilter);
            return new ResponseEntity(null, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @ResponseBody
    public ResponseEntity<Object> fetchAttachedBatches(@PathVariable(value="itemId") String itemId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        ArrayList<String> attachedBatchesIds = new ArrayList<String>();
        try {
            Item fetchedItem = this.itemRepository.findById(itemId);
            if (PropertyValidator.isValid((Object)fetchedItem) && PropertyValidator.isValid((Collection)fetchedItem.getBatches())) {
                for (BaseItem item : fetchedItem.getBatches()) {
                    if (!PropertyValidator.isValid((Object)item)) continue;
                    attachedBatchesIds.add(item.getId());
                }
            }
            responseJson.put("success", Boolean.valueOf(true));
            responseJson.put("attachedBatches", attachedBatchesIds);
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-session-boards-title"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchSessionBoardsTitle(@RequestBody Map<String, Object> ids) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        HashMap<String, SessionBoard> sessionBoardIdTitleMap = new HashMap<String, SessionBoard>();
        HashMap teamMap = new HashMap();
        HashMap containerMap = new HashMap();
        ArrayList<String> activeSessionBoardIds = new ArrayList<String>();
        try {
            List sessionIds = (List)ids.get("sessionIds");
            List childSessionBoardIdsList = (List)ids.get("childSessionBoardIds");
            List sessions = this.sessionRepository.findMinimalSessionsByIdIn(sessionIds);
            for (Object session : sessions) {
                if (!PropertyValidator.isValid((Object)session.getActiveSessionBoard())) continue;
                activeSessionBoardIds.add(session.getActiveSessionBoard());
            }
            List parentSessionBoards = this.batchService.fetchMinimalSessionBoardsBySessionBoardIds(activeSessionBoardIds);
            for (SessionBoard sessionBoard : parentSessionBoards) {
                sessionBoard.getTeams().forEach(team -> teamMap.put(team.getId(), team));
                sessionBoard.getContainers().forEach(container -> containerMap.put(container.getId(), container));
                sessionBoardIdTitleMap.put(sessionBoard.getId(), sessionBoard);
            }
            List childSessionBoards = this.batchService.fetchMinimalSessionBoardsBySessionBoardIds(childSessionBoardIdsList);
            ArrayList<String> childActiveSessionBoardIds = new ArrayList<String>();
            for (SessionBoard sessionBoard : childSessionBoards) {
                if (!PropertyValidator.isValid((Object)sessionBoard.getSession().getActiveSessionBoard())) continue;
                childActiveSessionBoardIds.add(sessionBoard.getSession().getActiveSessionBoard());
            }
            List childActiveSessionBoards = this.batchService.fetchMinimalSessionBoardsBySessionBoardIds(childActiveSessionBoardIds);
            for (SessionBoard sessionBoard : childActiveSessionBoards) {
                sessionBoard.getTeams().forEach(team -> teamMap.put(team.getId(), team));
                sessionBoard.getContainers().forEach(container -> containerMap.put(container.getId(), container));
                sessionBoardIdTitleMap.put(sessionBoard.getId(), sessionBoard);
            }
            responseJson.put("teams", teamMap);
            responseJson.put("containers", containerMap);
            responseJson.put("sessionBoardIdTitleMap", sessionBoardIdTitleMap);
            responseJson.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-solution-boards-title"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchSolutionBoardsTitle(@RequestBody List<String> solutionIds) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            List solutionBoards = this.solutionBoardRepository.findEssentialInfoByIdIn(solutionIds);
            HashMap<String, SolutionBoard> solutionBoardIdTitleMap = new HashMap<String, SolutionBoard>();
            for (SolutionBoard solutionBoard : solutionBoards) {
                solutionBoardIdTitleMap.put(solutionBoard.getId(), solutionBoard);
            }
            responseJson.put("solutionBoardIdTitleMap", solutionBoardIdTitleMap);
            responseJson.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-statuses"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchStatuses(@RequestBody List<String> statusIds) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            List statuses = this.rtItemFetchService.findStatusEssentialsById(statusIds);
            HashMap<String, Status> statusIdTitleMap = new HashMap<String, Status>();
            for (Status status : statuses) {
                statusIdTitleMap.put(status.getId(), status);
            }
            responseJson.put("statusIdTitleMap", statusIdTitleMap);
            responseJson.put("success", Boolean.valueOf(true));
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignorelist/add"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> boardIgnoreListAdd(@RequestBody String payload) {
        Gson g = new Gson();
        51 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String sessionId = (String)requestBody.get("sessionId");
        String itemTfsId = (String)requestBody.get("itemTfsId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        if (session.getIgnoreItemsInResync() == null) {
            session.setIgnoreItemsInResync(new HashMap());
        }
        session.getIgnoreItemsInResync().put(itemTfsId, itemTfsId);
        this.sessionRepository.save((Object)session);
        result.put("success", true);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignorelist/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> boardIgnoreListRemove(@RequestBody String payload) {
        Gson g = new Gson();
        52 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String sessionId = (String)requestBody.get("sessionId");
        String itemTfsId = (String)requestBody.get("itemTfsId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        if (session.getIgnoreItemsInResync() != null) {
            session.getIgnoreItemsInResync().remove(itemTfsId);
            this.sessionRepository.save((Object)session);
            result.put("success", true);
        } else {
            result.put("success", false);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/ignorelist/clear"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> boardIgnoreListClear(@RequestBody String payload) {
        Gson g = new Gson();
        53 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(payload, T.getType());
        String sessionId = (String)requestBody.get("sessionId");
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
        if (session.getIgnoreItemsInResync() != null) {
            session.setIgnoreItemsInResync(new HashMap());
            this.sessionRepository.save((Object)session);
            result.put("success", true);
        } else {
            result.put("success", false);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/save-bulk/links"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveBulkLinks(@RequestBody Map map) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.tfSservice.saveBulkLinks(map);
            result.put("message", "success");
        }
        catch (ViztrendJiraException e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            result.put("message", e.getMessage());
            String sessionId = (String)map.get("sessionId");
            String solutionBoardId = (String)map.get("solutionBoardId");
            if (PropertyValidator.isValid((Object)sessionId)) {
                this.customRepositoryImpl.removeSessionLock(sessionId);
            } else if (PropertyValidator.isValid((Object)solutionBoardId)) {
                this.customRepositoryImpl.removeSolutionBoardLock(solutionBoardId, EnumKendis.DEPENDENCY.getCode());
            }
            return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/find/board"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> findBoard(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            String context = (String)reqbody.get("context");
            String id = (String)reqbody.get("id");
            SessionBoard sessionBoard = null;
            if (PropertyValidator.isValid((Object)context) && PropertyValidator.isValid((Object)id)) {
                if ("session".equals(context)) {
                    Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)id));
                    id = session.getActiveSessionBoard();
                }
                sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)id));
            }
            responseJson.put("success", true);
            responseJson.put("sessionBoard", (Boolean)sessionBoard);
        }
        catch (Exception e) {
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/searchBoards"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchBoards(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        SecureUser secureUser = UserContextUtil.getUserContext();
        String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
        String searchQurey = (String)reqbody.get("query");
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{"updatedOn"}));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").is((Object)false));
        String options = "i";
        Criteria criteria1 = Criteria.where((String)"title").regex(searchQurey, options);
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"rowStatus").is((Object)0));
        query.addCriteria((CriteriaDefinition)criteria1);
        List sessions = this.mongoTemplate.find(query, Session.class);
        responseJson.put("success", true);
        responseJson.put("sessions", sessions);
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/copy-filter"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> copyBoardFilter(@RequestBody HashMap<String, Object> reqbody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.tfSservice.copyFilter(reqbody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/dependency-filters/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getDependencyFilters(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, HashMap> responseJson = new HashMap<String, HashMap>();
        try {
            responseJson.put("depFilters", this.tfSservice.fetchDependencyFilters(sessionId, UserContextUtil.getUserContext().getLoggedInUser().getId()));
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/setExcludeItemInSession"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> setExcludeItemInSession(@RequestBody HashMap<String, Object> reqbody) {
        HashMap<String, Boolean> responseJson = new HashMap<String, Boolean>();
        try {
            String sessionId = (String)reqbody.get("sessionId");
            List excludeTfsStatuses = (List)reqbody.get("excludeTfsStatuses");
            List excludeTfsItemTypes = (List)reqbody.get("excludeTfsItemTypes");
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (PropertyValidator.isValid((Object)session)) {
                session.setExcludeTfsStatuses(excludeTfsStatuses);
                session.setExcludeTfsItemTypes(excludeTfsItemTypes);
                session = (Session)this.sessionRepository.save((Object)session);
                responseJson.put("success", true);
                responseJson.put("session", (Boolean)session);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/session/{sessionId}/teams"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getSessionActiveboardTeams(@PathVariable(value="sessionId") String sessionId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Session session = (Session)this.sessionRepository.findOne((Serializable)((Object)sessionId));
            if (session == null) {
                LOGGER.warn("Session not found with ID: {}", (Object)sessionId);
                responseJson.put("success", false);
                responseJson.put("message", "Session not found");
                return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
            }
            String activeSessionBoardId = session.getActiveSessionBoard();
            if (!PropertyValidator.isValid((Object)activeSessionBoardId)) {
                LOGGER.warn("No active session board found for session ID: {}", (Object)sessionId);
                responseJson.put("success", false);
                responseJson.put("message", "No active session board found for this session");
                return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
            }
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)activeSessionBoardId));
            if (sessionBoard == null) {
                LOGGER.warn("Active session board not found with ID: {}", (Object)activeSessionBoardId);
                responseJson.put("success", false);
                responseJson.put("message", "Active session board not found");
                return new ResponseEntity(responseJson, HttpStatus.NOT_FOUND);
            }
            ArrayList teams = sessionBoard.getTeams();
            if (teams == null) {
                teams = new ArrayList();
            }
            responseJson.put("success", true);
            responseJson.put("teams", teams);
            responseJson.put("sessionId", sessionId);
            responseJson.put("activeSessionBoardId", activeSessionBoardId);
            LOGGER.debug("Successfully fetched {} teams for session: {}", (Object)teams.size(), (Object)sessionId);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching teams for session {}: {}", (Object)sessionId, (Object)com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            responseJson.put("message", "Internal server error");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/create-board-tfs"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createBoardTfs(@RequestBody HashMap<String, Object> reqbody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.createBoardService.createTfsBoard(reqbody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/items/state/{sessionBoardId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getStateItems(@PathVariable String sessionBoardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            Map result = this.piService.getStateItems(sessionBoardId);
            responseJson.put("success", true);
            responseJson.put("data", result);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            responseJson.put("error", "An internal error occurred while fetching state items.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/items"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getPiItems(@RequestBody PiItemsRequestDTO reqbody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List itemIds = reqbody.getItemIds();
            String boardId = reqbody.getBoardId();
            Map result = this.piService.getItems(itemIds, boardId, reqbody.isRemovedLogs());
            responseJson.put("success", true);
            responseJson.put("data", result);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(com.viztrend.safe.utils.StringUtils.getTraceString((Throwable)e));
            responseJson.put("success", false);
            responseJson.put("error", "An internal error occurred while fetching PI items.");
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static /* synthetic */ boolean lambda$changeState1$26(TeamSprintVelocity newTsv, Container x) {
        return newTsv.getSprintId().equals(x.getDuplicateOfId());
    }

    private static /* synthetic */ boolean lambda$changeState1$24(ItemSyncMapper itemSyncMapper, Container x) {
        return itemSyncMapper.getContainer().getId().equals(x.getDuplicateOfId());
    }

    static /* synthetic */ SessionBoardRepository access$000(PIController x0) {
        return x0.sessionBoardRepository;
    }

    static /* synthetic */ ItemSyncMapperRepository access$100(PIController x0) {
        return x0.itemSyncMapperRepository;
    }

    static /* synthetic */ TeamContainerRepository access$200(PIController x0) {
        return x0.teamContainerRepository;
    }

    static /* synthetic */ ItemRepository access$300(PIController x0) {
        return x0.itemRepository;
    }

    static /* synthetic */ void access$400(PIController x0, String x1, String x2, String x3, String x4) {
        x0.onResyncComplete(x1, x2, x3, x4);
    }

    static /* synthetic */ TFSservice access$500(PIController x0) {
        return x0.tfSservice;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ TFSUtils access$700(PIController x0) {
        return x0.tfsUtils;
    }

    static /* synthetic */ AlmErrorRepository access$800(PIController x0) {
        return x0.almErrorRepository;
    }

    static /* synthetic */ PushResponseRepository access$900(PIController x0) {
        return x0.pushResponseRepository;
    }

    static /* synthetic */ TFSProjectRepository access$1000(PIController x0) {
        return x0.tfsProjectRepository;
    }

    static /* synthetic */ SessionRepository access$1100(PIController x0) {
        return x0.sessionRepository;
    }

    static /* synthetic */ TFSPreferencesRepository access$1200(PIController x0) {
        return x0.tfsPreferencesRepository;
    }

    static /* synthetic */ WorkFlowRepository access$1300(PIController x0) {
        return x0.workFlowRepository;
    }

    static /* synthetic */ WorkFlowItemTypeRepository access$1400(PIController x0) {
        return x0.workFlowItemTypeRepository;
    }

    static /* synthetic */ String access$1500(PIController x0, String x1) {
        return x0.tfsToKendisStatusCategory(x1);
    }

    static /* synthetic */ StatusRepository access$1600(PIController x0) {
        return x0.statusRepository;
    }

    static /* synthetic */ AlmAccountRepository access$1700(PIController x0) {
        return x0.almAccountRepository;
    }

    static /* synthetic */ void access$1800(PIController x0, String x1, String x2, String x3, String x4) {
        x0.onResyncError(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1900(PIController x0, String x1, HashMap x2) {
        x0.sendSyncResponse(x1, x2);
    }

    static /* synthetic */ CustomRepositoryImpl access$2000(PIController x0) {
        return x0.customRepositoryImpl;
    }

    static /* synthetic */ AuditLogRepository access$2100(PIController x0) {
        return x0.auditLogRepository;
    }

    static /* synthetic */ TFSFilterRepository access$2200(PIController x0) {
        return x0.tfsFilterRepository;
    }

    static /* synthetic */ UserRepository access$2300(PIController x0) {
        return x0.userRepository;
    }

    static /* synthetic */ TFSAlmConfigurationsRepository access$2400(PIController x0) {
        return x0.tfsAlmConfigurationsRepository;
    }

    static /* synthetic */ UserService access$2500(PIController x0) {
        return x0.userService;
    }

    static /* synthetic */ StateChangeService access$2600(PIController x0) {
        return x0.stateChangeService;
    }

    static /* synthetic */ RiskRepository access$2700(PIController x0) {
        return x0.riskRepository;
    }

    static /* synthetic */ ItemLinkRepository access$2800(PIController x0) {
        return x0.itemLinkRepository;
    }

    static /* synthetic */ TeamSprintVelocityRepository access$2900(PIController x0) {
        return x0.teamSprintVelocityRepository;
    }

    static /* synthetic */ TeamSprintDependencyLimitRepository access$3000(PIController x0) {
        return x0.teamSprintDependencyLimitRepository;
    }

    static /* synthetic */ ObjectiveService access$3100(PIController x0) {
        return x0.objectiveService;
    }

    static /* synthetic */ AppConfig.MongoConfig access$3200(PIController x0) {
        return x0.mongoConfig;
    }

    static /* synthetic */ PlanService access$3300(PIController x0) {
        return x0.planService;
    }

    static /* synthetic */ ContainerRepository access$3400(PIController x0) {
        return x0.containerRepository;
    }

    static /* synthetic */ ItemJiraDependencyRepository access$3500(PIController x0) {
        return x0.itemJiraDependencyRepository;
    }

    static /* synthetic */ CustomRepository access$3600(PIController x0) {
        return x0.customRepository;
    }

    static /* synthetic */ ReleaseTrainService access$3700(PIController x0) {
        return x0.releaseTrainService;
    }

    static /* synthetic */ ALMSyncService access$3800(PIController x0) {
        return x0.almSyncService;
    }
}

