/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.service.OrgDependencyService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/orgDependency"})
@RestController
public class OrgDependencyController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrgDependencyController.class);
    @Autowired
    private OrgDependencyService orgDependencyService;

    @RequestMapping(value={"/item/dependencies"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getItemDependencies(@RequestBody Map<String, Object> payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.fetchItemDependencies(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error loading item dependencies: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/delete/dependency"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteItemJiraDependency(@RequestBody Map<String, Object> payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.deleteItemJiraDependency(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error deleting dependency: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/update/dependency"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateItemJiraDependency(@RequestBody ItemJiraDependency payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.updateItemJiraDependency(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error updating dependency: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/targets/search"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> searchBacklogTargets(@RequestBody Map<String, Object> payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.searchBacklogTargets(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error finding target: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/create/dependencies"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createItemJiraDependencies(@RequestBody BacklogItem payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.createItemJiraDependency(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error creating dependency: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/alm/linkTypes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadAlmLinkTypes(@RequestBody Map<String, Object> payload) {
        try {
            String almAccountId = (String)payload.get("almAccountId");
            if (almAccountId == null || almAccountId.isEmpty()) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("success", false);
                errorResponse.put("error", "ALM Account ID is required");
                return new ResponseEntity(errorResponse, HttpStatus.BAD_REQUEST);
            }
            Map responseJson = this.orgDependencyService.loadAlmLinkTypes(almAccountId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error loading link types: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/alm/saveDependencyLinkTypes"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveDependencyLinkTypes(@RequestBody Map<String, Object> payload) {
        try {
            String almAccountId = (String)payload.get("almAccountId");
            if (almAccountId == null || almAccountId.isEmpty()) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("success", false);
                errorResponse.put("error", "ALM Account ID is required");
                return new ResponseEntity(errorResponse, HttpStatus.BAD_REQUEST);
            }
            Map responseJson = this.orgDependencyService.saveDependencyLinkTypes(payload);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error saving dependency link types: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/dependencies/itemIds"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> fetchDependenciesWithItemIds(@RequestBody Map<String, Object> payload) {
        try {
            Map responseJson = new HashMap();
            responseJson = this.orgDependencyService.fetchDependenciesWithItemIds(payload);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("error", "Error fetching dependencies: " + e.getMessage());
            return new ResponseEntity(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

