/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.google.gson.Gson;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.ObjectiveController;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.ModuleConfiguration;
import com.viztrend.safe.persistence.entity.ObjectiveCustomView;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.repository.ModuleConfigurationRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.service.ChangeLogSyncServiceImpl;
import com.viztrend.safe.service.ObjectiveService;
import com.viztrend.safe.service.StrategicThemeService;
import com.viztrend.safe.utils.MongoSyncUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/objective"})
@RestController
public class ObjectiveController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectiveController.class);
    @Autowired
    private ObjectiveService objectiveService;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private ModuleConfigurationRepository moduleConfigurationRepository;
    @Autowired
    private ModuleConfigurationRepository objectiveMenuPermissionsRepository;
    @Autowired
    private AppConfig.MongoConfig mongoConfig;
    @Autowired
    private ChangeLogSyncServiceImpl changeLogServiceImpl;
    @Autowired
    private StrategicThemeService strategicThemeService;
    @Autowired
    private PushResponseRepository pushResponseRepository;

    @RequestMapping(value={"/update-objective"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> createObjectiveGroup(@RequestBody BaseItem baseItem) {
        try {
            BaseItem objectiveGroup = this.objectiveService.createObjectiveGroup(baseItem);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)objectiveGroup);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-groups-list-by-object-id"}, method={RequestMethod.POST})
    public ResponseEntity<Object> loadObjectiveGroupsBySessionId(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesListByObjectId(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objectives-and-kr"})
    public ResponseEntity<Object> getObjectives(@RequestBody String payload) {
        HashMap responseJson = new HashMap();
        try {
            Gson g = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap params = (HashMap)g.fromJson(payload, T.getType());
            responseJson = this.objectiveService.getAllObjectivesAndKR(params);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/get-objective-groups-list-by-session-id/{id}/{requestId}/{sessionBoardId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadObjectiveGroupsBySessionId(@PathVariable(value="id") String sessionId, @PathVariable(value="requestId") String requestId, @PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesListBySessionId(sessionId, requestId, sessionBoardId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objective-json/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadObjectiveJson(HttpServletRequest request, @PathVariable(value="id") String sessionId) {
        try {
            ArrayList<Session> sessions = new ArrayList<Session>();
            sessions.add(new Session(sessionId));
            return new ResponseEntity((Object)this.objectiveService.fetchObjectivesForApi(sessions, null, null, request.getParameterMap()), HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity(new ArrayList(), HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-groups-list-by-session-id-with-link-item-ids/{sessionId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadObjectiveGroupsBySessionIdWithLinkItemIds(@PathVariable(value="sessionId") String sessionId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.getObjectivesWithTrimedLinkedItems(sessionId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-old-state-objectives/{sessionBoardId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadOldStateObjectives(@PathVariable(value="sessionBoardId") String sessionBoardId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            responseJson.put("old_state_objectives", MongoSyncUtils.retrieveData((String)("old_state_objectives_" + sessionBoardId), (AppConfig.MongoConfig)this.mongoConfig));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/load-objective-groups-data"}, method={RequestMethod.POST})
    public ResponseEntity<Object> loadObjectivesGroupData(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesGroupData(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objective-by-id"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadObjectiveById(@RequestBody HashMap<String, String> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesId(requestBody);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objective-by-ids"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> loadObjectivesByIds(@RequestBody HashMap<String, Object> requestBody) throws Exception {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesByIds(requestBody);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objective-groups-list-by-solution-id/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadObjectiveGroupsBySolutionId(@PathVariable(value="id") String solutionId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesListBySolutionId(solutionId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/templateForObjectives"}, method={RequestMethod.GET})
    public ResponseEntity<Object> loadObjectivesTemplate() {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectivesTemplate();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete-objective"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteObjectiveGroup(@RequestBody HashMap<String, String> requestBody) {
        try {
            this.objectiveService.deleteObjectiveById(requestBody);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/unlink-objective"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeObjectiveRelation(@RequestBody HashMap<String, String> requestBody) {
        try {
            this.objectiveService.removeObjectiveRelation(requestBody);
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/unlink-objective-from-session"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> removeObjectiveRelationFromSession(@RequestBody HashMap<String, String> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.removeObjectiveRelationFromSession(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            responseJson.put("kendisError", e);
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/fetch-linked-items/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> fetchLinkedItems(@PathVariable(value="id") String id) {
        try {
            BaseItem baseItem = this.objectiveService.fetchLinkedItemsForObjective(id);
            return new ResponseEntity((Object)baseItem, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/is-backlog-item-linked/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> isBackLogItemLinked(@PathVariable(value="id") String objId) {
        try {
            Boolean isBackLogItemLinked = this.objectiveService.isBackLogItemLinked(objId);
            return new ResponseEntity((Object)isBackLogItemLinked, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/enableOkr"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableOkr(@RequestBody Session body) {
        try {
            Session session = this.objectiveService.enableOkr(body);
            return new ResponseEntity((Object)session, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/enableOkrForSolution"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableOkrForSolution(@RequestBody SolutionBoard body) {
        try {
            SolutionBoard solutionBoard = this.objectiveService.enableOkrForSolution(body);
            return new ResponseEntity((Object)solutionBoard, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/enableUncommittedObj"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableUncommittedObj(@RequestBody Session body) {
        try {
            Session session = this.objectiveService.enableUncommittedObj(body);
            return new ResponseEntity((Object)session, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/enableUncommittedObjForSolution"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> enableUncommittedObjForSolution(@RequestBody SolutionBoard body) {
        try {
            SolutionBoard solutionBoard = this.objectiveService.enableUncommittedObjForSolution(body);
            return new ResponseEntity((Object)solutionBoard, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/get-objective-modal-template/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveEditModalTemplate(@PathVariable String sessionId) {
        HashMap jsonResponse = new HashMap();
        try {
            jsonResponse = this.objectiveService.getObjectiveEditModalTemplate(sessionId);
            return new ResponseEntity((Object)jsonResponse, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/cv/get-workflows"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveCustomViewWorkflow() {
        HashMap jsonResponse = new HashMap();
        try {
            jsonResponse = this.objectiveService.getDefaultCustomViewWorkFlow();
            return new ResponseEntity((Object)jsonResponse, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/cv/save-options"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveCustomViewOptions(@RequestBody HashMap<String, Object> request) {
        try {
            String optionType = (String)request.get("optionType");
            String option = (String)request.get("option");
            if (!PropertyValidator.isValid((Object)optionType) || !PropertyValidator.isValid((Object)option)) {
                HashMap<String, Object> errorResponse = new HashMap<String, Object>();
                errorResponse.put("success", false);
                errorResponse.put("reason", "option missing");
                return ResponseEntity.ok(errorResponse);
            }
            HashMap jsonResponse = this.processOption(optionType, option, request);
            return ResponseEntity.ok((Object)jsonResponse);
        }
        catch (Exception e) {
            LOGGER.debug(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private HashMap<String, Object> processOption(String optionType, String option, HashMap<String, Object> request) throws Exception {
        HashMap response = new HashMap();
        if ("themeType".equals(optionType)) {
            response = this.handleThemeType(option, request);
        } else if ("themePriority".equals(optionType)) {
            response = this.handleThemePriority(option, request);
        } else {
            response.put("success", false);
            response.put("reason", "invalid optionType");
        }
        return response;
    }

    private HashMap<String, Object> handleThemeType(String option, HashMap<String, Object> request) throws Exception {
        if ("create".equals(option)) {
            return this.strategicThemeService.createThemeType(request);
        }
        if ("update".equals(option)) {
            return this.strategicThemeService.editThemeType(request);
        }
        if ("delete".equals(option)) {
            return this.strategicThemeService.deleteThemeType(request);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("success", false);
        response.put("reason", "invalid option");
        return response;
    }

    private HashMap<String, Object> handleThemePriority(String option, HashMap<String, Object> request) throws Exception {
        if ("create".equals(option)) {
            return this.strategicThemeService.createThemePriority(request);
        }
        if ("update".equals(option)) {
            return this.strategicThemeService.editThemePriority(request);
        }
        if ("delete".equals(option)) {
            return this.strategicThemeService.deleteThemePriority(request);
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("success", false);
        response.put("reason", "invalid option");
        return response;
    }

    @RequestMapping(value={"/updateMenuPermissionBySessionId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateMenuPermissionBySessionId(@RequestBody HashMap<String, String> body) {
        HashMap jsonResponse = new HashMap();
        try {
            jsonResponse = this.objectiveService.updateMenuPermissionBySessionId(body);
            return new ResponseEntity((Object)jsonResponse, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/save-obj-okr-weights"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveWeightsOfOkr(@RequestBody HashMap<String, Object> requestBody) throws Exception {
        try {
            HashMap response = this.objectiveService.saveWeightsOfObjAndOkr(requestBody);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/link-to-teams-and-groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkToTeamsAndGroups(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap response = this.objectiveService.linkToTeamsAndGroups(requestBody);
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/update-objective-groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateObjectiveGroups(@RequestBody HashMap<String, String> requestBody) {
        try {
            List updatedGroupsList = this.objectiveService.updateObjectiveGroupsByIds(requestBody);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)updatedGroupsList);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/update-base-item-links-of-base-items"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBaseItemLinksOfBaseItems(@RequestBody HashMap<String, Object> requestBody) {
        try {
            BaseItem baseItem = this.objectiveService.fetchBaseItemsForObjective(requestBody);
            return new ResponseEntity((Object)baseItem, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/export-report"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportReport(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap data = this.objectiveService.exportReport(requestBody);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)data);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-calculation-of-board-groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> calculateObjectiveGroupsCompletionForPiBoard(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap data = this.objectiveService.calculateObjectiveGroupsCompletionForPiBoard(requestBody);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)data);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-groups-by-item-id"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveGroupsByItemId(@RequestBody HashMap<String, String> requestBody) {
        try {
            HashMap responseJson = new HashMap();
            String sessionId = requestBody.get("sessionId");
            String itemId = requestBody.get("itemId");
            String jiraKey = requestBody.get("jiraKey");
            String tfsId = requestBody.get("tfsId");
            responseJson = this.objectiveService.loadObjectivesListBySessionIdAndItemId(sessionId, itemId, jiraKey, tfsId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-old-state-objective-groups-by-item-id"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getOldStateObjectiveGroupsByItemId(@RequestBody HashMap<String, String> requestBody) {
        try {
            HashMap responseJson = new HashMap();
            String sessionId = requestBody.get("sessionId");
            String sessionBoardId = requestBody.get("sessionBoardId");
            String itemId = requestBody.get("itemId");
            String jiraKey = requestBody.get("jiraKey");
            String tfsId = requestBody.get("tfsId");
            responseJson = this.objectiveService.loadOldStateObjectivesListBySessionIdAndItemId(sessionId, sessionBoardId, itemId, jiraKey, tfsId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-permissions/{sessionId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getObjectivePermissions(@PathVariable(value="sessionId") String sessionId) {
        try {
            HashMap<String, ModuleConfiguration> responseJson = new HashMap<String, ModuleConfiguration>();
            ModuleConfiguration objectiveMenuPermission = this.moduleConfigurationRepository.findOneBySessionId(sessionId);
            responseJson.put("objectiveMenuOptions", objectiveMenuPermission);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/check-okr-parent-links"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> checkOkrParentLinks(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap responseJson = new HashMap();
            responseJson = this.objectiveService.checkOkrParentLinks(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-groups-by-ws-id/{wsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveGroupsByWsId(@PathVariable(value="wsId") String wsId) {
        try {
            HashMap responseJson = new HashMap();
            responseJson = this.objectiveService.loadObjectivesListByWsId(wsId);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-relationships"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveRelationships(@RequestBody HashMap<String, Object> requestBody) {
        try {
            HashMap responseJson = new HashMap();
            responseJson = this.objectiveService.saveRelationships(requestBody);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get-objective-relation-details/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getObjectiveRelationDetails(@PathVariable(value="id") String objId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.loadObjectiveRelationDetails(objId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-linked-okrs/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLinkedOkrs(@PathVariable(value="id") String objId) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.getLinkedOkrs(objId);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-workspace-boards/{wsId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getWsBoards(@PathVariable(value="wsId") String wsId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List sessions = this.sessionRepository.findByWorkSpaceIdAndRowStatus(wsId, Integer.valueOf(0));
            responseJson.put("sessions", sessions);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-prioritized/{sessionId}/{isObjListingView}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getPrioritizedObjectives(@PathVariable(value="sessionId") String sessionId, @PathVariable(value="isObjListingView") Boolean isObjListingView) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.getPrioritizedObjectives(sessionId, isObjListingView);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/link-to-global-kr"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkPIObjectivesToGlobalKR(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.linkPIObjectivesToGlobalKR(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/calculate-progress-for-select-groups"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> calculateCompletionForSelectGroups(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.calculateCompletionForSelectGroups(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objectives-of-group"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getObjectivesOfGroup(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.getObjectivesOfSelectedGroup(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-objective-groups-with-objectives-count"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getObjectivesGroupsWithLinkedItems(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            List groupIds = (List)requestBody.get("groupIds");
            if (groupIds == null) {
                responseJson.put("kendisError", "Group Ids are missing");
                return new ResponseEntity(responseJson, HttpStatus.BAD_REQUEST);
            }
            responseJson.put("data", this.objectiveService.getObjectiveGroupLinkedObjectivesCount(groupIds));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveCustomView(@RequestBody ObjectiveCustomView objectiveCustomView) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvSave(objectiveCustomView);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/all"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAllCustomView(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvGetAll(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAllCustomView(@PathVariable String id) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvGetById(id);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/multiple"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getAllCustomView(@RequestBody List<String> ids) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvGetByIdIn(ids);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/archieveView"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> archieveACustomView(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvArchieveCustomView(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/link-groups-to-view"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> linkGroupsToCustomView(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvLinkGroupsToCustomView(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/mark-favourite/{id}"})
    @ResponseBody
    public ResponseEntity<Object> markCustomViewFavourite(@PathVariable String id, @RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvMarkViewFavourite(id, requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/cv/sort-custom-view"})
    @ResponseBody
    public ResponseEntity<Object> sortCustomView(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.cvSortCustomView(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-by-search-query"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getObjectivesBySearchQuery(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.getObjectivesBySearchQuery(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/update-kr-template"}, method={RequestMethod.PATCH})
    @ResponseBody
    public ResponseEntity<Object> updateKrTemplate() {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.updateKrTemplate();
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/update-base-item-link-sequence"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> updateBaseItemLinkSequence(@RequestBody HashMap<String, Object> requestBody) {
        HashMap responseJson = new HashMap();
        try {
            responseJson = this.objectiveService.updateBaseItemLinkSequence(requestBody);
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity((Object)responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)responseJson, HttpStatus.OK);
    }

    @PostMapping(value={"/create-timeseries-data-okrs"})
    public ResponseEntity<Object> createTimeSeriesDataForOKRWidgets(@RequestBody Map<String, Object> requestBody) {
        Map result = new HashMap();
        try {
            if (PropertyValidator.isValid(requestBody)) {
                result = this.objectiveService.createDataForOKRsProgress(requestBody);
            }
            return ResponseEntity.ok(result);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/rsync-all-item-types"})
    public ResponseEntity<Object> reSyncItems(@RequestBody HashMap<String, Object> requestBody) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            if (PropertyValidator.isValid(requestBody)) {
                boolean isReSyncDone = this.changeLogServiceImpl.reSyncOKRItems(requestBody);
                if (isReSyncDone) {
                    Thread.sleep(3000L);
                }
                result.put("isReSyncDone", isReSyncDone);
                return new ResponseEntity(result, HttpStatus.OK);
            }
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/get-custom-view-id-by-key/{key}"})
    public ResponseEntity<String> getCustomViewIdByKey(@PathVariable String key) {
        try {
            ObjectiveCustomView customView = this.objectiveService.getCustomViewIdByKey(key);
            if (customView == null) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)customView.getId());
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @RequestMapping(value={"/export-theme"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> exportTheme(@RequestBody HashMap<String, Object> requestBody) {
        try {
            String requestId = (String)requestBody.get("requestId");
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("requestId", requestId);
            response.put("status", "processing");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(response);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @PostMapping(value={"/export/cancel"})
    @ResponseBody
    public ResponseEntity<Object> cancelExport(@RequestBody HashMap<String, Object> body) {
        try {
            String requestId = (String)body.get("requestId");
            if (PropertyValidator.isValid((Object)requestId)) {
                this.objectiveService.cancelObjectiveExport(requestId);
                HashMap<String, String> resp = new HashMap<String, String>();
                resp.put("message", "Cancellation signal sent");
                return ResponseEntity.ok(resp);
            }
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/legacy-groups"})
    @ResponseBody
    public ResponseEntity<Object> getLegacyGroups() {
        try {
            LOGGER.debug("********** ObjectiveController - getLegacyGroups **********");
            Map response = this.objectiveService.getLegacyGroups();
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    static /* synthetic */ ObjectiveService access$000(ObjectiveController x0) {
        return x0.objectiveService;
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }

    static /* synthetic */ PushResponseRepository access$200(ObjectiveController x0) {
        return x0.pushResponseRepository;
    }
}

