/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.service.LearnWorldsService;
import com.viztrend.safe.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/learnworlds"})
@RestController
public class LearnWorldsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LearnWorldsController.class);
    private final LearnWorldsService learnWorldsService;

    public LearnWorldsController(LearnWorldsService learnWorldsService) {
        this.learnWorldsService = learnWorldsService;
    }

    @GetMapping(value={"/sso"})
    public ResponseEntity<Object> loginToLearnWorlds() {
        LOGGER.debug("*****loginToLearnWorlds**** -----> /learnworlds/sso");
        try {
            return this.learnWorldsService.loginUser();
        }
        catch (Exception e) {
            LOGGER.error("Error in loginToLearnWorlds", (Object)StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @GetMapping(value={"/baseUrl"})
    public ResponseEntity<Object> getLearnWorldsBaseUrl() {
        LOGGER.debug("*****getLearnWorldsBaseUrl**** -----> /baseUrl");
        try {
            return this.learnWorldsService.getBaseUrl();
        }
        catch (Exception e) {
            LOGGER.error("Error in getLearnWorldsBaseUrl", (Object)StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

