/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.okta.saml.util.HttpUtil;
import com.viztrend.safe.persistence.entity.AppInitConfig;
import com.viztrend.safe.persistence.entity.dto.ExportPageRequest;
import com.viztrend.safe.persistence.repository.AppInitConfigRepository;
import com.viztrend.safe.service.ExportPageService;
import com.viztrend.safe.utils.StringUtils;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/export"})
public class ExportController {
    @Autowired
    private ExportPageService exportPageService;
    @Autowired
    private AppInitConfigRepository appInitConfigRepository;
    @Value(value="${temp.file.location}")
    private String tempFileLocation;
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);

    @GetMapping(value={"/config"})
    public ResponseEntity<Map<String, Object>> getExportConfig() {
        try {
            List all = this.appInitConfigRepository.findAll();
            String url = null;
            if (all != null && !all.isEmpty()) {
                AppInitConfig cfg = (AppInitConfig)all.get(0);
                url = cfg != null ? cfg.getExportServerUrl() : null;
            }
            return ResponseEntity.ok(Collections.singletonMap("exportServerUrl", url));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonMap("exportServerUrl", null));
        }
    }

    @PostMapping
    public ResponseEntity<String> exportPageToPdf(HttpServletRequest request) {
        try {
            ServletInputStream inputStream = request.getInputStream();
            Path tempFilePath = Files.createTempFile(Paths.get(this.tempFileLocation, new String[0]), "temp-" + new Date().getTime(), ".tmp", new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(tempFilePath, new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            byte[] exportBytes = Files.readAllBytes(tempFilePath);
            String encodedString = new String(exportBytes);
            String decodedString = URLDecoder.decode(encodedString, "UTF-8");
            ExportPageRequest exportPageRequest = this.exportPageService.convertToExportPageRequest(decodedString);
            byte[] downloadedFile = this.exportPageService.sendExportRequest(exportPageRequest);
            HttpHeaders responseHeaders = new HttpHeaders();
            if (exportPageRequest.getFileFormat().equals("pdf")) {
                responseHeaders.setContentType(MediaType.APPLICATION_PDF);
                responseHeaders.setContentDispositionFormData("attachment", exportPageRequest.getFileName() + ".pdf");
            } else if (exportPageRequest.getFileFormat().equals("png")) {
                responseHeaders.setContentType(MediaType.IMAGE_PNG);
                responseHeaders.setContentDispositionFormData("attachment", exportPageRequest.getFileName() + ".png");
            }
            return new ResponseEntity((Object)Base64.getEncoder().encodeToString(downloadedFile), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

