/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.viztrend.safe.config.AppConfig;
import com.viztrend.safe.controller.DashboardController;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Dashboard;
import com.viztrend.safe.persistence.entity.DashboardAccessRole;
import com.viztrend.safe.persistence.entity.FilterCriteria;
import com.viztrend.safe.persistence.entity.PushResponse;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.SolutionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.Widget;
import com.viztrend.safe.persistence.repository.ContainerRepository;
import com.viztrend.safe.persistence.repository.CustomRepository;
import com.viztrend.safe.persistence.repository.FilterCriteriaRepository;
import com.viztrend.safe.persistence.repository.PushResponseRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.persistence.repository.SolutionBoardRepository;
import com.viztrend.safe.persistence.repository.StatusRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.TeamRepository;
import com.viztrend.safe.service.DashboardService;
import com.viztrend.safe.service.RTItemFetchService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.bson.types.ObjectId;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/dashboard"})
@RestController
public class DashboardController {
    @Autowired
    private PushResponseRepository pushResponseRepository;
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    ReleaseTrainService releaseTrainService;
    @Autowired
    FilterCriteriaRepository filterCriteriaRepository;
    @Autowired
    RTItemFetchService rtItemFetchService;
    @Autowired
    StatusRepository statusRepository;
    @Autowired
    private TeamRepository teamRepository;
    @Autowired
    private TeamContainerRepository teamContainerRepository;
    @Autowired
    private ContainerRepository containerRepository;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SolutionBoardRepository solutionBoardRepository;
    @Autowired
    private CustomRepository customRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    Environment env;
    @Autowired
    AppConfig.MongoConfig mongoConfig;
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardController.class);

    @RequestMapping(value={"/saveDashboard"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveDashboard(@RequestBody Dashboard dashboard) {
        Map result;
        block5: {
            result = new HashMap();
            try {
                if (PropertyValidator.isValid((Object)dashboard)) {
                    if (PropertyValidator.isValid((Object)dashboard.getId())) {
                        result = this.dashboardService.updateDashboard(dashboard.getId(), dashboard);
                    } else {
                        dashboard.setOwner(UserContextUtil.getUserContext().getLoggedInUser());
                        dashboard.setKey(this.customRepository.generateKey("DB"));
                        result = this.dashboardService.saveDashboard(dashboard);
                    }
                    break block5;
                }
                return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteDashboard/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteDashboard(@PathVariable(value="id") String dashboardId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.deleteDashboard(dashboardId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/markFavoriteDashboard"}, method={RequestMethod.POST})
    public ResponseEntity<Object> markFavoriteDashboard(@RequestBody Map<String, Object> request) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.markFavoriteDashboard(request);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/getDashboardAccessRoles/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getDashboardAccessRoles(@PathVariable(value="id") String dashboardId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.getDashboardAccessRoles(dashboardId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/getUserDashboardAccessRole/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getUserDashboardAccessRole(@PathVariable(value="id") String dashboardId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.getUserDashboardAccessRole(dashboardId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/createDashboardAccessRole"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createDashboardAccessRole(@RequestBody DashboardAccessRole dashboardAccessRole) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.createDashboardAccessRole(dashboardAccessRole);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateDashboardAccessRole"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateDashboardAccessRole(@RequestBody DashboardAccessRole dashboardAccessRole) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.updateDashboardAccessRole(dashboardAccessRole);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/deleteDashboardAccessRole/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> deleteDashboardAccessRole(@PathVariable(value="id") String dashboardAccessRoleId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.deleteDashboardAccessRole(dashboardAccessRoleId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/searchUsersOrGroups/{query}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> searchUsersOrGroups(@PathVariable(value="query") String query) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.searchUsersOrGroups(query);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/createDashboardPublicLink"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createDashboardPublicLink(@RequestBody HashMap<String, Object> request) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.createDashboardPublicLink(request);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/removeDashboardPublicLink/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> removeDashboardPublicLink(@PathVariable(value="id") String dashboardId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.removeDashboardPublicLink(dashboardId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/updatePermissonForAll"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updatePermissonForAll(@RequestBody Map map) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            this.dashboardService.updatePermissionForAll(map);
            result.put("success", true);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/updateWidgetGridPosition/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> updateWidgetGridPosition(@PathVariable(value="id") String dashboardId, @RequestBody String requestStr) {
        Map result = new HashMap();
        try {
            Gson g = new Gson();
            1 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap reqbody = (HashMap)g.fromJson(requestStr, T.getType());
            String widgetsJSON = (String)reqbody.get("widgets");
            2 P = new /* Unavailable Anonymous Inner Class!! */;
            List widgets = (List)g.fromJson(widgetsJSON, P.getType());
            result = this.dashboardService.saveWidgetGridPosition(dashboardId, widgets);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-item-compl-by-teams"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getItemCompletionbyTeams(@RequestBody Map<?, ?> request) {
        List result = new ArrayList();
        try {
            result = this.dashboardService.getItemCompletionbyTeams(request);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAllDashboards"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getAllDashboards() {
        Map result = new HashMap();
        try {
            result = this.dashboardService.getAllDashboards(null, null);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/sub-list/{type}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getFilteredDashboards(@PathVariable(value="type") String type, @PathVariable(value="id") String id) {
        Map result = new HashMap();
        try {
            ArrayList<String> values = new ArrayList<String>();
            if ("workSpaceKeys".endsWith(type)) {
                values.add("-");
            }
            if (PropertyValidator.isValid((Object)id)) {
                values.add(id);
            }
            result = this.dashboardService.getAllDashboards(type, values);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getDashboard(@PathVariable(value="id") String id) {
        Map result = new HashMap();
        try {
            if (!PropertyValidator.isValid((Object)id)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.getDashboard(id);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<Object> updateDashboard(@PathVariable(value="id") String id, @RequestBody Dashboard dashboard) {
        Map result = new HashMap();
        try {
            if (!PropertyValidator.isValid((Object)id)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.updateDashboard(id, dashboard);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/widget/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveWidget(@PathVariable(value="id") String id, @RequestBody Widget widget) {
        Map result = new HashMap();
        try {
            if (!PropertyValidator.isValid((Object)id) || !PropertyValidator.isValid((Object)widget)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.saveWidget(id, widget);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/widget/move"}, method={RequestMethod.POST})
    public ResponseEntity<Object> moveWidget(@RequestBody String request) {
        Map result = new HashMap();
        try {
            Gson g = new Gson();
            Gson gson = new Gson();
            3 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String widgetId = (String)requestBody.get("widgetId");
            Double sequence = (Double)requestBody.get("sequence");
            if (!PropertyValidator.isValid((Object)widgetId) || !PropertyValidator.isValid((Object)sequence)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.updateWidgetSequence(widgetId, sequence);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/widget/delete"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteWidget(@PathVariable(value="id") String dashboardId, @RequestBody Widget widget) {
        Map result = new HashMap();
        try {
            if (!PropertyValidator.isValid((Object)dashboardId)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.deleteWidget(dashboardId, widget);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/widget/deleteWidget"}, method={RequestMethod.POST})
    public ResponseEntity<Object> deleteWidgetById(@PathVariable(value="id") String dashboardId, @RequestBody String request) {
        Map result = new HashMap();
        Gson g = new Gson();
        4 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
        String widgetId = (String)requestBody.get("widgetId");
        try {
            if (!PropertyValidator.isValid((Object)dashboardId)) {
                return new ResponseEntity(result, HttpStatus.BAD_REQUEST);
            }
            result = this.dashboardService.deleteWidgetById(dashboardId, widgetId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-board-listing"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getPIBoardListing() {
        List allAccessibleBoards = new ArrayList();
        try {
            allAccessibleBoards = this.dashboardService.getAllAccessableBoards();
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(allAccessibleBoards, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-status-listing/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getStatusListing(@PathVariable(value="id") String sessionId) {
        List allStatus = new ArrayList();
        try {
            allStatus = this.dashboardService.getAllAccessableBoardStatus(sessionId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(allStatus, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-cfd-advance-criteria/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getCFDAdvanceCriteria(@PathVariable(value="id") String sessionId) {
        Map advanceCriteria = new HashMap();
        try {
            advanceCriteria = this.dashboardService.getAdvanceCriteriaForCFD(sessionId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(advanceCriteria, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-start-end-date/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getStartEndDateofPI(@PathVariable(value="id") String sessionId) {
        Map result = new HashMap();
        try {
            result = this.dashboardService.getStartEndDateofPI(sessionId);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetch-all-release-trains"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchAllReleaseTrains(@RequestBody String request, HttpServletRequest params) {
        try {
            Gson g = new Gson();
            5 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            Map responseJson = this.releaseTrainService.getAllReleaseTrains((Map)requestBody);
            if (PropertyValidator.isValid((Object)params.getParameter("soltionBoards"))) {
                responseJson.put("soltionBoards", this.solutionBoardRepository.findAll());
            }
            return ResponseEntity.ok((Object)responseJson);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/create-timeseries-data"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createTimeseriesDataForWidgets(@RequestBody Map<String, Object> requestBody) {
        Map result = new HashMap();
        try {
            String widgetType;
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            String syncId = (String)requestBody.get("syncId");
            switch (widgetType = (String)requestBody.get("widgetType")) {
                case "Cumulative Flow Diagram": {
                    try {
                        result = this.dashboardService.createDataForCFD(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Time in Status": 
                case "Lead Time Graph": 
                case "Flow Time Graph": {
                    try {
                        if (requestBody.get("groupBy") != null) {
                            result = this.dashboardService.createDataForFlowTimeLineGraph(requestBody);
                            break;
                        }
                        result = this.dashboardService.createDataForTimeFlowChart(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Flow Efficiency Graph": {
                    try {
                        result = this.dashboardService.createDataForFlowEfficiencyChart(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Flow Velocity Graph": {
                    try {
                        result = this.dashboardService.createDataForFlowVelocityChart(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Flow Load Graph": {
                    try {
                        result = this.dashboardService.createDataForFlowLoadChart(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Flow Distribution Graph": {
                    try {
                        result = this.dashboardService.createDataForFlowDistributionChart(requestBody);
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
                    }
                }
                case "Completion by Teams": {
                    Callable<Void> task = () -> {
                        try {
                            Map result2 = this.dashboardService.createDataForCompletedStories(requestBody);
                            this.onBackgroundTaskCompleted(result2, syncId, "CompletionCalculationCompleted");
                        }
                        catch (Exception e) {
                            LOGGER.error(StringUtils.getTraceString((Throwable)e));
                        }
                        return null;
                    };
                    Future<Void> future = executorService.submit(task);
                    executorService.shutdown();
                }
            }
            return ResponseEntity.ok(result);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    private void onBackgroundTaskCompleted(Map<String, Object> result, String syncId, String event) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String content = mapper.writeValueAsString(result);
            String requestId = null;
            if (PropertyValidator.isValid((Object)syncId) && syncId.contains("#")) {
                String[] syncIdArray = syncId.split("#");
                syncId = syncIdArray[0];
                requestId = syncIdArray[1];
            }
            JSONObject pushJson = new JSONObject();
            pushJson = new JSONObject();
            pushJson.put("type", (Object)"Auto");
            pushJson.put("push", (Object)"Self");
            pushJson.put("done", true);
            pushJson.put("requestParam", (Object)content);
            pushJson.put("metaMap", (Object)("{\"event\":\"" + event + "\", \"syncId\":\"" + syncId + "\"}"));
            String pushJsonStr = pushJson.toString();
            if (!PropertyValidator.isValid((Object)requestId)) {
                PushSender.sendMsg((String)pushJsonStr);
            } else {
                this.pushResponseRepository.save((Object)new PushResponse(requestId, pushJsonStr, Boolean.valueOf(true)));
            }
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        catch (JsonProcessingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    @RequestMapping(value={"/fetch-release-train-filters"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchAllReleaseTrainsFilters(@RequestBody Map<String, String> requestBody) {
        HashMap<String, List> result = new HashMap<String, List>();
        try {
            String releaseTrainID = requestBody.get("releaseTrainID");
            ArrayList<FilterCriteria> finalfiltersList = new ArrayList<FilterCriteria>();
            LOGGER.info("Received releaseTrainID: {}", (Object)releaseTrainID);
            if (releaseTrainID != null && !releaseTrainID.isEmpty()) {
                List filtersList = this.filterCriteriaRepository.findByReleaseTrainId(releaseTrainID);
                for (FilterCriteria filterCriteria : filtersList) {
                    finalfiltersList.add(filterCriteria);
                }
                result.put("releaseTrainFilters", filtersList);
                return ResponseEntity.ok(result);
            }
            return ResponseEntity.badRequest().body((Object)"Invalid releaseTrainID");
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/get-status-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getStatusBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map cfdStatsBasedData = new HashMap();
        try {
            cfdStatsBasedData = this.dashboardService.createDataForAreaChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(cfdStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-cfd-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getCFDBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map cfdStatsBasedData = new HashMap();
        try {
            cfdStatsBasedData = this.dashboardService.createDataForCFD(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(cfdStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-startendstatus-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getStartEndStatusBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map flowStatsBasedData = new HashMap();
        try {
            flowStatsBasedData = requestStr.get("groupBy") != null ? this.dashboardService.createDataForFlowTimeLineGraph(requestStr) : this.dashboardService.createDataForTimeFlowChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(flowStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"get-efficiency-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getEffiencyBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map flowStatsBasedData = new HashMap();
        try {
            flowStatsBasedData = this.dashboardService.createDataForFlowEfficiencyChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(flowStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"get-load-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getLoadBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map flowStatsBasedData = new HashMap();
        try {
            flowStatsBasedData = this.dashboardService.createDataForFlowLoadChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(flowStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"get-distribution-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getDistributionBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map flowStatsBasedData = new HashMap();
        try {
            flowStatsBasedData = this.dashboardService.createDataForFlowDistributionChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(flowStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"get-velocity-based-timeseries/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getVelocityBasedTimeSeriesGraphData(@RequestBody Map<String, Object> requestStr) {
        Map flowStatsBasedData = new HashMap();
        try {
            flowStatsBasedData = this.dashboardService.createDataForFlowVelocityChart(requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(flowStatsBasedData, HttpStatus.OK);
    }

    @RequestMapping(value={"/get-board-teams-sprints/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getSelectedBoardTeamsAndSprints(@PathVariable(value="id") String sessionId, @RequestBody Map<String, Object> requestStr) {
        Map teamsAndSprintsLists = new HashMap();
        try {
            teamsAndSprintsLists = this.dashboardService.boardTeamsAndSprintList(sessionId, requestStr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity(teamsAndSprintsLists, HttpStatus.OK);
    }

    @RequestMapping(value={"/{id}/retrieveItems"}, method={RequestMethod.POST})
    public ResponseEntity<Object> retrieveItems(@PathVariable(value="id") String id, @RequestBody String request) {
        HashMap result = new HashMap();
        try {
            Gson g = new Gson();
            6 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String filterBy = (String)requestBody.get("filterBy");
            Map responseJson = null;
            Date start = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("             Start at : " + start.getTime());
            LOGGER.info("==================================================");
            responseJson = this.rtItemFetchService.getBacklogItemsWithLevel(id, (Map)requestBody);
            Date end = new Date();
            LOGGER.info("==================================================");
            LOGGER.info("\t\t\t\tEnd at : " + (end.getTime() - start.getTime()));
            LOGGER.info("==================================================");
            Map res = (Map)responseJson.get("result");
            HashMap statusItemMap = new HashMap();
            if (res != null && res.containsKey("items")) {
                List items = (List)res.get("items");
                for (Map item : items) {
                    String itemId = (String)item.get("id");
                    Map statusMap = (Map)item.get("status");
                    if (statusMap == null || !statusMap.containsKey("id")) continue;
                    String statusId = (String)statusMap.get("id");
                    if (statusItemMap.containsKey(statusId)) {
                        ((Set)statusItemMap.get(statusId)).add(itemId);
                        continue;
                    }
                    HashSet<String> itemIdSet = new HashSet<String>();
                    itemIdSet.add(itemId);
                    statusItemMap.put(statusId, itemIdSet);
                }
            }
            ArrayList<String> statusIds = new ArrayList<String>();
            for (String statusId : statusItemMap.keySet()) {
                statusIds.add(statusId);
            }
            List listOfStatusData = this.statusRepository.findByIdIn(statusIds);
            HashMap statusCountMap = new HashMap();
            HashMap statusesByCategory = new HashMap();
            ArrayList itemsList = new ArrayList();
            for (Status status : listOfStatusData) {
                String statusCategory = status.getCategory();
                String statusId = status.getId();
                String statusTitle = status.getTitle();
                Set itemIds = statusItemMap.getOrDefault(statusId, new HashSet());
                HashMap<String, Object> itemInfo = new HashMap<String, Object>();
                itemInfo.put("title", statusTitle);
                itemInfo.put("id", statusId);
                itemInfo.put("key", statusCategory + "-" + statusTitle);
                itemInfo.put("count", itemIds.size());
                itemInfo.put("category", statusCategory);
                itemsList.add(itemInfo);
            }
            return new ResponseEntity(itemsList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/{id}/retrieveAdditionalItems"}, method={RequestMethod.POST})
    public ResponseEntity<Object> retrieveAdditionalItems(@PathVariable(value="id") String id, @RequestBody String request) {
        HashMap result = new HashMap();
        try {
            Gson g = new Gson();
            7 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            String groupBy = (String)requestBody.get("groupBy");
            String parentGroup = (String)requestBody.get("parentGroup");
            String realeaseTrainId = (String)requestBody.get("releaseTrainID");
            List selectedItems = (List)requestBody.get("selectedItems");
            Map responseJson = null;
            Date start = new Date();
            ArrayList items = new ArrayList();
            if (!groupBy.isEmpty()) {
                responseJson = this.dashboardService.groupByItems(groupBy, parentGroup, selectedItems, realeaseTrainId);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/retrieveGroupingForAlms"}, method={RequestMethod.POST})
    public ResponseEntity<Object> retrieveGroupingForAlms(@RequestBody String request) {
        HashMap result = new HashMap();
        try {
            Gson g = new Gson();
            8 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap requestBody = (HashMap)g.fromJson(request, T.getType());
            List almFields = this.dashboardService.retrieveGroupingForAlms(requestBody);
            HashMap<String, List> responseJson = new HashMap<String, List>();
            responseJson.put("almFields", almFields);
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/retrieveItemsData"}, method={RequestMethod.POST})
    public ResponseEntity<Object> retrieveItemsData(@RequestBody String requestBody) {
        try {
            Iterator filterDataList;
            Object filterDataObject;
            Gson g = new Gson();
            9 T = new /* Unavailable Anonymous Inner Class!! */;
            HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
            List<BacklogItem> backLogItems = new ArrayList();
            String releaseTrainId = (String)request.get("releaseTrainId");
            ArrayList itemIds = new ArrayList();
            String pageStr = (String)request.get("page");
            String sizeStr = (String)request.get("sizeOfPage");
            String selectedFilterType = (String)request.get("selectedFilterType");
            String additionalCriteria = null;
            String parentId = null;
            if ((String)request.get("additionalCriteria") != null) {
                additionalCriteria = (String)request.get("additionalCriteria");
                parentId = (String)request.get("selectedTeam");
            }
            int page = Integer.parseInt(pageStr);
            int size = Integer.parseInt(sizeStr);
            List itemsSelectedList = new ArrayList();
            itemsSelectedList = (List)request.get("itemSelected");
            ArrayList<String> selectedIds = new ArrayList<String>();
            for (LinkedTreeMap selectedItem : itemsSelectedList) {
                selectedIds.add((String)selectedItem.get((Object)"id"));
            }
            List SelectedIdsList = selectedIds.stream().map(ObjectId::new).collect(Collectors.toList());
            String filterId = "";
            if (request.get("filterData") != null && (filterDataObject = request.get("filterData")) instanceof List && !(filterDataList = (List)filterDataObject).isEmpty()) {
                filterId = (String)filterDataList.get(0);
            }
            if (!Objects.equals(filterId, "")) {
                String tempKey;
                List allBackLogItems;
                if (selectedFilterType.equals("status") && additionalCriteria == null) {
                    allBackLogItems = this.dashboardService.getBackLogItemsofStatusIdPaginated(SelectedIdsList, page, size, releaseTrainId);
                    for (BacklogItem item : allBackLogItems) {
                        tempKey = "";
                        if (!item.getAlmItemId().isEmpty()) {
                            tempKey = item.getAlmItemId();
                        } else if (item.getFields() != null) {
                            if (!item.getFields().get("externalKey").toString().isEmpty()) {
                                tempKey = (String)item.getFields().get("externalKey");
                            }
                        } else if (!item.getKendisKey().isEmpty()) {
                            tempKey = item.getKendisKey();
                        }
                        if (filterId.isEmpty()) continue;
                        if (tempKey.equals(filterId)) {
                            backLogItems.add(item);
                            break;
                        }
                        if (!tempKey.contains(filterId)) continue;
                        backLogItems.add(item);
                    }
                } else if (selectedFilterType.equals("teams") && additionalCriteria == null) {
                    allBackLogItems = this.dashboardService.getBackLogItemsofTeamIdsPaginated(selectedIds, page, size, releaseTrainId);
                    for (BacklogItem item : allBackLogItems) {
                        tempKey = "";
                        if (!item.getAlmItemId().isEmpty()) {
                            tempKey = item.getAlmItemId();
                        } else if (item.getFields() != null) {
                            if (!item.getFields().get("externalKey").toString().isEmpty()) {
                                tempKey = (String)item.getFields().get("externalKey");
                            }
                        } else if (!item.getKendisKey().isEmpty()) {
                            tempKey = item.getKendisKey();
                        }
                        if (filterId.isEmpty()) continue;
                        if (tempKey.equals(filterId)) {
                            backLogItems.add(item);
                            break;
                        }
                        if (!tempKey.contains(filterId)) continue;
                        backLogItems.add(item);
                    }
                } else if (selectedFilterType.equals("teams") && additionalCriteria.equals("statusCategory")) {
                    allBackLogItems = this.dashboardService.getBackLogItemsofTeamStatusCategoryPaginated(parentId, page, size, releaseTrainId, SelectedIdsList);
                    for (BacklogItem item : allBackLogItems) {
                        tempKey = "";
                        if (!item.getAlmItemId().isEmpty()) {
                            tempKey = item.getAlmItemId();
                        } else if (item.getFields() != null) {
                            if (!item.getFields().get("externalKey").toString().isEmpty()) {
                                tempKey = (String)item.getFields().get("externalKey");
                            }
                        } else if (!item.getKendisKey().isEmpty()) {
                            tempKey = item.getKendisKey();
                        }
                        if (filterId.isEmpty()) continue;
                        if (tempKey.equals(filterId)) {
                            backLogItems.add(item);
                            break;
                        }
                        if (!tempKey.contains(filterId)) continue;
                        backLogItems.add(item);
                    }
                }
            } else if (selectedFilterType.equals("status") && additionalCriteria == null) {
                backLogItems = this.dashboardService.getBackLogItemsofStatusIdPaginated(SelectedIdsList, page, size, releaseTrainId);
            } else if (selectedFilterType.equals("teams") && additionalCriteria == null) {
                backLogItems = this.dashboardService.getBackLogItemsofTeamIdsPaginated(selectedIds, page, size, releaseTrainId);
            } else if (selectedFilterType.equals("teams") && additionalCriteria.equals("statusCategory")) {
                backLogItems = this.dashboardService.getBackLogItemsofTeamStatusCategoryPaginated(parentId, page, size, releaseTrainId, SelectedIdsList);
            }
            for (BacklogItem item : backLogItems) {
                List teamContainerRelations = item.getTeamContainerRelations();
                HashSet<Team> teams = new HashSet<Team>();
                HashSet<Container> sprints = new HashSet<Container>();
                HashSet<String> relaltionIds = new HashSet<String>();
                for (BaseItemLink link : teamContainerRelations) {
                    String teamContainerId = link.getTeamContainerId();
                    relaltionIds.add(teamContainerId);
                    List teamContainers = this.teamContainerRepository.findByIdIn(relaltionIds);
                    for (TeamContainer teamContainer : teamContainers) {
                        Team team = this.teamRepository.findTeamById(teamContainer.getTeam().getId());
                        teams.add(team);
                        Container sprint = this.containerRepository.findById(teamContainer.getContainer().getId());
                        sprints.add(sprint);
                    }
                }
                List boardContainerRelations = item.getBoardRelations();
                ArrayList<Session> boards = new ArrayList<Session>();
                for (BaseItemLink link : boardContainerRelations) {
                    String boardRelationId = link.getSessionId();
                    boards.add(this.sessionRepository.findById(boardRelationId));
                }
                List solutionboardContainerRelations = item.getSolutionRelations();
                ArrayList<SolutionBoard> solutionBoards = new ArrayList<SolutionBoard>();
                for (BaseItemLink link : solutionboardContainerRelations) {
                    String solutionBoardRelationId = link.getSolutionId();
                    solutionBoards.add(this.solutionBoardRepository.findById(solutionBoardRelationId));
                }
                Map ChildrenContainer = item.getChildRelationMap();
                double totalEstimates = 0.0;
                ArrayList<ObjectId> childIds = new ArrayList<ObjectId>();
                List childList = new ArrayList();
                childList = (List)ChildrenContainer.get(item.getId());
                if (childList != null) {
                    Object link2;
                    for (Object link2 : childList) {
                        String input = link2.getCustomId();
                        Object[] parts = input.split("_");
                        ObjectId objectId = new ObjectId(Arrays.toString(parts));
                        childIds.add(objectId);
                    }
                    List childBacklogItems = this.rtItemFetchService.findBacklogItemsByItemIdsIn(releaseTrainId, childIds);
                    link2 = childBacklogItems.iterator();
                    while (link2.hasNext()) {
                        BacklogItem childItem = (BacklogItem)link2.next();
                        totalEstimates += childItem.getStoryPoints().doubleValue();
                    }
                }
                List finalTeams = teams.stream().collect(Collectors.toList());
                item.setTeamData(finalTeams);
                List finalSprints = sprints.stream().collect(Collectors.toList());
                item.setContainerData(finalSprints);
                item.setBoardsData(boards);
                item.setSolutionBoardsData(solutionBoards);
                item.setTotalEstimate(Double.valueOf(totalEstimates));
            }
            return new ResponseEntity(backLogItems, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/getAllDashboardWidgets"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getAllDashboardWidgets(@RequestBody String requestBody) {
        Gson g = new Gson();
        10 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        String dashboardId = (String)request.get("dashboardId");
        try {
            if (PropertyValidator.isValid((Object)dashboardId)) {
                boolean dashboardUserValidated = false;
                Map dashboardRole = this.dashboardService.getUserDashboardAccessRole(dashboardId);
                if (PropertyValidator.isValid((Object)dashboardRole)) {
                    if (PropertyValidator.isValid(dashboardRole.get("userRole"))) {
                        dashboardUserValidated = true;
                    } else {
                        responseJson.put("error", "noAccessRights");
                    }
                }
                if (dashboardUserValidated) {
                    Map result = this.dashboardService.getDashboardWidgetsMap(dashboardId);
                    List curDashboardWidgets = (List)result.get("widgets");
                    String Id2 = (String)result.get("dashboardId");
                    Date dashboardDate = (Date)result.get("dashboardDate");
                    Map res = this.dashboardService.getUserDashboardAccessRole(dashboardId);
                    responseJson.put("myRole", res.get("userRole"));
                    responseJson.put("widgetMap", result.get("widgetMap"));
                    responseJson.put("dashboardDate", dashboardDate);
                    responseJson.put("allgroupsMap", result.get("allgroupsMap"));
                    responseJson.put("dashboardName", result.get("dashboardName"));
                    responseJson.put("dashboardDescription", result.get("dashboardDescription"));
                    responseJson.put("globalColorsMap", result.get("globalColorsMap"));
                    responseJson.put("dashboard", result.get("dashboard"));
                }
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/getSingleWidget"}, method={RequestMethod.POST})
    public ResponseEntity<Object> getDashboardWidget(@RequestBody String requestBody) {
        Gson g = new Gson();
        11 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        HashMap<String, Widget> responseJson = new HashMap<String, Widget>();
        String widgetId = (String)request.get("widgetId");
        try {
            if (PropertyValidator.isValid((Object)widgetId)) {
                Widget widget = this.dashboardService.getWidget(widgetId);
                responseJson.put("widget", widget);
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/syncDashboardWidgets"}, method={RequestMethod.POST})
    public ResponseEntity<Object> syncDashboardWidgets(@RequestBody String requestBody) {
        Gson g = new Gson();
        12 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        Map responseJson = new HashMap();
        String dashboardId = (String)request.get("dashboardId");
        try {
            if (PropertyValidator.isValid((Object)dashboardId)) {
                Map result = new HashMap();
                result = this.dashboardService.getDashboardWidgets(dashboardId);
                List allWidgets = (List)result.get("widgets");
                ArrayList updatedWidgets = new ArrayList();
                if (allWidgets.size() > 0) {
                    updatedWidgets.addAll(this.dashboardService.updateBacklogItemsStatusWidgetCriteria(allWidgets));
                    responseJson = this.dashboardService.updateDashboardWidgets(dashboardId, updatedWidgets);
                }
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/syncDashboardWidget"}, method={RequestMethod.POST})
    public ResponseEntity<Object> syncDashboardWidget(@RequestBody String requestBody) {
        Gson g = new Gson();
        13 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        HashMap<String, Widget> responseJson = new HashMap<String, Widget>();
        String dashboardKey = (String)request.get("dashboardId");
        String widgetId = (String)request.get("widgetId");
        try {
            if (PropertyValidator.isValid((Object)dashboardKey) && PropertyValidator.isValid((Object)widgetId)) {
                responseJson.put("widget", this.dashboardService.updateSingleBacklogItemsStatusWidgetCriteria(widgetId, dashboardKey));
            }
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/syncDashboardWidgetCFD"}, method={RequestMethod.POST})
    public ResponseEntity<Object> syncDashboardWidgetCFD(@RequestBody String requestBody) {
        Gson g = new Gson();
        14 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        HashMap responseJson = new HashMap();
        String dashboardId = (String)request.get("dashboardId");
        String widgetId = (String)request.get("widgetId");
        try {
            return new ResponseEntity((Object)this.dashboardService.updateSingleCFDItemsWidgetCriteria(widgetId, dashboardId), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/syncDashboardWidgetCS"}, method={RequestMethod.POST})
    public ResponseEntity<Object> syncDashboardWidgetCS(@RequestBody String requestBody) {
        Gson g = new Gson();
        15 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap request = (HashMap)g.fromJson(requestBody, T.getType());
        HashMap responseJson = new HashMap();
        String dashboardId = (String)request.get("dashboardId");
        String widgetId = (String)request.get("widgetId");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        String syncId = (String)request.get("syncId");
        try {
            Callable<Void> task = () -> {
                try {
                    Map result2 = this.dashboardService.updateSingleCSItemsWidgetCriteria(widgetId, dashboardId);
                    this.onBackgroundTaskCompleted(result2, syncId, "CompletionCalculationCompleted");
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                }
                return null;
            };
            Future<Void> future = executorService.submit(task);
            executorService.shutdown();
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetchALMTFSMeta/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchALMTFSMeta(@PathVariable(value="id") String id) {
        Map result = new HashMap();
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(id)));
            SessionBoard sessionBoard = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
            result = this.dashboardService.fetchALMTFSMeta(sessionBoard);
            return new ResponseEntity(result, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetch-item-details-list/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchItemDetails(@RequestBody Map<String, Map<String, Object>> requestMap) {
        HashMap result = new HashMap();
        try {
            List resultList = this.dashboardService.fetchItemDetails(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetchGroupByOptions/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchGroupByOptions(@RequestBody Map<String, String> requestStr) {
        HashMap result = new HashMap();
        try {
            List resultList = this.dashboardService.fetchGroupBySubOptions(requestStr);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetch-cfd-item-details/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchCFDItemDetails(@RequestBody Map<String, Object> requestMap) {
        HashMap result = new HashMap();
        try {
            List resultList = this.dashboardService.fetchCFDItemDetails(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetch-all-item-details/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchAllItemDetails(@RequestBody Map<String, Object> requestMap) {
        HashMap result = new HashMap();
        try {
            List resultList = this.dashboardService.fetchAllItemDetails(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/searchItems/"}, method={RequestMethod.POST})
    public ResponseEntity<Object> searchItemsofBoard(@RequestBody Map<String, Object> requestMap) {
        HashMap result = new HashMap();
        try {
            Map resultList = this.dashboardService.searchItems(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetchgrouptitles"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchGroupTitles(@RequestBody Map<String, Object> requestMap) {
        HashMap result = new HashMap();
        try {
            Map resultList = this.dashboardService.fetchGroupTitles(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }

    @RequestMapping(value={"/fetchItemsMeta"}, method={RequestMethod.POST})
    public ResponseEntity<Object> fetchStatusMeta(@RequestBody Map<String, Object> requestMap) {
        HashMap result = new HashMap();
        try {
            Map resultList = this.dashboardService.fetchStatusTitles(requestMap);
            return new ResponseEntity((Object)resultList, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return ResponseEntity.badRequest().build();
        }
    }
}

