/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.dto.ApiResponseDTO;
import com.viztrend.safe.dto.BatchInfrastructureStatusResponseDTO;
import com.viztrend.safe.dto.BatchTypeStatusResponseDTO;
import com.viztrend.safe.dto.SystemFieldResponseDTO;
import com.viztrend.safe.dto.SystemFieldsListResponseDTO;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.mapper.SystemFieldMapper;
import com.viztrend.safe.persistence.entity.Fields;
import com.viztrend.safe.persistence.entity.FieldsLayout;
import com.viztrend.safe.service.BatchInfrastructureService;
import com.viztrend.safe.service.CustomFieldService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/customfield"})
@Controller
public class CustomFieldController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFieldController.class);
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private BatchInfrastructureService batchInfrastructureService;
    @Autowired
    private SystemFieldMapper systemFieldMapper;

    @RequestMapping(value={"/fetch-list"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getCustomFieldList() {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            this.customFieldService.scriptToCreateItemTypes();
            responseJson.put("list", this.customFieldService.fetchAllCustomFields());
            responseJson.put("modules", this.customFieldService.getItemTypeList());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-modules"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getModulesList() {
        try {
            return new ResponseEntity((Object)this.customFieldService.getItemTypeList(), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveCustomField(@RequestBody Fields field) {
        try {
            Map responseJson = this.customFieldService.saveCustomField(field);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/archive/{archiveFlag}/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> archiveWorspace(@PathVariable(value="archiveFlag") Boolean archive, @PathVariable(value="fieldId") String fieldId) {
        try {
            Map responseJson = this.customFieldService.archiveCustomField(fieldId, archive);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-fields/{itemType}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getItemTypeFields(@PathVariable(value="itemType") String itemType) {
        try {
            Map responseJson = this.customFieldService.getKendisCustomFields(itemType);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/save-layout"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> saveLayout(@RequestBody FieldsLayout fieldsLayout) {
        try {
            Map responseJson = this.customFieldService.saveFieldsLayout(fieldsLayout);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/fetch-layouts"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> getFieldLayouts() {
        try {
            HashMap<String, List> responseJson = new HashMap<String, List>();
            responseJson.put("layouts", this.customFieldService.fetchAllCustomFieldLayout());
            responseJson.put("modules", this.customFieldService.getItemTypeList());
            return new ResponseEntity(responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-default/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> markLayoutDefault(@PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.markLayoutAsDefault(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/layout/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getLayoutByItemType(@PathVariable(value="type") String type) {
        try {
            return new ResponseEntity((Object)this.customFieldService.getAllLayoutsByItemType(type), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-archive/{archiveFlag}/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> archiveLayout(@PathVariable(value="archiveFlag") Boolean archive, @PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.archiveLayout(id, archive);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/layout-delete/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<Object> deleteLayout(@PathVariable(value="id") String id) {
        try {
            Map responseJson = this.customFieldService.deleteLayout(id);
            return new ResponseEntity((Object)responseJson, HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/get/default-layout/{type}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> getDefaultLayout(@PathVariable(value="type") String type) {
        try {
            return new ResponseEntity((Object)this.customFieldService.getDefaultLayoutFromItemType(type), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @RequestMapping(value={"/create-default-layout"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> createDefaultLayouts() {
        try {
            return new ResponseEntity((Object)this.customFieldService.createDefaultLayouts(), HttpStatus.OK);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(null, HttpStatus.BAD_REQUEST);
        }
    }

    @GetMapping(value={"/fetch-system-fields"})
    @ResponseBody
    public ResponseEntity<ApiResponseDTO<SystemFieldsListResponseDTO>> getSystemFields() {
        try {
            LOGGER.debug("Fetching system fields request received");
            List systemFields = this.customFieldService.fetchCustomisableSystemFields();
            LOGGER.debug("Retrieved {} system fields from service", (Object)(systemFields != null ? systemFields.size() : 0));
            SystemFieldsListResponseDTO responseDTO = this.systemFieldMapper.toSystemFieldsListResponseDTO(systemFields);
            ApiResponseDTO apiResponse = ApiResponseDTO.success((Object)responseDTO, (String)"System fields fetched successfully");
            LOGGER.info("Successfully fetched {} system fields", (Object)responseDTO.getTotalCount());
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            LOGGER.error("System fields fetch error stack trace: {}", (Object)StringUtils.getTraceString((Throwable)e));
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)"Failed to fetch system fields", (String)"SYSTEM_FIELDS_FETCH_ERROR");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
    }

    @PostMapping(value={"/enable-batch-type"})
    @ResponseBody
    public ResponseEntity<ApiResponseDTO<SystemFieldResponseDTO>> enableBatchType() {
        try {
            LOGGER.info("Enable batch type field request received");
            Fields field = this.customFieldService.createAndEnableBatchTypeField();
            LOGGER.info("Batch type field enabled successfully with ID: {}", (Object)field.getId());
            SystemFieldResponseDTO responseDTO = this.systemFieldMapper.toSystemFieldResponseDTO(field);
            ApiResponseDTO apiResponse = ApiResponseDTO.success((Object)responseDTO, (String)"Batch type field enabled successfully");
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (KendisException e) {
            LOGGER.warn("Failed to enable batch type field: {} - {}", (Object)e.getCode(), (Object)e.getMessage());
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)e.getMessage(), (String)e.getCode());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
        catch (Exception e) {
            LOGGER.error("Batch type enable error stack trace: {}", (Object)StringUtils.getTraceString((Throwable)e));
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)"Failed to enable batch type field", (String)"BATCH_TYPE_ENABLE_ERROR");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
    }

    @GetMapping(value={"/batch-type-status"})
    @ResponseBody
    public ResponseEntity<ApiResponseDTO<BatchTypeStatusResponseDTO>> getBatchTypeStatus() {
        try {
            LOGGER.debug("Fetching batch type status request received");
            Boolean isEnabled = this.customFieldService.isBatchTypeFieldEnabled();
            LOGGER.debug("Batch type field enabled status: {}", (Object)isEnabled);
            BatchTypeStatusResponseDTO responseDTO = new BatchTypeStatusResponseDTO(isEnabled);
            ApiResponseDTO apiResponse = ApiResponseDTO.success((Object)responseDTO, (String)"Batch type status fetched successfully");
            LOGGER.info("Successfully fetched batch type status: {}", (Object)isEnabled);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            LOGGER.error("Batch type status fetch error stack trace: {}", (Object)StringUtils.getTraceString((Throwable)e));
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)"Failed to fetch batch type status", (String)"BATCH_TYPE_STATUS_FETCH_ERROR");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
    }

    @GetMapping(value={"/batch-infrastructure-status"})
    @ResponseBody
    public ResponseEntity<ApiResponseDTO<BatchInfrastructureStatusResponseDTO>> getBatchInfrastructureStatus() {
        try {
            LOGGER.debug("Fetching batch infrastructure status request received");
            Boolean infrastructureExists = this.batchInfrastructureService.isBatchInfrastructureExists();
            Boolean batchTypeEnabled = this.customFieldService.isBatchTypeFieldEnabled();
            LOGGER.debug("Batch infrastructure exists: {}, Batch type enabled: {}", (Object)infrastructureExists, (Object)batchTypeEnabled);
            BatchInfrastructureStatusResponseDTO response = BatchInfrastructureStatusResponseDTO.builder().infrastructureExists(infrastructureExists).batchTypeEnabled(batchTypeEnabled).canEnableBatchType(Boolean.valueOf(infrastructureExists != false && batchTypeEnabled == false)).build();
            ApiResponseDTO apiResponse = ApiResponseDTO.success((Object)response, (String)"Batch infrastructure status fetched successfully");
            LOGGER.info("Successfully fetched batch infrastructure status - exists: {}, enabled: {}", (Object)infrastructureExists, (Object)batchTypeEnabled);
            return ResponseEntity.ok((Object)apiResponse);
        }
        catch (Exception e) {
            LOGGER.error("Batch infrastructure status fetch error stack trace: {}", (Object)StringUtils.getTraceString((Throwable)e));
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)"Failed to fetch batch infrastructure status", (String)"BATCH_INFRASTRUCTURE_STATUS_FETCH_ERROR");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
    }

    @PostMapping(value={"/initialize-batch-infrastructure"})
    @ResponseBody
    public ResponseEntity<ApiResponseDTO<Map<String, Object>>> initializeBatchInfrastructure() {
        try {
            LOGGER.debug("Initialize batch infrastructure request received (using upsert - safe to call multiple times)");
            Map result = this.batchInfrastructureService.initializeBatchInfrastructure();
            ApiResponseDTO response = ApiResponseDTO.success((Object)result, (String)"Batch infrastructure initialized successfully");
            LOGGER.info("Successfully initialized/updated batch infrastructure");
            return ResponseEntity.ok((Object)response);
        }
        catch (KendisException e) {
            LOGGER.warn("Business error initializing infrastructure: {} - {}", (Object)e.getCode(), (Object)e.getMessage());
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)e.getMessage(), (String)e.getCode());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
        catch (Exception e) {
            LOGGER.error("Error initializing batch infrastructure: {}", (Object)e.getMessage());
            LOGGER.debug("Error stack trace: {}", (Object)StringUtils.getTraceString((Throwable)e));
            ApiResponseDTO errorResponse = ApiResponseDTO.error((String)"Failed to initialize batch infrastructure", (String)"INFRASTRUCTURE_INIT_ERROR");
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
        }
    }
}

