/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.viztrend.safe.annotations.SchedLock;
import com.viztrend.safe.controller.ConfidenceVoteSurveyController;
import com.viztrend.safe.controller.PlanController;
import com.viztrend.safe.persistence.entity.AnswerTemplate;
import com.viztrend.safe.persistence.entity.Option;
import com.viztrend.safe.persistence.entity.Question;
import com.viztrend.safe.persistence.entity.Questionnaire;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.repository.AnswerRepository;
import com.viztrend.safe.persistence.repository.AnswerTemplateRepository;
import com.viztrend.safe.persistence.repository.QuestionRepository;
import com.viztrend.safe.persistence.repository.QuestionnaireRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.SessionRepository;
import com.viztrend.safe.service.ConfidenceVoteSurveyService;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/confidencevotesurvey"})
@Controller
public class ConfidenceVoteSurveyController {
    @Autowired
    private ConfidenceVoteSurveyService confidenceVoteSurveyService;
    @Autowired
    private SessionRepository sessionRepository;
    @Autowired
    private SessionBoardRepository sessionBoardRepository;
    @Autowired
    private AnswerTemplateRepository answerTemplateRepository;
    @Autowired
    private QuestionnaireRepository questionnaireRepository;
    @Autowired
    private QuestionRepository questionRepository;
    @Autowired
    private AnswerRepository answerRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanController.class);

    @RequestMapping(value={"/create/{sessionId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> createQuestionnaire(@RequestBody String payload, @PathVariable(value="sessionId") String sessionId) {
        Gson g = new Gson();
        1 T = new /* Unavailable Anonymous Inner Class!! */;
        HashMap reqbody = (HashMap)g.fromJson(payload, T.getType());
        String question = (String)reqbody.get("questions");
        String confidenceVote = (String)reqbody.get("confidenceVote");
        String deselectedTeams = (String)reqbody.get("deselectedTeams");
        ObjectMapper map = new ObjectMapper();
        List questions = null;
        try {
            questions = (List)map.readValue(question, (JavaType)map.getTypeFactory().constructCollectionType(List.class, Question.class));
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage());
        }
        Questionnaire questionnaire = null;
        try {
            questionnaire = (Questionnaire)map.readValue(confidenceVote, Questionnaire.class);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage());
        }
        List teams = null;
        try {
            teams = (List)map.readValue(deselectedTeams, (JavaType)map.getTypeFactory().constructCollectionType(List.class, Team.class));
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage());
        }
        Map urlTokenAndId = this.confidenceVoteSurveyService.addNewQuestionnaire(questionnaire, sessionId, questions, teams);
        if (urlTokenAndId.containsKey("error")) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        Questionnaire savedQuestionnaire = (Questionnaire)urlTokenAndId.get("confidenceVote");
        List savedQuestions = (List)urlTokenAndId.get("questions");
        Session session = this.sessionRepository.findById(sessionId);
        HashMap sessionAndQuestions = new HashMap();
        sessionAndQuestions.put("savedQuestions", savedQuestions);
        sessionAndQuestions.put("session", session);
        sessionAndQuestions.put("confidenceVote", savedQuestionnaire);
        HashMap<String, Object> pushJson = new HashMap<String, Object>();
        pushJson.put("confidenceVote", savedQuestionnaire);
        pushJson.put("metaMap", "{\"event\":\"confidenceVoteSaved\"}");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(sessionAndQuestions, HttpStatus.OK);
    }

    @RequestMapping(value={"/fetchQuestionnaire/{questionnaireId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> fetchQuestionnaire(@PathVariable(value="questionnaireId") String questionnaireId) {
        Questionnaire questionnaire = this.confidenceVoteSurveyService.fetchQuestionnaire(questionnaireId);
        if (!PropertyValidator.isValid((Object)questionnaire)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)questionnaire, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSession/{sessionId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getSession(@PathVariable(value="sessionId") String sessionId) {
        Session session = this.confidenceVoteSurveyService.getSession(sessionId);
        return new ResponseEntity((Object)session, HttpStatus.OK);
    }

    @RequestMapping(value={"/getTeams/{sessionId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getTeams(@PathVariable(value="sessionId") String sessionId) {
        List teamList = this.confidenceVoteSurveyService.getTeams(sessionId);
        return new ResponseEntity((Object)teamList, HttpStatus.OK);
    }

    @RequestMapping(value={"/getQuestions/{questionnaireId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getQuestions(@PathVariable(value="questionnaireId") String questionnaireId) {
        List questionList = this.confidenceVoteSurveyService.getQuestionList(questionnaireId);
        return new ResponseEntity((Object)questionList, HttpStatus.OK);
    }

    @RequestMapping(value={"/saveVote/{questionnaireId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> saveVote(@RequestBody HashMap<String, Object> payload, @PathVariable(value="questionnaireId") String questionnaireId) {
        Map answersAndAnswerCounts = new HashMap();
        answersAndAnswerCounts = this.confidenceVoteSurveyService.saveVote(payload, questionnaireId, null);
        if (answersAndAnswerCounts.containsKey("error")) {
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(answersAndAnswerCounts, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAnswers/{questionnaireId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getAnswers(@PathVariable(value="questionnaireId") String questionnaireId) {
        List answers = this.confidenceVoteSurveyService.getAnswers(questionnaireId, null);
        List answerVOs = this.confidenceVoteSurveyService.convertAnswerToAnswerVO(answers);
        return new ResponseEntity((Object)answerVOs, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAnswers/{questionnaireId}/{userId:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> isVoteSubmitted(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="userId") String userId) {
        boolean voteSubmission = this.confidenceVoteSurveyService.getAnswersByUser(questionnaireId, userId, null);
        return new ResponseEntity((Object)voteSubmission, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAnswersCount/{questionnaireId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getAnswersCount(@PathVariable(value="questionnaireId") String questionnaireId) {
        Map answerCount = this.confidenceVoteSurveyService.getAnswersCount(questionnaireId, null);
        return new ResponseEntity((Object)answerCount, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAnswerTemplateId"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getAnswerTemplateId() {
        List answerTemplate = this.answerTemplateRepository.findByName("Confidence Vote");
        String answerTemplateId = null;
        answerTemplateId = answerTemplate.isEmpty() ? this.setAnswerTemplate() : ((AnswerTemplate)answerTemplate.get(0)).getId();
        return new ResponseEntity((Object)answerTemplateId, HttpStatus.OK);
    }

    @RequestMapping(value={"/getSessionByConfidenceVoteId/{confidenceVoteId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> getSessionByConfidenceVoteId(@PathVariable(value="confidenceVoteId") String confidenceVoteId) {
        Session session = this.confidenceVoteSurveyService.getSessionByConfidenceVoteId(confidenceVoteId);
        if (!PropertyValidator.isValid((Object)session)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity((Object)session, HttpStatus.OK);
    }

    @RequestMapping(value={"/getAnswers/{questionnaireId}/{questionId}/{userId:.+}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> isVoteSubmittedForTeam(@PathVariable(value="questionnaireId") String questionnaireId, @PathVariable(value="userId") String userId, @PathVariable(value="questionId") String questionId) {
        boolean voteSubmission = this.confidenceVoteSurveyService.getAnswerForTeamByUser(questionId, userId);
        return new ResponseEntity((Object)voteSubmission, HttpStatus.OK);
    }

    public String setAnswerTemplate() {
        AnswerTemplate at = new AnswerTemplate();
        at.setName("Confidence Vote");
        at.setFieldType("dropdown");
        ArrayList<Option> ansOptions = new ArrayList<Option>();
        Option op = new Option();
        op.setIcon("");
        op.setLabel("DU");
        op.setValue("I don't understand");
        ansOptions.add(op);
        Option op1 = new Option();
        op1.setIcon("");
        op1.setLabel("NC");
        op1.setValue("No confidence");
        ansOptions.add(op1);
        Option op2 = new Option();
        op2.setIcon("");
        op2.setLabel("LC");
        op2.setValue("Little confidence");
        ansOptions.add(op2);
        Option op3 = new Option();
        op3.setIcon("");
        op3.setLabel("GC");
        op3.setValue("Good confidence");
        ansOptions.add(op3);
        Option op4 = new Option();
        op4.setIcon("");
        op4.setLabel("HC");
        op4.setValue("High confidence");
        ansOptions.add(op4);
        Option op5 = new Option();
        op5.setIcon("");
        op5.setLabel("VHC");
        op5.setValue("Very High confidence");
        ansOptions.add(op5);
        at.setOptions(ansOptions);
        at = (AnswerTemplate)this.answerTemplateRepository.save((Object)at);
        return at.getId();
    }

    @RequestMapping(value={"/decryptUrl/{token}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> decryptToken(@PathVariable(value="token") String token) {
        String x = null;
        x = this.confidenceVoteSurveyService.decryptToken(token);
        return new ResponseEntity((Object)x, HttpStatus.OK);
    }

    @RequestMapping(value={"/notificationack/{voteId}/{type}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> notificationAcknowledged(@PathVariable(value="voteId") String voteId, @PathVariable(value="type") String type) {
        Questionnaire questionnaire = this.questionnaireRepository.findById(voteId);
        if (type.equals("start")) {
            questionnaire.setVoteStartNotified(Questionnaire.Notified.ACKNOWLEDGED);
        }
        if (type.equals("end")) {
            questionnaire.setVoteEndNotified(Questionnaire.Notified.ACKNOWLEDGED);
        }
        this.questionnaireRepository.save((Object)questionnaire);
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/notifyService/{voteId}"}, method={RequestMethod.GET})
    public ResponseEntity<Object> voteNotifyOnBoard(@PathVariable(value="voteId") String voteId) {
        long millis = System.currentTimeMillis();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"votingStartDate").lte((Object)new Date(millis + 600000L)).andOperator(new Criteria[]{Criteria.where((String)"voteStartNotified").ne((Object)"ACKNOWLEDGED").andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)voteId).andOperator(new Criteria[]{Criteria.where((String)"hasVotingStarted").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingResumed").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingEnded").is((Object)false)})})})})}));
        List questionnaires = this.mongoTemplate.find(query, Questionnaire.class);
        if (!questionnaires.isEmpty()) {
            for (Questionnaire q : questionnaires) {
                HashMap<String, String> pushJson = new HashMap<String, String>();
                String filePath = "assets/js/confidence-vote-notification.js";
                SimpleDateFormat sD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                String voteStartDate = sD.format(q.getVotingStartDate());
                boolean isVoteStarted = q.isHasVotingStarted();
                pushJson.put("metaMap", "{\"event\":\"VoteStart\", \"time\":\"" + voteStartDate + "\", \"script\":\"" + filePath + "\", \"isVoteStarted\": " + isVoteStarted + ", \"voteId\":\"" + q.getId() + "\",\"isVoteTimeEnded\":" + false + "}");
                if (q.isHasVotingEnded()) continue;
                ObjectMapper mapper = new ObjectMapper();
                try {
                    PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                    q.setVoteStartNotified(Questionnaire.Notified.NOTIFIED);
                    this.questionnaireRepository.save((Object)q);
                }
                catch (JsonProcessingException e) {
                    LOGGER.debug(e.getMessage());
                }
            }
        } else {
            Query voteEndQuery = new Query();
            voteEndQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"votingStartDate").lte((Object)new Date(millis + 600000L)).andOperator(new Criteria[]{Criteria.where((String)"voteEndNotified").ne((Object)"ACKNOWLEDGED").andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)voteId).andOperator(new Criteria[]{Criteria.where((String)"hasVotingStarted").is((Object)true).andOperator(new Criteria[]{Criteria.where((String)"hasVotingResumed").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingEnded").is((Object)false)})})})})}));
            List endQuestionnaires = this.mongoTemplate.find(voteEndQuery, Questionnaire.class);
            long ONE_MINUTE_IN_MILLIS = 60000L;
            for (Questionnaire questionnaire : endQuestionnaires) {
                long curTimeInMs;
                Date afterAddingMins;
                if (!PropertyValidator.isValid((Object)questionnaire.getVoteStartedDate()) || new Date().compareTo(afterAddingMins = new Date((curTimeInMs = questionnaire.getVoteStartedDate().getTime()) + (long)questionnaire.getDuration() * 60000L)) <= 0) continue;
                HashMap<String, String> pushJson = new HashMap<String, String>();
                String filePath = "assets/js/confidence-vote-notification.js";
                SimpleDateFormat sD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
                String voteStartDate = sD.format(questionnaire.getVotingStartDate());
                boolean isVoteStarted = questionnaire.isHasVotingStarted();
                pushJson.put("metaMap", "{\"event\":\"VoteStart\", \"time\":\"" + voteStartDate + "\", \"script\":\"" + filePath + "\", \"isVoteStarted\": " + isVoteStarted + ", \"voteId\":\"" + questionnaire.getId() + "\",\"isVoteTimeEnded\":" + true + "}");
                ObjectMapper mapper = new ObjectMapper();
                try {
                    PushSender.sendMsg((String)mapper.writeValueAsString(pushJson));
                    questionnaire.setVoteEndNotified(Questionnaire.Notified.NOTIFIED);
                    this.questionnaireRepository.save((Object)questionnaire);
                }
                catch (JsonProcessingException e) {
                    LOGGER.debug(e.getMessage());
                }
            }
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @RequestMapping(value={"/resetVote/{sessionId}"}, method={RequestMethod.POST})
    public ResponseEntity<Object> resetQuestionnaire(@PathVariable(value="sessionId") String sessionId) {
        Session session = this.sessionRepository.findById(sessionId);
        List questionnaire = session.getConfidenceVoteSurvey();
        session.setConfidenceVoteSurvey(null);
        List questions = this.questionRepository.findByQuestionnaireId(((Questionnaire)questionnaire.get(0)).getId());
        ArrayList<String> questionIdsToDelete = new ArrayList<String>();
        for (Question question : questions) {
            questionIdsToDelete.add(question.getId());
        }
        this.answerRepository.deleteByQuestionIdIn(questionIdsToDelete);
        this.questionRepository.deleteByIdIn(questionIdsToDelete);
        this.questionnaireRepository.delete((Serializable)((Object)((Questionnaire)questionnaire.get(0)).getId()));
        this.sessionRepository.save((Object)session);
        HashMap<String, String> pushJson = new HashMap<String, String>();
        pushJson.put("metaMap", "{\"event\":\"voteReset\"}");
        ObjectMapper mapper = new ObjectMapper();
        try {
            PushSender.sendMsg((String)((Questionnaire)questionnaire.get(0)).getCompanyId(), (String)mapper.writeValueAsString(pushJson));
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage());
        }
        return new ResponseEntity(HttpStatus.OK);
    }

    @SchedLock(name="voteNotify")
    @Scheduled(cron="0 0/3 * * * ?")
    public Boolean voteNotify() {
        long millis = System.currentTimeMillis();
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"votingStartDate").lte((Object)new Date(millis + 600000L)).andOperator(new Criteria[]{Criteria.where((String)"voteStartNotified").ne((Object)"ACKNOWLEDGED").andOperator(new Criteria[]{Criteria.where((String)"hasVotingStarted").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingResumed").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingEnded").is((Object)false)})})})}));
        List questionnaires = this.mongoTemplate.find(query, Questionnaire.class);
        for (Questionnaire q : questionnaires) {
            HashMap<String, String> pushJson = new HashMap<String, String>();
            String filePath = "assets/js/confidence-vote-notification.js";
            SimpleDateFormat sD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            String voteStartDate = sD.format(q.getVotingStartDate());
            boolean isVoteStarted = q.isHasVotingStarted();
            pushJson.put("metaMap", "{\"event\":\"VoteStart\", \"time\":\"" + voteStartDate + "\", \"script\":\"" + filePath + "\", \"isVoteStarted\": " + isVoteStarted + ", \"voteId\":\"" + q.getId() + "\",\"isVoteTimeEnded\":" + false + "}");
            if (q.isHasVotingEnded()) continue;
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)q.getCompanyId(), (String)mapper.writeValueAsString(pushJson));
                q.setVoteStartNotified(Questionnaire.Notified.NOTIFIED);
                this.questionnaireRepository.save((Object)q);
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        Query voteEndQuery = new Query();
        voteEndQuery.addCriteria((CriteriaDefinition)Criteria.where((String)"votingStartDate").lte((Object)new Date(millis + 600000L)).andOperator(new Criteria[]{Criteria.where((String)"voteEndNotified").ne((Object)"ACKNOWLEDGED").andOperator(new Criteria[]{Criteria.where((String)"hasVotingStarted").is((Object)true).andOperator(new Criteria[]{Criteria.where((String)"hasVotingResumed").is((Object)false).andOperator(new Criteria[]{Criteria.where((String)"hasVotingEnded").is((Object)false)})})})}));
        List endQuestionnaires = this.mongoTemplate.find(voteEndQuery, Questionnaire.class);
        long ONE_MINUTE_IN_MILLIS = 60000L;
        for (Questionnaire questionnaire : endQuestionnaires) {
            long curTimeInMs;
            Date afterAddingMins;
            if (!PropertyValidator.isValid((Object)questionnaire.getVoteStartedDate()) || new Date().compareTo(afterAddingMins = new Date((curTimeInMs = questionnaire.getVoteStartedDate().getTime()) + (long)questionnaire.getDuration() * 60000L)) <= 0) continue;
            HashMap<String, String> pushJson = new HashMap<String, String>();
            String filePath = "assets/js/confidence-vote-notification.js";
            SimpleDateFormat sD = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            String voteStartDate = sD.format(questionnaire.getVotingStartDate());
            boolean isVoteStarted = questionnaire.isHasVotingStarted();
            pushJson.put("metaMap", "{\"event\":\"VoteStart\", \"time\":\"" + voteStartDate + "\", \"script\":\"" + filePath + "\", \"isVoteStarted\": " + isVoteStarted + ", \"voteId\":\"" + questionnaire.getId() + "\",\"isVoteTimeEnded\":" + true + "}");
            ObjectMapper mapper = new ObjectMapper();
            try {
                PushSender.sendMsg((String)questionnaire.getCompanyId(), (String)mapper.writeValueAsString(pushJson));
                questionnaire.setVoteEndNotified(Questionnaire.Notified.NOTIFIED);
                this.questionnaireRepository.save((Object)questionnaire);
            }
            catch (JsonProcessingException e) {
                LOGGER.debug(e.getMessage());
            }
        }
        return true;
    }

    @RequestMapping(value={"/export-confidence-vote/{sessionId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<Object> exportConfidenceVoteTableToExcel(@PathVariable(value="sessionId") String sessionId) {
        try {
            Session session = this.sessionRepository.findById(sessionId);
            SessionBoard sessionBoard = (SessionBoard)this.sessionBoardRepository.findOne((Serializable)((Object)session.getActiveSessionBoard()));
            String sessionBoardName = sessionBoard.getSession().getTitle();
            List questionnaire = session.getConfidenceVoteSurvey();
            List questions = this.questionRepository.findByQuestionnaireId(((Questionnaire)questionnaire.get(0)).getId());
            ArrayList<String> questionIds = new ArrayList<String>();
            List teamList = sessionBoard.getTeams();
            for (Question question : questions) {
                questionIds.add(question.getId());
            }
            List answerList = this.answerRepository.findByQuestionIdIn(questionIds);
            List questionList = this.questionRepository.findByIdIn(questionIds);
            Questionnaire questionaireSaved = this.questionnaireRepository.findById(((Questionnaire)questionnaire.get(0)).getId());
            String filePath = this.confidenceVoteSurveyService.exportConfidenceVote(answerList, questionList, questionaireSaved, teamList, sessionBoardName);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy");
            String downloadName = AlmUtils.cleanText((String)sessionBoardName) + "_Confidence_Vote_" + formatter.format(new Date()) + ".xls";
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("srcPath", URLEncoder.encode(filePath, "UTF-8"));
            data.put("name", URLEncoder.encode(downloadName, "UTF-8"));
            return new ResponseEntity(data, HttpStatus.OK);
        }
        catch (Exception e) {
            return new ResponseEntity((Object)"Server Error!", HttpStatus.BAD_REQUEST);
        }
    }
}

