/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.service.ChangeLogSyncService;
import com.viztrend.safe.utils.StringUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sync"})
public class ChangeLogSyncController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeLogSyncController.class);
    private final ChangeLogSyncService changeLogSyncService;

    public ChangeLogSyncController(ChangeLogSyncService changeLogSyncService) {
        this.changeLogSyncService = changeLogSyncService;
    }

    @GetMapping(value={"/globalOKRs"})
    public String reSyncGlobalOKRs(@RequestParam boolean reSyncGlobalOKRs, @RequestParam String baseItemType) {
        boolean reSyncDone = false;
        try {
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("globalOKRs", true);
            requestMap.put("baseItemType", baseItemType);
            reSyncDone = this.changeLogSyncService.reSyncOKRItems(requestMap);
        }
        catch (Exception e) {
            LOGGER.error("Error in reSyncGlobalOKRs(): " + StringUtils.getTraceString((Throwable)e));
        }
        if (!reSyncDone) {
            return "OKRs reSync already done";
        }
        return "OKRs sync process started";
    }
}

