/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.service.FileUploaderService;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/binary-file"})
@RestController
public class BinaryFileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryFileController.class);
    @Autowired
    private FileUploaderService fileUploaderService;

    @RequestMapping(value={"/upload"})
    public ResponseEntity<Object> uploadImage(@RequestParam(value="image") MultipartFile imageFile) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            LOGGER.debug("*****uploadImage**** -----> /binary-file/upload   START");
            responseJson.put("uploadedFile", this.fileUploaderService.uploadPhoto(imageFile));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****uploadImage**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****uploadImage**** -----> /binary-file/upload   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/get"})
    public ResponseEntity<Object> getImage(@RequestParam(value="fileId") String fileId) {
        HashMap<String, Object> responseJson = new HashMap<String, Object>();
        try {
            LOGGER.debug("*****getImage**** -----> /binary-file/get   START");
            responseJson.put("file", this.fileUploaderService.getImage(fileId));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****getImage**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****getImage**** -----> /binary-file/get   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }

    @RequestMapping(value={"/clear/{fileId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Object> clearImage(@PathVariable(value="fileId") String fileId) {
        HashMap<String, Serializable> responseJson = new HashMap<String, Serializable>();
        try {
            LOGGER.debug("*****clearImage**** -----> /binary-file/clear   START");
            responseJson.put("file", Boolean.valueOf(this.fileUploaderService.clearImage(fileId)));
        }
        catch (Exception e) {
            responseJson.put("kendisError", e);
            LOGGER.error("*****clearImage**** -----> Exception Occurred. ---------------");
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return new ResponseEntity(responseJson, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        LOGGER.debug("*****clearImage**** -----> /binary-file/clear   END");
        return new ResponseEntity(responseJson, HttpStatus.OK);
    }
}

