/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.controller;

import com.viztrend.safe.utils.PropertyValidator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.ServletRequestAttributes;

@Controller
public class AppErrorController
implements ErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppErrorController.class);
    private ErrorAttributes errorAttributes;
    @Autowired
    private Environment env;
    private static final String ERROR_PATH = "/error";

    public AppErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"/error"}, produces={"text/html"})
    public String errorHtml(HttpServletRequest request, HttpServletResponse response, Model model) {
        Map errorsMap = this.getErrorAttributes(request, false);
        if (String.valueOf(errorsMap.get("exception")).contains("org.springframework.dao.DataAccessResourceFailureException") || String.valueOf(errorsMap.get("exception")).contains("org.springframework.data.mongodb.UncategorizedMongoDbException")) {
            if (this.env.getProperty("isLocalDeployment").equals("true")) {
                return "system";
            }
            return "maintenance";
        }
        if ("403".equals(String.valueOf(errorsMap.get("status"))) && PropertyValidator.isValid(errorsMap.get("message")) && errorsMap.get("message").toString().contains("Invalid CSRF Token")) {
            model.addAttribute("error", (Object)"Your session has expired.");
        }
        model.addAttribute("errorsMap", (Object)errorsMap);
        return "error";
    }

    @RequestMapping(value={"/system/error"})
    public String sysErrorHtml(HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAttribute("error", (Object)"Page Not found");
        return "error";
    }

    public String getErrorPath() {
        return ERROR_PATH;
    }

    private boolean getTraceParameter(HttpServletRequest request) {
        String parameter = request.getParameter("trace");
        if (parameter == null) {
            return false;
        }
        return !"false".equals(parameter.toLowerCase());
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request, boolean includeStackTrace) {
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request);
        return this.errorAttributes.getErrorAttributes((RequestAttributes)requestAttributes, includeStackTrace);
    }

    private HttpStatus getStatus(HttpServletRequest request) {
        Integer statusCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (statusCode != null) {
            try {
                return HttpStatus.valueOf((int)statusCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

