/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.viztrend.safe.enums.EnumActivityType;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.BaseEntity;
import com.viztrend.safe.persistence.entity.BaseItem;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemLog;
import com.viztrend.safe.persistence.entity.ItemLogDetail;
import com.viztrend.safe.persistence.entity.ItemLogMap;
import com.viztrend.safe.persistence.entity.Notification;
import com.viztrend.safe.persistence.entity.Risk;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.persistence.repository.ItemLinkRepository;
import com.viztrend.safe.persistence.repository.ItemLogMapRepository;
import com.viztrend.safe.persistence.repository.ItemLogRepository;
import com.viztrend.safe.persistence.repository.NotificationRepository;
import com.viztrend.safe.persistence.repository.SessionBoardRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.service.NotificationService;
import com.viztrend.safe.service.ReleaseTrainService;
import com.viztrend.safe.strategy.LoggerExclusionStrategy;
import com.viztrend.safe.strategy.PushInclusionStrategy;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.PushSender;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class EntityChangedLogger
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityChangedLogger.class);
    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).create();
    Gson gsonPush = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new PushInclusionStrategy()).registerTypeAdapter(Date.class, (json, typeOfT, context) -> new Date(json.getAsJsonPrimitive().getAsLong())).registerTypeAdapter(Date.class, (date, type, jsonSerializationContext) -> new JsonPrimitive((Number)date.getTime())).create();
    Gson gson = new GsonBuilder().create();
    private Object item;
    private Date eventTime;
    private String eventType;
    private MongoTemplate mongoTemplate;
    private ItemLogRepository itemLogRepository;
    private ItemLogMapRepository itemLogMapRepository;
    private ItemLinkRepository itemLinkRepository;
    private BacklogItemRepository backlogItemRepository;
    private SessionBoardRepository sessionBoardRepository;
    private TeamContainerRepository teamContainerRepository;
    private NotificationRepository notificationReposiotory;
    private NotificationService notificationService;
    private ReleaseTrainService releaseTrainService;
    private ItemLog itemLog;

    public EntityChangedLogger(Object item, Date eventTime, String eventType, Gson gson, ItemLog itemLog) {
        this.item = item;
        this.itemLog = itemLog;
        this.eventTime = eventTime;
        this.eventType = eventType;
    }

    public EntityChangedLogger(Object item, Date eventTime, String eventType, Gson gson, ItemLog itemLog, ApplicationContext applicationContext) {
        this.item = item;
        this.itemLog = itemLog;
        this.eventTime = eventTime;
        this.eventType = eventType;
        this.mongoTemplate = (MongoTemplate)applicationContext.getBean("mongoTemplate");
        this.itemLogRepository = (ItemLogRepository)applicationContext.getBean("itemLogRepository");
        this.itemLogMapRepository = (ItemLogMapRepository)applicationContext.getBean("itemLogMapRepository");
        this.itemLinkRepository = (ItemLinkRepository)applicationContext.getBean("itemLinkRepository");
        this.teamContainerRepository = (TeamContainerRepository)applicationContext.getBean("teamContainerRepository");
        this.sessionBoardRepository = (SessionBoardRepository)applicationContext.getBean("sessionBoardRepository");
        this.notificationService = (NotificationService)applicationContext.getBean("Notification");
        this.notificationReposiotory = (NotificationRepository)applicationContext.getBean("notificationRepository");
        this.releaseTrainService = (ReleaseTrainService)applicationContext.getBean("ReleaseTrainService");
        this.backlogItemRepository = (BacklogItemRepository)applicationContext.getBean("backlogItemRepository");
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    @Override
    public void run() {
        this.checkChanges();
    }

    public Object getItem() {
        return this.item;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void checkChanges() {
        try {
            ConfigurablePropertyAccessor pa = PropertyAccessorFactory.forDirectFieldAccess((Object)this.item);
            Object oldState = pa.getPropertyValue("oldSate");
            String oldStateJson = this.gsonExclusive.toJson(oldState);
            pa.setPropertyValue("oldSate", null);
            String newStateJson = this.gsonExclusive.toJson(this.item);
            String pushJson = this.gsonPush.toJson(this.item);
            HashMap changeAndOnlyLeftRightItemsMap = new HashMap();
            if (!((Boolean)pa.getPropertyValue("suspendPush")).booleanValue()) {
                PushSender.sendMsg((String)pushJson);
            }
            Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
            Map firstMap = (Map)this.gsonExclusive.fromJson(oldStateJson, mapType);
            HashMap secondMap = (HashMap)this.gsonExclusive.fromJson(newStateJson, mapType);
            HashMap changes = null;
            MapDifference diffMap = null;
            Map diff = null;
            if (firstMap != null && secondMap != null) {
                diffMap = Maps.difference((Map)firstMap, (Map)secondMap);
                diff = diffMap.entriesDiffering();
            }
            this.itemLog.setEventTime(this.eventTime);
            this.itemLog.setItemType(this.item.getClass().getSimpleName());
            this.itemLog.setEventType(EnumActivityType.UPDATED.getCode());
            Item kendisItem = null;
            Item oldStateItem = null;
            Double oldSeq = null;
            boolean stringify = false;
            if (this.item instanceof Item) {
                kendisItem = (Item)this.item;
                oldSeq = kendisItem.getPhoenixSequence();
                if (PropertyValidator.isValid((Object)kendisItem.getStatus()) && kendisItem.getStatus().getId() != null && kendisItem.getStatus().getTitle() == null && this.mongoTemplate != null) {
                    kendisItem.setStatus((Status)this.findById(kendisItem.getStatus().getId(), Status.class));
                }
                if ((oldStateItem = (Item)oldState) != null && Item.Type.Feature.name().equals(oldStateItem.getType()) && oldSeq == null && PropertyValidator.isValid((Collection)oldStateItem.getTeamContainers())) {
                    oldSeq = oldStateItem.maxPhoenixSequence();
                }
            } else if (this.item instanceof BaseItem) {
                KendisUtils.mapDifference((Map)(oldState == null ? null : ((BaseItem)oldState).getFields()), (Map)((BaseItem)this.item).getFields(), changeAndOnlyLeftRightItemsMap);
            } else if (this.item instanceof Risk) {
                KendisUtils.mapDifference((Map)(oldState == null ? null : ((Risk)oldState).getFields()), (Map)((Risk)this.item).getFields(), changeAndOnlyLeftRightItemsMap);
            } else if (this.item instanceof ItemLink) {
                // empty if block
            }
            if (diffMap != null) {
                Map diffMapEntireDiff = diffMap.entriesDiffering();
                if (diffMapEntireDiff != null) {
                    HashMap changeMap = new HashMap();
                    Set keys = diffMapEntireDiff.keySet();
                    if (keys != null) {
                        if (keys.size() > 0) {
                            for (Object key : keys) {
                                if ("teamContainers".equals(key)) {
                                    this.checkDiffForTC((String)key, kendisItem, changeMap, diffMap, firstMap, (Map)secondMap);
                                    continue;
                                }
                                Object rightValue = ((MapDifference.ValueDifference)diffMapEntireDiff.get(key)).rightValue();
                                if (key.equals("archive") && rightValue.equals(Boolean.TRUE)) {
                                    this.itemLog.setEventType(EnumActivityType.DELETED.getCode());
                                }
                                changeMap.put(key, rightValue);
                            }
                        } else if (oldStateItem != null && !PropertyValidator.isValid((Collection)oldStateItem.getTeamContainers()) && PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                            this.checkDiffForTC("teamContainers", kendisItem, changeMap, diffMap, firstMap, (Map)secondMap);
                        }
                    }
                    Map detail = new ItemLogDetail(this.item).clean(null);
                    if (kendisItem != null) {
                        detail.put("duplicateOfId", kendisItem.getDuplicateOfId());
                    }
                    this.itemLog.setDetail((Object)detail);
                    Map entriesOnlyOnLeft = diffMap.entriesOnlyOnLeft();
                    Map entriesOnlyOnRight = diffMap.entriesOnlyOnRight();
                    changeAndOnlyLeftRightItemsMap.putAll(changeMap);
                    changeAndOnlyLeftRightItemsMap.putAll(entriesOnlyOnLeft);
                    changeAndOnlyLeftRightItemsMap.putAll(entriesOnlyOnRight);
                    if (kendisItem != null) {
                        if (changeAndOnlyLeftRightItemsMap.get(ItemLog.Changes.teamContainers.name()) == null && kendisItem.getLastUpdatedValue(Item.Actions.teamContainer.name()) != null) {
                            changeAndOnlyLeftRightItemsMap.put(ItemLog.Changes.teamContainers.name(), new ItemLogDetail(kendisItem.getLastUpdatedValue(Item.Actions.teamContainer.name())).clean(null));
                        }
                        if (changeAndOnlyLeftRightItemsMap.get(ItemLog.Changes.itemLinks.name()) == null) {
                            if (kendisItem.getLastUpdatedValue(Item.Actions.itemLink.name()) != null) {
                                detail.put("itemLinks", this.setSourceAndTargetItems((ItemLink)kendisItem.getLastUpdatedValue(Item.Actions.itemLink.name()), new ArrayList()));
                                changeAndOnlyLeftRightItemsMap.put(ItemLog.Changes.itemLinks.name(), true);
                            } else if (kendisItem.getLastUpdatedValue(Item.Actions.itemLinks.name()) != null) {
                                detail.put("itemLinks", this.setSourceAndTargetItems(null, (List)kendisItem.getLastUpdatedValue(Item.Actions.itemLinks.name())));
                                changeAndOnlyLeftRightItemsMap.put(ItemLog.Changes.itemLinks.name(), true);
                            } else if (kendisItem.getLastUpdatedValue(Item.Actions.itemLinkRemoved.name()) != null) {
                                detail.put("itemLinks", this.setSourceAndTargetItems((ItemLink)kendisItem.getLastUpdatedValue(Item.Actions.itemLinkRemoved.name()), new ArrayList()));
                                changeAndOnlyLeftRightItemsMap.put(ItemLog.Changes.itemLinks.name(), false);
                            }
                        }
                    }
                    if (kendisItem != null) {
                        this.changedPhoenix(kendisItem, oldSeq, changeAndOnlyLeftRightItemsMap);
                    }
                    if (changeAndOnlyLeftRightItemsMap.get(ItemLog.Changes.storyPoints.name()) != null) {
                        Double r = (Double)entriesOnlyOnLeft.get(ItemLog.Changes.storyPoints.name());
                        Double l = (Double)entriesOnlyOnRight.get(ItemLog.Changes.storyPoints.name());
                        if (!(r == null && l == null || l != null && !l.equals(0.0) || r != null && !r.equals(0.0))) {
                            changeAndOnlyLeftRightItemsMap.remove(ItemLog.Changes.storyPoints.name());
                        }
                    }
                    changeAndOnlyLeftRightItemsMap.remove("metaMap");
                    if (this.item instanceof BacklogItem) {
                        this.itemLog.setActions(changeAndOnlyLeftRightItemsMap);
                        ((Map)this.itemLog.getDetail()).remove("fields");
                    } else {
                        stringify = true;
                    }
                    changes = changeAndOnlyLeftRightItemsMap;
                }
            } else {
                this.itemLog.setEventType(EnumActivityType.CREATED.getCode());
                if (kendisItem != null) {
                    this.changedTC(kendisItem, null, (Map)secondMap, (Map)secondMap);
                    if (!kendisItem.getType().equals(Item.Type.UserStory.name())) {
                        secondMap.remove(ItemLog.Changes.storyPoints.name());
                    }
                }
                this.itemLog.setDetail((Object)new ItemLogDetail(this.item).clean(null));
                if (kendisItem != null) {
                    this.changedPhoenix(kendisItem, oldSeq, (Map)secondMap);
                }
                secondMap.remove("metaMap");
                if (this.item instanceof BacklogItem) {
                    this.itemLog.setActions((Map)secondMap);
                    ((Map)this.itemLog.getDetail()).remove("fields");
                } else {
                    stringify = true;
                }
                changes = secondMap;
            }
            boolean hasART = true;
            if (kendisItem != null) {
                Map oldFields = null;
                if (oldState != null) {
                    if (oldState instanceof Item) {
                        oldFields = ((Item)oldState).getFields();
                    } else if (oldState instanceof BaseItem) {
                        oldFields = ((BaseItem)oldState).getFields();
                    }
                }
                KendisUtils.mapDifference(oldFields, (Map)kendisItem.getFields(), changes);
                boolean bl = hasART = kendisItem.getFields() != null && (kendisItem.getFields().containsKey("popupLinkedARTs") || kendisItem.getFields().containsKey("popupUnLinkedARTs"));
            }
            if (stringify) {
                this.itemLog.setChanges(this.gson.toJson(changes));
            }
            this.itemLog.setItemId(pa.getPropertyValue("id").toString());
            if (oldState != null && oldState instanceof Item && oldStateItem != null) {
                this.itemLog.setTitle(oldStateItem.getTitle());
                this.itemLog.setKey(oldStateItem.getJiraKey());
                this.itemLog.setScore(oldStateItem.getScore());
                this.itemLog.setScoreParams(oldStateItem.getScoreParams());
            } else if (this.item instanceof Item) {
                Item newItem = (Item)this.item;
                this.itemLog.setTitle(newItem.getTitle());
                this.itemLog.setKey(newItem.getJiraKey());
                this.itemLog.setScore(newItem.getScore());
                this.itemLog.setScoreParams(newItem.getScoreParams());
            }
            if (((BaseEntity)this.item).getSource() == 0) {
                this.itemLog.setActivitySource("APP");
            } else {
                this.itemLog.setActivitySource("WEBHOOK");
                this.itemLog.setActivityBy(((Item)this.item).getWebHookActivityBy());
            }
            if (pa.isReadableProperty("sessionBoards")) {
                List sessionBoards = (List)pa.getPropertyValue("sessionBoards");
                if (PropertyValidator.isValid((Collection)sessionBoards)) {
                    this.itemLog.setSessionBoard((SessionBoard)sessionBoards.get(0));
                } else if (oldState instanceof Item && oldStateItem != null && PropertyValidator.isValid((Collection)(sessionBoards = oldStateItem.getSessionBoards()))) {
                    this.itemLog.setSessionBoard((SessionBoard)sessionBoards.get(0));
                }
            }
            if (pa.isReadableProperty("tenant")) {
                this.itemLog.setTenant(String.valueOf(pa.getPropertyValue("tenant")));
            }
            if (PropertyValidator.isValid((Object)changes) && (!changes.isEmpty() || hasART)) {
                if (this.mongoTemplate != null) {
                    this.mongoTemplate.save((Object)this.itemLog);
                    this.mergeLogsPerDay(kendisItem, oldStateItem, (Map)changes);
                }
                if (PropertyValidator.isValid(changes.get("teamContainers"))) {
                    this.sendNotificaiton((Item)this.item, (Map)changes);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private void checkDiffForTC(String key, Item kendisItem, Map changeMap, MapDifference<String, Object> diffMap, Map<String, Object> firstMap, Map<String, Object> secondMap) {
        List rightValue = new ArrayList();
        List leftValue = new ArrayList();
        MapDifference.ValueDifference diffs = (MapDifference.ValueDifference)diffMap.entriesDiffering().get(key);
        if (diffs != null) {
            rightValue = (List)diffs.rightValue();
            leftValue = (List)diffs.leftValue();
        }
        if (PropertyValidator.isValid(rightValue) && rightValue.size() > leftValue.size()) {
            int size = rightValue.size();
            changeMap.put(key, rightValue.get(size - 1));
        } else if (PropertyValidator.isValid(leftValue)) {
            if (leftValue.size() > rightValue.size()) {
                this.itemLog.setEventType(EnumActivityType.DELETED.getCode());
            }
            leftValue.removeAll(rightValue);
            if (PropertyValidator.isValid(leftValue)) {
                changeMap.put(key, leftValue.get(0));
            }
        }
        if (kendisItem != null) {
            this.changedTC(kendisItem, firstMap, secondMap, changeMap);
        }
    }

    private void changedTC(Item kendisItem, Map<String, Object> firstMap, Map<String, Object> secondMap, Map changeMap) {
        if (Item.Type.UserStory.name().equals(secondMap.get("type"))) {
            if (!EnumActivityType.DELETED.getCode().equals(this.itemLog.getEventType())) {
                Map _tc;
                List neu;
                List old;
                String c1 = "";
                String c2 = "";
                String t1 = "";
                String t2 = "";
                if (firstMap != null && firstMap.get("teamContainers") != null && (old = (List)firstMap.get("teamContainers")).size() > 0) {
                    t1 = (String)((Map)((Map)old.get(0)).get("team")).get("id");
                    c1 = (String)((Map)((Map)old.get(0)).get("container")).get("id");
                }
                if (secondMap != null && secondMap.get("teamContainers") != null && (neu = (List)secondMap.get("teamContainers")).size() > 0 && (_tc = (Map)neu.get(0)).containsKey("team") && _tc.containsKey("container")) {
                    t2 = (String)((Map)_tc.get("team")).get("id");
                    c2 = (String)((Map)_tc.get("container")).get("id");
                }
                if (!c1.equals(c2)) {
                    changeMap.put(ItemLog.Changes.containerChanged.name(), true);
                }
                if (!t1.equals(t2)) {
                    changeMap.put(ItemLog.Changes.teamChanged.name(), true);
                }
            } else if (!PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                changeMap.put(ItemLog.Changes.containerChanged.name(), true);
                changeMap.put(ItemLog.Changes.teamChanged.name(), true);
            }
            if (PropertyValidator.isValid((Collection)kendisItem.getSessionBoards()) && kendisItem.getSessionBoards().get(0) != null && (((SessionBoard)kendisItem.getSessionBoards().get(0)).getContainers() == null || ((SessionBoard)kendisItem.getSessionBoards().get(0)).getTeams() == null) && this.mongoTemplate != null) {
                Query query = new Query();
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)((SessionBoard)kendisItem.getSessionBoards().get(0)).getId()));
                SessionBoard sb = (SessionBoard)this.mongoTemplate.findOne(query, SessionBoard.class);
                if (PropertyValidator.isValid((Object)sb)) {
                    ((SessionBoard)kendisItem.getSessionBoards().get(0)).setContainers(sb.getContainers());
                    ((SessionBoard)kendisItem.getSessionBoards().get(0)).setTeams(sb.getTeams());
                    ((SessionBoard)kendisItem.getSessionBoards().get(0)).setState(sb.getState());
                }
            }
        }
    }

    private void changedPhoenix(Item kendisItem, Double oldSequence, Map changeMap) {
        Double max = kendisItem.getPhoenixSequence();
        if (max != null && this.mongoTemplate != null) {
            if (!max.equals(oldSequence) && PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                Update update = new Update();
                update.set(ItemLog.Changes.phoenixSequence.name(), (Object)max);
                changeMap.put(ItemLog.Changes.phoenixSequence.name(), max);
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)((Item)this.item).getId())})), update, Item.class);
            } else if (!PropertyValidator.isValid((Collection)kendisItem.getTeamContainers())) {
                Update update = new Update();
                ((HashMap)this.itemLog.getDetail()).remove(ItemLog.Changes.phoenixSequence.name());
                update.set(ItemLog.Changes.phoenixSequence.name(), null);
                changeMap.put(ItemLog.Changes.phoenixSequence.name(), max);
                this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)((Item)this.item).getId())})), update, Item.class);
            }
        }
    }

    private List<Map<String, Object>> setSourceAndTargetItems(ItemLink singleLink, List<ItemLink> itemLinks) {
        ArrayList<Map<String, Object>> iLinks = new ArrayList<Map<String, Object>>();
        Map object = null;
        ArrayList<ObjectId> ids = new ArrayList<ObjectId>();
        ArrayList<ObjectId> usIds = new ArrayList<ObjectId>();
        if (singleLink != null) {
            itemLinks.add(singleLink);
        }
        for (ItemLink itemLink : itemLinks) {
            if (!PropertyValidator.isValid((Object)itemLink.getSourceTeamContainerId()) || !PropertyValidator.isValid((Object)itemLink.getTargetTeamContainerId())) continue;
            if (PropertyValidator.isValid((Object)itemLink.getSourceUserStoryId())) {
                usIds.add(new ObjectId(itemLink.getSourceUserStoryId()));
            }
            ids.add(new ObjectId(itemLink.getSourceTeamContainerId()));
            if (PropertyValidator.isValid((Object)itemLink.getTargetUserStoryId())) {
                usIds.add(new ObjectId(itemLink.getTargetUserStoryId()));
            }
            ids.add(new ObjectId(itemLink.getTargetTeamContainerId()));
        }
        List items = new ArrayList();
        List TCs = new ArrayList();
        if (this.mongoTemplate != null) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").in(ids));
            TCs = this.mongoTemplate.find(query, TeamContainer.class);
            query = new Query();
            if (PropertyValidator.isValid(usIds)) {
                Criteria criteria = new Criteria();
                criteria.orOperator(new Criteria[]{Criteria.where((String)"id").in(usIds), Criteria.where((String)"teamContainers.$id").in(ids)});
                query.addCriteria((CriteriaDefinition)criteria);
            } else {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").in(ids));
            }
            items = this.mongoTemplate.find(query, Item.class);
        }
        HashMap<String, Item> mapItems = new HashMap<String, Item>();
        HashMap<String, TeamContainer> mapTCs = new HashMap<String, TeamContainer>();
        for (TeamContainer tc : TCs) {
            mapTCs.put(tc.getId(), tc);
        }
        for (Item item : items) {
            List itcs = item.getTeamContainers();
            if (!PropertyValidator.isValid((Collection)itcs)) continue;
            for (int j = 0; j < itcs.size(); ++j) {
                if (Item.Type.UserStory.name().equals(item.getType())) {
                    mapItems.put(item.getType() + "_" + ((TeamContainer)itcs.get(j)).getId() + "_" + item.getId(), item);
                    continue;
                }
                mapItems.put(item.getType() + "_" + ((TeamContainer)itcs.get(j)).getId(), item);
            }
        }
        for (ItemLink itemLink : itemLinks) {
            Item item;
            if (mapTCs.containsKey(itemLink.getSourceTeamContainerId())) {
                item = null;
                item = itemLink.getSourceUserStoryId() == null ? (Item)mapItems.get(Item.Type.Feature.name() + "_" + itemLink.getSourceTeamContainerId()) : (Item)mapItems.get(Item.Type.UserStory.name() + "_" + itemLink.getSourceTeamContainerId() + "_" + itemLink.getSourceUserStoryId());
                if (item != null) {
                    itemLink.setSourceItem(item.copyWithoutTC());
                    itemLink.getSourceItem().setTeamContainers(new ArrayList());
                    itemLink.getSourceItem().getTeamContainers().add(mapTCs.get(itemLink.getSourceTeamContainerId()));
                }
            }
            if (mapTCs.containsKey(itemLink.getTargetTeamContainerId())) {
                item = null;
                item = itemLink.getTargetUserStoryId() == null ? (Item)mapItems.get(Item.Type.Feature.name() + "_" + itemLink.getTargetTeamContainerId()) : (Item)mapItems.get(Item.Type.UserStory.name() + "_" + itemLink.getTargetTeamContainerId() + "_" + itemLink.getTargetUserStoryId());
                if (item != null) {
                    itemLink.setTargetItem(item.copyWithoutTC());
                    itemLink.getTargetItem().setTeamContainers(new ArrayList());
                    itemLink.getTargetItem().getTeamContainers().add(mapTCs.get(itemLink.getTargetTeamContainerId()));
                }
            }
            object = new ItemLogDetail((Object)itemLink).clean(null);
            iLinks.add(object);
        }
        return iLinks;
    }

    private Object findById(String id, Class T) {
        return this.mongoTemplate.findById((Object)id, T);
    }

    private String getLastLogId(String itemId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail").ne(null));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)itemId));
            query.with(new Sort(Sort.Direction.DESC, new String[]{"eventTime"}));
            ItemLog lastLog = (ItemLog)this.mongoTemplate.findOne(query, ItemLog.class);
            if (lastLog != null) {
                return lastLog.getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void mergeLogsPerDay(Item kendisItem, Item oldStateItem, Map<String, Object> changes) {
        if (changes != null && kendisItem != null && this.itemLog.getDetail() != null) {
            List link;
            StringBuilder actions = new StringBuilder();
            HashMap<String, Boolean> subChanges = new HashMap<String, Boolean>();
            boolean subActions = false;
            boolean tcAction = false;
            if (changes.get(ItemLog.Changes.archive.name()) != null) {
                actions.append(ItemLog.UniquePrefix.archive.name()).append("_");
            }
            if (changes.get(ItemLog.Changes.status.name()) != null) {
                actions.append(ItemLog.UniquePrefix.byStatus.name()).append("_");
            }
            if (changes.get(ItemLog.Changes.teamContainers.name()) != null) {
                actions.append(ItemLog.UniquePrefix.byPlan.name()).append("_");
                subChanges.put(ItemLog.Changes.teamContainers.name(), true);
                subActions = true;
                tcAction = true;
            }
            if (changes.get(ItemLog.Changes.containerChanged.name()) != null) {
                actions.append(ItemLog.UniquePrefix.byC.name()).append("_");
                tcAction = true;
            } else if (changes.get(ItemLog.Changes.teamContainers.name()) != null) {
                subChanges.put(ItemLog.Changes.containerChanged.name(), true);
                subActions = true;
                tcAction = true;
            }
            if (changes.get(ItemLog.Changes.teamChanged.name()) != null) {
                actions.append(ItemLog.UniquePrefix.byT.name()).append("_");
                tcAction = true;
            } else if (changes.get(ItemLog.Changes.teamContainers.name()) != null) {
                subChanges.put(ItemLog.Changes.teamChanged.name(), true);
                subActions = true;
                tcAction = true;
            }
            if (changes.get(ItemLog.Changes.phoenixSequence.name()) != null) {
                actions.append(ItemLog.UniquePrefix.byTC.name()).append("_");
            }
            if (changes.get(ItemLog.Changes.archive.name()) != null) {
                tcAction = true;
            }
            if (changes.get(ItemLog.Changes.storyPoints.name()) != null && Item.Type.UserStory.name().equals(kendisItem.getType())) {
                actions.append(ItemLog.UniquePrefix.byPoints.name()).append("_");
            }
            if (changes.get(ItemLog.Changes.itemLinks.name()) != null && (link = (List)((HashMap)this.itemLog.getDetail()).get("itemLinks")) != null && link.size() > 0) {
                for (int i = 0; i < link.size(); ++i) {
                    if (i > 0) {
                        actions.append("%");
                    }
                    ((HashMap)link.get(i)).get("id");
                    actions.append(ItemLog.UniquePrefix.byLinks.name()).append(((HashMap)link.get(i)).get("id")).append("_");
                }
            }
            if (actions.length() > 0) {
                ArrayList<ItemLogMap> logMaps = new ArrayList<ItemLogMap>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String perDay = sdf.format(this.itemLog.getEventTime());
                String[] action = actions.toString().split("%");
                for (int i = 0; i < action.length; ++i) {
                    ItemLogMap itemLogMap = new ItemLogMap();
                    itemLogMap.setId(perDay + "_" + action[i] + kendisItem.getId());
                    itemLogMap.setEventTime(this.itemLog.getEventTime());
                    itemLogMap.setItemLog(this.itemLog);
                    itemLogMap.setSessionBoard(this.itemLog.getSessionBoard());
                    itemLogMap.setTenant(this.itemLog.getTenant());
                    logMaps.add(itemLogMap);
                }
                if (subActions && Item.Type.Feature.name().equals(kendisItem.getType())) {
                    this.addLogsForChildChangedTC(kendisItem, oldStateItem, logMaps, subChanges, perDay);
                }
                if (this.itemLogMapRepository != null) {
                    this.itemLogMapRepository.save(logMaps);
                }
            }
            if (kendisItem.getFields() != null) {
                Map linkedArts = null;
                Map unLinkedArts = null;
                if (PropertyValidator.isValid(kendisItem.getFields().get("popupUnLinkedARTs"))) {
                    unLinkedArts = (Map)kendisItem.getFields().get("popupUnLinkedARTs");
                    kendisItem.getFields().remove("popupUnLinkedARTs");
                }
                if (PropertyValidator.isValid(kendisItem.getFields().get("popupLinkedARTs"))) {
                    linkedArts = (Map)kendisItem.getFields().get("popupLinkedARTs");
                    kendisItem.getFields().remove("popupLinkedARTs");
                } else if (PropertyValidator.isValid(kendisItem.getFields().get("artRelationMap"))) {
                    linkedArts = (Map)kendisItem.getFields().get("artRelationMap");
                }
                if (PropertyValidator.isValid((Object)linkedArts)) {
                    this.releaseTrainService.savePiItemToBackLog(kendisItem, linkedArts, unLinkedArts);
                }
                tcAction = true;
            }
            if (tcAction) {
                this.releaseTrainService.syncWithBoards(this.itemLog.getTenant(), kendisItem);
            }
        }
    }

    private void addLogsForChildChangedTC(Item kendisItem, Item oldStateItem, List<ItemLogMap> logMaps, Map<String, Object> changes, String perDay) {
        try {
            ArrayList<ItemLog> subLogs = new ArrayList<ItemLog>();
            StringBuilder actions = new StringBuilder();
            TeamContainer tc = (TeamContainer)kendisItem.getLastUpdatedValue(Item.Actions.teamContainer.name());
            if (tc != null) {
                if (oldStateItem != null) {
                    Container c = (Container)kendisItem.getLastUpdatedValue("oldContainer");
                    Team t = (Team)kendisItem.getLastUpdatedValue("oldTeam");
                    if (c != null && tc.getContainer().getId().equals(c.getId())) {
                        changes.remove(ItemLog.Changes.containerChanged.name());
                    }
                    if (t != null && tc.getTeam().getId().equals(t.getId())) {
                        changes.remove(ItemLog.Changes.teamChanged.name());
                    }
                }
                if (changes.get(ItemLog.Changes.teamContainers.name()) != null) {
                    actions.append(ItemLog.UniquePrefix.byPlan.name()).append("_");
                }
                if (changes.get(ItemLog.Changes.containerChanged.name()) != null) {
                    actions.append(ItemLog.UniquePrefix.byC.name()).append("_");
                }
                if (changes.get(ItemLog.Changes.teamChanged.name()) != null) {
                    actions.append(ItemLog.UniquePrefix.byT.name()).append("_");
                }
                List childrens = new ArrayList();
                if (this.mongoTemplate != null) {
                    Query query = new Query();
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"parent.$id").is((Object)new ObjectId(kendisItem.getId())));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"teamContainers.$id").is((Object)new ObjectId(tc.getId())));
                    query.fields().include("_id");
                    query.fields().include("originItemId");
                    query.fields().include("title");
                    query.fields().include("status");
                    query.fields().include("jiraKey");
                    query.fields().include("jiraId");
                    query.fields().include("tfsId");
                    query.fields().include("tfsURL");
                    query.fields().include("createdOn");
                    query.fields().include("updatedOn");
                    query.fields().include("dueDate");
                    query.fields().include("storyPoints");
                    query.fields().include("externalReferenceURL");
                    query.fields().include("createdBy");
                    query.fields().include("duplicateOfId");
                    query.fields().include("type");
                    childrens = this.mongoTemplate.find(query, Item.class);
                }
                ArrayList<TeamContainer> tcs = new ArrayList<TeamContainer>();
                tcs.add(tc);
                for (Item us : childrens) {
                    us.setSessionBoards(kendisItem.getSessionBoards());
                    us.setTeamContainers(tcs);
                    us.setParent(kendisItem);
                    ItemLog log = new ItemLog(ObjectId.get().toString());
                    log.setEventTime(this.eventTime);
                    log.setItemId(us.getId());
                    log.setItemType(this.item.getClass().getSimpleName());
                    log.setEventType(EnumActivityType.UPDATED.getCode());
                    log.setChanges(this.gson.toJson(changes));
                    log.setSessionBoard((SessionBoard)kendisItem.getSessionBoards().get(0));
                    log.setTenant(kendisItem.getTenant());
                    log.setActivitySource("APP");
                    log.setDetail((Object)new ItemLogDetail((Object)us).clean(null));
                    ItemLogMap itemLogMap = new ItemLogMap();
                    itemLogMap.setId(perDay + "_" + actions.toString() + us.getId());
                    itemLogMap.setEventTime(log.getEventTime());
                    itemLogMap.setItemLog(log);
                    itemLogMap.setSessionBoard(log.getSessionBoard());
                    itemLogMap.setTenant(log.getTenant());
                    logMaps.add(itemLogMap);
                    subLogs.add(log);
                }
                childrens.clear();
            }
            if (this.itemLogRepository != null) {
                this.itemLogRepository.save(subLogs);
            }
        }
        catch (Exception e) {
            LOGGER.error("FAILED: addLogsForChildChangedTC : " + StringUtils.getTraceString((Throwable)e) + "\n ");
        }
    }

    private void sendNotificaiton(Item kendisItem, Map<String, Object> changes) {
        try {
            Object teamContainerMap = changes.get("teamContainers");
            if (teamContainerMap.getClass().getName().indexOf("List") <= -1) {
                Map tc = (Map)teamContainerMap;
                String id = (String)tc.get("id");
                if (PropertyValidator.isValid((Collection)kendisItem.getTeamContainers()) && kendisItem.getType().equals(Item.Type.UserStory.name())) {
                    id = ((TeamContainer)kendisItem.getTeamContainers().get(0)).getId();
                }
                HashMap<String, Item> requestMap = new HashMap<String, Item>();
                List AllLinks = this.itemLinkRepository.findBySourceTeamContainerIdOrTargetTeamContainerId(id, id);
                ArrayList<Notification> emailNotificationList = new ArrayList<Notification>();
                if (PropertyValidator.isValid((Object)kendisItem.getContainer()) && PropertyValidator.isValid((Object)kendisItem.getTeam())) {
                    for (int i = 0; i < AllLinks.size(); ++i) {
                        ItemLink link = (ItemLink)AllLinks.get(i);
                        requestMap.put("oldStateItem", kendisItem);
                        this.notificationService.createMeta(link, requestMap);
                        ArrayList emailsMap = new ArrayList();
                        emailsMap = this.notificationService.dataJsonForEmail(link, link, requestMap);
                        for (int j = 0; j < emailsMap.size(); ++j) {
                            Map emailRecipientMap = new HashMap();
                            emailRecipientMap = (Map)((HashMap)emailsMap.get(j)).get("emailRecipientMap");
                            if (!PropertyValidator.isValid(emailRecipientMap)) continue;
                            String loggedInUser = this.itemLog.getActivityBy();
                            if (PropertyValidator.isValid((Object)loggedInUser)) {
                                ((HashMap)emailsMap.get(j)).put("loggedInUser", loggedInUser);
                            }
                            String subject = this.notificationService.getEmailSubject((HashMap)emailsMap.get(j));
                            if (emailRecipientMap.values().stream().mapToInt(List::size).sum() <= 0) continue;
                            Notification notification = new Notification(((HashMap)emailsMap.get(j)).get("groupingSubject").toString(), subject, Notification.ItemType.ItemLink, "dependency_onCellChange_template", emailRecipientMap, (Map)emailsMap.get(j));
                            emailNotificationList.add(notification);
                        }
                        if (!PropertyValidator.isValid(emailNotificationList)) continue;
                        this.notificationReposiotory.save(emailNotificationList);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("FAILED: sendNotificaiton " + StringUtils.getTraceString((Throwable)ex) + "\n ");
        }
    }
}

