/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.enums.EnumActivityType;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.persistence.repository.BacklogItemRepository;
import com.viztrend.safe.strategy.LoggerExclusionStrategy;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyAccessor;
import org.springframework.data.mongodb.core.MongoTemplate;

public class BacklogItemChangedLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklogItemChangedLogger.class);
    Gson gson = new GsonBuilder().create();
    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).create();
    private Date eventTime;
    private TimeSeriesLog backlogItemHistory = new TimeSeriesLog();
    private Object item;
    private MongoTemplate mongoTemplate;
    private BacklogItemRepository backlogItemRepository;

    public BacklogItemChangedLogger(Object item, Date eventTime, MongoTemplate mongoTemplate, BacklogItemRepository backlogItemRepository) {
        this.item = item;
        this.eventTime = eventTime;
        this.mongoTemplate = mongoTemplate;
        this.backlogItemRepository = backlogItemRepository;
    }

    public void checkChanges(Object oldState, PropertyAccessor pa) {
        try {
            Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
            String oldStateJson = this.gsonExclusive.toJson(oldState);
            String newStateJson = this.gsonExclusive.toJson(this.item);
            Map newStateMap = (Map)this.gsonExclusive.fromJson(newStateJson, mapType);
            HashMap changeAndOnlyLeftRightItemsMap = new HashMap();
            this.backlogItemHistory.setEventTime(this.eventTime);
            this.backlogItemHistory.setItemId((String)newStateMap.get("id"));
            this.backlogItemHistory.setTitle((String)newStateMap.get("title"));
            this.backlogItemHistory.setItemType(TimeSeriesLog.ItemType.BACKLOG_ITEM);
            this.backlogItemHistory.setEventType(EnumActivityType.CREATED.getCode());
            this.backlogItemHistory.setKey((String)newStateMap.get("almKey"));
            if (PropertyValidator.isValid((Object)oldState)) {
                Map oldStateMap = (Map)this.gsonExclusive.fromJson(oldStateJson, mapType);
                MapDifference diffMap = null;
                if (PropertyValidator.isValid((Object)oldStateMap) && PropertyValidator.isValid((Object)newStateMap)) {
                    diffMap = Maps.difference((Map)oldStateMap, (Map)newStateMap);
                }
                if (PropertyValidator.isValid(diffMap)) {
                    HashMap differingRightValues = new HashMap();
                    diffMap.entriesDiffering().forEach((key, valueDifference) -> differingRightValues.put(key, valueDifference.rightValue()));
                    changeAndOnlyLeftRightItemsMap.putAll(differingRightValues);
                    changeAndOnlyLeftRightItemsMap.putAll(diffMap.entriesOnlyOnLeft());
                    changeAndOnlyLeftRightItemsMap.putAll(diffMap.entriesOnlyOnRight());
                }
                String changesJson = this.gson.toJson(changeAndOnlyLeftRightItemsMap);
                HashMap changes = (HashMap)this.gson.fromJson(changesJson, new /* Unavailable Anonymous Inner Class!! */.getType());
                this.backlogItemHistory.setChanges((Map)changes);
                this.backlogItemHistory.setEventType(EnumActivityType.UPDATED.getCode());
            } else {
                HashMap changes = new HashMap();
                changes.put("fields", newStateMap.get("fields"));
                changes.put("status", newStateMap.get("status"));
                this.backlogItemHistory.setChanges(changes);
                if (pa.isReadableProperty("tenant")) {
                    this.backlogItemHistory.setTenant(String.valueOf(pa.getPropertyValue("tenant")));
                }
            }
            if (this.backlogItemHistory.getChanges() != null && this.backlogItemHistory.getChanges().size() > 0) {
                this.mongoTemplate.save((Object)this.backlogItemHistory);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private Map<String, Object> findDifferences(String newJson, String oldJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode newJsonNode = objectMapper.readTree(newJson);
            JsonNode oldJsonNode = objectMapper.readTree(oldJson);
            return this.findJsonDifferencesUtil(newJsonNode, oldJsonNode);
        }
        catch (Exception ex) {
            StringUtils.getTraceString((Throwable)ex);
            return null;
        }
    }

    private Map<String, Object> findJsonDifferencesUtil(JsonNode node1, JsonNode node2) {
        HashMap<String, Object> differences = new HashMap<String, Object>();
        if (!node1.equals((Object)node2)) {
            Iterator fieldNames = node1.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode value1 = node1.get(fieldName);
                JsonNode value2 = node2.get(fieldName);
                if (value1 != null && value2 != null) {
                    if (value1.equals((Object)value2)) continue;
                    if (value1.isObject() && value2.isObject()) {
                        Map nestedDifferences = this.findJsonDifferencesUtil(value1, value2);
                        if (nestedDifferences.isEmpty()) continue;
                        differences.put(fieldName, nestedDifferences);
                        continue;
                    }
                    differences.put(fieldName, value1);
                    continue;
                }
                differences.put(fieldName, value1);
            }
        }
        return differences;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public TimeSeriesLog getBacklogItemHistory() {
        return this.backlogItemHistory;
    }

    public void setBacklogItemHistory(TimeSeriesLog backlogItemHistory) {
        this.backlogItemHistory = backlogItemHistory;
    }

    public Object getItem() {
        return this.item;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public BacklogItemRepository getBacklogItemRepository() {
        return this.backlogItemRepository;
    }

    public void setBacklogItemRepository(BacklogItemRepository backlogItemRepository) {
        this.backlogItemRepository = backlogItemRepository;
    }
}

