/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.interceptor;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.persistence.entity.BacklogItemLog;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.strategy.LoggerExclusionStrategy;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.context.SecurityContextHolder;

public class BacklogItemChangeLogger
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklogItemChangeLogger.class);
    Gson gsonExclusive = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new LoggerExclusionStrategy()).create();
    Gson gson = new GsonBuilder().create();
    private Object item;
    private final Object oldState;
    private Date eventTime;
    private String eventType;
    private MongoTemplate mongoTemplate;
    private BacklogItemLog itemLog;

    public BacklogItemChangeLogger(Object item, Date eventTime, String eventType, Gson gson, Object oldState) {
        BacklogItemLog itemLog = new BacklogItemLog();
        SecureUser secureUser = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            itemLog.setActivityBy(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getFullName());
        }
        this.item = item;
        this.itemLog = itemLog;
        this.eventTime = eventTime;
        this.eventType = eventType;
        this.oldState = oldState;
    }

    public BacklogItemChangeLogger(Object item, Date eventTime, String eventType, Gson gson, ApplicationContext applicationContext, Object oldState) {
        BacklogItemLog itemLog = new BacklogItemLog();
        SecureUser secureUser = null;
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
            secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            itemLog.setActivityBy(((User)secureUser.getUserContextDTO().getContextMap().get("user")).getFullName());
        }
        this.item = item;
        this.itemLog = itemLog;
        this.eventTime = eventTime;
        this.eventType = eventType;
        this.mongoTemplate = (MongoTemplate)applicationContext.getBean("mongoTemplate");
        this.oldState = oldState;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    @Override
    public void run() {
        this.checkChanges();
    }

    public Object getItem() {
        return this.item;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public MongoTemplate getMongoTemplate() {
        return this.mongoTemplate;
    }

    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public void checkChanges() {
        try {
            String oldStateJson = this.gsonExclusive.toJson(this.oldState);
            String newStateJson = this.gsonExclusive.toJson(this.item);
            Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();
            Map oldStateMap = (Map)this.gsonExclusive.fromJson(oldStateJson, mapType);
            Map newStateMap = (Map)this.gsonExclusive.fromJson(newStateJson, mapType);
            if (PropertyValidator.isValid((Object)this.oldState)) {
                this.itemLog.setEventType(BacklogItemLog.EventType.UPDATED.toString());
            } else {
                this.itemLog.setEventType(BacklogItemLog.EventType.CREATED.toString());
            }
            this.itemLog.setItemType("BacklogItem");
            this.itemLog.setItemId(newStateMap.get("id").toString());
            this.itemLog.setChangeFrom(oldStateMap);
            this.itemLog.setChangeTo(newStateMap);
            if (this.mongoTemplate != null) {
                this.mongoTemplate.save((Object)this.itemLog);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    private Object findById(String id, Class T) {
        return this.mongoTemplate.findById((Object)id, T);
    }

    private String getLastLogId(String itemId) {
        try {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"detail").ne(null));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"itemId").is((Object)itemId));
            query.with(new Sort(Sort.Direction.DESC, new String[]{"eventTime"}));
            BacklogItemLog lastLog = (BacklogItemLog)this.mongoTemplate.findOne(query, BacklogItemLog.class);
            if (lastLog != null) {
                return lastLog.getId();
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return null;
    }
}

