/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config.filter;

import com.mongodb.CommandResult;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class SimpleCORSFilter
implements Filter {
    private final Logger log = LoggerFactory.getLogger(SimpleCORSFilter.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Environment env;

    public SimpleCORSFilter() {
        this.log.info("SimpleCORSFilter init");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String origin;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (request.getRequestURI().contains("/assets")) {
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "public, max-age=9000000");
            response.setHeader("Expires", "Tue, 03 Jul 2020 06:00:00 GMT");
            response.setHeader("Pragma", "public");
        } else if (request.getRequestURI().contains("/extension") || request.getRequestURI().contains("/me")) {
            origin = request.getHeader("Origin");
            response.setHeader("Access-Control-Allow-Origin", origin);
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, proxy-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept,Authorization");
        } else {
            if (this.env.getProperty("maintenance") != null && this.env.getProperty("maintenance").equals("true") && !request.getRequestURI().contains("/maintenance") && !request.getRequestURI().contains("/app/health") && !request.getRequestURI().contains("/app/version")) {
                response.sendRedirect("/maintenance");
            }
            origin = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            response.setHeader("Strict-Transport-Security", "max-age=31622400; includeSubDomains");
            response.setHeader("Access-Control-Allow-Origin", origin);
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            response.sendRedirect("/signin");
        }
        if (this.env.getProperty("isLocalDeployment").equals("true") && !request.getRequestURI().contains("/system") && !request.getRequestURI().contains("/assets")) {
            try {
                CommandResult commandResult = this.mongoTemplate.getDb().getStats();
            }
            catch (Exception ex) {
                if (UserContextUtil.getUserContext() != null) {
                    response.sendRedirect("/signout");
                } else {
                    response.sendRedirect("/system");
                }
                return;
            }
        }
        chain.doFilter(req, res);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

