/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.aws.messaging.config.SimpleMessageListenerContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SQSConfig {
    @Value(value="${sqs.aws.region}")
    private String region;
    @Value(value="${sqs.aws.accessKey}")
    private String accessKey;
    @Value(value="${sqs.aws.secretKey}")
    private String secretKey;
    @Value(value="${sqs.webhook.jira.queue.name}")
    private String jiraQueueName;
    @Value(value="${sqs.webhook.tfs.queue.name}")
    private String tfsQueueName;

    @Bean
    public AmazonSQS amazonSQS() {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.accessKey, this.secretKey);
        return (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withRegion(this.region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    @Bean
    public AmazonSQSAsync amazonSQSAsync() {
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.accessKey, this.secretKey);
        return (AmazonSQSAsync)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withRegion(this.region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    @Bean
    public SimpleMessageListenerContainerFactory simpleMessageListenerContainerFactory() {
        SimpleMessageListenerContainerFactory factory = new SimpleMessageListenerContainerFactory();
        factory.setAmazonSqs(this.amazonSQSAsync());
        factory.setMaxNumberOfMessages(Integer.valueOf(10));
        factory.setWaitTimeOut(Integer.valueOf(10));
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(10);
        executor.setMaxPoolSize(50);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix("sqs-poller-");
        executor.initialize();
        factory.setTaskExecutor((AsyncTaskExecutor)executor);
        return factory;
    }

    @Bean
    public String jiraQueueName() {
        return this.jiraQueueName;
    }

    @Bean
    public String tfsQueueName() {
        return this.tfsQueueName;
    }

    @Bean
    public Gson gson() {
        JsonDeserializer jsonObjectDeserializer = (json, typeOfT, context) -> new JSONObject(json.toString());
        return new GsonBuilder().registerTypeAdapter(JSONObject.class, (Object)jsonObjectDeserializer).create();
    }
}

