/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.utils;

import com.google.common.collect.MapDifference;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.viztrend.safe.utils.KendisUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LoggerUtils {
    public static Map<String, Object> getChangesFromDiffMap(MapDifference<String, Object> diffMap, Gson gson) {
        Map<String, Object> changesMap = new HashMap<String, Object>();
        if (!PropertyValidator.isValid(diffMap) || !PropertyValidator.isValid((Object)gson)) {
            return changesMap;
        }
        HashMap changesAndRemovedItemsMap = new HashMap();
        HashMap differingRightValues = new HashMap();
        diffMap.entriesDiffering().forEach((key, valueDifference) -> differingRightValues.put(key, valueDifference.rightValue()));
        diffMap.entriesOnlyOnLeft().forEach((key, value) -> differingRightValues.putIfAbsent(key, null));
        changesAndRemovedItemsMap.putAll(diffMap.entriesOnlyOnRight());
        changesAndRemovedItemsMap.putAll(differingRightValues);
        Gson gsonWithNullSerialization = new GsonBuilder().serializeNulls().create();
        String changesJson = gsonWithNullSerialization.toJson(changesAndRemovedItemsMap);
        Type type = new /* Unavailable Anonymous Inner Class!! */.getType();
        changesMap = (Map)gson.fromJson(changesJson, type);
        return changesMap;
    }

    public static Date getUpdatedOnFromAlmItem(Map<String, Object> jiraFields, Map<String, Object> azureFields) throws ParseException {
        String changedDateStr = null;
        Date eventTime = new Date();
        boolean isJira = false;
        if (PropertyValidator.isValid(jiraFields) && jiraFields.containsKey("updated")) {
            changedDateStr = (String)jiraFields.get("updated");
            isJira = true;
        } else if (PropertyValidator.isValid(azureFields) && azureFields.containsKey("ChangedDate")) {
            changedDateStr = (String)azureFields.get("ChangedDate");
        }
        if (PropertyValidator.isValid(changedDateStr)) {
            eventTime = KendisUtils.convertStringToDate((String)changedDateStr, (String)(isJira ? "yyyy-MM-dd'T'HH:mm:ss.SSSZ" : "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        }
        return eventTime;
    }
}

