/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.utils;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.viztrend.safe.persistence.entity.BaseItemLink;
import com.viztrend.safe.persistence.entity.Company;
import com.viztrend.safe.persistence.entity.Container;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Session;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Team;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.UserCompany;
import com.viztrend.safe.utils.DBUtils;
import com.viztrend.safe.utils.PropertyValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBOjectConversionUtils {
    public static List<TeamContainer> convertToTeamContainers(List<BasicDBObject> teamContainersObj) {
        if (!PropertyValidator.isValid(teamContainersObj)) {
            return null;
        }
        ArrayList<TeamContainer> teamContainers = new ArrayList<TeamContainer>();
        teamContainersObj.forEach(teamContainerObj -> {
            String id;
            BasicDBObject containerObj;
            TeamContainer teamContainer = new TeamContainer();
            BasicDBObject teamObj = PropertyValidator.isValid((Object)teamContainerObj.get("team")) ? (BasicDBObject)teamContainerObj.get("team") : null;
            BasicDBObject basicDBObject = containerObj = PropertyValidator.isValid((Object)teamContainerObj.get("container")) ? (BasicDBObject)teamContainerObj.get("container") : null;
            if (PropertyValidator.isValid((Object)teamObj)) {
                Team team = new Team();
                team.setId(DBUtils.getIdFromDBObject((BasicDBObject)teamObj, (String[])new String[0]));
                team.setArchive(teamObj.getBoolean("archive", false));
                team.setTenant(teamObj.getString("tenant"));
                teamContainer.setTeam(team);
            }
            if (PropertyValidator.isValid((Object)containerObj)) {
                Container container = new Container();
                container.setId(DBUtils.getIdFromDBObject((BasicDBObject)containerObj, (String[])new String[0]));
                container.setArchive(containerObj.getBoolean("archive", false));
                container.setTenant(containerObj.getString("tenant"));
                teamContainer.setContainer(container);
            }
            if (PropertyValidator.isValid((Object)(id = DBUtils.getIdFromDBObject((BasicDBObject)teamContainerObj, (String[])new String[0])))) {
                teamContainer.setId(id);
                teamContainer.setArchive(teamContainerObj.getBoolean("archive", false));
                teamContainer.setTenant(teamContainerObj.getString("tenant"));
                teamContainers.add(teamContainer);
            }
        });
        return teamContainers;
    }

    public static List<SessionBoard> convertToSessionBoards(List<BasicDBObject> sessionBoardsObj) {
        if (!PropertyValidator.isValid(sessionBoardsObj)) {
            return null;
        }
        ArrayList<SessionBoard> sessionBoards = new ArrayList<SessionBoard>();
        sessionBoardsObj.forEach(sessionBoardObj -> {
            DBRef sessionDbRef;
            SessionBoard sessionBoard = new SessionBoard();
            sessionBoard.setId(DBUtils.getIdFromDBObject((BasicDBObject)sessionBoardObj, (String[])new String[0]));
            sessionBoard.setArchive(sessionBoardObj.getBoolean("archive", false));
            sessionBoard.setTenant(sessionBoardObj.getString("tenant"));
            DBRef dBRef = sessionDbRef = PropertyValidator.isValid((Object)sessionBoardObj.get("session")) ? (DBRef)sessionBoardObj.get("session") : null;
            if (PropertyValidator.isValid((Object)sessionDbRef)) {
                Session session = new Session();
                session.setId(String.valueOf(sessionDbRef.getId()));
                sessionBoard.setSession(session);
            }
            sessionBoards.add(sessionBoard);
        });
        return sessionBoards;
    }

    public static Item convertToParent(BasicDBObject parentObj) {
        if (!PropertyValidator.isValid((Object)parentObj)) {
            return null;
        }
        Item parent = new Item();
        parent.setId(DBUtils.getIdFromDBObject((BasicDBObject)parentObj, (String[])new String[0]));
        parent.setTitle(parentObj.getString("title"));
        parent.setType(parentObj.getString("type"));
        parent.setStoryPoints(Double.valueOf(PropertyValidator.isValid((Object)parentObj.get("storyPoints")) ? parentObj.getDouble("storyPoints") : 0.0));
        parent.setTenant(parentObj.getString("tenant"));
        return parent;
    }

    public static User convertToUser(BasicDBObject userObj) {
        if (!PropertyValidator.isValid((Object)userObj)) {
            return null;
        }
        User user = new User();
        user.setId(DBUtils.getIdFromDBObject((BasicDBObject)userObj, (String[])new String[0]));
        if (userObj.containsField("userType")) {
            user.setUserType(User.UserType.valueOf((String)userObj.getString("userType")));
        }
        if (userObj.containsField("userCompanies")) {
            List userCompaniesObj = (List)userObj.get("userCompanies");
            ArrayList userCompanies = new ArrayList();
            userCompaniesObj.forEach(userCompanyObj -> {
                UserCompany userCompany = DBOjectConversionUtils.convertToUserCompany((BasicDBObject)userCompanyObj);
                userCompanies.add(userCompany);
            });
            user.setUserCompanies(userCompanies);
        }
        user.setTenant(userObj.getString("tenant"));
        return user;
    }

    public static UserCompany convertToUserCompany(BasicDBObject userCompanyObj) {
        if (!PropertyValidator.isValid((Object)userCompanyObj)) {
            return null;
        }
        UserCompany userCompany = new UserCompany();
        userCompany.setIsActive(Boolean.valueOf(userCompanyObj.getBoolean("isActive", true)));
        userCompany.setIsOwner(Boolean.valueOf(userCompanyObj.getBoolean("isOwner")));
        userCompany.setIsAdmin(Boolean.valueOf(userCompanyObj.getBoolean("isAdmin")));
        userCompany.setIsGuest(Boolean.valueOf(userCompanyObj.getBoolean("isGuest")));
        userCompany.setIsArchive(Boolean.valueOf(userCompanyObj.getBoolean("isArchive")));
        userCompany.setIsCompanyFounder(Boolean.valueOf(userCompanyObj.getBoolean("isCompanyFounder")));
        userCompany.setIsPaymentResponsible(Boolean.valueOf(userCompanyObj.getBoolean("isPaymentResponsible")));
        userCompany.setSyncDefaultData(Boolean.valueOf(userCompanyObj.getBoolean("syncDefaultData")));
        userCompany.setLastLogin(userCompanyObj.getDate("lastLogin"));
        if (userCompanyObj.get("company") instanceof DBRef) {
            DBRef companyRef = (DBRef)userCompanyObj.get("company");
            Company company = new Company();
            company.setId(companyRef.getId().toString());
            userCompany.setCompany(company);
        } else if (userCompanyObj.get("company") instanceof BasicDBObject) {
            BasicDBObject companyObj = (BasicDBObject)userCompanyObj.get("company");
            Company company = new Company();
            company.setId(DBUtils.getIdFromDBObject((BasicDBObject)companyObj, (String[])new String[0]));
            userCompany.setCompany(company);
        }
        return userCompany;
    }

    public static BaseItemLink convertToBaseItemLink(BasicDBObject baseItemLinkObj) {
        if (!PropertyValidator.isValid((Object)baseItemLinkObj)) {
            return null;
        }
        BaseItemLink baseItemLink = new BaseItemLink();
        baseItemLink.setId(DBUtils.getIdFromDBObject((BasicDBObject)baseItemLinkObj, (String[])new String[0]));
        baseItemLink.setArchive(baseItemLinkObj.getBoolean("archive", false));
        baseItemLink.setTenant(baseItemLinkObj.getString("tenant"));
        baseItemLink.setSessionId(baseItemLinkObj.getString("sessionId"));
        baseItemLink.setSessionBoardId(baseItemLinkObj.getString("sessionBoardId"));
        baseItemLink.setSolutionId(baseItemLinkObj.getString("solutionId"));
        baseItemLink.setScrumOfScrumId(baseItemLinkObj.getString("scrumOfScrumId"));
        baseItemLink.setTeamId(baseItemLinkObj.getString("teamId"));
        baseItemLink.setSprintId(baseItemLinkObj.getString("sprintId"));
        baseItemLink.setTeamContainerId(baseItemLinkObj.getString("teamContainerId"));
        baseItemLink.setLinkType(baseItemLinkObj.getString("linkType"));
        baseItemLink.setBaseItemId(baseItemLinkObj.getString("baseItemId"));
        baseItemLink.setBacklogItemId(baseItemLinkObj.getObjectId("backlogItemId"));
        baseItemLink.setItemId(baseItemLinkObj.getString("itemId"));
        baseItemLink.setType(baseItemLinkObj.getString("type"));
        baseItemLink.setRiskId(baseItemLinkObj.getString("riskId"));
        baseItemLink.setLaneId(baseItemLinkObj.getString("laneId"));
        baseItemLink.setKanbanId(baseItemLinkObj.getString("kanbanId"));
        baseItemLink.setReleaseTrainId(baseItemLinkObj.getString("releaseTrainId"));
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("baseItem"))) {
            baseItemLink.setRowStatus(baseItemLinkObj.getInt("rowStatus"));
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("backlogLevel"))) {
            baseItemLink.setBacklogLevel(Integer.valueOf(baseItemLinkObj.getInt("backlogLevel")));
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("linkedItemById"))) {
            BasicDBObject linkedItemByIdObj = (BasicDBObject)baseItemLinkObj.get("linkedItemById");
            HashMap linkedItemById = new HashMap(linkedItemByIdObj);
            baseItemLink.setLinkedItemById(linkedItemById);
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("sequence"))) {
            baseItemLink.setSequence(Double.valueOf(baseItemLinkObj.getDouble("sequence")));
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("weightage"))) {
            baseItemLink.setWeightage(Double.valueOf(baseItemLinkObj.getDouble("weightage")));
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("linkedItemById"))) {
            baseItemLink.setLinkedItemById((Map)baseItemLinkObj.get("linkedItemById"));
        }
        if (PropertyValidator.isValid((Object)baseItemLinkObj.get("createdOn"))) {
            baseItemLink.setCreatedOn(baseItemLinkObj.getDate("createdOn"));
        }
        return baseItemLink;
    }
}

