/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service.logger;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.viztrend.safe.change.stream.service.logger.AbstractCFDLogger;
import com.viztrend.safe.change.stream.utils.LoggerUtils;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class SessionCFDLogger
extends AbstractCFDLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCFDLogger.class);
    private final TimeSeriesLog timeSeriesLog;
    private final Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();

    public SessionCFDLogger(Object item, Date eventTime, Object oldState, MongoTemplate mongoTemplate, String tenant, String timeSeriesCollectionName) {
        super(item, oldState, eventTime, mongoTemplate, timeSeriesCollectionName);
        this.timeSeriesLog = new TimeSeriesLog(tenant);
    }

    public void checkChanges() {
        try {
            String newStateJson = gson.toJson(this.item);
            Map newStateMap = (Map)gson.fromJson(newStateJson, this.mapType);
            this.timeSeriesLog.setItemId((String)newStateMap.get("id"));
            this.timeSeriesLog.getMeta().put("sessionId", newStateMap.get("sessionId"));
            this.timeSeriesLog.getMeta().put("sessionBoardId", newStateMap.get("sessionBoardId"));
            this.timeSeriesLog.setEventTime(this.eventTime);
            if (PropertyValidator.isValid((Object)this.oldState)) {
                MapDifference diffMap;
                String oldStateJson = gson.toJson(this.oldState);
                Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
                MapDifference mapDifference = diffMap = PropertyValidator.isValid((Object)oldStateMap) && PropertyValidator.isValid((Object)newStateMap) ? Maps.difference((Map)oldStateMap, (Map)newStateMap) : null;
                if (PropertyValidator.isValid(diffMap)) {
                    Map changes = LoggerUtils.getChangesFromDiffMap((MapDifference)diffMap, (Gson)gson);
                    this.timeSeriesLog.setChanges(changes);
                }
            } else {
                Map changes = (Map)gson.fromJson(newStateJson, this.mapType);
                this.timeSeriesLog.setChanges(changes);
            }
            if (this.timeSeriesLog.getChanges() != null && !this.timeSeriesLog.getChanges().isEmpty()) {
                this.mongoTemplate.save((Object)this.timeSeriesLog, this.timeSeriesCollectionName);
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void logChangesForDeletion() {
        try {
            String oldStateJson = gson.toJson(this.oldState);
            Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
            HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
            this.timeSeriesLog.setItemId((String)oldStateMap.get("id"));
            this.timeSeriesLog.getMeta().put("sessionId", oldStateMap.get("sessionId"));
            this.timeSeriesLog.getMeta().put("sessionBoardId", oldStateMap.get("sessionBoardId"));
            this.timeSeriesLog.setEventTime(this.eventTime);
            changes.put("archive", true);
            this.timeSeriesLog.setChanges(changes);
            this.mongoTemplate.save((Object)this.timeSeriesLog, this.timeSeriesCollectionName);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }
}

