/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service.logger;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.change.stream.model.TeamContainerMirror;
import com.viztrend.safe.change.stream.service.logger.AbstractCFDLogger;
import com.viztrend.safe.change.stream.utils.LoggerUtils;
import com.viztrend.safe.change.stream.utils.ServiceUtils;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class ItemCFDLogger
extends AbstractCFDLogger
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemCFDLogger.class);
    private final TimeSeriesLog itemHistory;
    private final Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();

    public ItemCFDLogger(Object item, Date eventTime, Object oldState, MongoTemplate mongoTemplate, String tenant, String timeSeriesCollectionName) {
        super(item, oldState, eventTime, mongoTemplate, timeSeriesCollectionName);
        this.itemHistory = new TimeSeriesLog(tenant);
    }

    @Override
    public void run() {
        this.checkChanges();
    }

    public void checkChanges() {
        try {
            String newStateJson = gson.toJson(this.item);
            Map newStateMap = (Map)gson.fromJson(newStateJson, this.mapType);
            this.itemHistory.setItemId((String)newStateMap.get("id"));
            this.itemHistory.setTitle((String)newStateMap.get("title"));
            this.itemHistory.setItemType(TimeSeriesLog.ItemType.ITEM);
            this.itemHistory.setAlmType((String)newStateMap.get("type"));
            this.itemHistory.setEventTime(this.eventTime);
            if (newStateMap.containsKey("jiraId")) {
                this.itemHistory.setAlmId((String)newStateMap.get("jiraId"));
                this.itemHistory.setJiraKey((String)newStateMap.get("jiraKey"));
            } else if (newStateMap.containsKey("tfsId")) {
                this.itemHistory.setTfsId((String)newStateMap.get("tfsId"));
            } else {
                this.itemHistory.setAlmId((String)newStateMap.get("jiraKey"));
            }
            if (PropertyValidator.isValid((Object)this.oldState)) {
                MapDifference diffMap;
                String oldStateJson = gson.toJson(this.oldState);
                Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
                List newStateJiraFieldMap = (List)newStateMap.get("jiraFieldMap");
                List oldStateJiraFieldMap = (List)oldStateMap.get("jiraFieldMap");
                this.removeUpdatedAndCreatedFromList(newStateJiraFieldMap);
                this.removeUpdatedAndCreatedFromList(oldStateJiraFieldMap);
                Map newStateJiraFieldByKeyMap = (Map)newStateMap.get("jiraFieldByKey");
                Map oldStateJiraFieldByKeyMap = (Map)oldStateMap.get("jiraFieldByKey");
                this.removeFieldFromMap(newStateJiraFieldByKeyMap, JiraField.FIXED.updated.name());
                this.removeFieldFromMap(oldStateJiraFieldByKeyMap, JiraField.FIXED.updated.name());
                this.removeFieldFromMap(newStateJiraFieldByKeyMap, JiraField.FIXED.created.name());
                this.removeFieldFromMap(oldStateJiraFieldByKeyMap, JiraField.FIXED.created.name());
                MapDifference mapDifference = diffMap = PropertyValidator.isValid((Object)oldStateMap) && PropertyValidator.isValid((Object)newStateMap) ? Maps.difference((Map)oldStateMap, (Map)newStateMap) : null;
                if (PropertyValidator.isValid(diffMap)) {
                    Map changes = LoggerUtils.getChangesFromDiffMap((MapDifference)diffMap, (Gson)gson);
                    if (PropertyValidator.isValid(changes.get("jiraFieldMap"))) {
                        List jiraFieldMap = (List)changes.get("jiraFieldMap");
                        for (Map fieldMap : jiraFieldMap) {
                            if (!"JSONObject".equals(fieldMap.get("type")) || !fieldMap.containsKey("value") || !ServiceUtils.isValidJson((String)fieldMap.get("value").toString())) continue;
                            try {
                                JsonObject jsonObject = (JsonObject)gson.fromJson(fieldMap.get("value").toString(), JsonObject.class);
                                if (!PropertyValidator.isValid((Object)jsonObject)) continue;
                                Map value = (Map)gson.fromJson((JsonElement)jsonObject, this.mapType);
                                fieldMap.put("value", value);
                            }
                            catch (Exception e) {
                                LOGGER.info("Exception occured while parsing Json Object, Method: checkChanges, FieldMap: " + fieldMap);
                            }
                        }
                    } else if (changes.containsKey("jiraFieldMap") && !PropertyValidator.isValid(changes.get("jiraFieldMap"))) {
                        changes.remove("jiraFieldMap");
                    }
                    if (changes.containsKey("jiraFieldByKey") && !PropertyValidator.isValid(changes.get("jiraFieldByKey"))) {
                        changes.remove("jiraFieldByKey");
                    }
                    this.itemHistory.setChanges(changes);
                }
            } else {
                Map changes = (Map)gson.fromJson(newStateJson, this.mapType);
                this.itemHistory.setChanges(changes);
            }
            this.setSessionBoardIdInEntry(newStateMap, this.itemHistory);
            if (PropertyValidator.isValid(newStateMap.get("teamContainers"))) {
                List teamContainers = (List)newStateMap.get("teamContainers");
                ArrayList teamContainerMirrors = PropertyValidator.isValid((Collection)teamContainers) ? teamContainers.stream().map(TeamContainerMirror::new).collect(Collectors.toList()) : new ArrayList();
                this.itemHistory.setTeamContainers(teamContainerMirrors);
            }
            if (this.itemHistory.getChanges() != null && !this.itemHistory.getChanges().isEmpty()) {
                HashMap<String, Map> jiraFieldByKeyMap;
                Map issuetype;
                Map jiraFieldByKey;
                Map parentMap;
                Map newChanges = this.itemHistory.getChanges();
                HashMap staticFields = new HashMap();
                if (newChanges.containsKey("parent")) {
                    staticFields.put("parent", newChanges.get("parent"));
                } else if (PropertyValidator.isValid(newStateMap.get("parent"))) {
                    staticFields.put("parent", newStateMap.get("parent"));
                }
                if (PropertyValidator.isValid((Object)this.itemHistory.getMeta()) && PropertyValidator.isValid(staticFields.get("parent")) && PropertyValidator.isValid((Object)(parentMap = (Map)staticFields.get("parent")))) {
                    String parentId = (String)parentMap.get("id");
                    this.itemHistory.getMeta().put("staticFieldsParentId", parentId);
                }
                if (newChanges.containsKey("archive")) {
                    staticFields.put("archive", newChanges.get("archive"));
                } else if (PropertyValidator.isValid(newStateMap.get("archive"))) {
                    staticFields.put("archive", newStateMap.get("archive"));
                }
                if (newChanges.containsKey("status")) {
                    staticFields.put("status", newChanges.get("status"));
                } else if (PropertyValidator.isValid(newStateMap.get("status"))) {
                    staticFields.put("status", newStateMap.get("status"));
                }
                if (newChanges.containsKey("storyPoints")) {
                    staticFields.put("storyPoints", newChanges.get("storyPoints"));
                } else if (PropertyValidator.isValid(newStateMap.get("storyPoints"))) {
                    staticFields.put("storyPoints", newStateMap.get("storyPoints"));
                }
                if (newChanges.containsKey("jiraFieldByKey")) {
                    jiraFieldByKey = (Map)newChanges.get("jiraFieldByKey");
                    issuetype = (Map)jiraFieldByKey.get("issuetype");
                    jiraFieldByKeyMap = new HashMap<String, Map>();
                    jiraFieldByKeyMap.put("issuetype", issuetype);
                    staticFields.put("jiraFieldByKey", jiraFieldByKeyMap);
                } else if (PropertyValidator.isValid(newStateMap.get("jiraFieldByKey"))) {
                    jiraFieldByKey = (Map)newStateMap.get("jiraFieldByKey");
                    issuetype = (Map)jiraFieldByKey.get("issuetype");
                    jiraFieldByKeyMap = new HashMap();
                    jiraFieldByKeyMap.put("issuetype", issuetype);
                    staticFields.put("jiraFieldByKey", jiraFieldByKeyMap);
                }
                if (newChanges.containsKey("issueType")) {
                    staticFields.put("issueType", newChanges.get("issueType"));
                } else if (PropertyValidator.isValid(newStateMap.get("issueType"))) {
                    staticFields.put("issueType", newStateMap.get("issueType"));
                }
                this.itemHistory.setStaticFields(staticFields);
                LOGGER.debug("Going to save item with id " + this.itemHistory.getItemId());
                this.mongoTemplate.save((Object)this.itemHistory, this.timeSeriesCollectionName);
            } else {
                LOGGER.debug("Skipping saving for item with id " + this.itemHistory.getItemId());
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void logChangesForDeletion() {
        try {
            String oldStateJson = gson.toJson(this.oldState);
            Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
            this.itemHistory.setItemId((String)oldStateMap.get("id"));
            this.itemHistory.setTitle((String)oldStateMap.get("title"));
            this.itemHistory.setItemType(TimeSeriesLog.ItemType.ITEM);
            this.itemHistory.setAlmType((String)oldStateMap.get("type"));
            this.itemHistory.setEventTime(this.eventTime);
            if (oldStateMap.containsKey("jiraId")) {
                this.itemHistory.setAlmId((String)oldStateMap.get("jiraId"));
                this.itemHistory.setJiraKey((String)oldStateMap.get("jiraKey"));
            } else if (oldStateMap.containsKey("tfsId")) {
                this.itemHistory.setTfsId((String)oldStateMap.get("tfsId"));
            } else {
                this.itemHistory.setAlmId((String)oldStateMap.get("jiraKey"));
            }
            HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
            changes.put("archive", true);
            this.itemHistory.setChanges(changes);
            this.setSessionBoardIdInEntry(oldStateMap, this.itemHistory);
            this.mongoTemplate.save((Object)this.itemHistory, this.timeSeriesCollectionName);
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    private void setSessionBoardIdInEntry(Map<String, Object> stateMap, TimeSeriesLog itemHistory) {
        Map sessionBoard;
        if (!PropertyValidator.isValid((Object)stateMap.get("sessionBoards"))) {
            return;
        }
        List sessionBoards = (List)stateMap.get("sessionBoards");
        if (PropertyValidator.isValid((Collection)sessionBoards) && PropertyValidator.isValid((Object)(sessionBoard = (Map)sessionBoards.get(0)))) {
            Map session = (Map)sessionBoard.get("session");
            if (PropertyValidator.isValid((Object)session)) {
                itemHistory.getMeta().put("sessionId", String.valueOf(session.get("id")));
            }
            itemHistory.getMeta().put("sessionBoardId", String.valueOf(sessionBoard.get("id")));
        }
    }

    private void removeUpdatedAndCreatedFromList(List<Map<String, Object>> list) {
        if (PropertyValidator.isValid(list)) {
            list.removeIf(map -> PropertyValidator.isValid(map.get("key")) && (JiraField.FIXED.updated.name().equals(map.get("key")) || JiraField.FIXED.created.name().equals(map.get("key"))));
        }
    }

    private void removeFieldFromMap(Map<String, Object> map, String fieldName) {
        if (PropertyValidator.isValid(map)) {
            map.remove(fieldName);
        }
    }
}

