/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.change.stream.service.logger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.viztrend.safe.change.stream.service.logger.AbstractCFDLogger;
import com.viztrend.safe.change.stream.service.logger.BaseItemCFDLogger;
import com.viztrend.safe.persistence.entity.TimeSeriesLog;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;

public class BacklogItemCFDLogger
extends AbstractCFDLogger
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklogItemCFDLogger.class);
    private final TimeSeriesLog backlogItemHistory;
    private final Type mapType = new /* Unavailable Anonymous Inner Class!! */.getType();

    public BacklogItemCFDLogger(Object item, Date eventTime, Object oldState, MongoTemplate mongoTemplate, String tenant, String timeSeriesCollectionName) {
        super(item, oldState, eventTime, mongoTemplate, timeSeriesCollectionName);
        this.backlogItemHistory = new TimeSeriesLog(tenant);
    }

    @Override
    public void run() {
        this.checkChanges();
    }

    public void checkChanges() {
        try {
            String newStateJson = gson.toJson(this.item);
            String oldStateJson = null;
            Map newStateMap = (Map)gson.fromJson(newStateJson, this.mapType);
            this.backlogItemHistory.setEventTime(this.eventTime);
            this.backlogItemHistory.setItemId((String)newStateMap.get("id"));
            this.backlogItemHistory.setTitle((String)newStateMap.get("title"));
            this.backlogItemHistory.setItemType(TimeSeriesLog.ItemType.BACKLOG_ITEM);
            this.backlogItemHistory.setAlmKey((String)newStateMap.get("almKey"));
            this.backlogItemHistory.setAlmType((String)newStateMap.get("almType"));
            if (PropertyValidator.isValid((Object)this.oldState)) {
                oldStateJson = gson.toJson(this.oldState);
            }
            Map changes = BaseItemCFDLogger.retrieveChanges((String)newStateJson, oldStateJson);
            this.backlogItemHistory.setChanges(changes);
            if (PropertyValidator.isValid(newStateMap.get("teamContainerRelations"))) {
                List teamContainerRelations = (List)newStateMap.get("teamContainerRelations");
                this.backlogItemHistory.setTeamContainerRelations(teamContainerRelations);
            }
            if (this.backlogItemHistory.getChanges() != null && !this.backlogItemHistory.getChanges().isEmpty()) {
                Map newChanges = this.backlogItemHistory.getChanges();
                HashMap staticFields = new HashMap();
                if (newChanges.containsKey("objectiveRelations")) {
                    staticFields.put("objectiveRelations", newChanges.get("objectiveRelations"));
                } else if (PropertyValidator.isValid(newStateMap.get("objectiveRelations"))) {
                    staticFields.put("objectiveRelations", newStateMap.get("objectiveRelations"));
                }
                if (newChanges.containsKey("keyResultRelations")) {
                    staticFields.put("keyResultRelations", newChanges.get("keyResultRelations"));
                } else if (PropertyValidator.isValid(newStateMap.get("objectiveRelations"))) {
                    staticFields.put("keyResultRelations", newStateMap.get("keyResultRelations"));
                }
                if (newChanges.containsKey("artRelationMap")) {
                    staticFields.put("artRelationMap", newChanges.get("artRelationMap"));
                } else if (PropertyValidator.isValid(newStateMap.get("artRelationMap"))) {
                    staticFields.put("artRelationMap", newStateMap.get("artRelationMap"));
                }
                if (newChanges.containsKey("childRelationMap")) {
                    staticFields.put("childRelationMap", newChanges.get("childRelationMap"));
                } else if (PropertyValidator.isValid(newStateMap.get("childRelationMap"))) {
                    staticFields.put("childRelationMap", newStateMap.get("childRelationMap"));
                }
                if (newChanges.containsKey("milestoneRelations")) {
                    staticFields.put("milestoneRelations", newChanges.get("milestoneRelations"));
                } else if (PropertyValidator.isValid(newStateMap.get("milestoneRelations"))) {
                    staticFields.put("milestoneRelations", newStateMap.get("milestoneRelations"));
                }
                if (newChanges.containsKey("sectionRelations")) {
                    staticFields.put("sectionRelations", newChanges.get("sectionRelations"));
                } else if (PropertyValidator.isValid(newStateMap.get("sectionRelations"))) {
                    staticFields.put("sectionRelations", newStateMap.get("sectionRelations"));
                }
                if (newChanges.containsKey("status")) {
                    staticFields.put("status", newChanges.get("status"));
                } else if (PropertyValidator.isValid(newStateMap.get("status"))) {
                    staticFields.put("status", newStateMap.get("status"));
                }
                if (newChanges.containsKey("storyPoints")) {
                    staticFields.put("storyPoints", newChanges.get("storyPoints"));
                } else if (PropertyValidator.isValid(newStateMap.get("storyPoints"))) {
                    staticFields.put("storyPoints", newStateMap.get("storyPoints"));
                }
                if (newChanges.containsKey("fields")) {
                    staticFields.put("fields", newChanges.get("fields"));
                } else if (PropertyValidator.isValid(newStateMap.get("fields"))) {
                    staticFields.put("fields", newStateMap.get("fields"));
                }
                this.backlogItemHistory.setStaticFields(staticFields);
                LOGGER.debug("Going to save backlog item with id " + this.backlogItemHistory.getItemId());
                this.mongoTemplate.save((Object)this.backlogItemHistory, this.timeSeriesCollectionName);
            } else {
                LOGGER.debug("Skipping saving for backlog item with id " + this.backlogItemHistory.getItemId());
            }
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
        }
    }

    public void logChangesForDeletion() {
        String oldStateJson = gson.toJson(this.oldState);
        Map oldStateMap = (Map)gson.fromJson(oldStateJson, this.mapType);
        this.backlogItemHistory.setEventTime(this.eventTime);
        this.backlogItemHistory.setItemId((String)oldStateMap.get("id"));
        this.backlogItemHistory.setTitle((String)oldStateMap.get("title"));
        this.backlogItemHistory.setItemType(TimeSeriesLog.ItemType.BACKLOG_ITEM);
        this.backlogItemHistory.setAlmKey((String)oldStateMap.get("almKey"));
        this.backlogItemHistory.setAlmType((String)oldStateMap.get("almType"));
        HashMap<String, Boolean> changes = new HashMap<String, Boolean>();
        changes.put("archive", true);
        this.backlogItemHistory.setChanges(changes);
        this.mongoTemplate.save((Object)this.backlogItemHistory, this.timeSeriesCollectionName);
    }

    private Map<String, Object> findDifferences(String newJson, String oldJson) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode newJsonNode = objectMapper.readTree(newJson);
            JsonNode oldJsonNode = objectMapper.readTree(oldJson);
            return this.findJsonDifferencesUtil(newJsonNode, oldJsonNode);
        }
        catch (Exception ex) {
            StringUtils.getTraceString((Throwable)ex);
            return null;
        }
    }

    private Map<String, Object> findJsonDifferencesUtil(JsonNode node1, JsonNode node2) {
        HashMap<String, Object> differences = new HashMap<String, Object>();
        if (!node1.equals((Object)node2)) {
            Iterator fieldNames = node1.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                JsonNode value1 = node1.get(fieldName);
                JsonNode value2 = node2.get(fieldName);
                if (value1 != null && value2 != null) {
                    if (value1.equals((Object)value2)) continue;
                    if (value1.isObject() && value2.isObject()) {
                        Map nestedDifferences = this.findJsonDifferencesUtil(value1, value2);
                        if (nestedDifferences.isEmpty()) continue;
                        differences.put(fieldName, nestedDifferences);
                        continue;
                    }
                    if (JsonNodeType.ARRAY.equals((Object)value1.getNodeType())) {
                        for (JsonNode arrayNode : value1) {
                            System.out.println(arrayNode);
                        }
                        differences.put(fieldName, value1);
                        continue;
                    }
                    Object diffValue = this.getValueFromJsonNode(value1);
                    differences.put(fieldName, diffValue);
                    continue;
                }
                differences.put(fieldName, value1);
            }
        }
        return differences;
    }

    private Object getValueFromJsonNode(JsonNode node) {
        Object diffValue = JsonNodeType.STRING.equals((Object)node.getNodeType()) ? node.asText() : (JsonNodeType.BOOLEAN.equals((Object)node.getNodeType()) ? (Comparable<Boolean>)Boolean.valueOf(node.asBoolean()) : (Comparable<Boolean>)(JsonNodeType.NUMBER.equals((Object)node.getNodeType()) ? Double.valueOf(node.asDouble()) : node));
        return diffValue;
    }
}

