/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.aspect;

import com.viztrend.safe.utils.PropertyValidator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class PerformceAspect {
    private static String[] skipItem = new String[]{"processWebhook", "PeerPushController.push", "getReplicaState", "ActiveNodeRepository", "ConfigRepository", "AppInitConfigRepository"};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"perf");

    @Around(value="execution( * com.viztrend.safe.controller.*.*(..)) || execution( * com.viztrend.safe.service.*.*(..)) || execution( * com.viztrend.safe.persistence.repository.*.*(..))")
    public Object after(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        String className = null;
        className = AopUtils.isJdkDynamicProxy((Object)pjp.getTarget()) ? String.valueOf(pjp.getTarget().getClass().getInterfaces()[0]) : method.getDeclaringClass().getCanonicalName();
        String methodName = method.getName();
        if (!(PropertyValidator.isValid((Object[])method.getAnnotations()) && method.getAnnotations()[0].toString().contains("@org.springframework.scheduling.annotation.Scheduled") || this.skip(methodName) || this.skip(className))) {
            long startTime = System.currentTimeMillis();
            try {
                Object obj;
                Object object = obj = pjp.proceed();
                return object;
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                LOGGER.info("Method :" + className + "." + methodName + ": execution lasted (seconds):" + (float)(System.currentTimeMillis() - startTime) / 1000.0f);
            }
        }
        return pjp.proceed();
    }

    private boolean skip(String value) {
        List<String> skipItemList = Arrays.asList(skipItem);
        for (String skipVal : skipItemList) {
            if (!value.contains(skipVal)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.print("sadfd");
    }
}

