/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.aspect;

import com.mongodb.DBObject;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.Counters;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.Report;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.entity.dto.UserContextDTO;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.util.Collection;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class MongoAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoAspect.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private Environment env;
    private Date time;
    private boolean isDebug = false;

    @Before(value="(execution(* *.find*(..)) || execution(* *.remove*(..)) || execution(* *.update*(..)) || execution(* *.insert*(..)) ) && bean(mongoTemplate)")
    public void before(JoinPoint joinPoint) {
        this.time = new Date();
        if (joinPoint.toString().contains("MongoTemplate.insert") && UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getUserContextDTO() != null) {
            if (joinPoint.getArgs()[0] instanceof Item) {
                Item item = (Item)joinPoint.getArgs()[0];
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                String forCollection = tenant + ':' + item.getType();
                String generatedId = this.getNextSeq(forCollection);
                item.setGeneratedId(generatedId);
            } else if (joinPoint.getArgs()[0] instanceof Report) {
                Report report = (Report)joinPoint.getArgs()[0];
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                String forCollection = tenant + ":Report";
                String generatedId = this.getNextSeq(forCollection);
                report.setGeneratedId(generatedId);
                report.setUrlKey(generatedId);
            }
        } else if (joinPoint.getArgs()[0] instanceof Query) {
            Query query = (Query)joinPoint.getArgs()[0];
            DBObject fields = query.getQueryObject();
            if (fields != null && !fields.containsField("archive")) {
                query.addCriteria((CriteriaDefinition)Criteria.where((String)"archive").ne((Object)true));
            }
            if (!(query.toString().contains("\"tenant\" :") || "class com.viztrend.safe.persistence.entity.User".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.Config".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.AppInitConfig".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.BlackListUserDomain".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.VatCountry".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.UserApiKey".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.KendisStats".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.Questionnaire".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.Token".equals(joinPoint.getArgs()[1].toString()))) {
                if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().getUserContextDTO() != null) {
                    SecureUser secureUser = UserContextUtil.getUserContext();
                    String tenant = String.valueOf(secureUser.getUserContextDTO().getContextMap().get("tenant"));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                } else if (PropertyValidator.isValid((Object)UserContextDTO.getFromLocalThread()) && PropertyValidator.isValid(UserContextDTO.getFromLocalThread().get("apiKeyTenant"))) {
                    String tenant = String.valueOf(UserContextDTO.getFromLocalThread().get("apiKeyTenant"));
                    query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenant").is((Object)tenant));
                } else {
                    if (!(!joinPoint.toString().contains(".remove") || "class com.viztrend.safe.alm.jira.bo.JiraWebhookMappedData".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.alm.jira.bo.TFSWebhookMappedData".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.ActiveNode".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.SocketConnection".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.Invitation".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.UserApiKey".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.Notification".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.ServerCache".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.PushResponse".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.persistence.entity.ItemJiraDependency".equals(joinPoint.getArgs()[1].toString()) || "class com.viztrend.safe.change.stream.model.ChangeStreamOldState".equals(joinPoint.getArgs()[1].toString()) || "canvasNodes".equals(joinPoint.getArgs()[1].toString()) || "canvasLinks".equals(joinPoint.getArgs()[1].toString()))) {
                        String collectionName = "";
                        if (joinPoint.getArgs().length > 1) {
                            collectionName = joinPoint.getArgs()[1].toString();
                        }
                        LOGGER.error("cannot remove without context :" + collectionName);
                        throw new KendisException();
                    }
                    if (joinPoint.toString().contains(".updateMulti")) {
                        String collectionName = "";
                        if (joinPoint.getArgs().length > 1) {
                            collectionName = joinPoint.getArgs()[1].toString();
                        }
                        LOGGER.error("cannot multi update without context :" + collectionName);
                        throw new KendisException();
                    }
                }
                joinPoint.getArgs()[0] = query;
            }
        }
    }

    @After(value="(execution(* *.find*(..)) || execution(* *.remove*(..)) || execution(* *.update*(..)) || execution(* *.insert*(..)) ) && bean(mongoTemplate)")
    public void after(JoinPoint joinPoint) {
        if (this.isDebug) {
            Date currTime = new Date();
            LOGGER.info("**********************************************************************");
            Long diff = currTime.getTime() - this.time.getTime();
            LOGGER.info(String.valueOf(diff) + " mili seconds");
            LOGGER.info("**********************************************************************");
        }
    }

    @PostConstruct
    public void doLog() {
        this.isDebug = "DEBUG".equals(String.valueOf(this.env.getProperty("logging.level.org.springframework.data.mongodb.core.MongoTemplate")));
    }

    private String getNextSeq(String seqCol) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)seqCol));
        if (!PropertyValidator.isValid((Collection)this.mongoTemplate.find(query, Counters.class))) {
            Counters counters = new Counters();
            counters.setId(seqCol);
            counters.setSeq(1);
            this.mongoTemplate.insert((Object)counters);
        }
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"id").is((Object)seqCol));
        Update update = new Update();
        update.inc("seq", (Number)1);
        Counters savedCounters = (Counters)this.mongoTemplate.findAndModify(q, update, Counters.class);
        return String.valueOf(savedCounters.getSeq());
    }
}

