/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.aspect;

import com.viztrend.safe.utils.StringUtils;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AfterThrowingAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfterThrowingAspect.class);

    @AfterThrowing(pointcut="execution( * com.viztrend.safe.controller.*.*(..)) || execution( * com.viztrend.safe.service.*.*(..))", throwing="ex")
    public void logAfterThrowingExceptionCall(Exception ex) throws Throwable {
        LOGGER.error(StringUtils.getTraceString((Throwable)ex));
    }
}

