/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.viztrend.safe.alm.jira.bo.JiraAccount;
import com.viztrend.safe.alm.jira.bo.JiraChangelog;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkPayload;
import com.viztrend.safe.alm.jira.bo.JiraItem;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.utils.PropertyValidator;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Transient;

public class JiraWebhookPayload
implements Serializable {
    private static final long serialVersionUID = -2301845629481851919L;
    private String webhookEvent;
    private String issue_event_type_name;
    private JiraIssue2 issue;
    private JiraSprint sprint;
    private JiraAccount user;
    private JiraIssueLinkPayload issueLink;
    private String timestamp;
    private JiraChangelog changelog;
    private Boolean systemLink;
    @Transient
    public Map<String, JiraIssue2> issuesMap = null;
    @Transient
    public Map<String, List<Item>> newItems = null;
    @Transient
    public String cid = null;
    @Transient
    public List<String> logs;
    @Transient
    public Boolean hasError;
    public Boolean epicLinkChangeEvent = null;
    @Transient
    public Boolean parentLinkChangeEvent = null;
    public JiraItem epicChangeLog = null;
    @Transient
    public JiraItem parentLinkChangeLog = null;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraWebhookPayload [");
        if (this.webhookEvent != null) {
            builder.append("webhookEvent=");
            builder.append(this.webhookEvent);
            builder.append(", ");
        }
        if (this.issue_event_type_name != null) {
            builder.append("issue_event_type_name=");
            builder.append(this.issue_event_type_name);
            builder.append(", ");
        }
        if (this.issueLink != null) {
            builder.append("issueLink=");
            builder.append(this.issueLink);
            builder.append(", ");
        }
        if (this.changelog != null) {
            builder.append("changelog=");
            builder.append(this.changelog);
            builder.append(", ");
        }
        if (this.issue != null) {
            builder.append("issue=");
            builder.append(this.issue);
            builder.append(", ");
        }
        if (this.user != null) {
            builder.append("user=");
            builder.append(this.user);
            builder.append(", ");
        }
        if (this.timestamp != null) {
            builder.append("timestamp=");
            builder.append(this.timestamp);
            builder.append(", ");
        }
        if (this.systemLink != null) {
            builder.append("systemLink=");
            builder.append(this.systemLink);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getWebhookEvent() {
        return this.webhookEvent;
    }

    public void setWebhookEvent(String webhookEvent) {
        this.webhookEvent = webhookEvent;
    }

    public String getIssue_event_type_name() {
        return this.issue_event_type_name;
    }

    public void setIssue_event_type_name(String issue_event_type_name) {
        this.issue_event_type_name = issue_event_type_name;
    }

    public JiraIssue2 getIssue() {
        return this.issue;
    }

    public void setIssue(JiraIssue2 issue) {
        this.issue = issue;
    }

    public JiraAccount getUser() {
        return this.user;
    }

    public JiraChangelog getChangelog() {
        return this.changelog;
    }

    public void setChangelog(JiraChangelog changelog) {
        this.changelog = changelog;
    }

    public void setUser(JiraAccount user) {
        this.user = user;
    }

    public JiraIssueLinkPayload getIssueLink() {
        return this.issueLink;
    }

    public void setIssueLink(JiraIssueLinkPayload issueLink) {
        this.issueLink = issueLink;
    }

    public Boolean getSystemLink() {
        return this.systemLink;
    }

    public void setSystemLink(Boolean systemLink) {
        this.systemLink = systemLink;
    }

    public JiraSprint getSprint() {
        return this.sprint;
    }

    public void setSprint(JiraSprint sprint) {
        this.sprint = sprint;
    }

    public void putIssue(JiraIssue2 issue) {
        if (issue != null) {
            this.issuesMap.put(issue.getId(), issue);
            this.issuesMap.put(issue.getKey(), issue);
        }
    }

    public boolean checkEvent() {
        return "jira:issue_updated".equals(this.webhookEvent) || "jira:issue_deleted".equals(this.webhookEvent) || "issuelink_created".equals(this.webhookEvent) || "issuelink_deleted".equals(this.webhookEvent) || "sprint_started".equals(this.webhookEvent) || "sprint_closed".equals(this.webhookEvent) || this.anyParentChildLinkOnCreation();
    }

    public boolean anyParentChildLinkOnCreation() {
        JiraItem changeLogItem;
        if ("jira:issue_created".equals(this.webhookEvent) && this.changelog != null && PropertyValidator.isValid((Collection)this.changelog.getItems()) && PropertyValidator.isValid((Object)(changeLogItem = (JiraItem)this.changelog.getItems().get(0))) && "IssueParentAssociation".equals(changeLogItem.getField())) {
            this.epicLinkChangeEvent = true;
            this.epicChangeLog = changeLogItem;
        }
        return Boolean.TRUE.equals(this.epicLinkChangeEvent);
    }

    public void logActivity(String log) {
        if (this.logs != null) {
            this.logs.add(log);
        }
    }

    public void logError(String log) {
        if (log != null) {
            this.logActivity(log);
        }
        this.hasError = true;
    }
}

