/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.viztrend.safe.alm.entity.BaseALMEntity;
import com.viztrend.safe.alm.jira.bo.JiraWebhookPayload;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class JiraWebhookMappedData
extends BaseALMEntity
implements Serializable {
    private static final long serialVersionUID = 2387411128053995159L;
    private String id;
    private String almAccountId;
    private List<AlmConfigurations> almConfigurations;
    private JiraWebhookPayload jiraWebhookPayload;
    private String jiraWebhookPayloadStr;
    private String jiraWebhookEvent;
    private String jiraSourceIssueId;
    private String jiraDestinationIssueId;
    private String tenantId;
    private Boolean isProcessed = false;
    private Boolean hasError = false;
    private String errorDescription;
    private String kendisAccountId;
    private String awsS3key = null;
    private Long sequence;
    private Date createdOn;
    @Transient
    private AlmAccount almAccount;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAlmAccountId() {
        return this.almAccountId;
    }

    public void setAlmAccountId(String almAccountId) {
        this.almAccountId = almAccountId;
    }

    public JiraWebhookPayload getJiraWebhookPayload() {
        return this.jiraWebhookPayload;
    }

    public void setJiraWebhookPayload(JiraWebhookPayload jiraWebhookPayload) {
        this.jiraWebhookPayload = jiraWebhookPayload;
    }

    public List<AlmConfigurations> getAlmConfigurations() {
        return this.almConfigurations;
    }

    public void setAlmConfigurations(List<AlmConfigurations> almConfigurations) {
        this.almConfigurations = almConfigurations;
    }

    public Boolean getIsProcessed() {
        return this.isProcessed;
    }

    public void setIsProcessed(Boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public Boolean getHasError() {
        return this.hasError;
    }

    public void setHasError(Boolean hasError) {
        this.hasError = hasError;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getKendisAccountId() {
        return this.kendisAccountId;
    }

    public void setKendisAccountId(String kendisAccountId) {
        this.kendisAccountId = kendisAccountId;
    }

    public String getAwsS3key() {
        return this.awsS3key;
    }

    public void setAwsS3key(String awsS3key) {
        this.awsS3key = awsS3key;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public void fillInfo(String almAccountId, String tenant, String json) {
        this.setAlmAccountId(almAccountId);
        this.setJiraWebhookPayloadStr(json);
        this.setJiraWebhookEvent(this.jiraWebhookPayload.getWebhookEvent());
        this.setTenant(tenant);
        this.setTenantId(tenant);
        if (this.jiraWebhookPayload.getIssue() != null) {
            this.setJiraId(this.jiraWebhookPayload.getIssue().getId());
        }
        if (this.jiraWebhookPayload.getIssueLink() != null) {
            this.setJiraSourceIssueId(this.jiraWebhookPayload.getIssueLink().getSourceIssueId());
            this.setJiraDestinationIssueId(this.jiraWebhookPayload.getIssueLink().getDestinationIssueId());
        }
        this.setSequence(new Long(System.nanoTime()));
        this.setCreatedOn(new Date());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraWebhookMappedData [");
        if (this.sequence != null) {
            builder.append("sequence=");
            builder.append(this.sequence);
            builder.append(", ");
        }
        if (this.almAccountId != null) {
            builder.append("almAccountId=");
            builder.append(this.almAccountId);
            builder.append(", ");
        }
        if (this.hasError != null) {
            builder.append("hasError=");
            builder.append(this.hasError);
            builder.append(", ");
        }
        if (this.errorDescription != null) {
            builder.append("errorDescription=");
            builder.append(this.errorDescription);
            builder.append(", ");
        }
        if (this.jiraWebhookPayload != null) {
            builder.append("jiraWebhookPayload=");
            builder.append(this.jiraWebhookPayload);
            builder.append(", ");
        }
        if (this.almConfigurations != null) {
            builder.append("almConfigurations=");
            builder.append(this.almConfigurations);
            builder.append(", ");
        }
        if (this.isProcessed != null) {
            builder.append("isProcessed=");
            builder.append(this.isProcessed);
            builder.append(", ");
        }
        if (this.kendisAccountId != null) {
            builder.append("kendisAccountId=");
            builder.append(this.kendisAccountId);
            builder.append(", ");
        }
        if (this.awsS3key != null) {
            builder.append("awsS3key=");
            builder.append(this.awsS3key);
        }
        builder.append("]");
        return builder.toString();
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getJiraWebhookPayloadStr() {
        return this.jiraWebhookPayloadStr;
    }

    public void setJiraWebhookPayloadStr(String jiraWebhookPayloadStr) {
        this.jiraWebhookPayloadStr = jiraWebhookPayloadStr;
    }

    public String getJiraWebhookEvent() {
        return this.jiraWebhookEvent;
    }

    public void setJiraWebhookEvent(String jiraWebhookEvent) {
        this.jiraWebhookEvent = jiraWebhookEvent;
    }

    public String getJiraSourceIssueId() {
        return this.jiraSourceIssueId;
    }

    public void setJiraSourceIssueId(String jiraSourceIssueId) {
        this.jiraSourceIssueId = jiraSourceIssueId;
    }

    public String getJiraDestinationIssueId() {
        return this.jiraDestinationIssueId;
    }

    public void setJiraDestinationIssueId(String jiraDestinationIssueId) {
        this.jiraDestinationIssueId = jiraDestinationIssueId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public AlmAccount getAlmAccount() {
        return this.almAccount;
    }

    public void setAlmAccount(AlmAccount almAccount) {
        this.almAccount = almAccount;
    }
}

