/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.google.gson.Gson;
import com.viztrend.safe.alm.jira.bo.JiraField;
import com.viztrend.safe.alm.jira.bo.JiraIssue;
import com.viztrend.safe.alm.jira.bo.JiraIssue2;
import com.viztrend.safe.alm.jira.bo.JiraIssueFields;
import com.viztrend.safe.alm.jira.bo.JiraIssueLink;
import com.viztrend.safe.alm.jira.bo.JiraIssueType;
import com.viztrend.safe.alm.jira.bo.JiraProject;
import com.viztrend.safe.alm.jira.bo.JiraStatus;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.BacklogItem;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.repository.CustomRepositoryImpl;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.annotation.Transient;

public class JiraIssue2
implements Serializable {
    private static final long serialVersionUID = -4018559456626863860L;
    private String expand;
    private String id;
    private String self;
    private String key;
    private HashMap<String, Object> fields;
    private String jiraParentId;
    private String jiraFilterId;
    private String itemTypeTobeConvertedInto;
    @Transient
    private String generatedKendisId;
    @Transient
    private Collection<JiraIssueLink> issuelinks;
    @Transient
    private JiraProject project;
    @Transient
    private JiraStatus status;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraIssue2)) {
            return false;
        }
        JiraIssue2 other = (JiraIssue2)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public JiraIssue2(String key) {
        this.key = key;
    }

    public JiraIssue2(String id, String key, String self) {
        this.id = id;
        this.key = key;
        this.self = self;
    }

    public JiraIssue2() {
    }

    public JiraIssue2(JiraIssue issue) {
        this.id = issue.getJiraId();
        this.key = issue.getKey();
        this.self = issue.getSelf();
        this.expand = issue.getExpand();
        this.fields = issue.getMapFields();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> issue = new HashMap<String, Object>();
        issue.put("id", this.id);
        issue.put("jiraId", this.id);
        issue.put("key", this.key);
        issue.put("jiraKey", this.key);
        issue.put("self", this.self);
        issue.put("fields", this.fields);
        return issue;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public HashMap<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(HashMap<String, Object> fields) {
        this.fields = fields;
    }

    public BacklogItem fillBackLogItem(String cid, BacklogItem baseItem, List<JiraField> fields, AlmAccount alm, User user, CustomRepositoryImpl customRepositoryImpl) {
        if (baseItem == null) {
            baseItem = new BacklogItem(this.getGeneratedKendisId(), user);
            baseItem.setFetchedBy(user);
            baseItem.setTenant(alm.getTenant());
            baseItem.setFilterIds(new HashSet());
        } else {
            this.setGeneratedKendisId(baseItem.getId());
        }
        baseItem.setAlmItemId(this.getId());
        baseItem.setAlmAccountId(alm.getId());
        baseItem.setTitle((String)this.getFields().get(JiraField.FIXED.summary.name()));
        baseItem.setKey(this.getKey());
        baseItem.setAlmKey(this.getKey());
        Double points = 0.0;
        boolean est = false;
        if (baseItem.getFields() == null) {
            baseItem.setFields(new HashMap());
        }
        if (baseItem.getAlmFields() == null) {
            baseItem.setAlmFields(new HashMap());
        }
        if (alm.getDueDateField() != null && alm.getDueDateField().getId() != null && this.fields.containsKey(alm.getDueDateField().getId())) {
            baseItem.getFields().put("DueDate", this.fields.get(alm.getDueDateField().getId()));
        }
        if (alm.getStartDateField() != null && alm.getStartDateField().getId() != null && this.fields.containsKey(alm.getStartDateField().getId()) && PropertyValidator.isValid(this.fields.get(alm.getStartDateField().getId()))) {
            baseItem.getFields().put("StartDate", PropertyValidator.parseDate((String)this.fields.get(alm.getStartDateField().getId()).toString(), (String)"yyyy-MM-dd"));
        }
        if (alm.getEndDateField() != null && alm.getEndDateField().getId() != null && this.fields.containsKey(alm.getEndDateField().getId()) && PropertyValidator.isValid(this.fields.get(alm.getEndDateField().getId()))) {
            baseItem.getFields().put("EndDate", PropertyValidator.parseDate((String)this.fields.get(alm.getEndDateField().getId()).toString(), (String)"yyyy-MM-dd"));
        }
        if (alm.getStoryPointField() != null && alm.getStoryPointField().getId() != null && this.fields.containsKey(alm.getStoryPointField().getId())) {
            points = (Double)this.fields.get(alm.getStoryPointField().getId());
            est = true;
        }
        if (points == null && alm.getNextGenStoryPointField() != null && alm.getNextGenStoryPointField().getId() != null && this.fields.containsKey(alm.getNextGenStoryPointField().getId())) {
            points = (Double)this.fields.get(alm.getNextGenStoryPointField().getId());
            est = true;
        }
        if (est && points != null) {
            baseItem.setStoryPoints(Double.valueOf(StringUtils.round((double)points, (int)2)));
        }
        if (this.getSelf() != null) {
            baseItem.setUrl(this.getSelf().split("/rest")[0] + "/browse/" + this.getKey());
        }
        if (fields != null) {
            for (JiraField field : fields) {
                if (field == null || field.getId() == null) continue;
                baseItem.getAlmFields().put(field.getJiraId(), this.fields.get(field.getJiraId()));
            }
        }
        baseItem.getFields().remove("AlmSyncError");
        baseItem.getFields().remove("AlmErrorMessage");
        return baseItem;
    }

    public Item getItemFromJiraIssue(Map<String, Object> fields, Set<ItemJiraFieldMap> extraFields, AlmAccount almAccount) {
        Item item = new Item();
        item.fillFromJira(this.id, this.key, this.self, this.itemTypeTobeConvertedInto, this.jiraFilterId, almAccount);
        item.fillFromJira(null, (Map)this.fields, fields);
        if (PropertyValidator.isValid(extraFields)) {
            item.putCustomeFieldValues((Map)this.fields, extraFields, false);
        }
        return item;
    }

    public JiraIssue getConvertedJiraIssue() {
        JiraIssue jiraIssue = new JiraIssue();
        jiraIssue.setKey(this.getKey());
        jiraIssue.setSelf(this.getSelf());
        jiraIssue.setMapFields(this.getFields());
        jiraIssue.setExpand(this.getExpand());
        jiraIssue.setJiraId(this.getId());
        Gson g = new Gson();
        JiraProject project = (JiraProject)g.fromJson(g.toJson(this.getFields().get(JiraField.FIXED.project.name())), JiraProject.class);
        JiraIssueFields jiraFields = new JiraIssueFields();
        jiraFields.setSummary((String)this.getFields().get(JiraField.FIXED.summary.name()));
        jiraFields.setProject(project);
        jiraFields.setStatus((JiraStatus)g.fromJson(g.toJson(this.getFields().get(JiraField.FIXED.status.name())), JiraStatus.class));
        jiraFields.setIssuetype((JiraIssueType)g.fromJson(g.toJson(this.getFields().get(JiraField.FIXED.issuetype.name())), JiraIssueType.class));
        1 P = new /* Unavailable Anonymous Inner Class!! */;
        Collection issueLinks = (Collection)g.fromJson(g.toJson(this.getFields().get(JiraField.FIXED.issuelinks.name())), P.getType());
        if (PropertyValidator.isValid((Collection)issueLinks)) {
            jiraFields.setIssuelinks(new ArrayList(issueLinks));
        }
        2 V = new /* Unavailable Anonymous Inner Class!! */;
        Collection versions = (Collection)g.fromJson(g.toJson(this.getFields().get(JiraField.FIXED.fixVersions.name())), V.getType());
        if (PropertyValidator.isValid((Collection)versions)) {
            jiraFields.setVersions(new ArrayList(versions));
        }
        jiraIssue.setFields(jiraFields);
        return jiraIssue;
    }

    public Collection<Map<String, Object>> issuelinks() {
        if (this.fields != null) {
            return (Collection)this.fields.get(JiraField.FIXED.issuelinks.name());
        }
        return null;
    }

    public String statusCategory(String property) {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.status.name());
            if (map != null) {
                if ((map = (Map)map.get("statusCategory")) != null && PropertyValidator.isValid(map.get(property))) {
                    return String.valueOf(map.get(property));
                }
                return "";
            }
            return "";
        }
        return "";
    }

    public String statusId() {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.status.name());
            if (map != null) {
                return (String)map.get("id");
            }
            return "";
        }
        return "";
    }

    public String status() {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.status.name());
            if (map != null) {
                return (String)map.get("name");
            }
            return "";
        }
        return "";
    }

    public String project(String key) {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.project.name());
            if (map != null) {
                return (String)map.get(key);
            }
            return "";
        }
        return "";
    }

    public String projectKey() {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.project.name());
            if (map != null) {
                return (String)map.get("key");
            }
            return "";
        }
        return "";
    }

    public String issueTypeId() {
        if (this.fields != null) {
            Map map = (Map)this.fields.get(JiraField.FIXED.issuetype.name());
            if (map != null) {
                return (String)map.get("id");
            }
            return "";
        }
        return "";
    }

    public void setProject(JiraProject project) {
        this.project = project;
    }

    public void setIssuelinks(Collection<JiraIssueLink> issuelinks) {
        this.issuelinks = issuelinks;
    }

    public String getJiraParentId() {
        return this.jiraParentId;
    }

    public void setJiraParentId(String jiraParentId) {
        this.jiraParentId = jiraParentId;
    }

    public String getJiraFilterId() {
        return this.jiraFilterId;
    }

    public void setJiraFilterId(String jiraFilterId) {
        this.jiraFilterId = jiraFilterId;
    }

    public String getGeneratedKendisId() {
        return this.generatedKendisId;
    }

    public void setGeneratedKendisId(String generatedKendisId) {
        this.generatedKendisId = generatedKendisId;
    }

    public String getItemTypeTobeConvertedInto() {
        return this.itemTypeTobeConvertedInto;
    }

    public void setItemTypeTobeConvertedInto(String itemTypeTobeConvertedInto) {
        this.itemTypeTobeConvertedInto = itemTypeTobeConvertedInto;
    }
}

