/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira.bo;

import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.entity.BaseALMEntity;
import com.viztrend.safe.alm.jira.bo.JiraIssueFields;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.Status;
import com.viztrend.safe.utils.AlmUtils;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.Transient;

public class JiraIssue
extends BaseALMEntity
implements Serializable {
    private static final long serialVersionUID = -2348623100377838878L;
    private String expand;
    private String self;
    private String key;
    private JiraIssueFields fields;
    private HashMap<String, Object> mapFields;
    private Boolean convertedToItem = Boolean.FALSE;
    private String itemTypeTobeConvertedInto;
    private String jiraParentId;
    private String jiraFilterId;
    private Boolean isEnabler = Boolean.FALSE;
    private String sessionBoardId;
    private String solutionBoardId;
    @Transient
    private ViztrendJiraException error;
    private String versionId;
    private String roadmapId;
    private String roadmapItemId;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JiraIssue other = (JiraIssue)obj;
        return this.getKey() == null || other.getKey() == null || this.getKey().trim().equalsIgnoreCase(other.getKey().trim());
    }

    public Item getItemFromJiraIssue(Map<String, Object> fields, Set<ItemJiraFieldMap> extraFields, AlmAccount almAccount) {
        Item item = new Item();
        item.fillFromJira(this.jiraId, this.key, this.self, this.itemTypeTobeConvertedInto, this.jiraFilterId, almAccount);
        item.fillFromJira(this.fields, (Map)this.mapFields, fields);
        if (PropertyValidator.isValid(extraFields)) {
            item.putCustomeFieldValues((Map)this.mapFields, extraFields, false);
        }
        return item;
    }

    public Status getItemStatus(Item item, Map<String, Status> statusMap, List<Status> newStatuses) {
        String statusKey = "";
        if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
            statusKey = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
        } else if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
            statusKey = item.getSolutionBoard().getId();
        }
        statusKey = statusKey + "_" + item.getType() + "_" + this.getFields().getIssuetype().getId() + "_" + this.getFields().getStatus().getId() + "_" + this.getFields().getProject().getKey();
        Status status = statusMap.get(statusKey);
        if (status == null) {
            status = new Status();
            status.setId(String.valueOf(ObjectId.get()));
            status.setSuspendActivity(true);
            status.setCreatedOn(new Date());
            status.setUpdatedOn(status.getCreatedOn());
            status.setJiraProjKey(this.getFields().getProject().getKey());
            status.setJiraIssueTypeId(this.getFields().getIssuetype().getId());
            status.setJiraStatusCatId(this.getFields().getStatus().getStatusCategory().getId().replace(".0", ""));
            status.setJiraStatusId(this.getFields().getStatus().getId());
            status.setTitle(this.getFields().getStatus().getName());
            status.setItemType(item.getType());
            status.setCategory(AlmUtils.getMappedStatusCategory((String)this.getFields().getStatus().getStatusCategory().getKey()));
            status.setSyncRequired(Boolean.valueOf(true));
            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && PropertyValidator.isValid((Object)UserContextUtil.getUserContext().getLoggedInUser())) {
                status.setCreatedBy(UserContextUtil.getUserContext().getLoggedInUser().getUserName());
                status.setUpdatedBy(status.getCreatedBy());
            }
            statusKey = "";
            if (PropertyValidator.isValid((Collection)item.getSessionBoards())) {
                statusKey = ((SessionBoard)item.getSessionBoards().get(0)).getSession().getId();
                status.setSessionId(((SessionBoard)item.getSessionBoards().get(0)).getSession().getId());
            } else if (PropertyValidator.isValid((Object)item.getSolutionBoard())) {
                statusKey = item.getSolutionBoard().getId();
                status.setSolutionId(item.getSolutionBoard().getId());
            }
            statusKey = statusKey + "_" + item.getType() + "_" + this.getFields().getIssuetype().getId() + "_" + this.getFields().getStatus().getId() + "_" + this.getFields().getProject().getKey();
            statusMap.put(statusKey, status);
            newStatuses.add(status);
        }
        return status;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public JiraIssueFields getFields() {
        return this.fields;
    }

    public void setFields(JiraIssueFields fields) {
        this.fields = fields;
    }

    public HashMap<String, Object> getMapFields() {
        return this.mapFields;
    }

    public void setMapFields(HashMap<String, Object> mapFields) {
        this.mapFields = mapFields;
    }

    public Boolean getConvertedToItem() {
        return this.convertedToItem;
    }

    public void setConvertedToItem(Boolean convertedToItem) {
        this.convertedToItem = convertedToItem;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JiraIssue [");
        if (this.key != null) {
            builder.append("key=");
            builder.append(this.key);
            builder.append(", ");
        }
        if (this.convertedToItem != null) {
            builder.append("convertedToItem=");
            builder.append(this.convertedToItem);
            builder.append(", ");
        }
        if (this.mapFields != null) {
            builder.append("mapFields=");
            builder.append(this.mapFields);
            builder.append(", ");
        }
        if (this.self != null) {
            builder.append("self=");
            builder.append(this.self);
        }
        builder.append("]");
        return builder.toString();
    }

    public String getItemTypeTobeConvertedInto() {
        return this.itemTypeTobeConvertedInto;
    }

    public void setItemTypeTobeConvertedInto(String itemTypeTbeConvertedInto) {
        this.itemTypeTobeConvertedInto = itemTypeTbeConvertedInto;
    }

    public String getJiraParentId() {
        return this.jiraParentId;
    }

    public void setJiraParentId(String jiraParentId) {
        this.jiraParentId = jiraParentId;
    }

    public Boolean getIsEnabler() {
        return this.isEnabler;
    }

    public void setIsEnabler(Boolean isEnabler) {
        this.isEnabler = isEnabler;
    }

    public String getSessionBoardId() {
        return this.sessionBoardId;
    }

    public void setSessionBoardId(String sessionBoardId) {
        this.sessionBoardId = sessionBoardId;
    }

    public String getJiraFilterId() {
        return this.jiraFilterId;
    }

    public void setJiraFilterId(String jiraFilterId) {
        this.jiraFilterId = jiraFilterId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getRoadmapId() {
        return this.roadmapId;
    }

    public void setRoadmapId(String roadmapId) {
        this.roadmapId = roadmapId;
    }

    public String getRoadmapItemId() {
        return this.roadmapItemId;
    }

    public void setRoadmapItemId(String roadmapItemId) {
        this.roadmapItemId = roadmapItemId;
    }

    public String getSolutionBoardId() {
        return this.solutionBoardId;
    }

    public void setSolutionBoardId(String solutionBoardId) {
        this.solutionBoardId = solutionBoardId;
    }

    public ViztrendJiraException getError() {
        return this.error;
    }

    public void setError(ViztrendJiraException error) {
        this.error = error;
    }
}

