/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InternetDomainName;
import com.google.gson.Gson;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.ExportUtil;
import com.viztrend.safe.alm.jira.TFSResponse;
import com.viztrend.safe.alm.jira.TFSUtils;
import com.viztrend.safe.alm.tfs.TFSTeamMapping;
import com.viztrend.safe.init.TFSOauth2Filter;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.AuditLog;
import com.viztrend.safe.persistence.entity.AzureOAuthToken;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.ServerCache;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ServerCacheRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.UserContextUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.ReadablePartial;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TFSUtils {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    AlmAccountRepository almAccountRepository;
    @Autowired
    ServerCacheRepository serverCacheRepository;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportUtil.class);
    private String apiVerson = "api-version=5.1";

    public String getBaseUrl() {
        return "https://dev.azure.com/sherazapi/";
    }

    public String getAlmAccountBaseUrl(AlmAccount account) {
        if (PropertyValidator.isValid((Object)account.getUrl())) {
            return account.getUrl();
        }
        return null;
    }

    private String getAccessToken(String userName, String pass, AzureOAuthToken oAuthToken) throws Exception {
        String authorization = "";
        if (PropertyValidator.isValid((Object)oAuthToken)) {
            String accessToken = oAuthToken.getAccessToken();
            authorization = "Bearer " + accessToken;
            LOGGER.debug("request by : " + authorization);
        } else {
            String refreshToken = null;
            if (!PropertyValidator.isValid(refreshToken)) {
                if (!PropertyValidator.isValid((Object)userName) && !PropertyValidator.isValid((Object)pass)) {
                    userName = "mw3anc23hprybpyfaefdhlorbfjv4vj2qlthcke75a6woenu544a";
                    pass = "Loxvo123$-";
                }
                String encoding = "";
                try {
                    encoding = userName + ":" + EncDecUtility.decrypt((String)pass);
                }
                catch (Exception exception) {
                    encoding = userName + ":" + pass;
                }
                LOGGER.debug("request by : Basic " + new String(Base64.encode((byte[])encoding.getBytes())));
                return "Basic " + new String(Base64.encode((byte[])encoding.getBytes()));
            }
            Map tfsTokenMap = TFSOauth2Filter.getAccessToken((String)"refresh_token", refreshToken);
            authorization = String.valueOf(tfsTokenMap.get("access_token"));
        }
        return authorization;
    }

    public TFSResponse authenticate(String url, String username, String password, AzureOAuthToken oAuthToken) {
        try {
            url = url + "/_apis/projects?$top=1";
            TFSResponse tfsResponse = TFSOauth2Filter.executeGetRequest((String)url, (String)this.getAccessToken(username, password, oAuthToken));
            String response = tfsResponse.getContent();
            Integer status = tfsResponse.getStatusCode();
            return tfsResponse;
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public TFSResponse authenticateOAuthToken(AzureOAuthToken oAuthToken) {
        String url = "https://app.vssps.visualstudio.com/_apis/profile/profiles/me";
        try {
            return TFSOauth2Filter.executeGetRequest((String)url, (String)this.getAccessToken(null, null, oAuthToken));
        }
        catch (Exception ex) {
            LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            return null;
        }
    }

    public String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public User getProfileAlmUser(AlmAccount almAccount) {
        LOGGER.info("getProfileAlmUser -> Searching user using alm account: " + almAccount.getName());
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User user = (User)this.userRepository.findOne((Serializable)((Object)loggedInUser.getId()));
        loggedInUser.setAlmCredentials(user.getAlmCredentials());
        if (PropertyValidator.isValid((Collection)loggedInUser.getAlmCredentials())) {
            for (AlmAccUser userCreds : loggedInUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                LOGGER.info("getProfileAlmUser -> Alm account found in user profile, returning user.");
                return loggedInUser;
            }
        }
        LOGGER.info("getProfileAlmUser -> Could not find alm account in user profile for alm: " + almAccount.getName());
        return null;
    }

    public static AlmAccount getTaggedAlmUser(User taggedUser, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)taggedUser) && PropertyValidator.isValid((Collection)taggedUser.getAlmCredentials())) {
            LOGGER.info("getTaggedAlmUser -> Searching alm account from user profile for user: " + taggedUser.getUserName());
            for (AlmAccUser userCreds : taggedUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                LOGGER.info("getTaggedAlmUser -> successfully found alm account in user profile.");
                almAccount.setUsername(userCreds.getAlmUsername());
                almAccount.setPassword(userCreds.getAlmPassword());
                almAccount.setAzureOAuthToken(userCreds.getAzureOAuthToken());
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setAdminAlmAcc(Boolean.valueOf(false));
                almAccount.setOAuthTokenOwnerUserId(taggedUser.getId());
                return almAccount;
            }
        }
        LOGGER.info("getTaggedAlmUser -> Could not find alm account in user profile.");
        return null;
    }

    public static AlmAccount getTaggedAlmUserCopyAlm(User taggedUser, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)taggedUser) && PropertyValidator.isValid((Collection)taggedUser.getAlmCredentials())) {
            LOGGER.info("getTaggedAlmUserCopyAlm -> Searching alm account from user profile for user: " + taggedUser.getUserName() + " and creating copy of alm.");
            for (AlmAccUser userCreds : taggedUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                LOGGER.info("getTaggedAlmUserCopyAlm -> successfully found alm account in user profile.");
                AlmAccount almAccountCopy = new AlmAccount();
                almAccountCopy.setId(almAccount.getId());
                almAccountCopy.setUsername(userCreds.getAlmUsername());
                almAccountCopy.setPassword(userCreds.getAlmPassword());
                almAccountCopy.setAzureOAuthToken(userCreds.getAzureOAuthToken());
                almAccountCopy.setIsTaggedUser(Boolean.valueOf(true));
                almAccountCopy.setAdminAlmAcc(Boolean.valueOf(false));
                almAccountCopy.setOAuthTokenOwnerUserId(taggedUser.getId());
                return almAccountCopy;
            }
        }
        LOGGER.info("getTaggedAlmUserCopyAlm -> Could not find alm account in user profile.");
        return null;
    }

    public AlmAccUser getUserAlmCredntials(String almAccountId, User user) {
        if (PropertyValidator.isValid((Object)almAccountId) && PropertyValidator.isValid((Object)user) && PropertyValidator.isValid((Collection)user.getAlmCredentials())) {
            LOGGER.info("Finding user alm credentials for user: " + user.getUserName());
            user = (User)this.userRepository.findOne((Serializable)((Object)user.getId()));
            for (AlmAccUser userCreds : user.getAlmCredentials()) {
                if (!almAccountId.equals(userCreds.getAlmAccId())) continue;
                LOGGER.info("Successfully found user alm credentials for user: " + user.getUserName());
                return userCreds;
            }
        }
        LOGGER.info("Could not find user alm credentials for user: " + (PropertyValidator.isValid((Object)user) ? user.getUserName() : "null"));
        return null;
    }

    public TFSResponse createItemInTFS(String projectId, HashMap<String, Object> fields, AlmAccount almAccount) {
        String workItemType = (String)fields.get("itemType");
        if (PropertyValidator.isValid((Object)workItemType)) {
            try {
                String url = "/" + projectId + "/_apis/wit/workitems/$" + UriUtils.encode((String)workItemType, (String)"UTF-8");
                String requestBody = this.constructRequestBodyForTFS(fields);
                return this.patchRequest(url, requestBody, almAccount);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
            }
        }
        return null;
    }

    public TFSResponse createWebhookInTFS(AlmAccount almAccount, JSONObject requestBody) {
        String url = "/_apis/hooks/subscriptions?api-version=5.0";
        return this.postRequest(url, requestBody.toString(), almAccount);
    }

    public TFSResponse updateItemInTFS(String tfsItemId, HashMap<String, Object> fields, AlmAccount almAccount) throws RuntimeException {
        String url = "/_apis/wit/workitems/" + tfsItemId;
        String requestBody = this.constructRequestBodyForTFS(fields);
        return this.patchRequest(url, requestBody, almAccount);
    }

    public String getRequestWithCompleteUrl(String url, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)almAccount)) {
            TFSResponse tfsResponse;
            String exeUrl;
            String userInfo;
            boolean isTaggedUserAlm;
            block12: {
                AzureOAuthToken azureOAuthToken;
                String userName = null;
                String password = null;
                isTaggedUserAlm = false;
                userInfo = "";
                boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
                if (!almAccount.getIsTaggedUser().booleanValue() && PropertyValidator.isValid((Object)SecurityContextHolder.getContext().getAuthentication()) && PropertyValidator.isValid((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal()) && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                    userInfo = loggedInUser.getFullName();
                    AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
                    if (PropertyValidator.isValid((Object)almAccUser)) {
                        userName = almAccUser.getAlmUsername();
                        password = almAccUser.getAlmPassword();
                        azureOAuthToken = almAccUser.getAzureOAuthToken();
                        isTaggedUserAlm = true;
                        isAdminAlmAcc = false;
                    } else {
                        userName = almAccount.getUsername();
                        password = almAccount.getPassword();
                        azureOAuthToken = almAccount.getAzureOAuthToken();
                        isAdminAlmAcc = true;
                    }
                } else {
                    userInfo = "";
                    userName = almAccount.getUsername();
                    password = almAccount.getPassword();
                    azureOAuthToken = almAccount.getAzureOAuthToken();
                }
                exeUrl = url;
                LOGGER.debug("URL \t\t:: " + exeUrl);
                tfsResponse = null;
                try {
                    if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                        LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                        azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                        if (!isAdminAlmAcc) {
                            this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                        } else {
                            this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                        }
                    }
                    tfsResponse = TFSOauth2Filter.executeGetRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    if (!(e instanceof ViztrendJiraException)) break block12;
                    ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                    throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
                }
            }
            String response = null;
            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                LOGGER.debug(tfsResponse.toString());
            }
            if (tfsResponse.getStatusCode() != 200 && tfsResponse.getStatusCode() != 201) {
                LOGGER.error("Failed: executeTFSGETRequest " + tfsResponse.getStatusCode() + "\t\t" + url);
                AlmError almErr = new AlmError();
                almErr.setRequestJson(tfsResponse.getContent());
                almErr.setEndPoint(exeUrl);
                almErr.setUserName(userInfo);
                almErr.setIsTaggedUserAlm(Boolean.valueOf(isTaggedUserAlm));
                almErr.setHttpErrorCode(tfsResponse.getStatusCode());
                almErr.setErrorJson(tfsResponse.getContent());
                almErr.setReason(tfsResponse.getReason());
                throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
            }
            response = tfsResponse.getContent();
            return response;
        }
        return null;
    }

    public String getRequest(String url, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)almAccount)) {
            TFSResponse tfsResponse;
            String exeUrl;
            String userInfo;
            boolean isTaggedUserAlm;
            block12: {
                AzureOAuthToken azureOAuthToken;
                String userName = null;
                String password = null;
                isTaggedUserAlm = false;
                userInfo = "";
                boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
                if (!almAccount.getIsTaggedUser().booleanValue() && PropertyValidator.isValid((Object)SecurityContextHolder.getContext().getAuthentication()) && PropertyValidator.isValid((Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal()) && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof SecureUser) {
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                    userInfo = loggedInUser.getFullName();
                    AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
                    if (PropertyValidator.isValid((Object)almAccUser)) {
                        userName = almAccUser.getAlmUsername();
                        password = almAccUser.getAlmPassword();
                        azureOAuthToken = almAccUser.getAzureOAuthToken();
                        isTaggedUserAlm = true;
                        isAdminAlmAcc = false;
                    } else {
                        userName = almAccount.getUsername();
                        password = almAccount.getPassword();
                        azureOAuthToken = almAccount.getAzureOAuthToken();
                        isAdminAlmAcc = true;
                    }
                } else {
                    userInfo = "";
                    userName = almAccount.getUsername();
                    password = almAccount.getPassword();
                    azureOAuthToken = almAccount.getAzureOAuthToken();
                }
                exeUrl = this.getAlmAccountBaseUrl(almAccount) + url;
                LOGGER.debug("URL \t\t:: " + exeUrl);
                tfsResponse = null;
                try {
                    if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                        LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                        azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                        if (!isAdminAlmAcc) {
                            this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                        } else {
                            this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                        }
                    }
                    tfsResponse = TFSOauth2Filter.executeGetRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken));
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    if (!(e instanceof ViztrendJiraException)) break block12;
                    ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                    throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
                }
            }
            String response = null;
            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                LOGGER.debug(tfsResponse.toString());
            }
            if (tfsResponse.getStatusCode() != 200 && tfsResponse.getStatusCode() != 201) {
                LOGGER.error("Failed: executeTFSGETRequest " + tfsResponse.getStatusCode() + "\t\t" + url);
                AlmError almErr = new AlmError();
                almErr.setRequestJson(tfsResponse.getContent());
                almErr.setEndPoint(exeUrl);
                almErr.setUserName(userInfo);
                almErr.setIsTaggedUserAlm(Boolean.valueOf(isTaggedUserAlm));
                almErr.setHttpErrorCode(tfsResponse.getStatusCode());
                almErr.setErrorJson(tfsResponse.getContent());
                almErr.setReason(tfsResponse.getReason());
                throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
            }
            response = tfsResponse.getContent();
            return response;
        }
        return null;
    }

    public TFSResponse patchRequest(String url, String body, AlmAccount almAccount) {
        TFSResponse tfsResponse;
        String exeUrl;
        boolean isTaggedUserAlm;
        String userInfo;
        block11: {
            AzureOAuthToken azureOAuthToken;
            String apiVersion = url.contains("?") ? "&" + this.apiVerson : "?" + this.apiVerson;
            userInfo = "";
            String userName = null;
            String password = null;
            isTaggedUserAlm = false;
            boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
            if (!almAccount.getIsTaggedUser().booleanValue()) {
                SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                userInfo = loggedInUser.getFullName();
                AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
                if (PropertyValidator.isValid((Object)almAccUser)) {
                    userName = almAccUser.getAlmUsername();
                    password = almAccUser.getAlmPassword();
                    azureOAuthToken = almAccUser.getAzureOAuthToken();
                    isTaggedUserAlm = true;
                    isAdminAlmAcc = false;
                } else {
                    userName = almAccount.getUsername();
                    password = almAccount.getPassword();
                    azureOAuthToken = almAccount.getAzureOAuthToken();
                    isAdminAlmAcc = true;
                }
            } else {
                userName = almAccount.getUsername();
                password = almAccount.getPassword();
                azureOAuthToken = almAccount.getAzureOAuthToken();
            }
            exeUrl = this.getAlmAccountBaseUrl(almAccount) + url + apiVersion;
            tfsResponse = null;
            try {
                if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                    LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                    azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                    if (!isAdminAlmAcc) {
                        this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                    } else {
                        this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                    }
                }
                tfsResponse = TFSOauth2Filter.executePatchRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken), (String)body);
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                if (!(e instanceof ViztrendJiraException)) break block11;
                ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
            }
        }
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
            LOGGER.debug(tfsResponse.toString());
        }
        if (tfsResponse.getStatusCode() == 200 || tfsResponse.getStatusCode() == 201) {
            return tfsResponse;
        }
        LOGGER.error("Failed: executeTFSPatchRequestBasic " + tfsResponse.getStatusCode() + "\t\t" + url);
        AlmError almErr = new AlmError();
        almErr.setRequestJson(body);
        almErr.setEndPoint(exeUrl);
        almErr.setUserName(userInfo);
        almErr.setIsTaggedUserAlm(Boolean.valueOf(isTaggedUserAlm));
        almErr.setHttpErrorCode(tfsResponse.getStatusCode());
        almErr.setErrorJson(tfsResponse.getContent());
        almErr.setReason(tfsResponse.getReason());
        throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
    }

    public TFSResponse postRequestWithCompleteUrl(String url, String body, AlmAccount almAccount) {
        try {
            TFSResponse tfsResponse;
            boolean isTaggedUserAlm;
            String userInfo;
            block14: {
                String apiVersion = url.contains("?") ? "&" + this.apiVerson : "?" + this.apiVerson;
                userInfo = "";
                String userName = null;
                String password = null;
                AzureOAuthToken azureOAuthToken = almAccount.getAzureOAuthToken();
                isTaggedUserAlm = false;
                boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
                userName = almAccount.getUsername();
                password = almAccount.getPassword();
                if (!almAccount.getIsTaggedUser().booleanValue() && PropertyValidator.isValid((Object)SecurityContextHolder.getContext())) {
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                    userInfo = loggedInUser.getFullName();
                    AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
                    if (PropertyValidator.isValid((Object)almAccUser)) {
                        userName = almAccUser.getAlmUsername();
                        password = almAccUser.getAlmPassword();
                        azureOAuthToken = almAccUser.getAzureOAuthToken();
                        isTaggedUserAlm = true;
                        isAdminAlmAcc = false;
                    } else {
                        userName = almAccount.getUsername();
                        password = almAccount.getPassword();
                        isAdminAlmAcc = true;
                    }
                }
                String exeUrl = url;
                tfsResponse = null;
                try {
                    if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                        LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                        azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                        if (!isAdminAlmAcc) {
                            this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                        } else {
                            this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                        }
                    }
                    tfsResponse = TFSOauth2Filter.executePostRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken), (String)body);
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    if (!(e instanceof ViztrendJiraException)) break block14;
                    ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                    throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
                }
            }
            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                if (PropertyValidator.isValid((Object)tfsResponse)) {
                    LOGGER.debug(tfsResponse.toString());
                } else {
                    return tfsResponse;
                }
            }
            if (tfsResponse.getStatusCode() == 200 || tfsResponse.getStatusCode() == 201) {
                return tfsResponse;
            }
            LOGGER.error("Failed: executeTFSPatchRequestBasic " + tfsResponse.getStatusCode() + "\t\t" + url);
            AlmError almErr = new AlmError();
            almErr.setRequestJson(body);
            almErr.setEndPoint(url);
            almErr.setUserName(userInfo);
            almErr.setIsTaggedUserAlm(Boolean.valueOf(isTaggedUserAlm));
            almErr.setHttpErrorCode(tfsResponse.getStatusCode());
            almErr.setErrorJson(tfsResponse.toString());
            throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public TFSResponse postRequest(String url, String body, AlmAccount almAccount) {
        try {
            TFSResponse tfsResponse;
            boolean isTaggedUserAlm;
            String userInfo;
            block14: {
                String apiVersion = url.contains("?") ? "&" + this.apiVerson : "?" + this.apiVerson;
                userInfo = "";
                String userName = null;
                String password = null;
                AzureOAuthToken azureOAuthToken = almAccount.getAzureOAuthToken();
                isTaggedUserAlm = false;
                boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
                userName = almAccount.getUsername();
                password = almAccount.getPassword();
                if (!almAccount.getIsTaggedUser().booleanValue() && PropertyValidator.isValid((Object)SecurityContextHolder.getContext())) {
                    SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                    User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
                    userInfo = loggedInUser.getFullName();
                    AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
                    if (PropertyValidator.isValid((Object)almAccUser)) {
                        userName = almAccUser.getAlmUsername();
                        password = almAccUser.getAlmPassword();
                        azureOAuthToken = almAccUser.getAzureOAuthToken();
                        isTaggedUserAlm = true;
                        isAdminAlmAcc = false;
                    } else {
                        userName = almAccount.getUsername();
                        password = almAccount.getPassword();
                        isAdminAlmAcc = true;
                    }
                }
                String exeUrl = this.getAlmAccountBaseUrl(almAccount) + url + apiVersion;
                tfsResponse = null;
                try {
                    if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                        LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                        azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                        if (!isAdminAlmAcc) {
                            this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                        } else {
                            this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                        }
                    }
                    tfsResponse = TFSOauth2Filter.executePostRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken), (String)body);
                }
                catch (Exception e) {
                    LOGGER.error(StringUtils.getTraceString((Throwable)e));
                    if (!(e instanceof ViztrendJiraException)) break block14;
                    ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                    throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
                }
            }
            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                if (PropertyValidator.isValid((Object)tfsResponse)) {
                    LOGGER.debug(tfsResponse.toString());
                } else {
                    return tfsResponse;
                }
            }
            if (tfsResponse.getStatusCode() == 200 || tfsResponse.getStatusCode() == 201) {
                return tfsResponse;
            }
            LOGGER.error("Failed: executeTFSPatchRequestBasic " + tfsResponse.getStatusCode() + "\t\t" + url);
            AlmError almErr = new AlmError();
            almErr.setRequestJson(body);
            almErr.setEndPoint(url);
            almErr.setUserName(userInfo);
            almErr.setIsTaggedUserAlm(Boolean.valueOf(isTaggedUserAlm));
            almErr.setHttpErrorCode(tfsResponse.getStatusCode());
            almErr.setErrorJson(tfsResponse.toString());
            throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    private String constructRequestBodyForTFS(Map<String, Object> fieldsToSet) {
        block17: {
            try {
                JSONArray fields = new JSONArray();
                if (fieldsToSet == null || fieldsToSet.isEmpty()) break block17;
                for (String key : fieldsToSet.keySet()) {
                    JSONObject obj = new JSONObject();
                    obj.put("op", (Object)"add");
                    Object value = "";
                    JSONObject objValue = new JSONObject();
                    if ("relation".equals(key)) {
                        objValue = (JSONObject)fieldsToSet.get(key);
                        obj.put("value", (Object)objValue);
                    } else {
                        value = fieldsToSet.get(key);
                        obj.put("value", value);
                    }
                    if ("title".equals(key)) {
                        obj.put("path", (Object)"/fields/System.Title");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("targetDate".equals(key)) {
                        obj.put("path", (Object)"/fields/Microsoft.VSTS.Scheduling.TargetDate");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("state".equals(key)) {
                        obj.put("path", (Object)"/fields/System.State");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("itemType".equals(key)) {
                        obj.put("path", (Object)"/fields/System.WorkItemType");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("effort".equals(key)) {
                        obj.put("path", (Object)"/fields/Microsoft.VSTS.Scheduling.Effort");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("iterationPath".equals(key)) {
                        obj.put("path", (Object)"/fields/System.IterationPath");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("areaPath".equals(key)) {
                        obj.put("path", (Object)"/fields/System.AreaPath");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("teamProject".equals(key)) {
                        obj.put("path", (Object)"/fields/System.TeamProject");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("relation".equals(key)) {
                        obj.put("path", (Object)"/relations/-");
                        fields.put((Object)obj);
                        continue;
                    }
                    if ("relations".equals(key)) {
                        JSONArray jsonArray = (JSONArray)fieldsToSet.get("relations");
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject object = (JSONObject)jsonArray.get(i);
                            object.put("op", (Object)"add");
                            fields.put((Object)object);
                        }
                        continue;
                    }
                    if ("removeRelation".equals(key)) {
                        obj.put("op", (Object)"remove");
                        obj.put("path", (Object)("/relations/" + value));
                        obj.remove("value");
                        fields.put((Object)obj);
                        continue;
                    }
                    obj.put("path", (Object)("/fields/" + key));
                    obj.put("value", fieldsToSet.get(key));
                    fields.put((Object)obj);
                }
                return fields.toString();
            }
            catch (JSONException e) {
                LOGGER.error("constructRequestBodyForJira -->Caught JSONException", (Throwable)e);
            }
        }
        return null;
    }

    protected JSONObject getJsonObject(String fieldName, String value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getNullJsonObject(String fieldName) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, JSONObject.NULL);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, JSONObject value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, Double value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, Integer value) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)value);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    protected JSONObject getJsonObject(String fieldName, JSONArray values) {
        try {
            JSONObject tmpJson = new JSONObject();
            tmpJson.put(fieldName, (Object)values);
            return tmpJson;
        }
        catch (JSONException e) {
            LOGGER.warn("JSONException in getJsonObject.", (Throwable)e);
            return null;
        }
    }

    public String getTFSWebHooks(AlmAccount almAccount) throws ViztrendJiraException {
        return this.getRequest("/_apis/hooks/subscriptions", almAccount);
    }

    public TFSResponse getTFSProjectWebHooksForWorkItemsUpdated(JSONObject requestBody, AlmAccount almAccount) throws ViztrendJiraException {
        String url = "/_apis/hooks/subscriptionsquery";
        return this.postRequest(url, requestBody.toString(), almAccount);
    }

    public TFSResponse getTFSProjectWebHooksForWorkItemsDeleted(JSONObject requestBody, AlmAccount almAccount) throws ViztrendJiraException {
        String url = "/_apis/hooks/subscriptionsquery";
        return this.postRequest(url, requestBody.toString(), almAccount);
    }

    public String getTFSProjects(AlmAccount almAccount) {
        return this.getRequest("/_apis/projects", almAccount);
    }

    public String getTFSProject(String projectId, AlmAccount almAccount) throws ViztrendJiraException {
        return this.getRequest("/_apis/projects/" + projectId + "?includeCapabilities=true", almAccount);
    }

    public String getProjectProperties(String projectId, AlmAccount almAccount) {
        return this.getRequest("/_apis/projects/" + projectId + "/properties", almAccount);
    }

    public String getProjectItemTypes(String projectId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/workitemtypes", almAccount);
    }

    public String getProjectAllFields(String projectId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/fields", almAccount);
    }

    public String getAllFields(AlmAccount almAccount) {
        return this.getRequest("/_apis/wit/fields?api-version=6.1-preview.2", almAccount);
    }

    public String getProjectItemTypeFields(String projectId, String itemType, AlmAccount almAccount) {
        try {
            return this.getRequest("/" + projectId + "/_apis/wit/workitemtypes/" + UriUtils.encode((String)itemType, (String)"UTF-8") + "/fields?$expand=All", almAccount);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public String getTFSProcess(AlmAccount almAccount) {
        return this.getRequest("/_apis/work/processes?api-version=7.1-preview.2", almAccount);
    }

    public String getTFSProcessWorkItemTypes(AlmAccount almAccount, String processId) {
        return this.getRequest("/_apis/work/processes/" + processId + "/workitemtypes", almAccount);
    }

    public String getItemTypeStates(String projectId, String workItemType, AlmAccount almAccount) {
        try {
            return this.getRequest("/" + projectId + "/_apis/wit/workitemtypes/" + UriUtils.encode((String)workItemType, (String)"UTF-8") + "/states", almAccount);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public String getProcessItemTypeStates(String processId, String workItemType, AlmAccount almAccount) {
        try {
            return this.getRequest("/_apis/work/processes/" + processId + "/workItemTypes/" + UriUtils.encode((String)workItemType, (String)"UTF-8") + "/states", almAccount);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return null;
        }
    }

    public String getItemTypeFields(String projectId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/workitemtypes/Bug/fields", almAccount);
    }

    public String getItemTypeCategories(String projectId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/workitemtypecategories", almAccount);
    }

    public String getProjectQueries(String projectId, String expand, String depth, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/queries?$expand=" + expand + "&$depth=" + depth, almAccount);
    }

    public String getProjectQueriesWithFilter(String projectId, String filter, String expand, String depth, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/queries?$filter=" + filter + "&$expand=" + expand + "&$depth=" + depth, almAccount);
    }

    public String getNestedQueries(String url, AlmAccount almAccount) {
        return this.getRequest("/" + url + "?$expand=all&$depth=2", almAccount);
    }

    public String getWorkItemsByTFSQueryId(String projectId, String queryId, AlmAccount almAccount) throws ViztrendJiraException {
        return this.getRequest("/" + projectId + "/_apis/wit/wiql/" + queryId, almAccount);
    }

    public TFSResponse getWorkItemsByTFSQueryString(String query, AlmAccount almAccount, boolean timePrecision) throws ViztrendJiraException {
        if (timePrecision) {
            return this.postRequest("/_apis/wit/wiql?timePrecision=true", query, almAccount);
        }
        return this.postRequest("/_apis/wit/wiql", query, almAccount);
    }

    public TFSResponse getWorkItemsByTFSQueryStringWithProject(String projectId, String query, AlmAccount almAccount) throws ViztrendJiraException {
        return this.postRequest("/" + projectId + "/_apis/wit/wiql?timePrecision=true", query, almAccount);
    }

    public Object getRelationShipTypes(AlmAccount almAccount) {
        try {
            return this.getRequest("/_apis/wit/workitemrelationtypes", almAccount);
        }
        catch (ViztrendJiraException e) {
            return e;
        }
    }

    public String getProjectTeams(String projectId, AlmAccount almAccount) {
        return this.getRequest("/_apis/projects/" + projectId + "/teams", almAccount);
    }

    private JSONArray concatArray(JSONArray arr1, JSONArray arr2) throws JSONException {
        for (int i = 0; i < arr2.length(); ++i) {
            arr1.put(arr2.get(i));
        }
        return arr1;
    }

    public String getTFSProjectsByPage(AlmAccount almAccount) {
        String tfsProjectsStr = null;
        try {
            int startAt = 0;
            int pageSize = 100;
            int currentCount = 0;
            int totalCount = 0;
            boolean nextFetch = true;
            JSONArray tfsAllProjectsArray = new JSONArray();
            do {
                String responseProjectsStr = this.getRequest("/_apis/projects?$top=" + pageSize + "&$skip=" + startAt, almAccount);
                JSONObject resProjectObject = new JSONObject(responseProjectsStr);
                startAt += pageSize;
                currentCount = Integer.parseInt(resProjectObject.getString("count"));
                totalCount += currentCount;
                JSONArray projectArray = resProjectObject.getJSONArray("value");
                nextFetch = currentCount >= 100;
                this.concatArray(tfsAllProjectsArray, projectArray);
            } while (nextFetch);
            JSONObject projectsObject = new JSONObject();
            projectsObject.put("count", totalCount);
            projectsObject.put("value", (Object)tfsAllProjectsArray);
            tfsProjectsStr = projectsObject.toString();
        }
        catch (JSONException e1) {
            e1.printStackTrace();
            tfsProjectsStr = this.getRequest("/_apis/projects", almAccount);
        }
        catch (ViztrendJiraException e2) {
            throw e2;
        }
        return tfsProjectsStr;
    }

    public String getProjectTeamsByPage(String projectId, AlmAccount almAccount) {
        String tfsTeamsStr = null;
        try {
            int startAt = 0;
            int pageSize = 100;
            int currentCount = 0;
            int totalCount = 0;
            boolean nextFetch = true;
            JSONArray tfsAllTeamsArray = new JSONArray();
            do {
                String responseTeamsStr = this.getRequest("/_apis/projects/" + projectId + "/teams?$top=" + pageSize + "&$skip=" + startAt, almAccount);
                JSONObject resTeamObject = new JSONObject(responseTeamsStr);
                startAt += pageSize;
                currentCount = Integer.parseInt(resTeamObject.getString("count"));
                totalCount += currentCount;
                JSONArray teamArray = resTeamObject.getJSONArray("value");
                nextFetch = currentCount >= 100;
                this.concatArray(tfsAllTeamsArray, teamArray);
            } while (nextFetch);
            JSONObject teamsObject = new JSONObject();
            teamsObject.put("count", totalCount);
            teamsObject.put("value", (Object)tfsAllTeamsArray);
            tfsTeamsStr = teamsObject.toString();
        }
        catch (JSONException e1) {
            e1.printStackTrace();
            tfsTeamsStr = this.getRequest("/_apis/projects/" + projectId + "/teams", almAccount);
        }
        return tfsTeamsStr;
    }

    public String getProjectIterations(String projectId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/_apis/wit/classificationnodes/iterations?$depth=10", almAccount);
    }

    public String getTeamIterations(String projectId, String teamId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/" + teamId + "/_apis/work/teamsettings/iterations", almAccount);
    }

    public String getTeamSettingsFieldValues(String projectId, String teamId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/" + teamId + "/_apis/work/teamsettings/teamfieldvalues", almAccount);
    }

    public String getTeamSettings(String projectId, String teamId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/" + teamId + "/_apis/work/teamsettings", almAccount);
    }

    public String getIterationItems(String projectId, String teamId, String iterationId, AlmAccount almAccount) {
        return this.getRequest("/" + projectId + "/" + teamId + "/_apis/work/teamsettings/iterations/" + iterationId + "/workitems", almAccount);
    }

    public String getItems(String depth, String ids, AlmAccount almAccount) {
        return this.getRequest("/_apis/wit/workItems?$expand=all&$depth=" + depth + "&ids=" + ids, almAccount);
    }

    public TFSResponse getBatchItems(JSONObject requestBody, AlmAccount almAccount) throws ViztrendJiraException {
        String url = "/_apis/wit/workitemsbatch";
        return this.postRequest(url, requestBody.toString(), almAccount);
    }

    public String getItems(String depth, String ids, String param, AlmAccount almAccount) {
        return this.getRequest("/_apis/wit/workItems?ids=" + ids + (PropertyValidator.isValid((Object)param) ? "&" + param : ""), almAccount);
    }

    public String getItem(String tfsId, String param, AlmAccount almAccount) {
        return this.getRequest("/_apis/wit/workItems/" + tfsId + (PropertyValidator.isValid((Object)param) ? "?" + param : ""), almAccount);
    }

    public String removeRelationLink(String tfsId, String param, AlmAccount almAccount) {
        return this.getRequest("/_apis/wit/workItems/" + tfsId + (PropertyValidator.isValid((Object)param) ? "&" + param : ""), almAccount);
    }

    public String getProjectAreaNodes(String projectTfsId, String param, AlmAccount almAccount) {
        return this.getRequest("/" + projectTfsId + "/_apis/wit/classificationnodes?$depth=10", almAccount);
    }

    public String getUsers(String limit, String query, AlmAccount almAccount) {
        String exeUrl;
        String encodedString = query;
        try {
            encodedString = URLEncoder.encode(query, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        String url = "/_apis/userentitlements?top=" + limit + "&$filter=name+eq+'" + encodedString + "'&" + this.apiVerson;
        String userName = null;
        String password = null;
        AzureOAuthToken azureOAuthToken = null;
        boolean isAdminAlmAcc = almAccount.getAdminAlmAcc();
        if (!almAccount.getIsTaggedUser().booleanValue()) {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            AlmAccUser almAccUser = this.getUserAlmCredntials(almAccount.getId(), loggedInUser);
            if (PropertyValidator.isValid((Object)almAccUser)) {
                userName = almAccUser.getAlmUsername();
                password = almAccUser.getAlmPassword();
                azureOAuthToken = almAccUser.getAzureOAuthToken();
                isAdminAlmAcc = false;
            } else {
                userName = almAccount.getUsername();
                password = almAccount.getPassword();
                azureOAuthToken = almAccount.getAzureOAuthToken();
                isAdminAlmAcc = true;
            }
        } else {
            userName = almAccount.getUsername();
            password = almAccount.getPassword();
            azureOAuthToken = almAccount.getAzureOAuthToken();
        }
        if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
            try {
                LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (isAdminAlmAcc ? "admin alm account." : "user alm credentials."));
                azureOAuthToken = this.refreshAlmToken(azureOAuthToken, almAccount.getId());
                if (!isAdminAlmAcc) {
                    this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                } else {
                    this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                }
            }
            catch (ViztrendJiraException exception) {
                LOGGER.error(exception.toString());
                throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
            }
        }
        if ((exeUrl = this.getAlmAccountBaseUrl(almAccount) + url).contains("dev.azure.")) {
            exeUrl = exeUrl.replace("dev.", "vsaex.dev.");
        } else if (exeUrl.contains(".visualstudio.com")) {
            try {
                ImmutableList parts = InternetDomainName.from((String)new URI(exeUrl).getHost()).parts();
                if (parts.size() == 3) {
                    String accountName = (String)parts.get(0);
                    exeUrl = "https://vsaex.dev.azure.com/" + accountName + url;
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        LOGGER.debug("URL \t\t:: " + exeUrl);
        TFSResponse tfsResponse = null;
        try {
            tfsResponse = TFSOauth2Filter.executeGetRequest((String)exeUrl, (String)this.getAccessToken(userName, password, azureOAuthToken));
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        String response = null;
        if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
            LOGGER.debug(tfsResponse.toString());
        }
        if (tfsResponse.getStatusCode() != 200 && tfsResponse.getStatusCode() != 201) {
            LOGGER.error("Failed: executeTFSGETRequest " + tfsResponse.getStatusCode() + "\t\t" + url);
            AlmError almErr = new AlmError();
            almErr.setRequestJson(tfsResponse.getContent());
            almErr.setEndPoint(exeUrl);
            almErr.setHttpErrorCode(tfsResponse.getStatusCode());
            almErr.setErrorJson(tfsResponse.getContent());
            almErr.setReason(tfsResponse.getReason());
            throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
        }
        response = tfsResponse.getContent();
        return response;
    }

    public AzureOAuthToken refreshAlmToken(AzureOAuthToken azureOAuthToken, String almAccountId) {
        AlmAccount almAccount = this.almAccountRepository.findById(almAccountId);
        LOGGER.info("refreshAlmToken -> Refreshing token for almaccount: " + almAccount.getName());
        if (PropertyValidator.isValid((Object)azureOAuthToken) && PropertyValidator.isValid((Object)almAccount.getAzureOAuthToken())) {
            String clientSecret = almAccount.getSecretKey();
            try {
                CloseableHttpClient httpClient = HttpClients.createMinimal();
                HttpPost post = null;
                String authType = String.valueOf(almAccount.getAuthType());
                if ("Auth".equalsIgnoreCase(authType)) {
                    post = new HttpPost("https://app.vssps.visualstudio.com/oauth2/token");
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
                    params.add(new BasicNameValuePair("client_assertion", URLEncoder.encode(clientSecret, StandardCharsets.UTF_8.toString())));
                    params.add(new BasicNameValuePair("grant_type", "refresh_token"));
                    params.add(new BasicNameValuePair("assertion", URLEncoder.encode(azureOAuthToken.getRefreshToken(), StandardCharsets.UTF_8.toString())));
                    params.add(new BasicNameValuePair("redirect_uri", almAccount.getAuthUrl()));
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
                    post.setEntity((HttpEntity)entity);
                    post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                } else if ("EntraId".equalsIgnoreCase(authType)) {
                    String directoryId = almAccount.getDirectoryId();
                    String clientId = almAccount.getClientId();
                    String code = almAccount.getAzureOAuthToken().getRefreshToken();
                    String oAuthCallbackUrl = almAccount.getAuthUrl();
                    post = new HttpPost("https://login.microsoftonline.com/" + directoryId + "/oauth2/v2.0/token");
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
                    params.add(new BasicNameValuePair("client_id", clientId));
                    params.add(new BasicNameValuePair("client_secret", clientSecret));
                    params.add(new BasicNameValuePair("grant_type", "refresh_token"));
                    params.add(new BasicNameValuePair("refresh_token", azureOAuthToken.getRefreshToken()));
                    params.add(new BasicNameValuePair("redirect_uri", oAuthCallbackUrl));
                    params.add(new BasicNameValuePair("scope", "offline_access https://app.vssps.visualstudio.com/.default"));
                    UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params);
                    post.setEntity((HttpEntity)entity);
                    post.setHeader("Content-Type", "application/x-www-form-urlencoded");
                }
                HttpResponse postResponse = httpClient.execute((HttpUriRequest)post);
                String content = TFSOauth2Filter.convertStreamToString((InputStream)postResponse.getEntity().getContent());
                JSONObject jsonResponse = new JSONObject(content);
                if (!jsonResponse.isNull("access_token")) {
                    AzureOAuthToken newToken = this.parseAzureToken(jsonResponse.toString());
                    LOGGER.info("refreshAlmToken -> Token created, expire time: " + newToken.getExpiresAt());
                    azureOAuthToken.setAccessToken(newToken.getAccessToken());
                    azureOAuthToken.setRefreshToken(newToken.getRefreshToken());
                    azureOAuthToken.setExpiresAt(newToken.getExpiresAt());
                    return azureOAuthToken;
                }
                if (!jsonResponse.isNull("Error")) {
                    AlmError almError = new AlmError();
                    almError.setAlmErrorMessage(jsonResponse.getString("Error"));
                    almError.setDescription(!jsonResponse.isNull("ErrorDescription") ? jsonResponse.getString("ErrorDescription") : "Unable to get Refresh Token.");
                    almError.setHttpErrorCode(Integer.valueOf(500));
                    throw new ViztrendJiraException(Integer.valueOf(500), almError.getDescription(), almError);
                }
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                AlmError almError = new AlmError();
                almError.setAlmErrorMessage(e.getMessage());
                almError.setHttpErrorCode(Integer.valueOf(500));
                throw new ViztrendJiraException(Integer.valueOf(500), e.getMessage(), almError);
            }
        }
        AlmError almError = new AlmError();
        almError.setAlmErrorMessage("Unable to get refresh token.");
        almError.setHttpErrorCode(Integer.valueOf(500));
        throw new ViztrendJiraException(Integer.valueOf(500), "Unable to get refresh token.", almError);
    }

    public AzureOAuthToken parseAzureToken(String response) {
        JSONObject jsonObject = null;
        AzureOAuthToken azureOAuthToken = new AzureOAuthToken();
        try {
            jsonObject = new JSONObject(response);
            LocalDateTime tokenExpiresAt = LocalDateTime.now().plus(Duration.of(Long.parseLong(jsonObject.getString("expires_in")), ChronoUnit.SECONDS));
            azureOAuthToken.setAccessToken(jsonObject.getString("access_token"));
            azureOAuthToken.setExpiresAt(tokenExpiresAt.toString());
            azureOAuthToken.setRefreshToken(jsonObject.getString("refresh_token"));
            azureOAuthToken.setTokenType(jsonObject.getString("token_type"));
            return azureOAuthToken;
        }
        catch (JSONException e) {
            LOGGER.error(String.valueOf((Object)e));
            return null;
        }
    }

    public void cacheToken(JSONObject jsonObjResponse, ServerCache serverCache, String userName, List<String> organizations) {
        Gson gson = new Gson();
        HashMap kv = (HashMap)new Gson().fromJson(serverCache.getValue(), HashMap.class);
        kv.put("accessToken", jsonObjResponse.get("access_token"));
        kv.put("expiresAt", TFSUtils.getAzureTokenExpiry((String)jsonObjResponse.get("expires_in").toString()));
        kv.put("refreshToken", jsonObjResponse.get("refresh_token"));
        kv.put("tfsUserName", userName);
        kv.put("type", "tfs");
        kv.put("organizations", organizations);
        String jsonAuthMapJSON = gson.toJson((Object)kv);
        serverCache.setValue(jsonAuthMapJSON);
        this.serverCacheRepository.save((Object)serverCache);
    }

    public boolean isInValidToken(AzureOAuthToken azureOAuthToken) {
        org.joda.time.LocalDateTime now;
        org.joda.time.LocalDateTime tokenExpiresAt;
        boolean isInValid = true;
        String expireAt = azureOAuthToken.getExpiresAt();
        if (PropertyValidator.isValid((Object)expireAt) && (tokenExpiresAt = org.joda.time.LocalDateTime.parse((String)expireAt)).compareTo((ReadablePartial)(now = org.joda.time.LocalDateTime.now())) > 0) {
            isInValid = false;
        }
        return isInValid;
    }

    public static String getAzureTokenExpiry(String expiresIn) {
        LocalDateTime tokenExpiresAt = LocalDateTime.now().plus(Duration.of(Long.parseLong(expiresIn), ChronoUnit.SECONDS));
        return tokenExpiresAt.toString();
    }

    public void updateAlmAccUserAuthToken(AzureOAuthToken azureOAuthToken, String almAccId, String oAuthTokenOwnerUserId) {
        User user;
        LOGGER.info("Updating OAuth token in profile");
        if (PropertyValidator.isValid((Object)oAuthTokenOwnerUserId)) {
            LOGGER.info("oAuthTokenOwnerUserId provided, searching userId " + oAuthTokenOwnerUserId + " from DB to update token.");
            user = (User)this.userRepository.findOne((Serializable)((Object)oAuthTokenOwnerUserId));
        } else {
            SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
            user = (User)this.userRepository.findOne((Serializable)((Object)loggedInUser.getId()));
            LOGGER.info("Updating token for currently logged in user: " + user.getUserName());
        }
        AlmAccUser almAccUser = this.getUserAlmCredntials(almAccId, user);
        if (PropertyValidator.isValid((Object)user)) {
            List almCredentials = user.getAlmCredentials().stream().map(alm -> {
                if (alm.getAlmAccId().equals(almAccUser.getAlmAccId())) {
                    LOGGER.info("Alm account ID matched from user alm credentials, updating OAuth token in user credentials.");
                    alm.setAzureOAuthToken(azureOAuthToken);
                }
                return alm;
            }).collect(Collectors.toList());
            user.setAlmCredentials(almCredentials);
            LOGGER.info("Saving OAuth token in user credentials for user: " + user.getUserName());
            this.userRepository.save((Object)user);
        }
    }

    public TFSResponse executeAzureDevopsApiRequest(String url, AlmAccount almAccount) {
        TFSResponse tfsResponse;
        block5: {
            tfsResponse = null;
            AzureOAuthToken azureOAuthToken = almAccount.getAzureOAuthToken();
            try {
                if (PropertyValidator.isValid((Object)azureOAuthToken) && this.isInValidToken(azureOAuthToken)) {
                    azureOAuthToken = this.refreshAlmToken(almAccount.getAzureOAuthToken(), almAccount.getId());
                    almAccount.setAzureOAuthToken(azureOAuthToken);
                    LOGGER.info("Token is expired, refreshing token. Token will be saved in " + (almAccount.getAdminAlmAcc() != false ? "admin alm account." : "user alm credentials."));
                    if (!almAccount.getAdminAlmAcc().booleanValue()) {
                        this.updateAlmAccUserAuthToken(azureOAuthToken, almAccount.getId(), almAccount.getOAuthTokenOwnerUserId());
                    } else {
                        this.updateAlmAccount(azureOAuthToken, almAccount.getId());
                    }
                }
                tfsResponse = TFSOauth2Filter.executeGetRequest((String)url, (String)this.getAccessToken("", "", azureOAuthToken));
            }
            catch (Exception e) {
                LOGGER.error(StringUtils.getTraceString((Throwable)e));
                if (!(e instanceof ViztrendJiraException)) break block5;
                ViztrendJiraException exception = (ViztrendJiraException)((Object)e);
                throw new ViztrendJiraException(exception.getCode(), exception.getMessage(), exception.getAlmError());
            }
        }
        return tfsResponse;
    }

    public String validateAzureDevopsUser(AlmAccount almAccount) {
        String url = "https://app.vssps.visualstudio.com/_apis/profile/profiles/me?api-version=6.0";
        TFSResponse tfsResponse = this.executeAzureDevopsApiRequest(url, almAccount);
        String result = "";
        if (PropertyValidator.isValid((Object)tfsResponse) && (tfsResponse.getStatusCode() == 200 || tfsResponse.getStatusCode() == 201)) {
            result = tfsResponse.getContent();
        } else {
            TFSUtils.throwGenericTfsRequestException((String)url, (TFSResponse)tfsResponse, (String)"GET");
        }
        return result;
    }

    public List<String> getOrganizationListFromTFSToken(AlmAccount almAccount) {
        String url = "https://app.vssps.visualstudio.com/_apis/accounts";
        TFSResponse tfsResponse = this.executeAzureDevopsApiRequest(url, almAccount);
        List<String> organizations = new ArrayList<String>();
        if (PropertyValidator.isValid((Object)tfsResponse) && (tfsResponse.getStatusCode() == 200 || tfsResponse.getStatusCode() == 201)) {
            String result = tfsResponse.getContent();
            1 type = new /* Unavailable Anonymous Inner Class!! */;
            List userAccounts = (List)new Gson().fromJson(result, type.getType());
            organizations = userAccounts.stream().map(userAccount -> (String)userAccount.get("AccountName")).collect(Collectors.toList());
        }
        return organizations;
    }

    public static void throwGenericTfsRequestException(String url, TFSResponse tfsResponse, String methodType) throws ViztrendJiraException {
        String errMsg = "Failed: executeTFS" + methodType + "Request ";
        LOGGER.error(errMsg + tfsResponse.getStatusCode() + "\t\t" + url);
        AlmError almErr = new AlmError();
        almErr.setEndPoint(url);
        if (PropertyValidator.isValid((Object)tfsResponse)) {
            almErr.setRequestJson(tfsResponse.getContent());
            almErr.setHttpErrorCode(tfsResponse.getStatusCode());
            almErr.setErrorJson(tfsResponse.getContent());
            almErr.setReason(tfsResponse.getReason());
        } else {
            almErr.setHttpErrorCode(Integer.valueOf(500));
            almErr.setErrorJson("{}");
            almErr.setAlmErrorMessage(errMsg);
        }
        throw new ViztrendJiraException(tfsResponse.getStatusCode(), almErr.getErrorJson(), almErr);
    }

    public void updateAlmAccount(AzureOAuthToken azureOAuthToken, String almAccId) {
        LOGGER.info("Updating OAuth token in admin alm account.");
        AlmAccount almAccount = this.almAccountRepository.findById(almAccId);
        almAccount.setAzureOAuthToken(azureOAuthToken);
        this.almAccountRepository.save((Object)almAccount);
    }

    public void retrieveTfsSprintJson(ItemSyncMapper sync, AuditLog auditLog, SessionBoard board) {
        try {
            String json;
            Gson gson = new Gson();
            HashMap<String, String> body = new HashMap<String, String>();
            StringBuilder query = new StringBuilder();
            HashSet<String> areas = new HashSet<String>();
            List tMap = board.getSession().getTfsAlmConfigurations().getTeamMappings();
            query.append("SELECT [System.Id], [System.WorkItemType], [System.Title], [System.AssignedTo], [System.State], [System.Tags] FROM WORKITEMS WHERE [System.WorkItemType] <> '' AND [System.IterationPath] IN (");
            for (TFSTeamMapping tm : tMap) {
                if (!sync.getTeam().getId().equals(tm.getKendisTeamId())) continue;
                query.append("'").append(sync.getTfsSprint().getIterationPath()).append("')");
                if (Boolean.TRUE.equals(board.getSession().getAreaPathDisabled()) && !Boolean.TRUE.equals(board.getSession().getTeamFieldEnable())) break;
                areas.add(tm.getTfsAreaPath());
                if (!PropertyValidator.isValid((Collection)tm.getTfsAreaPathsForTeam())) break;
                for (String path : tm.getTfsAreaPathsForTeam()) {
                    areas.add(path);
                }
            }
            if (areas.size() > 0) {
                query.append(" AND [System.AreaPath] IN ('").append(String.join((CharSequence)"','", areas)).append("')");
            }
            body.put("query", query.toString());
            TFSResponse response = this.postRequest("/_apis/wit/wiql", gson.toJson(body), board.getSession().getTfsAlmConfigurations().getAlmAccount());
            if (response != null && PropertyValidator.isValid((Object)(json = response.getContent()))) {
                if (!PropertyValidator.isValid((Object)auditLog.getAuditMeta())) {
                    auditLog.setAuditMeta(new HashMap());
                }
                auditLog.getAuditMeta().put("tfsSprintId", sync.getTfsSprint().getTfsId());
                ArrayList<String> pages = (ArrayList<String>)auditLog.getAuditMeta().get("jsons");
                if (pages == null) {
                    pages = new ArrayList<String>();
                    auditLog.getAuditMeta().put("jsons", pages);
                }
                pages.add(json);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while retrieveTfsSprintJson ::   : " + StringUtils.getTraceString((Throwable)e));
        }
    }
}

