/*
 * Decompiled with CFR 0.152.
 */
package com.viztrend.safe.alm.jira;

import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.viztrend.exception.ViztrendJiraException;
import com.viztrend.safe.alm.jira.JiraOauthUtil;
import com.viztrend.safe.alm.jira.JiraUtils;
import com.viztrend.safe.alm.jira.bo.JiraConnect;
import com.viztrend.safe.alm.jira.bo.JiraIssueLinkType;
import com.viztrend.safe.alm.jira.bo.JiraSprint;
import com.viztrend.safe.exception.KendisException;
import com.viztrend.safe.persistence.entity.AlmAccUser;
import com.viztrend.safe.persistence.entity.AlmAccount;
import com.viztrend.safe.persistence.entity.AlmConfigurations;
import com.viztrend.safe.persistence.entity.AlmError;
import com.viztrend.safe.persistence.entity.BacklogMapping;
import com.viztrend.safe.persistence.entity.Item;
import com.viztrend.safe.persistence.entity.ItemJiraDependency;
import com.viztrend.safe.persistence.entity.ItemJiraFieldMap;
import com.viztrend.safe.persistence.entity.ItemLink;
import com.viztrend.safe.persistence.entity.ItemSyncMapper;
import com.viztrend.safe.persistence.entity.JiraOauthToken;
import com.viztrend.safe.persistence.entity.SessionBoard;
import com.viztrend.safe.persistence.entity.TeamContainer;
import com.viztrend.safe.persistence.entity.User;
import com.viztrend.safe.persistence.entity.dto.SecureUser;
import com.viztrend.safe.persistence.repository.AlmAccountRepository;
import com.viztrend.safe.persistence.repository.ItemRepository;
import com.viztrend.safe.persistence.repository.TeamContainerRepository;
import com.viztrend.safe.persistence.repository.UserRepository;
import com.viztrend.safe.service.ALMSyncService;
import com.viztrend.safe.service.ALMSyncServiceImpl;
import com.viztrend.safe.utils.EncDecUtility;
import com.viztrend.safe.utils.PropertyValidator;
import com.viztrend.safe.utils.StringUtils;
import com.viztrend.safe.utils.SystemUtil;
import com.viztrend.safe.utils.UserContextUtil;
import com.viztrend.safe.vos.JiraConnectVO;
import com.viztrend.safe.vos.ResyncParamsVO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.NodeVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class JiraUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraUtils.class);
    @Autowired
    private ALMSyncService almSyncService;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AlmAccountRepository almAccountRepository;
    static ALMSyncService almSyncServiceStatic;
    static UserRepository userRepe;
    static AlmAccountRepository almAccountRepo;
    @Autowired
    private static Environment env;
    private static KeyManagerFactory kmf;
    private static InputStream is;

    @PostConstruct
    public void JiraUtilsPost() {
        almSyncServiceStatic = this.almSyncService;
        userRepe = this.userRepository;
        almAccountRepo = this.almAccountRepository;
    }

    public static String smartJQL(String jql, String syncingGap, Collection<String> ids) {
        StringBuilder query = new StringBuilder();
        if (PropertyValidator.isValid(ids)) {
            if (PropertyValidator.isValid((Object)syncingGap)) {
                query.append("(ID NOT IN (" + String.join((CharSequence)",", ids) + ") OR (").append(syncingGap).append(" AND ID IN (" + String.join((CharSequence)",", ids) + ")").append("))");
            } else {
                query.append("ID NOT IN (" + String.join((CharSequence)",", ids) + ") ");
            }
        } else if (PropertyValidator.isValid((Object)syncingGap)) {
            query.append(syncingGap);
        }
        if (PropertyValidator.isValid((Object)jql)) {
            if (query.length() > 0) {
                query.append(" AND ");
            }
            query.append("(").append(jql).append(")");
        }
        return query.toString();
    }

    public static AlmAccount getAlmAccountWithProfileUser(AlmAccount almAccount) {
        if (almAccount != null && Boolean.TRUE.equals(almAccount.getIsSelectedOnResync())) {
            return almAccount;
        }
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (PropertyValidator.isValid((Collection)loggedInUser.getAlmCredentials())) {
            for (AlmAccUser userCreds : loggedInUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                almAccount.setUsername(userCreds.getAlmUsername());
                almAccount.setPassword(userCreds.getAlmPassword());
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                almAccount.setIsPatOnProfile(userCreds.getIsPatOn());
                return almAccount;
            }
        }
        return null;
    }

    public static User getProfileAlmUser(AlmAccount almAccount) {
        LOGGER.info("getProfileAlmUser -> Searching user using alm account: " + almAccount.getName());
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        User user = (User)userRepe.findOne((Serializable)((Object)loggedInUser.getId()));
        loggedInUser.setAlmCredentials(user.getAlmCredentials());
        if (PropertyValidator.isValid((Collection)loggedInUser.getAlmCredentials())) {
            for (AlmAccUser userCreds : loggedInUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                LOGGER.info("getProfileAlmUser -> Alm account found in user profile, returning user.");
                return loggedInUser;
            }
        }
        LOGGER.info("getProfileAlmUser -> Could not find alm account in user profile for alm: " + almAccount.getName());
        return null;
    }

    public static AlmAccount getTaggedAlmUser(User taggedUser, AlmAccount almAccount) {
        if (taggedUser != null && PropertyValidator.isValid((Collection)taggedUser.getAlmCredentials())) {
            for (AlmAccUser userCreds : taggedUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                if (PropertyValidator.isValid((Object)userCreds.getJiraOauthToken())) {
                    almAccount.setJiraOauthToken(userCreds.getJiraOauthToken());
                    almAccount.setAdminAlmAcc(Boolean.valueOf(false));
                    almAccount.setOAuthTokenOwnerUserId(taggedUser.getId());
                } else {
                    almAccount.setJiraOauthToken(null);
                    almAccount.setUsername(userCreds.getAlmUsername());
                    almAccount.setPassword(userCreds.getAlmPassword());
                    almAccount.setIsPatOnProfile(userCreds.getIsPatOn());
                }
                almAccount.setIsTaggedUser(Boolean.valueOf(true));
                return almAccount;
            }
        }
        return null;
    }

    public static void setAlmAccountWithProfileUser(AlmAccount almAccount) {
        SecureUser secureUser = (SecureUser)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        User loggedInUser = (User)secureUser.getUserContextDTO().getContextMap().get("user");
        if (PropertyValidator.isValid((Collection)loggedInUser.getAlmCredentials())) {
            for (AlmAccUser userCreds : loggedInUser.getAlmCredentials()) {
                if (!almAccount.getId().equals(userCreds.getAlmAccId())) continue;
                almAccount.setUsername(userCreds.getAlmUsername());
                almAccount.setPassword(userCreds.getAlmPassword());
                break;
            }
        }
    }

    protected static String executeJiraRequestByConnect(JiraConnect connect, AlmAccount almAccount, Environment env) {
        block36: {
            try {
                LOGGER.debug("INSIDE executeJiraRequestByConnect ");
                ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(env.getProperty("jira.plugin.url") + "/jira/plugin/api"), (HttpMethod)HttpMethod.POST);
                Gson gson = new Gson();
                String param = gson.toJson((Object)connect);
                try {
                    request.getBody().write(param.getBytes());
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("Failed: executeJiraRequestByConnect reconnect = " + connect + " \n errStr=  ", (Throwable)e);
                    throw new ViztrendJiraException(Integer.valueOf(400), "Invalid input", null);
                }
                JiraConnectVO jiraConnectVO = null;
                JiraConnectVO jiraConnectUser = null;
                try {
                    jiraConnectVO = almSyncServiceStatic.getConnectAccount(almAccount.getAtlassianHostDomainId());
                    jiraConnectUser = almSyncServiceStatic.getConnectAccountUser(jiraConnectVO.getId());
                }
                catch (Exception e) {
                    LOGGER.error("Failed: executeJiraRequestByConnect Jira Connect failed.");
                    AlmError almerr = new AlmError();
                    almerr.setAlmErrorMessage("Jira Connect Failed");
                    almerr.setHttpErrorCode(Integer.valueOf(510));
                    throw new ViztrendJiraException(Integer.valueOf(510), "Jira Connect Failed", almerr);
                }
                if (PropertyValidator.isValid((Object)jiraConnectVO) && PropertyValidator.isValid((Object)jiraConnectVO.getAddonInstalled()) && jiraConnectVO.getAddonInstalled().booleanValue()) {
                    if (almAccount.isByPassJiraUserMatch()) {
                        almAccount.setByPassJiraUserMatch(false);
                        jiraConnectUser = new JiraConnectVO();
                        jiraConnectUser.setJiraKey(jiraConnectVO.getJiraKey());
                    } else if (!PropertyValidator.isValid((Object)jiraConnectUser) || !PropertyValidator.isValid((Object)jiraConnectUser.getJiraKey())) {
                        String jiraUserId = almSyncServiceStatic.findJiraUserForConnect(jiraConnectVO, almAccount);
                        LOGGER.debug("finding fresh jira user key :" + jiraUserId);
                        if (PropertyValidator.isValid((Object)jiraUserId)) {
                            jiraConnectUser = new JiraConnectVO();
                            jiraConnectUser.setJiraKey(jiraUserId);
                        } else {
                            jiraConnectUser = new JiraConnectVO();
                            jiraConnectUser.setJiraKey(jiraConnectVO.getJiraKey());
                        }
                    }
                    request.getHeaders().add("Content-Type", "application/json");
                    request.getHeaders().add("jiraUserKey", jiraConnectUser.getJiraKey());
                    request.getHeaders().add("jiraHost", jiraConnectVO.getJiraHostUrl());
                    ClientHttpResponse response = request.execute();
                    if ("GET".equals(connect.getRequestType())) {
                        if (response.getRawStatusCode() == 200) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                            String responseStr = reader.readLine();
                            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                                LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                            }
                            return responseStr;
                        }
                        String errStr = IOUtils.toString((InputStream)response.getBody());
                        LOGGER.error("Failed: executeJiraRequestByConnect response.getRawStatusCode() = " + response.getRawStatusCode() + " \n errStr=  " + errStr);
                        AlmError almerr = new AlmError();
                        almerr.setAlmErrorMessage(errStr);
                        almerr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
                        throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errStr, almerr);
                    }
                    if ("POST".equals(connect.getRequestType())) {
                        if (response.getRawStatusCode() == 200 || response.getRawStatusCode() == 201) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                            String responseStr = reader.readLine();
                            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                                LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                            }
                            return responseStr;
                        }
                        if (response.getRawStatusCode() == 204) {
                            return "Done";
                        }
                        String errorStr = "";
                        errorStr = response.getStatusText();
                        HttpStatus statusCode = response.getStatusCode();
                        LOGGER.error("Failed: executeJiraRequestByConnect PostRequest " + response.getRawStatusCode() + "\t\t" + connect.getUrl());
                        AlmError almErr = new AlmError();
                        almErr.setRequestJson(connect.getBody());
                        almErr.addInfo(connect, almAccount);
                        almErr.setHttpErrorCode(Integer.valueOf(statusCode.value()));
                        try {
                            if (response.getBody() != null) {
                                almErr.setType("Jira");
                                errorStr = IOUtils.toString((InputStream)response.getBody());
                            } else {
                                almErr.setType("Kendis");
                                errorStr = response.getStatusText();
                                errorStr = errorStr + response.getStatusCode();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("JSONException in getJsonObject.", (Throwable)e);
                        }
                        almErr.setErrorJson(errorStr);
                        throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
                    }
                    if ("PUT".equals(connect.getRequestType())) {
                        if (response.getRawStatusCode() == 200) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                            String responseStr = reader.readLine();
                            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                                LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                            }
                            return responseStr;
                        }
                        if (response.getRawStatusCode() == 204) {
                            return "Done";
                        }
                        String errorStr = "";
                        AlmError almErr = new AlmError();
                        almErr.setRequestJson(connect.getBody());
                        almErr.addInfo(connect, almAccount);
                        try {
                            if (response.getBody() != null) {
                                almErr.setType("Jira");
                                errorStr = IOUtils.toString((InputStream)response.getBody());
                            } else {
                                almErr.setType("Kendis");
                                errorStr = response.getStatusText();
                                errorStr = errorStr + response.getStatusCode();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LOGGER.error("Failed: executeJiraRequestByConnect PutRequest " + errorStr);
                        almErr.setErrorJson(errorStr);
                        throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
                    }
                    if ("DELETE".equals(connect.getRequestType())) {
                        if (response.getRawStatusCode() == 200) {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                            String responseStr = reader.readLine();
                            if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                                LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                            }
                            return responseStr;
                        }
                        if (response.getRawStatusCode() == 204) {
                            return "Done";
                        }
                        String errorStr = IOUtils.toString((InputStream)response.getBody());
                        LOGGER.error("Failed: executeJiraRequestByConnect DeleteRequest " + errorStr);
                        AlmError almErr = new AlmError();
                        almErr.addInfo(connect, almAccount);
                        almErr.setErrorJson(errorStr);
                        throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
                    }
                    break block36;
                }
                LOGGER.error("Failed: executeJiraRequestByConnect Jira Connect Disabled.");
                AlmError almerr = new AlmError();
                almerr.setAlmErrorMessage("Jira Connect Disabled");
                almerr.setHttpErrorCode(Integer.valueOf(510));
                throw new ViztrendJiraException(Integer.valueOf(510), "Jira Connect Disabled", almerr);
            }
            catch (IOException e) {
                LOGGER.error("Failed: executeJiraRequestByConnect " + e.getMessage(), (Throwable)e);
                AlmError almerr = new AlmError();
                almerr.setAlmErrorMessage("Limited or No Connectivity");
                almerr.setHttpErrorCode(Integer.valueOf(500));
                throw new ViztrendJiraException(Integer.valueOf(500), e.getMessage(), almerr);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Failed: executeJiraRequestByConnect " + e.getMessage(), (Throwable)e);
                AlmError almerr = new AlmError();
                almerr.setAlmErrorMessage(e.getMessage());
                almerr.setHttpErrorCode(Integer.valueOf(400));
                throw new ViztrendJiraException(Integer.valueOf(400), e.getMessage(), almerr);
            }
        }
        return null;
    }

    private static String getOauthAuth(String url, String reqType, AlmAccount almAccount) {
        if (PropertyValidator.isValid((Object)almAccount.getJiraOauthToken())) {
            JiraOauthToken jiraOauthToken = almAccount.getJiraOauthToken();
            String jiraBaseUrl = almAccount.getUrl();
            String oauthToken = jiraOauthToken.getOauthToken();
            String oauthVerfier = jiraOauthToken.getOauthVerfier();
            String consumerKey = jiraOauthToken.getConsumerKey();
            String privateKey = jiraOauthToken.getPrivateKey();
            String accessToken = jiraOauthToken.getAccessToken();
            String accessTokenUrl = jiraBaseUrl + "/plugins/servlet/oauth/access-token";
            String oauthAuth = JiraOauthUtil.getAuthorizationHeader((String)accessToken, (String)oauthToken, (String)oauthVerfier, (String)consumerKey, (String)privateKey, (String)url, (String)reqType, (String)accessTokenUrl, (String)almAccount.getJiraAuthRedirectURL());
            LOGGER.debug("oauth authorization --- :User :" + almAccount.getUsername() + "        (" + oauthAuth + ")");
            return oauthAuth;
        }
        return null;
    }

    protected static String executeJiraGetRequestBasic(String URL2, String encoding, AlmAccount almAcc) {
        String _username = "";
        String[] encodings = null;
        if (encoding != null && encoding.length() > 1) {
            encodings = encoding.split(":");
            _username = encodings[0];
        }
        try {
            ClientHttpResponse response;
            if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
                response = JiraUtils.executeJiraCloudAuthRequest((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.GET, null);
            } else if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && !almAcc.getJiraOauthToken().isCloud() && JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)almAcc.getJiraOauthToken().getServerAuthType())) {
                response = JiraUtils.executeJiraServerAuth2Request((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.GET, null);
            } else {
                ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(URL2), (HttpMethod)HttpMethod.GET);
                if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken())) {
                    request.getHeaders().add("Authorization", JiraUtils.getOauthAuth((String)URL2, (String)"GET", (AlmAccount)almAcc));
                } else if (encodings != null && almAcc.usePAT()) {
                    request.getHeaders().add("Authorization", "Bearer " + encodings[1]);
                    LOGGER.debug("jirauser(PAT) : executeJiraGetRequestBasic: URL: " + URL2);
                } else {
                    LOGGER.debug("jirauser :" + _username + " INSIDE executeJiraGetRequestBasic " + URL2);
                    request.getHeaders().add("Authorization", "Basic " + new String(Base64.encode((byte[])encoding.getBytes())));
                }
                request.getHeaders().add("Content-Type", "application/json");
                request.getHeaders().add("Accept", "application/json");
                response = request.execute();
            }
            if (response.getRawStatusCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                String responseStr = reader.readLine();
                if (UserContextUtil.getUserContext() != null && UserContextUtil.getUserContext().isDebug()) {
                    LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                }
                return responseStr;
            }
            if (response.getRawStatusCode() == 403) {
                AlmError almerr;
                boolean capthaError;
                HttpHeaders headers = response.getHeaders();
                List reasons = headers.get((Object)"X-Authentication-Denied-Reason");
                if (PropertyValidator.isValid((Collection)reasons)) {
                    capthaError = false;
                    for (String reason : reasons) {
                        if (reason == null || reason.indexOf("CAPTCHA_CHALLENGE") <= -1) continue;
                        capthaError = true;
                    }
                    if (capthaError) {
                        LOGGER.error("Failed: executeJiraGetRequestBasic response.getRawStatusCode() = " + response.getRawStatusCode() + " \n headers=  " + headers);
                        almerr = new AlmError();
                        almerr.addInfo(URL2, _username, almAcc);
                        almerr.setAlmErrorMessage("We are unable to authenticate with JIRA using current ALM Account settings. Captcha has been activated on your JIRA account. Please login to your JIRA account to remove captcha.");
                        almerr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
                        throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), "We are unable to authenticate with JIRA using current ALM Account settings. Captcha has been activated on your JIRA account. Please login to your JIRA account to remove captcha.", almerr);
                    }
                } else {
                    reasons = headers.get((Object)"X-Seraph-LoginReason");
                    if (PropertyValidator.isValid((Collection)reasons)) {
                        capthaError = false;
                        for (String string : reasons) {
                            if (!"AUTHENTICATION_DENIED".equalsIgnoreCase(string)) continue;
                            capthaError = true;
                        }
                        if (capthaError) {
                            LOGGER.error("Failed: executeJiraGetRequestBasic response.getRawStatusCode() = " + response.getRawStatusCode() + " \n headers=  " + headers);
                            almerr = new AlmError();
                            almerr.addInfo(URL2, _username, almAcc);
                            almerr.setAlmErrorMessage("We are unable to authenticate with JIRA using current ALM Account settings. Captcha has been activated on your JIRA account. Please login to your JIRA account to remove captcha.");
                            almerr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
                            throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), "We are unable to authenticate with JIRA using current ALM Account settings. Captcha has been activated on your JIRA account. Please login to your JIRA account to remove captcha.", almerr);
                        }
                    }
                }
                String errStr = IOUtils.toString((InputStream)response.getBody());
                LOGGER.error("Failed: executeJiraGetRequestBasic response.getRawStatusCode() = " + response.getRawStatusCode() + " \n errStr=  " + errStr);
                LOGGER.error("Failed: executeJiraGetRequestBasic response.getRawStatusCode() = " + response.getRawStatusCode() + " \n headers=  " + headers);
                almerr = new AlmError();
                almerr.addInfo(URL2, _username, almAcc);
                almerr.setAlmErrorMessage(errStr);
                almerr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
                throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errStr, almerr);
            }
            String errStr = IOUtils.toString((InputStream)response.getBody());
            LOGGER.error("Failed: executeJiraGetRequestBasic response.getRawStatusCode() = " + response.getRawStatusCode() + " \n errStr=  " + errStr.toString() + "\n headers= " + response.getHeaders());
            AlmError almerr = new AlmError();
            almerr.addInfo(URL2, _username, almAcc);
            almerr.setAlmErrorMessage(errStr.toString());
            almerr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
            throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errStr.toString(), almerr);
        }
        catch (IOException e) {
            LOGGER.error("Failed: executeJiraGetRequestBasic " + e.getMessage(), (Throwable)e);
            AlmError almerr = new AlmError();
            almerr.addInfo(URL2, _username, almAcc);
            almerr.setAlmErrorMessage("Limited or No Connectivity");
            almerr.setHttpErrorCode(Integer.valueOf(500));
            throw new ViztrendJiraException(Integer.valueOf(500), e.getMessage(), almerr);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failed: executeJiraGetRequestBasic " + e.getMessage(), (Throwable)e);
            AlmError almerr = new AlmError();
            almerr.addInfo(URL2, _username, almAcc);
            almerr.setAlmErrorMessage(e.getMessage());
            almerr.setHttpErrorCode(Integer.valueOf(400));
            throw new ViztrendJiraException(Integer.valueOf(400), e.getMessage(), almerr);
        }
    }

    public static String executeJiraGetRequest(String URL2, String username, String password, AlmAccount almAcc, String bodyOrParams, Environment env) {
        if (PropertyValidator.isValid((Object)almAcc) && almAcc.isUsingJiraConnect()) {
            JiraConnect connect = new JiraConnect(URL2, "GET");
            if (PropertyValidator.isValid((Object)bodyOrParams)) {
                connect.setBody(bodyOrParams);
            }
            return JiraUtils.executeJiraRequestByConnect((JiraConnect)connect, (AlmAccount)almAcc, (Environment)env);
        }
        if (almAcc.getIsPrivate().booleanValue()) {
            almAcc = JiraUtils.getAlmAccountWithProfileUser((AlmAccount)almAcc);
        }
        if (!PropertyValidator.isValid((Object)almAcc)) {
            LOGGER.error("Profile Account not mentioned.");
            throw new ViztrendJiraException(Integer.valueOf(99999), "Profile Account not mentioned.");
        }
        String _url = almAcc.getUrl() + URL2 + (bodyOrParams != null ? bodyOrParams : "");
        String decryptedPassword = almAcc.getPassword();
        try {
            decryptedPassword = EncDecUtility.decrypt((String)almAcc.getPassword());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String access = almAcc.getUsername() + ":" + decryptedPassword;
        return JiraUtils.executeJiraGetRequestBasic((String)_url, (String)access, (AlmAccount)almAcc);
    }

    public static String executeJiraDeleteRequest(String URL2, String username, String password, AlmAccount almAcc, String bodyOrParams, Environment env) {
        if (PropertyValidator.isValid((Object)almAcc) && almAcc.isUsingJiraConnect()) {
            JiraConnect connect = new JiraConnect(URL2, "DELETE");
            if (PropertyValidator.isValid((Object)bodyOrParams)) {
                connect.setBody(bodyOrParams);
            }
            return JiraUtils.executeJiraRequestByConnect((JiraConnect)connect, (AlmAccount)almAcc, (Environment)env);
        }
        if (almAcc.getIsPrivate().booleanValue()) {
            almAcc = JiraUtils.getAlmAccountWithProfileUser((AlmAccount)almAcc);
        }
        if (!PropertyValidator.isValid((Object)almAcc)) {
            LOGGER.error("Profile Account not mentioned.");
            throw new ViztrendJiraException(Integer.valueOf(99999), "Profile Account not mentioned.");
        }
        String _url = almAcc.getUrl() + URL2;
        return JiraUtils.executeJiraDeleteRequestBasic((String)_url, (String)username, (String)password, (AlmAccount)almAcc);
    }

    public static String executeJiraPostRequest(String URL2, String username, String password, AlmAccount almAcc, String body, String params, Environment env) {
        if (PropertyValidator.isValid((Object)almAcc) && almAcc.isUsingJiraConnect()) {
            JiraConnect connect = new JiraConnect(URL2, "POST");
            if (PropertyValidator.isValid((Object)body)) {
                connect.setBody(body);
            }
            return JiraUtils.executeJiraRequestByConnect((JiraConnect)connect, (AlmAccount)almAcc, (Environment)env);
        }
        if (almAcc.getIsPrivate().booleanValue()) {
            almAcc = JiraUtils.getAlmAccountWithProfileUser((AlmAccount)almAcc);
        }
        if (!PropertyValidator.isValid((Object)almAcc)) {
            LOGGER.error("Profile Account not mentioned.");
            throw new ViztrendJiraException(Integer.valueOf(99999), "Jira User is not mapped in Profile anymore.");
        }
        String _url = almAcc.getUrl() + URL2 + (params != null ? params : "");
        return JiraUtils.executeJiraPostRequestBasic((String)body, (String)_url, (String)username, (String)password, (AlmAccount)almAcc);
    }

    public static String executeJiraPutRequest(String url, String username, String password, AlmAccount almAcc, String body, String params, Environment env) {
        if (PropertyValidator.isValid((Object)almAcc)) {
            if (PropertyValidator.isValid((Object)almAcc) && almAcc.isUsingJiraConnect()) {
                JiraConnect connect = new JiraConnect(url, "PUT");
                if (PropertyValidator.isValid((Object)body)) {
                    connect.setBody(body);
                }
                if (PropertyValidator.isValid((Object)params)) {
                    connect.setParams(params);
                }
                return JiraUtils.executeJiraRequestByConnect((JiraConnect)connect, (AlmAccount)almAcc, (Environment)env);
            }
            if (almAcc.getIsPrivate().booleanValue()) {
                almAcc = JiraUtils.getAlmAccountWithProfileUser((AlmAccount)almAcc);
            }
            if (!PropertyValidator.isValid((Object)almAcc)) {
                LOGGER.error("Profile Account not mentioned.");
                throw new ViztrendJiraException(Integer.valueOf(99999), "Profile Account not mentioned.");
            }
            String _url = almAcc.getUrl() + url + (params != null ? params : "");
            return JiraUtils.executeJiraPutRequestBasic((String)_url, (String)username, (String)password, (String)body, (AlmAccount)almAcc);
        }
        LOGGER.error("INVALID AlmAccount.");
        throw new ViztrendJiraException(Integer.valueOf(99999), "INVALID AlmAccount.");
    }

    public static String executeJiraDeleteRequestBasic(String URL2, String username, String password, AlmAccount almAcc) {
        try {
            ClientHttpResponse response;
            String decryptedPassword = password;
            try {
                decryptedPassword = EncDecUtility.decrypt((String)password);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            String access = username + ":" + decryptedPassword;
            if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
                response = JiraUtils.executeJiraCloudAuthRequest((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.DELETE, null);
            } else if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && !almAcc.getJiraOauthToken().isCloud() && JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)almAcc.getJiraOauthToken().getServerAuthType())) {
                response = JiraUtils.executeJiraServerAuth2Request((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.DELETE, null);
            } else {
                ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(URL2), (HttpMethod)HttpMethod.DELETE);
                if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken())) {
                    request.getHeaders().add("Authorization", JiraUtils.getOauthAuth((String)URL2, (String)"DELETE", (AlmAccount)almAcc));
                } else if (almAcc.usePAT()) {
                    request.getHeaders().add("Authorization", "Bearer " + decryptedPassword);
                    LOGGER.debug("jirauser(PAT) : executeJiraDeleteRequestBasic: URL: " + URL2);
                } else {
                    request.getHeaders().add("Authorization", "Basic " + new String(Base64.encode((byte[])access.getBytes())));
                    LOGGER.debug("jirauser :" + username + " executeJiraDeleteRequestBasic: URL: " + URL2);
                }
                request.getHeaders().add("Content-Type", "application/json");
                request.getHeaders().add("Accept", "application/json");
                response = request.execute();
            }
            if (response.getRawStatusCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                String responseStr = reader.readLine();
                if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                    LOGGER.debug("Response :: " + StringUtils.emptyJsonAttribute((String)responseStr));
                }
                return responseStr;
            }
            if (response.getRawStatusCode() == 204) {
                return "Done";
            }
            String errorStr = null;
            try {
                errorStr = IOUtils.toString((InputStream)response.getBody());
            }
            catch (Exception responseStr) {
                // empty catch block
            }
            LOGGER.error("Failed: executeJiraDeleteRequest " + errorStr);
            AlmError almErr = new AlmError();
            almErr.addInfo(URL2, username, almAcc);
            almErr.setErrorJson(errorStr);
            throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
        }
        catch (Exception e) {
            LOGGER.error("Failed: executeJiraDeleteRequest " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String executeJiraPostRequestBasic(String postBody, String URL2, String username, String password, AlmAccount almAcc) {
        try {
            AlmError almErr;
            String errorStr;
            ClientHttpResponse response;
            block21: {
                String decryptedPassword = password;
                try {
                    decryptedPassword = EncDecUtility.decrypt((String)password);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                String access = username + ":" + decryptedPassword;
                if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
                    response = JiraUtils.executeJiraCloudAuthRequest((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.POST, (String)postBody);
                } else if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && !almAcc.getJiraOauthToken().isCloud() && JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)almAcc.getJiraOauthToken().getServerAuthType())) {
                    response = JiraUtils.executeJiraServerAuth2Request((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.POST, (String)postBody);
                } else {
                    ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(URL2), (HttpMethod)HttpMethod.POST);
                    request.getBody().write(postBody.getBytes("UTF-8"));
                    if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken())) {
                        request.getHeaders().add("Authorization", JiraUtils.getOauthAuth((String)URL2, (String)"POST", (AlmAccount)almAcc));
                    } else if (almAcc.usePAT()) {
                        request.getHeaders().add("Authorization", "Bearer " + decryptedPassword);
                        LOGGER.debug("jirauser(PAT) : executeJiraPostRequestBasic: URL: " + URL2);
                    } else {
                        request.getHeaders().add("Authorization", "Basic " + new String(Base64.encode((byte[])access.getBytes())));
                        LOGGER.debug("jirauser :" + username + " executeJiraPostRequestBasic: URL: " + URL2);
                    }
                    request.getHeaders().add("Content-Type", "application/json");
                    request.getHeaders().add("Accept", "application/json");
                    response = request.execute();
                }
                if (response.getRawStatusCode() == 200 || response.getRawStatusCode() == 201) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                    String responseStr = reader.readLine();
                    if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                        LOGGER.debug("POST Response :: " + responseStr);
                    }
                    return responseStr;
                }
                if (response.getRawStatusCode() == 301 || response.getRawStatusCode() == 302) {
                    HttpHeaders headers = response.getHeaders();
                    URI actualLocation = headers.getLocation();
                    AlmError almErr2 = new AlmError();
                    almErr2.setRequestJson(postBody);
                    almErr2.addInfo(URL2, username, almAcc);
                    HttpStatus statusCode = response.getStatusCode();
                    almErr2.setHttpErrorCode(Integer.valueOf(statusCode.value()));
                    almErr2.setActualLocation(actualLocation.toString());
                    almErr2.setErrorJson(headers.toString());
                    throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), headers.toString(), almErr2);
                }
                if (response.getRawStatusCode() == 204) {
                    return "Done";
                }
                errorStr = "";
                errorStr = response.getStatusText();
                HttpStatus statusCode = response.getStatusCode();
                LOGGER.error("Failed: executeJiraPostRequestBasic " + response.getRawStatusCode() + "\t\t" + URL2);
                almErr = new AlmError();
                almErr.setRequestJson(postBody);
                almErr.addInfo(URL2, username, almAcc);
                almErr.setHttpErrorCode(Integer.valueOf(statusCode.value()));
                try {
                    if (response.getBody() != null) {
                        almErr.setType("Jira");
                        errorStr = IOUtils.toString((InputStream)response.getBody());
                    } else {
                        almErr.setType("Kendis");
                        errorStr = response.getStatusText();
                        errorStr = errorStr + response.getStatusCode();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("JSONException in getJsonObject." + StringUtils.getTraceString((Throwable)e));
                    if (PropertyValidator.isValid((Object)errorStr)) break block21;
                    errorStr = e.getLocalizedMessage();
                }
            }
            if (response.getRawStatusCode() == 401) {
                almErr.setAlmErrorMessage(almErr.getAlmErrorMessage() == null ? errorStr : almErr.getAlmErrorMessage());
            }
            almErr.setErrorJson(errorStr);
            throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed: executeJiraPostRequestBasic " + e.getMessage(), (Throwable)e);
            throw new ViztrendJiraException(Integer.valueOf(500), e.getMessage());
        }
    }

    public static String executeJiraPutRequestBasic(String URL2, String username, String password, String putBody, AlmAccount almAcc) {
        try {
            ClientHttpResponse response;
            String decryptedPassword = password;
            try {
                decryptedPassword = EncDecUtility.decrypt((String)password);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String access = username + ":" + decryptedPassword;
            if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && almAcc.getJiraOauthToken().isCloud()) {
                response = JiraUtils.executeJiraCloudAuthRequest((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.PUT, (String)putBody);
            } else if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken()) && !almAcc.getJiraOauthToken().isCloud() && JiraOauthToken.ServerAuthType.AUTH_2_0.equals((Object)almAcc.getJiraOauthToken().getServerAuthType())) {
                response = JiraUtils.executeJiraServerAuth2Request((AlmAccount)almAcc, (String)URL2, (HttpMethod)HttpMethod.PUT, (String)putBody);
            } else {
                ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(URL2), (HttpMethod)HttpMethod.PUT);
                request.getBody().write(putBody.getBytes("UTF-8"));
                if (PropertyValidator.isValid((Object)almAcc.getJiraOauthToken())) {
                    request.getHeaders().add("Authorization", JiraUtils.getOauthAuth((String)URL2, (String)"PUT", (AlmAccount)almAcc));
                } else if (almAcc.usePAT()) {
                    request.getHeaders().add("Authorization", "Bearer " + decryptedPassword);
                    LOGGER.debug("jirauser(PAT) : executeJiraPutRequestBasic: URL: " + URL2);
                } else {
                    request.getHeaders().add("Authorization", "Basic " + new String(Base64.encode((byte[])access.getBytes())));
                    LOGGER.debug("jirauser :" + username + " executeJiraPutRequestBasic: URL: " + URL2);
                }
                request.getHeaders().add("Content-Type", "application/json");
                request.getHeaders().add("Accept", "application/json");
                response = request.execute();
            }
            if (response.getRawStatusCode() == 200) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), "UTF-8"));
                String responseStr = reader.readLine();
                if (PropertyValidator.isValid((Object)UserContextUtil.getUserContext()) && UserContextUtil.getUserContext().isDebug()) {
                    LOGGER.debug("PUT Response :: " + responseStr);
                }
                return responseStr;
            }
            if (response.getRawStatusCode() == 204) {
                return "Done";
            }
            String errorStr = "";
            AlmError almErr = new AlmError();
            almErr.setRequestJson(putBody);
            almErr.addInfo(URL2, username, almAcc);
            try {
                if (response.getBody() != null) {
                    almErr.setType("Jira");
                    errorStr = IOUtils.toString((InputStream)response.getBody());
                } else {
                    almErr.setType("Kendis");
                    errorStr = response.getStatusText();
                    errorStr = errorStr + response.getStatusCode();
                    almErr.setHttpErrorCode(Integer.valueOf(response.getRawStatusCode()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.error("Failed: executeJiraPutRequest " + errorStr);
            almErr.setErrorJson(errorStr);
            throw new ViztrendJiraException(Integer.valueOf(response.getRawStatusCode()), errorStr, almErr);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Failed: executeJiraPutRequest " + e.getMessage(), (Throwable)e);
            AlmError almErr = new AlmError();
            almErr.setRequestJson(putBody);
            almErr.addInfo(URL2, username, almAcc);
            ViztrendJiraException vje = new ViztrendJiraException(Integer.valueOf(1000), e.getMessage());
            vje.setStackTrace(e.getStackTrace());
            vje.initCause((Throwable)e);
            throw vje;
        }
    }

    public static ClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory factory = null;
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        try {
            String keystore = System.getenv("keystore");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            File keyStoreFile = new File(SystemUtil.kendisHomeFolderPath + "/" + keystore);
            if (keystore != null && keyStoreFile.exists()) {
                if (kmf == null) {
                    String keystorePass = System.getenv("keystore_password");
                    if (!PropertyValidator.isValid((Object)keystorePass)) {
                        throw new ViztrendJiraException(Integer.valueOf(500), "keystore_password is missing in environment variable");
                    }
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    try (FileInputStream fis = new FileInputStream(keyStoreFile);){
                        ks.load(fis, keystorePass.toCharArray());
                    }
                    kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ks, keystorePass.toCharArray());
                }
                sslContext.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
            } else {
                sslContext.init(null, trustAllCerts, new SecureRandom());
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        return factory;
    }

    public static ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
        ClientHttpRequestFactory clientFactory = JiraUtils.clientHttpRequestFactory();
        ClientHttpRequest request = clientFactory.createRequest(url, method);
        return request;
    }

    public static JiraSprint parseStrForJsprint(Map<String, Object> sp) {
        JiraSprint jSprint = null;
        if (PropertyValidator.isValid((Object)sp.get("id"))) {
            jSprint = new JiraSprint();
            jSprint.setJiraId(((Double)sp.get("id")).intValue() + "");
            if (PropertyValidator.isValid((Object)sp.get("name"))) {
                jSprint.setName(sp.get("name").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("boardId"))) {
                jSprint.setOriginBoardId(sp.get("boardId").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("state"))) {
                jSprint.setState(sp.get("state").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("startDate"))) {
                jSprint.setStartDate(sp.get("startDate").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("endDate"))) {
                jSprint.setEndDate(sp.get("endDate").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("completeDate"))) {
                jSprint.setCompleteDate(sp.get("completeDate").toString());
            }
            jSprint.applyCloseDate();
        }
        return jSprint;
    }

    public static JiraSprint parseStrForJsprint(LinkedHashMap<String, Object> sp) {
        JiraSprint jSprint = null;
        if (PropertyValidator.isValid((Object)sp.get("id"))) {
            jSprint = new JiraSprint();
            jSprint.setJiraId(((Double)sp.get("id")).intValue() + "");
            if (PropertyValidator.isValid((Object)sp.get("name"))) {
                jSprint.setName(sp.get("name").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("boardId"))) {
                jSprint.setOriginBoardId(sp.get("boardId").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("state"))) {
                jSprint.setState(sp.get("state").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("startDate"))) {
                jSprint.setStartDate(sp.get("startDate").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("endDate"))) {
                jSprint.setEndDate(sp.get("endDate").toString());
            }
            if (PropertyValidator.isValid((Object)sp.get("completeDate"))) {
                jSprint.setCompleteDate(sp.get("completeDate").toString());
            }
            jSprint.applyCloseDate();
        }
        return jSprint;
    }

    public static JiraSprint parseStrForJsprint(String sp) {
        JiraSprint jSprint = null;
        StringTokenizer st = new StringTokenizer(sp, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("id=");
            if (index > -1) {
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                String spId = token.substring(index + 3);
                jSprint.setJiraId(spId);
            }
            index = -1;
            index = token.indexOf("rapidViewId=");
            if (index > -1) {
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                String boardId = token.substring(index + 12);
                jSprint.setOriginBoardId(boardId);
            }
            index = -1;
            index = token.indexOf("state=");
            if (index > -1) {
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                if (token.indexOf("]") > -1) {
                    token = token.substring(0, token.indexOf("]"));
                }
                String state = token.substring(index + 6);
                jSprint.setState(state);
            }
            index = -1;
            index = token.indexOf("name=");
            if (index > -1) {
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                String name = token.substring(index + 4);
                jSprint.setName(name);
            }
            index = -1;
            index = token.indexOf("startDate=");
            if (index > -1) {
                String startDateStr;
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                if (PropertyValidator.isValid((Object)(startDateStr = token.replace("startDate=", "")))) {
                    jSprint.setStartDate(startDateStr);
                }
            }
            index = -1;
            index = token.indexOf("endDate=");
            if (index > -1) {
                String endDateStr;
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                if (PropertyValidator.isValid((Object)(endDateStr = token.replace("endDate=", "")))) {
                    jSprint.setEndDate(endDateStr);
                }
            }
            index = -1;
            index = token.indexOf("completeDate=");
            if (index > -1) {
                String completeDateStr;
                if (jSprint == null) {
                    jSprint = new JiraSprint();
                }
                if (PropertyValidator.isValid((Object)(completeDateStr = token.replace("completeDate=", "")))) {
                    jSprint.setCompleteDate(completeDateStr);
                }
            }
            if (jSprint == null) continue;
            jSprint.applyCloseDate();
        }
        return jSprint;
    }

    public static JiraIssueLinkType reverseJiraLinkDirection(JiraIssueLinkType linkToReverse) {
        JiraIssueLinkType resultantLink = new JiraIssueLinkType();
        if (PropertyValidator.isValid((Object)linkToReverse)) {
            resultantLink.setJiraId(linkToReverse.getJiraId());
            resultantLink.setSelf(linkToReverse.getSelf());
            resultantLink.setOutward(linkToReverse.getOutward());
            resultantLink.setInward(linkToReverse.getInward());
            if ("IN".equalsIgnoreCase(linkToReverse.getDirection())) {
                resultantLink.setDirection("OUT");
                resultantLink.setName(linkToReverse.getOutward());
            } else if ("OUT".equalsIgnoreCase(linkToReverse.getDirection())) {
                resultantLink.setDirection("IN");
                resultantLink.setName(linkToReverse.getInward());
            } else {
                return linkToReverse;
            }
        }
        return resultantLink;
    }

    public static void main(String[] args) {
        try {
            String access = "shakeel.tabassam+j@gmail.com:VYmw4ki4CxihDblHKgj647BC";
            for (int index = 0; index < 25; ++index) {
                String postBody = "{ \"update\": { \"summary\":  [{\"set\" : \"bingo update" + index + "\"}]}}";
                ClientHttpRequest request = JiraUtils.createRequest((URI)new URI("https://shaktest123.atlassian.net/rest/api/latest/issue/PMPO1-348"), (HttpMethod)HttpMethod.PUT);
                request.getBody().write(postBody.getBytes("UTF-8"));
                request.getHeaders().add("Authorization", "Basic " + new String(Base64.encode((byte[])access.getBytes())));
                request.getHeaders().add("Content-Type", "application/json");
                request.getHeaders().add("Accept", "application/json");
                ClientHttpResponse response = request.execute();
                if (response.getRawStatusCode() != 200 && response.getRawStatusCode() != 201) continue;
                System.out.println(response);
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOriginalUrl(String urlStr) throws Exception {
        String suffix = "/rest";
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = null;
        URL url = null;
        try {
            url = new URL(urlStr + suffix);
            con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            String location = con.getHeaderField("Location");
            LOGGER.debug("http connectoin redirect location :" + location);
            if (PropertyValidator.isValid((Object)location) && (location.startsWith("http://") || location.startsWith("https://"))) {
                String string = location.replaceAll(suffix, "");
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
        }
        finally {
            if (PropertyValidator.isValid(con)) {
                con = null;
            }
            if (PropertyValidator.isValid((Object)url)) {
                url = null;
            }
        }
        return urlStr;
    }

    public static boolean isEmptyJiraValue(ItemJiraFieldMap configFieldMap) {
        if (configFieldMap.getType().equals("JSONArray") && "[]".equals(configFieldMap.getValue())) {
            return true;
        }
        if (configFieldMap.getType().equals("JSONObject") && "{id:\"\"}".equals(configFieldMap.getValue())) {
            return true;
        }
        return !PropertyValidator.isValid((Object)configFieldMap.getValue());
    }

    public static boolean isDifferent(String sublist, String superList) {
        Gson gson = new Gson();
        HashSet<Object> superIds = new HashSet<Object>();
        List superObjects = (List)gson.fromJson(superList, List.class);
        for (Object object : superObjects) {
            superIds.add(((LinkedTreeMap)object).get((Object)"id"));
        }
        HashSet<Object> subIds = new HashSet<Object>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        for (Object object : subObjects) {
            subIds.add(((LinkedTreeMap)object).get((Object)"id"));
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    public static boolean isDifferent(String sublist, List superObjects) {
        Gson gson = new Gson();
        HashSet superIds = new HashSet();
        for (Object object : superObjects) {
            superIds.add(((Map)object).get("id"));
        }
        HashSet<Object> subIds = new HashSet<Object>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        if (PropertyValidator.isValid((Collection)subObjects)) {
            for (Object object : subObjects) {
                subIds.add(((LinkedTreeMap)object).get((Object)"id"));
            }
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    public static boolean isDifferentObject(String object1, String object2) {
        try {
            JSONObject obj1 = new JSONObject(object1);
            JSONObject obj2 = new JSONObject(object2);
            return obj1.isNull("id") || obj2.isNull("id") || !obj1.get("id").equals(obj2.get("id"));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return true;
        }
    }

    public static boolean isDifferentObject(String object1, Map object2) {
        try {
            JSONObject obj1 = new JSONObject(object1);
            JSONObject obj2 = new JSONObject(object2);
            return obj1.isNull("id") || obj2.isNull("id") || !obj1.get("id").equals(obj2.get("id"));
        }
        catch (JSONException e) {
            LOGGER.error(StringUtils.getTraceString((Throwable)e));
            return true;
        }
    }

    public static boolean isDifferentArray(String sublist, String superList) {
        Gson gson = new Gson();
        HashSet<String> superIds = new HashSet<String>();
        List superObjects = (List)gson.fromJson(superList, List.class);
        for (Object object : superObjects) {
            superIds.add((String)object);
        }
        HashSet<String> subIds = new HashSet<String>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        for (Object object : subObjects) {
            subIds.add((String)object);
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    public static boolean isDifferentArray(String sublist, List superObjects) {
        Gson gson = new Gson();
        HashSet<String> superIds = new HashSet<String>();
        for (Object object : superObjects) {
            superIds.add((String)object);
        }
        HashSet<String> subIds = new HashSet<String>();
        List subObjects = (List)gson.fromJson(sublist, List.class);
        if (PropertyValidator.isValid((Collection)subObjects)) {
            for (Object object : subObjects) {
                subIds.add((String)object);
            }
        }
        return !PropertyValidator.isValid((Collection)Sets.difference(subIds, superIds));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Boolean checkValidTC(Boolean isReadOnly, Item childItem, Item parentItem, String jiraSprintId, ResyncParamsVO syncUtils, TeamContainerRepository teamContainerRepository, ItemRepository itemRepository, Double sequence, Boolean parentUpdated, List<String> logs) {
        boolean newSubItemMappingApplied = false;
        boolean itemMapped = false;
        if (syncUtils.syncMappersBySprintId == null) {
            return null;
        }
        List indexes = (List)syncUtils.syncMappersBySprintId.get(jiraSprintId);
        if (!PropertyValidator.isValid((Collection)indexes)) {
            return null;
        }
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            Integer index = (Integer)iterator.next();
            ItemSyncMapper itemSyncMapper = (ItemSyncMapper)syncUtils.syncMapper.get(index);
            boolean extraFieldMatched = false;
            boolean syncWithoutShared = false;
            if (PropertyValidator.isValid((Object)itemSyncMapper.getTeam()) && PropertyValidator.isValid((Collection)syncUtils.almConfigurations.getTeamMappings())) {
                Optional<BacklogMapping> teamMapping = syncUtils.almConfigurations.getTeamMappings().stream().filter(x -> x.getTeamId().equals(itemSyncMapper.getTeam().getId())).findFirst();
                if (!syncUtils.session.getJiraSharedSprintFieldEnabled().booleanValue() || !PropertyValidator.isValid((Collection)((BacklogMapping)teamMapping.get()).getJiraFieldMap())) {
                    if (syncUtils.session.getJiraSharedSprintFieldEnabled().booleanValue()) {
                        throw new KendisException("sharedSprint", itemSyncMapper.getTeam().getId() + "_" + childItem.getJiraKey());
                    }
                    if (logs != null) {
                        logs.add("3.2 No Jira Shared Sprint configured ");
                    }
                    extraFieldMatched = true;
                    syncWithoutShared = true;
                } else {
                    if (logs != null) {
                        logs.add("3.1 Jira Shared Sprint found ");
                    }
                    for (ItemJiraFieldMap configFieldMap : ((BacklogMapping)teamMapping.get()).getJiraFieldMap()) {
                        String configuredValues = configFieldMap.getValue();
                        Object itemFieldValue = null;
                        boolean empty = JiraUtils.isEmptyJiraValue((ItemJiraFieldMap)configFieldMap);
                        if (PropertyValidator.isValid((Object)childItem.getJiraFieldByKey())) {
                            itemFieldValue = childItem.getJiraFieldByKey().get(configFieldMap.getKey());
                            if (PropertyValidator.isValid(itemFieldValue)) {
                                if (logs != null) {
                                    logs.add("3.1.1 Jira Shared Sprint found field " + configFieldMap.getType());
                                }
                                if (empty) {
                                    throw new KendisException("sharedSprint", itemSyncMapper.getTeam().getId() + "_" + childItem.getJiraKey());
                                }
                                if (PropertyValidator.isValid((Object)configFieldMap.getJiraType()) && (configFieldMap.getJiraType().endsWith(":rm-teams-custom-field-team") || configFieldMap.getJiraType().endsWith(":atlassian-team"))) {
                                    itemFieldValue = ((Map)itemFieldValue).get("id");
                                }
                                if (logs != null) {
                                    logs.add("3.1.1.0 Jira Shared Sprint value " + itemFieldValue);
                                }
                                if (configFieldMap.getType().equals("Double") && String.valueOf(itemFieldValue).equals(configuredValues)) {
                                    if (logs != null) {
                                        logs.add("3.1.1.1 Jira Shared Sprint found field value ");
                                    }
                                    extraFieldMatched = true;
                                    break;
                                }
                                if (configFieldMap.getType().equals("JSONArray") && "labels".equals(configFieldMap.getJiraType()) && JiraUtils.isDifferentArray((String)configuredValues, (List)((List)itemFieldValue))) {
                                    if (logs != null) {
                                        logs.add("3.1.1.2 Jira Shared Sprint found field value ");
                                    }
                                    extraFieldMatched = true;
                                    break;
                                }
                                if (configFieldMap.getType().equals("JSONArray") && !"labels".equals(configFieldMap.getJiraType()) && JiraUtils.isDifferent((String)configuredValues, (List)((List)itemFieldValue))) {
                                    if (logs != null) {
                                        logs.add("3.1.1.3 Jira Shared Sprint found field value ");
                                    }
                                    extraFieldMatched = true;
                                    break;
                                }
                                if (configFieldMap.getType().equals("JSONObject") && !JiraUtils.isDifferentObject((String)configuredValues, (Map)((Map)itemFieldValue))) {
                                    if (logs != null) {
                                        logs.add("3.1.1.4 Jira Shared Sprint found field value ");
                                    }
                                    extraFieldMatched = true;
                                    break;
                                }
                                if (itemFieldValue.equals(configuredValues)) {
                                    if (logs != null) {
                                        logs.add("3.1.1.5 Jira Shared Sprint found field value ");
                                    }
                                    extraFieldMatched = true;
                                    break;
                                }
                                if (logs == null) break;
                                logs.add("3.1.1.6 Jira Shared Sprint found field value not found ");
                                break;
                            }
                            if (logs != null) {
                                logs.add("3.1.2 Jira Shared Sprint found not field ");
                            }
                            extraFieldMatched = false;
                        }
                        if (extraFieldMatched) continue;
                    }
                }
            }
            if (extraFieldMatched) {
                if (childItem.getTeamContainers() == null) {
                    childItem.setTeamContainers(new ArrayList());
                }
                if (logs != null) {
                    logs.add("3.3 Team Container check ");
                }
                if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                    if (logs != null) {
                        logs.add("3.3.1 Parent Team Container check ");
                    }
                    for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                        if (!PropertyValidator.isValid((Object)parentTeamContainer) || !parentTeamContainer.getTeam().equals((Object)itemSyncMapper.getTeam()) || !parentTeamContainer.getContainer().equals((Object)itemSyncMapper.getContainer())) continue;
                        childItem.getTeamContainers().add(parentTeamContainer);
                        itemMapped = true;
                        if (logs == null) break;
                        logs.add("3.3.2 Parent Team Container check found");
                        break;
                    }
                }
                if (!itemMapped) {
                    if (!Boolean.TRUE.equals(isReadOnly)) {
                        if (logs != null) {
                            logs.add("3.3.1 Child Team container added");
                        }
                        TeamContainer teamContainer = new TeamContainer();
                        teamContainer.setTeam(itemSyncMapper.getTeam());
                        teamContainer.setContainer(itemSyncMapper.getContainer());
                        if (!PropertyValidator.isValid((Object)teamContainer.getTenant()) && PropertyValidator.isValid((Object)syncUtils.almConfigurations) && PropertyValidator.isValid((Object)syncUtils.almConfigurations.getTenant())) {
                            teamContainer.setTenant(syncUtils.almConfigurations.getTenant());
                        }
                        if (sequence == null) {
                            teamContainer.setSequence(new Double(System.nanoTime() / 100000L));
                            teamContainer.setSource(1);
                        } else {
                            teamContainer.setSequence(Double.valueOf(sequence + 1000.0));
                            teamContainer.setSuspendActivity(true);
                        }
                        teamContainer = (TeamContainer)teamContainerRepository.save((Object)teamContainer);
                        childItem.setTeamContainers(new ArrayList());
                        childItem.getTeamContainers().add(teamContainer);
                        parentItem.getTeamContainers().add(teamContainer);
                        if (logs != null) {
                            logs.add("3.3.2 parent Team container added");
                        }
                        if (itemRepository != null) {
                            itemRepository.save((Object)parentItem);
                            parentUpdated = true;
                        }
                        newSubItemMappingApplied = true;
                    }
                } else {
                    newSubItemMappingApplied = true;
                }
                if (!syncWithoutShared) continue;
                if (logs == null) return newSubItemMappingApplied;
                logs.add("3.3.3 No shared sprint but mapping found");
                return newSubItemMappingApplied;
            }
            newSubItemMappingApplied = true;
        }
        return newSubItemMappingApplied;
    }

    public static boolean addjustChildTC(Boolean isReadOnly, Item childItem, Item parentItem, ResyncParamsVO syncUtils, List<TeamContainer> subItemExistingTCs, TeamContainerRepository teamContainerRepository, ItemRepository itemRepository, Double sequence, HashMap<String, Object> jiraIssueFields, String jiraSprintId, List<String> logs) {
        Boolean parentUpdated = false;
        Boolean newSubItemMappingApplied = false;
        boolean oldSubItemMappingFound = false;
        List tmpJsprints = (List)jiraIssueFields.get(jiraSprintId);
        if (PropertyValidator.isValid(subItemExistingTCs)) {
            childItem.setTeamContainers(new ArrayList());
            childItem.setContainer(subItemExistingTCs.get(0).getContainer());
            childItem.setTeam(subItemExistingTCs.get(0).getTeam());
            oldSubItemMappingFound = true;
        }
        if (PropertyValidator.isValid((Collection)tmpJsprints)) {
            if (logs != null) {
                logs.add("SPRINT_TO_CHANGE_IS_VALID");
            }
            childItem.setTeamContainers(new ArrayList());
            JiraSprint jiraSprint = null;
            JiraSprint activeJiraSprint = null;
            boolean activeFound = false;
            HashMap<String, Integer> closed = new HashMap<String, Integer>();
            for (int i = 0; i < tmpJsprints.size(); ++i) {
                Object sp = tmpJsprints.get(i);
                try {
                    jiraSprint = null;
                    if (sp instanceof String) {
                        jiraSprint = JiraUtils.parseStrForJsprint((String)((String)sp));
                    } else if (sp instanceof Map) {
                        jiraSprint = JiraUtils.parseStrForJsprint((Map)((Map)sp));
                    }
                    if (jiraSprint == null) continue;
                    if ("CLOSED".equalsIgnoreCase(jiraSprint.getState())) {
                        closed.put(jiraSprint.getId(), i);
                        continue;
                    }
                    activeFound = true;
                    activeJiraSprint = jiraSprint;
                    if (logs == null) continue;
                    logs.add("SETTING_NEW_SPRINT_AS_ACTIVE_SPRINT");
                    continue;
                }
                catch (Exception e) {
                    if (logs == null) continue;
                    logs.add("1.0.1 Jira Key : " + childItem.getJiraKey() + " could not parse sprint");
                }
            }
            if (activeFound) {
                jiraSprint = activeJiraSprint;
            } else if (closed.size() > 0 && closed.size() == tmpJsprints.size()) {
                jiraSprint = null;
                if (childItem != null && childItem.getStatus() != null && "Done".equals(childItem.getStatus().getCategory())) {
                    if (syncUtils.syncMappersBySprintId != null) {
                        Set sids = closed.keySet();
                        for (String sid : sids) {
                            Object sp;
                            if (syncUtils.syncMappersBySprintId.get(sid) == null) continue;
                            Integer i = (Integer)closed.get(sid);
                            activeJiraSprint = null;
                            if (i == null || (sp = tmpJsprints.get(i)) == null) continue;
                            if (sp instanceof String) {
                                activeJiraSprint = JiraUtils.parseStrForJsprint((String)((String)sp));
                            } else if (sp instanceof Map) {
                                activeJiraSprint = JiraUtils.parseStrForJsprint((Map)((Map)sp));
                            }
                            if (activeJiraSprint == null || jiraSprint != null && (activeJiraSprint.getClosedOn() == null || jiraSprint.getClosedOn() == null || jiraSprint.getClosedOn() >= activeJiraSprint.getClosedOn())) continue;
                            jiraSprint = activeJiraSprint;
                        }
                    } else if (oldSubItemMappingFound) {
                        // empty if block
                    }
                    oldSubItemMappingFound = false;
                    childItem.setTeamContainers(new ArrayList());
                }
            }
            if (jiraSprint != null) {
                if (logs != null) {
                    logs.add("2. Jira Sprint : " + jiraSprint.getId() + ", " + jiraSprint.getName());
                }
                JiraSprint jSprint = jiraSprint;
                if (!PropertyValidator.isValid((Object)childItem.getMapJiraFields())) {
                    childItem.setMapJiraFields(new HashMap());
                }
                if (logs != null) {
                    logs.add("SETTING_NEW_SPRINT_IN_CHILD_ITEM");
                }
                childItem.getMapJiraFields().put("sprint", jSprint);
                newSubItemMappingApplied = JiraUtils.checkValidTC((Boolean)isReadOnly, (Item)childItem, (Item)parentItem, (String)jSprint.getJiraId(), (ResyncParamsVO)syncUtils, (TeamContainerRepository)teamContainerRepository, (ItemRepository)itemRepository, (Double)sequence, (Boolean)parentUpdated, logs);
                if (newSubItemMappingApplied == null) {
                    if (logs != null) {
                        logs.add("3.4  jira sprint exist but not matched with any cell");
                    }
                    if (oldSubItemMappingFound) {
                        newSubItemMappingApplied = childItem.isNewMappingAppliedOnItem(subItemExistingTCs, syncUtils);
                    }
                }
            }
        } else {
            if (logs != null) {
                logs.add("3.5  jira Issue do not any sprint");
            }
            if (oldSubItemMappingFound) {
                newSubItemMappingApplied = childItem.isNewMappingAppliedOnItem(subItemExistingTCs, syncUtils);
            }
        }
        if (!Boolean.TRUE.equals(newSubItemMappingApplied)) {
            if (logs != null) {
                logs.add("3.6 newSubItemMappingApplied not");
            }
            if (oldSubItemMappingFound) {
                if (logs != null) {
                    logs.add("3.7 oldSubItemMappingFound");
                }
                boolean itemMapped = false;
                TeamContainer usTC = subItemExistingTCs.get(0);
                if (PropertyValidator.isValid((Collection)parentItem.getTeamContainers())) {
                    for (TeamContainer parentTeamContainer : parentItem.getTeamContainers()) {
                        if (!PropertyValidator.isValid((Object)parentTeamContainer) || !parentTeamContainer.getTeam().equals((Object)usTC.getTeam()) || !parentTeamContainer.getContainer().equals((Object)usTC.getContainer())) continue;
                        childItem.getTeamContainers().add(parentTeamContainer);
                        itemMapped = true;
                        break;
                    }
                }
                if (!itemMapped) {
                    if (logs != null) {
                        logs.add("3.7 itemMapped with oldSubItemMappingFound");
                    }
                    childItem.getTeamContainers().add(usTC);
                    parentItem.getTeamContainers().add(usTC);
                    if (itemRepository != null) {
                        itemRepository.save((Object)parentItem);
                        parentUpdated = true;
                    }
                }
            }
        }
        childItem.applySprintDates(syncUtils.session, null, null);
        return parentUpdated;
    }

    public static void saveLinks(Item savedItem, List<ItemLink> links, String syncId, String requestId) {
        ArrayList<String> targetJiraIds = new ArrayList<String>();
        HashMap<String, ItemLink> linkMapBySourceAndTargetId = new HashMap<String, ItemLink>();
        String linkType = "";
        for (ItemLink link : links) {
            linkType = link.getType();
            if (PropertyValidator.isValid((Object)link.getJiraDependency()) && PropertyValidator.isValid((Object)link.getJiraDependency().getTargetJiraIssue()) && PropertyValidator.isValid((Object)link.getJiraDependency().getTargetJiraIssue().getId())) {
                targetJiraIds.add(link.getJiraDependency().getTargetJiraIssue().getId());
                link.setJiraDependency(null);
            }
            if (link.getId() != null) continue;
            String sourceId = link.getSourceUserStoryId() != null ? link.getSourceUserStoryId() : link.getSourceItemId();
            String targetId = link.getTargetUserStoryId() != null ? link.getTargetUserStoryId() : link.getTargetItemId();
            linkMapBySourceAndTargetId.put(sourceId + "-" + targetId, link);
        }
        if (PropertyValidator.isValid(targetJiraIds) && targetJiraIds.size() >= 1 && PropertyValidator.isValid((Collection)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations()) && Boolean.TRUE.equals(((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getJiraDependencyEnabled())) {
            String[] typeArray = linkType.split("-");
            User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
            new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        }
    }

    public static List<ItemJiraDependency> removeLink(ItemLink linktodel, Item savedItem, boolean removeAlmLink) {
        List linkedAlmLinks = null;
        if (PropertyValidator.isValid((Object)linktodel.getAlmLinkId())) {
            HashMap linkedMap = almSyncServiceStatic.deleteKendisAndAlmLink((Object)linktodel, savedItem, linktodel.getTargetUserStoryId() != null ? linktodel.getTargetUserStoryId() : linktodel.getTargetItemId());
            if (PropertyValidator.isValid((Object)linkedMap) && PropertyValidator.isValid(linkedMap.get("jiraDependencies"))) {
                linkedAlmLinks = (List)linkedMap.get("jiraDependencies");
            }
            if (Boolean.TRUE.equals(removeAlmLink)) {
                User loggedInUser = UserContextUtil.getUserContext().getLoggedInUser();
                String almAccountId = ((AlmConfigurations)((SessionBoard)savedItem.getSessionBoards().get(0)).getSession().getAlmConfigurations().get(0)).getAlmAccount().getId();
                if (PropertyValidator.isValid((Collection)linkedAlmLinks)) {
                    String jiraIssueLinkId = ((ItemJiraDependency)linkedAlmLinks.get(0)).getJiraDependencyId();
                    new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
                }
            }
        }
        return linkedAlmLinks;
    }

    public static Map<String, Object> getJiraUser(HashMap<String, Object> json) {
        Map<String, Object> jiraUser = new HashMap<String, Object>();
        if (json != null && json.containsKey("userJson")) {
            Gson gson = new Gson();
            4 T = new /* Unavailable Anonymous Inner Class!! */;
            jiraUser = (Map)gson.fromJson((String)json.get("userJson"), T.getType());
        }
        return jiraUser;
    }

    public static ClientHttpResponse executeJiraServerAuth2Request(AlmAccount almAccount, String url, HttpMethod method, String body) throws URISyntaxException, IOException {
        JiraOauthToken jiraOauthToken = almAccount.getJiraOauthToken();
        if (PropertyValidator.isValid((Object)jiraOauthToken) && JiraUtils.isInvalidAuthToken((JiraOauthToken)jiraOauthToken) && PropertyValidator.isValid((Object)almAccount.getId())) {
            if (PropertyValidator.isValid((Object)(jiraOauthToken = JiraUtils.refreshJiraAuthToken((JiraOauthToken)jiraOauthToken, (String)almAccount.getId())))) {
                almAccount.setJiraOauthToken(jiraOauthToken);
                if (!almAccount.getAdminAlmAcc().booleanValue()) {
                    JiraUtils.updateJiraOauthInAlmAccUser((String)almAccount.getId(), (JiraOauthToken)jiraOauthToken, (String)almAccount.getOAuthTokenOwnerUserId());
                } else {
                    JiraUtils.updateJiraOauthInAlmAccount((JiraOauthToken)jiraOauthToken, (String)almAccount.getId());
                }
            } else {
                AlmError almError = new AlmError();
                almError.setAlmErrorMessage("Unable to refresh token. If the issue persists, please get a new OAuth token under Profile ALM Credentials tab.");
                almError.setHttpErrorCode(Integer.valueOf(500));
                throw new ViztrendJiraException(Integer.valueOf(401), "Unable to get refresh token.", almError);
            }
        }
        ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(url), (HttpMethod)method);
        if (PropertyValidator.isValid((Object)body)) {
            request.getBody().write(body.getBytes(StandardCharsets.UTF_8));
        }
        String authorization = "Bearer " + jiraOauthToken.getAccessToken();
        request.getHeaders().add("Authorization", authorization);
        request.getHeaders().add("Content-Type", "application/json");
        request.getHeaders().add("Accept", "application/json");
        LOGGER.debug("executeJira Server Auth2 " + method.name() + " Request: URL: " + url + "\n request by : " + authorization);
        return request.execute();
    }

    protected static ClientHttpResponse executeJiraCloudAuthRequest(AlmAccount almAccount, String URL2, HttpMethod method, String body) throws URISyntaxException, IOException {
        JiraOauthToken jiraOauthToken = almAccount.getJiraOauthToken();
        String cloudId = jiraOauthToken.getCloudId();
        if (PropertyValidator.isValid((Object)jiraOauthToken) && !JiraUtils.isValidCloudToken((JiraOauthToken)jiraOauthToken) && PropertyValidator.isValid((Object)almAccount.getId())) {
            if (PropertyValidator.isValid((Object)(jiraOauthToken = JiraUtils.refreshJiraAuthToken((JiraOauthToken)jiraOauthToken, (String)almAccount.getId())))) {
                if (almAccount.getIsTaggedUser().booleanValue()) {
                    JiraUtils.updateJiraOauthInAlmAccUser((String)almAccount.getId(), (JiraOauthToken)jiraOauthToken, null);
                } else {
                    JiraUtils.updateJiraOauthInAlmAccount((JiraOauthToken)jiraOauthToken, (String)almAccount.getId());
                }
            } else {
                AlmError almError = new AlmError();
                almError.setAlmErrorMessage("Unable to get refresh token.");
                almError.setHttpErrorCode(Integer.valueOf(500));
                throw new ViztrendJiraException(Integer.valueOf(401), "Unable to get refresh token.", almError);
            }
        }
        if (!PropertyValidator.isValid((Object)cloudId)) {
            cloudId = ALMSyncServiceImpl.getJiraAccessibleResource((AlmAccount)almAccount, (String)"id");
        }
        if (!PropertyValidator.isValid((Object)cloudId)) {
            throw new ViztrendJiraException(Integer.valueOf(401), "Unauthorized token - could not find cloud ID.");
        }
        String[] postUrl = URL2.split("/rest");
        String url = "https://api.atlassian.com/ex/jira/" + cloudId + "/rest" + postUrl[1];
        ClientHttpRequest request = JiraUtils.createRequest((URI)new URI(url), (HttpMethod)method);
        if (PropertyValidator.isValid((Object)body)) {
            request.getBody().write(body.getBytes(StandardCharsets.UTF_8));
        }
        request.getHeaders().add("Authorization", "Bearer " + jiraOauthToken.getAccessToken());
        request.getHeaders().add("Content-Type", "application/json");
        request.getHeaders().add("Accept", "application/json");
        LOGGER.debug("executeJira Cloud " + method.name() + " Request: URL: " + url);
        return request.execute();
    }

    public static JiraOauthToken refreshJiraAuthToken(JiraOauthToken jiraOauthToken, String almAccountId) {
        AlmAccount alm = almAccountRepo.findById(almAccountId);
        boolean isError = false;
        if (PropertyValidator.isValid((Object)alm.getJiraOauthToken()) && PropertyValidator.isValid((Object)alm.getClientId())) {
            boolean isCloud = alm.getJiraOauthToken().isCloud();
            try {
                HttpPost post;
                CloseableHttpClient httpclient = HttpClients.createMinimal();
                if (isCloud) {
                    String url = "https://auth.atlassian.com/oauth/token";
                    post = new HttpPost(url);
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("grant_type", (Object)"refresh_token");
                    jsonObj.put("client_id", (Object)alm.getClientId());
                    jsonObj.put("client_secret", (Object)alm.getSecretKey());
                    jsonObj.put("refresh_token", (Object)jiraOauthToken.getRefreshToken());
                    post.setHeader("Content-type", "application/json");
                    StringEntity entity = new StringEntity(jsonObj.toString());
                    post.setEntity((HttpEntity)entity);
                } else {
                    String url = alm.getUrl() + "/rest/oauth2/latest/token?client_id=" + alm.getClientId() + "&client_secret=" + alm.getSecretKey() + "&refresh_token=" + jiraOauthToken.getRefreshToken() + "&grant_type=" + "refresh_token" + "&redirect_uri=" + alm.getJiraAuthRedirectURL();
                    post = new HttpPost(url);
                    post.setHeader("Content-type", "application/x-www-form-urlencoded");
                }
                HttpResponse response = httpclient.execute((HttpUriRequest)post);
                String content = JiraUtils.convertStreamToString((InputStream)response.getEntity().getContent());
                JSONObject responseJson = new JSONObject(content);
                if (responseJson.has("error")) {
                    isError = true;
                    LOGGER.error(responseJson.getString("error"));
                    LOGGER.error(responseJson.getString("error_description"));
                } else if (responseJson.has("access_token")) {
                    String expiresAt = JiraUtils.getJiraTokenExpiry((String)responseJson.getString("expires_in"));
                    jiraOauthToken.setAccessToken(responseJson.getString("access_token"));
                    jiraOauthToken.setRefreshToken(responseJson.getString("refresh_token"));
                    jiraOauthToken.setExpiresAt(expiresAt);
                    jiraOauthToken.setScope(responseJson.getString("scope"));
                    if (!isCloud) {
                        jiraOauthToken.setServerAuthType(JiraOauthToken.ServerAuthType.AUTH_2_0);
                    }
                }
            }
            catch (Exception ex) {
                isError = true;
                LOGGER.error(StringUtils.getTraceString((Throwable)ex));
            }
        }
        return isError ? null : jiraOauthToken;
    }

    public static boolean isInCompleteJiraAuthToken(Map<String, String> jiraOauthTokenMap, String[] tokenAttributeNames) {
        boolean isInCompleteJiraAuthToken = false;
        for (String attributeName : tokenAttributeNames) {
            if (PropertyValidator.isValid((Object)jiraOauthTokenMap.get(attributeName))) continue;
            isInCompleteJiraAuthToken = true;
        }
        return isInCompleteJiraAuthToken;
    }

    public static boolean isInvalidAuthToken(JiraOauthToken jiraOauthToken) {
        LocalDateTime now;
        LocalDateTime tokenExpiresAt;
        boolean isInvalid = true;
        String expireAt = jiraOauthToken.getExpiresAt();
        if (PropertyValidator.isValid((Object)expireAt) && (tokenExpiresAt = LocalDateTime.parse((String)expireAt)).compareTo((ReadablePartial)(now = LocalDateTime.now())) > 0) {
            isInvalid = false;
        }
        return isInvalid;
    }

    public static boolean isValidCloudToken(JiraOauthToken jiraOauthToken) {
        LocalDateTime now;
        LocalDateTime tokenExpiresAt;
        Boolean isValid = false;
        String expireAt = jiraOauthToken.getExpiresAt();
        if (PropertyValidator.isValid((Object)expireAt) && (tokenExpiresAt = LocalDateTime.parse((String)expireAt)).compareTo((ReadablePartial)(now = LocalDateTime.now())) > 0) {
            isValid = true;
        }
        return isValid;
    }

    public static JiraOauthToken parseJiraAuthTokenMap(Map<String, String> jiraOauthTokenMap) {
        JiraOauthToken jiraOauthToken = new JiraOauthToken();
        jiraOauthToken.setAccessToken(jiraOauthTokenMap.get("accessToken"));
        jiraOauthToken.setRefreshToken(jiraOauthTokenMap.get("refreshToken"));
        jiraOauthToken.setExpiresAt(jiraOauthTokenMap.get("expiresAt"));
        jiraOauthToken.setScope(jiraOauthTokenMap.get("scope"));
        jiraOauthToken.setCloud(JiraUtils.getBooleanValue((Object)jiraOauthTokenMap.get("isCloud")));
        jiraOauthToken.setCloudId(jiraOauthTokenMap.get("cloudId"));
        if (!jiraOauthToken.isCloud()) {
            jiraOauthToken.setServerAuthType(JiraOauthToken.ServerAuthType.AUTH_2_0);
        }
        return jiraOauthToken;
    }

    public static boolean getBooleanValue(Object value) {
        boolean booleanValue = false;
        if (PropertyValidator.isValid((Object)value)) {
            if (value instanceof Boolean) {
                booleanValue = (Boolean)value;
            } else if (value instanceof String) {
                booleanValue = Boolean.parseBoolean((String)value);
            }
        }
        return booleanValue;
    }

    public static void updateJiraOauthInAlmAccount(JiraOauthToken jiraOauthToken, String almAccId) {
        AlmAccount almAccount = almAccountRepo.findById(almAccId);
        almAccount.setJiraOauthToken(jiraOauthToken);
        almAccountRepo.save((Object)almAccount);
    }

    public static void updateJiraOauthInAlmAccUser(String almAccountId, JiraOauthToken jiraOauthToken, String oAuthTokenOwnerUserId) {
        if (!PropertyValidator.isValid((Object)oAuthTokenOwnerUserId)) {
            throw new IllegalArgumentException("OAuth token owner user id cannot be null or empty");
        }
        LOGGER.info("[Update Jira OAuth Token In Profile] => oAuthTokenOwnerUserId provided, searching userId " + oAuthTokenOwnerUserId + " from DB to update token.");
        User user = (User)userRepe.findOne((Serializable)((Object)oAuthTokenOwnerUserId));
        if (PropertyValidator.isValid((Object)user)) {
            LOGGER.info("Updating token for currently logged in user: " + user.getUserName());
            AlmAccUser almAccUser = JiraUtils.getUserAlmCredntials((String)almAccountId, (User)user);
            if (PropertyValidator.isValid((Object)almAccUser)) {
                List almCredentials = user.getAlmCredentials().stream().map(almCred -> {
                    if (almCred.getAlmAccId().equals(almAccUser.getAlmAccId())) {
                        almCred.setJiraOauthToken(jiraOauthToken);
                    }
                    return almCred;
                }).collect(Collectors.toList());
                user.setAlmCredentials(almCredentials);
            }
            userRepe.save((Object)user);
        }
    }

    public static String convertStreamToString(InputStream is) {
        JiraUtils.is = is;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            return br.lines().collect(Collectors.joining());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getJiraTokenExpiry(String expiresIn) {
        java.time.LocalDateTime tokenExpiresAt = java.time.LocalDateTime.now().plus(Duration.of(Long.parseLong(expiresIn), ChronoUnit.SECONDS));
        return tokenExpiresAt.toString();
    }

    public static AlmAccUser getUserAlmCredntials(String almAccountId, User user) {
        if (PropertyValidator.isValid((Collection)(user = (User)userRepe.findOne((Serializable)((Object)user.getId()))).getAlmCredentials())) {
            for (AlmAccUser userCreds : user.getAlmCredentials()) {
                if (!almAccountId.equals(userCreds.getAlmAccId())) continue;
                return userCreds;
            }
        }
        return null;
    }

    public static String convertHtmlJiraMarkup(String html) throws IOException, InterruptedException {
        Document doc = Jsoup.parse((String)html);
        StringBuilder wiki = new StringBuilder();
        doc.body().traverse((NodeVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return wiki.toString().trim();
    }

    public static String decideSearchAPI(String endPoint, boolean isCloud, JSONObject body, int startAt) {
        if (!isCloud && endPoint.equals("/rest/api/3/search/jql")) {
            endPoint = "/rest/api/2/search";
            body.remove("nextPageToken");
            body.remove("fieldsByKeys");
            body.put("validateQuery", (Object)"false");
            if (startAt != -1) {
                body.put("startAt", startAt);
            }
            return endPoint;
        }
        return endPoint;
    }

    public String getIssuesByKeys(String keys, AlmAccount almAccount) {
        try {
            String jql = "issuekey in (" + keys + ")";
            String encodedJql = URLEncoder.encode(jql, "UTF-8");
            String endpoint = "/rest/api/3/search/jql";
            String params = "?jql=" + encodedJql + "&expand=changelog,names,schema,transitions,operations,editmeta,&fields=summary,status,issuetype";
            return JiraUtils.executeJiraGetRequest((String)endpoint, (String)almAccount.getUsername(), (String)almAccount.getPassword(), (AlmAccount)almAccount, (String)params, (Environment)env);
        }
        catch (Exception e) {
            LOGGER.error("Error fetching Jira issues by keys: {}", (Object)e.getMessage(), (Object)e);
            return "{\"issues\": []}";
        }
    }
}

